/*----------------------------------------------------------
   Appends a build level to WEASEL.EXE and SETUP.EXE.

           Author:       Peter Moylan
           Last revised: 20 October 2025
           2025-10-19 SHL Modified to use Glassman's lxedit
                          https://5nets.ru/eCS/lxedit-2-01-02.zip

   Usage:
           bldlvl ver

           where ver is the version string

------------------------------------------------------------*/

parse arg ver

if ver == '' then do
  say 'Version arg required (e.g. 3.09)'
  exit
end

projHost = "PJM3"
timestamp = LEFT(DATE() TIME(),25)LEFT(projHost,10)
signature0 = "@#Peter Moylan:"ver"#@##1## "timestamp"::EN:AU:::@@"

wdesc = signature0 || "Weasel mail server for OS/2 and eCS and ArcaOS"
wexe = 'weasel.exe'

call stream wexe, 'C', 'QUERY EXISTS'
if RESULT == '' then do
  say 'Cannot access' wexe
  exit
end

lxedit = 'lxedit.exe'

call SysSearchPath 'PATH', 'lxedit.exe'
if RESULT == '' then do
  say 'Cannot access' lxedit
  exit
end

say
lxedit '/v /d"DESCRIPTION' wdesc || '"' wexe

sdesc = signature0 || "Configuration program for Weasel mail server"
sexe = 'setup.exe'

call stream sexe, 'C', 'QUERY EXISTS'
if RESULT == '' then do
  say 'Cannot access' sexe
  exit
end

say
lxedit '/v /d"DESCRIPTION' sdesc || '"' sexe

say
bldlevel wexe

say
bldlevel sexe

exit
