IMPLEMENTATION MODULE RSAKeys;

        (********************************************************)
        (*                                                      *)
        (*              Defining the RSA key type               *)
        (*                                                      *)
        (*  Programmer:         P. Moylan                       *)
        (*  Last edited:        15 September 2023               *)
        (*  Status:             OK                              *)
        (*                                                      *)
        (*      In case you're wondering what RSA stands for,   *)
        (*      it's Rivest-Shamir-Adleman, after the           *)
        (*      inventors of the algorithm.                     *)
        (*                                                      *)
        (********************************************************)


FROM SYSTEM IMPORT CAST;
IMPORT BigNum;

(************************************************************************)

CONST
    nil = CAST (BigNum.BN, NIL);
    NilKey = RSAKeyType {nil, nil, nil, nil, nil, nil, nil, nil};

(************************************************************************)

PROCEDURE InitKey(): RSAKeyType;

    (* Returns a dummy key with no content. *)

    BEGIN
        RETURN NilKey;
    END InitKey;

(************************************************************************)

PROCEDURE IsNilKey (k: RSAKeyType): BOOLEAN;

    (* Returns TRUE iff k is a key with no contents.  *)

    BEGIN
        RETURN (k.n = nil) AND (k.public = nil) AND (k.private = nil)
                        AND (k.p = nil) AND (k.q = nil) AND (k.dp = nil)
                                      AND (k.dq = nil) AND (k.qinv = nil);
    END IsNilKey;

(************************************************************************)

PROCEDURE DiscardKey (VAR (*INOUT*) k: RSAKeyType);

    (* Discards the key data.  *)

    BEGIN
        BigNum.Discard (k.n);
        BigNum.Discard (k.public);
        BigNum.Discard (k.private);
        BigNum.Discard (k.p);
        BigNum.Discard (k.q);
        BigNum.Discard (k.dp);
        BigNum.Discard (k.dq);
        BigNum.Discard (k.qinv);
    END DiscardKey;

(************************************************************************)

END RSAKeys.

