(**************************************************************************)
(*                                                                        *)
(*  PMOS/2 software library                                               *)
(*  Copyright (C) 2024   Peter Moylan                                     *)
(*                                                                        *)
(*  This program is free software: you can redistribute it and/or modify  *)
(*  it under the terms of the GNU General Public License as published by  *)
(*  the Free Software Foundation, either version 3 of the License, or     *)
(*  (at your option) any later version.                                   *)
(*                                                                        *)
(*  This program is distributed in the hope that it will be useful,       *)
(*  but WITHOUT ANY WARRANTY; without even the implied warranty of        *)
(*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *)
(*  GNU General Public License for more details.                          *)
(*                                                                        *)
(*  You should have received a copy of the GNU General Public License     *)
(*  along with this program.  If not, see <http://www.gnu.org/licenses/>. *)
(*                                                                        *)
(*  To contact author:   http://www.pmoylan.org   peter@pmoylan.org       *)
(*                                                                        *)
(**************************************************************************)

IMPLEMENTATION MODULE Arith64BE;

        (********************************************************)
        (*                                                      *)
        (*         64-bit arithmetic, big-endian version        *)
        (*                                                      *)
        (*  Programmer:         P. Moylan                       *)
        (*  Started:            4 June 2024                     *)
        (*  Last edited:        4 June 2024                     *)
        (*  Status:             Working                         *)
        (*                                                      *)
        (********************************************************)

FROM Arith64 IMPORT CARD64LE, LongDiv64LE;

(************************************************************************)
(*                     BIGENDIAN TO/FROM LITTLEENDIAN                   *)
(************************************************************************)

PROCEDURE ToBE (val: CARD64LE): CARD64BE;

    (* Converts a CARD64LE value to a CARD64BE value. *)

    VAR result: CARD64BE;

    BEGIN
        result.low := val.low;
        result.high := val.high;
        RETURN result;
    END ToBE;

(************************************************************************)

PROCEDURE FromBE (val: CARD64BE): CARD64LE;

    (* Converts a CARD64BE value to a CARD64LE value. *)

    VAR result: CARD64LE;

    BEGIN
        result.low := val.low;
        result.high := val.high;
        RETURN result;
    END FromBE;

(************************************************************************)
(*                             DIVISION                                 *)
(************************************************************************)

PROCEDURE Div10BE (number: CARD64BE;  VAR (*OUT*) quotient: CARD64BE;
                                  VAR (*OUT*) remainder: CARDINAL);

    (* Divides number by 10, returns quotient and remainder. *)

    VAR Q: CARD64LE;

    BEGIN
        LongDiv64LE (FromBE(number), 10, Q, remainder);
        quotient := ToBE(Q);
    END Div10BE;

(************************************************************************)

END Arith64BE.

