(**************************************************************************)
(*                                                                        *)
(*  Storage allocation                                                    *)
(*  Copyright (C) 2025   Peter Moylan                                     *)
(*                                                                        *)
(*  This program is free software: you can redistribute it and/or modify  *)
(*  it under the terms of the GNU General Public License as published by  *)
(*  the Free Software Foundation, either version 3 of the License, or     *)
(*  (at your option) any later version.                                   *)
(*                                                                        *)
(*  This program is distributed in the hope that it will be useful,       *)
(*  but WITHOUT ANY WARRANTY; without even the implied warranty of        *)
(*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *)
(*  GNU General Public License for more details.                          *)
(*                                                                        *)
(*  You should have received a copy of the GNU General Public License     *)
(*  along with this program.  If not, see <http://www.gnu.org/licenses/>. *)
(*                                                                        *)
(*  To contact author:   http://www.pmoylan.org   peter@pmoylan.org       *)
(*                                                                        *)
(**************************************************************************)

IMPLEMENTATION MODULE Alloc;

        (********************************************************)
        (*                                                      *)
        (*     ALLOCATE, with an added out-of-memory check      *)
        (*                                                      *)
        (*  Programmer:         P. Moylan                       *)
        (*  Started:            14 October 2025                 *)
        (*  Last edited:        14 October 2025                 *)
        (*  Status:             Just started                    *)
        (*                                                      *)
        (********************************************************)


IMPORT Storage, SYSTEM, TransLog, Strings;

FROM MiscFuncs IMPORT AppendCard;

(**************************************************************************)

VAR logID: TransLog.TransactionLogID;

(**************************************************************************)

PROCEDURE ALLOCATE (VAR (*INOUT*) q: SYSTEM.ADDRESS;  size: CARDINAL);

    (* Like Storage.ALLOCATE, but with out-of-memory check. *)

    VAR message: ARRAY [0..63] OF CHAR;

    BEGIN
        Storage.ALLOCATE (q, size);
        IF q = NIL THEN
            message := "ERROR: out of memory, wanted ";
            AppendCard (size, message);
            Strings.Append (" bytes", message);
            TransLog.LogTransaction (logID, message);
            RETURN;
        END (*IF*);
   END ALLOCATE;

(**************************************************************************)

PROCEDURE DEALLOCATE (VAR (*INOUT*) q: SYSTEM.ADDRESS;  size: CARDINAL);

    (* Same as Storage.DEALLOCATE. *)

    BEGIN
        Storage.DEALLOCATE (q, size);
   END DEALLOCATE;

(**************************************************************************)

BEGIN
    logID := TransLog.CreateLogID ("Alloc  ");
END Alloc.

