/*
   New install script for WarpAMP

   (c) 1998 Software Developers Guild
*/

SIGNAL ON HALT NAME UserAbort

/* Load RexxUtil extensions */
IF RxFuncQuery("SysLoadFuncs") THEN DO
    SAY "loading RexxUtil extensions..."
    CALL RxFuncAdd "SysLoadFuncs","RexxUtil","SysLoadFuncs"
    IF result \= "0" THEN
      CALL FatalError 'Could not load "RexxUtil.dll".'

    CALL SysLoadFuncs
END


/* ------------------------------------------------------------ Main routine */
installdir = directory() /* this will be changed if copy or auto */
                         /* install selected */
CALL greeting

DO forever
  CALL mainmenu
  SELECT
    WHEN option = '1' THEN    /* Full automatic install */
      DO
        CALL filemv
        IF installdir <> '' THEN
          DO
            CALL iconcreate
            CALL configedit
            CALL done
          END
        ELSE
          NOP
      END
    WHEN option = '2' THEN    /* Copy the installation pack to install dir */
      CALL filemv
    WHEN option = '3' THEN    /* Create icons on the desktop */
      CALL iconcreate
    WHEN option = '4' THEN    /* Edit the config.sys to add path statements */
      CALL configedit
    WHEN option = '5' THEN    /* EXIT */
      CALL MenuExit
    OTHERWISE
      NOP
  END /* select */
END /* do */



/* ----------------------------------------------------------- Show greeting */
Greeting:
CALL SysCls
SAY ''
SAY ' Ŀ'
SAY '                                                                           '
SAY '                                 WarpAMP                                   '
SAY ' Ĵ'
SAY '           WarpAMP copyright (c) 1998 by Software Developers Guild         '
SAY '                              All Rights Reserved                          '
SAY '                                                                           '
SAY ' '
SAY
SAY '  Welcome to the installation of WarpAMP, the premier MP3 player for OS/2.'
SAY '  After you press return, you will be presented with a list of options for'
SAY '  installation.'
SAY
SAY '  If you wish to allow the install to proceed without intervention, select'
SAY '  option 1, if you wish to have a little more control over the installation'
SAY '  then you can select options 2-5.'
SAY
CALL DoPause 'Press any key to proceed to the main menu, or Ctrl-C to quit.'
RETURN


/* --------------------------------------------------------------- Main menu */
mainmenu:
CALL SysCls
SAY ''
SAY ' Ŀ'
SAY '                                                                           '
SAY '                                 WarpAMP                                   '
SAY ' Ĵ'
SAY '           WarpAMP copyright (c) 1998 by Software Developers Guild         '
SAY '                              All Rights Reserved                          '
SAY '                                                                           '
SAY ' '
SAY
SAY '  1.  Full Automatic Installation (this will copy the files, create icons,'
SAY '      and edit the config.sys).'
SAY
SAY '  2.  Copy the WarpAMP installation files to an installation directory.'
SAY
SAY '  3.  Create a folder and icons for WarpAMP.'
SAY
SAY '  4.  Edit the Config.sys to add a libpath and path so you can use WarpAMP'
SAY '      from the command line.'
SAY
SAY '  5.  Exit.'
SAY
rc=CHAROUT( ,'  Please enter your choice:  ')
option = SysGetKey('ECHO')
RETURN


/* ----------------------------------------------- Copy files to install dir */
filemv:
CALL SysCls
SAY ''
SAY ' Ŀ'
SAY '                                                                           '
SAY '                                 WarpAMP                                   '
SAY ' Ĵ'
SAY '           WarpAMP copyright (c) 1998 by Software Developers Guild         '
SAY '                              All Rights Reserved                          '
SAY '                                                                           '
SAY ' '
SAY ''
SAY '  Enter the drive and directory in which you wish to install WarpAMP'
SAY '  (a blank line will cancel the copy):'
SAY
installdir = STRIP(LINEIN())
IF installdir = "" THEN
  RETURN

installdir = STRIP(installdir, "T", "\")

/* Verify install dir */
CALL SysCls
SAY ''
SAY ' Ŀ'
SAY '                                                                           '
SAY '                                 WarpAMP                                   '
SAY ' Ĵ'
SAY '           WarpAMP copyright (c) 1998 by Software Developers Guild         '
SAY '                              All Rights Reserved                          '
SAY '                                                                           '
SAY ' '
SAY ''
SAY '  WarpAMP will be installed in "' || installdir ||'".'
SAY
CALL DoPause 'Press any key to proceed with installation, or Ctrl-C to quit.'

/* Verify if path exists and if not, create it */
IF installdir <> "." THEN
  DO
    CALL SysFileTree installdir, "srch", "D"
    IF srch.0 = 0 THEN DO
      rc = SysMkDir(installdir)
      IF rc <> 0 THEN
        CALL FatalError 'Could not create directory "' || installdir || '".'
  END
END

/* copy the WarpAMP installation to install directory */
IF installdir <> "." THEN DO
  '@copy file_id.diz "'  || installdir || '" >nul'
  '@copy wampfold.ico "' || installdir || '" >nul'
  '@copy genres.txt "'   || installdir || '" >nul'
  '@copy readme.txt "'   || installdir || '" >nul'
  '@copy Warpamp.dll "'  || installdir || '" >nul'
  '@copy install.cmd "'  || installdir || '" >nul'
  '@copy Warpamp.EXE "'  || installdir || '" >nul'
  '@copy Warpamp.INF "'  || installdir || '" >nul'
  '@copy Warpamp.dll "'  || installdir || '" >nul'
  '@copy PLC.EXE "'      || installdir || '" >nul'
END

IF installdir = "." THEN
  installdir = directory()

RETURN


/* ------------------------------------------- Create Objects on the desktop */
iconcreate:
CALL SysCls
SAY ''
SAY ' Ŀ'
SAY '                                                                           '
SAY '                                 WarpAMP                                   '
SAY ' Ĵ'
SAY '           WarpAMP copyright (c) 1998 by Software Developers Guild         '
SAY '                              All Rights Reserved                          '
SAY '                                                                           '
SAY ' '
SAY
SAY '  Preparing to create objects on the desktop for WarpAMP and to associate'
SAY '  files with the extensions MP3 and MPL with WarpAMP object. '
SAY
CALL DoPause 'Press any key to proceed, or Ctrl-C to quit.'

rc = SysCreateObject('WPFolder',,
                     'WarpAMP',,
                     '<WP_DESKTOP>',,
                     'OBJECTID=<WarpAMP_FOLDER>;',
                     ';ALWAYSSORT=NO;',
                     ';OPEN=ICON;',
                     ';ICONFILE=' || installdir || '\wampfold.ICO',,
                      'replace')
IF (rc <> 1) THEN
  CALL FatalError 'Could not create WarpAMP folder.'

rc = SysCreateObject('WPProgram',,
                     'WarpAMP',,
                     '<WarpAMP_FOLDER>',,
                     'EXENAME=' || installdir ||'\WarpAMP.EXE;',
                     ';OBJECTID=<WarpAMP>;',
                     ';ASSOCFILTER=*.MP2,*MP2,*.MP3,*MP3,*.MPL,*MPL;',
                     ';STARTUPDIR=' || installdir || ';',,
                     'replace')
IF (rc <> 1) THEN
  CALL FatalError 'Could not create object for WarpAMP.'

rc = SysCreateObject('WPProgram',,
                     'WarpAMP Manual',,
                     '<WarpAMP_FOLDER>',,
                     'EXENAME=VIEW.EXE;',
                     ';PARAMETERS="' || installdir || '\WarpAMP.INF";',,
                     'replace')
IF (rc <> 1) THEN
  CALL FatalError 'Could not create object for WarpAMP manual.'

rc = SysCreateObject('WPProgram',,
                     'SDG HomePage',,
                     '<WarpAMP_FOLDER>',,
                     'EXENAME=NETSCAPE.EXE;',
                     ';PARAMETERS=' || 'http://www.sdg.ml.org;',,
                     'replace');
IF (rc <> 1) THEN
  CALL FatalError 'Could not create object for SDG Homepage.'

RETURN


/* --------------------------------------------------------- Edit config.sys */
configedit:
PARSE UPPER VALUE VALUE( "PATH",, "OS2ENVIRONMENT" ) WITH "\OS2\SYSTEM" -2 bdrive +2
CALL SysCls
SAY ''
SAY ' Ŀ'
SAY '                                                                           '
SAY '                                 WarpAMP                                   '
SAY ' Ĵ'
SAY '           WarpAMP copyright (c) 1998 by Software Developers Guild         '
SAY '                              All Rights Reserved                          '
SAY '                                                                           '
SAY ' '
SAY
SAY '  Preparing to edit your config.sys to add the WarpAMP directory to the'
SAY '  LIBPATH and the PATH statements, which will allow WarpAMP to be run'
SAY '  from the command line without problems.'
SAY
SAY '  A copy of the config.sys will be placed in the installation directory and'
SAY '  a backup will also be named config.amp in the root directory of your boot'
SAY '  drive.'
SAY
SAY '  If you quit and wish to run WarpAMP from the command line, you will have'
SAY '  to edit config.sys manually.'
SAY
CALL DoPause 'Press any key to proceed, or Ctrl-C to quit.'

'@attrib -r -s -h ' || bdrive || '\config.sys >nul'
'@copy ' || bdrive || '\config.sys "' || installdir ||'" >nul'
'@copy ' || bdrive || '\config.sys ' || bdrive || '\config.amp >nul'
'@del '|| bdrive || '\config.sys >nul'

configsys=bdrive || '\config.amp'
newconfig=bdrive || '\config.sys'

rc = STREAM(configsys,'c','open read')
IF (rc \= 'READY:') THEN
  CALL FatalError 'Could not open "' || configsys || '" (rc=' || rc || ')'

rc = STREAM(newconfig,'c','open write')
IF (rc \= 'READY:') THEN
  CALL FatalError 'Could not open "' || newconfig || '" (rc=' || rc || ')'

DO WHILE LINES( configsys )
  configline=LINEIN( configsys )
  PARSE UPPER VAR configline editline
  PARSE UPPER VAR installdir cinstalldir
  IF LEFT( editline, 7) = 'LIBPATH' THEN
    DO
      IF POS( cinstalldir, editline ) = 0 THEN
        DO
          configline = STRIP(configline, "T", " ")
          configline = STRIP(configline, "T", ";")
          rc=LINEOUT( newconfig, configline || ';' || installdir || ';' )
        END
      ELSE
        rc=LINEOUT( newconfig, configline )
    END
  ELSE
    IF LEFT( editline, 8) = 'SET PATH' THEN
      DO
        IF POS( cinstalldir, editline ) = 0 THEN
          DO
            configline = STRIP(configline, "T", " ")
            configline = STRIP(configline, "T", ";")
            rc=LINEOUT( newconfig, configline || ';' || installdir || ';' )
          END
        ELSE
          rc=LINEOUT( newconfig, configline )
      END
    ELSE
      rc=LINEOUT( newconfig, configline )
END
rc=STREAM( configsys, 'c', 'close' )
rc=STREAM( newconfig, 'c', 'close' )

CALL CheckConfig
RETURN


/* -------------------------------------------------------------------- Done */
Done:
CALL SysCls
SAY ''
SAY ' Ŀ'
SAY '                                                                           '
SAY '                                 WarpAMP                                   '
SAY ' Ĵ'
SAY '           WarpAMP copyright (c) 1998 by Software Developers Guild         '
SAY '                              All Rights Reserved                          '
SAY '                                                                           '
SAY ' '
CALL CheckConfig
SAY
SAY '  Installation of WarpAMP is complete, if you chose to have your config.sys'
SAY '  updated, then you must reboot before you can run WarpAMP from a command'
SAY '  line.'
SAY
CALL DoPause 'Press any key to finish.'
EXIT


/* ---------------------------------------------------------- Exit from menu */
MenuExit:
CALL SysCls
SAY ''
SAY ' Ŀ'
SAY '                                                                           '
SAY '                                 WarpAMP                                   '
SAY ' Ĵ'
SAY '           WarpAMP copyright (c) 1998 by Software Developers Guild         '
SAY '                              All Rights Reserved                          '
SAY '                                                                           '
SAY ' '
SAY
SAY '  Have a nice day!'
SAY
EXIT


UserAbort:
  SAY
  SAY
  SAY '  *** WarpAMP installation aborted ***'
  CALL CheckConfig
  EXIT

FatalError:
  PARSE ARG msg
  SAY
  SAY ''
  SAY '  Error: ' || msg
  CALL CheckConfig
  EXIT

CheckConfig:
  PARSE UPPER VALUE VALUE( "PATH",, "OS2ENVIRONMENT" ) WITH "\OS2\SYSTEM" -2 bdrive +2
  cfgerror = 0
  IF (STREAM( bdrive || '\config.sys', 'c', 'Query Exists' ) = '' ) THEN
    cfgerror = 1
  ELSE
    IF (STREAM( bdrive || '\config.sys', 'c', 'Query Size' ) < 100 ) THEN
      cfgerror = 2

  IF (cfgerror > 0) THEN DO
    SAY
    SAY 'DO NOT REBOOT NOW!!!'
    SAY

    IF (cfgerror = 1) THEN
      SAY 'Something went very wrong, your config.sys is gone...'
    ELSE
      SAY 'Something went very wrong, your config.sys is very small...'

    SAY
    SAY 'There should be two backups of your config.sys file:'
    SAY ' 1) A config.amp file in the root directory of your boot drive.'
    SAY ' 2) A copy of your config.sys in the directory where you chose to install'
    SAY '    WarpAMP.'
    SAY
    SAY 'To restore your config.sys, locate one of the backups and copy it to'
    SAY 'config.sys in the root directory of your boot drive. Remeber, YOU MUST'
    SAY 'RESTORE IT BEFORE YOU REBOOT!!!'
    SAY
    CALL DoPause 'Press any key when you have read the above information.'
    EXIT
  END

RETURN

DoPause:
  PARSE ARG msg
  DO WHILE (CHARS() > 0)
    pk = SysGetKey('NOECHO')
  END
  rc = CHAROUT(,'  ' || msg);
  pk = SysGetKey('NOECHO')
  SAY

  RETURN
