/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class MainFrame
extends JFrame
implements ActionListener {
    private static final Dimension startDimension = new Dimension(800, 600);
    private JLabel saveLabel;
    private JTabbedPane tabbedPane;
    private JPopupMenu textPopup;
    private JMenu menuFile;
    private JMenu menuEdit;
    private JMenu tools;
    private JMenu help;
    private JMenu skin;
    private JMenuItem newDocument;
    private JMenuItem open;
    private JMenuItem save;
    private JMenuItem saveAs;
    private JMenuItem print;
    private JMenuItem close;
    private JMenuItem exit;
    private JMenuItem copy;
    private JMenuItem paste;
    private JMenuItem cut;
    private JMenuItem selectAll;
    private JMenuItem find;
    private JMenuItem format;
    private JMenuItem insertTime;
    private JMenuItem toPDF;
    private JMenuItem copyPopup;
    private JMenuItem pastePopup;
    private JMenuItem cutPopup;
    private JMenuItem selectAllPopup;
    private JMenuItem formatPopup;
    private JMenuItem license;
    private JMenuItem bug;
    private JMenuItem about;
    private JMenuBar menuBar;
    private JCheckBoxMenuItem classic;
    private JCheckBoxMenuItem system;
    private JCheckBoxMenuItem motif;
    private JCheckBoxMenuItem gtk;
    private JCheckBoxMenuItem windows;
    private JCheckBoxMenuItem nimbus;
    private JToolBar toolBar;
    private JButton buttonNew;
    private JButton buttonOpen;
    private JButton buttonCopy;
    private JButton buttonPaste;
    private JButton buttonCut;
    private JButton buttonPrint;
    private JButton buttonSave;
    private JButton buttonFind;
    private JButton buttonPDF;
    private int numNewDocument = 0;
    private ArrayList<TextEditorPane> documents = new ArrayList();

    public MainFrame() {
        this.setTitle("TextEditor++ 1.0");
        this.setDefaultCloseOperation(0);
        this.setSize(startDimension);
        this.createComponent();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int y = screenSize.height / 2 - this.getHeight() / 2;
        int x = screenSize.width / 2 - this.getWidth() / 2;
        this.setLocation(x, y);
    }

    private void createComponent() {
        this.menuBar = new JMenuBar();
        this.menuFile = new JMenu("File");
        this.newDocument = new JMenuItem("New");
        this.newDocument.addActionListener(this);
        this.open = new JMenuItem("Open");
        this.open.addActionListener(this);
        this.save = new JMenuItem("Save");
        this.save.addActionListener(this);
        this.saveAs = new JMenuItem("Save as...");
        this.saveAs.addActionListener(this);
        this.print = new JMenuItem("Print");
        this.print.addActionListener(this);
        this.close = new JMenuItem("Close");
        this.close.addActionListener(this);
        this.exit = new JMenuItem("Exit");
        this.exit.addActionListener(this);
        this.menuFile.add(this.newDocument);
        this.menuFile.add(this.open);
        this.menuFile.add(this.save);
        this.menuFile.add(this.saveAs);
        this.menuFile.add(this.print);
        this.menuFile.addSeparator();
        this.menuFile.add(this.close);
        this.menuFile.add(this.exit);
        this.menuFile.setMnemonic('F');
        this.menuEdit = new JMenu("Edit");
        this.copy = new JMenuItem("Copy");
        this.copy.addActionListener(this);
        this.paste = new JMenuItem("Paste");
        this.paste.addActionListener(this);
        this.cut = new JMenuItem("Cut");
        this.cut.addActionListener(this);
        this.selectAll = new JMenuItem("Select all");
        this.selectAll.addActionListener(this);
        this.find = new JMenuItem("Find/Replace");
        this.find.addActionListener(this);
        this.format = new JMenuItem("Format");
        this.format.addActionListener(this);
        this.insertTime = new JMenuItem("Insert Date & Time");
        this.insertTime.addActionListener(this);
        this.menuEdit.add(this.copy);
        this.menuEdit.add(this.paste);
        this.menuEdit.add(this.cut);
        this.menuEdit.add(this.selectAll);
        this.menuEdit.add(this.find);
        this.menuEdit.addSeparator();
        this.menuEdit.add(this.format);
        this.menuEdit.add(this.insertTime);
        this.menuEdit.setMnemonic('E');
        this.help = new JMenu("?");
        this.license = new JMenuItem("License");
        this.license.addActionListener(this);
        this.bug = new JMenuItem("Bug report and more info");
        this.bug.addActionListener(this);
        this.about = new JMenuItem("About");
        this.about.addActionListener(this);
        this.help.add(this.license);
        this.help.add(this.bug);
        this.help.addSeparator();
        this.help.add(this.about);
        this.help.setMnemonic('?');
        this.tools = new JMenu("Tools");
        this.tools.setMnemonic('T');
        this.skin = new JMenu("Skin");
        this.classic = new JCheckBoxMenuItem("Java Classic");
        this.classic.addActionListener(this);
        this.classic.setSelected(true);
        this.system = new JCheckBoxMenuItem("System");
        this.system.setSelected(false);
        this.system.addActionListener(this);
        this.motif = new JCheckBoxMenuItem("Motif");
        this.motif.setSelected(false);
        this.motif.addActionListener(this);
        this.gtk = new JCheckBoxMenuItem("Gtk");
        this.gtk.setSelected(false);
        this.gtk.addActionListener(this);
        this.windows = new JCheckBoxMenuItem("Windows");
        this.windows.setSelected(false);
        this.windows.addActionListener(this);
        this.nimbus = new JCheckBoxMenuItem("Nimbus");
        this.nimbus.setSelected(false);
        this.nimbus.addActionListener(this);
        this.tools.add(this.skin);
        this.skin.add(this.classic);
        this.skin.add(this.system);
        this.skin.add(this.motif);
        this.skin.add(this.gtk);
        this.skin.add(this.windows);
        this.skin.add(this.nimbus);
        this.tools.addSeparator();
        this.toPDF = new JMenuItem("Convert to PDF");
        this.toPDF.addActionListener(this);
        this.tools.add(this.toPDF);
        this.menuBar.add(this.menuFile);
        this.menuBar.add(this.menuEdit);
        this.menuBar.add(this.tools);
        this.menuBar.add(this.help);
        this.getContentPane().add((Component)this.menuBar, "North");
        this.textPopup = new JPopupMenu();
        this.copyPopup = new JMenuItem("Copy");
        this.copyPopup.addActionListener(this);
        this.pastePopup = new JMenuItem("Paste");
        this.pastePopup.addActionListener(this);
        this.cutPopup = new JMenuItem("Cut");
        this.cutPopup.addActionListener(this);
        this.selectAllPopup = new JMenuItem("Select all");
        this.selectAllPopup.addActionListener(this);
        this.formatPopup = new JMenuItem("Format");
        this.formatPopup.addActionListener(this);
        this.textPopup.add(this.copyPopup);
        this.textPopup.add(this.pastePopup);
        this.textPopup.add(this.cutPopup);
        this.textPopup.add(this.selectAllPopup);
        this.textPopup.add(this.formatPopup);
        this.saveLabel = new JLabel("Last Save: Modified: ");
        JPanel panel = new JPanel();
        panel.add(this.saveLabel);
        this.getContentPane().add((Component)panel, "South");
        this.toolBar = new JToolBar(0);
        this.toolBar.setFloatable(false);
        this.buttonNew = new JButton(new ImageIcon(this.getClass().getResource("images/new.png")));
        this.buttonNew.setToolTipText("New document");
        this.buttonNew.addActionListener(this);
        this.buttonOpen = new JButton(new ImageIcon(this.getClass().getResource("images/open.png")));
        this.buttonOpen.setToolTipText("Open a document");
        this.buttonOpen.addActionListener(this);
        this.buttonSave = new JButton(new ImageIcon(this.getClass().getResource("images/save.png")));
        this.buttonSave.setToolTipText("Save the document");
        this.buttonSave.addActionListener(this);
        this.buttonCopy = new JButton(new ImageIcon(this.getClass().getResource("images/copy.png")));
        this.buttonCopy.setToolTipText("Copy to clipboard");
        this.buttonCopy.addActionListener(this);
        this.buttonPaste = new JButton(new ImageIcon(this.getClass().getResource("images/paste.png")));
        this.buttonPaste.setToolTipText("Paste from clipboard");
        this.buttonPaste.addActionListener(this);
        this.buttonCut = new JButton(new ImageIcon(this.getClass().getResource("images/cut.jpg")));
        this.buttonCut.setToolTipText("Cut in clipboard");
        this.buttonCut.addActionListener(this);
        this.buttonFind = new JButton(new ImageIcon(this.getClass().getResource("images/find.jpg")));
        this.buttonFind.setToolTipText("Find a word");
        this.buttonFind.addActionListener(this);
        this.buttonPrint = new JButton(new ImageIcon(this.getClass().getResource("images/print.jpg")));
        this.buttonPrint.setToolTipText("Print the document");
        this.buttonPrint.addActionListener(this);
        this.buttonPDF = new JButton(new ImageIcon(this.getClass().getResource("images/pdf.png")));
        this.buttonPDF.setToolTipText("Convert to PDF");
        this.buttonPDF.addActionListener(this);
        this.toolBar.add(this.buttonNew);
        this.toolBar.add(this.buttonOpen);
        this.toolBar.add(this.buttonSave);
        this.toolBar.addSeparator();
        this.toolBar.add(this.buttonCopy);
        this.toolBar.add(this.buttonPaste);
        this.toolBar.add(this.buttonCut);
        this.toolBar.add(this.buttonFind);
        this.toolBar.add(this.buttonPrint);
        this.toolBar.addSeparator();
        this.toolBar.add(this.buttonPDF);
        JPanel centralPanel = new JPanel(new BorderLayout());
        this.tabbedPane = new JTabbedPane(1);
        this.tabbedPane.addChangeListener(new TabListener());
        centralPanel.add((Component)this.toolBar, "North");
        centralPanel.add((Component)this.tabbedPane, "Center");
        this.add((Component)centralPanel, "Center");
    }

    public void save_click() {
        if (!this.documents.get(this.tabbedPane.getSelectedIndex()).isAlreadySaved() && this.documents.get(this.tabbedPane.getSelectedIndex()).getPaneName().startsWith("New Document")) {
            this.saveAs.doClick();
        } else {
            boolean flag = this.documents.get(this.tabbedPane.getSelectedIndex()).saveToFile();
            this.saveLabel.setText("Last Save: " + this.documents.get(this.tabbedPane.getSelectedIndex()).getLastSave() + " Modified: No");
            if (!flag) {
                JOptionPane.showMessageDialog(this, "Ci \u00e8 stato un errore durante il salvataggio di " + this.documents.get(this.tabbedPane.getSelectedIndex()).getPaneName(), "Error", 0);
            }
        }
    }

    public void print_click() {
        int n = JOptionPane.showOptionDialog(this, "Are you sure to print " + this.documents.get(this.tabbedPane.getSelectedIndex()).getPaneName() + "?", "Print", 0, 3, null, null, null);
        if (n == 0) {
            this.documents.get(this.tabbedPane.getSelectedIndex()).printPane();
        }
    }

    public void close_click() {
        if (this.documents.size() > 0) {
            if (this.documents.get(this.tabbedPane.getSelectedIndex()).isModified()) {
                int result = JOptionPane.showOptionDialog(this, "Are you sure to close " + this.documents.get(this.tabbedPane.getSelectedIndex()).getPaneName() + " without saving?", "Exit", 1, 3, null, new String[]{"Save", "Don't Save", "Cancel"}, null);
                if (result == 2) {
                    return;
                }
                if (result == 0) {
                    this.save.doClick();
                }
            }
            this.documents.remove(this.tabbedPane.getSelectedIndex());
            this.tabbedPane.remove(this.tabbedPane.getSelectedIndex());
        } else {
            System.exit(0);
        }
    }

    public void about_click() {
        new AboutDialog();
    }

    private void changeSkin() {
        try {
            if (this.classic.isSelected()) {
                UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
            } else if (this.system.isSelected()) {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            } else if (this.motif.isSelected()) {
                UIManager.setLookAndFeel("com.sun.java.swing.plaf.motif.MotifLookAndFeel");
            } else if (this.gtk.isSelected()) {
                UIManager.setLookAndFeel("com.sun.java.swing.plaf.gtk.GTKLookAndFeel");
            } else if (this.windows.isSelected()) {
                UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
            } else if (this.nimbus.isSelected()) {
                UIManager.setLookAndFeel("com.sun.java.swing.plaf.nimbus.NimbusLookAndFeel");
            }
            this.tabbedPane.updateUI();
            this.menuBar.updateUI();
            this.toolBar.updateUI();
            this.buttonNew.updateUI();
            this.buttonOpen.updateUI();
            this.buttonCopy.updateUI();
            this.buttonPaste.updateUI();
            this.buttonCut.updateUI();
            this.buttonSave.updateUI();
            this.buttonPrint.updateUI();
            this.buttonFind.updateUI();
            this.buttonPDF.updateUI();
            this.saveLabel.updateUI();
            this.newDocument.updateUI();
            this.open.updateUI();
            this.save.updateUI();
            this.saveAs.updateUI();
            this.print.updateUI();
            this.close.updateUI();
            this.exit.updateUI();
            this.format.updateUI();
            this.copy.updateUI();
            this.paste.updateUI();
            this.cut.updateUI();
            this.selectAll.updateUI();
            this.insertTime.updateUI();
            this.find.updateUI();
            this.skin.updateUI();
            this.toPDF.updateUI();
            this.about.updateUI();
            this.bug.updateUI();
            this.license.updateUI();
            this.classic.updateUI();
            this.windows.updateUI();
            this.gtk.updateUI();
            this.nimbus.updateUI();
            this.motif.updateUI();
            this.system.updateUI();
            this.copyPopup.updateUI();
            this.pastePopup.updateUI();
            this.cutPopup.updateUI();
            this.formatPopup.updateUI();
            this.selectAllPopup.updateUI();
            int i = 0;
            while (i < this.documents.size()) {
                this.documents.get(i).updateUI();
                ++i;
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Skin changing failed!", "Error", 0);
        }
    }

    public void insertNewDocument() {
        TextEditorPane document = new TextEditorPane();
        document.setAlreadySaved(false);
        document.setPaneName("New Document" + this.getNewDocumentAppend() + ".txt");
        document.setMouseListener(new PopupListener());
        this.documents.add(document);
        JScrollPane scrollPane = new JScrollPane(document);
        this.tabbedPane.add(document.getPaneName(), scrollPane);
        ++this.numNewDocument;
    }

    public void openDocument() {
        TxtFileChooser fileChooser = new TxtFileChooser(String.valueOf(System.getProperty("user.home")) + System.getProperty("file.separator") + "Documenti");
        fileChooser.setMultiSelectionEnabled(true);
        int result = fileChooser.showOpenDialog(this);
        if (result == 0) {
            File[] files = fileChooser.getSelectedFiles();
            int i = 0;
            while (i < files.length) {
                this.addDocument(files[i]);
                if (this.documents.size() > 0) {
                    this.tabbedPane.setSelectedIndex(this.tabbedPane.getComponentCount() - 1);
                    this.saveLabel.setText("Last Save: " + this.documents.get(this.tabbedPane.getSelectedIndex()).getLastSave() + " Modified: No");
                }
                ++i;
            }
        }
    }

    public void addDocument(File file) {
        if (!file.exists()) {
            JOptionPane.showMessageDialog(this, String.valueOf(file.getName()) + " doesn't exists", "Error", 0);
            return;
        }
        TextEditorPane textPane = null;
        String fileText = null;
        if (file.getName().toUpperCase().endsWith(".FTF")) {
            textPane = this.readFTFFile(file);
            textPane.setCaretPosition(0);
        } else {
            textPane = new TextEditorPane();
            textPane.setAlreadySaved(true);
            fileText = this.readTxtFile(file);
            if (fileText != null) {
                textPane.setText(fileText);
                textPane.setCaretPosition(0);
                textPane.setPanePath(file.getAbsolutePath());
                textPane.setMouseListener(new PopupListener());
            }
        }
        if (textPane != null || fileText != null) {
            JScrollPane scrollPane = new JScrollPane(textPane);
            this.tabbedPane.add(file.getName(), scrollPane);
            this.documents.add(textPane);
        } else {
            JOptionPane.showMessageDialog(null, "Error in the loading of " + file.getName(), "Error", 0);
        }
    }

    private TextEditorPane readFTFFile(File file) {
        try {
            FileInputStream inFileStream = new FileInputStream(file);
            ObjectInputStream inObjectStream = new ObjectInputStream(inFileStream);
            TextEditorPane textPane = (TextEditorPane)inObjectStream.readObject();
            inObjectStream.close();
            if (textPane != null) {
                textPane.setKeyListener();
                textPane.setMouseListener(new PopupListener());
            }
            return textPane;
        }
        catch (FileNotFoundException e) {
            return null;
        }
        catch (IOException e) {
            return null;
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    private String readTxtFile(File file) {
        try {
            FileReader fileReader = new FileReader(file);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            String result = "";
            String inputLine = bufferedReader.readLine();
            while (inputLine != null) {
                result = String.valueOf(result) + inputLine;
                inputLine = bufferedReader.readLine();
                if (inputLine == null) continue;
                result = String.valueOf(result) + "\n";
            }
            fileReader.close();
            bufferedReader.close();
            return result;
        }
        catch (FileNotFoundException e) {
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }

    private String getNewDocumentAppend() {
        if (this.numNewDocument == 0) {
            return "";
        }
        return " " + Integer.toString(this.numNewDocument);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source.equals(this.newDocument)) {
            this.insertNewDocument();
            this.tabbedPane.setSelectedIndex(this.tabbedPane.getComponentCount() - 1);
            this.saveLabel.setText("Last Save: " + this.documents.get(this.tabbedPane.getSelectedIndex()).getLastSave() + " Modified: No");
        } else if (source.equals(this.open)) {
            int oldsize = this.documents.size();
            this.openDocument();
            if (this.documents.size() > oldsize && this.documents.get(0).getPaneName().equalsIgnoreCase("New Document.txt") && !this.documents.get(0).isModified() && !this.documents.get(0).isAlreadySaved()) {
                --this.numNewDocument;
                this.tabbedPane.remove(0);
                this.documents.remove(0);
            }
            this.setTitle("TextEditor++ " + this.tabbedPane.getTitleAt(this.tabbedPane.getSelectedIndex()));
        } else if (source.equals(this.save) && this.documents.size() > 0) {
            this.save_click();
        } else if (source.equals(this.saveAs) && this.documents.size() > 0) {
            TxtFileChooser chooser = new TxtFileChooser(this.documents.get(this.tabbedPane.getSelectedIndex()).getPanePath());
            chooser.setMultiSelectionEnabled(false);
            chooser.setDialogTitle("Save " + this.tabbedPane.getTitleAt(this.tabbedPane.getSelectedIndex()));
            chooser.setSelectedFile(new File(this.tabbedPane.getTitleAt(this.tabbedPane.getSelectedIndex())));
            if (chooser.getSelectedFile().getName().toUpperCase().endsWith(".TXT")) {
                chooser.setFileFilter(chooser.getChoosableFileFilters()[1]);
            } else if (chooser.getSelectedFile().getName().toUpperCase().endsWith(".FTF")) {
                chooser.setFileFilter(chooser.getChoosableFileFilters()[2]);
            } else {
                chooser.setFileFilter(chooser.getChoosableFileFilters()[0]);
            }
            int result = chooser.showSaveDialog(this);
            if (result == 0) {
                File file = chooser.getSelectedFile();
                String path = file.getPath();
                String descriptor = "";
                descriptor = chooser.getFileFilter().getDescription().equalsIgnoreCase(chooser.getChoosableFileFilters()[2].getDescription()) ? "FTF" : (chooser.getFileFilter().getDescription().equalsIgnoreCase(chooser.getChoosableFileFilters()[1].getDescription()) ? "TXT" : (chooser.getFileFilter().getDescription().equalsIgnoreCase(chooser.getChoosableFileFilters()[3].getDescription()) ? "FTF&TXT" : null));
                if (descriptor != null && descriptor.equalsIgnoreCase("FTF") && !file.getName().toUpperCase().endsWith(".FTF")) {
                    path = String.valueOf(path) + ".ftf";
                } else if (descriptor != null && descriptor.equalsIgnoreCase("TXT") && !file.getName().toUpperCase().endsWith(".TXT")) {
                    path = String.valueOf(path) + ".txt";
                } else if (descriptor != null && descriptor.equalsIgnoreCase("FTF&TXT") && !file.getName().toUpperCase().endsWith(".FTF") && !file.getName().toUpperCase().endsWith(".TXT")) {
                    path = String.valueOf(path) + ".txt";
                }
                file = new File(path);
                int risp = 0;
                if (file.exists()) {
                    risp = JOptionPane.showOptionDialog(null, String.valueOf(file.getName()) + " already exists\nDo you want overwrite it?", "Overwrite", 0, 3, null, null, null);
                }
                if (risp == 0) {
                    this.documents.get(this.tabbedPane.getSelectedIndex()).setPanePath(file.getPath());
                    this.documents.get(this.tabbedPane.getSelectedIndex()).saveToFile();
                    this.saveLabel.setText("Last Save: " + this.documents.get(this.tabbedPane.getSelectedIndex()).getLastSave() + " Modified: No");
                    this.tabbedPane.setTitleAt(this.tabbedPane.getSelectedIndex(), file.getName());
                }
            }
        } else if (source.equals(this.close)) {
            this.close_click();
        } else if (source.equals(this.exit)) {
            if (this.documents.size() > 0) {
                int result = JOptionPane.showOptionDialog(this, "Are you sure to exit without saving?", "Exit", 1, 3, null, new String[]{"Save", "Don't Save", "Cancel"}, null);
                if (result == 0) {
                    int i = this.documents.size() - 1;
                    while (i >= 0) {
                        this.tabbedPane.setSelectedIndex(i);
                        this.save.doClick();
                        this.documents.remove(i);
                        this.tabbedPane.remove(i);
                        --i;
                    }
                    System.exit(0);
                } else if (result == 1) {
                    System.exit(0);
                }
            } else {
                System.exit(0);
            }
        } else if (source.equals(this.copy) && this.documents.size() > 0) {
            this.documents.get(this.tabbedPane.getSelectedIndex()).copy();
        } else if (source.equals(this.insertTime) && this.documents.size() > 0) {
            new TimeDialog(this.documents.get(this.tabbedPane.getSelectedIndex()));
        } else if (source.getClass().getName().endsWith("JCheckBoxMenuItem")) {
            JCheckBoxMenuItem[] checkbox = new JCheckBoxMenuItem[]{this.classic, this.system, this.motif, this.gtk, this.windows, this.nimbus};
            int i = 0;
            while (i < checkbox.length) {
                if (!checkbox[i].equals(source)) {
                    checkbox[i].setSelected(false);
                } else {
                    checkbox[i].setSelected(true);
                }
                ++i;
            }
            this.changeSkin();
        } else if (source.equals(this.toPDF) && this.documents.size() > 0) {
            String name;
            TextEditorPane textPane = this.documents.get(this.tabbedPane.getSelectedIndex());
            do {
                if ((name = (String)JOptionPane.showInputDialog(null, "Insert the name of PDF (without pdf extension)", textPane.getPaneName(), 3, null, null, textPane.getPaneName())) == null) {
                    return;
                }
                if (!name.equalsIgnoreCase("")) continue;
                JOptionPane.showMessageDialog(null, "You must insert a not empty name", "Error", 2);
            } while (name.equalsIgnoreCase(""));
            if (!name.toUpperCase().endsWith(".PDF")) {
                name = String.valueOf(name) + ".pdf";
            }
            PDFCreator.createPDF(textPane.getText(), textPane.getFont().getStyle(), textPane.getFont().getSize(), textPane.getForeground(), name);
        } else if (source.equals(this.bug)) {
            new BugDialog();
        } else if (source.equals(this.paste) && this.documents.size() > 0) {
            this.documents.get(this.tabbedPane.getSelectedIndex()).paste(true);
        } else if (source.equals(this.cut) && this.documents.size() > 0) {
            this.documents.get(this.tabbedPane.getSelectedIndex()).cut(true);
        } else if (source.equals(this.find) && this.documents.size() > 0) {
            new FindDialog(this.documents.get(this.tabbedPane.getSelectedIndex()));
        } else if (source.equals(this.selectAll) && this.documents.size() > 0) {
            this.documents.get(this.tabbedPane.getSelectedIndex()).selectAll();
        } else if (source.equals(this.format) && this.documents.size() > 0) {
            new FormatDialog(this.documents.get(this.tabbedPane.getSelectedIndex()));
        } else if (source.equals(this.print) && this.documents.size() > 0) {
            this.print_click();
        } else if (source.equals(this.license)) {
            new LicenseDialog();
        } else if (source.equals(this.about)) {
            this.about_click();
        } else if (source.equals(this.copyPopup)) {
            this.copy.doClick();
        } else if (source.equals(this.pastePopup)) {
            this.paste.doClick();
        } else if (source.equals(this.cutPopup)) {
            this.cut.doClick();
        } else if (source.equals(this.selectAllPopup)) {
            this.selectAll.doClick();
        } else if (source.equals(this.formatPopup)) {
            this.format.doClick();
        } else if (source.equals(this.buttonNew)) {
            this.newDocument.doClick();
        } else if (source.equals(this.buttonSave)) {
            this.save.doClick();
        } else if (source.equals(this.buttonOpen)) {
            this.open.doClick();
        } else if (source.equals(this.buttonCopy)) {
            this.copy.doClick();
        } else if (source.equals(this.buttonPaste)) {
            this.paste.doClick();
        } else if (source.equals(this.buttonCut)) {
            this.cut.doClick();
        } else if (source.equals(this.buttonFind)) {
            this.find.doClick();
        } else if (source.equals(this.buttonPrint)) {
            this.print.doClick();
        } else if (source.equals(this.buttonPDF)) {
            this.toPDF.doClick();
        }
    }

    class TabListener
    implements ChangeListener {
        TabListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            if (MainFrame.this.documents.size() > 0) {
                String mod = "";
                mod = ((TextEditorPane)MainFrame.this.documents.get(MainFrame.this.tabbedPane.getSelectedIndex())).isModified() ? "Yes" : "No";
                MainFrame.this.saveLabel.setText("Last Save: " + ((TextEditorPane)MainFrame.this.documents.get(MainFrame.this.tabbedPane.getSelectedIndex())).getLastSave() + " Modified: " + mod);
                MainFrame.this.setTitle("TextEditor++ " + ((TextEditorPane)MainFrame.this.documents.get(MainFrame.this.tabbedPane.getSelectedIndex())).getPaneName());
            } else {
                MainFrame.this.saveLabel.setText("");
            }
        }
    }

    class PopupListener
    extends MouseAdapter {
        PopupListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.isPopupTrigger()) {
                MainFrame.this.textPopup.show(e.getComponent(), e.getX(), e.getY());
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger()) {
                MainFrame.this.textPopup.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }
}

