/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class LicenseDialog
extends JDialog {
    private static final String LICENSE = "license/gpl.txt";
    private static final Dimension DIALOG_SIZE = new Dimension(500, 600);
    private JButton okButton;
    private JButton printButton;
    private JTextArea license;

    public LicenseDialog() {
        this.setTitle("License");
        this.setSize(DIALOG_SIZE);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int y = screenSize.height / 2 - this.getHeight() / 2;
        int x = screenSize.width / 2 - this.getWidth() / 2;
        this.setLocation(x, y);
        this.setModal(true);
        this.setResizable(false);
        this.setDefaultCloseOperation(2);
        this.createComponent();
        this.setVisible(true);
    }

    private void createComponent() {
        this.license = new JTextArea();
        this.license.setWrapStyleWord(true);
        this.license.setLineWrap(true);
        this.license.setEditable(false);
        String result = "";
        try {
            InputStream is = this.getClass().getResourceAsStream(LICENSE);
            InputStreamReader isr = new InputStreamReader(is);
            BufferedReader br = new BufferedReader(isr);
            String inputLine = br.readLine();
            while (inputLine != null) {
                result = String.valueOf(result) + inputLine + "\n";
                inputLine = br.readLine();
            }
            is.close();
            isr.close();
            br.close();
        }
        catch (IOException e) {
            result = "Errore durante la lettura del file";
        }
        this.license.setText(result);
        this.license.setCaretPosition(0);
        JScrollPane scroll = new JScrollPane(this.license);
        this.add((Component)scroll, "Center");
        this.okButton = new JButton("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LicenseDialog.this.dispose();
            }
        });
        this.printButton = new JButton("Print");
        this.printButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                block12: {
                    int risp = JOptionPane.showOptionDialog(null, "Are you sure to print the license?", "Print", 0, 3, null, null, null);
                    if (risp == 0) {
                        PrinterJob pj = PrinterJob.getPrinterJob();
                        pj.setJobName("License");
                        Paper foglio = new Paper();
                        PageFormat formato = pj.defaultPage();
                        formato.setPaper(foglio);
                        Book pages = new Book();
                        ArrayList<String> lines = this.getLines(LicenseDialog.this.license.getText());
                        int n = (int)(pj.defaultPage().getImageableHeight() - pj.defaultPage().getImageableY()) / LicenseDialog.this.license.getFont().getSize();
                        Vector<String> v = new Vector<String>();
                        int i = 0;
                        while (i < lines.size()) {
                            v.add(lines.get(i));
                            if (i % n == 0 && i != 0) {
                                pages.append(new Page(v, LicenseDialog.this.license), formato);
                                v = new Vector();
                            }
                            ++i;
                        }
                        pages.append(new Page(v, LicenseDialog.this.license), pj.defaultPage());
                        pj.setPageable(pages);
                        int copies = 1;
                        try {
                            if (!pj.printDialog()) break block12;
                            copies = pj.getCopies();
                            try {
                                if (copies == 1) {
                                    pj.print();
                                } else {
                                    int i2 = 1;
                                    while (i2 <= pj.getCopies()) {
                                        pj.setJobName("License" + String.valueOf(i2));
                                        pj.print();
                                        ++i2;
                                    }
                                }
                            }
                            catch (PrinterException e1) {
                                JOptionPane.showMessageDialog(null, "Error in the printing of the license", "Print Error", 0);
                            }
                        }
                        catch (Exception e1) {
                            try {
                                pj.print();
                            }
                            catch (PrinterException e2) {
                                JOptionPane.showMessageDialog(null, "Error in the printing of the license", "Print Error", 0);
                            }
                        }
                    }
                }
            }

            private ArrayList<String> getLines(String atext) {
                String text = String.valueOf(atext) + "\n";
                char[] letters = text.toCharArray();
                ArrayList<String> lines = new ArrayList<String>();
                String temp = "";
                int i = 0;
                while (i < letters.length) {
                    if (String.valueOf(letters[i]).hashCode() == 10) {
                        lines.add(temp);
                        temp = "";
                    } else {
                        temp = temp.concat(String.valueOf(letters[i]));
                    }
                    ++i;
                }
                return lines;
            }
        });
        JPanel panel = new JPanel(new GridLayout(1, 3));
        panel.add(this.printButton);
        panel.add(new JLabel());
        panel.add(this.okButton);
        this.add((Component)panel, "South");
    }
}

