/*
 * Decompiled with CFR 0.152.
 */
package it.kkorp.scopa.cpp;

import it.kkorp.scopa.cpp.Carta;
import it.kkorp.scopa.cpp.Prese;

public class Campo {
    private final int MAXCAMPO = 12;
    protected Carta[] terreno = new Carta[12];
    protected int interra = 0;

    public void copia(Campo sor) {
        for (int i = 0; i < sor.terreno.length; ++i) {
            Carta c = sor.terreno[i];
            Carta nc = new Carta();
            nc.copia(c);
            this.terreno[i] = nc;
        }
        this.interra = sor.interra;
    }

    public void poggia(Carta c) {
        if (this.interra >= 12) {
            return;
        }
        this.terreno[this.interra] = new Carta();
        this.terreno[this.interra].copia(c);
        ++this.interra;
    }

    public void rimuovi(Carta c) {
        int i;
        if (this.interra == 0) {
            return;
        }
        int ps = -1;
        for (i = 0; i < this.interra && ps == -1; ++i) {
            if (!this.terreno[i].equal(c)) continue;
            ps = i;
        }
        if (ps == -1) {
            return;
        }
        for (i = ps + 1; i < this.interra; ++i) {
            this.terreno[i - 1].copia(this.terreno[i]);
        }
        --this.interra;
    }

    public void rimuovi(Prese p) {
        for (int i = 0; i < p.dim(); ++i) {
            Carta pr = p.preleva(i);
            this.rimuovi(pr);
        }
    }

    public int combinazioni(Carta lanciata, Prese[] p, int n_comb) {
        boolean fatto = false;
        n_comb = 0;
        for (int i = 0; i < this.interra; ++i) {
            if (!this.terreno[i].equivalent(lanciata)) continue;
            if (p != null) {
                if (p[n_comb] == null) {
                    p[n_comb] = new Prese();
                }
                p[n_comb].aggiungi(this.terreno[i]);
            }
            ++n_comb;
            fatto = true;
        }
        if (fatto) {
            return n_comb;
        }
        int v = lanciata.getValore();
        if (p == null) {
            p = new Prese[10];
        }
        n_comb = this.search_comb(0, this.interra, v, p, n_comb);
        return n_comb;
    }

    protected int search_comb(int start, int end, int value, Prese[] p, int n_comb) {
        for (int i = start; i < end; ++i) {
            if (!this.terreno[i].less(value)) continue;
            if (p[n_comb] == null) {
                p[n_comb] = new Prese();
            }
            p[n_comb].aggiungi(this.terreno[i]);
            if (this.terreno[i].equivalent(value)) {
                p[++n_comb] = new Prese();
                p[n_comb].copia(p[n_comb - 1]);
                p[n_comb].discard();
                continue;
            }
            int v = this.terreno[i].getValore();
            n_comb = this.search_comb(i + 1, end, value - v, p, n_comb);
        }
        if (p[n_comb] != null) {
            p[n_comb].discard();
        }
        return n_comb;
    }

    public Carta leggi(int i) {
        if (i >= this.interra) {
            return null;
        }
        Carta c = new Carta();
        c.copia(this.terreno[i]);
        return c;
    }

    public void ripulisci() {
        this.interra = 0;
    }

    public int dim() {
        return this.interra;
    }
}

