/* This is file -RXSHELL.cmd used by RXSHELL.cmd to initialze its */
/* internal constants.  The obvious idea to store these constants */
/* directly in RXSHELL.cmd did not work on my system:             */

/* - access on source lines with sourceline() is untolerably slow */
/* - interpreting long lines with a REXX "interpret" instruction  */
/*   fails with OS/2 REXX (some obscure token length restriction) */
/* - if minor changes of RXSHELL.cmd require the download of 1 MB */
/*   unmodified constants RXSHELL fans would kill me              */
/* - all credits for 1025 zeta values to Simon Plouffe's famous   */
/*   "PI" (Plouffe's inverter).                                   */
/* - Please do not change the order of math.3 etc. at the end of  */
/*   this script:  RXSHELL.cmd stops to read constants as soon as */
/*   an input zeta(2*N+1) is 1 for the actual NUMERIC DIGITS, and */
/*   you have a problem if RXSHELL tries to determine any missing */
/*   value dynamically.  This could take centuries, and it's the  */
/*   reason why RXSHELL uses precomputed constants.               */
/* - If you rename RXSHELL.cmd to say RXSHELL.rex to be used with */
/*   REXX/Personal, then rename -RXSHELL.cmd -RXSHELL.rex         */
/* - The name -RXSHELL is obviously dubious, but works on old FAT */
/*   partitions and even under DOS.  If you use RXSHELL on a *NIX */
/*   system, use .RXSHELL and modify the source.                  */

math.GAMM = 0.577215664901532860606512090082402431042159335939923598805767234884867726777664670936947063291746749514631447249807082480960504014486542836224173997644923536253500333742937337737673942792595258247094916008735203948165670853233151776611528621199501507984793745085705740029921354786146694029604325421519058775535267331399254012967420513754139549111685102807984234877587205038431093997361372553060889331267600172479537836759271351577226102734929139407984301034177717780881549570661075010161916633401522789358679654972520362128792265559536696281763887927268013243101047650596370394739495763890657296792960100901512519595092224350140934987122824794974719564697631850667612906381105182419744486783638086174945516989279230187739107294578155431600500218284409605377243420328547836701517739439870030237033951832869000155819398804270741154222781971652301107356583396734871765049194181230004065469314299929777956930310050308630341856980323108369164002589297089098548682577736428825395492587362959613329857473930237343884707037028441292016641785024873337908056275
math.LN.2 = 0.693147180559945309417232121458176568075500134360255254120680009493393621969694715605863326996418687542001481020570685733685520235758130557032670751635075961930727570828371435190307038623891673471123350115364497955239120475172681574932065155524734139525882950453007095326366642654104239157814952043740430385500801944170641671518644712839968171784546957026271631064546150257207402481637773389638550695260668341137273873722928956493547025762652098859693201965058554764703306793654432547632744951250406069438147104689946506220167720424524529612687946546193165174681392672504103802546259656869144192871608293803172714367782654877566485085674077648451464439940461422603193096735402574446070308096085047486638523138181676751438667476647890881437141985494231519973548803751658612753529166100071053558249879414729509293113897155998205654392871700072180857610252368892132449713893203784393530887748259701715591070882368362758984258918535302436342143670611892367891923723146723217205340164925687274778234453534764811494186423867767744060695626573796008670762572
math.LN.1 = 2.71828182845904523536028747135266249775724709369995957496696762772407663035354759457138217852516642742746639193200305992181741359662904357290033429526059563073813232862794349076323382988075319525101901157383418793070215408914993488416750924476146066808226480016847741185374234544243710753907774499206955170276183860626133138458300075204493382656029760673711320070932870912744374704723069697720931014169283681902551510865746377211125238978442505695369677078544996996794686445490598793163688923009879312773617821542499922957635148220826989519366803318252886939849646510582093923982948879332036250944311730123819706841614039701983767932068328237646480429531180232878250981945581530175671736133206981125099618188159304169035159888851934580727386673858942287922849989208680582574927961048419844436346324496848756023362482704197862320900216099023530436994184914631409343173814364054625315209618369088870701676839642437814059271456354906130310720851038375051011574770417189861068739696552126715468895703503540212340784981933432106817012100562788023519303322
math.LN.0 = 1.83787706640934548356065947281123527972279494727556682563430308096553139185452079538948659727190839524401129324926867489273372576368158714431175183044536278720712148509471733809279181198276161126032646974618925474925103650338990895482019171870278396322319626114801069539077212991798446242791138554869994220056703919663898506278854129259137294882312495242609747363056899875868876466079702589530931456386347597570617137884627256430794616720529505853098298007871119999920741269437051440471524307006872475920543169750097227190768496265835824853999227536792803027895754591002020664176839367123881595143325254117505076497245186050590421609903624039361045196009176107714976706588822781361565555347544450762667651879014828040523867874263374089441371189156869826552081590826015367960940350517749618771749114464650668778489385596557499370542251617516233174875058017696896618350778815259190881989693579607832426181446570287357290751247594207086908526347557529234407222834527535937679132380540148826095822827999769257612178127235740915480900888592000137217806718
math.PI.0 = 0.886226925452758013649083741670572591398774728061193564106903894926455642295516090687475328369272332708113411812141285333118076432862211301262546854801393534231018849326552561424962586514475413114466047689633981400087319507675739860258350095092617009292723487247456320156960887762953108202709666250453199203806866738737576716833994894682925918204397725582580869380029533696715895666404927423124092451027327426097806625780823733757521369380528053998063553605030186022241836182648306854047161749415834212106922854804560210213892889034347383285002609152842562706698318472327090755358346941660971464678531134432612210271074974024960378243199437419252965320109107014642905616532489472601810574539481143694701622989099256567435633256253146630022328191054837513406248465297710230780380976108695762535103896379049527166450331111533807234830624094371534989417602530732221927092653986787128589592817979874979976131924621101944551983203223646986420672521501070282116716519630878067088168160008518827081738160334638270906417881245163452254242660067096217994865436
math.PI.1 = 3.14159265358979323846264338327950288419716939937510582097494459230781640628620899862803482534211706798214808651328230664709384460955058223172535940812848111745028410270193852110555964462294895493038196442881097566593344612847564823378678316527120190914564856692346034861045432664821339360726024914127372458700660631558817488152092096282925409171536436789259036001133053054882046652138414695194151160943305727036575959195309218611738193261179310511854807446237996274956735188575272489122793818301194912983367336244065664308602139494639522473719070217986094370277053921717629317675238467481846766940513200056812714526356082778577134275778960917363717872146844090122495343014654958537105079227968925892354201995611212902196086403441815981362977477130996051870721134999999837297804995105973173281609631859502445945534690830264252230825334468503526193118817101000313783875288658753320838142061717766914730359825349042875546873115956286388235378759375195778185778053217122680661300192787661119590921642019893809525720106548586327886593615338182796823030195
math.3    = 1.20205690315959428539973816151144999076498629234049888179227155534183820578631309018645587360933525814619915779526071941849199599867328321377639683720790016145394178294936006671919157552224249424396156390966410329115909578096551465127991840510571525598801543710978110203982753256678760352233698494166181105701471577863949973752378527793703095602570185318279000307654710756304884332086971157374238079344503160762531771453544441183117818224971852635709182448998796203508335756172022603393785870328131267807990054177348691152537065623705744096622171290262732073236149224291304052855537234103307757779806424202430488281521000914602653822069627155202082274335001015294801198690117625951676366998171835575234880703719555742347294083595208861666202572853755813079282586487282173705566196898952662018776810629200817792338135876828426412432431480282173674506720693507626895304345939375032966363775750624733239923482883107733905276802007579843567937115050900502736604711400853350343646722485653151811776618109222791910224883968002666065687051906275973877353574
math.5    = 1.03692775514336992633136548645703416805708091950191281197419267790380358978628148456004310655713333637962034146655660904280096177915597084183511072180087644866286337180353598363962365128888981335276775239827503202243684576644466595811599391797774503924464391966661596640162053252050215192267135125678597486928601974479843200672681297530919900774656558601526573730037561532683149897971935039837858131992288488642533510425160251084990434640294117243275763415081623322456186499271442722646141130075808683169164979181377696725145590158035309383622600202304558560981526553606265308838326130378691741225525605073750813917876046954186783666571223796259477937893134428055604651150585291073696433464289341433975231743713396243433114857310936262213535725304820787796571233233040429804527871329763977497246458997664932205731672600029827533605871320513045851116387291685820533714393169791188994651939674566243082288872700741116728692352416046032311169474962980805922699869648380167455551902896231467390483788516782903434218869450631859756091972999590437915763720
math.7    = 1.00834927738192282683979754984979675959986356056523870641728313657160147831735573534609696891385132396896145365149107488728677741984033544031579830103398456212106946358524390658335396467699756769669142780431433394749521537890280025904555197935310837008421073293990461070856412356058906225997760986947540763200004816329512586769250630734413632555601360305007373302413187037951026624779395465022546704201551040558222423925051086883772707742600217710001954557789898360467454061219526507654611613565486791500808585549476429868425539136775459376072804913873575097306696585811073319221509082180530272383509288509389401312842285256279674878106990927195319876834091656585887757288286293991355471548394645579926707688545512713057959711587058972241593629862839631008555356160891497368136046238604610692489433463033604950461784164365867638103061727056771514411677642120229066574325597142426626016538415890824424428599092540230164730720602056891943821539789214055604530729932435708154035336051611548773461812591324152885600100879168116255752780272658031305930415
math.9    = 1.00200839282608221441785276923241206048560585139488875654859661590978505339025839895039306912716958615740860476584706026142537397072243015306913249876425109092948687676545396979415407826022964154483625066862905670736452160153142442132633759881555805259145408489015395277474561334510287406132746606927633900162942708642201123162209241265753326205462293215454665179945038662778223564776166033028149236457039930111938398501716792600206492306979585094584579665485400269451187594815614303757761544433433983998514193835443874287618179634146695053924427473406909606894585996105461589736162668272802818811400557905771436620613381938718221562720925532612518009511262608663673143920144229683623491681832250614868970738786480974834510062608082183165341674072651564258871436009905467338168416173375070111195982714551000298536415263064755781009009031458293662123580777779513142944721448716934327746670465904148667631861891265226975795057157109160775056447088035879184909057111884185421412907293509668820549748286408736587509504863678708072212561025365604537741594
math.11   = 1.00049418860411946455870228252646993646860643575820861711914143610005405979821981470259184302356062983550607294814129860329979794004472448291452340594666101827864743680486809340363559802370626936931946760085394075876231621472810991507989405738788514513850619364669368985024077978028401244639896444047138478197119299613852973575977367246099677404198016669120204391916956191319060179639289541549789095007127526663656614465842497201232885762662179439935192225053382089955118320514329103446130085292868177747249372958239490759254848280350559533542125615135525321068258453012386694508411097701963544539299931034726252421142796409496146333207248232156368040313139123552191852678001722274000314060998347280972622792831952655553058167965642709630591768896393441579176982003768449176542193668310394000080971922751896260509614635522312761718751335639520565298853707831411741170624414139337904111814369114862573810967160603709866471902669946732043963721570584337746937545804596376633581838251644817340147383454493579767063171772955093912649035678072781847699111
math.13   = 1.00012271334757848914675183652635739571427510589550984513670267162089672682984420981289271395326813553902344840521179734064076485224380510939096729683929684996066771610573249629963829923832241270645534397908243398166611006072226482820829098611322006055919574798170105514560980917877805414224013190285001391962676914996314011069888817024039790203443280067385653208129153451676772441496562829429467748292391714206244780089073848414269889226664737755564722803627352500667467421430107203284172610080046639104001010610714066720775930530594390958149856243394485352083318403275389460651912543417271502821605459192948746239486899241846808496401925852714007396768033380116063335526501242179714199556417766679504169848363707680157664227867070649426352169965136076861423501274060702179256849092146939061871250152665330161452632169969977233435317213740659563428201718687298812577302782641078989758260296486164588017327125084231740187527233740140499533891005522938969732650532806091289356664455110033042552615868699393109770281508163884617380018045198680599330432
math.15   = 1.00003058823630702049355172851064506258762794870685817750656993289333226715634227957307233434701754849436696844424928325302977575887819043217944047700034332348332310742756487908423389159614985200731960289091129154799437770423351329528892987614029093651971202774281484478393862858576401560217170926244506255106707813961273962707293918686520124547118292434132210519145197303308151394364871492741346769997803264207405850437706141632690829109101557634435725518614739598061977480786101122106841937379529874597713846983618006628087504594900734865590356668330210531691853692421936427848505297476053493287360825218102676668790127008309538995011215575481165062972128581738701031740212262421540554846352666521502002813200012458762211797157455565189051421286903759820260584776358171966886117905328324053418574137653625706787760347860633995853642360059197440836656284170738277843223824997128343843599765195713611758535255609188962733308653465391928475319268876607046575066526201786073353120673208290381493435311058282930957978098004531436041967387888084983791156
math.17   = 1.00000763719763789976227360029356302921308824909026267909537984397293564329028245934208173863691667120960266159710110372601391961971597694682488687750381269409404895538941410178728305136626706952964898182943671017135027230948505793683977280922126659530767608827827089543820089607579931450793679883564443444869953466520841216626155122164790276065990036204758993230508914606209486856143495626482940361843790156961448267705547652173596343730496956285133820687392006647575299070060351118809487148198893301129956616635263852405395073444249192509852738217758384175641249136350684152632541165723274427871739369563912833185114393926910889227226218280783328771062520436493640277562901251877324760387951231671536329477304357702993171230372573312486003221782299175084925102200267475053510059269101472139496293257459786350491742149237275470471956963925522549362120127555375121717384586494818415930432502493637833026562144442996220406374077976409950631307053928123630080959322645113923997498768157429355083765619705063566962471226604800237820274462657800944045178
math.19   = 1.00000190821271655393892565695779510135325857114483863023593304676182394970534130931266422711807630270671648255966618456097585342453039807430808791661253945303731294219204836891165949553976248071922165903793556012396728953045609537304946699699074253320467806779824316343707017860924944934207469223240745945134177423256845801533383000053870413934944209756094421411172464429331139447579537287060224300420798830474755238200940699901562860116186597398952481469248923804319788041411315297782203860757059022872959594888150423472836593542855892069425734163902513793268868520150312584919405470060844779466812447284028197421788289684182713831850546185014679638768638114038251536706645213529017824263156480949460920437922582904346152751468807703679038356802570066405796352095598063746842070576915447585606935228858867009838189820505065890656738274915413270234729503466048445009835662740880297691114404903701884161347815399277614948080161356765497738469020942436855620508284735467975503826072183635566536190901971445642167732412851435338861012686557006255230032
math.21   = 1.00000047693298678780646311671960437304596644669478493760020748737659683908789815983387663856449725613266381211899380089748749729674239142554094170963850454110446555775097439531847838476586199984556849765411823474458558883059872219716844038230202095744412935728256974224101625190366767634572155772672890803948120000047503380626099030239851053360959958216416787173580846905389047928755417547868519650722582741077706005291156906084410883005063172391842624352401532191926314851397848969820906928114545415714789254879747142733936071523726912143155716797123652238964526177418632117001273813757162734019328186442641285893690297093737871246543992580787875218836413507938845340934122155173178195993908520686863838410185901501573028124163019832370151257755674111559661545945090193865267816744210889294463322014903472820759473954644312057754713355312190335848441918373336161634296455364560188328964552929392945148308442544859254995629478713651694729005032159776305821974560003786015424603044637021580539496101002664194494002194555408115470681535108667413928286
math.23   = 1.00000011921992596531107306778871888232638725499778451985860322579723624373042743512317431335223585983763945149600366863053831443772337083310550226047146143051413592223850853394341737927333405637847325136037386779153526791677094755722508969455084267688392923792817775337918538630367608567627464621600079477967188123471378712631714388864983511061457477579079782084366113408848671815731073587276477421532817221199292958732524117409542453200842836026158378292492352970167691510359169808569973616940489034626672987009708935720143833621973059650248825227835196400385764117297411752027914761161141594721624758036906857484132634367825394687544290167097419164685259789149101181878474143892203405676423061366794286962004951148396429678178628021613914827409198333187835505310582068382441256796863285369724634301557752006967160095377144016092119465508142468748120631855222859386479223646015573921823836858537719734815093095783499296800786366449081772307957550692324513494112121269458521152872894021258234231922368929312220829963947019025589552672438043654309692
math.25   = 1.00000002980350351465228018606370506936601184473091954331239868133901338446076746408206917156289620043378846094982287188620568186781966291932300910010651681302654526439685187828765686665783126158565050381460966182879795932329490941065021473065921713407855851542703916397966347669479378294719515840982675003401914147555772629209889204109758616966874463353959081906056759078778854622627924263057867185289712547137858649578268296613152048342188319822393899787098759644637333229214658463447481604500970928446298515012248274035878851098946968443732673346895088558495738106014707605043689791997121144347053793608191762308587964732190709980333395068860140598177609989429868596494670263420086443963588295902441300333491453829522141966923726287951508129691027468579112727246666997655510189772157177788847892593442734528491924635802429958369840768273125447125009545813067329836667631345083931870902626815792537818823827868641323776318327296588714165696981302662145409052840591423066816414508839164839087862851758980732335734588000873225405369629546280979706371
math.27   = 1.00000000745071178983542949198100417060411945471903188256582999323957835214760627157086790083710031352376493395183039482438632807963287170569286108893338587003424421846255968170525702971267035637555861027281333180183505502852252149472143404497226863912385557924202554077273865946359939320977466047945542501149998487836647053053063995960431677518416939464028983307102634547983900380730356402693223621532807088589845661720706616271858799428465547767060586739404315080443059569976855576790592352266189248403760189146592540140286251803257497843096162619912282172653581289061733290779308564513457258084132644209927815997615738114563929969868065140349970032487815858712996498561836855657418226810421478643915778763340910504610965658107727128969012192948006185458453354507962503458228372688715188845132618825831194236890097579928843656945095739254840004958724571723950355579920847254856511604853652974105281073865899794015531052697344906276656987215349138813242666686919392104147641444120949765214380898128309401237776745151826475521096593967290623408991920
math.29   = 1.00000000186265972351304900640390994541694806166533046920066577489380555809169326581787738147452100480717196733318418099673508724121255442697420794285026477111596734095292912549627887005080648409450263565350759466841659183729585191687837543483021004101449892701925187463409507145840473059195938884354044543941251115734825400166583267976650918005848577816122816210198316025334655414610112378170639583118626463674038580051725457472197377337195912398132415475715783564130473218286926516198179953014019424843865903115091552848774358132926322803597400584252469214727654396722369909070856532308780378807726308279572177096261503544498144716583980106451361550448859137378401107668995484979436817563526543399761771512141345546883315622416773418217210468838600474634454564188871715589459884758745917610005681588156254720899262754344492573004094699302628744215735046996117193662640562593242841468523896018627430506826186263801598999074978232571237093522342675229909194282343694683684983533168990333529389904375503235138285135322044735999739912822743042701260963
math.31   = 1.00000000046566290650337840729892332512200710626918533694730737297169337117566988980958264958219140667095094733928519909403818024401683047646393602101458401269222147875016160952782554305524335570540385991551120809099373051278590765038995801651815957483018695046346901269738907050651686068663926414585762489953983724265598314082518108880292619221673955840040727694022420642767669492454048561383386469274321427754612614071604716873598344881383291511847634269218824173901111582285020621960406975456532563792091171407764013398205897317879246000585701840173260429397755359627036593533784947008591347450068751839315485203575159365163002799512790169032037861895649749102177009101372739860695879533368234469746014805550367291617197217411952058170714552049532888947148674018526499400049667842489195748799185653978768859939567860526426300675157951442087405093178389958417907347862188069637956877584594886411519312298582808988225224729128636150210089146246976703164353220920305932161654470553818596726364928722126448690259167260418673301423950505495642064510440
math.33   = 1.00000000011641550172700519775929738354563095165224717276359325651773994702912462456754867393497437600881087091284577421382951336864765646110831278830569293948735967823326263031704665213818867091758113336959940124058028553659243069658533698938953640348668848254509050427429384623653444913761840604822979169343448999204422400878518685902247655996082293305235966806838095764277332311463642678179764859491769565457609127147408296585128225603544432363027281266080584657960770868037290884401546467848693519849582994320204984760508822254772316563338350185114219680457179951249329254417781300781240504053192249469624410274302467549234479989783452981697633497791255476603966006359334173401644635049733441227870473717939013543725611337247517614254800494605208849452221723986199533466364980510180764049429479252025168497836087771594828141240019208582602735948246182244265969841544090620406692514069220858007500477138394555831425115240322807577587594869879047076920158762775105841035424026195384210316590031676110449032911955758181403881260721974828870179144533
math.35   = 1.00000000002910385044497099686929425227884046410698198743303225621025482564048890140820433856911724428946203004508501377274799484714026521360076321815704232679973589113127488317337925670818628565076477349873941624493238273239119924513007196695471995477525004536948591684783496461720097770057991660807404648315164494480289675272863015018195688090788290608823157242646963674695000444368421903351004593079846347137773653461629647655862408717778925645582285600490411357683602112617411704526855435582433810000134667392455896796066168593038127017981727819488587034708929298261223492013244749741006204516599060064554766074055180078386269256538020090150425174231538314120439921379242488358680853563578776933238701680956209873885264980229408878856873675311305600330719265469965683173713688360920015878437038721524617815428886874442979412005849538800088105414864904128025131353186562048780561413222819232840071079367250192316090437965418108004780965535172461129754163439168725990717866120046746085041984976003480277131757544637319585296095952144096392751397376
math.37   = 1.00000000000727595983505748101452086901233805926485092555546610770579694263843837043933471011418379326234032663638703484386560852695256637917060470627391000045814717715271569214843152197430329745223172014570784347884675051700221685825222461499818190223020408923815683880754625671486697789947939876141505829222504720660417228641775193693431647737226721297914672361527029337938937180409220056173829065407179531782170718248702476608014100422401351080499722462139851671068141816069413150990234786063945340735860505417979393794956350520797376595816347239329213287589335719249084138613456794387971103767901595431628147180640829704052291427758563332006615046080281812328556528559454558429382056506411247196724217735139954502163413566043314354066669732204901024132440548458331562425269104935204771511326588822468070014700863130155069592817723714209776605687012979184099191724931912368920971276765158619615433175319199761911408945002499199525457448897113537591753137530005314550079373201777031905937428904699988264436048875778369564343441466242379524084779937
math.39   = 1.00000000000181898965030706594758483210073008503058930961866407053525125335650931615240714998016828968190529466850118711516196530495689212479438613057402783579636240478181830521878503401432184615243666317526824949709825718423860397739890681897986090284587474750660457851790839263459623527183865213792381728675944746600417227790726248205670853025460292206857654496360019879217662787903017000052669533013593222627217664302323200729396558658690393803847087789317466940657248222566335036375498425247212926957652354740425914040374217602256099312215387565209666821313781306116733525267721577951940444802197526799224223324828704354661874961973201046758842565395453777737076920888445089776747349634079609360207238560099290365832633478363362640818367016011789238922765387967744701454680738329860948929348256423952775469989983109415134971960763427890782467177176476305882708929485837934933129602971141562406955479967356695515206006598688017486369277880269587484583723112076232974097808648572379564790034251452290200403628873903725198199064928546488087556046687
math.41   = 1.00000000000045474737830421540267991120294885703390452991143862808123403590500260252686098892049313322445848356272884233074331136306076265803163875838399972458350789808926570983412028343302063905186534143349033204534562709676028310618548336754427041006997323205981903350064584894795718231284475456557867043290141695263460418126010228082605117628802579054314876749626481631479325762936669242431819587704426344194133224366477786726666096881865721322508583427776352961988251555363298234707523795826391439079573733419474067451445200328150824576146000188105689184008670062979298935172636172307244668599373470420557892085517834735332631773084452792866346091618035702953683231419663902601577515342254106654824277021361292043922968685447913828622260555918653984124439325001743455877948750833194743919555022205813987255260365426054612589421754057082428041575943186162234560066747144684109231761432009665592949616937439181842162653808129932728690662390136087100815969121260956884877365662055613179276520873000317424998806702114603222769482394619920253109732337
math.43   = 1.00000000000011368684076802278493491048380259064374359028425179989901227630935911208910851164971568769273284310714935221249146304249764577826191781892100104801750119952248281661886520633371868896441082715076654727465286252798791336160450807843989313883729726194715019181321163056284980553988411975492741479991503479659076674654593124011109109227861538521808083587626606394919836535955268440147522471166446702443951623055683656194165289373746070042342571368860926805785757259711006837073054224378462460588515518586699451651284988419069008287963516056808763835584921598880040505338545041471207475941275951515217658706094819317094522656812467056131371320544330044704995101040547351215295682796584721610800923929457689975944184197065992116563736580775988105776495927224172300672241013828963798880443009967214716712800950368914039462620680522346174619239858099883408918391151203582884943859685461997717980744752330762132532557274385374842874154055350376750278247501435888479073278090340813706532323819411648911771423671864861076680786323656471236200678428
math.45   = 1.00000000000002842170976889301855455073704942662074368826530983382762906278175669498283952988424022368026484474355547018899030148920667030926911024593164230534925031223377210757610381643677180833152806461021769099393579302536724342800830571185775433401360143456782094232505489755077862451663732153015661550484554477709806836677123298895558699221264882261061593694160910801351285530154018286562201601317867799729607626211733403788555949482319241664483531138938794138743989661826251569453658961456406949327398207983065233288972703679218511121163417725167715269420723857000252190377939133306979327266993686941370583235359201814748257024726461228368079587784788059031494175546245622563660103638442797470639724821388088832926797302607971647183609966960688790112914996977149693396164634038016518220125041662610696867013633902680864404609845272744615846839429877966357062667390711333584846531801799270660872360357923449999235400328584135886313145812568225618301150652736244367129488217182176626156220168667752686311112805705980945803233073631621320748469896
math.47   = 1.00000000000000710542739521085271287735447995680002274204359368768836382888775095377932135470299750400345139854657192126020629674958772171673259844584632297526402501244884885980323030985208807056426312701678031039524407331379727609465006932046918299210448389822301189349840199703821216416680029069473052617673411472561345741341504830426745641693827353609888137711021762463873933002100827995501546120782975115197586219656638528840436588549616391216420148559757996687163315338907400423841860656257546153000546930543147422817995882660528694384128957842260269125301615779497770439870944202110812515201747636501234894616551517001343852279521686898866359594027877092049763543384132854278859870549757962463311089049566380610289969944423286240621256725296694486959333508174498896160504498075987452254703588766052525146975867549683550175021892270363935960293554292258636064344662249247449974804417666335042492786106770771811102914763114334694513277407319683848502877276274292273622252813232814225825534474008496554804080847932131602402929844783829235984736240
math.49   = 1.00000000000000177635684357912032747334901440027957015550857532695197875924123327312105706630138163167985713853278184556788739608321873358514028052433079185457567463093267323535645659224245118631335462380644191700632787557346586531701363612843038845159603065982041383041528764288602165381236397218978983954350249831171175302882397824023700121146261698536959252754180338941976836074564715854927979259808826896489823779268160696220502425807709452464036020844537699114171751560551684212396886566183788801243006263074880180876237885381643079233403682090364712201658911119598618387994488823182996780472194651133710609109809010261435901455740405482230493379575114912554386220209635718175256874199959710363930324699655808832203718573952407644208183525473436987335213183277985873569102269138053460979119895127029129260896359039648235885994452073035797502178799399841569182134329460524021135945486434809372535774163833762950791241741217138935359811443731170910727516565657676295827894359355737143780235977237586262467481386015389812723726770087834868329623991
math.51   = 1.00000000000000044408921031438133641977709402681213364596030702441802859783115341484874514485333681139121400986580023282517422829835371281339953975150416654497529392009540335204215822828990719456657807056324608591071580530960592955983751862463964176572039337303003592779286771283672919555273895510980803114135994505226052174095582738467899655222167869818575521828746682089343820371900791143309132972826310384567650415321719902910023030749022062468598078199620624614776822811247006540038916529371449747955352983908457242767721119343380021398183744423995545092709851902851139086338835759040447394146081053529415969304580047307917243217834425248102679284542074477357753467603018934136805633957377839221658434053890223899640039373416835892694838637835575788237775670569177097994690036579091696568695476916985377411840175493914993840790922610061823549717378896112064778847615709540561403474800216605470525374746444205009028459332520775169726792292499940080203219921688501093708445067556623262403038625420150721587796688626595001546810195818520114325888129
math.53   = 1.00000000000000011102230251410661337205445699213827024832229004426259340923333088824701344793799573384328764667708388371262541343393211413511112875916987433694155175743625071326417886518061721073292823293155155959854620839998981116385897518899211098348169091264197351431125485229982574576329519198005965897687400011619333014413436112043097182505846203136262203196264614256393447463008895407258381056836291030578215716145750592883312022713143693723546003237114129049403954757988890822737958148067059621312192332437427805268191321063275567485332962255245024088082940224125234268386649388756114850164887939909082686768126130617959570620146797723621092053749651369760917678600237209632291626517077442669798750299095033761704894803816744776836124500011814439685415486410268627884926296084145252494863989887967439424305977828066984872606242978473728019724982975035804054690407705303566211446266374485905831571837094147445601091649848407533658231518001453645746780748445523048041179629961628989086312925281404728722760872426157785456077126981360696793759408
math.55   = 1.00000000000000002775557562136124172581632453854069768984890374369027218796336488341340489251596784097204755098229727196278437779475512703308153176865999374087409420243418575508969315791783108818655981601670860056674978172605704071376694086744076837237510415752720012053543183293836049510763757717470494800354315327150169964140321721307768889837027684829012939211522265642335568032278219358205786420012746830648596929336918109248005366073383894492888761870118487811565904131512742653227415690328084885867624636980941280523402120140171184301877248488760237562007251465274224117714398671693833624100042913532979680995734869177428582857674281249731101591820017093672618570143894748760212980437122055536934885399340868864261592506735708602034506784585999859138368060745510987204950554359524451853838201704903845133478589104438475886824317006763756318747761081105136938734664416802145492850880176074552483833243157962722407108830170180720474544182078435227445463170544643796866436110467733833884783426220906262335590799172056337379530897940963791323450344
math.57   = 1.00000000000000000693889390454415369744608532624980927483587417934713113365451618035724732805816046695380183917447081332034406806735798564843958593220454544724013659927950949323284383245435424561504243986132757722771453595761228099602732882805332247297746030792110226320290920659167979386788159466041944980140144687236020041645280561935277734055878464695672985214652582676383937340703481177277206355517665614190522210521051286850694301798264763773770686579782130203014546378642487925503365598576734102685042933928199566896053091488098808368414896371738911857978253401986327375942257400447189454069366163825470184751655769861952260083017245206971584003619304343957538220772548856899406340338030551664644628017829776714289087415114162795572776735340088696092594218037498939245858438070715694161394991305531172976181617954867719319698968438782410318725416005843517897368249306703804875815257156776761858774902350997648026400596409596914402503182724931967839615740478380259878521231100276392925615555866535396949289951267548565886212877185984397475169174
math.59   = 1.00000000000000000173472347604757657204897296993759590747805447890729663289024670563717349289716854593909643699182828273092172522117888394772977760949484135453543547566147109461344116067351129045326626307887140927646180317444867935076202316264165579429998750131706231567415317914327456293166742909489679964306544240346051880026767292582050781243612526416665219979181266788097733210350363847917846610782475963636720259197613545530784354230946718775958044687650714483833287013771962404249260515035084561243368388880745271779022366126979829830090207177867758482607510339263037647842028993453894201551730190438967879756360075765953166575146778126057409451210023393772339704961995840962622547280176057985387868485201363905937704109946118476905032881097172725255484727375805248510863052202133993894147017112003609989640234579103529211112618375748036916458984831454154661487527437850194695150094046053046222083198867620547871994008638768801944209639357688808450425424239430784753420716475764598907592559848263946309478864278090608505124271586590952034309723
math.61   = 1.00000000000000000043368086900206504874970235659062413612547801164858055992685963660708503064582857076833717948877659401572085325449656934462994904007634373080573223642565205070158669872976929685094569001527377579055624363833028207448736603174746933567773226540362131044234787779496509370001315679141671078299518080250983078857254199796915552457736082145352473410460219550029689448168701294325604318098281424716166594827387760107095029035409689951631514063027708463886324808112978763362051532526233395536157450618000102886003718532875215146985737561103291103323317755062786919954345137309773747277486498992265663263499956269261954766447015520191629237692384823157090229391866433077732473816064730565214224846989195739931851456115508208796617151671135942995596508971900688141210233423075075380075200865127379287510529027744249662526562670265084568465327691527070657142190549799482671562881608072057861421528872068150838312745655431690631372435801170191169761143769231752848634286565360815966639982258305839655210851606766432100672162718705771906914187
math.63   = 1.00000000000000000010842021724942414063012711165461382589364743780316545638704002074112214721978025372387985581540777611570164813871942959791748943637876525557180959416978347708839239799127282260323010119759160832565174488366047634617313660447137452819809381443209637607194687166234177575662871126742949388113079993991065905868265141185337026950409936833358989715642156711516355678464012734836118108507699068545689669913656389160512432467380434032580799840304480139829395149286607965432988759438085735527044841069247103786650638146279061729443994982888912416723040617193244790430350479002043062485446481165459967741496578445553923013756040401745522594494149003943474264897629170332779123372075875086013767362611117595934275868859692773793220473683350727958837567244198960315246590123192761090545405571188124838853818723944933524331048499878817054499367334247668174367110247402926817466261301748650607196782456360101396180604064891845991586966162189373200217566051938033167931036690490666765945108161224742483568841632743946138949427428766173736970658
math.65   = 1.00000000000000000002710505431223468831954621311949776431888728168050136559616419228148856384390891207031590122433573161121435856761535255587724979159768894625724605559403998486193613313880045778472315930522040493113936915141015197687456191086323988501834345724412727163261736936578551997246362999953225796750417026038869741122532372673278796108508458126513758736153068755219584932568779419750773343142204631103777043182131146792538309734566988751041263685011567713674209185163171966744561353543031389801636602616941731077485904617517803805622685739254990806170453546303201391095490782474370023635232558107385405507581879948690166574031560344107868847898675789662729704780533583780151026916790613037026814960180954803689036587646367095334146230844958317249304631020311312202117057687914770908266579801303405225182764811877137733310727531931651659281493073633004338346991604851874913556444846971945423109492717361681303087488764055389036457945722950744496121806142587740231169212875396746322379753150735445541584211917679328305795656801649202991454333
math.67   = 1.00000000000000000000677626357804518909799529874155668620598125857017956166828939502396913361632134006203107387187862076294858437749004255238383098597643122656375358818616720454250979486912111998391871842368133301375436642362559965464509817012991483001448359292155962713643706456151449685465187033543196073657708966557657055029114153289868654178252924954349097513830099659693551152652847007898518397732889813700364563971947389841070919557099014947831420846766130029718929701342859162377443943819344696410116175768558507552837661668765675782437227893979918724150001065007578790913938401443575615006468390648464134564386316609751682550208013409627986334658803618714405334033698214179176358763839627763998776968481174927513682329874470118028559508633641609874573805575662583204875764886182858002799109234099904895025881877924232293115543287461655143157947715442897208457876515735672143884873340201196914039775524631358131852858386187796858393714963521654423982845187343713056563472756000317765684117449864254817174252665148097108438693612197775151762189
math.69   = 1.00000000000000000000169406589450979916540649274712486194030364175552197180101786621381492114793619434232988861652980594362852181547100947445435844654386763408166516388080428111666494716190648498068035534120112977266395399446584405107717123750754393314743816117781284087037183774402759719810306394476390380248013115605435350437012053753472774102265565369673209790317086578222657795384123432620481094689745387493468453805046313933934520834136462610173967205071746452627984758280673257986563820039934571558443114051818602089483516425242767511072428194878099560849494184802720292459623414852665478872378688706553342898542702709026560124579157104206799071579070563376333757977170769097771960126273283588000611175560961075095689755554360580206864214612361900714236093936235526884668061099260099983598189303801736709698310728877373757399065957376132488391482408876403725465104108003656108968206812492024957305361291614549376696057137198471051136525774709628092772636444143682105800042853519966793864332939686580239891601563904021528699553126392465350289371
math.71   = 1.00000000000000000000042351647362728333478622704833579344088109716686581015467190772330637896333689604350013526414905229469609484334096722049015028785506795826844126072957170078204388212581883903186070952408879948114821144232398017468574928575564318546385980436518660338047812325349269754395798591282618315406864841999100451440558370820452234927106381449894060105624475830036877849376713153072596573531547747658660922124718110978079871559899640456158585238552112904137956071026205566626326221920124135867844670259442861129026681090832594098801594789860130248762324643297644706847471637967948003725573812623368848331141838666315480436753299344888124837257583413667326387567237151119296328175303517922820217986046453217914640708033761480998509083493319292939917521739938912872382041607485847269831786388474475373732476656691924298342789980855230878167676726332281343843247482850748225008140859373445545978108183699574928688531335605969018403609315564810135383370584208585789994007918555007314936858201008708646302236695827762051816341292124764983691960
math.73   = 1.00000000000000000000010587911840680233852265001539238398470699902149142664800958022743884631361380691798159539547487537052914060034185509836982061532898993634803787701189224089804137439462991146564349191815116392625252433130942759584011628091545624314565959460554009182029115405290045506755454187505826127807728629115162416572134773447946541675977076882065660377848476866708255077003010082101631842237942588583970550731091357717204681504585581663239338997749911545071610176013724365379090382466806332432416832485884217843306391783521626058198421043160152522055765759422065973181758410429981853045461656011314948317975143608912416765473252216667094525635461679499939226859786196690025017361102708221641293351147353638015861250312501692772093307154551651826490506956854087398100537325345845490793172645211001725094204187115487594465222140408323400741389002510799320539233302274423694133944481533110138245443364054469941653574602605274593476394218175166549892206566796081332275533027446375694852462045355010045604331411463634388210908355499307352887444
math.75   = 1.00000000000000000000002646977960169852961134116684203871559255613369100679404344087893768555845687296402555559827408180541244089670550949644226339895392627727554264254456479850142827186646279436790753453092699784089578579052473739423336361898269785337184052924796353724271835887682417447091863103978020259324676648266973136477125643550928016820015342357274716831830456403292507001300328451361156564255405327599822075389398293528005349786373102951334554234912383377469411207338348251722105299315963149283067888111592730477719992613878852438600590039125536534742648056412965861309405882304161902014119217472748271906814830684717868138264646451008786128362181744330216804319401157794485173599138952292508194614705991796977776599347391820391733983293468892743149925098365373241627772461148039438648183403798016383876726925753798326410458095796256170791705124151606591714060596923078001937265455108054281769976854299163706691411017497397738632593623723575302993795238698653446192892989144114083027842074060857531960362572806325370027680220437130186748329
math.77   = 1.00000000000000000000000661744490042440406735524533230822001471379749161753941608791739446619346151640582282489834344141030545341972254111480475831572087162239381122443897691719545567230907885436001593165891669898466282821109547930635177263096224090855260924963613849259920630127040468230648906595869006067427851268282048941313893610415409968557505454835961737225601850846365691513451098507266985394243958962249656402908974583110420752189664822935941633803083934696963163050399670979576377066145411572917944133869118908780001791605676386375996736286566774243823263369777658914080473939425538819790227062161899425031622728301473019749182414345566898088727951359592720998832190892054701344378858177555907250362565730864733170611374429775944489445068281274094400530221487708326931540294338109444203778277536801310773631072739962189642383138047683289759795524523626329025496863968297709008074303981886489152553801023221730464583074139483386161591033530090315357072008657159207726660030391733797924441327477185482844441137316577857177870677292554123605755
math.79   = 1.00000000000000000000000165436122510607564622992367718104882977235888666431758285674544143740902384580066925825480897303013099124854776616998680744601982752102044484418004952564540703970744925270956586190756856792434144560055616205656195407823747221869357509279716358055974216867210464193799586352388132625642292464180384550191689512743948101408552855228885076769195652158839787061406476509161683711629473021237729901199017776619403418269246815705689972166235836126240995588326307840898337922083847682622628511144642602409150209665991212576496491727395444602388118630245215403123408963493320024765972718151692985629250492978763849738080319765193057428009096608026784638974337713102780121914941366464561891275434270386071568780118231653191743026661525834413185928405612721540979842833570418095565742938242871531535450800761164928018264703186807924823064153994497663390208436192779717815573471720290819461604447148966738695619142671696753784239911266602773729250162702337734634061897541856711878418786879215619420057650905146587084838605075064577759297
math.81   = 1.00000000000000000000000041359030627651609260093824555081412852575873254430939774988237577539202156585372782014830914042632994018928239083638052584205393631560667396056366371882894543851691860210508817322684842635765313400453854046120134382725360517125287343147246128301499377784978817803466747458683533359850713906065683235391568869709050781796223917705947429631900218959288487633351006696220952332059423511618160804259608201575819038369915384504780359642442907856626439667457716102991632110995056217469035447912812801527570559810342823083726274752086668168631517542747290404780496983675727489569189148966191646573848086267007159766125190363177219362436094483887888550463549815643806541592546151660399179321972216508986824396564243039344931416613700734594901652076432596125495546938106115584586568883279843040394027741165059330877745578606256798490900274616756014676866678278120576034248032174141465658464284405479708154857258099590613214909130906151204176100397498424843910520815430779423808587059590886210406931371552457326441102575030117489009793
math.83   = 1.00000000000000000000000010339757656912870993284095591745860911079606271780618528317491663373931028452979291876858349765276129961537880008846161997762792039545878068523022282199107941548304050930502924373977180014139211096970266384341550966673140499941766629368432118626700139331851812006757568696572013491091086205823109188350562313827589328683821888445903113784904570745928031700798406990786119776752368784614923278970834650186767243666552201801802445043413591704988258810850220698220410800582215123552532411651860458081617388913009921917809693641615683001914094866185002936997960519156328753809277428652784840899714339869780754987636675768423446780732412061464209972560785018944860200326569892709024880759461278573662040107300313018290954408946331376914510504867531611324457373463530624646439082307795905161922897164399927458588476069097859064725368602913440612778217667918053035769134405025308312701125687478581093429175859436991362772001358858391766386541393102905930850193480215789124560782510904120212763743935279522516774519152623370840330789
math.85   = 1.00000000000000000000000002584939414228214268127761770845022226912115871341579638334474324599419154596270687189694467353799519835384418306029156080241351266856243721631900570855782192609926186432045123749821977891524267510950524499916344457334965225645089322385453030347187964461406674025715537976260693496498209288186512274130698093854653683384834527905990875518629005836924624788517920010070305400273700253966329055517299088390592648685358323724654835848439265576733374877525627126702804875521908800902935451883656501238147681379549457384718917866779175326092069752951495398709207087971811144333821124335153220437162277590303289669817067760898522060579565952664023243788921068606060085484111818091090512274472945442359528869320086588890435390648779981838646540134762646251343349430714841522375205374810749248625009345835659134049363099934769029029956930362302554888222069981033612212226275646847185154556684668290461798334876306222607810114314359410402914323422729163078424965161404983109603046140001080461531918833068966019254961042153243443575855
math.87   = 1.00000000000000000000000000646234853557053180343800216112216706603568635128639127656279544064987451412583345022143084814667742140295825962896549633836204032167243575968293334954621121885438973969532670664133025809704463300891702677386175970285159286099707707466343574669880687224040369370624501667425411680479210116560216739519725720746649384873853052092980810541974472528219595894011393883790478413329120360888534440584786210573684208197678270827062410492168051721407194750517925815956583599410456607869635899504391644680459654308709366715326078711526340244068801806782470466027106156847321414694643028790939468094990523433418022032819798600377085436178346280289528459953638827805691208458136710100505663781391518796472259537503677459973497445408924880582579881656712777726917880208461700940187220366855556107664144410771956524150207008071473598562410093075249270720471391454583673766143645350310675049040777761471431453547339949139402392637408456018201637823308201387807474538976544431693578783551969233405596310518129445275298050776823650939150966
math.89   = 1.00000000000000000000000000161558713389263252120601140570522727205091482618642979753205712706896848861085183008494202217647666253933308727930106991107177144041024908484569604544777899340158125657886729362931573524379145707850967634945226667545072110913742973669167084579303293456152356942973569924505348146011168379147123061379619791419237522338167874187681418180583166690005522388186636399334606090258266434262741183699177210160500349358365778247099041877668657689024671908856783350378145624811866790487502605031207316015988700972435606819422769186637429222971123222750796833468690915366973742372935677146694010716861627053211957856051597021600140706799173520850562153378612203233036890250453637118936557169701786992246397953286919533573271315066979779166305654361121949556074439163535215694264056714680085977013917749536211968976071643528159968394496546385612903442221662325289665874436576780615611418102800928494891442027872580796914062473515048877292748443679654854461322056182817748990771746204018481770669714043982650700867129175232617143343143
math.91   = 1.00000000000000000000000000040389678347315808256222628129858130379479699618799131719287466775247582904249203019903748875977478489312583130270876930062907049230526290559531255019408622449395142741325973524241257813151743967797208581060570031807783623262595857180489444123582382908754777357082533561177870777934812085620116869011946987986414356950154856896739446347481523617985167032900427070074737994776475127047527394890447112691589346905523000262100047120809324615895272676908338445039049313363608244546356838091628465706083910693487523404262053250017124946535850081044896471116906250795766340857888775718837279151628673792562709774883924011034501837920163326787141663551496894470617754985816865106919939116751029805777708279707284172642228643263860341909151944027437802832477393859856105103267404355119911967885250580411035623405769321103566174736278743745651619236238066238098510410036387857543606752910889653909916635538319129337980950889152554426177949116202020018990388019044737196861728404478501522067815433445031482612698883135950674864417464
math.93   = 1.00000000000000000000000000010097419586828951533619250700091044144538432400547657639274678955330231211740941777832480515649854601546696325047397978478368990599341083841051719304085901386049369715777124575914987501786879532507430703154991431629097518888524390951115706420823275740573851000812692431893290677462335518817241844058970057335197608360016894959521247098108867139115623456684705485667770336815561353920346123369351524424723113101018268387173438265906458296157238011131810058399044084963468197556535644251363107501694425007614690754956188920809059025715191960643168156107145266104657654414439477300517790085026591062641723110952143676169983908937787841426077980965755349185675245757650893389478740685025465430238470702785224890136594672509296037736129082839847665258954526003065206737191236022031141686154154727018051058027182792944147037052494080602724774043405934432345863471801087870626288385742447259986530744449578431743434946581286825655528213475804837359283137205161077248688437093483185333887706853650403395140705896128917159374346782
math.95   = 1.00000000000000000000000000002524354896707237824467434193796617564839869265830396662838931360229965414977120530064549588081776631277395518055367262551668771982752595915146675826321641958424855110711188074184097270656417695344326425797213652100132076233985181360916737770220009264643000843048338679752741987658456788135433964960154536504223711986209386737554945665246221415426860533213477306918000895339671256936443520331801764620823280199106874321732581582896287415395570313786774996439172774285506826477944451228475449623787729874773807108543884394615635304300304908489660886364007900394568079056132377973761983382554164658184334696512292465013722698124689902589161060445682577147470455556419852016138986745114829872588224812643845778972126501228705477578804907791756990033648002656694505872193956034262090601278153518184907086823407545798927979230078916468849741204540957558755957445496173854025853034851322691086584034712868284289342994952407797772964907294288769402722574626069954798887958310892419398771683015465024164402267133039102796262650683
math.97   = 1.00000000000000000000000000000631088724176809449568260939433320375006947119835693900326860128154489581337201528761219195727995303986218409290939979342194033499021491963064979828564673654322636217414934863623790102297411953109471330230901298004184810313177922816856449440450176753785058651719258805105117323131764765189636178623767204471795248264505687418768569978119249771025031692193564552254692628037199140505053773855365727615367473061503788803906697529288706234093180329834727250978251197600159216510879784982307156474697039773477263225114980828667651459174772271897689645428494645855976676031939820277009165880249305683899700665185429157465428441393005928549338121029288599625038468017467353683944833758676174069132498428613370010088276910882149012452888643349434038663046600484246488457532730627291504740716553745522569183044169878656432928024523862557614930294994419929202336517952177276920378510297431667802239715890100576621445016284004826472553783278719054741769638778123128439265209746137135847132691777883431196743392852341850309602253642
math.99   = 1.00000000000000000000000000000157772181044202361664443278301596017822370923862415277591427457314183091918108652199950607155424127212971376790365031835867140316625250395536864056812094664317257091749615023190856118459671944296892818194307997801924006554280756763317666589089023108843915267662005033829544688152031285646587779210582190021007740995820386403164450603753500863859707634081660734335194527591280363174556038905841859539013333339396679793709673168382428210271503567904425163552683682881912923100565939896375612157284922287398584878544472077674659493720434226581911582194578734601913426553366180515298150098328205751389091586911198512546027940493017494313625070178313847262560757986789419572967940032090170554981857260422802763259857347163271667587977360390636789092407610893078330473724678505589786505126824642376972216328881678979545321295612415801854960707816983649067699086784546199296572923835523153890929807242165331134076580134063128221215920722697932107358821183290596866942235292040364105226250881071942452146246185969620727221669872
math.101  = 1.00000000000000000000000000000039443045261050590335263935513575963608141044204433323680796761625237491928861445447104761428674299745438441574818957622047157087121949588291127548790096524591503013583366154091609592555734040093489167401537877730680292119177244345062720079530048987294893773720825124823557829467375629675004037826824689502078351153082020190034556854466943862945893574932257594460178334935822767226090976835684592392707422365634881380727204483236981418091615024437298781245092204000055752472644607980496146919583719462572020728942861303262753442706897595473814372098686898267645378670075647357998375763074992690066417983655645433158089100683705978144522084297107303957312401644138041378689506763888443128330237105606859250300409176278264467936209253937799101337731282246825242721017474195558896835960631640886967598186269848060428661060515337152476174048005987058003306858744049169321678254362379586923838911912007463446576063920040030151386246756337944355544528686758422059473828545744483845223443916647218346688006553286601652735343268
math.103  = 1.00000000000000000000000000000009860761315262647574832996760415921837750518131357516381977488948260313260292364775396425395653944440940983429627703821336021491260943157315710735945110592502919558238257474065055265376777093335900431733374941991995001580422716076748283106727665888627307689045606215828807474720688093053563525877710385367989963010261318915309157760596284900385979324927509414900817157513315858011339680054881001825097222677288054206075096144470916653803896581265262114527450301250920125730648445294324429802314708383225257124331568045854032888970436299537554891093431337372818191337583003028075643087411952293812670128086325834673678240219102753992356381082372308171293924556485666456400878512421978121661693192186496476257861385659856496246328973688996550560679230128406495068984740987024042263333715405116026024350532749625036745467574547968012470985575562639535970959145499781504261607397429800571710038519654840697918787377617851907921986898773362245199792969813592427607982140995792701497149493906258505585939678411420477945421704
math.105  = 1.00000000000000000000000000000002465190328815661892710139510328781252773254859693427874476585837833141988834731051880378175626243532251405340305439542034477846314545378655567978140112785348324983780886855766308850997331315595325849404274875554200033271876099547506493928559569661347749040920220284617698459756285299907235960323489037631022207883909373233074479485346380846526453164589760838258265649982040133795192689428043960352287449872071163012854161869583666131500588715228284752482681170211212356737159502128684897403886992986286509036909235009575710743607587868873632989523716970514420613758929899183152917522064922535459889570084454194640071087546111610176471433038740037583760393532387745911806779739726065271018823999809581623114128124221327426547497395047222095610853791743910319009075257991685492529861618941593722311219357538689767376851814030062298069692165312911207185810141620298109690603253051928062249868752743843314262982434832062833658466460497038837578288576444294145687146867276138015188381922697883790225722889728551291715158237
math.107  = 1.00000000000000000000000000000000616297582203915473066633802051626486093836308139234670131648793921079457042366907755412450892485618054319030289382079968414656957895088157018543274550720867772596611486104463726487330928573613909947200227720524074739470540048725218713574472882938910971987702764831184200973119722491481487760283844823852423112081033809608189172241590510831941313380675153116298833925642481939884891891668429202469624659512737391605676850900630904829624470687011448690945933493885861706138033152902386779638140856068473617920119405619452975380376583131941958368988319075667079792178202226847574319268926851985941471492578449272146461287766277624282446618931407807092215220619903326466147022219292063575059386185562491484196016446410190124201592489211152806179074930994543935166934965084267762159404336919686630484740731994452939531505153026524521271636789829497993003089712392937663094275508824215588148054967133093091787908516927873184423066506277799580609214730671184334653428876616869927322499619274737442399883329429968355389786131
math.109  = 1.00000000000000000000000000000000154074395550978868254336108787288416864969039512741284402806182489869728485649918861944622816584645439256997485801907567436506802192301853244005672108349606164546380512067553676522019709937066138800025190993673926363530519627318945168334485225226039122888631620122174825747272166313149921075300391967789419626470483209101890162751934333449757167334874115211720552470772284983154318461044832155797096318474352341730817278015371427979005633835948600241005639786459244009409046314269180737267044623474871903177676644057013987681907267129255876651553405232336343359879495857184188974104821095522149451041210533488688962285722267948606348553692818909676290009989338207559307754611960188908198292845900487699830865062184913326754742632737998019523853253484824661134324784880013543513153812529123845436299556698554786255221637121225494746029278775835863630282791087175015101468003008288768380358742479125408858932941180527486517486390856510065844388289391822420627481831836354820098856180946500692731123499261805264135707584
math.111  = 1.00000000000000000000000000000000038518598887744717062214878116197893873445220103627089468778432397427918932466146880690154577223717796028286037389506430563870583455088726881962103130179172109577634550267840314312288551485704536514721120016420643895694108634124202494697093032492143544371309290633103377253236553530214263406944589844989181669694435903275150580699294626908236897619026742359400229916226526216921305781113330446149058738594547094080103331585821877160177439501166408136369243223494565901868517047194587763913356860988422277924527800541319562994127364699778550659771171446654910967018782934412403668167154955441668656455297464788600389620403695871410676573903210175894851865838781724025278937934524190432322886743857242540540211641472329297184523731716701343067205172695166572403898830557242662080523918392637476075335232586291584989331289139667868669483929881983871651233796137909942776298927725234369773823785878068175406605748363469431833037196601055164068106637043237896769109974783867683803789039302542786941323593212518871471698826
math.113  = 1.00000000000000000000000000000000009629649721936179265401591853424563371754110826652318836633274686319810811568247469549076502437363700357340575957156121573809833396020115794615781904200971137626824326960729077812256639710664213681269545306296270827715042863993798864548128021631801217819677663654811789522160456929747920512398281918769734714656088073337419258713573065474594827730928291375405507755939506857206502760922839239680837011115766552949980579949444847903861026090621657146226466623659020103436359614528930822086805464643990719223505084395120516769141126678612426601905950269001833132168275657953682343337939173050600652262157490199779591682698081354594827446247239080855949528696151868248508018825442461778174441329432522933661632708046854899721559205938766107112142211728491552457624320200025697962692740046996273463048223784357514706996352242155720942233841565270663761121196299915702305057245013772377595915473610336228644097814537047979761094612191446836812057188972372437225494734230275014296886578374822297202233308208201637742428532
math.115  = 1.00000000000000000000000000000000002407412430484044816333494888286706522991424821101737889417794547350100246352327537670979068507103882214409536809007867085814358832524326860874039327155718021669288155874096044920530248759785839097024712867759575913001118634449187673438764000569069393933118307253095851081346458353815791683726240355796859810578232067572189218023068560727871634932308128268410698694834873200100244761206241493581614205427432462528289628271567098832744986204363256723452910623814652867970554038476715730903753309737048176175010723653168526710299273435885207473589212966182855514684658933737770746743855710364349202688225032372446566985724440953856829581537908016133841437856258857801766578827047324887120045940688798499823649095392395653251237486755121940761705147394511064288431590473575678480685828618694897635556630198213692636600992633313087057924284284704315748663596453555883001579365096065094178553845350987486381596915149239808359242172586745067898935196412388865321123982814586281787893296030023381494521966688872213271520454
math.117  = 1.00000000000000000000000000000000000601853107621011204081495602619517270316811913939737968450391742536316823119180324637154194579651051875006850443219839106434561110074710302523282316879504167332154248468008372010698269971082067717664071947914917289892104193376750204521376078503910575939928506906498763440315885723727039875364181192773178818574035588853657347063848346812658659121052128761096871178321100048200699302476531600925440432334788857587921921442432725917057542043919403652456859347458724889464218849155098482443969783587937260814412821690794007185930190351556698498549401650047427917017557765581817336701900494699456554894532718019217336757302817529258065980383648441409951457195470913380406867468942861149018983508328726794871685595886724186155336453247857646895913092263351107040321903905054882418669493051514075540094389003567987781751902538872853968541579324439580487547044400318626157594788132674316591830704938463051304219034220722435153576859042674912160652626273328434890538881999474914935172931339108645216584082421361890277302764
math.119  = 1.00000000000000000000000000000000000150463276905252801020165220715750500281779336829840610436537279931647277688803851144172105040872364516410852098461168719072790572983015226928822947486115114323825640404960692752413986460467212710676755047022438031761822230966544166282397318222783658492433762481853397412656115478170327966995051227165287513234407678382156870383466269612921596992458708894992668081945926715155328658969001524385376492160846856736218095499628536297525918404818187733513539995403048953638584884647563108277522989643862346513971761785267819624358342451930650335647930867099867904935083695244644632733179393031755254773493423691750596199216093916527374151945889481612600982127647129484313567220616716832889336083404251762193362646206630118107208629736594420664739607085887725178671166245147887958337480054582283178570155164758950521877323715173149404788854127961256579144218720578804772591237163022285459771681098881328827826554950225355573613517195824830777337425898256574759702155992124427365185658715290830537247171633427247365884257
math.121  = 1.00000000000000000000000000000000000037615819226313200255018118519034423181524370665364677155496332845085692873916603960142093342804311660136140181059880129941818223354763435538350305259030809125575358058392461026676078434383296988989742785265311886386612414683476133243064305633236368916459637598431232460969433701877105127915711793243673625194549258729866934135373106736796864057448928302518969773995043788683627220359722224451141737084529044868876915463860944575967194810403285240012673740415425702912185010414604099402596900626507635243767261240629831463448589555275466029177520983284154632745765702140391903884166761843252211173628938300468448888826193049273987993759203404680886511409031775634474253781466290424391590135225028540435814063954286525891032110238490949061773835763692314993208974901277736018983412895870501733268625258555318973044807749249049304958392698136559490721589237237723536403287252626819887631766988580665805425956437329370493303395669785607478318413694575803521774734792301553165602357515644762912052360117589111978965107
math.123  = 1.00000000000000000000000000000000000009403954806578300063751953334213805587564509701771051776668687116278268591840494648451684915477405640661067147735504444639101738610761196798829921616378168782338637691630695913574429006247332056531106189021834402118420634723428726983718430805207316726582198583668498362625757476536750280807400403350929062475280388321981694234986712242469301534938217727952234574045912859971203322206279266944181702508640646050506428174547649651911796720191823317966852433289620060812538380326790571190996887570659080191563041681545427984156049104168598942396873626627851929557503757114837083526556016402825865483514131101410606012009027874617573440144024107095368422506730967591907952152399495645275945901469238370459643961107391652389293062416682031272606567627242350380629122347512842799449092098635587494507126275041466577244169515571880436126701510294081316243280377430346646652618877250794386392194969388448411869202198454814478071617030007651345227740650148929446829929016089628625935642846282885650759982785431665839799805
math.125  = 1.00000000000000000000000000000000000002350988701644575015937702078492918040596029435358112811978323152719989359795403543803538538722946963139994789502441457092645638534972731471838461348677900303551420209174109888855433215838898952007212715168662623481223008660179642459589369534937866492104131750013249551030413384126674412581088210080178696596293902615613000898839384546431389258563739836421289668996858542723408733149216613740697175745801854183421426778320464024692449456053653922983185826217768588649512634540969624845473583244489196285905481246461906726763708818073057483099556656676515793840790697604535249981692159505146230831532721221848181789242065298756477055814982345085393009845273772319584325641522976636361659704857980439184604783271888268822709146360773263036961493170659116204647904562882711553289352697973722083158108487766192537353857238746057624662432442409415202564479225824851926411226232722327427033208899639276834976394428869445660923610888296898625502115246556272140996653204581651651011902513484111297956082244211782766364055
math.127  = 1.00000000000000000000000000000000000000587747175411143753984393713505392470568723561703782216467751435580957431678061423003876671771097783150763390746146506418513069421682074376686202154700677751367483086381878974464241628865022300115017516674350733623896260609269613294299088386237134088524166582357182521380152409859106867092383101486850670582069217819702438835451408368273534627694603191999404751944395717896826136302768981966248012804479399167318551567750059467224247242931221569994426880483733136458092058558431452398583985129835342461651816284708761222495617453672324820162162208245193961682157219798854045560403648655250868030206759961084047214679284545141854635319895406130622911666694070257751570252452933113324206643714176026221760812500526774138800709259219050083590776111803857020940477626023351183322784368511712870436219706830981826466661241390938456911313528864258946241314972125985348631771981445499043765310367234629288446745952954714445755697368797497651086896245040119883451699312944788681097159985116801986295316809396948709946854
math.129  = 1.00000000000000000000000000000000000000146936793852785938496094894363255113244875356132132700077522709029128796106374702139009161134277128152214458790317659196868584930054947098899399578656862284207511678174176150911133939570176285365524508281046478542606472801727622932982830449823660017170842890702633162530875186850940794672619116494213379818829460673037699759688012553166399955638837840002110608509283129498209760791070373490538013780169301783512493899564861154240604891015610180055554215105588522386837148649809948450194434006432279916942542541985312639001219648419041504812318370596748487140321577834830451200663031132741239163407626707259993911284519441994538249523433380618913880966501006376755064636347307549432860234770620079377621985909747661375737479569936299702868415632005648103491001884046311465796243975904706945623503121907830837642442853038334755477056833131990498706267990029332211303060240494068677740512705741184669068223468495533817637175877912471784423469284294883057455411979908107906711237926229280742453480932392577879813854
math.131  = 1.00000000000000000000000000000000000000036734198463196484624023330922692333378216376809355554029892447879538829161856514418981647517492126818810309736568753060719498036878235775343315781094374898888208484916126326350768215905758544117148111085063058678158078523119522935048281481185860943041192123921595618256315066803777799893832408404619625039183955742594584357924840459911410871954846313703125514758346949233164105964229710148083606087055129593102186924414793266674333389267737717734220867271545916501591878730019444476330102166020454288943035841877799205884434910357000871121793926270994730718608735479941269341024131734311111843206332891108997390107882952943423037167594859712456657304946254331386059593029704903743611640609780002942600944938401977471086983542539879944678876035433327403294877775159917437867045536778901034196083313135990855557935626460015922427407550996375264170449859084211034839759675806487027657445802020172430015356677384691290749754719170692915806968616352024361729875779282436067513386537780311836128567497635161847038514
math.133  = 1.00000000000000000000000000000000000000009183549615799121156005789100881811685333566276657445778175189720313307426249869431607702537611568436325979385146238773280919821547569077325189088151411798093055554723182024777506760094179307570450018439713417445693862107430941346621743473968950330359244634804499961470913806478753020538184072171418178304495593690175246284080683039225053453727886099535276318569957529586055918631083854658740357338246644298067655027874842187560930575332118210763302841946177498912620499958577039140546189801377491235346724627812241790511097744861948075099588085238702530551483644009826259577935156050477374226964365758860986249333484051009220698809290146888159971656827448100190840596116454731734715809129838867325210106362013824593706803754172883670117437875456151000705197522597952190379157188559415016230928738410768981239354145712289012125517049973568505537737107546107671167520020521053520993505530331796229782910149954995881721525824747429596769159592176342455625999806516928584728305448170763723306464858492530925212547
math.135  = 1.00000000000000000000000000000000000000002295887403949780289001442427465867181420122569731316649156268017114936231906893254252808782697181019688611489224748101270699340333501271300914412129406901542007112093977049200260979733984453886900114555850938971117596514400709812866319009494336621218885720082096210141738543056198753893379425844214368669841616990284021219728095408981245742420744596368105297084039894527054020473952600045414698025336671919387585964020234556668469779830538050661781043664026150025503950581984186697925565880689938371371957995995790376788858425131840479160954817183751061392825919706648277032158865431316304313833086390651664512662833578826002053423961628252912901592679383967212226406122968747219827110292859672244667151593755026189355119681644078033565194665784515122903479465968182729144457235587207271480155983252131318572524853748492948112015242010458346122519256199497842280777574695672972604408508486984025839502033268761966347867988857254473104783232045269557464324357982801892631558281953540522974192703776156407287027
math.137  = 1.00000000000000000000000000000000000000000573971850987445072250360068227068379809119551737380014461955272236931547908591960205249582949370886900726341803128290544446721354001635334376292026342322961565015420302576537935395357619968073382964516577035039799608504066260129934366955402748281493146193583735494297392727245378031148704806904019768633637086458166778505275182941015614803350033530101032438170582535681944085472758123124469478210924988074806100169073614550458095195830465350264358785170313735573598138716598281250625045372600153524152468013607660110907498933965891765913295808378617642960885521226446969207508808839250332331053231918060074945405152258995038053166101513856633218553255368110632097850400698095385296655600021906885480738568957036450277585717713640693764266114480166357585726563502189041209698164288128624850379969898277804456366814298581390850759242940135382892671727222494539228018502362334134461871202125897613785842349981613154182026449217216604811760688545015944360557127936884293423845226921338894257392214453935883996458
math.139  = 1.00000000000000000000000000000000000000000143492962746861268062589957207945048780512469406892337604663714298598656816295901247147959576809844605163853589312701524806744566056504615442590803171899168350514514255940124318205919843361058430799120071678857918577746991298829775037304540526651786051322739426751782156804697208041724779283854384273477829991594285218711295036293885351795840262807916193334188841549950621892150339289135901280735032350999723679149192793659439798537120690782991154890706571835372807436387442589268296333265882624031726031711346818081920302456619420257134904925981589889119141912815381619796705686302001345302632921220975280806953012379695548903576433667151240275445100605740083057572041041513427751139166876997273056398327324614041409643488418468168918898856807805701903281263133483855651666412216614435030267457787696977404529182438476997773985175561778978396132354283526509996656349170419341696190036231269829532990918708544923522515591179437000262518221787116167430135975522387432735476118752838515303524149224324684535960
math.141  = 1.00000000000000000000000000000000000000000035873240686715317015647482652117145953820656431647615632733582018341247523160036278869176804883283981376150176022531402105064818898065302211232778214008514542206610614481785795589439913989212686812388274553414871162760293146243158885726370092132461294047855034520722767036252393364456071355128592217283941719901697231285482165440484932543310375296136263837958883098730087089066644919310336072537807434362492703561395446906466302654767916210022597947922868251749107133517112314339630233180338833360312759219747996921231559137294238864803348232010125421944955675135145937282748829541127857408707817446047299078568717958678983455540482115287000783352660693866233061158255722320474493800211359552118979938002763596169614573422643107381290131360846233486137864152434439670533841920400280689889709920352687398149945498255191668393621519406871980568491784663942710731925675649221634106365051292528798311922601518438798115087891803012475192259254578761514834106322554785868911498494176546701736858347865692039238168
math.143  = 1.00000000000000000000000000000000000000000008968310171678829253911869924154940239421003660172778538680525769638438459464762399695784040960535644540367719758274360478337297120985368844638745118293193321056467889075764100586640921032496534147422212840993157970865716655919545681074455894862736052888396273674250056237215860440474226660355967336666756130450846879865398220851338141347068136372120445464528424426838039085420292965338378030047421566598501458675147902343204711544061249550170558050497678437567717937861325513708329068114094682049443431149403785520282080102010375499117690530795143069559476931771806280583767285847160581457298342536344075887051986741429556084466286603427892435121243026815238862021714328984663733625845385218939927259005779577712569270258014957305636628921420353691386389972890853463199666380246367234782186777236771383369560727526303412413568678886958875893604812866750154524933220671693081322831300094440305819792665672165165398341075837407094618797745737860273639753369866259446973089494945533462634461143074163644301756
math.145  = 1.00000000000000000000000000000000000000000002242077542919707313477967398941585476629233204811231680020988497376473758822690643305907035950078210559592403614912381503764652053226675791822255845937752092332645331680871919625326565961172895871402736047964898268129597939124942052543751343805959842870436642742720456606289733136778186758648733278886756287145035368713581596615063080082207201541791458597888616693456593218531151013220247656730389211258729256203909446296933320477213099454565732816541696559366631867716246015529287626878047084139202687145236752891077770519009084318506932349384251813407991584686160004766232408974745563375582156649117234069920151391522997744258375754193851649002499832597694535645044373501551677409213555336596231841031111025165707645209200789453898635465619784383942894940259171651584486299107572676792363450950069276872491249214318139002187488551408842291154548306549749053566403320925593419124953759433988091460170304212088049099197490221478879905675235783868710404432970768592879097755071492934981212200592058247465739
math.147  = 1.00000000000000000000000000000000000000000000560519385729926828369491840613490859909973007396836055444558295305383918830070284785923266934420570317110097363187070989461374607244475644530386651657730232474043492820416495057570731977998770447591930435994972745447829407232849659412083200267376094823277673249735455622885884610303054306196860763428469608229860920746886900209685481245247835937109689849376697122732829992218037029381162641836420559273905542203387240611552087240794137057836069040892815349886375786106967507508364882648828204568684044566541642560997257289037042958421637055820329028636684777648760693829753837532778213230221174928518396528019704800362334327869617425255258679633612622848947016602272982003469489870042432441348649720593843027973289080512770822759279450628814357364361885110675967336275396415858854812942561854987975951649126792314462272362177047742000929445574321123941553505399100809278066613940996405999347517119355983861303840296389348177863938567294070698272470270771900807105463620803900087203547322602457471220080524
math.149  = 1.00000000000000000000000000000000000000000000140129846432481707092372959139827658394455997440060863448857509377991292713307299779612789742983761630750281041146976408543863706870112202269123990832548327975068283028819914955529249758073164805344979539925181207210838023906496839379954658268373063293872230842408863917316874563461445767914831297401166403918347290266652569296313013936873369047315615615506106194954370751030012226817983301891863498490139351220410980255395162610745953314863473372308087873236339160660137298800015564740878162849095651521069412851539299852539079747017794831953626401747601981400496004773514472382075219502140403144868607223435742314071135220263142126456179430688989037320595440744468802053919797262186674396396864863221459920444339373069694083971581876832764675145490527372991907661789219391752124798531518273026726715485148675685083611222457149543790496811323288819216308858661649747749132081788600903779288181698523437415251836728940987395754338266691018989274674893345551510260429506184080238633266548738117921315689281
math.151  = 1.00000000000000000000000000000000000000000000035032461608120426773093239672340797200498748898746244363975597051753055786383403741704604481435343263376828190249859896723086276509055312727326502201520739237771644328299498687171618921608936576914481082088572824563899977884324796771309364271314068723419787859160085912344631256087078413977787146452638042580403153357375031804561492684485540549725573212155798983129396369764913776562057377144976045870803286432232784597579632628338792378580132618691023782097506262988998327113375158706174257940912943924161621884586749721642029713580582938805661791305862225295705204612245829805730432510729389733414356906519996699508253780180943057107717739886965170662357849580022350426106536185145012488302780209434565762022910064216825307896010341468239500248675151824005413982329998064066779988252254046851673713811832219389110347652367617574176258712053343988966807947558466893871062481318562870116984089565619483569945855417010014976592326831600400100209053059820720367622979005815465612237508536297782341700743788
math.153  = 1.00000000000000000000000000000000000000000000008758115402030106693273309905572297367000770508557560139301619359676673320510279127818046269688086846647667900338943091272287204942388335967559671117520258967140873132731440419559525577978123582431757866419474475350798830753528989485591498967886250120652720214857969923860956718716953620061781067168400772159761809000670735397558419248700266310981778137719505732849067967544253212936904660439983206005832921838746665911287494632639740642428620993971818760200010019614022576628297291326658724990155347920875101600841433432191364524465455168882107588303479138703667968942711537442195903809159074980946161674792997028111226616099120588538388102614713864501953999503655309468012869785633532110491916547445521300413453965125174827726381206557701381627242068142452561169687534393248164122587120903230020136524566594310004261637389679787158519885275837006451277304651075633165625953809348836483563713860614546475919705518020738521277133219686515512028489634250416910719368322642048377403944076559264827956075365
math.155  = 1.00000000000000000000000000000000000000000000002189528850507526673318327475002751904736424103236917449449930868969368466877686600405562158534841820249396713329327101398917746999052504796422788841778852334099106043383032282723011331615985683362295829395886524746114549294515128786066472149711653785062044262830165964674368480855585845290165249574710785736065451677485603496117749396427245682604287549756275540437805472417094923926324251099876274552166125554705464928748537020348369427972779256520679917386699703257709183519810115158296889125833914159186253735507761266278269794975059242573335174073717425804738170387711484159406727772331826694542445264183567805309240976777290000776380573360354371577095802805458648797505655463324568724418547006573214768758013336776678718802015673774206491094143699388801175533403447234682501060634007641358603502636454852416321086673688995133021032421847449693620187864621706577742155149533143181890256086182770720749235577274497031931450989386729141754630028395395934897358423461562312499650469300579646575059461218
math.157  = 1.00000000000000000000000000000000000000000000000547382212626881668329581868596207705404798412049279267343770420356213969248677549561367107652011668110876337058695715000951474304027604664216149091573671568317732362195056023009986453749875930735992548966129005537631126733071572606530234094834215006583454836134325180604864353495353650072026832432516423711426787306554107984975259360743971469488789074910209666128437014839442170176120806658976404859101672922529415713825991875769369460123493375942089884813155326311109165874327101141933994502058916741254869276765810853718705938888395441599214188072621896731247075270275806525607802440416592997487207966725425225423216309783710901174722686743149429136246980699898802123586747206505687887209604123727190478449840329958884411396161298186470093964432969379698671275008344660365890601816602110743978539248566580141473536823845300811430244880255812274839801575470407635377559632859896035144475055446909006007192918234654205058772615699027816679637290827828082644551314215099608819568294263353357911999915465
math.159  = 1.00000000000000000000000000000000000000000000000136845553156720417082395467131887451820165423706095651626968066849830119293363644318212809387047943006654692462953097362794832038675568554634129498844246157476836365424325637504799009657980792925004590244568720853956006184757515564849550235750745187018743078024955009708623671422266756135161056371855404390561629522365011315457187716685994405180185905866509291628603274486835244301015399190093787256996592310097031624481121968892026796058728473953853598167642654141658691068390865180719645878704565229474691352584100608783642360853160441191317628727941515540010200157087409010433111200936802634681412890367179811211524313896984281351826475869809414136297306783916821174760263144127909125680352842137828116643339347566621399426454041740367663378346800013989807121337274225689698850052315229390326532813159101011475294942161961598475608921673560429963882613454308592760226725151622448355421997933693283933553706136999611458210971002633120241230964683844023591463195951331287913173761562447663389695379158
math.161  = 1.00000000000000000000000000000000000000000000000034211388289180104270598866781064699118259780448081870995591661425622483617466052639840206603726937072278217377339136737182986268245009684563946314763391266353805274372884139057343276443481529308076991202254309520155453059721060090087516968393870681833160879157276747316402104197175851539653209969346198325771901325054460034870869651556029302321837199584108729956416397054878702644498520693753557323154121935889363559846058623326581598617241192232291004299210462439791978805997025225363542735409695545183155151363532254985675665499625277207562693486299887647727351152308164317823281402262622694931957143040980223259023945091399396816626768066057454635733162121698678295981619200058984656928831592993224447097017262593333214665511333221080161183510619824846773974408643443079866373898252185125113538255414178209993264131616614657290637386428616586072550365310669324948810614079105464267935466538633556062869385449784085195048750984517365338622888671325300978881401461141486645813639523017850886608132578
math.163  = 1.00000000000000000000000000000000000000000000000008552847072295026067649716695054267686589214503306392175496635189599757007464420359492644791002648344186018850314268987213303844095901868861488318513158588621140049861172459280691996106549125245908065232263243974541024052026212404936105200373798469728531741145049339097161637677301250548952975365287288409918830930662020673047032452166150502870234998838812458445947112628991222499873621425540044990518837629777597225974824186892459449778055400918412644728457626807999295559344674611748177512520895529711185154850251636658561794561631010793102292728399544812403923422065920022528269639722750133608851743394745499533148731804949468769300104069393245081223106666712800465674949521254369294226925303082117841927256299478808173049963860558040163575937465640474238180883017229612667675959727517811092023720826133072401960446246519403749514209642740441255784907722548388959814115940396545952563595692620088592629142028349917951542039691415903695650457602601916015840835522122698223131970548771508543184015258
math.165  = 1.00000000000000000000000000000000000000000000000002138211768073756516912429173740021689094444669302918547874980680130166918687562577204467102889287907023405933751805355733400587001165495651283356052765037632067190677351678449865850874851709796735437226025498836826301300810794808798132278584950273173020021082006632408377675386466158896967385413677853120887662492222822623927370914301464445590646650874911552428847198839413306430927059488318020607162168330346038702088677494272674041347142130938021998072738427307902865809054895383782595469220357535694053573559819097363154425533968176507102397519541280764286869137648716887651885080701277109508485730502064401570289988257360442409125691418074530629716993100974088765043208899924785542346611944863089443548928850943909623561983953704771002606152036145634541594604618197118506861335053011873370980849098966047289845462838575040110102146178117816033313078979906879341169707048241136888162486044740612425852784862398291338319839763236190428467938839300042951693524541695658717781908963321290810664385867
math.167  = 1.00000000000000000000000000000000000000000000000000534552942018439129228107293432389285323293505489771915950841192497264847567704844573725982132503686890000918133890267109303441220250763331779735620012645850278523119070947291095590923364129857491991485498162209194093458976852284852297686036234604902985405206509220250640900233591212629892370649613025548109477847790275008411772872039351126770268968854226903291235671410537231010866665500377201035602193366549614672912204675127938300339044383371311941052428307719557957176267990385316153648114500231835985704852218554699191746493670580677589135589970841008900925958467069741196165476434004839520650514539395930826904462246749604891065135306585203784759147047201839320703006782627765421550442993705468642941141017979048349127059191406162345329571906294829115747083188084738887769735440316930627776723278325440586863536373644832231763994419611343473321643136377880978459573483339703901253348816874031681848205792188897239970941369323703228051023107137431866283931111217148790317511205053388952075857552
math.169  = 1.00000000000000000000000000000000000000000000000000133638235504609782307026823357806639447454747279559204477651816727664775898566813257426075331249239274521466858431588691097979467966449020094187180488644998724318588913656814954500861371347447413564637806996531304234302545429112670818968974288771835936120670451392544274045698033693396981506612672006519422557287495242737861896829399805257120206112594697987430857065858783900629854538643522167219867313566789347079223619303499479104242004254069580404056716019505441439078610499696101036201269326665797644877091425578562875277988311434987075095785888311126278843100895164848302966191842712678442722958277547018968094475540517257215313791712506497764346520610948773086095229042250789473106975059516949752606674102362754579484910270776132934399239360392539456946839579765454607665403632275141711268609724867785006815344640735437452159100380826258088642394282827128258648566136913004673229008991274122959750356091351297198822061537714683230698424547106170226409932209959526025563809540894944505369123658
math.171  = 1.00000000000000000000000000000000000000000000000000033409558876152445576756705839419361874822728031791629996263245450102059944957639678128379154540589521835310537915778818896521315352235532360380186377874325272747264456006478603682088282273883441692875352408836830911785233834711256404481927840823675574316295226598398280517757025250987096588588261555705561741071424303041181035075983880960188801436148635522793253130442750856578506592219286315909329072621829805405227561559337021528165524782780313671256079218952082066377490336929441397539044266728643883892615866287689686591287136810084223853774481514005636696694374080909881290190417808198367572256447881510553037008768447612832228835806421239605652739032392951398941597924174217541163747043931627049105488175180097946628429095426692973755968332246197305727257876268925268175277611520472259027106991801805720056780585403073322700296664294511214664013456590740018323590308386264333508101206379946469282834148727591090924198194146432245728140233862891029699832088153316628979495458148110077889250673
math.173  = 1.00000000000000000000000000000000000000000000000000008352389719038111394189176459851251803478908809270334557616615272951133277555170800006630966465359717337137448784174014261328832324912354810597730129106207589469110293804409371356973884633198949960775489302387015138267362510619539866110161793566801880574362380948143414104389295108815680747820124504393351259328755809897181802723719598657785115117566026000413473393127295679414772599073478727441921074335771053693812972813580556654364263706754408749407258423719971297680498177344084718300578519892761062929603791099382936042514853478779100413067643327403649273908369826105517909591488467171055559525277754110948503549594994942691614541172291256458569976382912039863414562131836411933905410311745319634862503119903337449330039624549523283193783293872893192961956508579896744855419828783060772692979651631729818601695626702704491546295285478790312185212202501393102154686700985202047760840194893899503695338150722766965100417308906412715745526482040633976638874769200703553985428264022228490550286464
math.175  = 1.00000000000000000000000000000000000000000000000000002088097429759527848547294114962414210288974624686742303202208029990937689253421561481336794678758481206952613005598994152079327010096223090690118620925757482865487365749158369576210704096598054455580245965078462630241296997237658678484007630066113551790113240067298464586737600147206000698281414948585047532680126476384230433993179011464365411629491856716645249118561822422561989556922096105149115714544310609118872464712598061455251169772128123080458944516006256672517255622330581886733232326325757476379958976422969861291319824663826192146987515225218831754174143146270961960690546249607406424786167503407905930138713756845066110147730981264752131753108729792071398307289276435004439933011953780382613595277984001084189526808050856588991849155864826428474874642450906124130864650381091573762420617414748487694211860492346561516692345790698187712359483598687840790207596486043257464440506585785626607779515970960439952403448126730505787643293509682784526958073803721906225495833769900206890640368
math.177  = 1.00000000000000000000000000000000000000000000000000000522024357439881962136823528740559248063271147546036544803333614326923495044029692266642697612808317443197118275704302398361375899729018370822187174083596466519622286347416704988329254831373934260723504747620653843931488764081420758262667051386735619101757296421116670493061904484160591914192171708060534283376987428200132952517609003735337546165725637724675552224683497354822486717721859355480466318732963568597129958035989276177060540939696128008431686570721202745875313246414107304026977325477800920163941734869466663669288243834072994865490277151605606927167160048973415787204475110531084271435693845719489835550705885654378013716412976035559772076443515995050161804102356271839509405320942855211964251395855137129630253569460762563707420162231282341438871553251929069678226081254974248975482648916286140595701207580720001407271003799732584810083954625947905624147532652362252583838469642528373931872938134446527185701488542855951074444196637466294998639655206584704989686636240864739749476631
math.179  = 1.00000000000000000000000000000000000000000000000000000130506089359970490534205882185134889292598619261437022042996500519068178407666549723604021969489249937523101773555161439624587516092253069982570793111589671715681992179328597538849554628563420399528631233127088279128674438213913350497673844771323777903223158368785408044520915070894873561008517636644452025108833151831321386933655657486814934355493405353824146154709406085158748100233289214621905828173630238142484454727091461809066480102152762784789524837469677568083128772485044553859566355453753016775411410347860285312457763177846016613709532208957638177862681236684650953435824436246699182060312447103541764229231448489861549314482065023631322690685814890846461805762728501127054036488547322187296094146157282811187099791995848812033846513433033959986651281603371506062106706679117330387736236619226279095637788620509313399252309996296905977851346584309778466845121625566248793749126854931085672321617366309044524995543738281807603081887413695227631352798443713173520910007744542160326489807
math.181  = 1.00000000000000000000000000000000000000000000000000000032626522339992622633551470546283175353903080634795687295827568300629846825975465810306692327745716725668273534096999588011158877819879670630390206788455425660546823748537966322303821871978059081097135377179710098238192226757416082414651118804926358133624560013419711683064843630086033108695388207274957563865768551000407538932618116974849590538123289509215880484598095524440476992607572249003491964917862366780853712853898302852439118995799715629966143070811697719335156133688440221230763227149076736004409402576340661882951112074574564806761480495428417556293060717197157290446487985955448620331575334557267326865640256294109505096891512482150291175318483518748926027356793867531606668873449276182825854672864105630330742719459702953610249948999776498549778242056184673505312975320724685217349755351547971938488192604666087743723948798648519540973221843986165270705551148977773713699360012228969626845062354162483788292570031020332668599573270367340843679804438350826110184073655837694410344274
math.183  = 1.00000000000000000000000000000000000000000000000000000008156630584998155658387867636570733064115039694191858690517989174700744692799132283913423845177753380280464539655532156807062905475271273531355392852126409133725833369851381811516198315237224522883765200162999865825649308675265523418762322643294999424208719932408747730953932606847216190514843014663714819211542154008409471506194196567356184776469067824330949616389396233007268675028859199999402454768407043347309527066358665757646833491083287960006129357227665305136782339113936427656610074884987779345605023217948638912324893759582083269976344419191909823614807673233840718328556901825477634028336009294177186893055591612590162494788609682216537724398956396496559356445332982374696753262958303939086196535120785611631841751911370331978076022373813189182666919485299058667556880839301785348781949979712714935329353904412028842373431118766485470545995278125706310797897149361837140899401751740923209047910760414504989054684140744523546614102339840856005745476645211300460481123013985593460182428
math.185  = 1.00000000000000000000000000000000000000000000000000000002039157646249538914596966909142676513322012094158290991233309684770458898175468385418529732813920509449575961226733437118812399765844776173382132194411227102793938413768108345890313931250709865324598495141463252217303723774108371895692821259483057604929859949251620606632669127018698016026567866852232912413108627652934665089444251454663225080031803035359218066813465790810857577957702200117330437540161506358608599884617853042236424896389011684394277363812925153120263431560731046011813404438482095540602449357638190253061992469425782207256445842687881514157586671416059845029768353070830463963627854528474152555339043295010416264686257088637662655407170264483300754313273004389861616213251655430479369275303338317709774047635834329212683085700495080641939828481950967436635671278536423582966842324293313718636844319697772701944017202553171674384937489384220347428191099572490508320188531562614320029619319509614457008590968719657585972291323818703579774432809724911402744374820190576253937476
math.187  = 1.00000000000000000000000000000000000000000000000000000000509789411562384728649241727285668378029753264718497894325926120344271218548060858470482967753822285953829682270847617157735560186026060550508197695493615456766873537238585956057577048877825981195554315852644683447652335580360686525171601693629543782444102712786232242343699963571362078072381351636156378658360120564271601174545398686632149798359830664679167435572005124072534091138009455730485437721347298324298299815768876809172701129636206266577877197248337789590044785020673943325972586282274507155790518016945291356069445162097432920535028663265979432691567130060509403406733692062876772615705715347096986110510181383497337955355817967623741217976267647068560555935249596996138268852267578589434423690387138983389723629054211845668855891351077660845994529562277097150006052087679898370518910514170340746477924822990597582810184194099334486335413717271575852516696492580275393626236658792841373957182618199190467308818120836453385667365566922834437297412119053392436110283024643760128113711
math.189  = 1.00000000000000000000000000000000000000000000000000000000127447352890596182162310431821417011140688342977282823194927051528402107588889104388847721742797661657107399303880831907092504954367553150689363226837605533168763247522629235990182752724458066111759397326814992773594734792130625008464521710704845051336713471893095410730820424185177739085872665128453955241215179358582407845123138937918787454994396130152242063847265105583022610520094150868030887233623107878285764577453861895292830682507754575453069469762886192943185069602302715139536617641111843165800419014774184702990439169094903610086298266623473369903700340285981830489519447579074915872102847744800245971432124407826439625541932645751090767277924631733745469877742268875331676930637616644700153712279194242136032021500134916389165174316668952723588945087751857237457810615359840561669730037487315314883896976495790172670369781870749181566909965290608589199580681803280541806244048067369394758581402206030987244123241332143550663958653086577313486078131529763439647054014679222294446243
math.191  = 1.00000000000000000000000000000000000000000000000000000000031861838222649045540577607955354243522199866499616077978027174943952617729099225664634484498404994776550234579668855732619806476258764542275178126763012995687272398692798084766035920592457262480756452472974657252325630430102117812875551204531603472463180102533589247719227151099049442618678893632626376533169286572505285810748357037243166960971775263275680516333495827790862876116604773273687754772651148233222474071339205805496328211953539157669614441595034660781251303092389759960517074924259762899495505181334832258795937613765308334503837347055954933385589641948636429685626905664862877836927704571706905569610237679694668543528445351724748460726414959950155211690620003466108712598057225605463055311729583401048614582276682251456016601408826377178601779677952295833413185907042431249393171862839782904322429202369302128342690239211286666212336193685673987113249202157406697179097846480429317751633989422141335835698327050561834861591790812521892908924297204852362647299406994747910065607
math.193  = 1.00000000000000000000000000000000000000000000000000000000007965459555662261385144401988838559851330831153270171958874431097821265320086993496964856019509709022845477711008629747217325768975886774299846893281512542171120855125409519561732529368708799890025351549427334926277429531031528826005873422302950521305846489987025230286786656040981880588898539825088673608420894043950691651098213495605010920326486214067687308943390938999674278841473085926994548812057065656926709874647744081957082705162974627627384158427028287624935364928853010211030211085289719537608029653712270629568941724015538549514706156449500048915828983916604572619905706047415689495617526810958552418539354023038473300179311085334870061795200588245827644403179877253955864097087935395629620567138510459071585540682640566807824870365396462662823568667377332508581820742020219821532388781466738148039049692688947016142426812236975387770222979201148588834163116000562776826113146699670845389473533590284892225333146702583719733975630943590273986555368506370218676245108748382833407310
math.195  = 1.00000000000000000000000000000000000000000000000000000000001991364888915565346286100497209639848475026069247115485759548899344036339489970117724573424583050073130581872077802010819360620279053321536189112319380948202482225986046715384741279269530118471321573159650731022647688313923306114581538502187755406518034188565264278862295903543133233970279167709154758387121427980449915478039760901152010952449860157214556258452588695438599347417123115538110106944181946284825606350204820949778574826551248637535561522664659739395445912952458271042142668777828883509393373494758533351670284917229864115143115868443306541279026812764466894626602058126792258954466105604971193084719419337378478316432416885563631210722201327074780156993079290784669012754636007363547724186747428067961248672263292382898014405031573536335309275346071457014594114845322886114201923835335806684549091367867732809862921047859725735781895016400805446527270541464009863249494803194819249122747129713807753740567779970936188229066333654761163456949152669565117550900383406533816240631
math.197  = 1.00000000000000000000000000000000000000000000000000000000000497841222228891336571525124302409949412347437415064704333330910672015260906473117282758412555015661574920498476611507201720767639256397455549033631666418754969573240407039368382482623156394483979905574123107532368939475655647777742413728998656081834859958015311444747013877211811559210796101584921333819140009927829077232101798127646359663927650777986563141533500415024142688079915591024273216328821010720728100610461448036154674197952056455900617935626640322632624506308715632175764583899462930874289916854505694591560518549020863224411811944001851373202103883562113453849017524771385214041866114841400340982802108001890909952503785414868210986181792478613353147113457534346800592671445583072164082929088450835740836085238138974462575653375814195469973622086777737425988462102315684885382145725557351612663832263437911120093773140990055255733696307178500045245601325670050917818208500140372493902429629700984861533725132121027185098104346047411449696252920648879047969031083465449931244662
math.199  = 1.00000000000000000000000000000000000000000000000000000000000124460305557222834142881281075602485941263628254131268627049054202805442944543882644170225996645522845213015269405219983455280803078578223271986614044486226322045484902881382692194042498369527870024911055182393762904107980034793516876298337900680781076325977999629364889771039078851921236103692474489740332969426871201651091157945173586678131857006439072306528210173487651252736456938175038944999440302864255800265937219173356342258200865919707783272321857908048344509912558295576429648438119446426702278577167881619871924031828670448253592716923238574396754574969461462087550631549031113828886987427631706969244817317848311854538749262433486366481892129839787327984597818312491048099875178420034495395470110630472824319404491679117736001033609890416148093320344794628696305426173937046035120496731105749922345251396892150255206032919919529698442451669974559338495799187041823639213161723001125923783870123138499348944267436029581731657313557127275108013737209706025436533783655835381149056
math.201  = 1.00000000000000000000000000000000000000000000000000000000000031115076389305708535720320268900621328446659163573382994952989089132155992484298801781224714984566084479801214552649787982939220606181372015568161354459264035417834798359978417790823118984335265024489329344341932395470885219236322643005821566183883619311380108337449838225807958425696670612780731168058671434782736294546045219607351921508217025818275009027640409489152821378669619849750071103460856557710397044279382140138682303546833022497849283240365951865937481106910757313454853656391639995800478977152360660055095654344801363167945346672397028120920106272915973283044886230478091541831866772470996935850618800246719197322726813797447274051679484112920739481626355309187822801318049751633903426000869637683929804738027031476318801031296874212654483964588811132219264761843953266965329042734641570775767322591378615254027117822521302732008951088287137917016895826164613991235082500888095135197960787893904192704134472978114358205613199518142240957566484177995548640503479866982203714670
math.203  = 1.00000000000000000000000000000000000000000000000000000000000007778769097326427133930080067225155314681748357564519730759440410657818537640398245419089448602462039463407114899143474003399969472189878346252281314914663355192993905653258488137820619833868581427134116105325251803169091298974691747774016888907582168317017142664013592475462693087274201447192580575388956667085098965296851342666895181849468680207402816174794427971237703413631067828585872066456475958633199258059977108527160318182542254883658906458180331444322891927826608486617164293619775370956725561678412667925738377277942480008264561156197957270940381885656131605849470952488698454035915812573922341350482473340082004812674869174502759807758049641706054547538250461256858299799586243388981084026055457973587156146249147506185220051687058007686580235454423588674111941185439473625579156749406222136326066351304503462970845948548828058138282774321665785633814221624130444933548275091417248924596468820493674882173043054697599702667274487566815333641086594414840208960947652134204470225
math.205  = 1.00000000000000000000000000000000000000000000000000000000000001944692274331606783482520016806288826733779707910149264025548317393195559629785395346824180646794467965399665938580642313703747982744633176713722708340958181436220302851400002709081898974918681749542228345352863225460203730889073165056109439702142374682836862874480960150795190363469506470984428993263282505988497706867584190374489375679236064827302063337104744416473032162160516122921114958837621035390732945460896584442065548919189031137567429872003863922433259651036150955782321922495158360364190280562075242968993266617496432956346652302620498043012139871821162184702678084495506923824635708612876537213995069748462921727342780935601063537487201263444029194824077758772454813884326672613439889112277973268940512281199202688170811333534380853211687821101833370871445206040752901387333879639060345659552381639592558995503878005638661459336826259777656861051399563637081623402791253633357775984365118959668452038422077048318941463723398399060627496843314353650100441791411885641413545927
math.207  = 1.00000000000000000000000000000000000000000000000000000000000000486173068582901695870630004201572206468260773479650575043685775388880442622535392512244198813523288659587692263365708177054466003614460341440843560783383595896348933803315611278889423018193658538364686296797359577803496636007154512060232477149649869207713030799698656929976375864057532122092523341764428017357365370079478077728477358270767387633781980171297873121872099146271512022121770862520461187019471554315077704667980517715993714973893995670051893541919573888303395948538726011771078486771501329700013568151552353680726607738739502874908398148034930718270854895537481901189418668838503744171177070011670264926817641963672107787156976491206950794985682621345135778374326801979060776592489148656269842100580475238435874139254591927639641281291745417293412786243969488107602920095805192923041812811788548746414083834729044060744861712939012446304638940290362355900597967684747455426465837809123633209949461866389593965303201327852323000110910681257666208589116123775986034120553572852
math.209  = 1.00000000000000000000000000000000000000000000000000000000000000121543267145725423967657501050393051593155842981258561431732410418649262687977877692466614287630973895728503263213343677487413478806088975520083214151103440117367099564491531413457255768478776529066950169661258919149618709800977025052476099393316036260299836982823742174840242763750455247638468405214362516617979667917022381203262972194880566281213361049464616706666265967812165960856523403363725972012449548461554723288562924854806053986905170973625205911152463447526692483744669385875436848035919622796103215672443472780191794535554477480429463515049317135291775579128591352779867563207364079354469652736335370557847036423885378223383543694573710163896213526421154173704723582602420972692295388723263284074214962267761916604203770880647188226184136853962648959532708386208531789629018688101169272284087403427308434941104085762190962256824560835768400269581608028222633242577180939328104176615278314653496591280022745646606824764204590789722086279369000613748481761923516822134253237042
math.211  = 1.00000000000000000000000000000000000000000000000000000000000000030385816786431355991914375262598262895632366257686408988023210023031393783754967307906382266683663497927881760310688739191221356119199743250481449706587106243618922418653974173519653994117753300579646080932088872745789100917316247667523139865124551854978188590766734849651402044100574921743506691023244057813173122106353367634072906401623934089712051778608052499342055443035424603673039880066398598977544255543022809753801156322672979209725875508785153152421779131061193166796386070183307565281036161624658596226555655428365421194154925888592864615423883302810654316809987885223905152623576806893772080587273018080078882571058722785277853007894105274914159356960789523841671240141006248270103806158330567746780666894954695056845537109541937432400149411019216310918709856690793358239768320350909891525270822636706214631785181953308520102392802889622808469467454317583509085324869726757577310395863896074095181749828179177405706974472799975197486809539133642930853905251892201565177120059
math.213  = 1.00000000000000000000000000000000000000000000000000000000000000007596454196607838997978593815649565723612914399129576539238036664700888729005883615548418147427026870157478158215598782155132134842110724612822909407850061988781590211319784480689303127793487853526175800868308194663086984625477662819544621097063252545288524789265953393454627418764629715514420734574060422522549539497149384068479203158458734309430316311233033137939931108212037296437509478389685891425820880838964040119028624371668043190424784262510078459843481225030143042220803825619271306909060966152235174525509971905534024631791849728668531470385637347522433926496845279791588944618360521689721884596363744919299167705453914419060220085598839425486706239645411633478816593964934703351027930545163052383757661118840320420732988819093132076943818206824356874179870445975894557443885087288127495764612897860718285330894670639801633755959293908981201510159851552813301437553545601665669170219352128056066320367476512307689324056355579823913075409654352714400873450605249760042394336698
math.215  = 1.00000000000000000000000000000000000000000000000000000000000000001899113549151959749494648453912391430870431136972169056168646295030825855618957340202840840869785469269699512964260507515407744495093612522245879794997230707909597953327900618850925762628054340988061548583468168516424896908214492414787654472632866903071290855757951574834819958484938502078722755557984846276668822089698157901986141953636739892094806760555561142899918600265713997555019440179225860059879780712329889677738089066840917319322472683991161908783398780377409888880599324567392094725606551879462364222515835747069464831713446443661890664405325318154538804749438784483213973468412262134868655012949214545925665805361576378305488434844361276102138575457780776250464082287733652865810663551506915949071390232668269247531629969285629622914421728253866378547022745356617942391315217529765194731180103920269360388849891330741559754009349034678485139796314343003792878860925870549840885661245184355129100622799149157961863168419113101874927997349277496617097740703338849846932324696
math.217  = 1.00000000000000000000000000000000000000000000000000000000000000000474778387287989937373662113478097857713963621708572810859843476969144321898628356712654603951610111851175395149272337131657134348558573581239464598353262073988683107368914467620832237401126992365600225944546102486806681695985820216342632689117714956422876278194387322624929815607526182101964286509546674041093006627370497012186716133177853312158752554570872348478418973264442907934628626917289219362957803243067013820832096153206569740966069058673626335602977014352501949588866254381645126264411827538799205189669111080746189191551543622328175321358438723427100372513709322247110290888974612545702046120952118232324031554240866651154634785138689108127483001147968881363150084246716572758142392372336888076710559728991864641220695053074322277554181411630856965188780682864296794996524505342802266035261847299512549669788291200786309952051899277264553083506874393828266637283514545485112730192549296565118596525308044333736503689009005433361385502379261547908414657337199250030203809023
math.219  = 1.00000000000000000000000000000000000000000000000000000000000000000118694596821997484343415528369524464428085998478868819028036636266107905311321944075613719366146026006024800770963854115079000933501372735213537815144332739406419751616502950209843506029600492777611973169976118131603979133833899064692263209178112251019626227353585009231079931352858197289014547318472231643517925508069253628611937320074748681596542651978817945679158100397929294293012583466942675205443307559638767864433754782446727278507572789458338994492978928740131074958202235042961019916984163612738383279769686651748446758538741344662153040622364866567349698491605535768785470984253123089652480126713740490974278688075065497655595566495442310067552909698980560767096384130778283111440149486553048798846672117019667224602748347952526755434698482490707772739653181408418168417033468478436006420987988869567091888651887975264070819609841290633633091669234993818485056681162709506057562546597077265476434277477304645153069983638473692248272063720181426699795122334685177015099917039
math.221  = 1.00000000000000000000000000000000000000000000000000000000000000000029673649205499371085853882092381116106976509958797828791795355402527724681460571788169435174918198590475065114919536394844809112912178146724709706369847123127785391303346334281198621302154760303963621195795561908974958720067701307425374332351549575040735201336910022748937924333933541008407365293629969154381403574745789055616606385458384672594740705334687298837140157746831672112093449279268036018070303549578714513200291859801356132846996785127562744186054520799155675187707380581683163317550096209285670645502932703198304335078077377909702305675807378789040501016584875158918327912389843326899627465041841867446539556544930488298734362325104386540208112552840398844825829583315343959987013841616196234921302387723053466056416762935861173333810200098255582645541399290558945816470653653202784400600743414177618875819359245909231515319748617319151368164060710174756519908152062894241602715839657770544339612135174989921053725470140791233740550837963008017109881266466966558685510821
math.223  = 1.00000000000000000000000000000000000000000000000000000000000000000007418412301374842771463470523095279026739128638486193201813971776855520642615749122974302981560802441726897984440871368090889453339810681521607090450065522997110115197810472065484191165492963556018800507817976986336595298011981216407666462221881734824427653454802068238493640200484449065927172570106716133185680972228469809706229302969481451599719967514882885693255760926213343281487236663507603442939896477501247045460199606947097964833078293332211714333182428342411223990723437041553731646552331842725426842372832916018509607714670249111593763818437777504217903596289794061832032584878531167012149585259134620261203472152273944667593868824516568238016161374456739936233311745997239133946546518835063821994357037303729095578667994634433742523990069731608451818857437609846164202814470368828811822751986499172712868374737545565552332468258870535559309807425750983515777415758910386669631554382492738466802662403046845339317635245177660838891176166545350364295749113839576427943892711
math.225  = 1.00000000000000000000000000000000000000000000000000000000000000000001854603075343710692865867630773819756684226731708963411994063269349914802686125257334079879321142913838374879212618312991917150360418299146143195321598544818982122679189439545164335759545996310349291029896667981079262915479549864997968067266219985388389986779085865809473925383239713428669935693877427870564011486915185064890536591015902557014654909503217401582683394594884017342855393049689756077875942547252139445572021459474808532275911888817697617619321763262733146522665311562145606986132318970653668044188225024368828788965313572607234975037867335808539363708529886553316083901893811850731619125938743135777123873212499639019869888251331927425354439787556380860964625775599144420257891395015326508098246097215036084345883684140893061621279894798508447370021575950380836993640321399208061252292324182088690030671014172342024675533047662385201031493622208006603370726566941967651760177765264785498931230203861970324357856346233637307096502997449001191709867146508168730445599427
math.227  = 1.00000000000000000000000000000000000000000000000000000000000000000000463650768835927673216466907693454939170994968714731420947468075685932010244823628492066212867706196154948285114324960465675967863213764577339424006943726616098861909458609553464219851085010853399815711452383101726172133878904163880091176021006304244583365621290754996845659154420549987312287633708491012133498207273483033126906629448095928420588028821763047349412050059530807572242733883597536140992257745437235948375183082280514799674496972579127640548961917832316036701330852541650327558528201770955293892512508143765022843239857405331549313133183464458766826747242899365687738027029709425536542302345879833323375377452562267991708905225990894663265965768961227775569223288065776418333343257494506953544392383269282838371131772471232416141820811182903744610592924273197399041103662911070614273770198303045445091634861174981194570439463456637807146879875643586658246338724708205367539817999302454749264344233413528924726798370852189649955437379719726751256968586221554999786093821
math.229  = 1.00000000000000000000000000000000000000000000000000000000000000000000115912692208981918304116726923363734792741885043959585008972825404644794903567850715885663879998903839154647272204340113943110962317533343266711462396094446132556074890320092451164682810299487965754861966173209730695760297983585714600923870377468167014855618166653286607097433150625853150662933908514721998562594657890337985832533212579525201930107378945885767496242716338981362731436789769825873260242649142903955466355959463352467160461783545407537180759806326568701852689493458642857992838814428348460722647210088136038565275760953393972925184786365046118620204303208078225095429566979975735502668204860583311257623871766901607396766878125153375756655686072759312096155149160268256630489042439442702373375348184418576327618898686368033693111223685078693717430675280565118058468995463962881282118192352620797196280046808565414091804558659804072743512091026869991807656850757699382628018287614930595914920387474156687022774860774133916562857373143006577363135999149224818850738374
math.231  = 1.00000000000000000000000000000000000000000000000000000000000000000000028978173052245479576029181730840933698184709357131755115810518182623639691070825704410176548322659226499783502782595843603467176381631770503256109992202988611935653792944196109422003379146644329448644735507147769187412746388215981464527524987689157843453134207006425184590475202165568450068575882765319808515768271648858868789654310363861479278061178874190090986139387183783046159068033960289063066977143311430135207044713553600759659092687675626267326307081383786453059480046171134266595532247491335663826819105967720311556741177759229361831565386928998075633561061249430323352866550801090417080687795880513697264376559726565506711684148245653851024142543500560821680774197638977200286383481111656995970057470059976922004669112638574547523539516725889400514170380379766875593027283445654081537623104165471281760125605475759929900738910642568087993562049347414456021061633290656291005717346071683569027104782806072795154180617943487936150217110373274831726981897294930429264829101
math.233  = 1.00000000000000000000000000000000000000000000000000000000000000000000007244543263061369894007295432710233424546092683298700874904553082485071254622634426401849024473481031562537081646120356319501428320692507193938140167766712578726031316890811461894234498770150038018213815032088408794074950149246808015549846159902524940154432966779214056693376249453577092886259386912332929945620109836110133067808244767135162237453141578529359873184834182082668642922248636977846301515261479213334510697731338874803562851774221541412218867228916087454108109865774021988179266769984785033407923314237832932631566156471036949082196281537351355326606423667204405845329189577520265224591646141311528430638399231462655733376400460265489776603696884984717819744156240893737591985427009900005676792638090938946696743962002993376869584036293773883424709374081115810685150315912177656641445653727471330525098555825301153434004125978161074957812989461445686125357829182052059515240523076350169171435878399956246780471416993659451306443789214935989884650701662060472803322521
math.235  = 1.00000000000000000000000000000000000000000000000000000000000000000000001811135815765342473501823858177558356136513764604204340498574219157841371511174835642433517271703971346709028505817990837657758106775172386600360997142302315423133116239839707317973842012879192189638259501248583367947827600312197235433322035752187936643112284899751015832045020803548265593202455568194152114147494362170005671771299426782018288547024711215516501748370203149001396222944745480992742130597923875429977762864161397322398236892643485734640276650243899640799841108488143134567085965545872021466969315805537875455311226525925697369605946120996243585492772402286414420366520436320605025574490888951404867063645361506938785742696686756668040027155616056227987297930523366165781429046189286536499811001948592150857134452777512165180601896287428945125141131240279967624293664179294701780510078839070999281014190587263009147353892056049366088411657214249365248662202565461378766098788000256159697508370929379589614219753579824299555910519042829911554454887569098307054860177
math.237  = 1.00000000000000000000000000000000000000000000000000000000000000000000000452783953941335618375455964544389589034127396015443209766025326849079631867606054228316550438924811633219771115869841334897382647743779823162251513680469532432897653210337022152755375164813884854317374108052344443075388285632797741584793643878190547524389579668207323126997444876715664508735173319926047043785742129760882540389031978110804114191907641240213108925363066564446700542132856017301778478537143773436191815152084090574541946416676674377345276031453826492274108643571319503639251308851106389476216961652674256247448690712054367768342564627023844106970393123004420449334145864188877270880240165130987758713068977466309999479325814050500763802283148313068233432961187933193314361194593070979005641908475081366906459041845303730508553057859253622717170472617030321444269363158209562978526835053372222407894481679002579931016435640156360171794222624317409425442007841689836200568268399473831424003028347801074037180707635611677792327102414201847076536694653222426475798808
math.239  = 1.00000000000000000000000000000000000000000000000000000000000000000000000113195988485333904593863991136097397258531732877682149623882084163338718153636183028612005782446264632381344600940091657449270765488940828922931270986225766646768745348376510620132890825149661813288205218340382695888090889951501124801920139348576961732808155766357683621034595674632512491665952459810720839201902227709506252007361555238789890482755734805562790122713214050514321442529605490784669790104749075039562778936570765097156316235568453056235152909325699206082146965279853681090286967611255153076815251880824035821455059798153765074160446326921535431231797669473207699398017287603198539243363220428281239215541622073530277528405857313091793404390352490043128969131091036186186540141589950997274929407424187335039616970906172776399421175797423687726715216538103440830909273340648165106054874281832866966111018484213818701645152992157728997238946536140311691187040579968887213267402775912633418009151147446113250807606776695702513134543776873291621981067628649590231462030
math.241  = 1.00000000000000000000000000000000000000000000000000000000000000000000000028298997121333476148465997784024349314632920316511798204012271313175658466732340142365595426145253724607475611268526530977252320343248345078180173176364014967083421714350252783246458352410578025418047295537890668685814578418871075460968864112431332383795710913378191362648976877406879036428863367758767958470863066175240676735272795667148171457756088994436477322593546430799676883777885890388387355480009388041469527154916875882114458299538041357288459264605315586536996659367965106826253680651710629268235537820454704945252968131902723044427724052089305485411393601239367066913595783914137234717240330101433759698475339321295696567799919995555740276873137992561445856337913107953153249508754040266218795420339291147239093532224571272902346258484010765320614796051335421894053669305102093958674050268991381903245136329321884813645748264024548466048900086394050683899261025759255259610750378364404880297575617322699128890077053853279867291999385406669987073019232954592946910467
math.243  = 1.00000000000000000000000000000000000000000000000000000000000000000000000007074749280333369037116499446006087328658228645471422973007706747442912276553555106138495949179549950940912699602007164546520125217486051666503126182760382172156967129015693057902828662887133506970349304340366313739886903773844213436769065210625221054649790387593868134420084733823394492567270722553157974973983645384958057354686251069053981111567127092572085067689155861266384185781384265603606311751332154158572818051028153222040224448502960922814703068684111952134594993326177200531867451030594978363432921021595845694428451247966628390936256426990788110821682838379843195073572544082799647186200974813153228528037317033228004582986482296170611166403738211702025942867555548770730950818526946619188248707894678381217315120319553699677685789849900956888680349896002676724831231233181582875938926230217098800354084653956944779708383930441955554495309333336370277310225527456466775053864834076984645563798734542669516103227101699432634842922885798594545771124620874073973239319
math.245  = 1.00000000000000000000000000000000000000000000000000000000000000000000000001768687320083342259279124861501521832164557002072686123474664344543950031419211397218407552125076256378629316149909247124526163664378066722852307392336276976012096316053871206335275733536363031404035195157347131853338879686943571290512538543554502635241719214343227958173888435132182849512172592924076076420010008789753874680513143223032436052992718811903970791833354017324820095330578422105607104082246522594566643247051835574917630700979215167404987918151240582135734360912094363385364814849874978319527591195995523172282987101910409597041711051578615700986938466465422390119367887779294546283697788029259533753567011449251988693678629973413348207085335129150508632470987821317903757451280219842741443923893036004965039893639618268625330219484341160103384634702876891383488193339912089916239309167701250811687679594701602521578275801794029942693824269259949417056003984532416905987247588385184951737456635858101859191148584546105083198207981553702885341095313006875724709424
math.247  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000442171830020835564819781215375380458041139232818708239782303603656345503668345178794515027115376570945722725493750662796799998931488963439023176935168524267183291048558713117771483561257468660415217959177092748181951079765452368834077073727546878568820192512969259886055397471329642804869280253151929109706096702119654201838890506789692657349836193892041945000106580273138770960202600015229583330789287866738079057473355403992810937879424630980985739205479133691395924863289624940394899554521904570233272196414347866451071110284640721752284585710993271343980786558186134797376666793321712203588134941998963547939926388834014971560789062745509030724432049214063576478563857104312818241726769504029720531687065085410735102486913269684760179842795915387017080573207191488016134746185501237417674334357753130208134554111891810463459546446421945951472503541222303818679751076971060254142228343425262099665409071774653305020551575013352974924416905480591046614478949567197932941046
math.249  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000110542957505208891204945303843845114510284806238070027602646736194126153229987236480323513114069829085344091542656751739783655194084399896577785930917061624770827958099649340137443807500173718225212344463920783420043506446790208208398349435559806801596982434080250267379320601551655499695720284768923607002555227023442261857806935099017310719803813803084772251261098987638847211944526602625408752772165713389114390193307699520327660687489386523555499634009519362234734493076246614300181141212267566700597029968314208685724556594867657477868959964955508763666334697379294948099573778132053747179429494616740149350533608519051944834579194543469042586835341585731078041854899846516373957397998624262864875726299647759207992973355091397545070488824115214065973749506665022710504346102006003759272036290482072711707971255323081570809260104882680583900170433111977341472151160422830229268426717676442659427436691802522325914882190384894741605826825936408301313570726044315940279578
math.251  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000027635739376302222801236325960961278627571201341005614418113999079647069120059178669056265565298947890337285035265637121809522356737471391813921806982123844642044244565244046203854462272314060820482187740149755593101641309271198207726524742871006200920234993282569863303305048615807800400145407631226296059613079507726968179236696862372883888081564566622308903906913120875956907975449927949049276868920025056001152635143956874686416335265429469340514669387931810879296498747463031569082885899819008502736528999044356619366119374288609219092910347476170744148648291598939011170682245137348112237080814417955241030231678361753777929232889936595254341993206952036244211714880256618848461656231353815287977583142231411700437015344596261671569140794529087084334336232064421105198815987791944951131829548686304597340402909617331277880542233714485746393069194464071575448252788052611022199131629020948279441169156453188700201563550727747254275859103943433083419310174297645444139215
math.253  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000006908934844075555700309081490240319656892800310972304439800979217813492925856171729366079765174122937978033892438307467604705515977198424036755662611182286018163346618275013724625965398331689331382924698182485261826063479617192488216650993781264212036269104453726782605645428419857188251871142782508190975116693464039881431405610196455888700719780199506865266925227505150592319672339198159111790735865601865780676699320811329958272732913737069647846879939358583023848300012604973344830672442038957676158795302513601540030065196358154926190742530437967232637696907638869228933171408636307705101291415148179437808766184841709426335460335902142075352963013500198475823011679216428713620811955398616798075556267786859951539517626030054941625076195415888270704561832169225729286820476955999942695929280606490456512026505123175036485378982983878677440186920986774971163100637948977025230514324135743584480540890296509004587478404359411172972386909151503821150304755164446696020886
math.255  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000001727233711018888925077270372560079914223200075045398424980520298664676081002043328199679295873066557490790505871906403739874284359869859088969278122404992090529754341820059113721650066795698058114776673306170547668880404439558109408353093947434808167281236070580135673348007248432213173481362135690066370943946038879085444014940670336382233536990978858357544261853739331558855268923978998247847386947079526249452744417973984120686824948583924395705622004646002115665577232279978442368826361118853942504487766496555186192293815213420013785345254789778613380405951456439427320439268708606043876532456463824820752097988089925188152202496037674067774300191219236692049448795995415032348430447818110792313671372692707186129044512688816393775748160648994636832417560791006692739902798940033730023853574198316182636615060057282327748013107750824680976729951042251556184696270031957036659433247562666596560800469432504460879227490760292603421156141690649000864737429001301982815772
math.257  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000431808427754722231269317593140019978555800018461607641248494018467424892421404115621808507931037539437546658040959365840039475527244577659917989239786094306949847422446981231921856831074747224355288790215080655981413824820121453966101027651663091885161649761370446448582748971483624651945812996312963339036564162840377250352220713724452163280301554925995643313606854235510403214497541918867760250377634786675160252089262578127493772657305048951354504615193189276825638762087474080359845138536645170036804338905455231785823996621212998972450190519774233905440078686780614135565324386361009813339143545715742790089394118327312365811367388826225474321565111320336701199375688731435655900096354207258863555209814729465616281912777562136606569433240141440345312381587478234956657933197820485673912103252371150464291250129524704603690244715900003634131222246930596696773305759928831653289256075382291549125835722216332053480666304811225942022115032795709690308270462428354446474
math.259  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000107952106938680557817329398285004994638950004582097247534719498372551320013228332332112250208382556238677919031109054670348291649385174334277119760961214206981284741455149060303682903262166339644276215735608084096072302832869195951422641479884253707330934229012190725644120283365729628774134462532121089645551385223292122558185630654637182873540616357947029848377955623842330196818417875427877863238212142259204484563066633200869331627614846427761131098847023516913364526601501949866562736187747843898223497787989114501793014462824952321142581266826924626999129688319918309257310665435637285101733945807367439338078756750396083299276201953099560461128068516613116921386578706021188111232858313046805486893192892464090165650874083825400121571071018446794976109353811806492809818529512359582270840655011978173621836149425598133128507335102001863730967531243232039297182537202553079091876353390741068649443752521229727505065417447377707420651615658026255475942372716296884740
math.261  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000026988026734670139454332349571251248659737501141823793797301651677103951881960133792018440306802641729233036752405490403791361178519652072578796974980769297564192294059151633270367524341625148212467242497500010482128112743170950638388511098249329333942198596927784956713312011109107475116840821793033013295658054108968364362358767385868987414084793472647737060982883797647543581822458324229982981567369278767974171268175658791857073850068739493302115932365115221720281059529592353508950682491950274306938826267346505353507838292974986355282730679283668625059551997993037285505608447405023031335024172009669479789941278241191386625057153136027252980963799893737516763836565038267339677420919472999002213194493398854435380718519987539157226176150105045418451137261794591721353303112387306691677424157208481024330075009477712871477212998807529202372843720887821638762656326417891371656243887712022293770126929582868925619999827628575465011704163912294820043571147183506113601
math.263  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000006747006683667534863583087392812812164934375285044779773061165928605557068118151255630299803381576372306776308767658285539298210565946394400549644338812488299736103838974227219395358050707938454340367481568925875891197429444719244785526825067744907198299787830758187398861091964669873158648173967857564685781294393410893987407621011646896712623191555039225497284938364523320358876287375114528047088991227522937825541295913730912820460977061320259278706893635836840942325595654454644531760426873552547504524586037467651571307588525929335413662629420984333948882808699799907281850121718123896347423220271044693802552482569203664690453908457592099881400359091444423794373762071976992135673795345651414123255446579620039374140394852327150943600437453541297746329401073138798773087958046858367246268597058031324452344810556505237889530793152170157755199823875561573019387618279585049658316320921380889389067460149958629784941986542562064080923935224856690056611909683494467599
math.265  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000001686751670916883715895771848203203041233593821215509534791486260965785833432662081141268460653143369676686596797978895787867657116159435364755384419497784331902372692574239783857177061616811652273173398178323857400039381548667495294375848314157432540338360103617055459998932384406204165040260808104486279608934457173535651259814795125523448418175320635734219834849669941589093453740453777964597476830833801481683675114429503530270040028012174527995746378357355682823586912709174461554926584051559163367161193653234879307077433804703142467285422412573961915142275714597918077780760840113674916033442036100415522729361866031080050045890838393136668231250191834217237830545126825681868721426822351929833042860172398943910207362732462760561295083698872582308943868336142587304845180315632398610862496678850091239414900690721576095385370478351685557976521246986245404043477868906612078141989178597195693591700948023566657298009771340732155709833065665757848637886371061536918
math.267  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000421687917729220928973942962050800760308398455298801227200782096220823854625179331904877170847402620023347190460155115050459008896858763793955433569103463219091853814552208529813135880090215722924881400061428104464422734876489309631824904054288918167285933921113795724824104082667164046958367478703760531665294599096330608100044736091577360992586546226655671413171337179057790316061120052867550284461511454790268658316237796473192635321185195231385707497459606475656274923231775015997758332471896022304588608096339612478696001649755176189631274863374380804135174720074962965408096097022987623299414089368734463455246655461502813266880056342433293566470265427616385916595191512156994534218342081777331773672094985890578119700546235095248489140154424700638929460671226609028599443061709444346510389033386953969664655294168030653103983563305688227443465219532428020687137170631291467227035966806563373265253664283786875099719010940585689601768703883708870825496084683593766
math.269  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000105421979432305232243485740512700190077099613824136289411630027497359007685963034526603375227789336696839542717764031602343842078633962682771574163802815752207524125913985336402865053085425054979637013563405252272584954860993559617746787933334148215440841051757316951307150048191841909015109001539911149354498188474770588979123106871845403986800486124670477626534765146654205285964177796578433996577825706276857745748363284324371519707911573089826894839287490930686996816409811898997949820426163228922307901727785735677334786130620894060073412198159689876101752662358875835535703697986159216729771677530714064153038022712369020679456259333225194082946985407565280002088554457758207367342690469995114350447264077512690608590925633809464437283005766452294371713237898513336853091854945405418695855622917308488575534418135532771170858831443375618051425839766055121861536415653308796478582022396927554176078625693252764769766016289735628371021347567861234215536386564461520
math.271  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000026355494858076308060871435128175047519274903455971403754178007256801201258120558820123357745935877678868865246265664623635990650841836046442464623226601389916104928759946638440265176677951181439305283667068438352530049707994688502148161087522435784095269716394231136193492093742570874085126945873344926564435510266795375324925629596380024873745801731485511163217832287604818495270682665804426554848852196923055031478312894307129333043467765150067186950324146283341532178647466002942333673044934251538253689934239942823318992174026273148619603845763633391007735915340595544824142753052829869357901569531958444595647430072442599284020078228667606190722399676715872988233005133443255596542394131475070686830249872594065532912465173661552694409219779918164277169391073038816436625044142088764118443139585453883032199383400731406498480852398607802447671664462485129899753421476202030711879712133103596417044561076554486260738892885340981706981472405722229045552285738511407
math.273  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000006588873714519077015217858782043761879818725863985887760907890745584905796377895282540761422308795155310770081847682480670806210708872751107148512817110256081388902960458539686722552607717409502246417925278168246361565059942200214358766412274335252155945746463178434410532785942139867945578483990857764708568133983139989330674497096618564774487156432126090113811094903098826099433211516739537730221178373444719733872476236035801252635158037212175870595927682124682974312203507948024469344438681865018200504542216983001595246734366154003127424921299788587733286718664490859911953527142667339681841802405756456012314366046124832284961911248936130103298988335637646974221914986975504285339834716400907461573970656282804741207943403561582858095674669720290340448448570185774814598628679214788430290424689645894574720265369016898898978535310648171109979118384440297013734756365470899901072524359218887565677150760031659629042714221900008736920498071877612295002326470418963
math.275  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000001647218428629769253804464695510940469954681465995698253822904789883404835966446662644048242428810593585886024936305681397995540651250592254444667673545881170456624775215203667177189469701520451806083582208127456525993431762162676873245563478261707499582700133969011915335115525237539567217722248348437307009646559942323388277098621632407618749366919437943229243591385485022955646535605285299012454228753708180420979630804645033530914226524503667535664813881757913738416107226640074645708605234344207695260923629820942488434878828761115379863643127129146677897532084019046327178242268399169095333457421089678513309978174256203211713669534312377827214993831523383932844563174618547586110343833167965287395950916795387242450895400837775906423196737357139228616132737172282140827906138231432996032293095000071106152802792427222892982974413007774739990714643843286220498501749083917721272457429995021222818352114445330799772036059230964670789918430039669653925200644963902
math.277  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000411804607157442313451116173877735117488670366498838598299718653413871029755164203665953207728490630225369310676732934952569907241509046794264154857433877890540023818563204633496488521047143421193234540035837760636982970685981464178213248449533640788555505896735768535866238396672955974170674829417402864904890679445002312616577429637865561034249257104662337371319518571467145441631555918176903850791226890441557714317719691119593429407963825682604915462063557495006189264610281390159318307348776317744212150714405542350008628005478060371347487162865450253361700656095232649177242078001328441594344962745800901023024664679112266527311615172278982888123295278679968773817804019754784148686939826423358373900410896774304617399763293349352797045679479331432261472161333975059928338984576546283781369804564036040910930475013328882882046128442178873452306258271518740642349311140782570557342460832299539514217195943376340921396417365847156034554380080470987724492577994452
math.279  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000102951151789360578362779043469433779372167591624700097890928825124914404190296888472840182426432294646371852714451254013978233790325788913130838617207426259478664365314001833703464489766669025630788399337622537909430625325109105867304420715703652861596388580873348232075055637370061511696569352305694654515481552592020412517301515082402144360862770760550132167913203319686283719410598582006357260545322166600175384701253744042864557237436571633702852727818489821915570473907104223338674223979601322738081460918722702891020773035488441075988216581971700239884441246398749637372400566226612418267829651854212486307674108540370800616451278826734012788313946440766114610828699868068933870822085609880205721511859344723874566073755978703453133755542937113442176359259407294507246061603666207347981963192198626619324887591759408667508219732924182243889758299513513885847352122080728785683698774897178231177695910898132782094098994630808710786181233090887300763304482834418
math.281  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000025737787947340144590694760867358444843041897906173963174509890922500450686630426291153489115194552449244632079210776537715236225809125083892120843982878426693785822059307341555433951834276455923615966443048175303955967254799795771597105014192468506282470297848188291521522194472126483998007780021408664783773567553067914517287683013935902673780483010847092332882526909122552383793475729993933313027811450754220567073735331061566986279942746024058779672700395257293595837152095883969480944262024583692387066226645420725865802481883574713498515214515738538559031885055902227943113952541972733918495309448211723642277425332194456425918029593119677408101882159344353789543802501743431046981552482312149356225334088795890865376314267445597203040576319074368748321046560592784397794493932163158236688845130825051291424530168850221416432081014734170335272814734128238365105339660821808816223366825382163827619676294916665026397266608032952475507471587064731106624317229147
math.283  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000006434446986835036147673690216839611210760474476543372871602771024099762631552740369783054273384418199819923280007996655019638052157379770255640921881915003980415058759031415013132760165143408847119222553932243025256061268396323781295233435874582902488330098742575793874349302691257557880736182384793000334460534316472707028526358311350828889659337213685333197344245610709377350590634561527616638504428730409073970797466483854255885641576894264844157744029169397958128410947355458934783923884307094798877870642419585897793635622266263757803266566434947775452901419901502402672041281330975779610791860921144231352170010415044711920128157144273146586277029754147758764946413608970356451299912702559650680378410122141582415647975062271421002894513136851743971740482927330581953915678913294853294514471061144258507794037101066730335456636027935747323014652678345916424614008327864116352708428747363783013728860492916465569216469963186805937493959113964979611528000347202
math.285  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000001608611746708759036918422554209902802690118619135830115453503677522123986765422181000788612485396379122115976977901249004673225752063106006954489241922844030533830383276990872002615214911313709941393171507943965131732320786810824186637806918046381881027745463156654716267574286367516772394709335091439680089782403184365529072426326132263769633766889159791732032921787872240627998095099561251221449919458935859311830986581773234638921318287663119304657750706107018782591734529029099373972335264375814708038205529956315285881447392483311450997788890330727100757853609088428032945126475201474221609726286784374055546840424398240501366226851024629608998656346822805199564602061662704023250109328011965380388603709005110581253763357740150625329976471373218399449075665010980421587297085602178740760376177351395922767401939214364503388013755729466005817374999477278308571578809699010151411725641266973137700418680820033437811686296309718796969825638323508537577162346270
math.287  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000402152936677189759229605638552475700672529654783956073035910466213551366566604110645203709433130453403234644690253517962764840623863837835558176612555864964749287572416342960658048724582914122746792721811608810494918916454249725991598223297394942014319263437306952927885879315561042597057019341173743122833532944066806313848027162262399299577347421768927528530732884366926157743837374158448361069302345534676921439173579497500003716077850529973600436696344944644043137092728035542099776191381705472647740585124760630435240731407804885129490893706480505613730780580768834652511498365106381488192929590734653798612746623241242233845190863360560205921132564245317052369988579333446157945110196545666823278402234936906081736380355643542007858318028239959831329175833272583266047514931217578630830422852159863219456965793610495475659512225301087695304244759607822573327408818600467847924710136878218093849461416863189003496008872505127156946413854604662489672044632554
math.289  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000100538234169297439807401409638118925168132413695988856500370343979278993850011979371857447244777350409145509118178279060224648530684389875284029847188434016387115676994520234076765610736611993144256625552347377200208932077689037240134962752269504693374784150146470263025031790361190016440794527407696326546544928009311914318513766056557207649570789682889474118828549715846005455841234738760457169904993671660576526486295804427675968664514173088064625161370873989311415436005541700553143386014088374173951829399521040007048048768605003743956889921990425517291681579109521518104929809045327800692103299349627917694901324590350376613397552118181295356176911961578172659083074511858994141792224649633404179270606133850250717848331596598600779824688851527843500659729687777376462225419602085532493858367830179063184979233286031557370175808648547251709784592527278109894339359837403300155410333824690838796639945938278586760472330342202493574867353679269469783469444184
math.291  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000025134558542324359951850352409529731292033103423997196151914000153252098707876433921915100983767858906701068586451472423012037441998538604135219275022960942111495541514693710574001620150111144262140838181990448069477633272908624519595380392688652342360281578000584322776710937485048319956722468858683727171028011913902590576758431403313207044502103118422241519748645298609015682041053867391393576534213450326045842866234664595144032306220741010860343518766687705860068485293207465518277268751991692541908426771899040927548062324184884332761317032385543920415272362767691924954774041310178440882356321629565767878112225072740769281222448118635682683735156468074544683490329357861366484834002927548904067956871120526917363569980628840642947682769699163303181497677277070363287376337000572137033231143972344756071880133181318213115360059412907252237999901505814758802363052398686603882792542306287451712106242726213667142518115112022251450911137541016220861028679801
math.293  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000006283639635581089987962588102382432823008275855999297040958657167027730259788379489251080519746432056897700721106324042198285118367059310360331099837156162253409224003645737960877425835544392420482723666437492693018122152339098818857181275608487518295298019792841878770334166576410840802245592845760159546193028314860223167010822051225899102222031069914751858403904246165609548744687750976348429563781678997249820860311909135014514391390581587373269992732702678725092698134133809917897147491839686367830364634175168301896308143715656303389075242036886212491207549638385942591002438126562918675647616019260404055826978453699592115398992764281585761470098407745637624541106459996696910446055958643286342832532456436898699657287706872138270491048165661268289604208834041086147054754022935042750525568530212372135997862973859879594259814623478463933827337779952412160326831012523801723855716792452540842407251811294085124198844340916068105619127091174636534991381240
math.295  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000001570909908895272496990647025595608205752068963999824038348570639391899851927013873287470773495900805551828986217063616604614815899652587777003641043856787578257219919085140089272702694753552242712370002660526656048824331422482434070576328712366165454814351891657238951049508042451874602243906868968319494305219952196531312742205722510182919919965673317629689458046399458701071569774045009443948561840834037156772487656313230372324346697787727533237017415928192612583810703781080590155756156033729948028390307539446550105820292334143451458015251841288658414521259051786136366242982562833820772437159255326449511136604334133310781810950300347653121728913132043681191107300520894905948007711471422002697028959105630663642798265971015428738529959656150670925567652779349402470680144188709517934538096255629708891790758392067238566733375105236067900615953604454210559768291532423276685462891472962003853125360372555555916503608110056164815051753643410424140917789540
math.297  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000392727477223818124247661756398902051438017240999955984932576698474082439312855579541278879590488065644642396373839579121159416985113673542232500451819395380293056379773615801031551743266873549948335136577950792569205725320488092873559356308159481518222614333053024168113396120718535971461936444147449203307190119342225949497427729257743864189924167807208571902473957210365950175244351585498797671908991736000303165263754660570470109405894209882383240239328632431903459042061732695384118638596354383907137676057287090414392477920741740200039005315411703804882501409095590301594958818500555274823066652350698874268101957498527925728994947718957345573553602463581030732192029243286340380646346010182479407441946481488169469803896092733054971447951103136088676233390169448151054919981776458306615156781917963919650289257595803632520211760626820295093944168853233978573742929373669769063165679147119497051129248873372784894034635592565012567662776034807557979588788
math.299  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000098181869305954531061915439099725512859504310249988993493747956688088107198336351687476518591049299849283688951438084137408602092755429942177132913257591164568856391215711763746419455946257683223074530358981562362774490382225049997016585141497744650296700557915334406347804930527545384752625737583826031932475566428506608282881044841026730402577039484730674024716545014612152042043716543395972139060567297920734131378897182258949539037423340999020929076114486835795502474822764617193161192836331142626705503599988028877874930685466233811957972615383920496673283100622793819263828637466045423265549350903354838406306748724734758944459622264728054915061957898246827113525537206847814371549198374376409114414955321475540584372786411031993361673054396143884935156807242550387991247119070476824590993033780685407242910741620878883242099707795706456028620271520318186537317073607517209735350951821103421218461163694928726262529565110489921352020910790089561636117863
math.301  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000024545467326488632765478859774931378214876077562497248069059631624196193174042138677664329516645444557434756242233695054679671350894047295913133560309423995847609409164307259853649528559275463174581977415509113981717113509236900067213699602102883451339721301346899709354722416104896297141876567446639978666434302017909903612321321899310574705694556907956857781260347864730788925345299556541264121981382674594126057728714586208944491923383449295471700594136042251392556866353425922374889825184084728207043643913380840430120673076997169549591011947907933769102021568437149711047479349238174578684211237543241823576953555376891915017536117769267644826879619034446892328104943515941124746038232279317167928928467528849796891579814288818080295152160817002237064645893778064396873920515737327908547574900626765374348093124365448199154835968081230082156033342844759555143144846205690602807260303320647600166050189078554132328327009911396688589632404822677247576736104
math.303  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000006136366831622158191369714943732844553719019390624311983445201511846177890672540308948882365471435489634541562304091549432676681387856522017360385736951941029627491010505899428677938853173967940982998201626112041602958648833187683866360518545116948290941893312758822994948963220956539199674283886492966483482297853452424008030395545412908243154205050645719970667831422278755792550069444578048386016239046358949314970279079567029042629194050100100770369105745384874269670839391028037304940703935039393276636942321719295660186296813246569879264005643886934376693103625369217584698430833076189646397331078867635812123603797077490946237092530275187769703236848676531511746766005744719678339400601493903111258938842392246552053798662228573493820633860722734375252808203915176329485904496827846416221818427621812084732368271696502425029488437355809720385345255032212132109148273885527798907678312351059023049871521058098960097576234615314089341660832355750214827426
math.305  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001534091707905539547842428735933211138429754847656077992103555223050114427908357926074198367679447338809902602654269558356031464024491517679403069504876548318745181935331386528973397016354515115591301623450607187015634085614059577614885995788732631212758807469633930577553426365242249064311484229036623123498958768984526096128425014560442392871267429112296603015689897348960262241704171702219446804215640212421624783428499726610288670978742204089297669555504003233724019796646138035814223347511742208947999833892340190993007475767040803022993886079911738366753960405148086244460525582149171493333972698374736088772457099298118660128100993668132544273656012199836871589365662300953412641487542759681033767937282396886840898916831583431209700424640854670107782561048370416722362324231591809232844110569554201886203074076567871236875885573132621148050681625708679797841765043822437559532914377184927199117753116796670483638615745669042590176602738876015703416943
math.307  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000383522926976384886960607183983302784607438711914019497608361566327925268670447575833769344846803760464668899276140299236103888917930244877083663737666855775088225943444124751597935961995108545884669344002220730858704799382129855392945695644322592129514556607909036773989316374047182982323239508134345200092196609324899350001602956256636175978065799722938700559211580338478020789108753962975323977691947207962089987480235811932705389322273933896774569586293827433300619204943941828669969465122025382531362597874278109681038821661612431185414378639158938321445019577076865624910332893494809834488412471445731805776130724921432329442848701420045774472148890464036263381790066424370749686749953331456352178816467128000046803682410853399379118843113689185011759914031016991748997097726117747176044427573884598127965242614659894289521618650183569739798468297559027465891734979461680311528254453385986727258044355136319321866202963720204156393728084425293778698129
math.309  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000095880731744096221740151795995825696151859677978504874355698476089247612911318348882355642092686771210983641508174491963049996056973627712575923058242255517657047557051475063980586278735414075597777422670669808511483200893734875278563925193520383004009315843027349925343908586514702920327813246481024120384057206358915871514568243599715722208511883400593004988727925606408667252202355089464643132862927092084061697185063358291864182785473899273366329210469558567278487536534078259351947229632518170462678103668586793875119114365523012189075990743831911206540020320786951346675629784624075091057861584959981473964064197808432003416793985736530255358307938285135622532031649125374258451749894089602979517284449072275332813531660620703867643045900766410237104619049786794950889382586990297603409785058232267611523101332705398479736422346128842212537377572829811607515068132766679233980772278357020517742719367042927615654841646236788426591519515469807407172256
math.311  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000023970182936024055435037948998956424037964919494626218583769961745341491643796971101023722287739080661136307381320793263009036645195570608050916496023637750943103484720945475217311844870097668892383071341255600261231993528741176906429827629297515047474180885539767921934774267409397586519720129292998525924681843033460989598915984191253161833410389202703794817259068855735875330999286614280176820402761413912093507041560555804367551132822705698357536832881269448130249558704470077645948330116265028062479431145280040103932720530909190438390607501791946163319567926621642053095654540642547374659319445559014883070478978474326671795431360802614419195197674766313629156365351236946109267010652504794159870714429896302141272162686473897688392859820581226069522315429739795583066411386681883665779855918048088483722592763365418259087421355667934372212018680296421476695986547268285350455980651302004599080448237934184761359572321674126234970214267068836531373382
math.313  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005992545734006013858759487249739106009491229873656554645369750738894216068278952095304242990220873396985073431564849980003226458448744849412844712246625887877295671494788414662425842066977453663697372930936736882838571132150617112008935202931930523526918114086729733644482770699552792710301037986987787293891278018549335956802931549997721070044342014662185876678039098291253805367841091091116025079035534335545741000579953818881585805239510744351402993934942250428187340346566470352618757836381703878936860619459792602047353549333575642554403676182566754467099554666502536537173951850763813078354270707996615443835449353440439392851438590802108708963631199172951868130703885792005948198515860245704158531530167289137902144751250408377939293686226484916774840102825947228145512491741317943195252028107826615027535629254302692180444279943041598359820716604290714019104898597925555023833910639724934112534604713050754440304917403488643809658896791686396174338
math.315  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001498136433501503464689871812434776502372807468414138661278799940563425478995261281609206571809282189066646952693914726487109668442219329658390930258272872485746901484587621781620711986180653289617354221653728065537394423110619161880465104089473859307139436000309823727402511337296077357958767131549532409912212673679397477343064135727443436401424060117312876264192878477756325951554014881907943341446684538568876225738764290580725290768367461794993872498180837575340408803571461466066438113589548500106359423220206614314920211189272021388117929039727735387660290092424169903865811757420064992578206726965540975492653804001854876854786800480436998674681078864873641199919218227690525252695957789721391835383863817812525370607097161648150933704998368026362225839791479504892066756960535737685710624289268418084265787417836408249369609406392606275822196184694680925037935697197076832004068673512325337193862839581145885746273958215461122551106736076148200076
math.317  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000374534108375375866172467953108694125593201867103534665312629124678619865518317904600428956758330913681998323477873849141962200768542338252815617497519959824521660852730384281758470496488680958100346343340030305178653167477064973206402989900216461820207896437615330941764875815988711099290553853008007346157343560800372664463526460828888637852424185904136252497349133669079097262341357349838205376895544904323796450457846213803624384600510035813390622531522505939208261170486724896172310545805695132050041243606071850093381862978182125744968089531664356875568896381315365298540817970222786548152914945834816926694055558545109302017884175323143653753474782125931544267027690104793056511361944849343605281445481533897440018907262858821318394672847234328682715559780924301157284331809820301525499602245695211771566157040211952039777427053991405533790627331916181891717328123439372639171544102480827647678414185829508753734287460001634417790107138511709304328
math.319  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000093633527093843966543116988277173531398300466775883666327371630007184243687301985505454718501361862591076220020907191150201081647313525763684649233227160444967300536801988114496986816233230384357300985571275155605737044545456194034532684231462471754171604796672240091080194551214373614655304215334435056357000001403933965611494535199079173325992674290779690178961862946053194540025011063270733327838227730193450301820173243634950921837096181815274864494998062375971036502890834846058881885661599933941371286593237219393700187741941035345155123622897987316056653680894357414269884496322891136378548957114093933548886210351957703731081402129946226561282057718914875495390040257670663790211952114384084898531689777309039151865222214792640617736577755560816445235969969557360418125258571198084106118772973064887087666433757805060082809757249299090645214116168840029478149716067235460157651700270329316262154321005334757863138968954134375790564230454275707338
math.321  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000023408381773460991635779247069293382849575116693970916581755612928188202844905775193624510659982604452276550793293277329894565567373518832188934058863041277382402124957774313063324494924360877427112153915690898988097440326315887515755195588210152539824928804469878381229273269391543340249377595332163359888662000766077427973768239612563053849729798645587318284568877164143945107614092506227769271340069746589169533107977811665440700438354218755888682203807232044808945951066899075890443309739532262982476373180018480779858619708661274767399923601452012360644113821178114813395658417048445358061513230559574994134240287514094523514575101154945101954633096074733530404718340469900712948902829465735137631563246848504322005905781122846781289961326801675695119874972990329603261209013480138304404094636007475754783580341248350139541197974149241158046440677914346575879663542701217079795277826819232231103320504602765701637596070942155295967536045480207410640
math.323  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005852095443365247908944811767323345712393779173492729145429203834979510924902030333657331113289222890444906834088758635903480610041518902408093825318079870901686439034796456865513345392863509772096006818503438024970130692287874262044651830426969928554583486020892378792857911013320024045713002873671070033111280106581482335237538998221776369792261064570036983445326289472046369480238398681056670489328945595902986424878145903368216712411171230148812675056968624863205094876824256466378323353617509564223710046063268122832682582502943339030824258804601979739706102286777947481781779736197428960411218661740136141294568045548686657996933654045175404464085182801096503744212033404294901333081807828501286949392762512941060778144547553418928295191796312240534718103969916848465311968783971384003793137102531102661398267262531721973857052626303202898095731796680112288709057987880744852255813230070366236819031622791066662535411957903866579865312003227932262
math.325  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001463023860841311977236202941830836428098444793373182286356223247959595532745017198442244272577147081152106796064338985666159633752682534518855049714025064372044576213668700229733571045376340106527758213309007836398045832551243741730592590951309497528748690004459929666981067512734538010218938645989297110361223321654387735244447967397937088403357711208642025089207460247864766014303514795287293568165671149699297448711853922537111535973942401447791580550978174876815985378129527347849095652783944411600085576332288546170289314340898016370105619640275322595464521970892691095311469570645853487378695164415061893683710862197830837921935912950057488748769167651737266788790476245572470496256533012947198423220434222794518946729347220803163743249371802589626917592989689770740207951087771795468405377281336017121364530582560046855013165713165424257482672097344941515442562264576135355944818886786222097543111698880702190332155931876887647336528654553275634
math.327  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000365755965210327994309050735457709107024611198343295571588936066347089750021755367946995678617046924358486650771559009359785726582884255221454943409929791905855441285921136771451266927903863050497348385351000615255849653020460224613072039557708792645228494630200500099885556918306100906428749569035928872032733216944644153519801053034475946172768601255527753515928139877686103501434269026849300820594929279808991380820899364473693538538227070343311684664002673605027305857447852749747608425580939216510384901489878081961453183659325291888291869261836375971358200316116688568161502470854743521835308208290289458044672408826633631646562587887932474219018701049635982372431983430878873266331693730299325400494083608958923904736083755307806674965658217280426956883224667820384875606272696734199927715375262014028348338146349091488577074530598694394653451364995196750040516743388492898487140964641429180758519944263613764953534094206085196562190974614151247
math.329  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000091438991302581998577262683864427276756152799585823892897220711515349200487161182913019431929012859514764848153616885998910709231656556514410471634730157995842945235666087758203518263166138649791513729350142140941542855242549572928561233523694414276634390251919762445746197458936822093160749529477731762455239723652233237837921068314457793644165394529175534529931949250913250027443856556472891773140872742446056720122108171675706632249515603285090078897427496380453934990785041338766952909861173129690026222541091832114282542562349718074732128616252580205862092930507208679798571134054959479440561034608686371808154966742678832599209886499465285263821757786402645402776115729560224107191684250338770794030060778973895011305798332389589763743742809429790201219082483762179677047231340330251549081858524008133350969859349570735917153652330021108600873931331766274471861069371878483714149809363530840462459315056017614793498089605256712101234211304007858
math.331  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022859747825645499644315670966106819189038199896455973224303699537568051564203889164507137123892229160344820960367444267303101762800532357098926897810822224216228454537031450456399389465344191277973460141226105484326400195093581599427828625812032143479235649594796113513266114965971412889252677839758760372002882212835237606779589960455776403932072783371840973760539175765667311678169503146978753356674465259251519271322317721845872120976972843753584095594955763657082971677963356387551984272199400222237617735894687046228375570649903651897480144201395458276566796905541888028999777324295061671571791075900715904166325655998629659795795194722746191517040846977507443021052184328874166381132940838723384582015198663449998764260625640071712128224390664498153187522397048090483622282662100913068959380316608564904675692497091793345886315952333396087961260819575869854109186181602069819551652310577071346291233312606786135501560810013839769620545083786317
math.333  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005714936956411374911078917741526704797259549974113993306075760624250985273541371561821481963377392211032018001122093258009256925326681805622805614594007622877868330722136422036940897541868878190428477905545232681237925690580198268704782547171249794067493346819007275246195958437833614921694718353222415771000756006938284586654580178047469158566012647286155728699824289715813413908333898675735320514086490483456741578647835318778289466940522348994305304057467436494950958981110750017235634499468675854454630249087039361295964332826909042927220788659172580792045001378910153941779364830978739314893773933018892061047944464095438616239221602574887446945146759896291705549228716578884181416074837659281313158886735856401200247794687096790069132528840365639623012535785404120759508572230009675736475076763919288738325596806751013250578000289954533310639767595067860990807853038192085236014583374421378373030491191670848170596636153283303057995463362355138
math.335  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001428734239102843727769729435381676199314887493528498326518921904935965471995387253865892455555940821799613598223527356252394874809290394226784766938639367703946309522089499524460235250012192705436596032019676957290657286547084669339328468224616378074519982576475600423181214476375422333812544407756082633288922397946665310041636670213725023013311270150517746243548107934592047921817150695078634281947387988581822267980565076492650897467199419898879249960413627276032388927668111080444982506116754271020150236793783942566880777221158873807153526725412879731804364822935351911537056881479946327360988463556234833081470895297736269127125077862825379247023564438147749171300912497084944052054305370194164889903868979242053793040107304686599540669404987325143704788676112744342155442812222213302441357433755779868302374991206203098523165145593336862340215545715723192159185970006462986773603327997814262351162922178937276219422557528831052828593234758431
math.337  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000357183559775710931942432358845419049828721873382124581629728448331015718399962853845419998856939957568614612663832317205935764551725013401281114193598421828800391851368338936574584927878074911923025956077157327592983801326803218796532401269272912068539528416361268250511660277193313313239050913950718374701638381127670982537262376171001835651460580459170825085030381989916674094953220379892186041686838089277549957761282342142497090460991160485264730182063266745284738444571951268005067551386195731443824566355132872800467719146354511092541162117742326127263066337293646267249438723969473789895245304133206693171471368336108633868522901185071462573564848157761790945965345554726120627694864559657811089700850265735048404594665199972393655136907939070462310808083831348329757858424146375372365990499695441244373568327324286037077089946602349053194482381076706565348392883945463967946953182030915637315577602602826180366662209082447348610410674229505
math.339  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000089295889943927732985608089711354762457180468345531145407431886760201079644559162392349098044007739627752064483706398133573146018191255736647976075221326821884453755079170990974985526404275958525856322708454605380194841050845677801224956862249215359432655411730815038579085384516196482384931735609755334522070182108135584783658632638882718233931557732281392969442975778647818441743359439897257910657210595205618299183091963324848688742231132159276910060236646661260569482970744753939689912988232281386010329137627616634024230111809664429739870736126561688951193226161601230761036325735998825140816104817678026099706745924768220328825533496861015709176900963022640594428140190927938232003990716732678318136526773142264082117706361795875463447691944288590737440926359354385530272079755546032568902265314740651971282881456122712484454984078030609926856969052737530730314882800346612207761816188148960403499744520201159831935497712750564195058160335104
math.341  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022323972485981933246402022427838690614295117086382786351857946654211064360536284923753285436532240488682801328119359899083516200083214221850281973935640648883907416547783566618149203981984239908664204894439685172786903635955022450050807959815980749422272264372591447767161255082608481991157965735176070933485114522858489449391394530898251700685723468032837719025384593258375488393785341612323686086681691241240393447747132893268039542216386017651878293500393013753122513122795192528393807741153835265763972517150965286243756383412286529709993786066334160415683569860524573275388515206737691749652821768925457972899010736350614562486377107178665296145585479244245676632677325254655451052630655073478076126089742708241690739380738472073530192700364749076131310197935656711100058874329760550959414061915314148364548570247827552333361681560847677299662015368691641397271576334459199938551844463087805617435194777235255963435801716355466138846174327008
math.343  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005580993121495483311600505606959672653573779271595696587964483881792854362289237267123433684191982964587514351905330879702591116049449421229374238931982409207930909601458142415504905031090958864263361545507651959298998033431036621076458462002253322507703711743670393681396293978517159011206497487783913997888116194817741856869022775268464139937098704360264582461743843908260749997159693651284442448022595124754018929590192512480083574983510583664558639112564304570437972112177027254969112719340870334018941109993782040872655994789050509950683287357181589406873400591352353593535489985308880544725735684396980644057297132451096239990201659478970359509405138499118622365287877396374802103764860829017327539011220355690138457464275589752751087888459638861839479373019895970372119433147784413527948774670612728686780927548938124603450708943111048639739635803732576506782824056909760749217822276046400806323873306177965822497046278118065072798028520325
math.345  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001395248280373870827900126401739918163393444817898924146991120661363778954145105543023648679387876056971014458043655721714554528701117538300839498627405000115041706766889892804106205633998555139820160225282138951854458497234373714556961676232414125275252530271585028149786140780390022168227838215941733255456857856207890090989914575861347933414841379436577389017064124286562583457341863779636417047831499431188489910861119068065283534894174433374769770936836253649801548444243908144495416947496039786119409476540726177367862320125223322247102908410090111494752808814728406551569174292790580286319079758235025038492647274129487400424383878794729409974990383571358420267268412556951163293997106671334639887627418748195815304071134811233457461578102279181807363919816320714700741826662490484691505998135013804440142139291483820499978226365980793060379586344901522109033576871973060111124160897606186616224446542916179134131747131325418394057431873762
math.347  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000348812070093467706975031600434979540848361204474731036747780130998229778933253744227333309662511271556549327926244375843853609093267118664472785126997784337734717342268132356994423348844750339296484983651484594953761243715324911906033965653564127305050859780534003030709696492921478241715603921018632885566323746756007037776852442946690267921674228742857098472047425194994487676606751680016879637663437394124158056403688476645741002288164994325994295838764912414846253118864906822950750482428770553897433488642024242135701602828304701456897730749404026964491434285366847796238365499635612912912308416416122682030506985278303344466776258615224045540886802375071968388036571254893528186400368021894165368186320612206970947100941583848577855480417797442727825521284751001303573575798342437687705273507131182365003386252856472423424220584703069586383482790151741628315738715392263182093232425166092906052519076044248932027002847088687886981325541641
math.349  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000087203017523366926743757900108744885212090301118682759186945028933700226999644253664769009617354735368448144240699553222015261115406628063544636546268970317749022279326576462199816484502179427447810795595219362228885884482000090467712510453977021726658136221484484210392915821646305899316971266170040203998733102319475108460423519887623767674330418798828625303455536412688540147975085428195617126787001828543475900476695362471860253732027166159620850620455584973650185406685259918889036876380701339197301323707143150490373062513413428875951404177714569230303437557347373716354020477809300307438736478067035797593550363853219332743356453422470518646648834344757075174391645080258413159613186474629812397300364114108477741481194059523878143978649259742550473966039800586078739343760347528687433121899093575500212795036401074867155863450006168394043360646407213878358733117139031691356979865852987762875231658581855526334487172364088973347378501714
math.351  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000021800754380841731685939475027186221303022575279670689796736256809440921446170043150407328204530563562035470734224409389608547877006229764817071075123519473266100894996601098390872496877278046379642494513850407606834221611213292765742939805625057653184965736547429710683215336260086809084799408884101059778743086659873118839691757917476741862124805573445688761278432776482746986982938479070035567351704946390540479548104538085641130966528306689467507966975788823948932187427724931651350522066218599475475445558906685636131101974271075553280864708886242795230959535020361580222353929327442555186846903937249540734721407117151155701528255959547828316766581901180040835221362355042366898257055830071534634617481326263455989613168838533993345685015557179635120223482910967865388694760910400910391780194773313551561044590899975967094861817064513337825294201999269237952194383969994238190445205701709189156817321352378296265822492063212504389504258215
math.353  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005450188595210432921484868756796555325755643819917672449184064155250881994460175202514618251153960859389250007112349346301904025583324596244771151556976327760300001114294168550624276392314240092015953252592162888746487461736713264132420908710769712136936475724914846349376985921740815715257213267261335619203745196161818486723007364456370936506487777080919265847255576993605206920648193247217192806485599750111485436735998938026051863501129727127069482442001869031727425051171949214791280560514941111778089026444091741053973029352799127887566180044111653879493713682559496167026066430664446174458126950049551408433833514879933572869127516299103318508598973820287651408082963424302834176870745510149278992163212197772054050122802257998922039057614453184142101917276231377330675883578115782179209994568105010339042669713252198172106831207896030601561703433925372146811514100670971867172667578014341408137836490829472325396714788154076655959421973
math.355  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001362547148802608230371217189199138831438910954979418112296016033578348457828117624507853029457525766945132803270147433022624921744022858277033883636889597732890522633937447696469595340365942036050409472082177090936952869407976049386138087543623647483853816675333664773545105619722077096898929846851490986102419847919417589621687300123988983932145376796946135019305551784298288622032401032821235017234051524654262220606709816219468640534552961192288865970630215539841707469643452418375665212161509278687215049110729366822903324706989787869348539410353245243673800054125606410468154911617105473693489497671325754824236233618985370664295345578580435267472182837179664203825374907749591144628762525600642423511296300250638652628120365743350321077182112960373101677058678450058769021721257908925224365076325553244839788911742641341515714246718398748343405858023478092973631862020922900938613630511769397449615696382405584152173069515054194950509375
math.357  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000340636787200652057592804297299784707859727738744854528074004007812990221036259831002429753660940947524929903690767798618704534792762836620338344639692081534976864866312884417082477690790969026248202964591987052565016717237485032010959564426855609876328356388650725116523656149946480621167550750786638966038934890794064110476313149327943843020849269313378839802168502087887647017820446125885804896824856648182330195329000730931611748323063613692269002122293625265201368833323925673371172006110692381839396062752429054625963043902945541624271018946825128349860733047895047574447038318278814268866075574180813677483307834559077912659554352686453567128296392468747839612242319518929261581992447389606751416909296858352643775197173348285210128519901340927448001105692631499181456126496759834414428905431634645233866606302889182203217918918137604709651156725835805916742106075509226681671466115267830123246373397099866182333751719213714044406120932
math.359  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000085159196800163014398201074324946176964931934686213632018501001888625678212312782736770382448186293079970998633377459464600152403543044863842606019402188774314217540305189022375840014645212715070746571008762578049828734144620625546947692663591110775630308180634119378266761272033686800529967553917195809766227848464660418238899829511487811017736355171754378093295337583050283553174437012930253952855497468537853062880265650131756863640876478560791092825450898637289362788677484939258808104590752583496996366175019114556622062660345673379076584319003260483129860163234872100136684386584652699209018378637301763185015530920047412824138145039699169752933484404743339520118081398313437313919405084407517586243081039250942940106225708625180978811452353860811701575619791658128798607564284775366733769117669497511961637327113443265553814736931068526142931328531218242476527292763837907498904397785184682134457485128863884622311773651822133066755190
math.361  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000021289799200040753599550268581236544241232983671553408004625250464976210992327954015988478282374468403185918858996495455629567012531950595598641694062669944426730726717957302273601134238898956490131234200612466266909351072310369902062371597179377161465327985773008239774926142083482734007591639065702698131479099667304007263079100961106843393547423240919044653470014832239709117266665072664611062850880491994440502738865234569995704768750275674923970811935556014335303542751270194464840578678918073897967723105724248065525685171846493415823702452219697673797717836040822666774168642479507189932401312875683963353219108405061305359219221359828493291837279974187035152357902632728208705383755284072052280812677679926770375583089677366674399137338537185401953751200771185125355935179840799871182220990724950617117641390221696140069335671974502643565641541067362896103622393326065205570861468312733856134600602640149167696587655528322975353387941
math.363  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005322449800010188399887567145309136060308245917888352001156312615446251796887517207529995422852272115595720737704802717567559837062170973775991905810287946655433174663910632262457109822258094854240012760298825757111660557856802041759286394245801306076139129343842585280170565234546479636745981931341550046763266978896967970411975513081549290252523116138324588121648530614213804182318042232627544807400595713048403786849531097626493343041455536377830129830678877942828752364256165170036255042524984874840470754278158110779407761177850555875915013962387895318840849039561503514760668291040661233128665096018982554176700031495652353031768654663655192247106939675498444268779474931950686059460217148709935251734741318231530720012758631540508533483161346273625200395213366815848979954377926147759594083647626536588383951139062963987608457386643306585671317567990967883164080573196513639653196909119183461988379180162174534115735965601708473780606
math.365  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001330612450002547099971891786327284015077061479472088000289078153772918399089160268941707283741807474987734742573699573503172411950149644431986148753526476944455602928939866531362422366020024667697955800022229765043058196300605952014020434142766167679169894460266258127740229575926405202339696201042997411101264760215941132570394593705683665804064310964876250428903633687898419127628695233156895217249591844748601805473542606523024416871031583868582271193671485285737508106777198804195818835818046323085011368246704738396611948035964973220766591611762790008563667607896642123003774345763154330033796593023125904456514613590673718822288232462891844243512622208926338765475320420667811710123330359784086360991769870555300472365509100693685004845276354917604495211842735328184843304312910056925696909256052566974885477733280846555970607805852790348802733744175475208500197445654578174304048445729480986880222111931106883143072352810126586365371
math.367  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000332653112500636774992972946581821003769265369868022000072269538433380205313099063575338868494200696090134192106840126008584028217995669440103292903358036666444451431023448028224686574128211933900703519001522983475212891133348471988315588285311508687724139373558867913763304449128325706336596245351002635849210134371519075042851211417463824983336467937317020190679043506112838304974076473695840610019611866126442397538017959445070434248262158599508052748259321918239897739473605021342384673997974969115066743022499698301199703821881082866148186655754260884225322112922717637152065365909338904629614257967135568682310438309023855900460722394026236994623744934877429152249020636637960808485056313495042104335213558332158572814990222729229814252802775519962941959974201191494520520778709362525554474861034868990396984223931959518787850873017740761877144400750538333207675438538086614311475253485142926708679823243765782108344349020040410211088
math.369  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000083163278125159193748243236645455250942316342467005500018067384607250674166142432153824944630077821505111382078361989291788303430032594841377772673634998319511968001423821194970506914468970113707489696295517479177374570222138861880984026730758274165502678920816863087727390263259625673477968660658386126914993780523025592177760659416737401482024253590334740605206810131903550871643491672650684108324251652348410019606955801947853449369500700116203155138115876368037453916805314575194999688847824334695266909990294902082944998798393174976338508172703217405938062593362894388550753219007786177802152546301650936315970172983670696868176145014254033213197857806491745934553769195663618442937230824616041036314630109084645150818266097598331656439792917207388797999791509674502405963089633096493333066171855702866969217628228322014320010558672522258790565835329939142862646064435695086274553383336938898331215540920380703166818632731997426857754
math.371  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000020790819531289798437060809161363812735579085616751375004516846151691071079076459845121816991578082874342049303117467545921148664160118701328415255049545351362666272523788286021412563552953482232041921879916220807006870466376651592371050498388239768367358048487261153638431059374479835473610089865490084084635260275804504587194582284061114490267382717403688330675965697861761347265249446872850222863862672660593532445353134307133825712513655090788445741711198861183821085231909542364482972359918311831102531133805310758701417346336019422840250501971169478377418712363980019885475485284824484088092756928098983148352634037347122221780542229509531590343049885253699270233859638861987440661400282440476444282328812427458653368779414978579922971621546636375258163595965587251225669314951416933489608597956961066336240006176092360318045170031014398304278883750238451066912856775211042786220531208425084130750339981006143074240988297935322600372
math.373  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005197704882822449609265202290340953183894771404187843751129211537909256940606987384243296562789923773925979412838549509985214414587012816257432652082379090078722765023295429621208785708353969063256814379740898714094230892530913221288950270515638941518850138219657578989270085893784481215140279577388684517561205999432012710290924036566855641084717462664191114792122032296312529384775898501235835069698418077846438080107177151233492622925978598160304794957988590208669008292919653243823230994966025019506839235221756359128185556853112898099359327541129892937103199786526885425739882956839438591395066894496990828680846904362937142639445224648810837190224708618124595727016954023892229597640779458097965953123900387880989103254945541726469958079975058964821352015112218238322364386480538594542625167623580995545176498144501246984425279512762183968707832781457564476674505409581248627237232922883292068655468632101511848802824324835026463666
math.375  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001299426220705612402316300572585238295973692851046960937782302884475813031911510448612251064574747949630435640660697067528589078695521318870950169071658696700161901518460578853932411974315395126505936957724496846657732523681717954857135299407218088472926991112132721845904558312121137004018332749934914696433834552115955072011597368731132798566848192789565696634209508095659942451925758612912555252113268416016588801291775743031024263299370700050292083033852867896214930942373658864821334597864143871926116796384103257743505615690773151144725250933128225818346286586319852811200543289922678318886065334874359704595175622094127691355621920575321624865298084732553836837057240043818641205242058160449342096554614825041590903843757759200860858599448097804908652430479686644957476987592152679013095614326741296927849464760720903475063962862927489862700553174776942734981438783410034182511461835192915373678303924726932094585357962290785738864
math.377  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000324856555176403100579075143146309573993423212761740234445575721118786457617851345769887979907827765868602330993072250405079280977159633393011648607889484134588229579481270790006064090570389533408232832810596361328217561043566259572333225402393865256581956869625570611533956692244179291370436339852450664764339316265228514827743841946744843471469684186940760980360133165465017127704460513227706891235690343950739764715549232707296695807346639953641153584285300994274367396720533495051883462898961551667231677343242285493654426828630527700497918957104234970260871785411240025765819706456905000990362348576360958637394505746886758666030995050957448549230085589396214161381282578521830128189808884692085554992778676497283228414531035404252434340182551711356210496082422830143655393757334350510546014351645457581866254049257541452549035341172604355259011066200090080050513872787686452249956542868008632513027975820410026660204518076634938833
math.379  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000081214138794100775144768785786577393498355803190435058611393930279678081031126584622119240950750361296149851729145770226554645296603897772386666682863322534232118134719640819315544501323551688500740115646390477718116206246100220414981338389655358661186451150747248043294896717498121520104173759448208755244064252716728820850967760234910062851621815001315561330958463697164593814571312892812489631132489077149909633497720041155026110984653779057003336974262257500306855445588800602132706773552777832319239491561475858273175654858794854436483381809596623693774223342796894625956183312310501650907494139917909206598248892506504597443660020970463789884763817880586276451107282353272207404598185197661206721811335903856416503299461825034337192650602278022574315950226781448037427846953470168754349857768074883290676486989283205200066411082414042008017848251684257945037857274585602289403036963694050552896235631826852694880317555638817288361
math.381  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000020303534698525193786192196446644348374588950797608764652848482569917460994077618175490615345886859193926270596828419689341360039460491331486039982745682058600530980683649065467072257746976690168844715573389354923815678815232780684800007241737262893159195078576386599635099740712755088766340400567323730334267335982847907876115712993025306409113935477955123148897327776201152236008938780839070345651836445152870446546184896424282672788407775566567304451026183008395180163182343586626357874302024737821886985280115359737482029863956486113370292144979210805010849462917244356432924835765204422491590728422221903393814578486088829656332881631538094635507400977608464260446359982626624378213472371778364113807133819466328199855395972460613555487424810326138248183393337818676467016506921956529727377211484320105300642052724844484033617291270345031584852737203772752637849503370496868581138222297844242836514245209178454812807251941680544577
math.383  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005075883674631298446548049111661087093647237699402191163212120642479136441441179212757187737382744672913657389711769649365080585076400143882625122560415787091237836824599809093597695945753393308749947897763738244444833629031314129039289809790032355790392608781370830005229182996073329658295301286314548167234985424023867186312818401914697754310424225433836697007702134109513658813655095045427777463359870542557480868641964117917638229362902131667692631273143275437723083362397395797869485169505475143745469710028363140148982923383761367799838374737799080767200902993098018297336608912048709902034031742393827740044150263158022186499350742829445921746249182308621799338255903279327641121089123958948471485657915329930768552225490281541245680326986508127425686073495368595572596420849645811813887787673154213510137533523993445457202521819271560590040828904738651684222409499359522685629760313094756352687001998016958356000570693558783992
math.385  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001268970918657824611637012277915271773411809424850547790803030160619758687351603099732022923335800598720868763039571864029053588386964035185159786611076375871606626948191091286409620792151951312119909890697122377188067039397356748196765307672365942637911480040295935765426729461481045666435320049363512696805602485437392072329942696684521680097583465279864079823392334685659975039665798501336136770276075285734879437143455272380074038799811275183479509202498122763802280494891233498692785006568221394338576840924141525228980301769722803492076989079461370533453255555227677184588000451540800882133262020273570041029604352046274683375320387664515861036721716923349927653202114994647566708576776402770456516674486437315919415435227896673515983040787018289089902072207251887168510151576303843668563622187880197220346093893112784595424424611302820030935416102850962201767067038253721209117768087631700390975050732251912163239540701342731656
math.387  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000317242729664456152909253069478817943352952356212636947700757540154936847059157252326641951832851753068267681383407351876463712914347416222341839169437951129002286975366938828630612392732450384958942535060725013610024893281313215666534717612106067303253692812150623266325287406558852874119804737520500410063055780952879690745465266461106994985847542195606127106996863819576703807557524080939726982724891733136339181022975924106455131400067402624022646543855022646532694340407635398180829179539475245826112744327062032168422615950573449426483351328743571692532330673255464162157108218989062044069494276832537298934172329605463640916780036646718846904945619922645781880335351954035400056572271975576302462056427597248126758485580365129698190998231180660006487306723336599362535490324464227590168434115696534272760420204275057264952133919127914270100808566975947362588298955078405619774745288798414860081119577582868507805190265169577450
math.389  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000079310682416114038227313267369704485838238089053159236925189385038733897900484477236508956958090894199072530415131214323575820265547244239174305673927189164024913787680365054791267299281122046706965749409883408715641109206588360558136168707754880403069668212272146300863662364528910877230191006996588583387579120860479015618651411573863731833541932786999867688011691924349784001815669595707956588147294586082547423311947361870186633078434429461729454462729580696182797458852964442415845982454624373863721858424693821554792442773801592639623830422928191866718627833474646865114201431077654534956086338253076559396785513399502891709417104675170344938770181803725301560330177158295183596854313594948323605576388665166007977063139524481009247879700785942988419096151427138476341567757474430560434133119197347528218035218941333718347703338493799510483851658039661420850073212886856490796656281256962439674049613547199855897591416134363116
math.391  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000019827670604028509556828316842426121459559522263289809231297346259683439601309470881888180239509163097768755944813845407229350796292389859541279574888211717014071415680643923695552701963509014574920181907653740034614670726060722772869409761681319075423200739057837459443106997278384566838683023861968443776675925580707637746621752176867011145463352816530750459029317523202958410310129075311490071316127622992583692571913294136832542227097203653927413150200922648745240298371858214278318543473985691109150427693121928088722993245837178192480696972575983317821471734854184632999499331207308184807580485697492621094502033088093732329878438626455206526769311661605298842185011964350599185522068823753318668701946127903264816781533003541784167954766286604572976638284325773755172601130318191275490883954001885925498697587697592049865846239908672854430062031314973806064469836389058086137389288062418809945342258980629409647198084878574863
math.393  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000004956917651007127389207079210606530364889880565822452307824336564920856025459406784112149615431339613108924912984688221973483540813924408011040261976168618606966401426620048747112171786139478823724399257948000278096324863066556939579509684983023999505857857438030808890893457793482621309776710566814757521029303161792182392711693491038303002832617796718440720628870322282871792326403979026715286335287160022359692789295651693026433845497035146493411634435863587399973285889955972516502626936488245168663770013086358067263970423983851367582530387170703980344174085786563358083864930864272426014574789315309219002074581739398633626997585855407706073571637621705061873474600644146006988300729299759059794096817074397259313505142367188351624033237748613272185626902091583616797645394906894716735103835299629690326168847146278553509371830563921651114206563899584713482083574059128160503820416774155231579847327862843611201292817027898085
math.395  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001239229412751781847301769802651632591222470141455613076956084141230213575823967147543604576697173663129090775666308374436553179048030371297171913063114917205681635533954462326724174472921935900134610569168160886850353945969685382748679112580662229940085436390204794785526410422896645913902840920289027634249757880584871839476063104868494418751974701168733159542561473621369224844593130404498611261300110268487922604360827267392637929952598950576453678327139878280281513899720235672480670488608192646104235568789340928265551988400883375933745592816580048076263504036500827869470998827616083916405931425548018014408710996056145191675082421251237821571329051437507100570319035559773155043192631965835152086080549088552453422343738332343665888491927856719589622264829886774616375398921849070287078159236257970802104120256102302214185341737442940648497932556345170037622742566432401497050454943783305061874826108405690693561945923686934
math.397  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000309807353187945461825442450662908147805617535363903269239021035307553346118115725943186385600886611321368199185481129049509207986819431638421977022533613846507992951483303477918574508833755303203662499561088547579200529438426315188261179776605901524159065049783815479391227610065276599548164544623969323164393942667575184334757604881396893975400284705996475490847553960416235338092639634546177709772905112836482347770701791901964722106471164385559063200692364234971708864085160542400940339624141417851668947459058134191334069404970042851966692070919234665950819706213923834102450970872324264132384059457003098890213297355362951632937051518496895623950216127940887996383391955254963922902653623390429152896225935242498127350001129743280974443416423089243364069837227840059127348732893468333258362405505784564604341801611221357859339391046803165619057034044034286303746061076604005125107295330891700875643724112301302914893028244668
math.399  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000077451838296986365456360612665727036951404383840975817309755258826888331214209369158828289892065341223574883715137397311447375168758654444736140931673676732968331275906770745322026592444501248950167977719306052110974754270684944691788378583200301459942497895221850413849222522262657267603770906127676925290673124894784609127075228397184812670628309599268747271247813504247081147087097336033201720490444703021601426389280681972141612925348758608642606719096466362846069342489799169037689602236386342044937712358313932165710978360155442445662266890648922387356455718272969986525604220185886832035871720746512162653952508487353898962364011932125055108690396854923524623947586064604445248072098439120891710426811441998894472533209676152913851672157738558963289348656601516949408256895291094618663820915007318253021875628567707970348703130037846087539893275353292439501720297355717828171719735534206057823722602862757294887538369156796
math.401  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000019362959574246591364090153166431759237851095960243954327438814706722082212961279808932816194332300682919591364202917666656155709387809962323876678364613261286817801762027871011301672350779619886106522621962756233701225036931712581119681096136419460146289416800031769338284541220862217109904095077401074192380898583704527408954671988602278093431436222785073810330484702257172678603526772808327683547155805845729008186965887841430194670161223898680093219761325088105703479650513506054144058321963893537899069489799591490203432652923053678394367962582655983478711992904581491425130260258201771410984447188786878116378553554485169127210182939158788046260215038268819636353602247862507284297272810463773697325453717293046247163700446040606324594872038424214998204716841576168443455571526286047110913132916651074505940376787333237189613854287956188360901038437829738326694893762484952839725859571499853042238912275380455803860922867404
math.403  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000004840739893561647841022538291607939809462773990060988581859703676680520487619090787702731128729293545954994556097237009863953682610145978382117707508615667264599487642762579176061461495776658547419228977369231492623032477106024434454980774337083674862622366399061285237833950988486005617515210020320566374019205831722096262079742831270655836253959270920003543581387270363325984068583361202657276847603020404512635420266658481190123614123023781012383421360736498690142436174784435174509891870994868574385979351318042390233118957580875154259484740320959610272462562304959823713340378580851679172470543596850399579906885565407510907251048576979201364355691671002249018034664343745616779741962162042899474502796686095101831854006539426860611484641625708949895991196374740827787836307240047324166220924757102948503155386474721835515876449424608703681896929414754575477218392980130528115553653206367523352894005577638408079422581124137
math.405  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001210184973390411960255634572901984952365693497515247145464925919170130114613525011977852457754125428180426051807254540599346455127409347678091038005559227375369557329386131134646240133407557843503938922290441986566723867732906131719822522894152061795901287962835379754693190759211135511148903354150363224217517477124470583356868287292047636778058896045255577777043778484148873972155681164620412153650056334394733587222973539580469175460855092693306433963738996129485600952872505913654208147214245969815060536556313838252785588292888785587083107846200592883236762831149604473054258094568455467129425636946571800326427147694663692679405591080098530134018891460300274323059911911407960875417875980445977979644350477452104426007191105468337963308459903930354061861078354755089402733633868790882432220621599422040678749642868311768632797647330987401988467559489759019188899999110384412479103746939495725903985032813149682794747607972
math.407  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000302546243347602990063908643225496238091423374378811786366231479792532527843242621333593078390953806121959558816585333831322975633301141358848396586755573594103478557249139341846042128869366128892733553070435613084511733370720139565186955157876287206113381207600937947605826632300946181284945614715951098157790428822146758933669490358718044126796777187152347183269380604513076318499512093412413230475982876056865078193138138004880130769700198780415677599268843962789603859508908136980898193999594638952467322083346223240277804343795116879076467673427585833818969498901938192602841989515961242427276377785888979509856933974845126041593243685060828907610604299335483933827155263865677640282435313093847015414775137899023017871660185266049394972769831863126371133713551197141541520468296540951867444935463814995266287399706318889939837038097538068525085625201381543605564205008036650649325097676509380665314763997641906568948876590
math.409  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000075636560836900747515977160806374059522855843594702946591557869948133131870795251815523821148007612539029117022454299977996028712570752408466122174506524358229394189372725318138054709130633657487323433096795807681465846981638232402883009953283891665506848080988523168308249722359104514382222666862868957637451443383429461655518662125539599102196763894202053341633466583864310326247148602667828870649039662427372207213511430125833182272357740078258852361495981953660412801302901965605491857726167884456805781673601569347539343665828311062830710666727965294863224254079755665888772555554974836314346227371100802219471937188874149098188599922416756221095129120202469917661096509528094036256850432542264391086466541265064243735633555767447678019924874657283795874614724356121778479554304271956859885580671442223295454212323425213455429618132620438698169075854153224831277919781417166811646016461969392723380866435495096180460244603
math.411  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000018909140209225186878994290201593514880713960898675736647889467487033282957697101451894905459254032135706082290981126830072936054911353881835453728418818639851286214890415743314977355624300415520166214473435305197762483191786746599310493611569326251144411431944655217514470943111035649979195865383336188597064970118614936136106959161438666478709557100550466510599315740483585818754784326679328791784276772754298396708908711678689021602238900293139329947332537738966833794508134614217997127916096031558728918288634753817692987334451921812736680947367126370656482872187739233333206119432014589041978424328401567440055099763979110517048222178823574965644607733816249986353126449787291018024934026886290489384663225577618588815789092943127913632976931519367686653893829534728597397917414418221945160221832643881967710786576048116060357387659192887293450948960450828978047104864870526919292823939780401633133067916492554975723253861
math.413  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000004727285052306296719748572550398378720178490224668934161972366871758320738312974084975276383952633478476387576675009689248671077026249424793717991771281450224244589296410559890281517210123873126675340464250753339568487425686692165856471103899982853642987952293747744735421747988125143142692121112312873916102041932698439291376652387338016332496692417029158701975297058835917586099905323960689319611394736424778334077657976856302598066259235325403607023779493023319742399793886666778720410208673848185667416422428473126021797284764143118332747520959334932937522579657149611645890842128456745107250241640067954648817315470810763633369104800873308730337450011903753628195183867068996835492656533154795260277297962739500170058220016405156836797929580289868148195618129035414725400799608439895925703050838235507907186074813822069385510311547693638068143469552225207118929956990132430756926200501695107463461792247782551059546432596
math.415  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001181821263076574179937143137599594680044622556167233540493091717939580184454765601466213542559172307902415450160944420282216364434976301189071447990544197321628079415479310443952448851321161509032393392635659805699035670410773003191536304994890378205368063079207541374147503145006762046596369808208401830405268355943030694369838413766358885652769322222908211835545788784694927229253610263347169499158526707191346940353100959962857042954648877223834426458215946672050843843090004829687778584576997344725656781905123708938990221462280396243575422887762652589017010901366416302998551635891114215959097633379986487830099474596103783257055295154220554011292688538815065971800588284354978603236010034695852688988129501338904904595074993303983377872123317207874687853081747346047745121355895418889430466520801544409870568690251048051576310928542890089650802055030431822983287573245489133794317531255050674027211305043724882321730063
math.417  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000295455315769143544984285784399898670011155639041808385123272929484895046099971631502374990814350181229305924317146327067226159276535309119706710549903542933724730039182483945209338947874418746885660534158279290962418812054239476480211550584116365285420846479386326237668189537950420665257789347821432036951169710689163658675891598379124754457589488105811916776644680743842694895916995737765139857265940978241267309593226224133259336469154201162543957614611051938987237446018296746308499276556574335173830952590691555914431613426602292836415297278468125145960124647694878278128068083251778323989839583923092146496093854299023200571778509675364765550730725368620783643461345651730626203105143053305097100486258056010211599361179366708128378945524711634593450869538821084766325188384774857850641229789116257678752787619836207704646189989077074070023416677379378668468218097836918066771484118127074624855730684675414097207895814
math.419  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000073863828942285886246071446099974667502788909760452096280818232371223761523468489112907259389649445779960043498943273099770103076191930756109519746913132298135181277437400381165822809222347415644207143777498986797447226612506144097537180821928239560658233583252318119070644834785725154187124446168953368800956714241656401474288269720507783467196499941781495077640366517789885722082296022905541922907081625238677401885970579018074653574840818018476682883948184453236261409115116842502687219143193871831470320603199997109998447497410728802834260064977426544585977115033002787911598929436538004063814038683648205942907580852502483098820072758439416116207689108071099280057001846776174974882639946832464035905649907408906821879792094912641023067325734218546892440519365128318324015722885096451745397085631591150287196637841851667860886405326385688279347086742150889740793386291959212977096779997876813639790649165079083651609084
math.421  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000018465957235571471561517861524993666875697227440113024070204558092805940380697742415706093923641461497504851143586561756382921694455353196542186910225947453105199895787759042072106552405506835379833037621769751325374769313610606982959511701061889081579747176677103362954204884390274142825001618665869407613891693565557926900594844613615578365795384525231552270750149097327858467481153891663299199163794910638503556395862322298812570865177323352093960056368678214449046347798747033404290694672337851918098415631806986719240236977670948424184916350781910982042872416253800224805146654622802121731647540584447636458575185178888529338279550596595293045544721279680062694652269580443349062279190568950232243253330088363672693227941786920230806548123407355315730493379613973905342443186565893695195908031650849117173111321737399879089350129565540461792108346662185266129762383154972639475043260871379082897508509538126784034835312
math.423  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000004616489308892867890379465381248416718924306860028256017551139523201485095155615619201998933824709824655639482435611937033552193600825515883375423584294938967835499246014806813962006670597669309675132807400444497914625336533319729869439889090664934384228913535052139289769156826139038227346453122950222712218855023940553083110882028372657282043581235031232880311877005997549339775799185812670908970109632515271454606926544761051886637837569686010204614887394936568872393940442673131049297926681910454451548565611962410392160305904467616967767596127463356485421985656125527795350061334265464679703196523477436120213561582332399434455286960092435443156642932677079712361733463171366196262230903274743049865643974980380237802149528452861332355584969386074540542624496964210393204981496675806562715930350037986445941856528935932748000497900730090423212850029962232883106580448833026847680978246987035645320084054449182493666713
math.425  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001154122327223216972594866345312104179731076715007064004387784880800371273786812795386663672668882395083846170224344261807034911763173808909600178307167745253882371728506491330547513889035156842099617944458822987458043404246247157329661261550328398218591290647235756872610346506400567204408053555288018554677023429766758441018931054350453976393368718993580081393830873275680972733782739893200586691483885155909049524456458346070265110761206833349640088954934248411167202252996376230789564299621701544658266488139774153462233193870480782802497665892711795331386969313203688519278044211122297716961050427858024191334119164497204658251872570949710616815321026429262806068277627578324292874215279377282890555918019546550428050499807261587516877404739042841712817540408348506523611883197225041659637811256648363609898140126215766814548110056666180733362045140833844132903766249109416573323218643323854691304491745417687407088722
math.427  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000288530581805804243148716586328026044932769178751766001096946220200092818446470853356239689190854480873176686957801762957163934983065664253240873495191534835043869998973790014634302033337818556364487680190005623629994573814088797347530697975334426401384585864474836937645101304368532611654022115694732349725096896674188950919576229230080724984326426017634109514066600460572794086011983627692636032466753248361908159533481041063178588384431512104075071667454370684407671011118912393865963592290420768612886727291090583319101926499117316954984986215464011443741084218686809311749362340927323205174106176788957454383928556591479718036644889499784211899201561969695678356502740556138628769531512698020310384419212040833612782423606294331426153753635457778660046338948564097708892790188414400099845279396320633541876902554120378492909255856466417612739045230673372250577180107249318989411681410703677110400948660055557745664914
math.429  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000072132645451451060787179146582006511233192294687941500274236555050023204611591897173457007967006273785206965561863296017669340083918067943221776710942994490201303817480782816963882029437151181224820423524205835980310639406521612483093091496831020521400957458111992125715236822924743998028804316455754102666857623202622808496241580996927037041915200363365513724627007426820690236214825975761215185790143204906276997653227789702012130852588741880629162714485610459643980648203655133859066708329737565749338572679222603139292509162071059387540951270741079090190347880614599449635064167213670217936107434454204236443392882191753575959720267690231713368128662897307583820183511029457266145485727835586889956076116519291166421883107984361142988990654409425727672374104826826610127440156249389404388550518884553377772619204778517655708099249970028011163833607178393918114410823659758726716311027319887660817856797595142162191251
math.431  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000018033161362862765196794786645501627808298073671985375068559138762505801152895105830519483732784085509292051815178363479792707947448399520332861743778999810150569918790933283812905659830234437840515057051176206067122252078975865857109822150836111680441018852402419284618339300359001837443938646834348788729634966476843071122280785661340120325406314432714135643686192435089881976352979416411111035249554143894780629247596374075745454996179338782777016024260506751286938906305568512771746418855677111743091847627276266478558959010934117686081866917426787575712979497912657462914913408621365583883773499507831813769885961352042595835726394382363267131308398132819823513633547579113064821112450277664538116640804369654725901863754886891681648705361060126586008489074238482638831392935717304879238814195167884583454708116849243811794129359451403753503400569664139262348278845637946157849796456942925304092499065663203442479979
math.433  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000004508290340715691299198696661375406952074518417996343767139784690626450288223457739536007793310745495433047445429317478323218423136894404272617386041528903291571387980935432121990367667586990112361822726701427937179029213599092770877572207038683546963603421848058571331241334260475523433507881224359471665268569863239173272486234782470501195536007158492642826336617357288433253256974984395242381105144676697064109407646588828208962632335684614019782734891823771745263792003389240078600254994982247402795951806914319818584985105729478143472737727487868328321433307567185548351993318243924314896236097040773197028301771521189267267288377646287099196589138143774548193028198079239247466594505533923187773101184831325594081812670852702817500517778151060626311737366872426029658432221446702871134055950342304235088106882899071065537119769685622504306272564852858130073806153701465532202806356213808548922428332889588553375206
math.435  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001127072585178922824799674165343851738018629604499085941784946172656612572055829021762461599451544609203821249316743437178031432037008188361262896415772660414892699374812435759244266508998744510586406488262927739056789764092047113464674101888360206091734248263867326878529353080628992478734304533994215516614314738275917022686202976243696659074834745125817203278544493936031175911859325383709909409348197142422672940971677871932630079498471440431748980706169326286015861698200751488585630430103427447492491602621653428156464494557787953732190077594427336503241054531576166366473851447859120929947117157744504528417482755007976289277032776837379117834578657363664556075604162599205503380996188074797816944014871925794495749997160254216467485826093650314992138772590909467946474610526738338925340288913493887594086596562640586342449735633554383311585193139380336324560681027391399210292733099634957007292378684835039804914
math.437  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000281768146294730706199918541335962934504657401124771485446236543164153143013953320649333138876648178450461910991342977916421949815118853744054000475734706173487531796524375132738825037887453708052724732688120339749496721762841934516773504186990840415323596331935679563579643298019586172121201454186993502981482913457260454660991328666630656366703380662189702334965687426103516867239512771625501158345211586678546351487649092984249184274457556460661436964686809214631759126749353362766267066647510894640498539515046266690693505754037157565496062893186435960118392539975262533620500328716725925701674209982617789024556214714771451603585064277355030118026656284623954371761322658253126282218076382423028381959242072023708822598907621091607793212006966087455036035855656318978526957912204486596967349713645312668865807429740451774378345534311516331220470085208531144906800150332056646618849091175057040193606753413293115974
math.439  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000070442036573682676549979635333990733626164350281192871361559135791038285753487892963301922387357825295893988710297646548207053209987252179418697059137829961094862611915490151821616381940022260585332347117348288777333013832613186578670016602055685423031586267977185799817574958884588706536814933965865084737915580479163276879248809848373008258846111401890279352316233069782972688046054839100145895520698626538518392928988526593344368502956373317265036916988670066476444256734074780580240908681292008389890921451694717095073168273783150890141770788741368723787084682527298113849068509450458385105151534007359727309796128222276050993061603024191659516404129150400599307211093634087261639806557034707368986927308952051543617765299692500539622187248142601406366890446342337564628933330274924731189665980966417793062317308637326144311309949634098261831555368279726114933432873495712157743694649416849907977023409172235096710
math.441  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000017610509143420669137494908833497683406541087570298217840389783947759571438371924663155329226638987511004442840070178533618603942075435697156005147654681756755036032262127003389888161662291054307214764654175363745345403280972285215639858211936986975181139437965763722814079814335411998070367045602659498895901761222452350185224841858888804456681951188898756005918288419168221958468800410633517888522671578536436151207879857838942641350227815337191768858950037060412592861545660998119386823268101198102295094296048939571232338784039556991144031930353389132493403624810911370670491115679628569752673052745643867444710057476683562379362126904833043157559550873326418151868558630478048238342203531078106280865826900225502539637803415975674625824999610274275397869803949683253576063480297347190966917389958498015611794290775390755844738715168097508568660736976429419879851450346704869980389157677252905757331702681282231828
math.443  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000004402627285855167284373727208374420851635271892574554460097445986939892859592975768269926598859694787421215783628185399689855501027595226817668475327222197829800881810649565203083290187117865539724962052184708832100112839966870023703948981906988629167930438754652270130108741338344887582636663581566289851708923799880292013882473144570392623051613649672592290440483681720266481236573479737815482965701619880432670501148676143877470693326644741032289934850265708805246300226199102676397093167023041378361300009858707562362229831803169526389008996657715174695105461845285604127553966756625367648661164436572536157014813769344978088455546422932460826177255463215976892727969904210104149535069831922307347642522309865309314872721048856102024605493676086567210908466011424317290822675944091759083584881343017045296755679444323412304124211172941583505734365231197769625307146222064829362281883406798898229441260277143654180
math.445  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001100656821463791821093431802093605212908817973143638615024361496734973214898243342343158793292695686818648954086006435065264376980091757474662596800337283482066376455056078060875755293424485214101941786259574718686868322037868276054933367387435636700295741456871651277010553728138621917532070144710656656482723268416446645299981783564654721981247512516457599082488247615135524613974860443530839685478526181927298002350810058844538281688191683310929372311893150721003151914520227827736080727561039095378232227447755235681986566044174220055080391961336782150209393052029101694763621060422521935265558377911810270887777767867499774676028899984925846443862305239793807582170615572378076055652996454455172588864019322598316178564083494660202873028179719362354910200577726670929529755323246800833537038152663347515427443348044115767101976960387069438280792105544824700605365629891164263764396106699906813441698312762764107
math.447  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000275164205365947955273357950523401303227204493285909653756090374183743303724560768949753825387370809478367239430274951559960594436488824554273078094526970814782997074282938644711887395514468489816343061160420785913036428410330279628836353333569733349101937658237784341497178336872211291411781078869861343531859101744014117851472568434384591357737504274146401298126395314266287207432083704456627968485633691534394327571054996521306324483468360535179412703416610631476651143100276750904386581093071470383829635677129687188869605557637145461933242849258252151379944966994584162026678233379916987112032991693396014265532437615422307776317993344886661548552410101952506701655966625943356290841670278592727267228864943314362811752257511456483903369392425839086938734479703292113167545619083031344812903520635002015396804946384905417017682763655033739840209881531403186215554166933715858212278097563795372938281776254558877
math.449  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000068791051341486988818339487630850325806801123321477413439022593545935825931140184833434470465086801011114587736321331533728426408173971269609521220802121277182165365866424185325316866775579107665767907748975012328936874199476636679994044591012950158496277241978261649574771306167860871381031021843061870438855943588356683652802330877947769330994701628661980564797362888683088863596815952889202207229618059596153893869243562046137694651495253452143922946715870797359353018731237399988516397748173084687502120723935760081238357191071643875141577597190337512389623715945574103986719728047509805454299736040125716523420534538806178295120142137586823304115021926552379458699849089170641683099701002019046225175985497147866765151619168485003963846655264149032083081563964610950372104395225235998601198394434279170019421763508468311895330978690288942754577228535878981353823841420249132382369092094179893561916939274791606
math.451  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000017197762835371747204584871907712581451700280830369353359755648386483956482785045385691508073854377879614511142830621066069693024160355616641434913081202641468416337799059650318764167499864617511556251407884844912171011364052504574017803718042097663263257501818510869172507934827146977351991504529320311464651806788271108528197452786223216309106839659755014377205086864428759205131592722311743388555583763133247725194484788883920177135098418542721092974281575487907626331457024854852684428560729293139766198000268547850778548332503894359936136400331085186778005868778325969161758320609961708343423665295808717079913543792837053486866528329210836325835998284851135123044382457770333307449379817983704315614013016715616916047891150742652059770663563621446249732738488450598446183317840065362813979078399705674891492920306003212024264556860582572051468163024875658066105465292755427254517676168211420159740785049688860
math.453  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000004299440708842936801146217976928145362925070207592338339938912096620989120696261255015420402639447539552057142235465064588266191830851437840463683130345309539572548415151374909819701554716447528819514951853165653300801193902161679174396215074074014052562454743607025359364048770924632316106242696271479800727139399278795310036244603430137050429521558899032982604747608713491735637329403490226264683842289719392435904025929888027813534379280856375914936203090706865804746425101982667957337313147085093293026140647042558906089548533248643497774252028669965319662639234279755401194898574714655139757588092199915799876077490749087792326206286158260166357098400168832690397998849064510214623770961507416693874608010454965421864688430292835157358480129860497410054377974468788266913533710640140349041479396906523607479340009474134736379605553555067589246603045791174868471817393601153716967606820185037891239858442916486
math.455  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001074860177210734200286554494232036340731267551898084584984728024155247280174065303597471032234956670404506436284178465932715763045575363229307374002172743406690613512136510076522852269603124490127513761223302018152222926211463258426449431292952588821887720682032108367212372832164113559264418166074880864388028258327800361886664866311699849997633740143437083397463807292495809907416626719976770024477093004858222164431362982122060611847711804764294809327871382799008700782581639934916108694607759800589453631803316135188369246817124491765474688704970493428705821025632876881593832400720597591099536317301826522480953530410773453407901897244719803995995193368905866351830446605098110849184834004706911398987411183253533946929948351200613022167376392338573106828211129001043903773579911789283911541808664849291428539963432697632669133693629767664956141041924476601494382312168566656139318814286468800100450837784375
math.457  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000268715044302683550071638623558009085182816887974521146246182006038811820043516324770880639344860810436292403596079305348251075771156341227810741942415517458425906476946142771884667994692175811015516774295684261671115423547013587991078993445528721726168630839075206668301118685893520630325841097566758873175634531672027463799710638002562893117440458810932331152013912125009277165592085517734813338876885188464881169163918387382904411787375688375936153748280262024118468032657762799420484156465316652911477763424760100702215357309825172238933336445223609900880320123781532541741619701472014372457901573416114668628158213053877903650275266159930987576216789544740743362847854378563431892057169121082739521960621414948244718873552306333262667576862437077374865968237564806991362547009322335863839552069189758502413373648188619428180103699876120934823942372796189694466698994226541654383096268184417990721558584511502
math.459  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000067178761075670887517909655889502271295704221993630286561545501509702955010879081067332702201339829590758189179579236210959672832762696464889532762181809046183100584961894824705756902762108446697967132400332956645342695695592956263012476840823874670845374758533074653018167977649358658780556844992433709476305297220249310377439075997836494794193848875658297098598399072153460417674309377200117721316877622077473215445555562337943189825370234251061353895540822993375118742807619244146963909462768389347725620575936909162129095029051394394096165787528611611396696224642049671531486406589843068556823711515562858404027000681592287501519032531825536983916183008828592356200885724280556883937880237115426725087553917417224281326869967441190115753706144310947596878177371229774043132674038663766997448014489576685881290035621275419228179119863609047572234676338795620222110386172654115525132766989393903919901432564605
math.461  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000016794690268917721879477413972375567823926055498407571640386375377425738752719770252901235813126582617876779326068076816506240862632186467110836547993896083994819215992015116180680841457428465570809656233771521689716404737780734982542578454177629611969192023393360500938311752514656040918621421011546616950065033894063831163819179428174558466116686392764240853074921355621123458601103285479121523505866742941039232327620937251667297014970998243892929477413112373981626685809117317631043546944045336775992369916408167283978783106830678988107423273594209591285571668399290286363325010532835161591856712096386101061102257527823408639002273056077838759295706060720109648423546794969436932779893606753868974861486786948786803735297169853974916164898506188732011555269035240720845560241925521898242988491849376978301060386925537336960797854730494626861302485656408714248653738469701337744181597120431672389578885504703
math.463  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000004198672567229430469869353493093891955981513874601892910096593844356434688179942561677315649147381790045553946091826733433929399484881322432393072134815450718492844123442502089416394322019702819798993456352756383562337212194813068018855676898699716285812191135906016931906190320793363230216745113397456086211782915252003459873641835503710434064618761337311068125854133609200323424705312813401882485429023323730204498682517818589153476031426632125302192996670649519881998010856573086155652234597385136473014193862552099686008064755097853485176347199520193948508624908503505952847560810813548250877117580971753650478845051653262769850296664727776301761303008784381084779599249467396817496818719158722001479895547013061764560328900251782854010206560765117297978838403217134710175858356156069684248621780267011695162565599104550162620032853244568900688969654161455768085310032735764099508209222109038352209479186689
math.465  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001049668141807357617467338373273472988995378468650473227524148461089108672044985640247329656271927240353206165920157519948190036963090853458644414012593389905634717512696921814728494296945627305384599430514492534479469248749485103691678904732562111890394171122765507619276064428159980512170842616562473307714593061829413702995548122452703281111961702341841066987474436519711089610907658016388854782093471213113284287619804752530196818545301198758129880922578323536404644575257431819854684922598471751827807058319186938908989188054224602188203439881022057826008134920245480452463509840023553428335965929351902762486439104313794374652140747740562709743332591659834295626546290922054993843265909944758736315066207703074963607903588760818546391690443642876099470156383059385532008270026308981497068201613760059512504239194712485308108634418379312206148236462654686631647150558252459505097987429483168105089110618845
math.467  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000262417035451839404366834593318368247248844617162618306881037115272277168011246410042721385621879787070725728079728361830348363362091660348056726519369852691203815641510818538856524330854926705033896905773073641605026049040762605701401162536332555915681704679937084048723297911270132310052748178554828210437167788648774002173002537768483397858081129297355837844935653353456674267586931504209616151355747251854199520455436269402113261859406926025174474722210387180579280399065808656343030921609408762768888552885787736044020259246633671322514871720625542067760089518746214504744965041430172407906281801039938627875889949753563853842489424828670074147034175729901764824929090417150957905077797561481652359352992119677107618214124589919026738297178085115186878140978922022381237956739764537648854474330879260917318927406915736774834160367245494479506774170357339092703708911666852817108313083454165565313931975551
math.469  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000065604258862959851091708648329592061812211154290654576720259278818069292002811602508556898800347499765728563864341977329064963520669464751836017945305297222411140716638665786359864577151306479901871867026512061699110972644363270624033677202817666043029516109097132195591163812066269318876097783129157974647325568106043200621174670417750945410574050665017087014044289046371271169236068432624054010704390868252703043843053361934861458263446853634298562558183046299550881187906702335038792773448789712240067146395309789613873865044518776121426230241005074754876237539332003816968726245071696224488978044393387792445731897578322943033719613873805622070755463885498581662866801586210679556739699745369288028940105850907498551407545186551051626028771397438628684040211304800197428384731663707106222329572048951964821074914789546265959320550603596291744821236559358452889459493892144722044284430254286503034971504796
math.471  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000016401064715739962772927162082398015453052788572663644180064819704517323000702900626903286077295491941215155615464370651319337844628093928494770353481528097446254164529023673714750426262273767660973601275438611504605806532885659488133326963630841127246140948136929569802729435214213369786324936253909490816340292138469274145231200862284431973730179169686741651527356538649032871857579334644984167669371066510846554532844601268995641251099234893000809966862445213764526321963066751612584324777965244147408588271288125758622316493985132914527954180432129713533153362781654204181009450032635359254814649533546276291693053226189268700504873582704572790766019083125528445474862002725521741205935265434643760440382923091712270764677054649751681613795952967740915294392322809288285233993693040149848892173640404342307175584822360902273844049397790700477182882310689207924774317032603681249794320722882094880691987859
math.473  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000004100266178934990693231790520599503863263197143165911045016204926129330750175725156699606116791497096390790531574856698280178568319326564405444743671890779545428387159845984584756172919204451989318871975511768522951511758375591150420989378043342186864192540990100605075045920336355906937730660404982838744407143216654059799921075878117300667197812742605526368783407568917987634157120830557282168233649231631784947088504679058765676401980442827630085228734793430997571040793906126017152109811165096227028469858906696688101379230483107557641159697866621728597520178041380258245122150611204189617197359834976542306351005083428586033123698583187347204317479201271775123736157211752930715434980808982007851545364748180382519031260622471480919523086329552021107295044352467581509592332805511381270269160140831886844893899527752277861806334199685842677380959316483628575379923917574646523768776098827364235739743650
math.475  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001025066544733747673307947630149875965815799285791477761254051231532332687543931289171988706694276953107364480416910178508971765097865316910444783247017938551309542382464235221028834041373698876866427332380217347320016141826673682263109100241168115986711717758085039286431754001977900193672127798323698028383358484198690180545646953575487535828719502299450278389233395864201600574659337713933754358575146023778534076177193295051947569738136851406107973034125456516102812182417440173593431438709414316662577152097696948474943630612899680172595077948099614176995548145197376186846561942570634394204534666324953989662883700698569035687822595340406203563420995400387823590643513404020961338470483424408847402704790720305525297190531893309748076441388045961310248558230465201546597280395113765408981307832932552085461933091425950013465845760876409636577982847371018921746591687748859267700429847968796512823470908
math.477  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000256266636183436918326986907537468991453949821447869440313512807883083171885982822292673529728725091500137436495693767287123732720914515428620485936231028640882568191345075546333084926563415048479235036704625018855417739520860287908853767104344681179834467530701704509999019402641960287296783837210803997753117599828344422275597277674293219869972827283268210510802232257275865994651807350077454740868388426413354662699579092992281108408473455776967326857408819664229604101308000061094122956734044371567588891032915502989128146973469335501797830643154816855439324415791661956348312523959651532216159628155862010080901942681400408003341948346985611055468577378386521399664863146962424218240488281637851705445590357158331326471248065344197689020153774270926966128845188575541802352643208580322713703191328058557025510386655077793725841086098845044341645020714040915704814051448404034218819262538482303580385320
math.479  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000064066659045859229581746726884367247863487455361967360078378201970770792971495705573132421660531923233178394278530799895101021118722871768378376038105454079744441487424620827222556784376459117480975729539294646184753403891014774312815075848352040045418294046205300316269019674754119170734686310538347907468723452601443588314955145965367376112674312569630036370889310084382100326459363326000593177415764859999410914063670957882736571407551214790600565831005185361157634863815217423673201231528296456976276957013576305153258438104906240545860529490682502394758366520108582035070870127853351578345915238898655059769566422065352331435185510763933656120167595351728069940467638826178321802077004507918311105988670622161937767668453689114471436981687164719458275199611497344161849885551321449283319083306095926693898859381101138374151180955035876029503530066691077480505253457372412313711925699514794551473681817
math.481  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000016016664761464807395436681721091811965871863840491840019594550492692698242873926393279109773838608625866158031255739759699709495068967154452733410406334901776664562092125913575821573886962998172783571097956207145197451019511514035956750949829269076686948548739314164102120781306182889353793720653054750303759170549276948235294048897691066804511070812399737206627869298588459271799713992635121164923329132925051261459688890279020145155323497983789898114931972869067863908005178113195106646042831928488239609823910514815554831579069591860533455076947399531896548443458786929980522736339064037916797197465446163382216458462732766604963811614365441462010290998756504630037587064845344284485374916512606119511601995389015454890008664611173551141700581828685602915678403642534476342323422196129409547361433149662438072108928415770884468011082030567506903403611519435262894395731132157941192835296818704736897703
math.483  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000004004166190366201848859170430272952991467965960122960004898637623173174560718481598319333483315833025085601670216494916138755619921491701097421064184580861739235969108523948731561462166779639215517354401114490306887824751955925921003311249285285824182600630422571269746476769828759618881370156199223958887670542449509861467748982460808580478453961545359009139818479982760671338397813739327936932479955755354205252981054017123436064287498491163240821189254245877212264631480276107892195480783488806431141690609019787380704796119557670955708255162373505807042290388434737753886945876395587002151213638940290838627587241050518256887480937579969657481010717032855752866466589550350917194978064782821094204355530163629211562678539585344667445426822637899872097371721707011001549578770753902860596245382161971569814981765366364379946812637403749288196213450732766788622072237403711989935462091355948883158005573
math.485  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001001041547591550462214792607568238247866991490030740001224659405793293640179620399579784041924089463895740657821074837502892043441956248883715011800971305889921433418806966708376263733244382185337502218495698502792225977551739018946823902257198661928963103206614901448686986550597289149813570599455142239604163738750617111425481998851693602098006433882609327236403975937972120025635455767049589809888135163600235383885560032735818518111706789169560343700674678131390166820780963847576916513860502766810988125442308236054047281807977054704022828167083401353326606927062421657462681665556820622071452398206293822426202099883552994309574346417123722388427673964957759154163799277294666397969462140121106971851225851857272968779140489087288410255400938871205968133900041609135613450366537349345281299753589027866897988133560177473419464301985288312940764575290298205743531798590260431587379029987455902411630
math.487  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000250260386897887615553698151892059561966747872507685000306164851448323410044905099894940529491592500154417413373818832538856692911776098177524280257795987063332727798843457078479770003406219989814318437899144627564063013378661420601925213161069832927447399660355011368876106655780443570140714784312412883521723568271761468275099806500205490430710557165254895003960145056032204566354313851629065521230868608281078627955738304924800691276948632290107806833406578286753232862284173798164102500952406498439784359776250241840324609851299651468896926091324201819761818665003724417946066473571843662746527444135006796751793529709323648190791142275698988426551468940341986291106760878635967693231553454756767355128628856967336529520432639586199859572613845771902972669083589993195205077729336234341508055694424845203734761789242294878250583318474821293408839005650333358754942724149613591305221643328464139729573
math.489  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000062565096724471903888424537973014890491686968126921250076541212862080852511226274973734523374072584391991269889960277375062360122531472984002795320935128184695659692501606668989086275579531655130104431128790552349914082684334515297031969293057222221886656619779891967248743521061534263952642707290894965086570807598623725649474297497719979071049636248163784141757206209667113130281887967174648348983287057060393204505128646279311755385027705241755455515448257404641450732605271711620165252991641234362922607184623096262961884559538479560408362045861051480337545816868280067474353730645717050787537644818739957967422040358077180374005685273762298988986050263842123844474286619447985355236240071325679257626599893694473536289993964731992622925771018154274744285195069345362710393963705259070890783948605383216137381501978751644061856047478976656699577115889926867453050489432763393426495699167849108517960
math.491  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000015641274181117975972106134493253722622921742031730312519135303215520213127806568743433563176981974915040808199879577037137610796698140294847557192071282913401064743442254754628124973742829385993834054256193598070995953755036964490406019746627190491028410189551453308785254810382634622143741634113992754216734180573609171472465222202136404287197808260908580640102263249958307406041593263517428047446474189838738067474431830829134490506089654281971499549904906581206443342053547452761812742215301989576742496655605382126368241159453880040019360418054614036349245645737692169479131127043256783887643078069712924892556299632214089183503395312025411531226336653146478224503684475045196947157464698222950219557290506796184139766181696507662554567582661217983189404305548246356978455784378758057627323559696936327586047082841144215516303565444247534250254488751586132543902261468026144967591328670519061457696
math.493  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000003910318545279493993026533623313430655730435507932578129783825803880053281951642185858383275741474708431645464124284002992405006515120856917095782666788716279545823118414971887254794452864882245722267074903369922261765131416847729769707770720871278837256646373395212500872578249000915923589499291043804616721331388498624274724842574815926821031251116385983123458693748491804849755305858276768978373188587350866391068031818531253935908665314018239127068437901387062814655066361077885582371081213279493349495366063809493642400258763901568698960969688368312126472763715891684194199586368364955904849790634563676547592127594430093740362923647232359206108176233667586287082681066459538726867305712215651992609328610712866748814257346212665866596942544743274742168016744701907069137309956701883050708375934047052960363936588306110033043611086167539421167441421836732708528559739725039574274377469215873522157
math.495  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000977579636319873498256633405828357663932608876983144532445956450970013320487910546464594983546033230404738412048225416715657063555511967918741332849938143174086741273558110981360472020028664460529720643115197657608039047241906892928954049538893578915048629359583897602747933858559218157884743828968125960197688287769250014326421802218309125745477124487110092110429822447798444569499579045073643425109483187027473974374376268376636637591261145251872887737065493086361288308593594463070113624282003414769665422822461303747682896285131778802242649053170661510490243993713498706279135979676825984247050199730272958812332663860767325776790353115553778758913456627615964273961203965367251421188723568433158275843270934982404102377930031061058974428594544530831788676429477583544089301166106765770251476587113680967811897615034745083439680096326470762311491799369200393785903089181470207588591306946295907418
math.497  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000244394909079968374564158351457089415983152219245786133111489112742503330121977636616148653065471035745276497013962400397531578325181520167403931788401592145436459624577082724565435950515176960481143938650094295208575394939701842654982190028725135230229260438480337444065343666670798961363871915599991933094055177807009270200620206709273230171308424537206228998344713736766343495766797449252782058005456269414430893310717696457587783003955331632566499525900278797282932254338280221895092358427170287279112489172360339062393744888388397822537290390193253892324864828123146870638410815822849910632675408072260297760787032361761581451033330676480740267910419876326717400788152420983219545759883558805823821624740849886644119775346531173536443487044174971146793228163828514280529308704808120803951674775523514042812497630999428093000746552061001756898510554221919348734536861200341731650967145295057616218
math.499  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000061098727269992093641039587864272353995788054811446533277872278185625832530494409154037152952919173174551556920369049679229262629773549840486382788869046957842927907260482531635012982287737484805137916599860511272319365498716287169004363017992702587925382332789872305117295985282789580556701251025241356757046838944001333712482576291403713343405919380397361532569722574767646031270766557694198016739733440166991720344491467109753808442991600001952655237197837927696766027163174533936168345840906911124756298469144403955871206975311708884089828574207806607771806868218248002227379688843671629647319920285398095211405202189753445049032771355612421483674718405536664348060164130000842023172749350560027436899848657570636943463266789869835405927706575206259246443026579547449370770528762768466101257364436154939490023998595731887155271686388403328319843981741991431970568992113502661150548540128153992058
math.501  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000015274681817498023410259896966068088498947013702861633319468069546406458132623602288509287092291061542330381748634312373123578773940961882192195679636005952552263579049271614041503467245306386977482979327919771165657421513368400839999249743144518204175625191826257456098600566268301228278924561727822900287748729135272317975681597866581696957835709735269682691791008788340486170962759780954741069482384864936705386250557420546284907085795750713280153767347645043806668099051501319442569907117446079691514915742295008242997451233943201270218164859458815721303804462768484774339364705990673680001716793707306035254497228213767153927379320685605620548358404216797863149219035328669550695400295935332899773410697265290127529266435877835319887684238816418883193627726175863596305480506016462166067278705764069718454147268161079369995805882496858396611036582680504901082045834917178234018224952862572747310
math.503  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000003818670454374505852564974241517022124736753425715408329867017386601614533155900572127321645746239635437316828107694754760479484207193184111448917955528963178374763197995422106383516444488799172982623670272045219632396745450927385521517203718715350707646382669001724033322110474568977295835022206336225284219420173699788830246583886075658868407651194834389590064389220878422168087983564427340732519423567808274189347148094942264043342924543993877910917689463634852325021278598838633183641347689878741638042421325710511070814144964083981087928774654421610189992609815710183576085563622678212220778838694739935382148002618036547219350275423670618357554281140021269256537404996226855298176274212781895783391930393211657089711857271314304936306798708595885101165979336075041639416415196797524103823637674108193175764408702820822793575017500861326372972498610723955340932706635775815223751689131203148520
math.505  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000954667613593626463141243560379255531184188356428852082466754346650403633288975143031830397289168158843187139354603317743407070020904153090462229271829759287067233220733487358314219521925554271989395292480853398627813164456068644184279809991841958061622453488782436053892846252402931736187500819104465807016357665556801413678851101309762767669188569334400065084655040810756508735314190649852230886481339386033122364431467322227834421419786507000466572279761596129392575135816948741701034189911121863561467135308972994480501528824855911600625192448301633461607231904701990072386879586173979645308704544767686384756786778903461825746117566108082756978504932929567644202993088316889924271051580265327331473237190248334864439200856227873676678623143112233360081077665448972285855776219310321729293120483273452367339971473774673269343431075089446003096318020140110421297628443744246658646126484993867412
math.507  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000238666903398406615785310890094813882796047089107213020616688586662600908322243785757957597750359623042336555097281899330661456279571133501793335071618276538930208944733290431224046968237788981469443305778914764103379835818746040985753955848228021767855352396743925114580079706410230127754823670715532801737566416667930694354889541629212977532032291969020203414579649229787830955873525585825310577655357650498519556827021839250331312604818906064110224483866770608364884112901719989541002938648490174398315464672405845685055513019561426330617543928178260682345357275806258041561018321526461621844055701300385511839557903543193509946311658953000609190913482833499086398869554575901023141966106524858279585420942749282858056177663201697854278441703636470742168319257425720245858363439829410298453605960221306858429515411085090743105051500694768644116263950655372942045840912911154558971141532351008492
math.509  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000059666725849601653946327722523703470699011772276803255154172146665650227080560946439489399262930748352977446580835038154310885044820016178690309073866884408597909691513276308913087865553243466603879039571726298095715613215902759123922843931830373180630526444688254608320206494108943229983182661910188871923883213110506915596742634996669981204833814740194832251548592981246487324143757131342905228397273660453058416561508610614128492190567775469594646003267604266673500403237573436364220996633136274914862003729143730396603807763448701899463036034859158612405681359256721230213694312592480380164087027114674247228612644798869074794642589398981199716197199535033066610670770622595474009551275032459454757728502907568568597551569122562543364446760990451095922918168890457514467782827174392031942262214148605937069200653440228229167877354050787886527692402062538987558529758435711937648114595351370366
math.511  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000014916681462400413486581930630925867674752943069200813788543036666412556770140236609872349796326114042954729179265933240982779147308029911699463413573645026659689476654006049006267876107675485522086849097553499859520269934456853166426591347764431169643177076716568357756939584566137908117924174330864503769708995691345372576067210669096577667786969749029166463171860243075740039031217445784546409023992640364660725180109727144465336599865103769239168738260404330239563941627672215579997427503631365821569479114425113026437003391520057367204692713173125003745505020779170595939698054891331241877610269999072283818806618843788704474316266236887928955833623185474693297003091066692539753138013715803800013271648147949516849680217194559744133568213128873364327531957169244973314058794128125196309427228020815102125411393665250255635425251496043066909078788076631882855368758899438000849220637632738842
math.513  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000003729170365600103371645482657731466918688235767300203447135759166603139192535059152468087446925242616817612020822835943846256774171788129816742091738625026379435868393100266372003230273379421731503719336794786532664138253193083035904800130107235716778827052225350177464773762058929976024699399943385480811766610817650058869719507199665431417250242844784629288913238219095514273768741617233060278367049953558993336021160072609672628329115536901447097807497366996568178870523698698492135314201055178437805899323011629159038499188051000054226611583432350467085233370755538410606131055832404500670456876265685142480384269827629964922368098553304284527519707206413873992103170479808837747624357568215293703019989571414994722455557585628918952169948873422968435156339890653846990682848976495384398397071815896665374820734163281189666528535465537192093823638294321415226684809219197158295754051498741771
math.515  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000932292591400025842911370664432866729672058941825050861783939791650784798133764788117021861491723332657617419206414834139404414359033771553282882750791119916752199229971468546007131328359780015538659607500483254253882547893634345912441546464082243852492694711602887168338439635973429934518726797995149418568861513546783523631403424009624578915894020920847185835033009450136627285652975923664337811415085633935172958810527565317851978430165857527396859422622521916560340139723549741725270680005523841316155476165707929126549634482111722247731557831562067786503664588944961834029612743145147843807665564005872887951204497206223222473690749587339059252592377233897928026462681753475590956180952081172957728154777711768903872686400035275059776038156377187148491756860417034958712531115368200415161327093028415112607306528264480916275953003700839736513863644680902930630891848926852496822668126531577
math.517  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000233073147850006460727842666108216682418014735456262715445984947912696199533441197029255465346310019659205956357237691665722239235990302788220427333934987016221503307929056683062351115103226699826235994028836163164288117058234218290473717150538234014973398121951165753837943119247570228140367166295919026444287367321746051987456532040609943626145097563547118065977578324622058655873407915515773197984801670444525485816904067300221231357973013124367000592828375310022412347688258688584577512679592718377151416216590751209103106691330427949632846141494867078353483247923591789339603893461908930121967257865235020502147367959818355809334878342262393902910514688088031568887539475632239093337218855395439221273735611178067230448998010951222783984669750380404569848112841645060312558710499862299807044893711068857705041268443025887409243335652648138136928106639262295170952304792374543250683517154282
math.519  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000058268286962501615181960666527054170604503683864065678861496236978174049883360299257313866333619636747557222595490976597638463769690004574821740905287880869360536281004544286814253635132175548677923911913743536445633227521514554922949950892453045402041155371241856362111493711254653537725030157594984886874107553355176491886698403194435115789737974819926174856721637393819294985043714476631073746495433900846521364445039201495468654646207645858146267814218847413740574973118581778438822591948000287224598472258312674002312885929402764031710049074548476586385361482527904686471372875047330753092444487500819338878461381590041349686357463321306770514721583952352206820678332977809466010756365996176862244404489548900416752709236016246719476972591027145862624815206817162058745962807115623209139587202959677827154530433611758397915613060815955936475315237729361475121705227495330941794984941174394
math.521  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000014567071740625403795490166631763542651125920966016419715374059244543512470840074814328466583076257168306609371781805669543827493610548796790616789855762896823436555321419497777563951323987915968734809527113952527909566724810096026771658584590151930698150638062710910950281098867842278157623730182251873290653953835418644989131895719737869714430044035582424098855459199520563036676319920536656455663810170688599545502049640203485201294182333269366722407429675722013833251059019601967409852727604353434363422996646299490632364548002079025279408360330594114088220658708578781789148777392843211002511823235747464369955212145933256891882387409126996505526008610655763108536746733219838109968203806659421561770306251422092005851996869795255417700562888753544682144708191646215083515102837848760948595077401559297232192777531622369368516438366133061219066309689638004619770313229902365917574862112198
math.523  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000003641767935156350948872541657940885662781480241504104928843514811135878117710018703582116645732547401123019423268680475178647045756864716207118815634362133037646650446568801776344791352991644591211347349211939570633565677759417416400154824694571922772310333653850332514894617790595607071991915357503151432686402495158119791662677300362507572601330669233269219552859399363433252611985708510269338795118909279727686082798701661600357018240654856809933502578866366098311262603743232688294577166169939771184262311689105076393878265435547009353793533617259930185325745276769206303673337753468162101675424666147798091838551070794113043831618438127935842684721443234494293846010021540879876252660160060623921736510299183927579274385998494772129289367674751552911451860799894860874967609160031889703516421829648461073698571295300090706582545695480256677852471854588215910858537227969415799662576767910
math.525  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000910441983789087737218135414485221415695370060376026232210878702783969529427504675895529161429079417952573420297528902993849558367463680941720217038637356462962949454246816813703173848726540392083651369505472456868418088714197178437119449460766052311270982052323453697095327215173872190878368846556578601448563244227022538096210737128328182662748164857897969253031335724073463314113490095590468285003503984901560679351538576766543056769157240363128233190196128567359500627898583893425859713098826031957512710360686352772249810800896002858003621773468230325733263674022780759404363081938690682948767844474937189114495312600802929461229809068473519909357534873091374731404586676735878798844773609855680074315326901024835167274120210320025400099078278533084790603575940667925524010199410859816541473607425610810392839169183231453157896331113322995077259040278975537496834099509627655413791392925
math.527  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000227610495947271934304533853621305353923842515094006558052719675695992382356876168973882290356819028673900973349977646215038811472782309334312333496331208360580978054179075605567950383986989719604195608609901012372994263480926077588692988343503411869409123535519885143569111319860592948553216764844939702416046335049116670336062085901749002447450059869734462592619175641248399385790001202052062154095817835566502381746055043381404692539658409519191437723173886888711214569918509434372377230295059695221966223049940187946884388887642891672671596731867565774177277579319769957531862219087267918313278101461950662766675240603010636745180778557782640285902208912021057970618061295169794018275544030552439408790584414653576977032209829415843799139577489366914897805369815417671225197946199236198358618514960642870531710025658838330164970800730516046366936639202725755140312466698166210463811860068
math.529  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000056902623986817983576133463405326338480960628773501639513179918923998095589219042243470572589154665411337200923671680494490416410519620566787225511490787561794235697036641600585994172626297681951752059261057439734924691313111380037179329555740500336775324225943083756314455166957051946358743673171828682500685537160862613782468640931108311854274288719762884335747633096893361817599367835453148945974022778076580200397821916536388210923040516528500035226509405717694740304788595229207712194958503000783912518513092096625420917301436967987778303220277862749553524391647140548729978729836915710852223707284022390411515349105215900714890357105848346249466673911966189554507289995632890395798803965544794391749802802116074435847974930645381730090717229286627298657511329357402296411530622776831557816849452064696982986356188456155469492744040204521746385526872388223722580949779426093215978223333
math.531  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000014225655996704495894033365851331584620240157193375409878294979730999523897304760560867643147283100602041184407159838894814905607332576612053377726473584165076229333263878775686137484086667487707967849269993677762582417292091766261386805128851081183950768536287163114942197605385958852236580052019413550621414991583482737572523752469075190543574155426763152261000663518344406178016676990850414540593596380604317606768441375096974004189173974891419414236547879149028159010639492904087882989082033721229746515616877272130297733023781299572440409391743077280991348885101455727523656757654785704544118075023829171828099817203441530915747408585925045697829119238556611872109947462236974826541131213911060307628370783715231944433050443553271706484010932664924795877749793602728968746245064842721586923026029846359570658655808903437762404677589551902091408221948871995317017249220172454650605879286
math.533  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000003556413999176123973508341462832896155060039298343852469573744932749880974326190140216910786820156733755505454705728476058426569022329871941852359240716849561021007216150851486096641484325041569006147763745994156328573895753855230301655737624006343497004625457882691470833389101160088081975021369723959353832339680073613672399547157871471151537653292450715011372936452528760416561187919149914844122362903675106030212548322246980372808938840996506108849972683408721402515497745949810016237310239565328468923272532900585118701877363627649112491213897811255115120236656478401308559391421989148943680835490701709767838485654551918772367974271971889489566567952954449495588561130997062911393710085915629679038646999519855511359847720808766702449355134531053604303399153390122313051929684875430007130827110637948339311030922771214259417061442543732366358458925841890290094689536108759231133000827
math.535  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000889103499794030993377085365708224038765009824585963117393436233187470243581547535054227696704970470466121847333739758165128883054380881199741748434881524422695678460286397340790950792167101877184348063863304442293065002739090587127015995985253631128761572601412891609638049645073840905211839201884843505550606194464683370662961624009296502043688739413260849430477612684470399235684051396537291031743420084144165750223029547095965300337526438970263250528291537045048092444615088447257216926843415640361858465006977532642480456904166645958625525747918559252918675439036510687244980007642797209425934983653079364822671492891183400415112088239759824778287191877632870738554883217169708088547597356971266512911324788424249601327389173533587415595397124786609601731182967348131447241102723486255675408881097048433370195885079225903743241800859581445526267732952314193198530110139489468110360994
math.537  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000222275874948507748344271341427056009691252456146490779348359058296867560895386883763556924176234982841779960017580232780229136407906155101521954733687304664833968174141293461358206379045163437916268214763899533243794423316703266637177953252924234594693121939755127701479190459348651100471807250171068971246892782464194968639422089537432526146688520880954988927293705918425494111070318333852135901760599508143824145771571324282896533078877516916559017921267431752730135198729686079413140516568445857332724357816727428903644395458646987900383769168833584949900212116807261022356259182800607771247626881673980482449230096830148329475216387023716623456870849937374523879812058857587142820034346637394873087945660266318492433123328310752693701526595936645865997406497789667510749231750589077671260108268239030875515318164786429732791951246892468024548557752410065574918657906451390666505910897
math.539  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000055568968737126937086067835356764002422813114036622694837089764574216890223846720940889231044057897402139378691522312999384719173566642642223435086195928783892941955483196064539169140622394038163592879017537589307830010797690878147126675035392825205228388856191460490998263986761707659214973041927050191780700625081088438159188011649215894263775328392781175064718623298474466526917975131305671506652593840448756071661673170232204679963562328933800485443192232000217994973795961648839734983577636893636112349423720883280044496395719082355252859066673708024740616739128534875841283409066908667713769410758112223198740149200124457150915523063123330067912236610484372966652630373042346114668841839051063195717945923283750514385277144015034876862167893052545818890274811363936738393082427113867534347671537720394473271767757785076216165571956957877051075104753919672805813890781371654907132071
math.541  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000013892242184281734271516958839191000605703278509155673709272441143554222555961680235222307761014380094056443415894717672549228134679449979093963927412771375715952150257098483869722632138405394947099361659703801682870367509976102334260378741651292186479389523702851555754053724235304922885644249802452074956724985749953737787656580660359156700020762436130279883798071413540639823787602214722120148042307076224364278201546069653489748971220881073947410800447608462272279232709798620100940379999898603173530690817897800998438331530876919535115462467358407214376478298762769229994284162401901167608666471061520601724461490735298712931292022376118013275665406312481380456851274310536719717193377033366276232793605240938411974996786830493429450612761158186137183377360284189170636711997763578431268637998903954905998251704085037835475751188884290297399153761238750190772852188080536634685135585
math.543  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000003473060546070433567879239709797750151425819627288918427318110285888555638990420058805576940253584550572066269864139353993201293812950196833280443615836086122623222444202495926969832539525438712264442653164994885307439367361172504877578739558405142364914074360512934686900210139111110303839656646875833333300618463548922105730735742599307845814513781191837470299029164185220558006077187594789836574401021421462501085559581305920001105453105495515532644694386036321354001432651016390527891980443699694467479392947595971762148755631740687477674988626076443685126023226350377569934619388585789935409699231124026538158291806623819805833841532373290417287327164764498872826302478145356181103114394569350693046957395975423226365006178688584280528252354553957859572989279048033113132597294125450911114495663267141969857051438884578715673205923177262504489567547289087101362482854753614279662414
math.545  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000868265136517608391969809927449437537856454906822229606829527571472138909747605014701394235063394973982789391453863720260066352358025071659407828877586048441059715059744355969614326299050077483489992010865253632846535087437149210692504941895145758903977624184641759417473366227850858125747471858757170762259458252173156118193817587809645186805315334603731386945523317141277428015471017764293479145748690508140499956913286271352996497618391423122826336106872660683810292351301153987881494498839908150143701148558801659375017392388318870999737747536693618681610586806653882815137736231133760490879260408906548950192622732941965292029552262310687036300493639416018428440522883278268713118099504671118920114123417510244867557234275115098219412044758895467670314678847350251774616950836157916649673105020385889935075022117410028013526353723999273222441599128055866346058656578103128157997673
math.547  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000217066284129402097992452481862359384464113726705557401707381892868034727436901253675348558765848614200116550528780250260768369078927103742750592549799515100309807593668140553078981085868726698373244054460140341013036759131836848698591872949560795580278578223967816216830857670494978112326075992126713048419607795174254555780776674549740524515768647238899642088784297580424771897236694265046238272256803872959123614135736839945902339418232966061996729127979283973433046402762502766481788293872648010608869476931794809026986281357288067446754712728841019336329427840484126190446823147644022379268677394052402356945524442021628201477829144024854306548333230122686919194840405245646122472100243406401461050381954980784769131004896660467372203134174205691192924871540225281081460836761069775877519283103917708516259905466558973658847744320183959566304130393857355686505812354166108267734505
math.549  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000054266571032350524498113120465589846116028431676389350426845473217008681859225313418837139691462139183853493483896653698053401268556313249898607618605767996193549546122643173193447491005282128635635804906852226979060573789241140949992425577039876140084127838892868652848198302589780111169024448017896698023914596692127996285331509114682104831857434463180835595649092751516024477035626803342569404483099102017710577439782543523712285082930951745834407275687420374259697333908778139964432565999692326589223031996563066871474491591100982967443753720001441492703005084095757083021614287865234731366852257419036764631321836708811611729941070631855074726734104586808418358050618334482377892760408511572600386562765699722958360113539833683338076568132233748336559479198632163102192369632220790566050640026758226273310325420907892076656378669044993915532782014079756584215958240287422812849704
math.551  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000013566642758087631124528280116397461529007107919097337606711368304252170464806328354709284922865533199721635132274340217053495761452915791831425180335429690283509347391134052412369900371780976766946268799988067927707029609199224685120249749095365835580664776738482792819215178734922435891827458012429762048552239407781837390275972132008535099412678736471504085332093040157141190140510248923432493165577232182703425805235200978056783368317457378260671762907769332973927540002726295928199743161803578222849797409945283976111363932570707080163084214190350720610037641305048625017774789657278385063287659381944233619586719084952678292479752932914074216629990299331690948432679908298937884269981098972366747544070962386302357982763560086943502158179941546727541077784167596728350680173500358914979983950718480244238954679399054574655467858335102980612724689836644221625123553777440704586075
math.553  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000003391660689521907781132070029099365382251776979774334401677842076063042616201582088677321230716383122570215645435271364545612323064766445664164436826522721597001999165882287012304270030260596005338012672497420716980547470480652710857748829040983301460143317606148793838671030012292332811242920214225227977767683790659445030124142114334793682769365476972058053909584798013089436052549268975513767252225607407965886088274318634150994541945708636649205787005346025435260773044980745933966696934874125213357760546069993754352445734465679504676718380389004709855374235895743154468307004585676590516701857673729785200066649190724568496815865100818869836800281446025512540448742159556351865947748321917227763408035712990940966631770412939066427898097171114797110036574047985768365622130087060559217533067791464748570381073412165060063727643137568733541743707598586181891051907385616158876381
math.555  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000847915172380476945283017507274841345562944244943583600419460519015760654050395522169330307679095760935865784955116320056651789955251333383408680511371269179931017826831655701800281714595866714751161635063487694477101211604303718083736686389915801517674787830229627629958754830855045422824452581670105455174682399045109729597474482688827159919518847462624591530415644008040356942284243944319222663380308413620570880348867822470929437163908020350368356354979787003093649821836977950071036238272783362747752328614948736634445438495144486476933902783589958150196433680328040411266345710950592548392233449041549818697828556278564513432223182091540960897286482011112193980238262897968757501458609276617804702445175908833837425920056793576555433186145071526084382007960056235420167854819429961401441878415975503563576558222474061020650380662587529112391690512305054421162456278085744987992
math.557  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000211978793095119236320754376818710336390736061235895900104865129753940163512598880542332576919773938044334432193923355449746137398708358008893011383925104937280589793971305069956275708082665227450394687939329626020284459366812231746692261380032982694332623534669445534245509624564169218852934509262807507740189321275360724725825633231946849401207343818317257764337714346197910422989154873546025113138182926644384203537062256578807180700059478795744768991814183180614878286011500827695283726042848992025615940326019239675163237013595231919534515154909127989877423386856197630909001316970440468678568392654209376981613969491654886941983691315956901330464086605163690791003181958219602935854129276575602775884706540078107724504297999260868050734592507434695504652274852322578998294662371210958156122263015718610375188043291807346910535774681919123863171259980896811601122205931286142185
math.559  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000052994698273779809080188594204677584097684015308973975026216282438485040878149720135583144229943484267791162043496869466390222117443258909227790763323752639019906930411046369321922522706858987457379564432035948482802118783682234584651032977804827308333666644719045924115829150453118921144274798742859293432490543731071733332839710812522166532106822509424156312931137144902152820343250314535575786777038451126546339856592938716597059790611128483573582804334449206834887373589858317226336658853251974452992791402808204353126685423129815607036970647628794263470752585810348387283284252066325649694218805910515560956715176613096085127282502950673734170110938304890573879276685329762113612225467106968522344003895262562701589554087191264024290797246235617863345358676216438427159362300144085470761332401371733604536183705718231396247857574112208947938338283217981075771179680765056300036
math.561  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000013248674568444952270047148551169396024421003827243493756554070609621260219537430033895786057485871039915296510320442989259076392445944661418563014980102204721616675038123477061835732153944736212309599663610590225160709849275923165989550494346356726397329273630271455933131075950710240279027048489073883841893986053344469878186968450523995070367516737310402716711608853182199637243055945175582105755994362406388861828976527053270960154679714716733611805044650424824120673726329428208952617656922268495658064739053833899066197306963630715942449841123679104777382938776430157904785939768454823826239825806078836682495087462464913448113553072051967173104914533988872908661097093755297614607290530756823328580137782216689517200955647663464361651625720110138501281125534347579076488985782607196167965527944193507823738088976100591547670651279238565840426249477189753231534570873422139243
math.563  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000003312168642111238067511787137792349006105250956810873439138517652405315054884357508473946514371467756975213683074135816499382527343167269144820234206043778398919717919015779101924377074906719144079738953700123498191382322679273231934516220339948965807606537157281747956650792635299507299841462194263052944297017960356692039737728025886560533535177578937119317343011990708469275907436881385819679827082957359900036807007509706322444494054176924410526937380891213101177111395332489451158944012450838668389448913100874502321594204721116076106869478056078255216827864909654014691598958892772575143411038157114019625744359013938555322702797165851298782515773854365086645757118479173778396814030277227055029003862516807855291131567317848208303124312364460724985264974150007787858142318784145142189857527736563228410255498254970539334315714723234905186467298265216231943418676022096769952
math.565  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000828042160527809516877946784448087251526312739202718359784629413101328763721089377118486628592866938910068926934536739589802679528200828818447223047179636512898323830807839644788601209235592202180308123073192648458053506750728262803848567874257452764462121610724926592210150463202455514188625412418690188804244945955983259414015687916068147154400811794803691913956603569133386509403445270529301779528392153993035880023285369695378013486171089703564822639281063299006990151931340094730354934245088167866443347872842808695720042627014690142456390759747798176856101042182487970223342104767045016097366403038751542045924208184370720908696618398566601567926571725853624543531859226428314572566862934590301179799996658567349435170453216455945440357346035803665219357679707459519705570895890396166915477208301354439169545271151375722968589558624764741075395345681374630182117439312680685
math.567  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000207010540131952379219486696112021812881578184800679589946157353275332190930272344279621657148216734690435621307634494393557008514540097374860935150202541563021069218930171452143138007005441629107625611173899331599610552324226648410606355231668794632298646076327028392769810294752113388753118266079075382524102590936528376193923772893521881803584672867724910724317120022610719815625591499056897024668539852165558955727649433438395948579740495997498328476001535910920459658412958896483853005255879935715107701497519398579667591179075165772884056838613103443717555399853333280904845623407152384827582648987030633381097977854682168164086518398575023608916121208235685459323212484653520516570985197506587297651903625514126167580684635941357440663754620670176767539946250157489829941955407353244055263173408057519037728538530134197037181267499147534124281028553520593149758278368631971
math.569  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000051752635032988094804871674028005453220394546200169897486539338318833047732568086069905414287054183668488726390686435764623289754467234362631803719595927883510432667091233096746494124507642886776235160609390579172244453809061545103524520184755297823866346465113175737222635673716815137130025235907432610668121850706647489506744299833985204457919303867377927345796959290834619552671372207569870565954060387467778385778842674768410522424502071995536359472597926225241913150674824842560810859962220244574493055799231927473133813870143096175279175988774820585790410518857379353535236610374893572809484669714586749530975487499273417338225610310747150194634150671514488830980056924549719552520108590770233745706751413911824131953779370204740154189011598575205495271816527976900228021080717915917927354187638017865705388449958288554802944250034465398832269037477464135813917291245396020
math.571  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000012938158758247023701217918507001363305098636550042474371634834579708261933142021517476353571763545916664383938091365848515159952598165259426458700126236692294848762590440526282607926017261543978230112131460787066140614963123562900050378123528420816451922846038648263689380272315029505847799526684510849252112088672855076440117085093850520349208590125738499468617932033635868233690668482524588573386752938424697765479907531254431386472855067064089267988273173635315448259492288510500692325858048362967241273041885392108771766379550647062601518400540656456690580015872426754043028854316308077360349004093591794410204466231778903437884468251409114921767013264254541375197752065758664810071364439432626660213780492313600961046712651117506789915186910875185551451889291546824824300744271509762071080398489806053610934900989884112449143268598739952518810319106713363961546742119228569
math.573  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000003234539689561755925304479626750340826274659137510618592908708644927065483285505379369088392940886479115229577902814451835383045258580944719782205056809697675627812405124826492102677681415997644591932836072924617609082366082623574082636035297479946992098052914602994836036707346316558477974363636878055403093184063784815543952114534068923591439883912158848880366250390841187520907725838351381407141147776415399397202834855096168375714063746257210780858414988762046537664274141086544319712802255558661218980821995502013126173143136274619306082033157295438730693015423306373708360629494362008954390063539337571067377422975668456348835570258148898576065583817509244984875582085458709490162343375266114741503887034359524337962137382783849475652880589755305873951087083869025033069095303385638128730664232544904173702829228422190422940916590725019741308375429905171811407383995138274
math.575  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000808634922390438981326119906687585206568664784377654648227177161231766370821376344842272098235221619773155571517922834037356100993427417275853054600341371596897577741005061629555412542139863778972210973609064862761775550699024952611568021159170391863459543505987769960251673431001665359561922569558546541054091225169797794776838508489658614225133274528462075359780366462319632212078402232791573678920791098367796047283787788692479695391734511719288926284227994654731210874235374920830916408422209483616674366134354699870163812449424686618871636696929593368523073067026063077231589668278135636195130162451749015183194962959316123347405718714936533038385596636170862127299952760313121273622770271398775139880042352333752176662353768155539007643390622238067213607016577733682646745932586108213531092205061332577207125601601647297227991467581935954755778007455561042092789760626596
math.577  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000202158730597609745331529976671896301642166196094413662056794290307941592705344086210568024558805404942660912550838399740284618545999318885175208465211892585667797172998360409067970370726257594365075585843676735537066772078627721656107617329246034285392387943937352830591979279939513422589587621907415457992279905345341454774642479462907071915122041639036208200238917605183513159438608517239647641786853208825284205235664065817591759366688223022496649084503161375366516017108024860754422355041354368567434903798312984450134248172705583176170004252519428688851716415157412519466122059205145360556902652497387895689607582256262819784983878566274543457116518464474999690807721057108130477612517585873299606152161336979282484234217976017399200890098762265877391776032181955841689897398874335414120032267334914262950869599873358545402343215975800606918501684119636935775668153984375
math.579  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000050539682649402436332882494167974075410541549023603415514198572576985398176336021552642006139701351235595452545638232294065109447348992450872907095761478667132882930777045102513160563223206251874090724908449942827364381567701500055276181150649021631576990018595384157153110003332227957813570755346993482693097727039052753230416938013669380307707396953766304100647602112722024485529545704517574738775489839274839523929416749026341269478525468385706028863062410017037153051325735768374646676355404316088042026576384017445005679406436912660926026152588057832231189169756215194187977931110160900982550278020281166453665101207043508169998821420206782327320734265203512010800594242205428886546802313083332986603357741279539403630484673483853559566360455293916589173132565627640842893673759650138844455320600059902627812115720529066868927739155694681043883193922131443887384452973604
math.581  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000012634920662350609083220623541993518852635387255900853878549643144246349544084005388160501534925337808891110292846072780071161229709377304893682882769092502418324470197311831214922654891563748263304090037854558302194007400934005274388718144235498778020658246033071272453339452643145512449862047862826152218777166262926590749380671001251017120192211128857014208910919118483250198204573720093243228827006121022655460569916047391065392194723753865866372232424733283822790714187818358768098087855814469982886303306727313191797739319851608549964330372261379995319030761982646914654344779805341437888563137902631463990164146150499454623419712921272437377266334987225428713897168079745790380645357874914267744194519157694676489021331760528333174294433854988183089507914076523492301591180820417406059496594978321036410247537132568522032617972031032566116539699499618805937410586860631
math.583  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000003158730165587652270805155885498379713158846813975213469637410786061587386021001347040125383731334452221916146148908717968332959413136458687360288339908996230703755049666908424700419845129914698372643285998508019581315125769412338546854591010930787542745869997533739549225402799068076020094382922756064171907822198068946281660344259898911540933730243708334001273412204274280604696914216216413378828768804630246387281909443666567186753609335105790505426086914818287670231854968031390273325349647655086547291763788997860213958585711549582259082141393545609138757792277217265055393568763585893116274373481049108433812354197444139334436555055463331478652086170764436094202950409734907173733524234034750722412503183206260445030347281646263070101856054443020110478435836922944759539955992427694132198718283107338011754685340980986465718991683479943699388343227772959597323972148180
math.585  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000789682541396913067701288971374594928289711703493803367409352696515396846505250336760031345932833613055383322419159459819921312296149907167833357379159012460578454040232166064075184051353397115696522700684555050072185863938111037679509689766012274691188795885951567630487418081630986524066216562414770538367041944770262425696713179587289526818820151506676643199443022056262326010089319938383133346931609549298240896125479783211250996111578964347951521352477985104657530902995794912800870537414308619990439344411886908271550050171071083451395698373805444352691927002742286012728172250301004555286029366567032302846321959619662663445832936338720308438312109395216130051321315236215144566524778769432468535483353690821243039085520723385433171361512575814954181791865892432825565934122207766103422961991028906139016104653522068054211042135392122921652669869473823003811365762369
math.587  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000197420635349228266925322242843648732072427925873450841852338174128849211626312584190007836483208403263835195702782340546962336123244787069290926599698837937689337429815312511341936437349001941389668357137029961722134061726597466406820777001831522575763486706541176141198736683338355746113475218052927361701174915291257248277452540080634922873497144837972177561166066221724488076970336365762066290980324396563175259921994111690416136705286248269751718063845399145126428613174282574962979121855339566770229625680699812913914422080628286834904839842755616837598693808168754204192575016694009775243936430982885723715360079536861521603342416604351388922931225280502254710863190838844169801642480523060088087114424609094093810846473869250865441432289030432777839281316592224006723453830679184487224636890608580253820173051974838873134240185945085071790063388962829219263605500835
math.589  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000049355158837307066731330560710912183018106981468362710463084543532212302906578146047501959120802100815957617269916971313627473814056453464804130233803496686927303681871302682871445439355968527851132923797884934423070548841760371613030003309119174603425188387028859274160089602456462242834936702765535678147274052514143705418937640436099670168028448321501100436898956919408263187340733606996535001398990367966223633783913252726737058017308605485737588733111287748378206066198398646101815933522992347781202406323269041162912233414254797646193963349884399794828725589242354093843180924517839651150365887323856189402210702386525489159652876296185751402704945015728387654853363055246732418612898030493476056446862291889136505150682700543660321633157163351207896446298769316835871032743576194513863011692907970396707242943512159996970045775919842755092337119063613351884402393210
math.591  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000012338789709326766682832640177728045754526745367090677615771135883053075726644536511875489780200525203989273022392730181394300651652475221476743512215183860899044734291989510166305060019251148630334329427768420415554708318153324974758724849531846966828693622292369149025574827323158532981424888666147458162101543046471364798088508437932589013723131609652834537475449828772102310989525411180693248369996212396619038422835983618378457405442046844984614241078377957894419683723827747640311500954405902195160363319576881590957263379716310879550870685455709425233310410161055934791449135557789818374176338008698571232001502540107717591024697267209562610774176059838673472587125814397275463113653279919238884563415108411842064416180613063595971387760173824530839130266540543392603475179044320637390518397098966150497339569217460965090903191813318694099779318693471876235472728883
math.593  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000003084697427331691670708160044432011438631686341772669403942783970763268931661134127968872445050131300997303667255236695680512073817381233733153761805385930687785496220126693035848009272088880033868732547524065008417425303723885387968887927588265285015929900115289149043601047586648246185607579619632870831278521648168007092714281889466234838191004108896963064738021559693331270838354536381493462780978945044533491124526344607673819376646440707206690646428486674477574689971536313287003190416648474384290638699649008475960203281991510019800203496473916729896106026915771862156907450530094607016323275757916146296046875666999681774357532076440061574352725463502424863914585504077191406022859962268098556666760486590586112512186095735676201939184475118566965355486534275209645144366439260002625781481560293786349245578240474742518191019921851227193771818162598027174752287429
math.595  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000771174356832922917677040011108002859657921585443167350985695992690817232915283531992218111262532825249324295886815190623676564110374467140395983090412034390060186571379374980547765557616965183742027972202209382683742676604065940988603529657882169299898651344540408213385047768169005579438537984404643829644861065005079586612646279652196450963060038429234500880186457839264165250750209647877246829628344815382954287777105465845073646622868062382843507299333699686428274466806484737937122510759381999258056539120012158697379132193918872310440061307272244392026683882162990542973382433130610212735423855220026101441871738600244087901306584131749405259770578208819407973767895648284893764037232970958285004571305909254419963884350970920833009233578260997632446616170812327757130367845694431724694096225827031471203817127194067147513683786406962505146054002839310973225050532
math.597  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000192793589208230729419260002777000714914480396360791837746423998172704308228820882998054527815633206312330893868704466178535646100485745530333167176943625455083248033550143936424249283311133910557631789525884764837296159030473504036250409772818948796598027109805253790453480198738071478155602383597610919743684941436460239619990830086937352277816053768997967670832718203743486044344301080512240717834155708793653169981702540731327107572735741527746953698789272864085098451841376186302304078221329003213900042235514231632489913213113379545127181327547125603348405994436104993104149187734142934782763454589702437320375513941739924263858388676780708282531828687297716539645003058565699853459582800624451408451472139721232753204678095999048521996670744320123488793856512959380391332691189202833703014463392933288929376979354833162386365104697967109343880171905379574742017233
math.599  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000048198397302057682354815000694250178728620099090197959436605999543176077057205220749513631953908301578082703455731746380480189866553895132053755283607086014611723274021458227582429918800544381738562635413152561685571441815349840423861954072575413787397094223342601642057375295956628162791592334704990036394404649150447826996282311193761834477686484618666902219760650163366316663126336400983210299016610837924805572485736507316856919211829745723032743454825171510048773492572706682708914609377395981096929723373435071169816968365582513459125247400323424560961581826932894525766651139654727314691518001883914983490384031761881115653365798867616012354812075753221579859881352163782730968903552671001321866948265342063629906976739044541505791481116399586528473749160531483873468037741173024824189737423714824407170768874848341102149418963313498960994718357343617528542661062
math.601  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000012049599325514420588703750173562544682155024772549489859151499885794019264301305187378407988477075394520673640439117687991856171242080310732379208609680353746365403575800361726314993973831442572534703327709680995974975464697387825277184791152032841523479863758597953743389353828037250528382395413895734269907468011111762464070915239707936526220801501466660206825393098336760838544297669929261175106800392982051773532274404548193368354415797810075894841360129550925181439264417516607176814114360919984857244714776584200438027517971687577518746494580837093855500520950844348499990341515739762730372571873338160506505912806827103742029183326805699320682177576106098597131226246428542008585803169385541279578340370528050221323077877859784401922305648735636572287747868309313744003764210900373924650169956562387400228575660044201775933997940081849720499837232302328856581208
math.603  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000003012399831378605147175937543390636170538756193137372464787874971448504816075326296844601997119268848630168163054910654539276121099809691874088178564409960669195193679554068746101805846719129909440595441850039303773642985714393682485914636630537246926344588931830711424192607454006308960036360633213374590671849561705389188643287996426723793304665057629411694072727862369903594235090658180740823261956277735005090166733284379361663886353617823854443763205978967565002565234458925649104467423167021431151705434506927114872894682925879069981873313189685331033392050101474033375652888901903879456176682003672122812698393897229371975747345305860588067416471731206055352802451745352467429662826534515432120152897849620618035479809173420535538028449997939342170926863121643128401642341109016170193912717073660193562108924310728997463627091475012733088266447594736907854210879
math.605  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000753099957844651286793984385847659042634689048284343116196968742862126204018831574211150499279817212157542013313186689472742594529317935656410197575768031526477003173844514777028013403053646258747502650557259380074767433773329256974629802893430571719921496435938586609111829811562352233876529327386171123730022875616815876567193521363101213476697587872164115553255478597377682107038379223808262949524172109394087921028012195396418308879890026514271941412215450778973055742420320354834474812191215047398640161273585344306939733407116507039640530627807690738740721318810929217585260783309897450857870698605284354243557113317262153271041287187700518651595632201893794435554429621067605750751200694238623990925915917496661197910520993093481571862236409622781564913097769518073102429914341803567172432965148480255634989659526208146175207497072766429198994757281863292575297
math.607  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000188274989461162821698496096461914760658672262071085779049242185715531551004707893552787624819954303039385500278236564127954933549481207546090121942238179143750162432789572870979510233965392990161715420572968454730525317221653315512144674018832379457322140413264148103643999236792745381724056012587813697836915046861330930403161104701129090290374734695001340582897184554620727404585926988919743565363477415012385165480512728282279956597721582228366082291125551138329779364706075360991473640817148358732332545870713312529359732112483195936542687246564861147995379443990917930341252711939746604209311785363609027584410230625683983224724370407776257086061982241428611510520165436120544174581684003785335245003014161551376149238922790837869080116374334897612589171956281874797439853020805611212258014379846188128505967812839757450733413782030965084884321349135328001338470
math.609  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000047068747365290705424624024115478690164668065517771444762310546428882887751176973388196906204988575759846374730663573449740876155942715623410038546481341592840975234789442570714044990009929302092398578464398993465023550014533427456918317384228313871734569950769946026309790782368941131047017108118065147308438408503146828643508646320214292216921601173163716234869586442415430549895277142910632173061548274322222323499615259311042246707301949927649833353934535864559886229201980021473591065492566878909562516362197079042208867980857568706470200886692290873283647227181383203651384788674271016898720748282600378859112207942161639246317544448185816739008200653265304283749697323899125043271821004285684743791863955270094080901195454247659724497972356086789397741516200663959771993735880054665835183078549549750380049261794060314740213516068616449618609766619755590528877
math.611  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011767186841322676356156006028869672541167016379442861190577636607220721937794243347049226551247143939961593645010830297741012679938169321062232754500535043421736544985366126341752073229999998705908001040372445483255693468561700358698791142532941759687795218715003689213956542014808432475595335724372134620361062355382153660694160378319178359664025958745099306391340377636725563391560599431343143889546398197729732096065055503679900240755160271433330773540357658171975390775606800788413847135586518607465709728151731410727755946639541175578976950625273090967100869611672593092973570358154716065146281560748662761465505964955136271080177128911733644068692442875948414584013204834623953012745842162279389501251278288475766752503318578795694196967958999418289409551337984488998339908299146940493065397107619629420140552408365307574506373206201093247140116758124490200173
math.613  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000002941796710330669089039001507217418135291754094860715297644409151805180484448560836762306637811785984990398407068811678358119130090374598622194090611822610323377773611675474214686998944092782836325883505132420732915332592238261817333365466413625067009749769703167523658739634399347433166787319277649752773471255102301495094614916022598071067479690994575633968470530487957293205532334643161129613296902792401317149018328816799148152027336127472864203987590843120459439500683953889200476401701697350811800544718245594335042454744840630901308171943770810709721342200613035885247077990867593512218740967997226791001136082174823062529355542281384712753037522102693855328612081822923749443511033935820622604941987789041257703721259326244756291495303300484864959820369140182821124767028335818984911890112012912152333448900096783534678149257115115725782677779797308256642215
math.615  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000735449177582667272259750376804354533822938523715178824411102287951295121112140209190576659452946496247599601302325597803181555867686123917396956207032191410615958665733751068032747584546125610563510631156091550836718041549270834173601645930030343877497259203598663223229625906168345031071884133774861535703427162187413372419365978854749189587083160704310871365379143926730890840209130784147062685820768914579560305600842150927128299369383184885321418932686630382082405394193958416272103913744014192889228545600261647207461459972760236412649113991605821878400807940003997370424760669266692506411990912471053016185921652146583109518638177424550950395164915602245962902166611983026042168113296708822937569025311720874594141979847788091552315295975025104987202545793073834287452062148090079096711249791570024995272233618290367731456923902980051095483775542584468905467
math.617  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000183862294395666818064937594201088633455734630928794706102775571987823780278035052297644164863236624061899900273928363696756697116376250341776842779988774389295269140079535824159408879306534627482558981586143372626510851443878804156927073304627112982300732462548305447514315229377980757739869245310971029094660672180033037558860289753638518311270569523860154075228748383167176837747965739705855382370669923619737975045818032853748676662420318479915460052269436484618734086117283899377999017886244095039715029885075683915281652474307682836531015346757008690906741456887936604324557396461217095854814985349160014071142207609765880534157278676948384374668219289505600259654252608661997814953609246654694070705290908483844412721846863144968299765491010243487255503407064165810400525718635116106390601983309319586018892419853998966170823600208940200634771280497084733636
math.619  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000045965573598916704516234398550272158363933657732198676525693892996955945069508763074411041215809156015474975062742864729295986295700142514602833331467274323617292782091672629056654662401127759089806365813584633124165203367388603889911672952728751035512745701176487853656530880819460150145391059842921630988080164038323696581094269435916305076884356202143601803059423687466512333419629026726129180434683106311258021778070039213602629191793972305724659101762745614901134857912510747743779525281206549691642850412999136219352205928669060622641096381663135863658673422320046247085704984725491272777006921311845860728257138574422284119207378280801637677448021600371364536039902885361045390895314626377437765999029884909540752199714766954638125075761687548619344448064704863718574790049594769397830031314071630877555331832376352585592471411108715144623100841029758300518
math.621  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011491393399729176129058599637568039590983414433049669131423473249238986267377190768602760303952289003868743765048024382891420131325711176334999736919049772714709361864228009821586159219673254568545231638320458727368425297429869553404799862086214092750609914731672584914256171362305264349429988941829850811569295056451456173492208702960519565722706943337515112977605219950993371492607255775987063724816155474815840805955429710731288873530798605197381732703569441865090532114520135945009308977950294240054565173792031658783651497385681032694391363984605448929566103314870891675209850673445263118723504958533831028833677038904593898037700210221329520257948434497949245068861602850420686314103946739679335628274410532033352894069411095375058968832587753077200433665880588842957720848381580388720478113943289562743391070016529333393037046411110490054919897573957105233
math.623  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000002872848349932294032264649909392009897745853608262417282855868312309746566844297692150690075988072250967185941191151451341457650320391743826448979124454797824275803392869208295110150207073096751047241133233300245665999524934891427743506465320363839372080798616849949835898553679231644110610536409805009094876955394740269752867024383446544872312142899722666698078057480980557968246599318384926266934625655051455682244504829250681190845895722456806897975488292426491329295482563389709279620548266650155551763621307229900178122120581514164273687738299128616730550927293182398490914642534090959090903178650089122201236574751697058435805947565363472218419684343822248419230378696603994435320072757450934708808180513035012887242627577858666691626998339016105639068682546075662471086915091794524228867569210651513531569489345331060179277206241773124687702073224687355653
math.625  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000718212087483073508066162477348002474436463402065604320713967078077436641711074423037672518997018062741796485289915124570764703412205041483578805324968405527802113395640880500412383152007706569197085911130584357591987419836867873629493150156939790188059579138338997845311310183843716824857606234266702116221484744209213359044845054811827429524540517518519263204992500764870416094015834031470360065563968914877286970222035101307578698769794390073319077080022976320548113605235027584686994317544299763405703648447524225627835995522791022024475740829315184635612882922964664069148874289958739694456299308255729285940981500267862769098878188316808282887874424087419165333138928331449308092321672185636349622104197761967166303806169200861369194185594239447629481133303503792535201862225876275583415160781759907014915030225006168328091573903945692440851526182186145188
math.627  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000179553021870768377016540619337000618609115850516401080178491769519359160427768605759418129749254515685449121321604032446624541501063160985002096947225957612143101965290617728062523076917419881375458682448641206346353072073808644643124029524460020063677753205705373608057354905896542673909138734852748518420097750778639188810064229357161326631524506377432409662582639119578447397005399967123501834613051138454589812873427092717517491497730801833718190026801371227503598565920751143640063400807439483464410729077866449417245666450808808812117849609216521352117576706208267267039879752800946326707715036725928484091034231866735919807948515574701902246212717830495972860075597419269702581889483369367251974041854507785065959714062728525129896569967774842673569301560004157219697152991793408629975049335229399692909192557776750004910954854669858127305323331186261378
math.629  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000044888255467692094254135154834250154652278962629100270044622942379839790106942151439854532437313628921362280330303813812093176002822668092262457083026917873057172559809365276788900467997743155034624424006796542055570336693880264558004285268641241005987826487973389583438090799370622278149578384031955696738851329758581449903327929333903461586559753617814285109544384474102655170206516238633881824668938396037515861836661142776122576216705744702395699502865355108806625869790582349848680927366251703104048325753858178607306368658065771308294381286181443130487286050869213441817937244649724687728809159499908591073916665349250756575163826226930024120068403828950321540694476917090093155798832239009160854428377669441693083341471999357965284060224337095111357121707049018774387616276262893569183251578683166513708529595613405294089639042565839859342640348244981388
math.631  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011222063866923023563533788708562538663069740657275067511155735594959947526735537859963633109328407230340570082565154086405187403767542339289162364781221520488892814228642524172032861307034478884995040933642961172060608477436114116548510242180663218406536336960784567127502046460614829329189587358723611565884641559477286321259582742240031325540287286816874568179016348278047473052176431284698650757358835692877854131041517519417787204209010405196514257700277505826318996780817023140823224467182369018234369502665393178699497153593540555609591953089795905332888345337304178260604649389977615334316400887656168874302349225230789007332285500115678908811320057480905821454166105479665506860113975462952811691916493355028448834270954176706397209755752794746937708638358326354329810130498892902358628893306908532363481919064168964793500120343708971649930858938836855
math.633  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000002805515966730755890883447177140634665767435164318766877788933898739986881683884464990908277332101807585142520640088591977062784615427286624907046086915608147178722921194098262431298027602918807830104816077125022079169750773772251560479610808933778092386931435676002832047189744132027822289174758864964143852655987581882667424036257480751884448171857876781277991783505476810229613199368776685330873007253116388925719020604964525535537530905366223731421471838110241865132353867690310246781441082304377466506886185349319427596946703590894249104966674556119806580990280229109996893148057333852563786250249468312684647751904435135436771268916920358480450140973649696231103385041337213472133856471431401123309253841835404945963585910117748455268516129476036901118518791008709749810263172912056933724217476524068330654860299450589528716825448095028879947727028278119
math.635  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000701378991682688972720861794285158666441858791079691719447233474684996720420971116247727069333025451896285630159888822480461911006472566300961923176352260706234182881857798701099278140327874056389433701482585370578350885480960737081344641115940710983924050062113223142902576664694910310262910732114734740603725083336539146589340979707656639239326372386621524334926636796073122452307328430487984352018564484099084193246553773115504140854365698878838862724911009022163626261438073228989782545176930393783574816924946443053152139270535668879969121945192345906887251561037679252489326184758503766461539578712025171345275866069036965982815946321715041638745248005927293016233471308202298075350157384908643798988980837789414286475982159161355318204881965025991459128842948480703789970854411689275470822852052899512709772008109511997274634180543556820672498107255875
math.637  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000175344747920672243180215448571289666610464697769922929861808368671249180105242779061931767333256362974071407539957391674137279401908779869099943200157327250940712626193257912551647716573873443084971917411731190890420662781859615745039399237866522801744385927875472777722978795898740609523863961083120708655979106713304853662768387467902458276896097097992059377032303561023318226660022916516696433444686835425096788852968373405002190319253519258388236917729727554699797144893236481492970618798345721814098367632469924173866498681390743252422641776925620272231880729047511752497873332568519366914778115516178232718775482610711505666117707866238585684887350104704482268027027011646750939610116508661529799923454715126681780101945864064261601400302482777280624134808043690875553274040794062467579504467119129688474909920847285772851889053979638708620918471336279
math.639  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000043836186980168060795053862142822416652616174442480732465452092167812295026310694765482941833314090743517851884987701924536742256065043666592703845158138709888752257184848726724226171531457797370259852988792638632933395469791071385401212556399452644417046798949629348917295545350912423028540357943869468031540701669532230249965547712089354873693010984344144562752420795834753055774998855012072607860815947777529177717469726926023881332871311825222816210159319008065444744517541415808965272767006336486624458100493782310615069911621004869237133519169396381330800715788846672454634805312163887609089068747750378399358794198555099422145507065973850229846302311637108755120642777078556361110852226417893948848490222913618233606136394349615401700290108031135139066562517822870687810833678472775323179480961774217143099361707552493130025341589909197284257653441828
math.641  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010959046745042015198763465535705604163154043610620183116363023041953073756577673691370735458328522685879462971246742592912232497970466327683477966302735443822585186589160431523980347592641053411924743447582959481235937776798703643251906123227913185713708766499641004072429899839319778780681892786045785676577656782255900592203734900227901020344567047144148770751240275585224858667419813250422672046957114787324350197639794848808651624850826157339538798678712230870178455947032906242718373538245321155727940833883718844780620686783701427949667715798568208469940068028846176858771766206161889594535724603042036459196756619952081651568504478948453232299773969366373377174160505305752716578310211491203472530034910791075680057849190377440887452796845426755743591165667444775250567805307848631787245759549440362152548959285801672558154374608300759055260031923174
math.643  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000002739761686260503799690866383926401040788510902655045779090755760488268439144418422842683864582130671469865742811665327314507783820861627591458603243817279439023754679839913419097731865913219360862974968657963166591876756418059434933800918697731273312144039375873250759779229596951513043694614761000412095914812795220158183373977838363835881715507760918902667921069746308089967468042906625216054619054611457572715407734690306176335859531529389200423882517086554572693383797421671889019724248128784129708805870557674680105332751719061994199189173759863012956177584512596599418272178054643285948599715460763328403561985094157817714944046353737204993048053749105487135856233826992262884558610627660282909336940098852930545156688676923341146104297944070566013502667805684848423500362060970056175198874866275343975982640190722266404350560441200978979510429051110
math.645  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000684940421565125949922716595981600260197127725663761444772688940122067109786104605710670966145532667867466435702914073949343574769464856416818996551858033024575656229132178970119171296228633285546889210696926781815120014771936055303721109626799307199449024538234875082632815590138747616336236764072653846998132727189686488084599195163756282601365349386503189567004312490353539083556541144005696767765007106526742274850437373495836973064207853219833563576327306145040011142166604013922428067164784331883124955888431437609783917707404591858250269499604208924822792017741880719738077759180410460309556071094108705072486052031236050455467428359955382744493998859405250865384076351205314526332469961248000597508564405308722535435883012209182965332876343923778768842786597666441526773806068262474905602919200232156375226114562758785363331930540547168214305865711
math.647  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000171235105391281487480679148995400065049281931415940361193172235030516777446526151427667741536383166966866608925728267611859963560616152939644120886953809718901660452746622588679208194029417037535311522164153059744723603203172530424096580260299891000567870850976793815029480725436987401281174776808488938897347123432116214668115915267317394584400366539467449013978181313311982319470101058313517219431732117672523141323247536898836949484339031713715004063691337383212800308926537555961771698550633609030811027504697625230632957726920673315938037922599959114344849075151505665976994813866498464760706926368238009290249932154229341654741032393507568157132215221044649919164311389446984810781314453707963990714616083059300798198453621971697835058396651453407071501096987031585676506540355080779230011874810834204686193254511010943941931657103353676539565642880
math.649  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000042808776347820371870169787248850016262320482853985090298293058757629194361631537856916935384095791741716652231432039027912109764404031438848738193848374814476275823793719852297514867393160783400380554282118807416086728315288213983690024866377994390046324332178402506320921077400621067798759492353822711516689085563933270794794097396556876752351512219495644597000652831281429087166291070666158794940410713887988099973830741657918490636822412320555177371941116319190161915851944454217367751883641539240339959703712735702990308457027473801218512228729919654393438963262663912350019048575703259114585576533262519302347917674784010270771070385257790892902244786442924393539287890488270618525830485985241893670109622737280166210361146502196994548891304156932737668119431833979481530303960658562464798940023313282665239303444284637103351711333028081432986270015
math.651  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010702194086955092967542446812212504065580120713496272574573264689407298590407884464229233846023947935429163057858006659749929538239895993483040989807640635258053479349214874755235696724490920740825885959676175449207113247934473758724455467837383853045631782827452217301201048753378216320939040467056773328879956770623754227343277277891794676587696208897325381199093425815478283906397188701569891480996326907559238786737475304504636818840867756324555254244179093718862758313831244308479578642459086918930129120728099347208894077872818677807108415260765337501333366696933578938408153701827417699296074746072403139915567344181446677385064774702704809757598239371673319705461059013354251547720295749851405931323079875475119058990846741963011280852695840103957289804554948163924985377650568566243791736201930705718956519913832266892604955294303397054693306959
math.653  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000002675548521738773241885611703053126016395030178374068143643316172351824647601971116057308461505986983857290764464501320801027062019850457678633185379193151218844983548502042208904144167367255173065610455110580649799902976659420003517105891124409225403400382339563261458805890351375675660724881059083511120652047279688365799013997114790628379204215716961862962379840833616015338479917372112208334059540441970719225369158972910916118300554817959231606767898594052084513616952179256544975497978094904658241445012071301228004526026198200672749266218292556410316539484810236456802711587429048558219544284911648669290333255565362923486865857233105385707923877130529648115343187687862009797650006754115038797071619539449533798941359961146768189143648790869100069519084219028778208698981235631290036901996494827440761606178305557993918867537065970707362615054566
math.655  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000668887130434693310471402925763281504098757544593517035910829043087956161900492779014327115376496745964322691116125291962872840778282221009421956114496398071859202966147546498903282706980094347472984049476547565868501337552234298331344884953905752864848430418456949754196150360969240927490362051955655858943906462804030033723827812309795325608768765220774445767361923144523726878055309335308923218774476002283735923992414042241981105568958263544641816633545388389512592547806303780096342139444090801794636805278960892924631063534246659569871332062717233695661145784874725896321640569693683791217026167985928200401612045555647833810601133165998552892251698493513628520459639414375870223702310589984833472126943971968378298606072302204457707320457564160916775911153742908068054876890860191016510385253901282628166706869507401435616382487488283152971548615
math.657  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000167221782608673327617850731440820376024689386148379258977707260771989040475123194753581778844124186491080672779031318742119996336050511540107006780812778436536795972539335063245514750649276981780089046586366219925215717513118858419403709295108541693350759925492070377317675528793710092376055278157727728238924605054984625715738609887973578326236184999318946138957245146535700796565121674917842302537650453744912015440006164124034980369132366859537443696135770275073122780602453977038928511327870411987557519731429737951134927110778513776910790437058585950861646675174371251776317557318355372928588391201590709453922992412432576685944159256521129243646691660360458351219431140877698022493262511768451658814953882916652073694914010720787019188635813098420189741656856499358263823241473081684545758463717138415370176570890706012648622926769949385204386927
math.659  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000041805445652168331904462682860205094006172346537094814744426815192997260118780798688395444711031046622770168194757829213463530877510400805888031445446381155642198463246216925646900251429458511546338195116951491148204859827856990983060085582409073898438162017403419543654933969490869610230735329538848098166162909531425695172885376903161920410287442469791219608337156673676211202859046919950699953869401649476887019329356123599586051010800777490885063107342651922890950332028782806652058009549790853388192697999550972324430020470841609671785296913711977936348611694840617223992956018305435231783718599880863124080007032981373350243862858741170538252894154363507685366811358903219305827649207469499602074671206618327999612043847931111617298077849206813658510316919284467008993897515014886677503422908693730821535274395917987294640698591116282203308539309
math.661  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010451361413042082976115670715051273501543086634273703686106703798249315029695199672098861177757761655692542048689457250914052918655130526012150055833060460744771779157263471393449681053713435231175210602444602479512554388314050701450170481777034852389909591711147548825506793198673873111926817028682891663618371072644492981033230513242365097305474134227404196463191269494107836200365122087938292008038778723764128012516787641195504976526221469156824496777845823281403225657481129633852698790417971548001635564262664164715319915308476514582531074778277441129732829579158373714765523694823735161601830037261223594377491126605296820639783155833974923187526163309188461658872578306325693762135601377580344989573122957976393908598099471932161603154676257072002830027330823212285217671589874338604912125099573797848779613156327229665223618582778372263455078
math.663  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000002612840353260520744028917678762818375385771658568425921526675949562328757423799918024715294439440413923135512172364306900532140694619334229719980010650134278884296272172450068554044507467115179414987456929263856993642453565789046986984071109100525385038197566515440887389629385526751989059549939507279103421000566334127218567092609059555914186732607565851082956339875174643869254705577101034714687753323242805376497767584999568671583177040030524617712196186862251937762416970607133604433906414049741506826485402780816176930365582701838139275333876496432721707451447698033849839183667793205024407674457339928426406366732068382367224098841062632296985149021570399815834462310159494944353338171492620485664247741653731164416543664213181595013248141017344721356277215053509273003323118872001978699960414227804121889712070242258099008208310115168893154047
math.665  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000653210088315130186007229419690704593846442914642106480381668987390582189355949979506178823609860103480783878043091076077579580843747800527061380119594202357797890899471621652715358265093307280589434074890275000605537397980559111294842456530374290578264069555572756495301794582776032089832508486965065475355991022298386509674167242616406615246278635285855738956623752939260356086621948284458403767038548396544166686227807136497303536876497651968414003980389799267580729733969875206982610217653164720362801073149145679361250874634923521948893478278932075122452322203956141941928599942294254242733519243483879258049901853420918765247535449504005155160257866239148608513094931925117835517063696067728013037878669540284491277912762878805948497789445728296186012946182296751954997420098826694349276932120114847591960855737067187512600169604661338876168153
math.667  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000163302522078782546501807354922676148461610728660526620095417246847645547338987494876544705902465025870195969510772768947444511396502835350613276709557624899235785706137739761576267026076274429673545987195699740927861195038476721345085402453167441870347629919864500571921990459949644936953919135944878591245199697533170406710293505124028206052520524273656470132853093900126655017058634175644171351736745334463908530828109014360364218057328215793462222433555822846704790588471740795867854142930503273356271746439880206305017976953311613694084024350289411618143030211852737160298148823637377705378624959154245886113356597437474134303701490084580524554265794809349565658552583817777760800795713213480386082826349642142520486641575688919892113523578068945047740062687900272461993477204006264658928588449302281235895095205969892154040394302496273659057790
math.669  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000040825630519695636625451838730669037115402682165131655023854311711911386834746873719136176475616256467548992377693192228866640758633029417525311586240414481451870091119972090216003140941618341810185104445941016711512481773468567409092692760939413046840628265454589655090090455106501752663468910236359111767646773585674165309145006016663629643206549083955708162236827940519645830046456635061457188147829865354012635707491798434703960751417646180169802139911035464127909757418502743199818659921392113628143438413792881389618723999591481205452975664146092191491257134839785601003955653174594375492144744381465550061711326239913502312642869001416057676617352280792750417433568615908139623864869276030458336827649683594843317617878548026545632869566450659841065362558536233962822594656135336432280756750223278239224171734093115878516978452668163354512724
math.671  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010206407629923909156362959682667259278850670541282913755963577927977846708686718429784044118904064116887248094423298056328383846270181863255993719765771204434403485511719372534215939060132333718301676963584358665462861622553931666850664616419679270429333504601427284239440444491956856787143521553052245264584296401812316777201790611777949306099575043746869116522418987958717621727674341875398713746418873079151758902936902715968511407637335088963060856582577891648720029064740856623596737935488247376194042566486112670194510411452740361211875729873810382510231667782295953640607310454447577617501586256254175343231292501061198194094627085010600284353581520262915811956478515181467908034380141708532752635082982500309580335198089558340722575462189528515479746189547989243966084616925174495780554052689969799093428774890713853519217033895109800102948
math.673  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000002551601907480977289090739920666814819712667635320728438990894481994461677171679607446011029726016029221812023605824513983398590079981522355627965853183643783204867237010548686911224078891722125770463780170128074074544200540013182626665761792232995654039557889634822790881419908653373061510270883555776981624988320727331698310543797124236827237521433363625293437024664097652187861412432423855389938800106735948437126244932814513430911312250714394450285538037543140055291699540709052989043962259244286966968919465123980982930771747293809823318363360066688914696307865615414616429362207910837390692517105100856779446234448397291371992239379030240837711014500396245032908752242015119410865129724054448561544141741005830102681540263091876877370443911021894389869210890545454210645333062685216844141713650529955907286487109579203535084960979043776687427
math.675  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000637900476870244322272684980166703704928166908830182109747723620498615419292919901861502757431504007305453005901456128484883272910266053537976939897933782354090549682483826677656388165707223719908732004971364349804302568838832926443281015211933272819402098536604331897697879355087859308248187364620087146677358673049497638294011229141093828091934857182516056269093183093388651329480840364235875170969978365652208501997160852242222172317145034233927417366637796896802915614738111797538647757491388867297777239528455109499403428761283596510302106790816454437511601455659565639178538169163777174025012534995478170774494991692694703114815777680005582478941418103446182025377885058256581467929222460902373438453577399771054212941403112224494486622065767615843492957741126407985258679395152107727378402507797604987952841503221907428767252273358135429367
math.677  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000159475119217561080568171245041675926232041727207545527436930905124653854823229975465375689357876001826363251475364032120002332159818810378835340356109875744999229962091088836739495057647282950917862563457749211579081435075640248997982509090549723896521351334606726399896294460454208247159981084282403890871065142403184219343273733166928747530223225728791310544911884888234843877996182800375624879649720705570681894253907249234482213028193560882321799532022250910944777878880283862465028093810988708877445173607972107735386267116352358982716397049293943134830637699969269143331305348537265976451897828764559108402147020615801887281130998614227061857403283764738926167727542558506939137998133996923848111464968667260943532340050009491447530830008054567573542141154469387703261408327094655016452522308034303275697811152576737441277031910344024796304
math.679  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000039868779804390270142042811260418981558010431801886381859232726281163463705807493866343922339469000456590812868841008029865195699093846705191180131430405620302762217352786894443251321769651517833985592221686405477509791428246665054304250935313022074032271572868316734951845343992186380339024393646626641810280236765010988317262092864364297849527923794905466728168273890411576240109974939464349985483396516772460478533371111842791242271353095499731249303016326342499605461289059684305273706284311730805043012057759183809251001201628737643866050773718958985354883690873767905739772519031086443697234202320896488460592597880256954180948645912833779115521562022899460491227102913235586122930040551898682855498885158524441009581135175510235856187219206891708012011213243523057013987492735001105115745860248522177896581615345187459012542967214531979642
math.681  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000009967194951097567535510702815104745389502607950471595464808181570290865926451873466585980584867250114147703217210252007451255886900033244129166704235705481081574412874865021972854781259949632803443059317340486372436336909960854129777822013545778933826661759744580815328042656220680521752027571397302709681272299838782874321680801884332075589752694482145374172143507182402296266445562901093960364319811186753563383566848003488648706371157388021876690838821592706624930832087627277318868854144348790840966267668098004173641629826355304012896778581290856871179860545702812225623328184838169048202395314460345162404206086024024052380085476652647033411306185590905477399990158681422502552497262034460224602424345580577946261171554026070328158496382870403744287302634005939623989138987236086587878366768099146352283170443275685317643059331366758735892
math.683  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000002491798737774391883877675703776186347375651987617898866202045392572716481612968366646495146216812528536925804302563001861142523072405151902444083989826823159936254167234955311218356516935936350299282747326253693760006405706485017515534380679934277089046779685943159767942823340991246299056404193850097005442533563551477187386331186832416324574393343986147966317557757708199459511921275622165080801296829480837004909313039401356540127169193777234646905734042289372124432190186776954664208538043159737711407072101393012023343239868258044963104524429355109819651587457397556550285512512008246423441821559161457691888253338145611077219152068493632402318739162165234789044034663696955839267987481397475991056561278828936787973639864867238810308482151135247827706589515140238352403998193015413513158740059911922550239202752718085188365780060892260006
math.685  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000622949684443597970969418925944046586843912996904474716550511348143179120403242091661623786554203132134231451075640750465099914251145381405627955212001200555488802536088594363138440373894931659734656011052809378392877750055146249243989238590953813546504331221606951517042799226509860486523137075471691437087886331208087891324410082280308737524512667345379167515367360827228517203106478262498997814048230007924211461193529251004278901851909014166361924490068309664051666472027016694825223564212352915971715340156438771825918880947880155654640383173271693127020892097979414722943461950180033075479459405115952524648007600165147363980212708036017516482399904420840266803493041715154443294895286262060822888717249988066834004809169047636365360001346255986023685479947700027843743170211329991217879217165894134929103811168034053034844409734964696873
math.687  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000155737421110899492742354731486011646710978249226118679137627837035794780100810522915405946638550783033557862768910187616254343394235689065853314826838577335039393855608799205821704676213838200729201261010008016634129031524181377495417880538229887853457225637021398180930804854908602273507866105126110258104398477680074832844299505901687851556239931642563604175348617427509929677035512184020503600169844210272488214966851181602664874932164474064702368295065815415262633534068599798466183751329756409393340655264118045557942296685864092024765114754553855970320808281141672691507324406565425620584747880416885144436687918184166737704975842596935266404148346091561543808706359805223484697403332571280397284646820104274540201948601646342198278288716444924188512196708235826824467798512652042566263879030132404898231681304430613051173944792450286726
math.689  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000038934355277724873185588682871502911677744562306529669784406959258948695025202630728851486659637695758389465692227546904061293052053293790290698264913897355556203266300716536459547789357915693048471121724369336422038255809040798434586474501511052639729139287660699170001420178130181996173236982413919833970793534350315229942525788168055616648859147383216811127297909468967479204517514761777714146821611747369434377603617874634592405922597344571095751742056989983741462127486891605419978720570341888233902869884478965762596260045183235699683724986196164429894384767488003729640223575328536763816973263438631994826909611076640422112667575047481812780216862816635725687413680029900127211124607588662762742321100035485736878416278504641924706932719397907387744517454665484167929149471946496848494644233802840296738766164640790698766039229164379029
math.691  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000009733588819431218296397170717875727919436140576632417446101739814737173756300657682212871664909423939597366423056886726015068507846031394664604517140058007977534683508347660226456016262196272469470092261299817678785538634131668610965226530123235954670407593640967016927770801366750043291430613653454806394663808248083141042660260945709148168930198499704197110284915426847932292813760147293857334400394277811726809758934992190571963828876567712194690821311030530288659297356324759969004014163747348202710122330416116055302494046787736658115887887294110309837872878488318164241731560025201084471784436132408388306221052165971337403742855414412215259509641437981893554314073627777361222684985141303220306450397396973471986201150485904443249778749789059917474242281019502800950591004448083445172454705868946283754674845022150640215960597191865773
math.693  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000002433397204857804574099292679468931979859035144158104361525434953684293439075164420553217916227355984899341605764221681503738820831808731676365568275190465226437433869661195735677233945850995807073335490903563843782449721857856534666537141223053705279325762401487976356364054184363305347543456485605154921779602815434968393663901158323679555487484671936434194613738650642053438369594932632991909400408687475989092375737279183590977894153948229449983251788932831088524667238353661798075664158853584427366155552927650693715067096419356164252358860493202139953393460647008536967349491729300407121148035844129484127610493403835671623304690264136527776793570280743131885922236072109228743884500833596140403142548491785316442537849949530634694946033576782562116717109176047752801326387400035546718968110738565228064035874612447843981862943087623331
math.695  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000608349301214451143524823169867232994964758786039526090381358738421073359768791105138304479056838996224835401441055420375931560082430058809115218623261612221281998799923552342704111806496296472846757475567958683368360013112047574956996471504101239657018758850756461649390444720454851393795193181453324141506239623658905063181562801018022860226679129802311525272448005103409838633866809121162292545241527508268216152780771568894101720067522639717465648749398294893938569486276634296421697567882748407748205962547548634724248449032320211892196477599244308186457750803350403971951359675575418693161570983709738234319449616121398113562795308596155545438758645178943955534234295541549884710631005421774134748254144991002084240822071000383222634718259622217166218613623142663315335150146452152458486054298318916721491866494652051287495542238674334
math.697  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000152087325303612785881205792466808248741189696509881522595339684605268339942197776284576119764209749056208850360263855093982540562216167578948118717422513712506348625815138464429894987183357176109291991429997196095441562325683051033234007780651703086601627853441653376813336357276587872553549756923863650057796716002537514909786204177898109502114306983863426617735015646155345921415194963500264819653661038944998003540877125452713364260122924505539904939310335799196970745292353470327938757967353987178539365406974442060851962489936622520586006117511831238247106853719651891479769406906975067307776740584068650467702599348828911293948362515541958783678182830861422506284217548414974762292021502084752917248224840291055508204425938161840377060326665561796691785129268557183799584839308247532039794124287484826001656845161301163257182717428943
math.699  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000038021831325903196470301448116702062185297424127470380648834921151317084985549444071144029941052437264052212590065963773495596311843892214366953463978640723369459259324256880413458972969092967127056622583944579641298178036588787001775585705005439771452394013835614604976554216086570700142768890344768485697759682256449069134026996285499871870543961421716895703479714629464256450294218541411212066306794750832399192689434177635090747170947560221806991432198179823371249032113884983404026586938570079877016045872346948614684556182510435802330146619110114387811123343754270596521918870373869463731401245979735758676932972735263212839097251809502796053166019483946424819854749472125839182203422970419992149011912218882306679174718571196590490234555549171489921492404824535248762844673582466453832451884778415990567949593157799373515162019166137
math.701  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000009505457831475799117575362029175515546324356031867595162208730287829271246387361017786007485263109316013053147516490943373894763659845311328396564286105991424906159594450027248474212817079205459512336171146731647703663448949484589282036732441890893020756407077844578708477290077300764969870303666342005717485830402759794347869575378494846662658929092617032651238871163835429470308767935669398961008689208502331778055228089930425943968731913385335184564379340907204087951647912315555621693190411716711556793206438294358379114870544271747575599963075899165702619018095568546537022371418345879499970457204914352842826847992864065803918738821862474622825936938476800741530308854413371800496231631397915879474267560657255211918637371085369419047958490828450972231279975142851582891413578691013781891050165313589518399226796785718871018368011471
math.703  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000002376364457868949779393840507293878886581089007966898790552182571957317811596840254446501871315777329003263286879122735843473211548169356469505607548353810143175578205655374272686272045914908440183437434471192549544250487514379284316942682380755777103379799963893935828752991093100957793375526821170408367390351021028011098434167920192529706084149814591166671811195338655156547269963681408674679241838878185729798562130092011476417082748553777012083692354408097148816198300320940633075987228716068662865429837549391227042745651522063268137311544745569107541589156396781488588813376740068240716134388554909484828911159862949710083570562802319511706347853054688178920390027814613898693899367237857936502664686573880376529271806527404732395706810474517916960558772344750754854984561808834732468753215660532680743849646152709431946074533195112
math.705  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000594091114467237444848460126823469721645272251991724697638045642989329452899210063611625467828944332250815821719780683960868249624065453410421564828958153901010454363307495508234647882772627896190898624360521430463001835018337290426962734314401065081727655207930975980288962900280262701939351606051519256810794436246838443638094311714094791035643991518610101541130161132789963705136190280519018446524505531799760353866463049834404885550315256693320282424797839144089242299496157179533086232138944782308007488743898554168480346486691311578604165624266395311546647635341056094370724173436792545951223966272369871469589323498574948133881901493522890536865462849731351925226484523333153007411008752517894800780706425248921579742224481411274313665140757988876375593888912965253480200569226258604079526138516000160380320575791388001392453498734
math.707  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000148522778616809361212115031705867430411318062997931174409511410747332363224802515902906366957236083062703955429945170990217056487907820496277075978558394182498898014370612981510115289725812616952729018950432945735925081693588167028245843951586516036396336942465414199418658847301658076708087037494688657882922824756967397291398540589580466963497607551887605848903253956522099541389386348731972498410284398376860105552417326035404322452481931715790059429535828328079822648097912584710307237984924403139959794249166138340744078925415868384174336775809473436820456904860603081403702427874288261051483561595753053815792225028998961441856762521770776483956333963224368019743032807397475478915743016894287869038257287256767307809844204319407727613279004821183313861856379387355092558691022555579789931499108972091834396246007578577475603845016
math.709  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000037130694654202340303028757926466857602829515749482793602377852686833090806200628975726591739309020765675988857486292747554263464409339251143900635897249179763200550653068701427690302323970447894293850610975190669588397925725886487546891165712213198982611133499056765726607336330864285958080937550519400437383756533825048430530469530346051356146857682898259675067212836760434574671712864094512884523111478528628435666524902127811290265065445575825655262369041928703059553065901508590231279445255603309157949488525609983083019405626760147499069315852070069323415426931491554958490543843526130300044219818713756002735093642001829901073307673316280260753540886485715125231833494146248919794723490967516982010856092058523971636062656018194085910315922336673372099161187974966005925617669568247086774868318798464240935529622253918887729807228
math.711  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000009282673663550585075757189481616714400707378937370698400594463171708272701550157243931647934827255191418997214371573186888565793039266382460934230225162365400630809558868892695829406680161200157585862194229014804688790902398258245779990805819743264892345486892714956657013969432748369780372323587536516620264881247681658347561052337892733083831754941989670978944918489229622124541867882209979121072146159066109967682462672549675284545025837553395375747254642441419633217586714010490383111933013629004620626907723808552627575542935471700594544565130887095198525557696309982692668807943710435871041146715484169787547792223355822492292514075884382108199223809928159593527986602626189188076839372050081812404370580394284385908097395662967779088237326795889259977233115011423809613684331057701451970330302303530201938595057142516478800827044
math.713  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000002320668415887646268939297370404178600176844734342674600148615792927068175387539310982911983706813797854749303592893296722141440141697881134673454361940599179027777044784080656058110681059032059842287719833388938649177989640125817464763466607551544964640473737526419127879261519613187291714066125180705152911842029783033347863263007846514774805260885374216835971612751521385602569089234559658300912115033043805591860514461624083884078698502248370052310571788370804386059477577327663772027862661439203051407114759854483290336902706084391035043570150278979157478040060646618248407441302918591116077875058736986490447582452904672343575864086155659049506740448232668813763196063717588326775331154869128492084126305457595413414813894838449656833068633448624235483263505656423690906754717775579578416125479066112228218191279365451382729376673
math.715  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000580167103971911567234824342601044650044211183585668650037153948231767043846884827745727995926703449463687325898223324180535359133411279785828352124446261775742508111759004328692389782600172683898996615655695594381966825049248431981474728557608047723050117370775641128256496586053436208842403297612282080662401909020665896493453537431554207321608520929257581118295836723953576931092355443747958631166758538838607560633018379252361120582974917199074945993277986902733507186606851493041307275240882778235211498933189187855811320454346373745972320717260470319479591583688601987006874346156738347365849878263645426213618747102299997217146027748007115398967482934846210478213742148919709928558306915195112167855511789221680064389657071369564652906276299964044251805990807010282654587636450094863396522271867636402542036666883043008469840965
math.717  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000145041775992977891808706085650261162511052795896417162509288487057941760961721206936431998981675862365921831474555831045133839683129132113363753423773911219600689678002304878248415458131755911967907452324740383008789122421616713442329312573363041849552084005162682703547049570071188147690484644148329470443579170041888243975594466528169764339280108706384767124863780802967254951695196831548852174235470591524703370631695301660575786566164454495181811395577147548220734015827962127065075794142339560461601579427856393811929410350029426728485747646144879143973311833455152446791043056635108767879767996435864576006910271905388616660985824320528634299700023800018506616252077579258421446098969638680422918344904455599530614916240070575400632359262295259462993394262703325767562217367577137528411946808747966080805029465218769316135273388
math.719  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000036260443998244472952176521412565290627763198974104290627322121764485440240430301734107999745418965591480457868638957761283459909646317713552790066239294002196290491729748863570472532586462615880105562904609149575897024191122221128351299663780382590775860359799873968878334992398321953582331523341678317371975116508279361494164397976160026707684840882732651392357749973698006758812673440541474480575509964700796175298632749001157164998870760523320044579677375047408092542630027594163229159016712548462598915910346057923268337954434883634284700798057276251747883243457173756958142581686284000698977269163295740584592155805625521067321888516832100096878770081902387593232052320827003134243519489984321846815219472129905023813008293963095615087588138046909331025010820782700843202557074544482477953570743251535825380917039959729656582981
math.721  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000009065110999561118238044130353141322656940799743526072656830530441121360060107575433526999936354741397870114467159739440320864976174249948967292151037136411359752408735678620782436874041451613735374024039866071152163118363639211280332711426896689559436370848979560922103655897915242251040926482055221924799884411326112238471213452141423975630300015829459242386021220313190196800567223513522531609886688827704198902583961284347572257705613290454112668779596075574344641282302311652811033887294755582126294676071017623006591798833214056419306127945014300708939522766025257787709703339572321668163294127888121618530412481889361951093061699332680122751156449755874667497631414389970198867780002792677608590206258785692418549261763546587217895541927902799070450804054938380213737323396163665796350424460012167096463448148166103251708010769
math.723  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000002266277749890279559511032588285330664235199935881518164207632610280340015026893858381749984088685349467528616789934860080216243906081433972833552701207759596680300606502033516700189720900232296659909711490271538950653301401110856113408351539104512533900383197880560068346135211525973520443730247845332621796896902072493196122524480023403367717797638715664424670460396835142725011760081725879750940555703544173008998566959173476215470020188833330838172720539091499241651281703567530235020086709653864901872634184166856316313557007989471652133323380262583420228180798080306194442141164301329441189464173422951881288710075686159968691131249315646980376502442378177665665770497459901256030651565352880395772981939696942767654887922301022500511761248130146846453185105237018394714923329829538290224730710788171636435994888326294704817896
math.725  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000566569437472569889877758147071332666058799983970379541051908152570085003756723464595437496022171337366882154197483715020054060961244685907765112057737901761030319420801328192629599786951427947811244505819651634838760411783778025851344281352982441710751387568881013688452727334146934396498611086069978827754942101711000192737320925540338901041598344236694099856541598514374098161114485589176227971522851932290878496857655220128335963790733369611317689194835609001660422145447291339082031743575005798034526401797687990381817822267247319521091092302502277310524848534918885072833389899898479652190984455275264795228402880478058919894239191566114646689099491961698263356558911328944641562315854182240258230955966519135201429441134612056681246959022757249808262382014677665141087447498630934208114003853991337115052811750617579959040920
math.727  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000141642359368142472469439536767833166514699995992594885262977038142521250939180866148859374005542834341720538549370928755013515238613874523003136223594026758242051440664312027430127986374120306246840801782366658720923113017793115904117836601372177905167705387236097257125144872070904534190448021394538678152262740834456451084929881626761062316922292617536099429097468368407134537792799549750740509976434640382250538557925736625353668813196402506065858406936784206759080116959297366794335223196957962978870151338432920417032133061147804740826902353588728977547648478747761402354819977338060073140336515465922358984271653688980956276760104896643707382432364885238068416311684559625396845844391419026011109134168750150519491977936408489220098665932252230709857273908710076927214667423679123716389683172070962888856898663523747654477336
math.729  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000035410589842035618117359884191958291628674998998148721315744259535630312734795216537214843501385708585430134637342732188753378809464880080313212745805123502669898591884298004554501778775337112038824608815308748014812223847244910394147875560828863041289983087128366135141931234907231913827174430538649775557438554349907949638884082129965851607286492830929398803719527248851318203530648611709378749957702279270927775233411086048320038420732483149198985993013659082034810793710751322868045750096529880171786247794055310432049307974511184427900565048540199651528546763922966492192168793082494228840959169584972718345935499577620234529612198782059843464060773167004962173148994835399843953895362215900898656091366505003031075706143007546365274583257098248163883667223281056885879810460733739722874834085745063921590734179593866637930185
math.731  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000008852647460508904529339971047989572907168749749537180328936064883907578183698804134303710875346427146357533659335683047188344702345265736696350818663127188235184173717543389771622087158479504173829975356017974040878772140617249654173626140200402542596603827427700573275095047502526544928482891246156350456172720108452686659693464062671906474560794293405421293284707116016180520827063788858455315890655480495906378705034320345399210929959920702458420537785620063950134210205557869956929729859099227086840742630927660477983961134285415774740874885471579577473011066485521484668696979946073528845342813015919261780405539333422219290092056923679420331597439706797627525452512709270913201827049829913666536359120416094321756846097859718398460704906992470611432533388231040336224353906182408890540571009007800081871231853430437491908864
math.733  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000002213161865127226132334992761997393226792187437384295082234016220976894545924701033575927718836606786589383414833920761797086175583988180464981886022653609566319324067882390624349593174580456728360140855914580958794772610691492413354503860323321823092585989154292394474188074045794541659292037558098838397410997651549929243464151609775381658387462264899292896138372379110625836060515135962827196835416734275092245409632373483307859249249795895545792865913142961209202004683592216271166504836115953193714856504971581516712329911542430710576914102541544637183334509500078613817413043410085141112542112608173537397136243171114843484044695929625364566764442909944985197702669205791732594759481104100888982451139697222912561119614586630498144576756632125915626276182459526986248714464019252638327118269542139411461953766705319292069585
math.735  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000553290466281806533083748190499348306698046859346073770558504055244223636481175258393981929709151696647345853708480190449271543895738350259678158323093603781304639976803546898470072891974067591523662660301988289540368661073036144586131353149145337049617106675993739169906362716159427562097964746391311857710685675744253269829063890522414270973738661849175829684152683149601740829057011075791619917727980307009529108072016354291547708525476200589748417681836357319338195041807959488860707604863799948297373843132317195301649732147389398410324169776178405254454439616705791771369425201801825937502991230346926927101502091076084178453537657452204015544213952545326883324770622887268490781132018049547874924242526457402641288621457525299372975413074672147207722665258452655606750113056006352900389065511963756862964985026815250691027
math.737  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000138322616570451633270937047624837076674511714836518442639626013811055909120293814598495482427287924161836463427120047612317885973905843691967615893821201099740027656404547751548926511696733943373540936889201855700833888424279147475536570068082520682323236407805023421841655213398238128404370135407251160004247859612728508503238236146500690559876720196992522803519007839286770174662285810625661225088099925416173630098601263271688804056194852557144970361216566800173431962170867762262832387675019153871734908518035634671500342485791768804515468461624143829189155997971246526027863421975860470358808442421971863942267143510831709595088827574141980644450179951076340826730575896195717497423065441978586275716132395954929389721929759637947847006153935651809824820690994495111332710281704226530971959296099773849833107248030990441586
math.739  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000034580654142612908317734261906209269168627928709129610659906503452763977280073453649623870606821981040459115856780011903079471493473267159330579119349500292092103321012654829768499215557874268675899153312712106515846441345655479521506280756267781415174582602525867488674075394698509107099162105667833922018800378059280388666015713712709575325176832549624655663701788380416193036517241814467212073214958462304981390280577186245974373653534047143302607316362014448665005635623600160655246263895184668624330675601430760354704438208662191872068146056061362239035805267617651704058377574049394882250969025529239214232108139403262754083983150459073062684663517674852827852071824720239941701939491568648554349232797297660180536010534835933281527424369973162046985277259217199558128124802877256788696950172510020980061887135158934509236
math.741  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000008645163535653227079433565476552317292156982177282402664976625863190994320018363412405967651705495260114778964195002975769867873367961927203608684936730630484925431021110139873376758070989765261476334893779320250143606918591801859449832162680713372508405218517291193008633260128553374948900667706657284116136192833170951202915857805453121159205167896206202333999337882106078138892197699414549094500133045439265057463237656191140644971961163220033635346797215728870880047599919900681333974522057792334095443714991053226966733594848136095447868832277595434152069980122402959992338630500575679466771190049771726371644694615527826643036221326889051330079008167804451672804968312368715502891790349090909843613201544095081253445912024803569724586246838234177853434568281454591000238943968664323574829836307514606193158454697558917733
math.743  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000002161290883913306769858391369138079323039245544320600666244156465797748580004590853101491912926373815028694741048750743942466968341951052619898160689666608450331313396160471905149962204583129992313700008511640464889456905445607456697245617761130073844290302522176939834027750414077252621632694429382861743446274705427059708516863957151255651945621830782976766052130614154254955384689286370180125244393810049893991312845063473621122812778755278256263607962065788550980764154445247918136585117192990297558226944005115849114676360283662136307847417595785449615360806200515261964657414441292560276771664082525687582463474084016432679197976220837157130004588956203235217952468483256991155571241873741314455979319556530669292205133005245459048976948307525840789184236684272401103164712590847452499284247293287842535065340441976320852
math.745  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000540322720978326692464597842284519830759811386080150166561039116449437145001147713275372978231593453757173685262187685985616742085483382134862983445248202204705045642471555413710354183016414573294493478246444605372759245894481675402064372868477138247287612987735410088414031166675886932742048928712837313869606363449778567909356101999828104591585825580978146608359979314498158956401717513094164536584385052954507931488718806985877963757735679446825848729393174217549319385205572608501869929114015741486131501830719915514115874396810411205062348294979441781025777803433286657250972370746434726758314413624073674914442368451351433144313843570377265990675614179261396247139089634420062561116526717202460433802542493127806977229474643959641069310754973038620945422482589782490777966419823520498395884017057927973061983869032701644
math.747  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000135080680244581673116149460571129957689952846520037541640259779112359286250286928318843244557898363439293421315546921496404185521370358753703350669404445005856507776554715235363462282628618318347630978019226094582122591421740823634259403172771463478059312524968055554504951567342412257830924423368511687378236522761378599868156997934239212971529281346903888250985857775046300327182375755736935144963315132644555883904467878185836939355101737598691195615451788233242200069042732036447700137608890807866445381787382209810565713404081434454918514749141721538027589347645148355027019815982904359979378681475661248153617219488703578206242021457619343744301950168380199206587309857732567551294738001858664528976347003031465763054642878268645734248163885156325780811683733658795966463164151213391660198046512147833122280303553892811
math.749  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000033770170061145418279037365142782489422488211630009385410064944778089821562571732079710811139474590859823355328886730374101046380342535601757793757139155079761932095909437295722629319198767321256241923222319295116523178960781944161105335379742239849512885038142457643349355953145876948754963254858712633182459798682779053713378114670268210867676474184030352757664565169552208178026415182740553494120467117813886804022212625288636557834797384962121319321546743728683672066657798851535761782989728652050938246378036422581867350560106558056720268209069089859683330148040511117117326266029185369450094184172558541688933869375571579035393624421864537599111713385726426582007365231572615164616331701904662151753781822012740743493636499276991992861565723364831474038722383210310111751742336689083452453755496283021807152145821378439
math.751  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000008442542515286354569759341285695622355622052907502346352516236194522455390642933019927702784868647714955838832221682593525261595085627890809665782594571417529128040840776933584186635193204357166208722885303465053685520418567347509233061655408352813654013019219481708307314736599548449569194921591235282448757145442452644602559481117449461137444186165140736841869075282120916917504447775123287518077104434048796423664960034301704124458989450546523175491742197729657069627218161430676074569565033247331446559687922465875758915635109356279619540494153362895773782813938604140177434214491211048602019040144096136638218081791351354188409396821276693954542582524320996610645758832882100296688689111916246097662249249656729022683163619455606693699381718144042338914991011194610832375484231038538902185843912158671628024182629919958
math.753  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000002110635628821588642439835321423905588905513226875586588129059048630613847660733254981925696217161928738959708055420648381315398771406304965773928238618704114353678750573967801994359397580258941790874285739604182816349624460932700026166182430355198565563929007622084590900042806253129234063456424873680408239883605268445704402418375767485806852074911201804108002011899680407819292102601727935500353920906312086879998950302670259048884977547370873333365807965005724964293914573110566317844424740802105401491563834805335834869413266503624114060312552607871547386024590450310184342045836741380027955186664687698807855130146375163254453320514127080139489116345437268309587871746496219537829445978888911439365912316658009704085695943856629092562821967910694228551387231722162476537482899292583697284638312746582998407905465187426
math.755  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000527658907205397160609958830355976397226378306718896647032264762157653461915183313745481424054290482184739927013855162095328849692851502048483202347429770443263049525463462440048334360426083585474240078591983036747972908317354939582866485913032424832541850969856383233709789993897110146457975514552199459516554279246126472455879796394128581822502502621708707359217294889099098603026879140554688844009919846748773687716457423316947371365304634119360415982932043954139370393369458857572765702995106067529876904574927318662702733361299058243006876475766859181372788420445768609095015592841481693071881598019085960810407941802574033272971788564110526382437572577014772625963252679061202603207815898935370290316968068268263803511305540940635472918081903004310434263070996533204623760762766338391282098789949353605929877643613485
math.757  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000131914726801349290152489707588994099306594576679724161758066190539413365478795828436370356013572620546184981753463790523832212423212867268458547285499119768001832363345862331073166313554411879704840187109893758191869393990685598032454279388381881448598733879589233965618753912724136419300522067396936103833228834024422235928773887519479955275116367866774207387576685126322101768819699720637661040685734117794373590210372455731316660062465183021367742418786282362277423471795128174390446856292526029965893607536607958543710358977469477916358734524861141928425267663871336903684102260270130870861670209122974631584660030623129848712585015650118455018265679765174901118151146959853453188691044208666449825493227712658058127930309108163774873416798771882666276738893197176981280720223246238230013847584620100372739969778313764
math.759  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000032978681700337322538122426897248524826648644169931040439516547634853341369698957109092589003393155136546245438365947630958053105803215901152164232334966292798910311056465218441745214327257523630241176495462106104064700376709939882017156704370822833124898120662430656986618207791538578639079081506444973091339664486082619353188754274175858198836097630410108061018464776804641283643477864988470570797109501427700230768789453068595402445052760021787309579277090545801789375967686395470461170860814361435042819963716194355064691751995769456473192972624293279426595772498380351011699560942885805253759167401243586355480712572984835676031383213431512292883779357208901710642303473609650552419562984036601400181383582910754753109861605886163756757547956111933235556737461397444640536475766323769120661533642935270464718577694644
math.761  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000008244670425084330634530606724312131206662161042482760109879136908713335342424739277273147250848288784136561359591486907739513276450803873514432992634873389955111157788560708574153374241664886874674864092530933921138103080737322791412983714438261517544537690804516803013022168795195429122705089318773655982572146348155889166327869247051209047597575524172509760152393120866108101716610280829565485263307282792616964528048367268152145989816679326818579209922498807333955084212916463088082927924792688753906871736251551210502856993458341659300542702027442626940766643804323475981504207902863539948501761118318530976240325318296603446767514333055456891525750698685454726154072005270409025132768094017204013679551852534236060921291951388962393193387215091209928339152737530864352727210146062165168876806004240629364539707440127
math.763  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000002061167606271082658632651681078032801665540260620690027469784227178333835606184819318286812712072196034140339897871726934878319112700957070429574219955216017153742783189555361729129189288500159459223797428889857520295546468757122497786043896812204112576189126182022305875408112495142959561233502588201289001480339676898068671032106339948195147431733173081870779197448004602224244311275450954623162840556935502625383452238119028996017592860816870134849686780858651981403159140034833377270215296677363964348654871113499275123902325509153804258140160615173717579490606029894650586931767385654615622991908415488598219466772824569729146311260651495551735528669361443947346296021721824002187380015329394752891894753642305390966695815233089360281676037962070911698206853914533123770347770214349793239116026324027037897290182677
math.765  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000515291901567770664658162920269508200416385065155172506867446056794583458901546204829571703178018049008535084974467931733719579778175238011143096450681789396330208288691764198009036256085711533285973479834573172961826083982125550035591013361950376089933845892569195854587803632256399333704118864398489694538929582259996813431911380890200622996127532771923905530671849035603644842629742895432514055518085003019254738875501585723801180280312634191132579399726487173509585770159250776527969508675655707258639920160527638572119145018685323960325719991586547574413551452589205405498681081779117665929631368138360428760585309561382253400594944951964133569454036482956197283956709700585504247265595941201501328032332147800997257401167027185550666528497792877782919803839570410029605805011733470610349743550508791131255472695045
math.767  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000128822975391942666164540730067377050104096266288793126716861514198645864725386551207392925794504512252133771243616982933429894944543809363178629989969667948198304582494538311455231726106270827034956428900571149749540098480524306332745478648865623896221678131826600598371630937158676598470892917807200180671320533356608325941508781447649929749702711112191186078120397787729820446720574881167867148996453219239618701226741772725397620368197844964676481549571482746373109506312768695969664878578715874754308792527181688236274396047843307704872252313590653226219583130022243489640280632073877935835538341537021389497464226579866567505090821490858910038854838385996264621879119585659605920035068261828104777091288997335857841612061356594772708381504015553752853006664200043364791971854460761137563543182979638939005436418940
math.769  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000032205743847985666541135182516844262526024066572198281679215378549661466181346637801848231448626128063033442810904245733357473736135952325282752594970108164729104202326034273636360449535994700504679447107579215938394311007352512008082540706117124180872541879179454667579005297645445576925416073576369521234515340796748394327215163983139758390009129041400555906960765537946985441761087087526930779494372860597906257124316827643896837778060478241598377520340587417628833715530411714480265809250525920983199892870470941851925745332059899100385848196950011172983627695392953495245037388957499273192937500811690470880695510769341007633452394896945906620996709204611528110558413500036596321836873593204965407722230991010784261205111334126752520287697814580219711393787384254857512001954545846129348346991545797676806186710116
math.771  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000008051435961996416635283795629211065631506016643049570419803844637415366545336659450462057862156532015758360702726061433339368434033988079597143159573381616480001390215108534606040392162823896653496566208276629373599609572640509715899500112564974970889592705884348467692860762291915796437239142709416402146334412183257065454709625554888828509089060656193587566183922756669709242039070649713661734524147006169101398198683966526065076301422622788166279517933954134044679814574672997052589699793633140641012493770683490464365586536487154757596978369534450567704962238577574934242198132959508742812600597640933260362271321299378586051813827490845651640572106235296789738308404403358711267420799654715149132981653424285644191254692897316925306749820079187728631532243604630179299086453420742345249106012380817082007563579796
math.773  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000002012858990499104158820948907302766407876504160762392604950961159353841636334164862615514465539133003939590175681515358334842108508497019707780791096773690264192051957510463228949018016130998777521553155556026831066683706582614286072621225064796728381907263665630974575761290459493418747083641675677232966277468730720265809720800633476270057656079289369281393103244177037800115104511170354058869161168705268811745179420326491735764377801913337543870719930538938917627050977223088252894253035118849133800637791792956415133806912086314009648586022565087035423775460379000188436638098995202690591029126061211162090530710928051643257193831501910941256733513102203339955856646151016838364978181232720768146877974902802959687227324616448090561132306854074893320386163174605514105166879442542987680848493809531933478911381402
math.775  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000503214747624776039705237226825691601969126040190598151237740289838460409083541215653878616384783250984897543920378839583710527127124254905666864574574343248735980145347985760286023390191085762618989578165325539729646628137041000084577458954068145399756468303727963369742704971000488983565780388660657470073808590998625214431288051391819521035796931743137157057138744164520490776633499187438333794615870307024168806942735520583316529359416887979910858981118557531273853701951931618229619520425378517301202300329704732220892863095281053920913778713978090221846067319361799913639727743210341588776051384569502606451043863930608224123545183025100953320727427031505117787046459990912912503118915492306269465332177825235379431857868324308519266733336261011488766461415908050150463940875743491514563880674026871577556188588
math.777  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000125803686906194009926309306706422900492281510047649537809435072459615102270885303913469654096195812746224385980094709895927631781781063724052456899241465888038213609222593101521369057120919892681258648905366810706075623866636630972969417657080724523185521398768529977800353041476954799933791578034682411149820963231806770982703321752370723449099974396625219671068452209401394883258222123295226706848842732049214822649422307322237542067933245848993886246407570231837002738447193731516838135584235985746115371273173399125109227806666702700234163630982575100725159828820983615847334926906060189822051292246991295354271045969856529843169024728706915634516121200392451150921517375503902500700615114560897015253473085568332736049533818904861612413977459070108801231059672158989959313865668358113221283683562756088996852774
math.779  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000031450921726548502481577326676605725123070377511912384452358768114903775567721325978367413524048953186556096495023677473981907945445265930750418753210130924882244354848492348874771509788357578951038134933456749984703791170256533404556272263410620304594161291939307901799494771563986474665835339314202560164398133689827184622696032143957193643530793276563727013685889351244959527898271628905221023206822555912021075564771071502523959484531837901979906276950247733473146184500586156890695270782760865669193189525211508917365018856332044976672503732531337017174030423237997283626051192969274818920285439259288409354801222607131435719584802799856364740421945011556017399275421991187292911572142660340799735480921171726753706838174275364142122809227729976622011852490865249837906522139472916063864274587111019549957421337
math.781  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000007862730431637125620394331669151431280767594377978096113089692028725943891930331494591853381012238296639024123755919368495476986361316482658416302569173225984193416772439095384740571392436906491173252923043637197085379481852730646840615936060622375951999484327485628563557623315592881256857026767917174004934279328116043001975551802548123459743795538109008942366938550406114829215757829219727990904147840268473535382778888367901839032655597282443793490702592100555155252429258446146705369745009999817134101563424862465143779893706293325511601224648286205056554485760551562734770956878280406912759608670147070519363955548859973560476953513577073728194401369412772731294529387148573548936764372052421868709091209544068192634552472809000284010569670240048788708403748856697005249919862043456591431354399417067662181177
math.783  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001965682607909281405098582917287857820191898594494524028272423007181485972982582873647963345253059574159756030938979842123869246590329120661360921671920028136451946199811552531301553286481172373172615362947514821594615058161915694565881615307230200385838052271588705199866431866538211911975141092525344832614998657817993166696598611774510494575266806465285897788931434465140371133857667390932191341010567266632480593611146771747439925048427087375882871122428439214634426038843565481113232303287210043611102237981193461521086543576478981204231473194802879091490517187014360241858182524416523792461454167411555597434392757291295880475090547510620319645292134723052974284132306882701874445411917422940565526982074971128211617742659721822884010832428752298120005994807962754241403427889124881733432532462396250252749486
math.785  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000491420651977320351274645729321964455047974648623631007068105751795371493245645718411990836313264893539939007734744960530967311647582280164979879976827420549713385661808641320060545036994953732224187410979834874545683785395893705069884590716348507458560175348454633233027314359109577473505062481980535856214173099074120688235768406219362372402382374032807988024535581521081842853006423883519259572235682390951858938801140707225222181438629844238758622929613507349559564287069749036534509786514251436921718027642852638361441298439159401777701183376400122424410200359991280883376853773085397937145726637898183735982908350312388656281162706818312309717930403716719805390546184644622820344858935909163403369357927596271270541451642709802228482609256943908871998746678496495807165085554003190480537854541642946538856418
math.787  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000122855162994330087818661432330491113761993662155907751767026437948842873311411429602997709078316223384984751933686240132741827911895570041204931056301012194717279650102799573041264783179256281826161693883064959652757615332908401981739391018993024973353088113670735567059194102098475068306967327583216879818329087501502324556733999326708611256771205511075475622809289903382403610258943035617116524657884038083135747985769766685337081868693538465980027383251146403145429942643103888446250246519382768740938492585924543839027197894459201954553682364024819112590342991171046822379174334171218865727911460894411535528454182050536915225722026548473382652500355738638539605096663746443145417906967853631450110196937589878727032277234195389229786298320578813155575956351554608900822212400881515580944049853779720904832636
math.789  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000030713790748582521954665358082622778440498415538976937941756609487210718327852857400749427269579055846246187983421560033185456977973892510296783993196826055044756938597993142485441587342649386986553183597222488915004589275886542241464652592304551349975254282816083020493954299243729829595882564314921395274437979399393205544440094938320832856917823580914261416689944431372505985924734931772408453744855492933326059534397340197853275595866556520113297702454780936318270254154004563844154171684034655369658002059191705119994467389559494850946499201550536219433107439486329231469793355894348543463153052333071773853796310071807520300158500842794440860453587844008260620699472367246594125489519607224205749543510769328640818896039934692113835552530332894530986472648495830102056848401524663260921214902682447806427667
math.791  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000007678447687145630488666339520655694610124603884744234485439152371802679581963214350187356817394763961561546995855390008296364244493473127573701690423825736690682237546419757757485440340977381916639713691134094340063945701489351309925030353624759223307782404616540900675061691690492845336802700824493171507717875928720681369252897485050020379175380102587348527420545630217956945305049933557978995008687476497382216022282306921789045345414306940607779137375535782667057820710886577980574321343441162256369845995566934187359966172890884075295625838409650727507739325672303687703801913392399689026034218053351277897602352841561709740331197310334255393461500146153691656011896821327016682814979369550821497156143858228408795409827268721734449112206845285866181613382115568989821590488971118442630131632450939056301887
math.793  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001919611921786407622166584880163923652531150971186058621359788092950669895490803587546839204348690990390386748963847502074091061123368281893370499508691903387058670819596214121163031585834904942493419288542242708495186245652084021876687277997573413734669480275069978710849951730053062972580263825741024765178453839453767880999844386971107753366995086009200496659317537958103487413662802258855905094647056484848118743029722397534599454121776244093346933075670982615855208296754376974263316099229404260619967784866904126167914076382323723609114221299547032643286154814152123504989395073898111650113329983064399245960092494193523620288916510769531957781845341294885302259217611852459253751981779674388670271668679200223050952517495776054993982017729661530518551708995509160437238749144706089744442446213194426970939
math.795  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000479902980446601905541646220040980913132787742796514655339947023237667473872700896886709801087172747597596687240961875518522765280842070473336522310810250203918902308564750717156499174302121731549298251664307246399263208110770582624219562792698692405050204402870610601327349761028445625239910787995537264330142906758940618166106568871407081741243551572817807882329366466516077889385391135172290520333239250330466688430069449634862029347235239689608557018573388256915352175417270489265488852930772726753410667940746003833284525912437985012022297697798134111215826120894095971173206363262670500463165720714882871453860555086871862468158813673807390747914694337889576784294392719215402847944925793121998435398443260513520476381366740221247012862321240245554707057653915341548074674662067987578876955280499238856596
math.797  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000119975745111650476385411555010245228283196935699128663834986755809416868468175224221677450271793186899399171810240468879630691320210517618333452514773370812885751644215154033385318268891463265767984943974826430408200984994109265339949084397766686062212877345381841154139386168767178388351585559286309975371697194155799311012728792504506286966005306521945761334970255267323349010164533545450791570991519820356582046771615119005976643346575016145370513064708214416037014660077877532760140858086821679269729123430827276288739125358363126201702776278260604929713434246885750623475128250823126910521493066150445303698255042415103828983924651308352267155846393338189902764044700645782764334275360886615097997039002548976681050589773233319477195418146248648986179593139828976673417371346151703604161269234358311221755
math.799  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000029993936277912619096352888752561307070799233924782165958746688952354217117043806055419362567948296724849792952560117219907672830052629404583287788367876954544329696284229214357017731146858353428736278333567676358537488800351385188753292621639553356194714626501721376531887211526770254511127999027309163351212543259478161494636031453825021380585331903358258689337977047091404853616677749899293977713572970415030064064882395234445848154213740776788080592521170341926195194701779670206002351961426277719854900917787880914196213532519915656622269969888758699513325865749009523183854458319736474999037653794186060946692423527385524222175949199997221256615288974293597332497947361718443790792617485950207108734695829780151816239923074819253648127597385978024167467241546324123772383433995933320553536630808051149124
math.801  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000007498484069478154774088222188140326767699808481195541489686672238088554279260951513854840641987074181212448238140029304976918207513157351145813575944695266560848177985550715368219784333824870244599629843376482284799621372512742836495658880099853846375672101134057696189350052915472594555137432866937471937928445888113590226862906693121814258846436837915087042043099004415254050729774404429840823377041548585449941219810874005562184536784304678598380549845516117801413766109823390302509994333340112505417759174215800009665102323192672165316340384223956288740275469945283530954229276483534881103607411808629782437695672607440353076177231787604782547059739476940924956128354903300639306291834266096428075403183463453738113474820909853233011891338235332348950047104177069260299003689957583474724945093308349775279
math.803  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001874621017369538693522055547035081691924952120298885372421668059522138569815237878463710160496768545303112059535007326244229551878289337786452463858698930854074906042442502373051096255357359993084969711953516481773821917842063102380285356101708293833732892106843748446034843656017628609344456956644248942779642771407375836302479085478938797826018660845779286591478723112056215845619115005819405622223989256690502282143651173480181654618356783920553149593577273572998000006277722269745938962743629160757961110793257977217321077647042403634443479830164071022107049653920913489773879531491490364518042336741209312313026525367129015743024620690904955262166593273427525605638413474699345748050156044702886773084086174543766343378240729192049181333704719875061719483472499726341142571527272816297071056934410872712
math.805  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000468655254342384673380513886758770422981238030074721343105417014880534642453809469615927540124192136325778014883751831561057387969572334446613012617177523181725711126838939318929012971828355824041804900333867554951668432206502152623556965256181624143630294041117921541446592932372163876896163096019651422204028556818721775209917409376694601739576798619868290377377050381480460757870691144906388690670790675768196163867269150681946150508250264353526305074664101706450310230830436791332049190515892574130596056991530777349970141545909996649544152011567061160333891444337644583525767527523284369658163498434398963844920640140173839656607174345705009276865497146665106835119451265352401462122207081522402738496125596630420502822908215653294229138779274310906712186411471772557130291171630386503693653542443467441
math.807  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000117163813585596168345128471689692605745309507518680335776354253720133660613452367403981885031048034081444503720937957890264346992393083611653241671239135291898870516846214132584057566066979603318291499788521159238829658356735135603498755339685120861533350652896461540568243511093349567442381903737932638220662801008798270602796341746144056577578116845190070793973310752952319218814649567912152746761530716795620174010886973619576348177180866937920770261629046396103096474626630352226172236883822406577188991499914107066788836966034352057777100033180037297391150479162676097639438530792745665486082152271159335172005605343480412725084618221464281643242128146953839392160299921302624616374376105367946036541126788583845039386103599276324756591822185641215430067217845157788534831553400449590627442943723886742
math.809  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000029290953396399042086282117922423151436327376879670083944088563430033415153363091850995471257762008520361125930234489472566086748098270902913309141914756544804433488671162344573992649640066083863777349914358542087586586845307072506164634837770157437296166535106181666046415043965281546241834916118281113584556489704533372173564539703748717600695844516916217616582237000742423488566913795741755741832726740916641274264428930965849415536046219388992529557833165306737560371347295551468987788886792850215397251246463446688517938354727217333594488264889180629645438944119494355004719663390979989162209311238046173052083500842752613634017489057480303107575195929078409112006846004336757009603141363427021059579965857394057976141888379613815539947634293942903755632538620648764427864474157532535966108402315503129
math.811  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000007322738349099760521570529480605787859081844219917520986022140857508353788340772962748867814440502130090281482558622368141521687024567725728327143712574994182187912107747120746606857757052207969744834697170552441660999184229355749351152709759082524061506527210119554479675003191308548097352096216111452479924636832412699197336130064658015109353013280317402680745122089918993788313938838712695268266576308329690619927282682946018284447913383580790258550969049222037343382938002008183468230829108871988535018610789723963489642184979156346577918803723869201228421960120057220288471011363900397589124704766651322978630205446730930708953970578123907128435599079776702341764139743435660026264835709939356999978072477691713642430259584667879059453125740439291179534285612777078983584862364473143991961993182047427
math.813  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001830684587274940130392632370151446964770461054979380246505535214377088447085193240687216953610125532522570370639655592035380421756141931432081770176353288321222482464709728475886013922267017215080708365246073323722400070824293117650009733030497727519014086413344382844206437525658802885734515300414886717656486087996578266845350721086075414473339224550525066575238135337342982459766430884610568289669465533641305582165158822843639907011162227652745083477287810306038782657011908395174674409455665375056866323291694674118046055182618803220016884450107018278406503969600165299493721868919207367324016068314663918648807622534900189841453219945008648500728634667898324352849738483628638628053008209469611194826143725145192128720885036115682262892276094973361861942490132062155528017220148416273660904761635942
math.815  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000457671146818735032598158092537861741192615263744845061626383803594272111771298310171804238402531383130642592659913898008845105439035482858020440793889382055380676664818870817775314534233861550730677056973011132409172270457957077224971494989927447489847073491091569444656615811941113811697649061028266233984244144159253806528509734970368716661176408440279710230259303726926063832568934255306885594365732292534814558325085864366930895000346853574837709266277193870174583380044124808376374452589457772836935038365583625572831458546174693316208254593164553937115429650377997293286410057936231094644257394007386491305048439414126743130892169084579996760906833398690177418981333058738535065938649800974332798913833498874014827385086915668148666145245254327300222321701638394022887107492283028272594004760142336
math.817  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000114417786704683758149539523134465435298153815936211265406595950898568027942824577542951059600632845782660648164978474502211276359758870714505110004005796622186842060498210893199807639521477304011613704872307538822134429031365246840961658384404419467938861029599783674468580856008394157057773478116278990902850887943350448353734210119274900979841310192921672439545813499580298140493216462223524388676772962754055830773730344669053289892224462583135334890509537397030329979213554607368456221571445504127195124862209787206807047640169376956814190060517281246953391521719488159321079967138269742504731433570681929263058077701981851881614850091171055746190548292436641877899242571200388459183619464983524787617909498596543106077119801265615436164199300560624734900642038506212763557934365929680943752463067156
math.819  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000028604446676170939537384880783616358824538453984052816351648987724642006985706144385737764900158211445665162041244618625552819089939717678626277479394054834251340836712718633161727354987370650039452808510194079785515980748605309214098057333536944618907171955545201537360240117787178258105207328456540346722932330842978693187202532114165417345065829994078124785250300196535016791436587794268686941353731897093194216253168402147557943136802918079213061504995189739948994247675641286771350386472971647805128608281601188660995549085754796992843137035869459727652201076478487516195823096831316187126540613039687056075578502317153174057066304350153376542930620059720599162625738689518238787647565459447221800747110767418447009535141031985468826945524554725327686383502174722886137183628471594230819212830945063
math.821  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000007151111669042734884346220195904089706134613496013204087912246931160501746426536096434441225039552861416290510311154656388204772484929419656569367447692117307794133799086981608406888203176142958368689048894874955265925575013993692842030193099329461689184133308553850696122152305154823324119455449743090448258779721334881843659015955271165446626627659357572205435407992839661643471645095940635156168713863395696854688356995518528985078951964973816709846613893556806452923843828415639569811228334685264569851594109698727263457175602135622518403624083581126409491411610746875302879400748163885911571547877843181730739899899496973984095063008500235610995375278092105561242039855169021188176315399345871761009896585973507197920540336476456657749072010751235545253731476397767935007227354155418400796251767834
math.823  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001787777917260683721086555048976022426533653374003301021978061732790125436606634024108610306259888215354072627577788664097051193121232354914142341595165074743055080629872559104098949768164422456092781920151091517581695881293794688690231532687620510714916324385548747675130942018468752713701229310093616328668325599831040826002880174321839378511168842471315258894753992708719437268660683510978250903056694179168894635008512234194181171140833871737390996236152388701364546217852097489954129304685152571966666604675713875131494907614950081897812520018334435410223183670532205265624762808096242963689494373846232790750743414347129431604173443764776465823507686813704627496811625801662907664972170778448919034744503167192860607226206191098868413022251539757120612555966268588543377923694305382734081547313077
math.825  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000446944479315170930271638762244005606633413343500825255494515433197531359151658506027152576564972053838518156894447166024262798280308088728535585369151495954220053177479341298468873855082259693634374330918592077036003357827926035003638325884437143827014609791095545659556679780284833409459797000133390812358505495283057432753114174108367917278685729160299324116558174123270099949905357609798675506261919497640337200288542725770857905271402080294972534653495560405607909126747167894524026695395387258257681625212581719492413267804230076519922096939813840684426034620371088547816715576333306076527647853805603257181835522277490288258709771915039647269687932062428278126009356696051246814463264126932709739111378984356331549049222202062583431731229876646661444190158532073785070116278382296632552816595801
math.827  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111736119828792732567909690561001401658353335875206313873628858299382839787914626506788144141243013459629539223611791506065699570077022182133896338994565907272378074371079938222122509664026487809835677271961263441287438068590104621029630661390621084632249158255127272654782465553924212734330335919402040160334510721008179655096087979172178801941346050741984461207464092292275313074181421347475319865749423921067110526467888571988545191299885070980299020533916633405880577836138681649474902560785802090764070755313749631776635995550448963018289627205345271927180980761216528061909096901806617333230109869363944336233435232227122248107767371992552812589656753464624836672953607155049719956151589001299933029512491694118536269942033038866654351512055724391175008420076036178002275377944102525810805859886
math.829  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000027934029957198183141977422640250350414588333968801578468407214574845709946978656626697036035310753364907384805902947876516424892519255545533474084382718356675579494148463830511631076959724573552596929822691787436131481585104036807492968686490025840940558046975744753603739843724593909282193955330832257932974456341229810958343775145559244085534058646702562150622046331119839660254234406852292991527488050280524700596372151473620406138765185580997121933630698694734695764145749983840342080425422733903607156169483729904476137949995477582929186164689238663822538607596105381853966442107260733689082112696617796717209351914307828716512804228457002834610265745708829659624786514212591365635506524183077239302896326060684886450409159505005465374585678976939195890702964324088422768558641576972534743835780
math.831  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000006983507489299545785494355660062587603647083492200394617101803643711427486744664156674259008827688341226846201475736969129106223129813886383368521055021464708615426376637496067474485855899804677053455845084221478567272848271177052121637840638325412434332548027393358735903663451426988029547816595822573929435020888253288362137515197740673639616810537111261820697370556324493107882959425713774628705170202164346044790925090245647927464787685700284815081486116389028778746711641350854880045637422124155457015655897623861939817190104574082284463519578585600136659675942732009897852359627076235648696952160353144267221959174000668146969426774451049145738287928830609670510028827475298530376642196017863294610736734042890971746603203566125275422745202384770624050814589644099033269101757840212922982166431
math.833  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001745876872324886446373588915015646900911770873050098654275450910927856871686166039168564752206922085306711550368934242282276555782453471595842130259237796792678362465217322732376034421304802423586055448983419216256751817845035135280231201161339014464120151935143244704352119582793204727014536251225650345288577037429072955251181105613663849807324394074983960264689432363035008638637807289461979460004331134552188558349744984368684362233885037921426969405827799673264354678293644927117801002923148215527304571558859716109691638000300401492343965098151196969323019198793989626145707557589641930496693646993001242837624917666676208083864510319062020805436876289824679500325965706988570970290867634268599799103249385390087463704828084016840380832133243608033622272044168837083395778312841601388078891447
math.835  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000436469218081221611593397228753911725227942718262524663568862727731964217921541509792141188051730521326677887592233560570569138945613367898960532564307497044338980157532991651483721156140628523043479583102784120354736132880952214070037993734974493766649706990201890725910504829574224322598705068317771351093353555060031683225076430857439868495965698976040040704423445775372705727334221840033118464071579582856823752274445211662734271183858254894805299975044809478412813692770210304211162191372464067086066571012657354349206555472138954865075641714451330276318667366413626685017976520841177240140834042328692573670424120595259291174687976550862597688168116502218573206694195330473511717692183213539069751800895692904600366017792378141513842617045873336941413371182075486026162949752719566399127654408
math.837  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000109117304520305402898349307188477931306985679565631165892215681932991054480385377448035297012932630331669471898058390142642284736403341974740133141021101799548010543964210242692009461347871343777199420315354843009856053044648434656396186594259150125064890013051216318458082246469678447326753996492734242331327351106697748900645681013685098893718290198797877112033529704653475571546444744601665119997126771740047784350280547895976697352392005923185809612830449016034655279598158152970126422629698563630710183850637183467713648173455473086738784596845403035807310743002213728357187675712342082394622962956092700566008945138488207955215753043952007733849231799369842359468061156235610957431790500900724900652407109285053382030819503179802915199804222494684716362585494020067064944619470439087469568804
math.839  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000027279326130076350724587326797119482826746419891407791473053920483247763620096344362008824253233157582917367974514597535660571184100835493685033285249078509716254358722270597319788940038380526279447580027689689965927571019429928790642011999733179384977624674312127075272082548027330278679479278496939993563238190296393064016460956211937476520267447902939562513260096121056239473920880994436513667468804059245530716029346149345982963248173151110032856205729169541160500627208280877815893831860026257466455309916353107685692518598721750873114567680725026268954279277687101306062882554828023237343868381685986163346719715144559022134929315454669659906098720515101676633758928448187246300271309735762693308190968079136690316348062560729503061605026084510631612371565874961378716977935631018107049626051
math.841  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000006819831532519087681146831699279870706686604972851947868263480120811940905024086090502206063308289395729341993628649383915142796025208873421258321311581078521202669984036320068479076643085430495989420001239197959644510283553906656165276927840893941101229717263672958085094203820524544006798234589030966584921838203621014904727126731202904268768561274168094073245700559713147777757271300931352650023915844767302668259584814954605586132028435925527877387298719028321341422861795553589669662475019022870031288885769302610475560427758764868165968581884098042718629124076723528503042255929048707268055269387194776110299873701837239635564391295419965908061996702888559581178063122724602627443734903962373025987512508027026136117934679536992887839259873967361700253727212194659250257848874866139683157955
math.843  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001704957883129771920286707924819967676671651243212986967065870030202985226256021522625551515827072348932335498407162345978785699006302218355314580327818764196093898640838932321401084897825835282455968888567218986373640629632523826097405223949956718037176780330443980743629642510217168582084416944105955339788799226032684946487320960557272890411429168066444811179489649556763436750998841373415649013761424354080928221952138054423339806476705341712833880390912473680079412734808303400024974634300283563084050128315857243752461580499962240225994842645762478710533574087611751859809823085139993784100196282466622656159139662723468663664885346704180258116243240116141599130407441449499679306063057541074179529231885298206234496169266912573024333061491259990761949164569913771101471617091963565001605489
math.845  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000426239470782442980071676981204991919167912810803246741766467507550746306564005380656387878956768087233083874601790586494696424751575554588828645081946190445222722565190827780825972973018067449331615987503740246200356052824136196752805305097459538705057460545649205889322887864106089646720361475307109488730853981846108956115070478095533209246575635271016729240500049924395552994656493288986960268473271760109073953767533678364291922737162773470207676892812675354950211276531541333369987982027023607030115184375462460471563212229834611534038079717527714399732209006505217959243236511879719409592131993638729335805741222649868184389429008298029078931321452904024644045766551816358091735577162042171228358618570232651851306538754585683015948753703507061138546457649838809774994100717324740430792640
math.847  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000106559867695610745017919245301247979791978202700811685441616876887686576641001345164096969739192021808270968650447646623674106187893888647207161270485603099772263741851161911926015659761362265523751081916150117061971890474479075880251770619917146809126950452811117627629547239350889807163399901362661418370442764269312042966444471406861224174631870702434734709629208123487130701776433414048174464709402346015309879946904503509829952316392099765054749792090241036614155538514922944332683839721086275988181240397994197878313854949866852415738437582638613314504129197365780603882523297050971268605521406669466189537816371920433497197647620246932650388149254401327798479461095276592027573458257734557804813222784062927708739503320680118622520872837385326545495721646986610245473925011794273157321522
math.849  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000026639966923902686254479811325311994947994550675202921360404219221921644160250336291024242434798005452067742162611911655918526546973472161801790317621295829217130724413174363172561961218878944513254113261283646544591070092891438602512992026707315828155358220473141859539714272313815419748374149466474246960038312906610527262088069651147478100233277224531875279019915664723116077780138445027106987706150750073396795028528659122736765995262788654612586181134601360284284963081767620590294927289855494873954872507243693269364024200321777644812098801886849491534459141526236670696535250397769375217615788655895974483454869325510406185578146658933077304766447560675561768724230075651274189074640209014822921020565463133516301143337889756343622282819766142123348146247532765367547795118487300914185477
math.851  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000006659991730975671563619952831327998736998637668800730340101054805480411040062584072756060608699501363016935540652977913979631636743368040450447579405312296668067657653336244703258051002335111476348677513348258000492000575919711832011586825757721082135908512516620500721799132582467443849974056954183410788606531540362896461870954517667608193114078553950277777563456066138409007652728616459733708271294915625768284960267444713643185530058808215231103670947363646461205022655970312276953447719293484187270496696876040399373541587157858698862463858434362764353617353069873336658063520175077312524243758196055425872819714375927468732682692623834142438875665646818467236149360047790362104791766255047894708703323393540966399703502239188129609663627613612018806989696399732647128067083950999263285436
math.853  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001664997932743917890904988207831999684249659417200182585025263701370102760015646018189015152174875340754233885163244478494907909185842010112611894851326778540770800696672133832494241716985486241091074844784547429494581594279578200378823241892862728878095901238099662981070870993701907871274686568846632793314801017059294251844450267073751313492158901268133766855750806053279761154300902869689585149843002418368443265665979261495837639428474759595698248724711105599281333937043936415742621325061451137399292873031551439383032214586876352273232140475599615917343600699981137357191466140855020994486384257844361913851734292119345644808496474782709381657709602672036411706903270220963620007357541318215465468055278315569954591713207039897814612156005630213947666161694417328562871850648981869845058
math.855  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000416249483185979472726247051957999921062414854300045646256315925342525690003911504547253788043718835188558471290811119623726977296460502528152973712831550676720909761205597086643530314402116934939869318579190516192710004158744577025364314412485955368870505659006015809008388801884592133142621563530787735519549212497490151593535162855524584929449708716008916071350672978829062121456238946248702084506239518173437286748888895147385613130150953088091944953347530465998320323087575112678320778286492374921375226634324931436029247955174966438370393211028124018749433117694468984270476861040965985529453650656034394293675506282056834843334921732811375309366833481922161561588673765936623870145884441805465372814506253310244842948157815705888494485433403483279642454170696363179674903298416862034801
math.857  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000104062370796494868181561762989499980265603713575011411564078981335631422500977876136813447010929708797139617822702779905931744324115125632038243428207871673794472949972239674829768121395612053142422952687359146694740234994002813915303134596373741414367240898279857867480539481640542701510082999929068172307721024123317639144452216161938921565488280885280349188786199558874006979152186331126780580896497248169963022709925260647769154539889605765565388618048976452223823638691437946524894871544105641782904442723883873844751482373594486608089024144665573384131161096954296430110131007359864787656947584172386217661046806660409819750033707663392684156526676505122036121149436609622083830536839049107562987799829983738291587312191865393803064875343543630175696264592945171323195453990291686472177
math.859  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000026015592699123717045390440747374995066400928393752852891019745333907855625244469034203361752732427199284904455675694976482936081028781408009560857051966141183534405234264407948429312881689993219767474065457733078858695854535888996488234315010352306052878500533351604487984773019689505518400890988101427962381603716530527442496998763501102799307326219364438690544788444395569964708918093485479078333242829905472942317209018012494217556190898973653637841584020106397141151211030591174991445008679384671440987739385300867100791041479166124063038727039169560498829471751175252607714619673842188036197298460746764077774021853088130318004585366203330196678991258241606721721268148928772123675865482950213398050789125031946007885512541138232074190056072007491891424887395763377068554018331386302301
math.861  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000006503898174780929261347610186843748766600232098438213222754936333476963906311117258550840438183106799821226113918923744120734020257195352002390214262991337821985397724255489680550359612954384964293172504544205092511744753193437306640108652743356626786671655796923488102675396616515786694166722164382915210792970173185290472870987139676328025271922988335880696884747626183291799652958655380204741074827585453836272024772193755117270504910606928111430623422947926039234155934439632340355369415962414076062091851306897368814564768698616327988877366712103636955716155623481561194435884521619700400099123863424695739746200492160855904746879025601921357625311884402050433299004347490730312555123021206774080885076085560451976127504641116166234053580934875749921908137711329833392897612840938671089
math.863  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001625974543695232315336902546710937191650058024609553305688734083369240976577779314637710109545776699955306528479730936030183505064298838000597553565747812513952104588362693274964593391297694758778993569267137031216499609360522110828699393629257884504829250689690959087468364302950345477175585710735343876444686178126984754674583531426095448874546959906620026485262448123660838432845289837876046791287588207945297994620835306268279354429066195353216826464769076069931704433481486921223072809891923883573906795695144814946235174142787641558873000532839642997666161580085970521029720448677944623366387622752278099449689413694599573668259876563773639520104550963597707736815473634321176597236387756784801524153510051207989006796342204642845524122488118329691636710111961775528358284702370964474
math.865  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000406493635923808078834225636677734297912514506152388326422183520842310244144444828659427527386444174988826632119932734007545876266074709500149388391436950690538665609012764524833037624275434636106492885998016008702854171347037503725916207345472107549336350088033271643841456876841347201073626495903508320663001555828370458107355474619539721513547879416633766780203057662530331571464417264675776661543515565152849943713515075274163705423383405770883948300028722560301461203957421583774544805079032826160562705666091272021869677173457712215587279477956537920045454279572107865281358968511454880171982107853365548365149112762000919335127616058433145932888250585074416016259552328322628829223842973383136123848265043531149471292695951923429794839384186494883770578258886587844926205054992534271
math.867  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000101623408980952019708556409169433574478128626538097081605545880210577561036111207164856881846611043747206658029983183501886469066518677375037347097859237401751404120244534598551802659007859875294594831908529752275572350504193484378005869496163319823237313901520840200804528315590702230760485419363739536520259462898654729801220139818554257043776816249076759743169991950883842246265292576605498096625991925282160990022543547327757666377211247787996793084851173503247225310364103196498411596842775844840769066879163939506533608446532611214455071405197733974496543885192038363293384869053382999591006335123973697156471488193188219057479681189741310995167655938989958360572050709357071282903019767837281466529765249423498951732430164307385661763645394626217167596695709766497177728409197846431
math.869  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000025405852245238004927139102292358393619532156634524270401386470052644390259027801791214220461652760936801664507495795875471617266629669343759336774464809320339710776504616257120566581745187326186756664689246410302210732922429938699671113780684751393131909184214949809743699694233823994707636909122024391472501649316624992258782966811087990006359704372968050608937883886222432848544358326931429131506538728355958680193030808971645198565655046634245292610221539061094972185857901830020759509204596733392003478659261982586210806453370523196330100071333422498889471666579499677699237833003181603662408804070760361234264709804408322418664228917754205791595585806101688206252586976390795620671142279131614884666415176670970426403901551255425958206532750209181766027270806132381449595449169569182
math.871  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000006351463061309501231784775573089598404883039158631067600346617513161097564756950447803555115413190234200416126873948968867904316657417335939834193616202326740689888175429909555987858435543760142590050251435377268143532707983214408825516934798290230207708485924265033677036217218340342391810686041890648057058818689277571883706623822546763591659353470636870073179395367338020529630368119883202022169383932445574635321877609486350335049553269698512478771972524312056399861269022794886285654837601045927691480059894994962175621407605123997123157311932760230719872927434422918762198588717423176285975315868821122644076060472563663293180845106053443323344167156178037947037378316125323337976427537641954298516323513091232823560259972432609888457920143664743815262280149769469194913022753278410
math.873  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001587865765327375307946193893272399601220759789657766900086654378290274391189237611950888778853297558550104031718487242216976079164354333984958548404050581313590493604888126864090988275468932101858721904983708171768199785593106905973905732547028377765786142577791604054573045458480642235834761196261024843298721168229613704723837352427800109764284057680501029710820173214186442729146925792758541120085496779848343598625632988330856722256016389435665029537074541353190583605586793445912599299973444043506269462654175405412634757405327536206214655132734429734084637087069975152762440158136616375430667814862808426071828969178331862404319035705241458966610030763301526115280938184834018291042959159428287109169613249225175262272439819513720306513712796685581463039034787476224295080888331597
math.875  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000396966441331843826986548473318099900305189947414441725021663594572568597797309402987722194713324389637526007929621810554244019791088583496239637101012645287110736908003214991033194142932009921710370403148689693467862902909088204689868266342029963354097537988528498650044223067311164532793070739227232047886603945096529777055394426995859501095006533049937204623477576620312106251603348993286453891686447595030925554024400341460084163762349969636405592486915270735571148595075929939265391102797877162868602487434915770974084813675984953660617700030885693401473574385534254233134983550496395112388854367241576208384684565307827167722812688124842715868978466221724979705159853163212774386875703909434711107264929041117701744414245590015750829612415768716940118919586517204009754693933686940
math.877  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000099241610332960956746637118329524975076297486853610431255415898643142149449327350746930548678331097409381501982405452638561004947772145874059909275253161317190252394420935222759459321740199913343780370443034940092056054228473326527621714719426698495485606979807746851918764457198482402003666443961398519593276505927382013972624272203351178256383176790999875945784793029353307922406674092552695826470560513087394838804702132640362287727667577937550053049974742373616597180414525432742619676515822255085652261661043474399005604578385055389999289539941452501836436184231973074077645360218274624766090523637692172861202698210564879836888014389651823444979122610361435755756601274886336879697567978714197910051832877660700372507908452461113956682868457793395633365987883447071497009130270211
math.879  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000024810402583240239186659279582381243769074371713402607813853974660785537362331837686732637169582774352345375495601363159640251236943036468514977318813290328787848450540803969578882695546960804215521511461410125770246272279474028893589278472514364363533759798582561415054633861220289195961337364731341205269699087164429620797634932963829100820428107178849736532299611146188076396522699787521734910749203274961994236181560646449463986413328510631953989822832484204191982481584566078784564683637472174145779947744973508877597131356718214436274901584027422185739576745229634020905186421134158700612680423026420901998375682178970926223123583436806639241814857504668558039757163623908411702172881806363476725198421399990527395330593471376624433286294116509482231763668017777325051119960725515
math.881  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000006202600645810059796664819895595310942268592928350651953463493665196384340582959421683159292395693588086343873900340789910062809235759117128744329703322582140327151739153232826833770010285848373833313293202685970031819039019140252473302928423889950845924177826820877114115826295669685224397675102072793516472504412019581330680927389362805437229778746009588147091924203527146523696591007337239581759909069431695108212849654777444058186940633104662429521180797458399944201012964395087000083114897772788760317850779030741520070892291422141233128772287845364729860681328967516645045072049001620700855870295741166053306175708876694188433115726353087319497699349819210560844986606631638576143349170205017032098981288352778356847473632851108282370759550023207053950368324472419402182860132950
math.883  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001550650161452514949166204973898827735567148232087662988365873416299096085145739855420789823098923397021585968475085197477515702308939779282186082425830645528789014501894112699165453182965422906786432259728466440004649311882633177460101655472116805485090403143503055262462923781169268947704714568851154834707107733839758429734995658431999620048670282341574435183073890906649353161548786311070100003534638486077258563227886010003018821575841794636426110553404132998160356580208714479089480979913618044051554158800280822103646829555161679883214736521183382142395825554203893999473562126080768356328326336279847329051489814388800120519623376783745709533478614584987097844011937565382049132970641725939645578694364040922051644236225014306971246201194182225061376171642042082155357225128183
math.885  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000387662540363128737291551243474706933891787058021915747091468354074774021286434963855197455774730849255396492118771299369378925577234944820546520606457661381498056577374173118397697815785129150399730724535204937500795055984863640403000516464267458901673640639964412261781646356338836714746102676338388841945365878945768783095880172447423004223333459089996243857536177176374230398216814287259709878627206568652743904504001716058391232588713624604307376484487322137806747629110448418199079514691652077449048050798343332654890265152371453758186937019811867683502401705630098844980895979799411402852601978941713485602823449020140358785730532633781069561547744417251390369307501304191509399069599840768263534100632471672496525032501372634641205307206717886262912999287247650092979231893794
math.887  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000096915635090782184322887810868676733472946764505478936772867088518693505321608740963799363943682712313849123029692824842344731394308736205136630151614415345296825583443614940000128289506701556900279643311922159652935733775572059660525140515648893339907414588223175115238563797896592090519114593111035036014992455891378767263473637798621578969291153777881758313276195443417289917225548114931117968790003669004610858750917683034351913212023022274414203058926699238055885177400026766460900229660089825616431570090965675122257991396017849195267047918854910372876786740539300508114080743195301711974245531479430440075926569723928110504645223685814032071891345932338117888199726700021880291383525010193663820338451068461532379667139406434810058927023898098653579683912512481947720860208824
math.889  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000024228908772695546080721952717169183368236691126369734193216772129673376330402185240949840985920678078462280757423206210586182848577184051284157537903603836315574333538689475044554720772277530258441795514438420499649152308265920421772953062199115403253409694637135117689244350927276865115853641795365325010329264725536255090697983125556246121665002587733867330157874375123549776288382612804585451783559912365746534983208679108160150297897486578951401343908343945659709988798049262961569782060516103669648823233701093156902757068915854595909136956100760610421597021601933390574664041344738246823786688548401540802457327676760890319656109424951253111283003737511451344622246134188400214232863364651365184347457066807622330414623492543653273171628853722049323433702030841681357373933720
math.891  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000006057227193173886520180488179292295842059172781592433548304193032418344082600546310237460246480169519615570189355801552646545712144296012821039384475900959077934465348870784321641196681469620457207324954882702967847312395330136272847868035914989080621858651168321705965345343478460453433958451517686652951442578560983733983655299581463752201041928178712645640534251084741043296184155929508063430402212981660376865117934035661928789656577112259858876081951250536041600817295732409278249154602326339959117291107802556262805219642347310303598244314190211992963339774114647908614448511627623953250790930172517677936408261305285415842934898260424314228326672332462459602550886318201690165463823302685125430078905570005396409851134174757434255364475893184973475646969005180102798690491914
math.893  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001514306798293471630045122044823073960514793195398108387076048258104586020650136577559365061620042379903892547338950388161636428036074003205259846118975239769377047666573075587132801002411875991257039691639908835621275245306273642368036983463770629023076465848640196107282537204426933402856286721112819324422626645366073718133897960129593712665341240172716913773823496458655884530135070660222834654370645974990541777544719804949404410980753097746542734368645837555030912908806539291595238826230023152583341935566649691130474935016522285157382430767931552366200922697281983600369197604763846579097671574094752254649815224509124927572139626420770408111847344729720546263707682296125218926505999922172231718293019880817747884011514271846762766434646473284156677393601275550816935282487
math.895  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000378576699573367907511280511205768490128698298849527096769012064526146505162534144389841265405010594975973136834737597040409107009018500801314961529743809942332420953238311064196811565274576873031505306567669774867479605379206141053794798586500808241059316801777801206373556367937665739284709214815938028780582270705433952759314926275569962121167270845850803346639262642859036744658454792420185869469186451310928933191168045155995796237519976103821144352282955443574338238732502326048495220806340624917061609286082665312349813589437962822860830410568308837732171160533425215259376505636070015400473992642722790507401306458888655245709493625070173976333927702222836652261845951601361747046498068188859159562481085740904756717866248229967442506888277822319685513616287243323223469178
math.897  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000094644174893341976877820127801442122532174574712381774192253016131536626290633536097460316351252648743993284208684399260102276752254625200328740382435952485581789575709026895761826370726600648837570258159438839934887767350650171981424872171131663280852629238179756099321700552650815668639922196216152381190361944266481737206675522133584384186305288715436546594029196773345983709395485993407782907946324576144481302564488446187613812665916603266925850880002697694261444930670924075804496033457038990507854127365523026525071220403978060677091075888666850383906889643234062188090303527333053489172661356455307098208847613227962625788434360306715691378021818715564721249615565926479073816819065983816176637656045059809911731995774105008821565732523668855041500330466223197456608469464
math.899  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000023661043723335494219455031950360530633043643678095443548063254032884156572658384024365079087813162185998321052171099815025569188063656300082185095608988121395301209193862182797414757060311987829358556930695420674612815838312391519575792767728078178056246202626639669022472807953183420332883221125332981771239679159600751678025334199188636376058994500363821133479006241802344104638427755852720015754709937500651349342205823944284319101131351851574360203841914915335946420511576581959673449914827140537376651515075011637770173638526788111290110760155564434472295103827958961679899651354971284586303708736771512606139811906288387138359474943737737742822958464976867332941831465578993956086212769450549442522649988155210403708576259581912824267794992968010096700512780577792503728463
math.901  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005915260930833873554863757987590132658260910919523860887015813508221039143164596006091269771953290546499580263042774953756392297015914075020546273902247030348809059550310596683460151973818199804002527276100045245418856626316969938140567605814815362052182538776848877721402092850070774149219568540154108552851679864444526012506781821186892528605396798935700187808072964108050217211343004068825304838570864643482336572107995203452697537149897834379453861496788765553111230713125560841933767397080305351548806744246111102572290430535702496863261646886163087425765386295854818932305857559034654632019481969496081374588481614505438352019866749494165520492061941866676762902092032402360670450947078388040883870619882250527628307523474746289483220099014717380726776425734191016184950350
math.903  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001478815232708468388715939496897533164565227729880965221753953377055259785791149001522817442988322636624895065760693738439098074253978518755136568475561757587200460137782654835765756072203461378407619379405699097662008897328006046562544058551792264683947966707566548370993228780253064880895631089199823605417050582573826884714575685289436990035262616571521839458088571055326103907707443652346675763584548859878332142228245876750962339941775486790146203986664809667423493026514107413488694458867668005147763786298620767078636684362405851666628797261907972516695810335922596314389163613662492181797273752348648346864515501555251596014716433396575567903380522262133403396503809464597802116313389402160864576132812748883521305297429324427201478831440057133336689411148749837061648950
math.905  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000369703808177117097178984874224383291141306932470241305438488344263814946447787250380704360747080659156223766440173434609774518563494629688784142118890439396799914506690664338374852137911855503202681240449278972894090528859641907421458476537735668856642806345042118086153055447366109029416752984766702766424134210483894543725147792700332254540115565581041396725695398501988681052162717757153735066105784194298892555906788067211631958297374652839276980659498541995345571737255345826087695429128424401871295750447032384490006557770176170350823695878980666355163382574477585605794520098539243092577875791832225511415825697467712952009676308982799190855513379965757154023052760769978787022580590109445476700589908484459691359575647384608015188352713303701840210479138860095921371040
math.907  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000092425952044279274294746218556095822785326733117560326359622086065953736611946812595176090186770164789055941610043358652443629640873657422196035529722609849199956345810999487864092270018073893422978798512081320832254666051314965275456003789965873068122458771610582965249902755868164055175232630618810241325079792235892039973472479803253975564880171736346645216250804782409569975169714257742934231384507235358659561317095333276064847029594112003935507790637745241740872827992892092364336402570751317561166858615089306674909183195879243547742456262157439031678846939573305463190083422461547958221259491783019100955814270559653602075649778742880215930765616107757769878040549327424615379249597810599711760659298696059835914431785227816180192187124703128960517442765685139801608786
math.909  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000023106488011069818573686554639023955696331683279390081589905521516488434152986703148794022546692541197263985402510839663110907410218414355549008882430652462299986610801453583440509649231197364202667865005771616609033892494651462254429710353661685584137476602385985012835991134094562382796122493753394344205619145458504414705230164529468353552435196386093581193015294545265195597811958182719982974726490291164495273874129728469724779172646272537058803243112312467496723746438717319656626499138779939740967602129823359990832108194455014808390278896224539803588394835810040357831139507389451816740352808141825867184369402085394065244775012024291489921412313736286413795301136461497063263578186779857836288677097713551431336534664186845489935306138754091290464362516578591861339671
math.911  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005776622002767454643421638659755988924082920819847520397476380379122108538246675787198505636673135299315996350627709915777726852554603588887252220607663115574996377627997141579514810277430328922547317960081935974588498232754279000892506411323223320157353807205756172267166167094205855610397387452516364156541478693607816966268413235410147968668018235128164056510593020700530220691823543563865144921429824332214666621122430491114788360794622017478263386038521499231136946123418553368846441058884815297201736284321189315961163479548760447985405802260039364250828424341441611620998016214088796418675102257637916256790387868890476411892549519115643367364791335602771359568558610005902331082025834356207428939380673274845051015779635046657133612002179972386331900224603072907382044
math.913  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001444155500691863660855409664938997231020730204961880099369095094780527134561668946799626409168283824828999087656927478944431713138650897221813055151915778893749063843403034919255080121538803105290201902091487529461571792532060132143690916487228266053003413646912367406588028885611256463584449392681192905483064887464533599464046072723520532811208204706431979873940739693256480324015857634560063778760695945731799842624861041751033740259616999619788563389121632712686239950460811061265389181894860301201504891251888757603842388315914312624155277436655912172777860451371955283069480151678154147139930331770432974499955384296605228073999387211863022507976470259875139879183670371209959281827352294923985345450733995340503945552963498475694949194895820711786417051643457601406453
math.915  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000361038875172965915213852416234749307755182551240470024842273773695131783640417236699906602292070956207249771914231869736107928284662724305453263787978944723437262564895619788077811980627058651284036299086316719678109307504513964360429875083631781625880293616780683444957728014673158241682645676119150785770458499800735973876169136192904639699648384575948310144877697346894268826349227740560681025137977419674553404262628275897829483101276623151402793762381563292263529764130379433191150654747189371425952670744591094150522089347607950902720662390792438956480314611416812645016721323168302135617377438261955821949693656055121405704743674425929906342442994518842829153717205698348830663155791512657648206407789652243445932642497103444077061187226884665521778069941920522348012
math.917  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000090259718793241478803463104058687326938795637810117506210568443423782945910104309174976650573017739051812442978557967434026982071165681076363315946994736180859315263895556175715457656294804426705618610723073050732051366806295039015052707211110691530095566760312125482718400980888420189473982465343462780599868873105062361471521434648431917715029837040230944992216087451226669831269624410959940248141162715632520916876409551283863314387699233972762642432181476855143017062809397389803065225834764006746995493598508297962604135301127418359746456130246549499882910130499849738902228242290168744988455168982167638379596735525871948835053477945040255530499013590041267014640174558627624094243531809646677838009401491959700513493362049660069528928191139855332339415746529820580261
math.919  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022564929698310369700865776014671831734698909452529376552642110855945736477526077293744162643254434762953110744639491858506745517791420269090828986748684045214828774048516958228420487533483302663583490008712026106626623916036709523201536629466866896260057618535470773066152353814000336261179594321233921153659328873052789159906894405115753305535911961493544381550716529026668126224211364976919408497454856016345133140072460471494149398636748105651665813062807892310935017526194973733364057962288056254700579818362779012506074538017173028834650591343438355651608942762119966978044743173685184903747175474320372837365281160389815663736265885636237615338796418081985282071753739516606805160487490508219000432203089473937093659931019021530667663531509175621374100500014375972462
math.921  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005641232424577592425216444003667957933674727363132344138160527713986434119381519323436040660813608690738277686159872964626686379447855067272707246687171011303707188853754563368166907823346625220026854427505091351502631780616171799626868582554404947813477285573583182420599433853342109018515581936701053662963780251352097302464114177494136862004419494815409261230878453096001901421625795744545040434646668891243154470655552553497440839640814808690202457534221299346889643224706767275207598679312361506094727278977117380831399629016851700639290144803889421841607815169426847119682569973051838744785714473818428056365789068751498560464827849283451385977762850248852127900609693179038119438595813924842036300300529382003170416942634308845833100369868757103987563168347500417877
math.923  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001410308106144398106304111000916989483418681840783086034540131928496608529845379830859010165203402172684569421539968241156671594861963766818176811671792752825926796695841454598826369838056189588799044931912615596191877478665931218665215415103899928480976308164475294400045563507808828191697180941983916946018942217216047252839349576751118864902025602242843780672881337587598137614008575706890546908482792726568225093085398759979296789722052352072290309724665362502753468544063929820272113119930434936721269976446528853365773695465112891391839510200757755674500202546817141406451054297222093600416081081376544599929533558262546975069692241745559853129360809013486997149291403115622649655038432416451391205018675165714780826420469825327939998683391286992882345943279954785434
math.925  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000352577026536099526576027750229247370854670460195771508635032982124152132461344957714752541300850543171142355384992060289167898715490941704544202917948188206481699116449565178238219446427328873176686935759969761083104873390025945639470328161008170067755964460127656799444246993007696620656840048612810937076964587820412321321612638862949283582468738817882913697983138458402273140166919766703531582679159833069789605004194098018026801924385913012515813447565830667970331193647659243008128834452432612811412122482105280061738534107404479730456488091982296199759063664508731775383647890411942954072995611435216642596748534162594393432383743913313111320727427494957430815612831083473476518814009230078230855875983060860529595624629212606971566398599073859050351053883309583172
math.927  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000088144256634024881644006937557311842713667615048942877158758245531038033115336239428688135325212635792785588846248015072291974678872735426136050729487047051620424772722302575507513415708307937847163478693527536052457940983455724295774968083033507844440311939366228999798045761147159838367302615417870366102767040590741898216313299191443255163138974481486754451432648344726973242105807507483635393515257649836117395561359428983734444190867977675946210378618349511894877566459791405136747145969968646022509749629967064242509275159818146932106841366636001921431596133380028528246901694935160882885985277075295956079998658496165753387251193423714387204951642309242178473830444559931964742637654498692571232465111422631112108202477148582686373639253559670305056110608692148612
math.929  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022036064158506220411001734389327960678416903762235719289689561382759508278834059857172033831303158948196397211562003768072993669718183856534012682371761762905106192470565786204429304382796508856567730201552450211079121094302735283489007136622984219721335854212036672164731886164049699226164336274605501909482859504453321352939284813259972050028371440984387794411348122211095015361907149892539741396887384055884347644064406069536650288809352880728764963329130113084140216739709719762565455847114903773385369372784017865543692100283850807050172242581694690454887030959402977137804262244354548348896824339688305318390328303195885885098635819265192996059316919809461170142956361981769994802392469993266791062840691289660982235024278568291331484694506088335684807772091447174
math.931  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005509016039626555102750433597331990169604225940558929822422390345689877069708514964293008457825789737049099302890500942018248417429545964133503170592940440726276548038751462365279653924112407702450472609073731019210295367846662066377281241474035750331584837927506881620651909971819770693036740021698459697934962030860256394384917459629389000101321372317634820213203608125483184924345121501809220542050510522575455704858178525554316070926038639931791681169568453283462736941921969201942629797076147024001570017279142581440771560675300630420580254419536168316757613615617108164207329954741457968493586777327048540417638237802923699675150070324338883682362933629723486033660984672640814451429540028641816947530787738919711688023677461699441782692575277451760755148480218673
math.933  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001377254009906638775687608399332997542401056485139732455605597586422469267427128741073252114456447434262274825722625235504562104357386491033375792648235110181569137000922311792894616573074021979869122603233501473295964407991774210539323583403874459294146306634598688580659526207489136475537328869355442668444261893214406491685753298188324621071247599893129174558203529831946455180749075592890286568909033774766830498183611487661335635001976104185097592111904966717543399618341523446000621823324892270701066863863841239521507159317689643114971541219651292377741541951000507580117501006957100524824747233432285369446443086740987931380887068882005802596622683631403585938007337512225583432607225186819742186117756065402923598037581790702891412259750796589963804459454514547
math.935  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000344313502476659693921902099833249385600264121284933113901399396605617316856782185268313028614111858565568706430656308876140526089346622758343948162058777545392284249256627526176398931273607723218003367582271892601034498223511185295386815077120339458119920786729890831331164742376086196456956805152913510016959830822606024109549450072845310049434836836278639931302265217996769873779693368721939518799057352302040361464189847162235354024354035231230723712115411028763418015907812737185055488039749337026348059852509510705349903655920290189546359459579138512660644691781620157469536001924776857789676995038730881214344945515785853012294387852469124736291644789431097938012857532491408167934981837186929556539252224831539422213158782730709713773023846263235478359773566130
math.937  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000086078375619164923480475524958312346400066030321233278475349849151404329214195546317078257153527964641392176607664077219035131522336655689585987040514694386348071062205940167983293598152302178387914477092667586958819001914274199952797361461074720935039240655358052561851267095649999730621443859839759581175676329597844336837201627829760817085238265908800133509137246451719119276233340839672370743757187037526566177834256189057058709075754821383606867743604572667420955969007954251380307076663818495242557601227323278137308193673071688102071847790613355256556495400460273939767896361328588175154885231827469732185979847750637216904306456046522770455406968673999741598720369121924733004694336776478809016893049029528402520799181056220191917455065828362357203516506656025
math.939  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000021519593904791230870118881239578086600016507580308319618837462287851082303548886579269564288381991160348044151916019304758782880584163922396496760128673596587017765539460962711289384575175572106246800961733520496211459073945928169193857886579195352705283548136799790909314097252053074739440769654205362300030297259084808994420167424544184025062108009354654848576260369322055255227594828602462079568453569545938339177760499864783034163841722111386163162691715042473984189738188902608006438162727929424109914315149634759286578665192983219589599905658848304909869134767256476970129448970678563110239814536025683979716684915869975104498852772092562959700899081018056477965826950316807359958950460406785783739142126372719510210872308935765833783384090344084718202043069946
math.941  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005379898476197807717529720309894521650004126895077079904709365571962770575887221644817391072095497790087011037979004826189695720146040980599124190032168399146754441383529231868429677814582784972035942650274116096998054612417301840186744196234856073614706818622787353332494893572963618480657348377475684126961352089760093143175734539233615480369235207922934984755086194848478709946713206140666947218369573206596185767376214594451459754563476159250023808934646984523785300804026529648668054066415877370598045286642018411837490216921021382168029561543650507654513257824861836940293392796353649175593939456256218944287810262480598809714312158589049323648286041385983414554859249868254990017031057174578365750202420897915049021868142605587978552668575302349390317755202255
math.943  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001344974619049451929382430077473630412501031723769269976177341392990692643971805411204347768023874447521752759494751206547423930036510245149781047508042099786688610345733862543841567417066684236950568152550833021243423635763305437589828240679831489007941808165539883400364431088790943528573011361062276044189874338517096532871347222380176488834254382588040415244213068202097777523023519948117560081395333646621834636204120043437647232831218363382188005683738802543900983750004205971382210634338335107234868169469003035827488772522597118993738068399450386013306940098822358040837670544755840514387207388263924073524046757037113759073106022915116558158051821842701062390574052382103046956158472115398138847111494930896170577888921027784002487385313911968120367963118821
math.945  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000336243654762362982345607519368407603125257930942317494044335348247673160992951352801086942005968611880438189873687801636855982509127561287445261877010524946672152586416971700041963850202336391897817870357964254976845907014046356902250637016748702319126019098034198079784519738369962430160056317372579648264722960510787607400924632026965969392208951963665627795601995416715330368846993217235218111231558104556233900033053074417187052776451636684545833789038635643715735379317640901885522095109739219776533488145134115905575134156116049099822649353720489342929435621284007821093539414148086490374530674908661647850122182199524789832410477991580446553817265742263420445484260140490862443044565988751027338806567378798720028295079682840511155933071478632677710477699860
math.947  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000084060913690590745586401879842101900781314482735579373511083837061918290248237838200271735501492152970109547468421950409213995627281890321861315469252631236668038146602410265463998962098991357158918448947297285929321476539424922281650834459386156698352678891914019212134286819722738001928982222822185960107721178189924426902312977959701725409504934708340583549999642532406569041979698207745135657078701874031327461555515631316226138076717119644222425807091701659675145916416635814998640917427201154436610117179512277472352659792222120076894569286288794361583947112244160045185124270831857646448940470018595937720008716299182823137661609767329082816319860303278399650649863758614999553960698190250130439422187593589120131090292530823400183606093710497392297852721537
math.949  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000021015228422647686396600469960525475195328620683894843377770959265479572562059459550067933875373038242527386867105487602303498906820472580465328867313157809167009536650398937527500629363459756976892276832136123947342591333291045354422505859868648187762744624912445879943366914389600877646880278690747986997911242989662875143071006103759347875658678549438957630853590241362076463412519838782172263475764746627023220055572235646392564894312789601450842378545853848132520988775086879467584405129219946828890894789176387523253496592719789375000124724346836045487911733445001324583733384485172580657125441334677917863035410654303236444020841361366573693427420331232923352251847725751698286530058685150877856213079492308875046783284790281644931045470024216316671229350295
math.951  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005253807105661921599150117490131368798832155170973710844442739816369893140514864887516983468843259560631846716776371900575874726705118145116332216828289452291752384162577108955375256100721818987241143051957564594059228077593296314606715047747396381737861145331882700753596751870613150208434652527902249362206861254306806878720787778668223635724450367161274942315778439009151884059608957929675680359725842815629548806200440583679450628832671143167887509111483806457375455697513662801172568396514522496040386701458937927070829099566387371481846310370264441333970468987827589697936943003752022163216388143553481620033630225515256445494533121314622574481153007228273438407366450549420300119732024139088090961501549425024513436067773571791443652751526822222441554342290
math.953  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001313451776415480399787529372532842199708038792743427711110684954092473285128716221879245867210814890157961679194092975143968681676279536279083054207072363072938096040641763302566047220720108051590071745647561549317427046539494631540688604467986243745262507344500811940371968331343613196228314856942088856852029995730142232918621560669665284951682545767294962118568515019339255752310721483305001815592502100603667820854821945274211209643339739728223326792796376393868839975313090953972634491558721413086092756413965168070315284596620713118877652689405937454032147607170228816791148077996331280820572653262156245704051179360470793218279539024376574132079358997248954032665879216855580395830966790495729211693299205581278470778355074280924564812928694735342062346168
math.955  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000328362944103870099946882343133210549927009698185856927777671238523118321282179055469811466802703722539490419798523243785992170419069884069770763551768090768234524010160161499388426604684432935650827490040575987418536764650559274872839911398234021859737540281850773735312189901023717259517333646658771591260082613841875313354708023135033319388646109494760338646921411761832378870205671491331987807148180331882845833351663157962098523781684116911809652498208658346032089360274568303772226637636262043559994700131354584879523651336341762768533738339925349931408091427432008841761560711343109503941971041275382958133566358238008883441449164195294097029377699771092531182683156990318444495520980883097930693032866311001985254455459844202997334105319626763328730819942
math.957  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000082090736025967524986720585783302637481752424546464231944417809630779580320544763867452866700675930634872604949630810946498042604767471017442690887942022692058631002540009338596763851116042225329741267357775730197876413719938220605728617880807112234203486564432201294963513899499019754930630089342572813855830120061719198928176250285062604692630741764984798039455062453707315818702106781127091549802885286498742852814349467601149781366998500613625549967312462525161505179935197700203223324634596057043292575277005927335595299250321954287070814904678213326279833522181482979524902682837534576123331085505617805122763344741333041834813912651935098004598027306281038948137288503842870588323913056141866394404800981082100457941986922668421759867887240213138993116714
math.959  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000020522684006491881246680146445825659370438106136616057986104452407694895080136190966863216675168982658718151237407702736624510651191867754360672721985505673014657750634998886176930651661780999823216916266958569587607128158573266472267558918118289921802994029326884530533708077568431654293922536290669234880437818557943129659908149234911414180004941599089471984348754883039557861596606888741150098544426715395006818499360790979245168441217899695220610447827322084588650097467298136247065770230148300646473460666273221193754339213853377815299354967343461094782049047846317235798481643248416869078487664366512664025431113093369563758110915024199992314335253213334572840006474386703778070336733504224082366907233781186688391448183483151882269726559416871202602330598
math.961  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005130671001622970311670036611456414842609526534154014496526113101923723770034047741715804168792245664679537809351925684156127662797966938590168180496376418253664437658749338380648183902419743677002184558685713178917118120597617875937490223742518243034317661578258266721519197469183104191399583178207384201853883437830107953915252045462852158374236716125056180006633319558979754092736226206415880964861537859781507160052985767819841350244219016958273287463881959272883626764510020371178079346303831618382292916431803457753946984749512552619049583598460489091036243192264884535224424816241721272859096559432096009296014646757334561766745874856654138710751495028750765899071006433862317153696058504286729409110365607887176646709702233227208160300477150080424137066
math.963  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001282667750405742577917509152864103710652381633538503624131528275480930942508511935428951042198061416169884452337981421039031915699491734647542045124094104563416109414687292021430437196379879666050318972109880603842094650255437942081105944181512423267864876977513137134612263598081908338729817417353761714540765522069296492267641356884665833534377073135249684748193925031165274012201601781485342480144011435638125200920578793026158493383784463108932707562560087582714951549855607351756997668518447006042809769668918078046838580765179302121445281602982439344865005205607362251261241422475165480787992863385000414265208822571830289128214736923737817861643735192007927223288969291748928019290991266949915190570472322973037801685557373736529726986932452458562671100
math.965  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000320666937601435644479377288216025927663095408384625906032882068870232735627127983857237760549515354042471113084495355259757978924872933661885511281023526140854027353671818274942986101403296999490332279965075963084169787020085426975469084739365090540220159420261458778567784147385602894780225822841966929469829837232254067898733213535324939183229310202194037921381434589294221965077163577088484132922690798821074218708720420729395635270990620222983010718785587396947659580940061330833708133789105885733398822773014039905802020197741086498849774012060212611849993486702964724256871628589593807798996345387146984783315154560462924573354060427858480826963380970126133139888930986627472503836894734411613497330962198460545146861588045201675204261746232412631182909
math.967  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000080166734400358911119844322054006481915773852096156476508220517217558183906781995964309440137378838510617778271123838814939494731218233415471377820255881535213506838417954043134121725607305036870111129651002969895892016139046461349999782150839826493194366541274606305188025842164748035928142324389562891095156533997379344176119022219491021087821620285656528776260554745560723901419648697276995186228502293113148800871588688807647496211959455769208675903174594470457790558972308017768988621151580497377029723903056575305078557528445312999319260524767302843428549408680389117627387057329014428115274004235077700732520496833991379886370355357894973527592181417298990232196787596081860888531630702845732632626147409576940751962243338680517254597456296695140741403
math.969  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000020041683600089727779961080513501620478943463024039119127055129304389545976695498991077360034344709627654444567780959703734873682804558353867844455063970383803376709604488452383349898096990791106142011263832295710067400632986626960403557867265351496425183489341900644135459772243225599230156242545121642685996344683497375871835797892215367608765976435714957650061992499754252550297496768528907732737660347529891509054141268600601599404578580396534074712778105643688018482252877482298343650067227639954378396278849393402345099084047363276273135614506635434110364107870758347065080834974660486110150828228605541262388730379662279985233678573841045521386273041720767737543134060480363438222088242927310969107982786947256760690249883942631581286967333159195045785
math.971  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005010420900022431944990270128375405119735865756009779781763782326097386494173874747769340008586177406913611141945239925933718420701139588466961113765992595950844177401122106606928526379265979097492639354967135398194005335827213587090179725655826193342583856115836168571470866583255132057330245827351256776203816760558355554720861553594852472526563493459382586848874161298734116486973199334643922847144656234973222847932499558983823583807472160821557340526549504672882659743124577792637617730271843492756751569178176857137068034135783256473000488650006496046448030696386188448169532499975911908170600267761625783275446308387224282673883298448936066398606941321737958255626674583063585060290015805644440663795177808574654334132971809351559710189334557092141527
math.973  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001252605225005607986247567532093851279933966439002444945440945581524346623543468686942335002146544351728402785486309981483429605175284897116740278441498148987711044350280525930742248467596303810035063898631679568512629687021309713104688293507233028250789073337888042980379485926085864375420470959122815810060753173180892707022172052816648200920294784815993243256229284044407160356968234453433367488066755645660091978311912955324765665460893036994269715050409905449418129971926268571766900486856868274722689467258666528604213618157720695528957182475745696255092648623441120536757204101737120652317511285794637872446251424046425833632153336136413304941683280204052067863037342431187989340952237653750536768731034130222040987789977523595252197869389953538941295
math.975  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000313151306251401996561891883023462819983491609750611236360236395381086655885867171735583750536636087932100696371577495370857401293821224279185069610374537246927761087570131402575575102763499178693421981312352749790838349873605907868632446942727865942157613813241899727040623623773919578420441020100524746234217765422643898087397211328518762031332573993915302058966297098830399825131116656884390450906642032794355124695540182827614541773803144220922702312024525627848992603550187005212757628136293128047248111397270161827520096857233386881176746486997958109924688707514852933237974104292054105451697361406789064760946874022123884908574864950401587900133955596371899707405368780046246264325019183022800451431828862540380022293784001533192035186960564195446274
math.977  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000078287826562850499140472970755865704995872902437652809090059098845271663971466792933895937634159021983025174092894373842714350323455306069796267402593634311731940271892532841742784107453588486471650607178580727188007468370432419144098153243006367472146108506507129263087461699527085837334590619648120896468040120662218017681254846503594848231741602063039778185427085791884625040741123028578133448286403269406190847931763632946665390636897871823559904751866951549977945241536728288653773309202427264206505038629335400016277662511170228505842919155325768924757989995765079182273168824670427671489290448330970153192099289572699966981749283325780121844675472311948504780829849818403079259639924884421426790483092708267398711106897026135015204102357999416188965
math.979  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000019571956640712624785118242688966426248968225609413202272514774711317915992866698233473984408539755495756293523223593460678587580863826517449066850648408577932985067973133209446683841503698642928834330889144352879257187192833765027906765144898747533215049910315299463697121624168838786303589917656856071019913589266502458292905964359664491441938543476344019723594471530205163325293402552737319616343052239264491092287735165029203693004458034540338946726063026986379362110644573941420492534413969884612534917407000662822297173336736301632978581376561680978475557920537488222663475400034620996749007234333330708498249702932293800236070695871139513136802004847162566231938948418254218819936950828521596248545442554006814290457228534052734833536109764362720286
math.981  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000004892989160178156196279560672241606562242056402353300568128693677829478998216674558368496102134938873939073380805898365169646895215956629362266712662102144483246266993283302251780717558180385322310991510563773895620443476011292394963605378907704179434709453544215660138197761518550510683668841941975520967916614665355765987500107580698618186013595004155733588955958094625409939262549950861142928067887770513915186473770017939375799344509185940639501170030319901916279222213158207981786549114001410121538761117227407003685410836588899390732522957246398833846294955449410969223596253387456341877139756615341027184951459741419270007297350358670143079094812043048572376104999962375649944197011833277124729466015406720483274861037443256268087052786043303790195
math.983  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001223247290044539049069890168060401640560514100588325142032173419457369749554168639592124025533734718484768345201474591292411723803989157340566678165525536120811566748320825550735152409795732396144682187449575215661349388758695447406114021691705744428782582937764003280540257654786607016225139655280072835177430573403565326626750225284353183685487885873371878309793726570373114214053189252282103840372241015190685217756455614324081559391817486414734901934453706490447102460554543221380727254091311557884579902569158132345062744580622622308488102156971490972678115730057101526625004798948806688947073155897951039498344970506201496780369726141291943255620266212774440457792803577255273561280284210927251347335514161977902194372330308784323355710201284895468
math.985  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000305811822511134762267472542015100410140128525147081285508043354864342437388542159898031006383433679621192086300368647823102930950997289335141669541381384030202891687080206386327118438032337106321385470174463997443808293829215233925441025085679736059429559017964343958578488555379871681312721488242888428356987541461206917278350519945810314004866896716893201304620409842429366241160472491876732901026406183354550483073950387264080066477375580290266443750733990644990131879602344773732368574784177950586248925675609656422840326650500742757615188530998425564340030262413090320176621891172854861618154852415611839768550377747909261923874467075137048598768161718494542222564396496707830105880738186070357251137317560932966925600151425757505589591070650152354
math.987  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000076452955627783690566868135503775102535032131286770321377010838716085609347135539974507751595858419905298021575092161955775732737749322333785417385345346007550722921770051596431038535684018055167592470133846020864115511972808405378461647345059189565105602341549235227249447043476436801134451102552288516088326541932616075227850482489982799438058974154079670549130763933398185746350976997505007550364893993391814862936912020749448122524397655273342692705624217199570180142384627730348493980260838525092546950591455636199870716848108888945354822902889513369374017360030491090430417587521561459255423084112006241830116478512664974445732698086834228420633687489784839756004917007277309912898884761033803296698051932538033285930123119843184261573152212386480
math.989  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000019113238906945922641717033875943775633758032821692580344252709679021402336783884993626937898964604976324505393773040488943933184437330583446354346336336501887680730442512899091010625718330489190481017821264840938602593383813723222071121955558048007970646428393769833212897861383716853706531745692699142948570257122546678960330039712520238091025586067150883080666160140432428498836871309685900479475948468924970723760642035451287964334649358863147487225188626204021038135442270062401000166267392670608415050786703698483967594375833611343749722506345525870176755296707376960200788909795710482413697393338691562170387738187928953805811127503292515977530910933133200903197506211515986806041543418191474258080166633434057410085931504607387467793855208056284
math.991  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000004778309726736480660429258468985943908439508205423145086063177419755350584195971248406734474741151244081126348443260122235983296109332645861588586584084125471920182610628224770891655518174397341907243376183247537158838944910277680790637168810984292736466700765827016792172920958663397140290599762578320036886563477980434725679194822207026431443402164294094144205505781318393287002046422096512552603673846655027152118639954573924962583497517754150222815570457212499997642589818398507788733196840632672123138119212791668205450933781224771851442463178169852193448815406746820659695409944518601766959019225474002961682490692724247558639856380710074306316725532986917674143555956992968119797363737917297348032529236010737765506980046866493903581070519350118
math.993  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001194577431684120165107314617246485977109877051355786271515794354938837646048992812101683618685287811020281587110815030558995824027333161465397146646021031367980045652657056192516136000498241007064254057475482695679508691667219073005754478860687438822317241154499482919037503085525203031034612533911672672882136413204841073687504978203837402900185948427887209020756129344697432827397631958616243846431278009754728356631771049752161897013492888388000788742608840075374854478861882447887990643481662680323961506375498739781642280734232128294830482000515951028178227582914193088514197695850975656637986815447813408826494537913510408408163771311736820713199807713536158007660988073258569816806276157935394455029205728695957605719069693229827409419104230424
math.995  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000298644357921030041276828654311621494277469262838946567878948588734709411512248203025420904671321952755070396777703757639748956006833290366349286661505257841995011413164264048106058680230631548609112760305500764074299279076765840785671418232720900332046039840074062809869850532032340062865537866063152767468925696324818218568376049566411107442382456109421235937102409795668744419553033449287152693552192910622073633753426766641128196708309134891899234361975359392241020277976131145983751596422591996250264476017935766451832495070007068860309342485252991860864153363080906580544537399692340037530317752076112324917071633038323797970532230047266225125258648849640395327432908471432544093541970969997185843877995484933357465429443889210693476376334050278
math.997  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000074661089480257510319207163577905373569367315709736641969737147183677352878062050756355226167830488188767599194425939409937239001708322591587321665376314460498752853291066012023961856736110253468172550736000756591288387120298246033554832171241229597063368799068425933590848717524867160728260547914147721850212634372041126596224490535590367991804390539208587936209316007752328773226484821046365865005900745160217173056083781835207429041167623302174379800317749759759836940983312550224805390319829774125720341587565861650606124749163628606631428348314178799827194413135872083757791345594376094722496806545856549223779509604889296993402831984108529110955296121647278455616073243536043062446427474341645135405282038930715497366666308092602810964378986340
math.999  = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000018665272370064377579801790894476343392341828927434160492434286795919338219515512689088806541957622047191899798606484852484309750427080647896830416344078615124688213322766503005706818259411159624364733312847474211456937596864204379181705555372641234160493181883763175744755077660859250738940257133910219700929121539172131292853081999065911592137788216704109068194200262433805668971565899764934178460481500706149213566306977275644677328035736088463029251853999603933706060271837139533910186119218852421739077545281919670177554539173985120571698012003984878059732136781572731648119446540232421560849123374089062462615503718491113493276741797669812183531204187223825636396624126653726427039940203586743601409058792677528402891522358445519664320185936019
math.1001 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000004666318092516094394950447723619085848085457231858540123108571698979834554878878172272201635489405511797974949651621213121077437606770161974207604086019653781172053330691625751395188351006522823571360620306011337712550045526011413772426112461197401306195626817235981974749091446286197191054522078519032015346293324815322192246558735774952889169575443312803469490307481952603807682373356218032087070614153876238816454400935419635876932382663023787969939282879333733318048825958632321403879485408390536958285652741826141329484360189843351847507164853497368397034432829892169745060161600432680510640672014050529445424872442940527166904970374915279560170346977832973505176931701918918597635991887461683006196340834297037430604942880101166682055689155439
math.1003 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001166579523129023598737611930904771462021364307964635030777142924744958638719719543068050408872351377949493737412905303280269359401692540493551901021504913445293013332672906437845295286213156585612859854198074254966839249860387333329439830739525693967223610187230683053527308642801703131799125830189922156714867501720465163214662229325985133293723854901238665823285649294457106679774605286567888775831941973718153084382241759295103822307970319480092308643136107182406965006514749579687576694535819406290804986427982016189160340370363349782506088273705587568592789077902701254864177452805428821362781106890178795787504949741088598176858089944871531306896936137233752181179598254359613453596297719134389133544638796951060880829660471556503669775702407
math.1005 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000291644880782255899684402982726192865505341076991158757694285731186239659679929885767012602218087844487373434353226325820067339850423135123387975255376228361323253333168226609460934732493458688594328263451915388246010005629417331097508102420906572785214202933798969381141831136392665097842614269831943224816517856839099457538334136488077517933834584993984449503223926586208036937582885866952375893603404847461028972676793927394205105341803576963429345912240611528807222179502392127202509537188707968739138722834319777506622446171593533406448515104946077053735440657609406160856439876459542388642788538297211120905374096062641519856022698610803303638650665554024055564871221507210244475410393712081314447815257301087939417883389964774955247434462141
math.1007 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000072911220195563974921100745681548216376335269247789689423571432796559914919982471441753150554521961121843358588306581455016834962605783780846993813844057090330813333292056652365190451005605732392039099185467383117535856203389943637171263909229437562237806332004331080592124892508415087226523879934037215843481758409135590448567505882660240276922261093244944165627884964319633206144329782020734428143601513731089302624668578466072941421255938015814737062801452716960426024678826840909847939083678304956821134129871687675796461920585008025754403729912378136731838230060177186160935984251643311008685768788116375352363500217407750521795474367254643349496029333944175290622150366245274073391291688561995826363349753577494107122210405944868305154892959
math.1009 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000018227805048890993730275186420387054094083817311947422355892858199139978729995617860438287638630490280460839647076645363754208740651445945211748453461014272582703333323014163091292809182761550902838334054421127563387670139295887116269953566641003208996591093951592629626549790728242528780616560258626127261884372752110529451481673101633395383301306591714333344866311995813219683661610038121541993625645494526635872215327377345612356897523938218343969664565820570911823882662768601650679398511713887240167421676265226579313284518772515195693113019092453201526987522410344194225564158931886134746697204595800301056084629322051344146342782286018271089383423925024105216921956700746588180757408217633019782454919754869125454856148131892438247239619559
math.1011 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000004556951262222748432568796605096763523520954327986855588973214549784994682498904465109571909657622570115209911769161340938552185162861486302937113365253568145675833330753540772822668565841511926246090097833535422402884877984905246509392568252877893186607719149065919570917288526631605192263650095225067738290510094599195348422577608835901082341333023729476397304505884721118536063941269947929381809195234336359233340721274232338568491445988225339232891486435233614296281627046833407724959818229493408398338985683310907914629874959937503904580059292625697698894703145984862558259725161856381906660527673171703292909232435348191378568451019975962062398647206782637945657974410698065523450038729993919031985552314590111037962275494573363328760623933
math.1013 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001139237815555687108142199151274190880880238581996713897243303637446248670624726116277392977414405642528802477942290335234638046290715371575734278341313392036418958332688385193205607838143836226065578811594856470218050924291885585787559717240178038956369701527396231244315971114388009408855858082758326481582846200833565800990812365436200760854981992575558191157646307218210390936734910666303447525075553967169574651045715794233864107402690162130554071810986063998787528957992787646701077019691331180052834719604738616980071923200617249583055645649203526646036729418333709591178651840448488275777440884248308579081452383881695724366087422229444153790826535016896180227249066117211160926725091337296797338046022496574805587442107209264866440422762
math.1015 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000284809453888921777035549787818547720220059645499178474310825909361562167656181529069348244353601410632200619485572583808659511572678842893933569585328348009104739583172096298301395370278565528127956512580544408067549364939155760242468993218595461479061066686307919072366398221122569920079514027239810458954295230923826249633654756270529947298642803979159229974828715798861315149949012868419498467495518847472168823626756507594874878045432892903098745582190283333050729865698760167050041490213644690359060325776120308476713199270063103016314633661117150218620522905125726302824465439744463497747672773839628461177135150318032293865284177880805912365744594062303061879319833272169799668046082475877637633221029939848961409936804610947725180888640
math.1017 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000071202363472230444258887446954636930055014911374794618577706477340390541914045382267337061088400352658050154871393145952164877893169710723483392396332087002276184895793024074575348110429930989988829329220895023185002522775476091593459366516710082229761782372072408797123533493339038876449384007537755819022979178152498944497049964481241989858360589253390869735400988941519406415774631945346331648699497860498169719295315921617461160236018239712955203916497119275061231413076921669995783406898578728303078500865536905765287696917497103214852522823781732242496198888254584032924915058645188636045893300316691062303537384295442157138177147548209139651181924522728043856155373071274963134226699182202795282131863018691742256271714473486708332861510
math.1019 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000017800590868057611064721861738659232513753727843698654644426619335097635478511345566834265272100088164512538717848286488041219473292427680870848099083021750569046223948256018643836946258626037270189576869196969259374539753945373068680632541628766875217836226406483202506653810896803763160068835298639310787352784675785324685581624595510204539295702178832140168967803560385360099022957868310143948351359349540003281509510376077432433487356428863215065546090221941173809302496110706009339945948435927487786810008490007798734707384968163022878777165396837564949615505864865979357108765100971750822211139750930982453499700181612640528403785379049807079419925483170954994158702706257082332177748144400964177860244918369318208241757150541974709939629
math.1021 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000004450147717014402766180465434664808128438431960924663661106654833774408869627836391708566318025022041128134679462071622010304868323106920217712024770755437642261555987064004660959227525894652625656532502185154921857402611828159952760801570123996865224169126978107578762860168008872501239764190315126533922572879384362805698786670464616323175337390707058795501521430738244490266066122233196269104258579448229351596610078422101493641736106981309972705776405548773453331218609877655310169484894780476748596651777696936954061538276980456347057738100412535858037779751290185420604720656877233644878716476923953567954326307083219077265525816587782650830006936577613945006228159297262923431652791051078422825948449301725860757378009245150300210347244
math.1023 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001112536929253600691545116358666202032109607990231165915276663708443602217406959097927141579506255510282033669865517905502576217080776730054428006192688859410565388996766001165239805877166790190648481823866945686799213727772797397700271885277310899241565622897469870039181343700514965359912934411055711950169324639477863054026268132947619640626924580884730741678062128163193729972643539347642046155561566131549796889200576027103302219145929146424921355210463382506755122761199094634747454007978058493890242943116560812428172300762308395903237136100733046224203598524187087401896777400966414518159394988015912772630377966927073575280469894809373028313805832232861889646555308431270868473738068325720976154521889287286127046881688570075687288927
math.1025 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000278134232313400172886279089666550508027401997557791478819165927110900554351739774481785394876563877570508417466379476375644054270194182513607001548172214852641347249191500291309951357702044995910381422446809416848121551367172394926187026068917911803227332519138909215180480558272834678863998806349936706378566830836566917713850009654263931887987794114585714573426165665129188361858397059796873588211072026017135722177451314385985904223040764657630653168086919839384980530729636405592246237203621741402301410646729797089545508303987670629654485167695007866511896582191220890209296805223445370811231455101360705148819720134156092411348892444262837690595529530373666986114737346949959279817705916418562139913337461598402543797323583265440316706
math.1027 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000069533558078350043221569772416637627006850499389447869704791481777725138587934943620446348719140969392627104366594869093911013567548545628401750387043053713160336812297875072827487827026660965449624351887266020339621290000012326009448873711628387616677491662537109715504580654361996818481084724208151812020890228409074835163549126674957904475391666016250899911065301117714225793668243879696331460539575702712751932712224390415344879618266344711382256509098518821110728650693500876625233693438982544241594266310018726423510896637263692326219296338293351521347860947061928558937842453411077940956242332131774880067719289569247327782141464847842899221641494969466700609499414567321476392806013584132598714245946253216091650197302701553507317254
math.1029 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000017383389519587510805392443104159406751712624847361967426197870444431284646983735905111587179785242348156776091648717273477753391887136407100437596760763428290084203074468768206871955379015209859298198669101356876859867184249662311018009227284753533710557197051208807954974109678697887816391739121001023608139066453180003854567022155666135951164661561678757981508049994091524932523960991769856924425515536178754501625250860426035191197027278398397006176376733347727959982517199140992872678133388146662931088425125669860560228810288595266391146593464110031254792075720702510299108617326549449696734957108968993412671334040245537263233311265344019427637167219046571308300764534800700091845194836803605866881348910504167620946525041079682395288
math.1031 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000004345847379896877701348110776039851687928156211840491856549467611107821161745933976277896794946310587039194022912179318369438347971784101775109399190190857072521050768617192051717988691681576742257006411418100529432138427645369000938479062307594675598881997198016799664168965873918770087000219010135041524581045870745343122370275593859412976017025869258553063611973319114147090071746191910500609014564526866255830705584104502880672547927242688017787541113947040319138792129237526880958360630427379889373331075095610976458197683007109058568076917357337892182700868330563827268507984755008551249885436311436980070927486384303194101591434912699073648456186545222200608557771567115394952009674136741137664740858089091499613659251493723658784222
math.1033 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001086461844974219425337027694009962921982039052960122964137366902776955290436483494069474198736577646759798505728044829592359586992946025443777349797547714268130262692154298012929497155912369105278969018870387500159942565976114852810617182853166034696525243514528044102200623518951281203183641889187625450317070301612358411874049876844334597291268737546274072862245383946027591541630982542591370228738489077943214052770421088642076892722651476869240405409089508591859147208496053664399636365695111730963418293872160778241181817285218880512524561921348626010856056443359339496142357396454178755079663933280691537738430974367117446043404708739558653612464345419970647684438213137476716468358068651513347803797598467923295516577282595019321136
math.1035 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000271615461243554856334256923502490730495509763240030741034341725694238822609120873517368549684144411689949626432011207398089896748236506360944337449386928567032565673038574503232374287088311711843599745386026027017975414723447891266654008743987882651554060235856882601789976107567996820955197931925113592487246336449618933685932638687084724628021672420957626588799821914256929959377224247843113886832179847353263070669142777574561741798342346089713117790757774947653144971939148850893973045295916160658022301412000919265487089192733405949877523074282304568631932861153526746246535720912133833995955972844342180727513023192981208559966994070318015046316497287888767520230767722872533839169375831936085500743971718712766990348190552312654409
math.1037 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000067903865310888714083564230875622682623877440810007685258585431423559705652280218379342137421036102922487406608002801849522474187059126590236084362346732141758141418259643625808093571562102309685772990865220856974270495150797437045996803633852123327046598320878095270029696274428685485256498089606634757000475891002940918398247210078163858444110278734601155969225718284302149037243906969876858786055903170764060430495065967425216861499203336677999607123157470732953223401395465905440541333885186463203828345696301480400666325193937961091642176094883443225733932381009376533296633101071757265160110004733586188844605634367372241362372931976017344702633367050016310745497579530954632509613482347363466950701031565896972262791267898463786320
math.1039 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000016975966327722178520891057718905670655969360202501921314646357855889926413070054594835534355259025730621851652000700462380618546764781647559021090586683035439535354564910906452023392867194953168651364885051253156876139506581077509202901069335825572223658831543287664127668762777914291316091034248920506903303895745296863583601254538178574728197132376009001663677301753128994770498619409731067033521259804116543975461852755648943674946193311066966288914300824799483408132433100313833431671336310508647104126937358064690714465005487020610130979520924476201741225454530249413092696111618304754424990615593128063475388479150750117715059347087346410955187843197827318726810836563134911881778180088564477362850830943489774052332016387639139838
math.1041 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000004243991581930544630222764429726417663992340050625480328661589463972481603267513648708883588814756432655462913000175115595154636691195411889755272646670758859883838641227726613005848214206446708519298684456817612919981067632126960378914174097600253107249069144017898989722156713450008384796815434148106465068743158362442733568523704402612957341881751499514773296034061515571756737790031416310009149997187672972639916456483554006742521697662962087541211446149136090345131767179806740554180096301920177617853937145667940503979952784432562727836519673383071035650181024507269738246749490539863415099547185408831127818753038007975516792859093889968969997040607451848089646244006765086052581977829380193462516890770608797862715473994710279399
math.1043 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001060997895482636157555691107431604415998085012656370082165397365993120400816878412177220897203689108163865728250043778898788659172798852972438818161667689714970959660306931653251462053263579278947208833691315994752322621462127027103416199831471603282516085203581806187186646513803772713507432399861246587294160147621124828931476757543789501593424630548996028484056038981529182876397069016068675428018546256231960558041151628202065335496591482328358113646995697671634898475932930259599977484897978440541102444437222203699106907222868691641535226148782967535433992569434418447467745058300856473413210850169644652214893724648384067534990636788033670186765526693231357205307475944842071265165928166917567654382744210892293353697789692658830
math.1045 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000265249473870659039388922776857901103999521253164092520541349341498280100204219603044305224300922277040966432062510944724697164793199713243109704540416922428742739915076732913312865513283891219938733782042508064412783694760431233110152678436431405265707223291737377262325117999055528802522216826779113865826537187799202226682976381859700412073052380966107819771184006042830788970388182879477141619110879597432180197977873509976541407072600332409685508823966099529405622589786316716878973478759578085665910601110445960265059885538822665262428349979935087144655593702557314568652705871774281499964043713528216689137652595951800406742895494478648762621772860996552080984295717556785835377102917408002558324022082991977248585359252666586967
math.1047 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000066312368467664759847230694214475275999880313291023130135337335374570025051054900761076306075230569260241608015627736181174291198299928310777426135104230607185684978769183228328216378317416849451564731468369134517051816956207750092460239440059351810324383821916780506195552429831058381091149620785200935234745091493672163203475581439929892286384285453661350644839073620663086739751721618997814195834225638916141930623972568134931218385136330671989054256156255414159232553418684043783898806610888567522508585520638529547202681357245883092349124156569385993642405873893941819251681231406599633566437512346763470618077122688792258004821817209292848802344644791999244076815765326324199720318920938592083860054026479999735572992946695267656
math.1049 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000016578092116916189961807673553618818999970078322755782533834333843642506262763725190269076518807642315060402003906934045293572799574982077694356533776057651796421244692295807082054094578959106192544659084619185675246942379729708835884178730120560229680826844255021369950473988576339726435075784539680508117365250044965743188842367282908630675959498668793817382743843449967412269504444167615795542113461968448328760223808829032669234450065187398948435075636640919382703307156485569786349148340586793568858470586950460230596427633528205817558916034921839646959601384897862978998760981623723656695791556032084827730858882582142165566660077416646353772436589036282657797019466501214358372977202660282958233838690635137256041886367358099709
math.1051 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000004144523029229047490451918388404704749992519580688945633458583460910626565690931297567269129701910578765100500976733511323393199893745519423589133444014412949105311173073951770513523644695875862542106573102229979476623166118846243723169001430775865986843476483291591754461372823926612849023210506406824174750087752524914638645350932519860105385461420131284882743660890339669908466445543102074031624310861753917155736964051528464071473601521744584515163443192844332979142756008402633259275075272614591811324776566743636533896522616934432963159499966550708443964053953770577900174131874001950455487973575286188631326878399762659726907856139185409267857507294534152364289187848636698407202121511592092914286834889699257247870100084446103
math.1053 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001036130757307261872612979597101176187498129895172236408364645865227656641422732824391817282425477644691275125244183377830848299973436379855897283361003603237276327793268487942628380911169091111680631287936383446054143299439313675903250508013320167448559398611882481190486773837075173350061832001211339059844052520496084691938389857240321993745853143351864857525557067386263174635304779991398970817492497954636100492973465127824958150095510701468257851657175143800022374145784736146119316509633317819949012825339432874543511304279130521226062558580572631293474831330256259891140215771669915611704163028111768787917721903509201695734313102717896845610517171899407648330720069120076474202862090625917989180665658921226846479268478998136
math.1055 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000259032689326815468153244899275294046874532473793059102091161466306914160355683206097954320606369411172818781311045844457712074993359094963974320840250900809319081948317121985657095227791730794147391671390854300534089992405339765083863544520621841967900797374199462881162963529390295575049461264148349544533960972609006742189399853136234816135016118859099967047593059153411804748249808568675342889716348052979062090516277184854648805141398518150758379452435399172416619895813770353093282963482893368868784598930539305841264213708995281934015225095653764663490772474315260050672114223714799810629003689422247836994316348380886223947083292860747983558774245216811571060369748516692940768744718838255205226784184294430784630719445632529
math.1057 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000064758172331703867038311224818823511718633118448264775522790366576728540088920801524488580151592352793204695327761461114428018748339773740993580210062725202329770487079280496414273806947872478117651678892908957246917405606391757505193765854298993837059749090353070451795326445694407475710587900908811250530484447872805735532370849371166349693923009139839576343950021474948816323985347593937999206610794003465905193622751995189697333389294696129190032411038318278293739186031617341949360491118142052599053580013304497817840886771328694134494353298175202295962031244853668769897396937880557241528283205065363491194950265750676850387197913514323854494982083528543173866875166150297368398431301566234672313827184783587324318809475385814
math.1059 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000016189543082925966759577806204705877929658279612066193880697591644182135022230200381122145037898088198301173831940365278607004687084943435248395052515681300582442621769820124103568451736961428371724448728248948435439896679937585624545983655146252164274331688899734805338230007351027822477449484657394353121176023603818556663792155143843926477686805428053511182411742346918111145813342264619246238591583578583201679013807138412246414871977241903131194132828206663103161610279159809164147448856577723361310066411314877511285435148145165175635176737985586850876548046586799683821992704379443251230705346278083842142408947804468393744816524405690074094599072585056463838745496652491115999066513376152365776514771598997777781318311488364
math.1061 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000004047385770731491689894451551176469482414569903016548470174397911045533755557550095280536259474522049575293457985091319651751171771235858812098763128920325145610655442455031025892112934239613630965726515953538122605590312022134878164000601738952341625182301815096722711157323607470950458229316656592092779022329416023208746034602563316542943692412115015293370801228418451241755088767779360363625198523810983973995060460783024699057427682883032971625365502730116855593662443555037816099723346630288631290864195949943077254166449369762175438697797813830005751323638331650443473079826205556379337661237564265476923683258097971654564592805656473904073587125066195913280458811901855257419562429462343235763550070858500378124627106662783
math.1063 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001011846442682872922473612887794117370603642475754137117543599477761383438889387523820134064868630512393823364496272829912937792942808964703024690782230081286402663860613757756473028233559820800856388777198529087734243816009726883099611782429448007690362173186014516386300422209613737041098100885508412583503173855680087719296599610501612777954781610746561344669286853327129481487947500145674622978983819626115818223914541729639801289871214916445135221953425541071973957379344523853638545741456720169226976657533960817613030276090070821728589738523879068137261851548619854342126018838302104364139243874372890612561200392281807828427177187775237532201917140531287703474385830410748151492960080055359562370287443104001277565492702545
math.1065 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000252961610670718230618403221948529342650910618938534279385899869440345859722346880955033516217157628098455841124068207478234448235702241175756172695557520321600665965153439439118257058389946021671314655211870556053877202669564294503637571384551993287486831933419221953076337919930767529890166523750479744625525852994942546071456572517461282867315220685366270014725886152173079394615046351932828324143133765312874077943737174667606655100902325685980014816014463228660060300398765413611451471820650637149315192329831753930169328250596535106243341862438239422490001981424898407962934728858422515719845205836707542764870490391020875839951755041224092290111606336193789579207613904479276790066230118468336055274025513210022660797588187
math.1067 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000063240402667679557654600805487132335662727654734633569846474967360086464930586720238758379054289407024613960281017051869558612058925560293939043173889380080400166491288359859779564264597485485579741715015438559471282217185961359595768795710270219584637962276345426916769221409707951134652057331201328447128573950923726816194216349918455426046230311198948583782960114397733885701778405529526752899130065417644021773585435665762602587902174660702889105864108501865478520418510425452777745612101705532802519752993861419357642002927069823806257850176560209255813057600099828729658735243259655475032536756398975425490990129303070383612789696527231878166887329763364095519822147215157889044818819266600038714706570445789548584199916185
math.1069 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000015810100666919889413650201371783083915681913683658392461618741840021616232646680059689594763572351756153490070254262967389653014731390073484760793472345020100041622822089964944891066149371258079592434444134186585355322798553705006704354801360023925355741046085314665692320566840905478349627188385188613001275986361486279573981160395136040850838257193427767286952264006877045642843823099208594286400293233224277400552764698107921822240799055813738799514725874492110694716592378186613549651172833907645757036453681949634289397423785705075572840891257926015446010325287189600527133321944743803794803383112610947312614698790302906362593606083742897086093095675277093628206307829805735682107422511918425873265212439366825542046016078
math.1071 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000003952525166729972353412550342945770978920478420914598115404685460005404058161670014922398690893087939038372517563565741847413253682847518371190198368086255025010405705522491236222766537342801929304442576619607392731582755423244596982994908539169206805185314521212881589748498867328335663697114383503431163555940882655411618907266599471263706824949567903181524870199628985919324473843962157211805783060391597847097879931752093537162200551719518195726913618066338538748676477521063789708458808343397249601970725144556138555954852028751129875384683861080343576727131815307177257601396933346509487276005036601532052004620465671956933251804229103761331345148414988591521491465823396852861727952831678810662752405855244287758403918688
math.1073 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000988131291682493088353137585736442744730119605228649528851171365001351014540417503730599672723271984759593129390891435461853313420711879592797549592021563756252601426380622809055691634335699083371258862553353042226534806165235409835404972490254882308657445630290355415955831067621191257734313850009888670137534586473168652017596785990448933745153727704721570364015916095249786859245594477147915285743571534747689306004525922666026541053161373071653322735464106301152987922575025560274366013867771643318815257415835731602683841655001590063511828554361659494061674370138251147966910196268120899406353113521617966634900397515281572049234561017500443457622428621383986178999044511435451373740987593012894787344478733915481251899298
math.1075 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000247032822920623272088284396434110686182529901307162382212792841250337753635104375932649918180817996189898282347722858865463328355177969898199387398005390939063150356595155702263922908583924615403386739904832837672593603464578214746590825939837340644648929963126714967157702916992976407968026824072920043006444687263771690482576466653018981226965675840603413601625622037372106296455335501863790361828078700286714848437236480079587418669254407412062796612301445300760338482074371975869312949619987294166698697315837965091788563267391318222385192977553492483071099497765036413342594345796820998243786162210933483325486256191296467049836440269604237084117477853732158285862570786461786976297485023042155115195376898754629376645265
math.1077 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000061758205730155818022071099108527671545632475326790595553198210312584438408776093983162479545204499047474570586930714716365832088794492474549846849501347734765787589148788925565980727145981136579799132116929829097699501079841149496396549020211959613104962330287692754363730745924652834606945412859390885804062398554329536784975030675494576471519299252731751567899982359969565003282679834678276233997479201319657171917510766450766029537807142468425667657896488722988924182121324083404748590882144027591229020940882995474728788024780935887325734331908699462382474301971395004076666533659224261644743567882571099933208957669420284083194775359089122581866999066746859481541775304071561266382123279274810283392561972460006902654726
math.1079 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000015439551432538954505517774777131917886408118831697648888299552578146109602194023495790619886301124761868642646732678679091458022198623118637461712375336933691446897287197231391495181786495282225944499378201526127708330849259909130737897536747725953492099453628146967765855466111875290053396209530532263123510180387292007992286088086586067946551837059016961733479980161187556536567733931570481590083531622132689771960411970511015421911125830344763504158395406501386166841809265517545683656283884868863967219394277674169287521891145893198520983442416256805271545726392732703822002550359896433911323701966609923428499622702380148131082812391503012378272743962148193688428065819216364480957879035564048103357963034275743575523584
math.1081 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000003859887858134738626379443694282979471602029707924412222074888144536527400548505873947654971575281190467160661683169669772864505549655779659365428093834233422861724321799307847873795446623820343263315549991389182291911110014935255644336637708568827285898071302172717405344175375825720446866814195486903744488054068901849086521017482969925073804781666513057779690349466888921034937126214582276540896324475108321113231197821280720720008585242983119195798282975706292894971774481570795309113753613150280668552068202885123195586882820281775361016795159729742444703181797724531862235604433210881089234728784028108108508194155128228081354642219787344697070055419654265763226287163400312473943190204967815754073788284549855120876740
math.1083 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000964971964533684656594860923570744867900507426981103055518722036134131850137126468486913742893820297616790165420792417443216126387413944914841357023458558355715431080449826961968448861655955062124405632546848145613514266137062477573291076485101911145127096480558287736211633715940529882107565972522152376523181180789778614791331149321458895885213109670878401981642061816713815915759014196544767535205267510246537176176791691193011189014339155354919366442090684799223106194842903378868284127642551634744353225538836016508465052179515096812616919433668734016678780267664243438345844848697887062995958966025690507797191603139473282396167592172273459060121255546798326837869193638717005451311567874812104560817742120634450802223
math.1085 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000241242991133421164148715230892686216975126856745275763879680509033532962534281617121728435723455074404197541355198104360804031596853486228710339255864639588928857770112456740492112215413988762898721046475489908630104843049079915355790204349937667155576505081807917310150196192538921333903653984647252143064258368926813136271287120685580228128828415780959403135382827612303850011868529813613515942153137355020021804240993621564599428000251072684426702689350653796782105179366499633384187670648484096017255278191582289754615184398023034516415160981637725978193446466150958766581580726559617416163685547524166466980294624886912660279203614868256808434711086380011892462434021518389578766965763636245830588845959554328347482938
math.1087 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000060310747783355291037178807723171554243781714186318940969920127258383240633570404280432108930863768601049385338799526090201007899213371557177584813966159897232214442528114185123028053853497190432193554767625574071606908152804900612555043890669104496593540821748462147103914355196262429406664884108114596758671600423855337687094568749877070757930095376061941818153020159038819056034784856604472521286002138777876484994571711628273708175504084058749227084764192556618076799212549825260449864998255037308059205135315929785778245470122067238981968412364840867625924765780674552548342956721100226013425441663019181047886479266625788249665618070261403052030171447375299185437784646890894308466592948952103034962429575116038481578
math.1089 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000015077686945838822759294701930792888560945428546579735242480031814595810158392601070108027232715942150262346334699881522550251974803342889294396203491539974308053610632028546280757013463374297575549865708434515397244026748260660905761815728576685869448320155581169183394463622917013618010638597465506600411068678793980729268359512889600065182437729728788488740772355867821829887576491587870215452094702788327200984708096309554025021822611878274378251048714922725817053719130824979191184977431184317918292320210181956128238895590145496944672606429945261986453841593917776875869881251201999130978665995633016283283966706270721957430857899823905591211221260049131684084219659236851077331690065736372806813340089561655618577818
math.1091 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000003769421736459705689823675482698222140236357136644933810620007953648952539598150267527006808178985537565586583674970380637562993700835722323599050872884993577013402658007136570189253365843574390276519428945086835904595543738435865620793349467439216839850588911298256584003131742358739020323246748429755794033922886052615077821641965280487987263301568922837401314930685327612135339450896549333998499941936948435145847524155408900637526992545880307314273254664316001301721109123253974087002794073122557027610537768070193053138868925800960367618291485906077118428783788579593667330616028900640074042093646319296421113679996093075941293115765014733005990538128020947294536458652396679582592770820359339268101929735497734280261
math.1093 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000942355434114926422455918870674555535059089284161233452655001988412238134899537566881751702044746384391396645918742595159390748425208930580899762718221248394253350664501784142547313341460893597167913524106989263042103203342750148536347161513889554151937152785158559783266030270379166368154544729557784025315897742352868520647828705694295571804655409823555719195482269465526238436011367302787708410634468563727818602874431691550874360942242758024106693189673235872816616546170043723987964761227211808785348018443666599947031268709604560719718009814301190484552479677812475573511175959046772462209559029678230804475012316556289876599887977878427300691908997095811169086194013186648717200656800125900755918791228374133139165
math.1095 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000235588858528731605613979717668638883764772321040308363163750497103059533724884391720437925511186596097849161479685648789847687106302232645224940679555312098563337666125446035636828335365223399247398788456827043990076280547703224037547770839253471864870344369326750572179312827015845104602384298217262125974242993459296546961114757093531307416906083727385068726279582886995625244998592378159254076026383587451683149707043637906805343072234238702001741840022946883275360301482137350799783746859840861664649642100497771202571338386640449555283972392362889098501082155829948212434176921905308823441275883764292674725248912721245373488757418115796426262391076134339405455469166298318847534002824627462503801288966563992627940
math.1097 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000058897214632182901403494929417159720941193080260077090790937624275764883431221097930109481377796649024462290369921412197461921776575558161306235169888828024640834416531361508909207083841305849806896409050882286356358012327149771220882607205455710558093814556002477712640695457800744999768790309646295100343035032572721849717962864984318672594884338738752913739337088707038687118879822543471091057538159624893297039744243548616641987446679732243848677953488665150711127997237347730611425806517770392355652599279187779131689166850358722133820711759788447348747171753717060792987463607949875825409575842432074589446634982823371807023623297523586443548589334989161695263503471058880377942646137980681450567659804925849218377
math.1099 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000014724303658045725350873732354289930235298270065019272697734406068941220857805274482527370344449162256115572592480353049365480444143889540326558792472207006160208604132840377227301770960326462451173736922351185517849385547367883384275725634213076816398590134964040547004159114566495552566441381310682616069033678610724652760344513552353548211573190336779686941895180573368216603016890432192908955286771342016655355831537486206100979772286630431297814814826096072040587635403083434983204953327614281911852252225740638846663320344487083051411027123842865231142074062139255218451269903814890284078020017527252616023612704100064568080017172665387493689821252628142237452395156594145730627502655563470833819304774623713168500
math.1101 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000003681075914511431337718433088572482558824567516254818174433601517235305214451318620631842586112290564028893148120088262341370111035972385081639698118051751540052151033210094306825442740081615612732282526102309038213444438573130910408384056647619112641329366625834705511482584210102699544304101316460525237622299704630517671292105866879436746161664414023948236298486233133191926968064243181540622391305489440295096909755429448459768700618839607426307648126393523731106448914018085708653126351988724345278055542534358333799260089463152230618799833467554283533405243328206725898371498505049976508557393809021685751398977807581095486133970761969711259345873691274743548433504264791054651929651224958827882204102830961548535
math.1103 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000920268978627857834429608272143120639706141879063704543608400379308826303612829655157960646528072641007223287030022065585342527758993096270409924529512937885013037758302523576706360685020403903176275997693856443859038670946744956973146308394610323553852545310328072906808735560134431708597553772314005889446006043040891026845912853271958924518590166656224586946540786395588951061801519698216394475174184253198429455920106309138710307294034696785852372984283405685879360124564689707948602885869322561252226188485579131662204626700635217358858412349627348114237821076731359714582757684377175670084786817262135109579432097530625133008408292125317471899244921298739491475500433645763438251769803721801591669811895217600832
math.1105 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000230067244656964458607402068035780159926535469765926135902100094827206575903207413789490161632018160251805821757505516396335631939748274067602481132378234471253259439575630894176590171255100975793314040108828464776501618992626486951181054235619863709965381178011951174361971613101247574096224936767265314588216079302807379936243367380569201658716880198270811292005263355953740937539232962314290204655231086855059605370027728525369795892508219943923031462202862125206184965863854249795946882233328080502069113508662484452328138415257782428396175492185156581034492755430002021816638822601888657127555418265599324052206746110272647600143532715965560911539110611759510844912751651652932189683358377307911183107475703942188
math.1107 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000057516811164241114651850517008945039981633867441481533975525023706801643975801853447372540408004540062951455439376379099083907984937068516900620283094558617813314859893907723544147542813775243948244625658914266617652288221038871483116872129679108463213816944550758121108247094727271854295926955712790088894466749663766803120145858963283876978905326995436654809198068900197613081485057317253388875949879394600998587497151236534075347199416386356240417139159364003312399408149847210966639517990423717799414511959195783250108548144528145305835580108857410616661745143855154261122209192055207600195093903022761147564810941139559703881863388519462478535767195273958006087936462632467760507730576274490061196413567970177305
math.1109 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000014379202791060278662962629252236259995408466860370383493881255926700410993950463361843135102001135015737863859844094774770976996234267129225155070773639654453328714973476930886036885703443810987051835929362694479249392441135523398037174540283570730883728863920775122223478906065369070326411819097194606695551435175726696128490355531730413297341493798251588251601939167918659819019996092362723722694345581626814854599816326208710713442827941958861758876887378546534386403798526414644554466854508925276717254825373890022179061877851392660812617435264108194652899627717081004187316704191728348337849297589842554453297228404737722174119311203945060756555471869676081073832654720628477260518386875343200304667244274594432
math.1111 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000003594800697765069665740657313059064998852116715092595873470313981675102748487615840460783775500283753934465964961023693692744249058566782306288767693409913613332178743369232721509221425860952746761923372855576711460828153158970352537955469277980862174296063511647735216582741225625723887428519237520549948547275211685562404173021193033954190662824451569436380583566705247180481623874335587622571422793490556196050504006641430490622929096268841552092318071485181008965502312072488647319753926577180304554947018522053531074704777237296575649065986875116384873542419233233248131865521092438446185369929735495732738331334913864488869033576209616144814724357707622133861442214963549014764155714692964496370209566351517930
math.1113 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000898700174441267416435164328264766249713029178773148968367578495418775687121903960115195943875070938483616491240255923423186062264641695576572191923352478403333044685842308180377305356465238186690365775493327854715038154164752532915451293342505013260614443381406817655336020274104592783615525860849237295432309516005155975715525554936435267148838842064380333984604356095257840010643243962004007543360189623498618276180726190140931687598777199399846073457900559088728934113114703719537221244518031930606675062649572205070607749624139705991262230127696588019924749720318506370551878462388496926026795817797065284604434489692228718907615895970998912672220550490956708800976188844428222337017312430259709111797236136986
math.1115 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000224675043610316854108791082066191562428257294693287242091894623854693921780475990028798985968767734620904122810063980855796515566160423894143047980838119600833261171460577045094326339116309546672578658571046816662074106971744793760080870671516230839269213901295580397299597842714832841654814359819987080335354124899485146670244750587215185681312955150081136643961749310752324330771860915018484361134063582692347655159237699859149271307530871885533992528224588165848004083036534702237288136507093868108315021243865864401913138931060258463089007704279410614592018030035116377637044032101451027839721619715621265237880933010068497094982183064691563666924028062297214104623101003746283885067761246039562822715657539040
math.1117 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000056168760902579213527197770516547890607064323673321810522973655963673480445118997507199746492191933655226030702515995213949128891540105973535761995209529900208315292865144261273581584779077386668143244053618910052553478790775827387933334038533499656941259370428770208598854213366339837719362800466960965247980391880226414749934894519371244356921630361670493118327616684562969197957559590197945376357742197311925257558367327572979212131543859025994813558103786810150881168319246231959394476289169759298784224325793753103445014042425670427382354192038100784037749908175761181531639560998460931269052767692261663684290897054264424231258221518932241267062923537874910514202928156746470125412341813758058733109119060329
math.1119 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000014042190225644803381799442629136972651766080918330452630743413990918370111279749376799936623047983413806507675628998803487282222885026493383940498802382475052078823216286065318395396194769346667035653170166639278364475480787248952307013106372757352804643275396623119846819636973544029130469501284736262996899749153984951252191913282350309905346598873193798076704257113050008539444277460824247626565558058801267880418063300038250921145446325550451286958521277765391872476599514390993102466160313881863189703637378327684436333043437683072277460980423705884718886707393547765072888169373413577947348007627532455165834069093722127846199137627592483231481040523618965276890813566481976609681905790234109633579622219339
math.1121 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000003510547556411200845449860657284243162941520229582613157685853497729592527819937344199984155761995853451626918907249700871820555721256623345985124700595618763019705804071516329598849048692336666758895754404094460171797290540511360890495454008676275819975089159092509705827807424714792804909464339850290380881009642266054209126666059755077632352701041182158970361631251810118578497233217431240432862423101055826177097177136127736070970454274990350194925024424176707430561669990739284901052408952431632317700291386302315048016843300875825765961429024031674862130211374836054131927481256556414844509792496300303531985512398620899145983211552804190414945646332045112750462036085542499195872120050011310762061197422119
math.1123 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000877636889102800211362465164321060790735380057395653289421463374432398131954984336049996038940498963362906729726812425217955138930314155836496281175148904690754926451017879082399712262173084166689721989919071908440802480451094409424150772103889839801528691213099430731359496098548563259259820420369930887626482672096493151845965152624047221173488397721349197330107961541287594978122253957495537889562144357112402668655820905609902457820214436993665985851758163098359831867370242528975913177495163554579734542571135523071241065704545698818952009135042541233355089843822419604757581988759377294649818415640923343731257314935954951507900998425312296484625293458344318227469623571466453972867585886740458613099412065
math.1125 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000219409222275700052840616291080265197683845014348913322355365843608099532988746084012499009735124740840726682431703106304488784732578538959124070293787226172688731612754469770599928065543271041672430280959551120821073193203436554489540682870608101155552719350311113605606823384900459154596338920137744754396201808194121021246413359009931563426127496046736791813825162199011706489038791876644420692028561373815512145402685161983890733872230335862413188986091366815011128878916475252641820505906290659720271944162792343791541250263069974006663045862616793901595528716530445062522635041267588451709758654565740253718605058341795136542805781982391960695498758199820577741541340774950050266479593156989619917586336390
math.1127 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000054852305568925013210154072770066299420961253587228330588841460902024883247186521003124752433781185210181670607925776576122196183144634739781017573446806543172182903188617442649982016385817760418107546182085907284254139755377244414996614033722652089462685009470695726153589108476594604180349598372798636653448356511863336787705792069585086274820566914352099740211527679985476922668668525286646671736267169983596290250717898244996942289049059492990788081499300874410624803454486757392408902247270860151856863859503705737809261846066664988472856211242462264065054631949254596227463946059492219959790480128006867270746473674790062050593900187160769749635679299843927269367621867252350225559489721968779729931666306
math.1129 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000013713076392231253302538518192516574855240313396807082647210365225506220811796630250781188108445296302545417651981444144030549045786158684945254393361701635793045725797154360662495504096454440104526883872432379829839739544901878414039313876882954889096171827022442523177495417369313074993005718297462153391628522957225065472048942719296515508458349547687316964133317728622229992929084044626300565493720579848020911932557497187250564399398446550821936764967869085029413032177784127070944168080234098154155616266649720437667372311400752955632047547753367458542546542561599215331822520520581088718896616106979759325058869825812509923836277702105736773606639753562978452703233141926010584447731887787068575681402935
math.1131 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000003428269098057813325634629548129143713810078349201770661802591306376555202949157562695297027111324075636354412995361036007637261446539671236313598340425408948261431449288590165623876024113610026131720671098195291768402064676310415764290732382104485244098576161696029865384758814568760298020131652616926595492290053668403176359179535590822648472514488135818122562882613304265614594347068632203134014139991193070003888326207337791870001637202376677487667454850493698937992768445040661532044025519576934743648858230145404416818699345420920521649485320096459922759284025548845398120989518863705965517957450513597857512370234831956011771987818238323985278304537401293323354193097112121949945736658230889220690164773
math.1133 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000857067274514453331408657387032285928452519587300442665450647826594138800737289390673824256777831018909088603248840259001909315361634917809078399585106352237065357862322147541405969006028402506532930134773448860087485758219171027524901823446788983863253046196655718474236290200557800246701555366293274787493645770568449328350566423427338303397260356139860294593209498604481974112406104127398428770605083690104289571107890746937407734558978280257745854867332474509984126531214727914666061615282513214823042105514672179294246996979668776858749450680399235924319128693858812297325477114945779724264043695651160052373775468142238365430474802674260168891489052917826892991002823492776629020203265556283309042587674
math.1135 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000214266818628613332852164346758071482113129896825110666362661956648534700184322347668456064194457754727272150812210064750477328840408729452269599896276588059266339465580536885351492251507100626633232530026573330260247577560358692834984249234059786249394195122078564174991305938685628969697224669699879045609030693436706613672171776915682647103623188003254345990543124309534945925555743856558378991512675791032009469655247962923635106917205343767473581566481048691080610601660564948730878670623816570316984706064619567360050310773620130342999436635947772926114314068634344985125857052702967831802996877651863312609027505506221229687686352707126428277852937268255295950811494056084235240898464606856059308657418
math.1137 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000053566704657153333213041086689517870528282474206277666590665489162133675046080586917114016048614438681818037703052516187619332210102182363067399974069147014816584866395134221337873062876775156658308132099222345369325909724041443870274817127666339927190874733065711550018074638954316009982287926105698689039548701225242684705212963235459336359784760473739461807382516467536137449948214496419953426381398363180305411323051872621482659352821069667476409336734470196957831690642854744240813785359282442680184966633434793150028567507266730704602297161011342627010390779781433983247035827252804355660816862882154282621659152437800128883800345601760518932307449728392672830061067852512156148236466970545608812985569
math.1139 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000013391676164288333303260271672379467632070618551569416647666372290533418761520146729278504012153609670454509425763129046904833052525545590766849993517286753704146216598783555334468265719193789164577032979536587765027479134782779929960788150711184244557977122438213499312324010214457754446458843602061219775141733958095785763766576254035797932603592811871376635188876582824281388990718523287628600787844941607934957142240202676725275201472854704627180325659742359935665106502761187775131019612765796344545644576927532678831561435863297285514534966663471436994297542151683859811335547222984049271768390970157405961793086822761547366118225070430495638409662258751382078447303626883951809568910693694204861234239
math.1141 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000003347919041072083325815067918094866908017654637892354161916593072633354690380036682319626003038402417613627356440782261726208263131386397691712498379321688426036554149695888833617066429798447291144258239854258210445314417448185978311539689766084868112856329406418442806726041495378744383935473353363810223258162228611181395104236890750167687890871146460808771809958390555749338178459797122501923990774807311005698062488460260454175581327727207186961302536901564506022929773469668175988021911116899376484834899287824865253492501116508950486015947339804568202416227764940289447268542863551320561060046200296049386769172629450388983979800442943931002644106833597562115417078898624498763514436308176987144041295
math.1143 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000836979760268020831453766979523716727004413659473088540479148268158338672595009170579906500759600604403406839110195565431552065782846599422928124594830422106509138537423972208404266607449611822786064559404688026965600230334545494113589661562442195580809865551256284921530959145151831181797286388657453142422621528162488121460791759047677278054953348378310555049539831356310443897155499685710405307782895903533996495564705379422341181170266878102268641860364224986749436920802882293685218195321097146802849422551638812318473975050073750797679353646778017571726453603637988649141411843097009779339219611191303109587896762352440089946718753305099801052260764824990068396926458274600510926065110902381757801156
math.1145 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000209244940067005207863441744880929181751103414868272135119787067039584668148752292644976625189900151100851709777548891357888016445711649855732031148707605526627284634355993052101066651862402955696516139789074615002985793802802929032364608626268435401046442298886479477032678538655418360539701380532863350784331045486143449552390443801934359078432198904193919591645489770221005022085635989667381423879170364671987601124762096705912207549503270752011894385446219947553549027312096050397665605126488862233840108893436832507942623186232396528995868266124588082790237931021544400506402637952295740708122548044850458821795179157829638071174821034595458906737851683062298682767080825686159805918405137871569891252
math.1147 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000052311235016751301965860436220232295437775853717068033779946766759896167037188073161244156297475037775212927444387222839472004111427912463933007787176901381656821158588998263025266662965600738924129034940368943557589308030608127314087506960529096239799830120396331896663718384926905764033856432174160289382602279532149353408896778066040816387907431555751942805095143724230332796093481749506495203978452074806397177717975617801126493002549975357139015483741595311187282085509872304416809813343461338819916035868379256578561160013346819496205239517441296836512084724720120130997689058875411879034058477265958427572674977859874329816120893722149328957323557220805037449811978062532607025575633001816573542658
math.1149 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000013077808754187825491465109055058073859443963429267008444986691689974041759297018290311039074368759443803231861096805709868001027856978115983251946794225345414205289647249565756316665741400184731032258734325601423490978072086186834743693940572494881009759701840717643877657235149843238108345339936978344755263849678661059576757435307127673721232348749583612728012214751271011285596322227196078426711856356911123728170369193261155818498015392384437228268603074288408705059676970306050992923829833509514447043323476409529043194759252197799490128598483668471663186964532703810087359810680622037268097720155133062995565656506979965755837318794770712012420901886888160267005546077222056746227199690812313091963
math.1151 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000003269452188546956372866277263764518464860990857316752111246672922493510439824254572577759768592189860950807965274201427467000256964244528995812986698556336353551322411812391439079166435350046182758064683496218748549816858514230598266125396303148255925751277875916596492939602000584898093739805194626616456550771285845678363581941136850526166336475310218383826178588057426507131286245292864274577476036477919445588751516583917005666013873801609718166914750156232295637558895724847544745053808309984278873217981164094481553960544225075005509813816930606063549510709749880257083042870000032167295474463329306465743421660526639968292924296369183798981539714456865616222393760228967225069657512760314831934560
math.1153 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000817363047136739093216569315941129616215247714329188027811668230623377609956063643144439942148047465237701991318550356866750064241061132248953246674639084088387830602953097859769791608837511545689516170864590064101573363572189192853220450315789790167361303070727725292515488634937789919729781322032435254997116028814798865272438874220254623365050856790126436250549308939997822131326369131429197453971386001264813743311311612807274763793943036423076602245296107513486168329937212780098326413096472761131947506236242843607343395074008119815532603859289481668415157707923872984712901626876943472337311295466383913687075564483088877816849260996086248566652830604877089638259996582910553326369876699778769760
math.1155 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000204340761784184773304142328985282404053811928582297006952917057655844402489015910786109985537011866309425497829637589216687516060265283062238311668659771022096957650738274464942447902209377886422379042715095891243628801886784136356270568272281083784720712834542884230826715284822399190631870888660973384955881585798519635693326784111466220483588496197988423982581931366773911594338268753820902532423292849923292027333938009015566920939925775329585206056772211175586365023454859685514949865767168441808955391075312258978236673274045304807343595802745585516819646522127023834216353293739593790044386868445137463008777920685973815925424909124158542959625525970500297904052572659612137981669297632575387936
math.1157 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000051085190446046193326035582246320601013452982145574251738229264413961100622253977696527496384252966577356374457409397304171879015066320765559577917164942755524239412684568616235611975552344471605594760678657125612933362804333460549397137145107341639833554549398049158561994724104261098846792784182228298595259571849054344409466925534133506747822210999329674699067099568853133191833885701363069564621787741777863272335016356502418448911790525579631485638001716380777930479553309412357483818846530559272530262842725695691532149693035724950737122913558825639621499763768154607049205184083249469226525175968810452918071479456556630512158989401597954439607877668646212339850373673397230378890442948245877042
math.1159 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000012771297611511548331508895561580150253363245536393562934557316103490275155563494424131874096063241644339093614352349326042969753766580191389894479291235688881059853171142154058902993888086117901398690169651298381236247626931968077385894850392065487030986008545326523068867114681472085954900980714110958243958134673310745600826201328674149089947229081397400637722301378652289730387126191672243051703840455464041637847866493642267249289953096863359701601165487465441867479492431891959384731054857731834221264454281401705555547065133886310925974654828421791874804073792189899900341189881526586022834457556369818785785326650433948226648938443460900194977547997609158334203429959993620942388292751893033892
math.1161 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000003192824402877887082877223890395037563340811384098390733639329025872568788890873606032968524015810411084773403588087331510742438441645047847473619822808922220264963292785538514725748472021529475349672542411382037309384898493947901572763775277486380321368432269199878925924382409857667182414443475033726627116560525110704122257602548295289761708104640761100023114370799064568998690302732955415260024528679638179542993919944651317084599386382236423679363262328780714185430648676645860011084055435606172689651417639726236278584452500461519045733073742014859792126422056935827526194955176321860419064019022634407944052691408356196694554786603455544464572061646303185852867164520113695319197028984109951637
math.1163 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000798206100719471770719305972598759390835202846024597683409832256468142197222718401508242131003952602771193350897021832877685609610411261961868404955702230555066240823196384628681437118005382368837418135602685225105159890374704295640556506339312707142966766970951997304670829351296599650457966235036874664126587559809122444125628661087906050340503645806446982369838254443908969949724119763870389776380924244854972682748879402427147329433034691370794971944810420793135710295473793960734678410685864334751624056277500653408125285342238132527396222312665381032141849392101309450413182979830439287860536698378892235517375589056103670931712470470776145430712422075336570265862898021889742001817239006094099
math.1165 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000199551525179867942679826493149689847708800711506149420852458064117035549305679600377060532750988150692798337724255458219421402402602815490467101238925557638766560205799096157170359279501345592209354533900653496918269268788255776159846411309266078126033320509810446834299899976583281340931642155012379000181363270900219101427099167940208024797734520965448895252857781753634683048786514163801346556301135871009458725025893529420652333835778605384630161842173082462223002294934263291455782241537327422030624166229456224694941907103890881710892176399341502483266012694443882059763256202301860243171903822744052810909142234615783291564087026871590822651554760071808221721034611625369757558113938045669315
math.1167 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000049887881294966985669956623287422461927200177876537355213114516029258887326419900094265133187747037673199584431063864554855350600650703872616775309731389409691640051449774039292589819875336398052338633475161395412009461218683910956595745574476286347096288879349550320589663065119057160601482827225668120506420415608159052067407236725966618667501253520735534680705486402913318635507313742657469646262081647680023027952292470763140592884997145660625667823529615795998361515291884886825563380033837522957857162174528849858642137756863736916695336218629965069110318575560284430587394579149662519731981285522245047520972239485674394786456673576510076924765635577818584637766639553638463375057556618421686
math.1169 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000012471970323741746417489155821855615481800044469134338803278629007314721831604975023566283296936759418299896107765966138713837650162675968154193827432847352422910012862443509823147454968834099513084658368790128984384825751517640729886063365525712344061623192270380759260158885276790604080212072192258515733391725889051349318033191930482167163327271522340103267585245253297487688539409309413288078700687336839420639717634253325407177625233956035432609769901071672937924665111404902989338172442904868001588725362649779789906693377578641730238695041371781014655793322628657322835544010399038867118183792483504563637734551153182108935301247513507561427279887720206740307310600738512458723845236257797236
math.1171 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000003117992580935436604372288955463903870450011117283584700819657251828680457901243755891570824234189854574974026941491534678459412540668992038548456858211838105727503215610877455786863742208524878271164592197507816249813154195706070331196616037721503491800350560149987494233401207756130345590947535380349556324222804153013585195118288063932068215368785269277060422219649086346247608837304033987878502896663675533727440125294598418275140152685162972296143777214778776255497888672159777828353236692649686621168145419764572535527166707077819351147819694260392704063624206271368193870359042913757228063070770824603188225622236422556807589979555840712945821089535339530197160797659529311338083407294541259
math.1173 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000779498145233859151093072238865975967612502779320896175204914312957170114475310938972892706058547463643743506735372883669614853135167248009637114214552959526431875803902719363946715935552131219567791148049374239635076257028514949567208128971240755592549482361432474393468759178445530289235284604657945236078421404581606313597315161509693047874236741282250247680130153531865729313230461725633954372654400722512246478353248274896513152691784028469305978434095387677438973815461910297030419263283000766113687934278459259548564375960381847026223842263632165954136071768636198652703223848007819215273546793287114999332331921656043794425604466749196043487343108891858794623039844479178555497854552975433
math.1175 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000194874536308464787773268059716493991903125694830224043801228578239292528618827734743223176514636865910935876683843220917403713283791812002409278553638239881607968950975679840986678983888032804891947787012343258305727171865971896501180807238566897755870636670513116100579457447556548983735215342365914958685979318205774124765832744765613265393047468094444668314744154325640077188040555822017924425424232407190851883111446682371573624683335745235671320031738051530766707092960025707837368239389247285928264078037486208663583975972550952799444606228035849243185928714803182296652379928035988693298965992147968384216833395909292211000533853223419744078779920266364671632225921253766328525321493187486
math.1177 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000048718634077116196943317014929123497975781423707556010950307144559823132154706933685805794128659216477733969170960805229350928320947953000602319638409559970401992237743919960246669745972008201222986946753085781064982693811919991804115065698059136534271355398756612080946227434438600180536736523502748589634425270335929369676625292234535538950982787331820345393222254951594477311470572108616279099825402343884108401123392508897714163428515399609142751487730092204231947440714960574493971319609714260664505675774475584282120799785537757752458651058821252842313545237734245081863093093673253449988194369915531015349216160275313412685615017052682494684041330915846689630415915365507477695337171391576
math.1179 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000012179658519279049235829253732280874493945355926889002737576786139955783038676733421451448532164804119433492292740201307337732080236988250150579909602389992600498059435979990061667436493002050305746736688271441542751329102471888804230973523227829921934916208703412248658930533337368148978954429532494908515598588782258546695286001507870798360270243533867220733504826191453742977185545030190080288876301793093229152330258796279797107488598619654975119896735823595690624377033408533381191457828254248320504859733173048605243926096250120792556741020574015460240093569634166434771056472350612999292770068698086031920715361318598111061177910769857764994978041049265637366334042548585644234880661307858
math.1181 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000003044914629819762308957313433070218623486338981722250684394196534988945759669183355362862133041201029858373073185050326834433020059247062537644977400597498150124514858994997515416859123250512576436684172067859971966238458894848962524655280663962568080070980955215198656107486081866271005268640567213478363009899550928659371169242426882912214792510516901486998066799221257141530535880125066884411486640975606422953852632309403833953320268146445111911079324837387077348227793515142367664127043288096935958126113398765786633219857842853385633344102180877562606871070573581170611899412636451359370692611884043577519123989373810821400501344253760072947512757621002665420654627146557475449572935458591
math.1183 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000761228657454940577239328358267554655871584745430562671098549133747236439917295838840715533260300257464593268296262581708608255014811765634411244350149374537531128714748749378854214780812628144109171043016964947022493635087809658571931809038991207308500181769844037051957410714635927058042719384480008616764725149439278475830948612266862789778677588495891964669932821851004278513618952689971783203390709014145249520118352276595629611813512434413490586523700573569577791813179310202429741147565853563322380782318727196920343791398542369467642064456363154946705980024290165438520217975815110661032418851977586968400312773722885070472859877665205297909362647383093484565026756402887959753030222819
math.1185 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000190307164363735144309832089566888663967896186357640667774637283436809109979323959710178883315075064366148317074065645427152063753702941408602811087537343634382782178687187344713553695203157036027292760754241231647949411034629905525290506578970086859178649501465480083870523700233355020813519761972962045970320205327276689295363598127397334786952725931808571474012599490697365536402857395145047669081677951316674259570832949753378622366873970041009377965448748821917546828608194596197554180508297750447190739492589427763449744342980048120338427177054558768666844637524294139532037350638692860796624192889248264420255213818870556515518910111367212600039006832565460403690541268125456808010806183
math.1187 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000047576791090933786077458022391722165991974046589410166943659320859202277494830989927544720828768766091537079268516411356788015938425735352150702771884335908595695544671796836178388423800789259006823190188560307344468019676732753146023466013544997829467285048589089001065538816344380228125917708921347166134706597772647735694688282316369515623658551350489429622044829276576692091186159203946344322646249712356734786639728008893029650061099886349178771343241346295325475158655136436981466940249401851760228635359447268736522729555264667171449862491180118758110604472080228650169490368575468670671003085487950927728268032328227455078173586862137118233139215470407651085504921628125719557430609583
math.1189 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011894197772733446519364505597930541497993511647352541735914830214800569373707747481886180207192191522884269817129102839197003984606433838037675692971083977148923886167949209044597105950197314751705797547140076773059301243413774593694848655475413470108223781394241025832818914228988554022872512611237530938357376825476218742655113110705732453350234489570944825872405868238704076748887038183460790843241281668411430438642067541053618364726631202124720196660721100335737625859619298481693415772064877614681179112719674543701964244463728192611852321876065151862741309207346786251414603656473611128199868139132686247361007377279083841265738175646477284554783806286189449070078002888075539543032127
math.1191 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000002973549443183361629841126399482635374498377911838135433978707553700142343426936870471545051798047880721067454282275709799250996151608459509418923242770994287230971541987302261149276487549328687926449386785019186258413791323508793666932402989871591164989558598223453743364085239790860393650693195131687112887202804403975221106338558966805729719291583720357031158992330417043558365855343398377595968908522604277351517443377034501044534007422359779959612841433428367011715169003779668123747443924788441720550225242586510442342413896581052345308496527476312207485338696149929303816040424889250684113762666865942037307549053415418141449508777660815374559463545622515399462493784457357830834451998
math.1193 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000743387360795840407460281599870658843624594477959533858494676888425035585856734217617886262949511970180266863570568927449812749037902114877354730810692748571807742885496825565287319121887332171981612346696254795786113278994217770110424238427581033751017791121740663134192060941341461974849624970152066709143784989771540531436869115440631723138904336077602682768297200901758510601974199454566171535774187603153606031554326469827655527399025411933805609676024636991562400190907451794196866572602112741173992105098035138532961962078439893469051997935152540438297332595026862857547172542033599295205218280020745497720436864917558531759401631758073786426618454699955592462606432520085255279988708
math.1195 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000185846840198960101865070399967664710906148619489883464623669222106258896464183554404471565737377992545066715892642231862453187259475528719338682702673187142951935721374206391321829780471833042995403086674063698860029412100036728271349519349130051322173381277344587972253686305490226257760956428245699447388388946184056991321471109493372407530179577369124384579385668934329023387188865879417806184850340106447652965507013528087623742298391637639504271154877019277141707521770679955602524130345186541630757858479293848114639416626087107243498428331255639783298411488399067860702528065662090727909878606737429116211902417739172035140255286778777800914316381212871050329017510556157561598757757
math.1197 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000046461710049740025466267599991916177726537154872470866155917305526564724116045888601117891434344498136266678973160557965613296814868882179834670675668296785737983930343551597830457445117958260748850771668515924705396363286284991594919986475308600928812115707881638347364051695278652204890078016584500725191813091961700009881729314110366932632039726936694842132375827646254042460733831308669971059956493173760503646156387517817498658611533411454407359538240818852837289487751272458237685856356450819719970114334593727624658134044979230543063814446590798278884135193913603958630048225857980686473916610049672181292894455903171716664687529200218180321245130905151408777720933920041932460000452
math.1199 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011615427512435006366566899997979044431634288718117716538979326381641181029011472150279472858586124534066669743290139491403324203717220544958667668917074196434495982585887899457614361279489565187212692917128981175281203072824115623961397356385604465344003414586575292874416270364784789050279382982022499447366145814390087142805832609483269907953802022441904531711483936618408320820402653241185296535587949503011388357655361983951805038124688047332599780408595274386721383803590602182948051542206195360554940408428006789546507757773757595939413026696126057727423364148876663517997266654325604348333003008154645528181735759616319618041627355937914756459574829962469725984203803666517139103299
math.1201 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000002903856878108751591641724999494761107908572179529429134744831595410295257252868037569868214646531133516667435822534872850831050929305136239666917229268549108623995646471974864403590319872391296803173229282245293701646573900791986571616087714007142240553574492884457222315550540654168132320943393938660211776300100704753415965180828136543782537769426529164354996681853694189969281399314789649058681936628031471920114999451103236810888656851717032717345426372429679201961849062299579818266232805949751756991224251936383220577808127985778607121409682604585903428351662093136935969873107087471882596647452762414721261475746934509140207764824242181689641407856164493160903386299237209462979449
math.1203 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000725964219527187897910431249873690276977143044882357283686207898852573814313217009392467053661632783379166858955633718212707762732326284059916729307317137277155998911617993716100897579968097824200793307320561323412227844107949450040822549552680232882866473717247851417102385740658872129719246698310557869603493208188102979576153282119216646251033347845478668979050635044622488995839561064843694060446145621271392173340708488667844043989911939301640621858379216557895222306629073004779346912410963538999969755064441399925479948026559256222069365274803439779851342001306100080240943908584115150945708351188901615410650302885389974975938166931482038182791180682795007935333855208026018316469
math.1205 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000181491054881796974477607812468422569244285761220589320921551974713143453578304252348116763415408195844791714738908429553176940683081571014979182326829284319288999727904498429025224394992024456050198326830140330851592094430626412887752140457523219034353071773092711422222651780219754709834146213447183113696364211270571814403466995539257572742379558207279398381416779740234004386535894833616708238729661923924557977982298873654580270834400176116291855028625561898986629744788676607410036731568702153240365990016014102053653994571117712132354092054662772851962653674324792383088876131691786535614468973527529902220419138054457093713560024966356529156256905276899556509463039411481520346076
math.1207 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000045372763720449243619401953117105642311071440305147330230387993678285863394576063087029190853852048961197928684727107388294235170770392753744795581707321079822249931976124607256306098748006114012549581707535082712735260652505386597220979899864489293436762759248816585327557983394387197170129279902856183568034487175814739101914379441420327761108358579143153054982478635446588296383351359916074203435826240368391829367708038374282846695387236891771444337704882383425309327578569921150378915753871319234446891832683540742136714722234958428142767132070045832922530080286864979359963071045134242191573514147976030482919135902548809684960641015317678276305482316625519099481791493450894031147
math.1209 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011343190930112310904850488279276410577767860076286832557596998419571465848644015771757297713463012240299482171181776847073558792692598188436198895426830269955562482994031151814076524687001528503137395426883770678165730390331767024336683284464309493897912336031719560750988944552979968149375956258054090908002336722639438720039442699977963559778586203377266425926543072268756781430271428315071633291020056384282668711067365479184081221296514988752446604910120178894198672980778666923463230258344348755103762576298996688699258759134287046348237672770012517308857189026584934054954550781953411397366557329219689604788084252640988162185242834725569987604398026946537394978929249268671654913
math.1211 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000002835797732528077726212622069819102644441965019071708139399249604892866462161003942939324428365753060074870542795444211768389698173149547109049723856707567488890620748507787953519131171750382125784348856720942669539423178383544019976552855504764836867669378032320491789869397105398677465882170873662416617666552506069387896072177101619255514333701724021147513390627446086561802882647454696055616080034018595496816131630560655766134608792569381094647466724398084079578360160278027123728193918854480325477324616618199376777611852010321028019135066535674683866536868233037607177613847045348372659684033787727004048606408255614793895361553743590770553403751268092019824828227505408528888579
math.1213 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000708949433132019431553155517454775661110491254767927034849812401223216615540250985734831107091438265018717635698861052942097424543287386777262430964176891872222655187126946988379782792937595531446087214180235667384632525795952923204402884363823149593938599399679078681036478272700078858530340697209925697823967940451738998024968322807565503515542672469379201337544837473565488781721282785792651322091224205773294397334394512994585652470790331953202212979278697414775464740006644441936387305630360124625752734240157524030519693531204797092476300857995955718511908806816957008392253720016741231891232746517787790438128091482715285226558536677707620061760688122816456899877983083109162894
math.1215 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000177237358283004857888288879363693915277622813691981758712453100305804153885062746433707776772859566254679408924715263235524356135821846694315607741044222968055663796781736747094945698234398882861521803545058916846133323804551221713352351145137114107042567060097431418433467234436176324861451616390739373723473075550089418840344752635530445315787583835577280666595985207132714862106750419900808488819951776603400753200300985473342147168723687384703142425080864426721596570997113062791065087723265018760774582470258244081796308867176298007881386961973809848046321944697589242536559542019610761669518238617375666092727732915428991791587879102321479480658068860001924352307844147675480433
math.1217 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000044309339570751214472072219840923478819405703422995439678113275076451038471265686608426944193214891563669852231178815808881089033955461673578901935261055742013915949195434186773736424558599720715380450886264729211530574546200359974143824458971092605489299232821875826627738771526950371240792508774157948905032834491650651302764262818175841266380442149809040203561193663009626830845099577020600692728223524512675455537858611518087907285257342840832204934105983991616596260457258551438517393600312214812864477764848275441790996959371844832270254149089964851791898566982841687192928543278898414663068940712429617798670808433051363602011288633590599360870325491089280633114538400773943627
math.1219 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011077334892687803618018054960230869704851425855748859919528318769112759617816421652106736048303722890917463057794703952220272258488865418394725483815263935503478987298858546693434106139649930178845112721566182302882337369334818276403260189485752493453286749071859842436864910983727180590801416602036498945609827023371362447099740666687652531865504558665006721658320347640739070324357321877944052381942990738485214766949942959515820767674644185694217164190614102420657381480315021131933109045626771480264305984499802448264341944940787593442620688400561842551314935840317027705391154007461053979844359937159420516058875286984958377909270426557817802846623381321118795105102797985194496
math.1221 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000002769333723171950904504513740057717426212856463937214979882079692278189904454105413026684012075930722729365764448675988055068064622216354598681370953815983875869746824714636673358526534912482544711278180391545575720550312643118822752737722342880272483428569586452836806986251979486193789989608529231014927441525467004918347487010162465656712440864364245445754944360301743392135289482724348128015939054790461677439141906575231893494970848739455399232964233536752882779003643981736505669667293147759801182979341495589576243316094172895529630984586137678103858487380310446926677765663014507231372965407817587208038393722265880788498011908821441486344257656192478337492455831383981450341
math.1223 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000692333430792987726126128435014429356553214115984303744970519923069547476113526353256671003018982680682341441112168997013767016155554088649670342738453995968967436706178659168339631633728120636177819545097886393930133797084047956093953616693658084689757907098667417668165454576377592741085097063276852641975833445769238224173094206815719020274048116014605224794954543761833115975820350665804616428439662614142186420002629552559274093593376889883876302856876983897249321331006365704853915996564978989545511444560819171417163085207606298660087915769713811671927345749698079480563966656294590166312768021602644607852000531035660487732050269710828989023013952094370756272124316670668282
math.1225 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000173083357698246931531532108753607339138303528996075936242629980767386869028381588314167750754745670170585360278042249253441754038888522162417585684613498992241859176544664792084907908432030159044454886274471598482533029151375127957462758185407634124539561741561766468865684930928403106781018147038001928284564147999866071298978181281630293086715587331789504649723576866266749036509590066386385414389985668750925288424133458435880808072647849150663678990444500589841841459323607455645604588949385689720898296345621079567061870115269067142774591995537479078395263657816360032665854702055538172127096566210437910450686667802512403641969335533548710796899755836732848186208850363024100
math.1227 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000043270839424561732882883027188401834784575882249018984060657495191846717257095397078541937688686417542646340069510562313360438509722130540604396421153374748060464794136166198021226977108007539761113721568617899620633210607884130759807284436573365525812677653934320734085790264602545767974114968006032567381208346617472797297600615273485410829257069980518287101429220986144650237671931477843875313585869926782603825238400836920190040670775841738765204609466254103791593751944023177504225038884651838992412014936124623941343662671094538878483925885027054346046957343683916498215605343732799716529580905538919406715723884900875562863224457550915216681500430292526072317647748725717685
math.1229 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010817709856140433220720756797100458696143970562254746015164373797961679314273849269635484422171604385661585017377640578340109627430532635151099105288343687015116198534041549505306744277001884940278430392154474905158297465308849220000887208056836603084034659988455640951377458580685885468957678806678373546420676611868897043606383813157779102600731178193006324134897109825333423453113748844626763760559618672431747246306533795911632956867872654120381140353736923814209712647505911114865090932176531208893527862461792292514640997053420839543324474318865646782643474457154377479642819784294470565507791599033929148417444152202189198469135312654558463933713284975843257684831261238020
math.1231 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000002704427464035108305180189199275114674035992640563686503791093449490419828568462317408871105542901096415396254344410144585027406857633158787774776322085921753779049633510387376326686069250471235069607598038618726289573790031414141672340257449041953174438136830988961063392130470732520642287079346688508020062790259356190674146732619376825486237567648221966530897901151155300776851707173484380089718708862409945765077446707350612514010583175983215009971462213439219709709268990238923698195568797551293215899034360616935477077227017705047124309031941030656608530768140182840247678199587331513979199187789001487767979061216929742383250017855218035245889305350425560568600587971126028
math.1233 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000676106866008777076295047299818778668508998160140921625947773362372604957142115579352217776385725274103849063586102536146256851714408289696943694080521480438444762408377596844081671517312617808767401899509654681572393383474987072826098226077241910782879475522622245913131117709412135635577065352785339742066544354437821714452809451076137561624656895797015516042717162644276684912062817867254237944261464259216753184014770747201746707472052907419681570444423545977063682546527725785686626945474667174163948886449382676601651135802032648151372436626337729680160438489999526429632125134274969284776859059916605627094674067004922707237127584279331496617063566727095706586571811696393
math.1235 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000169026716502194269073761824954694667127249540035230406486943340593151239285528894838054444096431318525962265896525634036564212928602072424235923520130370109611190602094399211020417879328154452191850474877413670393098338753983827918526018932086191305638751248975006550203122215322923406117076951097803017411174620787096989270549729017026744857860333253867643823817276756120003495307175828832705243607291472279326973784645977335720352904751178040429505479841827091746817161804781378533254156477564701241677436894267576275679312555833607975830731298247476921618094674194589314577013813952400098752293088294190097032705749998176285077119115678688563499200505784628033239256061230743
math.1237 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000042256679125548567268440456238673666781812385008807601621735835148287809821382223709513611024107829631490566474131408509141053232150518106058980880032592527402797650523599802755104469832038613047962618719353417598274583897966741392076111667774404894178452519834801089986374196938496351220692639207947207896631269883178865168453806281811392264653539902868440379636317644035690568154229787446505674957127635640305042264708288457773655560161335260258756537596070167137302609201480638022395882518205603635370633175672919986991852034199873784245516271296922616578121746751823343728999647553151747043748038774232018416569901510281374498530665394559287303877683118845037085178883369073
math.1239 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010564169781387141817110114059668416695453096252201900405433958787071952455345555927378402756026957407872641618532852127285263308037629526514745220008148131850699412630899950688776117458009653261990654679838354399568645886655105838290650909693918675518920319691039100544992842913264698881997982183486407923473107991506340497759715351292259849517657930095057808651523683787335212114213171819536754460397837950261634126473714910004563246377837756511046018580645279683867745658594342857095228718862145172096267469732859723821974612500531195006450732295670624815815274468083832212648042986700152526588485701798223828011548906274488864468281855113584003844936088301839295673151483279
math.1241 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000002641042445346785454277528514917104173863274063050475101358489696767988113836388981844600689006739351968160404633213031821315827009407381628686305002037032962674853157724987672194029364502413315497663669959588599892161461904156514047287504395737163543541989893019644919403687803720687062368920254927113753014420389066765591733958146805221827196555921899091975912041395699990918011636329716755223538520247393358193532930020920314926690583793173752813879207002153624355505964685525230928835713284463745772720193510456839661488169036586857185600477458208687492597185671036051412205853980511167463135778628228534709964188002223415293946401064985393403699482613167565589051550066894
math.1243 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000660260611336696363569382128729276043465818515762618775339622424191997028459097245461150172251684837992040101158303257955328956752351845407171576250509258240668713289431246918048507341125603328874415917489897149973040364391636912342335740206962901404086820803283785650201530514864006470244388364737946412936509918510044783188381682143767330667710251516476052172361512786459641339724500443694816560771754685871730685124818855250839294995919400550564250911919934966402571945287348700543871812001055499311509276965051311959616827379597132429392026060297410182475992377129674795876339907895687529745074762608925930028735922176378977769955368941256148886729490913068504067590848282
math.1245 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000165065152834174090892345532182319010866454628940654693834905606047999257114774311365287543062921209498010025289575814488832239188087961351792894062627314560167178322357811729512126835281400832218603979372474287493260090977420092955641031063743904297488518904157488014811561358041983251411336902407394155976672459765661571936527881140659818652324370772641575064684951958999567841440169649818004362277115984193708869517289772399438328469535016409751945736260498188159350047452824989744555061044913290236645685812288290702070463946567125154991467124597957175094371893681144355180344957758676747654293274279940176728833867818609904141976054930441935560204348079280912683349630356
math.1247 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000041266288208543522723086383045579752716613657235163673458726401511999814278693577841321885765730302374502506322393953622208059797021990337948223515656828640041794580589452932378031708820350208054650994843118571873315022730967341557805490656158551512868442359743432181731910198324493772169527537959949378187784223845654323666291132574578064217014071347996233990792857296681520611928866686467358693874575801469345430254390587818582533476160893336399175976404315273454101269322641858355604145937869253047682273061356508128892506811939421201642926133460789592631612701426703318196269280500479697326435285209471436518563212533590834014956247678046371645575160990172402788654391162
math.1249 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010316572052135880680771595761394938179153414308790918364681600377999953569673394460330471441432575593625626580598488405552014949255497584487055878914207160010448645147363233094507927205087552013662748710779642968328755681254315202661954096286590704716700882569642509658424200560456549633125585863109660012903401395217906547923801175801528226912737687536374078211727580496116672306602521001750366944673414414538990366657498061460531141601843574217286046533018080264899531742847287216526365712740742244726803206118820040579021973732339580623820288406018213896062946697333948588448330111034767362318984426478845374705488679439286558924656715543906298231242306617731393288156127
math.1251 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000002579143013033970170192898940348734544788353577197729591170400094499988392418348615082617860358143898406406645149622101388003737313874396121763969728551790002612161286840808273626981801271888003415687177694910742082188920148298779911108683210197990234685253157275567884100122471151149251697363285013227832776666508116068373797730075301161187023653294166017472943322256937999892601239671643561964886136685518628828197229847660862698708700900940561100065580888484101781074622137064545598034831172649388615234261423146013886173598722418577902276112551601719304354417663234586515844333807456676183688413814677417417974462313486826769430702865478076789133678904037318794702432657
math.1253 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000644785753258492542548224735087183636197088394299432397792600023624997098104587153770654465089535974601601661287405525347000934328468599030440992432137947500653040321710202068406745450317972000853921794423727685520547230018710248227290521817943976898172428013192774245413260876791899739970559356723952828144257311396971730873519161197599089010965420461718140834762826658274498107187280309801592855375691059015883315530218703622787526549873713855913709424797883796192008778787351177434479234504364892888418658474496480391746358084888263346169445278565702058166514649541551265624203945156618578902082281295930544396973086997945875075907507626869571285291630331727468109914125
math.1255 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000161196438314623135637056183771795909049272098574858099448150005906249274526146788442663616272383993650400415321851381336750233582117149757610248108034486875163260080427550517101686362579493000213480448605931921380136807502637067973435225011752047484487675305950847147396451914642876315775553009788837748141629959445682336876611639451878526947747143662119954386349846933876905078167271595364656322844406515232948787563134165938198654630980733470118627160308916124277948801605878650500340779214928721911283754494845124284859107582103983351650349517893524645288611632284334154238469904439962788263542965104103168852360948695984368219019680844627784121798615336676650113747756
math.1257 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000040299109578655783909264045942948977262318024643714524862037501476562318631536697110665904068095998412600103830462845334187558395529287439402562027008621718790815020106887629275421590644873250053370112151482980345034201875432545428537983425967573344449093082338006629742794833710152565697545271403637163824914782261024962458956448657689493369715206865162257394105143985614590775287539604042173463288675059937513396201837225251254048904017121884459283887807509354750056124356142831809168901317688672986899202212259029509402189832718592312449904909438019435147395428391790650039813691296948188753343783327703787976449643290811776384160601838505278404677742902531550530649159
math.1259 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010074777394663945977316011485737244315579506160928631215509375369140579657884174277666476017023999603150025957615711333546889598882321859850640506752155429697703755026721907318855397661218312513342528037870745086258550468832945072154404431272955722037514854567867751090552247877475195508125986623845705043951728054101171530272838697169024634959737377360816437139361802197577083351555672622425146762716348510440342273346546619307316796582656567761352066668179858942960395616520349434655917636783798899712811747203890243056157903752229864788697946184745733305276707060561372641429273953271034261595416254938235706115242647403085527043512929340929683684980175012686403785371
math.1261 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000002518694348665986494329002871434311078894876540232157803877343842285144914471043569416619004255999900787506489403927833386722399720580464962660126688038857424425938756680476829713849415304578128335632009467686271564637617205437236374146505016134751167738889640118725956510677463806249330780348741843250048512713401174729650960845955708550746798927195570232119130737762304275314119111470829884308502735449329153652452094465292991000928438632641240571699098831650032306697440466496163351539139543757181979049192007035548543252338117659546125579101400805993866362474980449658120059412287492777903871535466560326353821179791469539218606954194906968063126980928786152338246622
math.1263 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000629673587166496623582250717858577769723719135058039450969335960571286228617760892354154751063999975196876622350981958346680599930145116240665031672009714356106484689170119207428462353826144532083908002366921567891159404301048305575263892609355445642863630854268769065113515532000167938667181861669904044075376282254730942561615520195614863150731004584783364210006364104388944449922958299450721322634289217792074077405966848578378625594004246323054806483585444536956664630123051670246393819270200099475811874150384871234457968327936416144080714353508453078589826064490993643602995791401207811887321788792449841519916800818299315643434907094113857769900692760122088634115
math.1265 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000157418396791624155895562679464644442430929783764509862742333990142821557154440223088538687765999993799219155587745489586670149982536279060166257918002428589026621172292529801857115588456536133020977000591730391972789851075227520447341224969596834505263564207371535330276806234783220385330361540551819514568532729670465905620559883523178957615571551778665322655537360307021693436941883409065548963378741123448351555641775979471688671036109975823975947178466858463582451978460098208745800997381846640441695419229854374822115292909110641275578922496609699643020693562733658216593985867985670085047295214536713314867852794992639577890361375061230470419736196902991438636868
math.1267 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000039354599197906038973890669866161110607732445941127465685583497535705389288610055772134671941499998449804788896936372396667537495634069765041564479500607147256655293073132450464278897114134033255244250147932597993197462768803040562227000888761205636821186217821144173013471264449491585295208837930659712369876366762814606402935082377936432940324976903829606397554981107969251950842300749926748849324225514122536951013740912630746625901082193748128669136494387540928266850540211737257259655801872455841934219260275062185036902257364836079037725549185794563828535118764017331886939286276104311847527467906025233035719100850331438615143214712052570907960594205006181798746
math.1269 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000009838649799476509743472667466540277651933111485281866421395874383926347322152513943033667985374999612451197224234093099166884373908517441260391119875151786814163823268283112616069724278533508313811062536983149498299365692200333523933605182897189965928107128452870525524953338973893617319648704237409909617773889951281221600488782983055407516907031888086654458685483169349405053444669656976868959409308718895293220505463968968405527578838316357588797929883119981040907411087833103311440140470231817277948942955554248155749591568946551471755184676447098335167342814102897839891120606218703508154257510693249138983195805201610298904833037644864106527492266583164786182658
math.1271 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000002459662449869127435868166866635069412983277871320466605348968595981586830538128485758416996343749903112799306058523274791721093477129360315097779968787946703540955817070778154017431069633377078452765634245787374574841423050035979136385180247285108895672401446282573855858948394753484440561786587657475351699561183440035400094974900049551799429623267813802821259897224821472603998289163131156004216749181639490148922875864481720460501981381160381790342207657804080979377809418810826869210510180744508411710102245512277753005755254492338721335968282167283393879008554981926011607586096829480488766364221068267187280024425210278171646445162382328847702459848240349696335
math.1273 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000614915612467281858967041716658767353245819467830116651337242148995396707634532121439604249085937475778199826514630818697930273369282340078774444992196986675885238954267694538504357767408344269613191408561446843643710355762503727912205615564375456936545391398577859294478138615497268900212625594503813054286677928706645516687385853266354607657724183152577283824810576481381633292585827259721552179411585045476788009612841573067324112149701427970851341438459049108508541865436183303787470393488283706308805787464164756008860390330442568344814113189856507219729255354019070062798410621349574659461660259061249323714910385474416697220468568618567061420983924760222042217
math.1275 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000153728903116820464741760429164691838311454866957529162834310537248849176908633030359901062271484368944549956628657704674482568342320585019693611248049246668971309738566923634626089441852086067403297852140361710910927588940625346770063550613599884202206046853756377693676579266853083646172287392802558176500756996937398786578917810900362725003355308699158385235073340817680239689036850308238547862673627087580581902929856324352325097892196894325355217563967103550639912621147771381000652450843978213321802017248230336958189613296540309266996299539515240286489703215030992462238056377071936038988459379778276249271192343968413313622363292934944740453143875463083422055
math.1277 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000038432225779205116185440107291172959577863716739382290708577634312212294227158257589975265567871092236137489157164426168620642085580146254923402812012311667242827434641730908656522360463021516850824463035090427727731897235156271669406126178122862158114811602784862520092149773710911625000753069775817867783976750874431630801070713567732244927385967498235603450865079281901707851802589666335827551226003862309592501664910420147110043637736253410787802996701942094254115179291364083300680151223873612979125059837646770541888948566131964636079123448307133585054842630095038399429534272517680249271370290667629092943382687299698921245389519023885885895460818839840865387
math.1279 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000009608056444801279046360026822793239894465929184845572677144408578053073556789564397493816391967773059034372289291106542155160521395036563730850703003077916810706858660432727164130590115755379212706115758772606931932974308789060692561558047277703440369069555067967640764482438649687985523263958730085391796970576789728122606527818485559901640351729688275123878504796940195610066233244873101988865730939829703438338942508942157542963404311870355499607575136609231142283297915353558298844628850066106053616426887737085289714606990676308512683572224380433339075632483591075869171000052875095477324862098004179259398966639615101288948070995326212638843339206668225339096
math.1281 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000002402014111200319761590006705698309973616482296211393169286102144513268389197391099373454097991943264758593072322776635538790130348759140932712675750769479202676714665108181791032647528938844803176528939693151732983243577197264370385948012124646737963419239252742133606836720242639782966713288714313672932684465205334276752327525742904068788810736623592805749158257803906700639145266491356570889089355613764307906348297979212719821012239482486379189546862749019472200863043480002066317738723555162003488860143318981540192896099781659446554711361840147708055659352093721167808085713657294459480745604226939848112862852647626264530326337193463755155943916926498931305
math.1283 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000600503527800079940397501676424577493404120574052848292321525536128317097299347774843363524497985816189648268080694158884697532587189785233178168937692369800669178666277045447758161882234711200794132234923287933245810894299316003401549058620630670920982793200491113781233192347350810917889133182110898786886874191100485421492500449227583128171884622734204190570904291960874951184867208745453901706304719721182308717563989627572917416491537742669828876305991380455459913406866721175027281533193430670617240546983679193673481513711916756770149162006198344911233733110279936122710969963820353568564709525644056834279628582512451251493840097758177062325361870120998895
math.1285 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000150125881950019985099375419106144373351030143513212073080381384032079274324836943710840881124496454047412067020173539721174383146797446308294542234423092450167294666569261361939540470558677800198533058730821983311452723574828990939838604165098666222482140898712287376366521674247798860162373407031333647134580535527000936863193891584847552150660096443106909118430499766240936840500200620923932462635379587685750663068543427285520839710593901843648188428435389752744231147447766432434525867996811617331677389228271181918051812068244233301030157819341200572673041774252506978124156078283598938414353701309240383256234340751021977676389647662453626211406198083072932
math.1287 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000037531470487504996274843854776536093337757535878303018270095346008019818581209235927710220281124113511853016755043384930293595786699361577073635558605773112541823666642315340484885117639669450049633264682705495827863180893707246633787577653490333054757917735632461725320321928274182618450603364147123295162852021409736854381361670593762084716297128639616267443574783472229367437267649981326123716127693335495389089110532771303424133373905902775701927275220892510301138496912500169278734177173902269417566262591127860395556395345714199014491224787007166784729841113230440671910803095020707586079890438183470157284538236922860246886667474938922869165907199417924189
math.1289 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000009382867621876249068710963694134023334439383969575754567523836502004954645302308981927555070281028377963254188760846232573398946674840394268408889651443278135455916660578835121221279409917362512408316170676373956965795223426811536094441814729879541371410824014158751466601760925460421658207509080035255277291548411099393613736328503723876365588960440886237990223380149242801106777201364899711887196242856838837634082545532004042190291870407754297398727491775781491935769752658916559786754499510499142161049186803785808355374657952859442436009523445332292853278057537301253242536172700725076844971426312641115249619793752617211488255457160250632237389391530743859
math.1291 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000002345716905469062267177740923533505833609845992393938641880959125501238661325577245481888767570257094490813547190211558143349736668710098567102222412860819533863979165144708780305319852479340628102079042669093489241448805856702870428893498277725027307511749348655612326263915659911190641835951497037083984498280775959868405478072220962453001009982141441800734148032179664640193078776882288187578421554739456590017005215629979987005908131427453813988866241359023677158928049711870076283338242767721518940194054975148747443586837810382127371269591677036129076276305284588999740388663065171454945237902625587807420784810126701116508351747007615597692494229237650924
math.1293 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000586429226367265566794435230883376458402461498098484660470239781375309665331394311370472191892564273622703386797552889535837434167177524641775555603215204883465994791286177195076329963119835157025519760667273372310362201464175716096699268413348494822951164375510116910411920629260696019046107232817967681144058379899413768263294732466333684653911316607143654269473282955486705645747169579083764101208345337807399045120357740109427181412729820541129596425088535806010034059401194249406341715144829591868581919423184574241598695990702277506361010173361945259800871851837676193046970439508100309828517763338410400999072504143087727355468658289294534322710924019268
math.1295 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000146607306591816391698608807720844114600615374524621165117559945343827416332848577842618047973141068405675846699388222383959358541794381160443888900803801220866498697821544298769082490779958789256379940166818343077590550366043928856338805308216816816412594098138219653030307014457718266826762292488791551954846615631458627276243313919441247208079582623640743648753347187685749453220453395553316933447902213581132826285867276338748700036050499662721081830232581304723567997925184168754717576310043394980606614464898448237479936443014467644913830490372021840893476017769820313856327109362735027085293300454985591147517895001471315686127550371232599351784295146078
math.1297 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000036651826647954097924652201930211028650153843631155291279389986335956854083212144460654511993285267101418961674847055595989839635448595290110972225200950305216624674455386074692270622694989697314094985041704585769397637591510982195436255572040836771955904413896853849416168626630267818047272293598231180396359656203043010731329676346844514695864534930560722587897784180123001034614409015641957901471876501343701135955689012054632466069372542666363150236962745353568434951077816274339671036672253909253505785279753502399090641240443184342318990411309063300716905798474383119234776184655611342416351366432754487042047789211372945072338783943988866952277796946409
math.1299 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000009162956661988524481163050482552757162538460907788822819847496583989213520803036115163627998321316775354740418711763898997459908862148822527743056300237576304156168613846518673067655673747424328523746260426146442349409397877745546787014364675390589417060091181135566371663475881548982438549375674672605366606358750225014228640068849709373439948871429823573610942162420942035111021301772438672397552703207416350042111142926506277841321691259966866018890915370736527299809344718792177776501649624175339038891854515597495542625364833695859678632166556480996299531640563241064900606429198377572396626011858255157771106340669763661133400674964118601468538285606635
math.1301 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000002290739165497131120290762620638189290634615226947205704961874145997303380200759028790906999580329193838685104677940974749364977215537205631935764075059394076039042153461629668266913918436856082130936565106536610587352349469436386466525865798312246957385465873830792039318237773051915379274155282569796926931194654163393728916422741649370556207522046031825954287509091447873761351736500723910768738928934521186128747725277767857986921036309365023434608232054558617882131765242877611600215130769060432906993843496271992090698155942526868529613366088841112989544329637934217187023964712719505116056118163444662976189480305018066259474543979437728404066553586103
math.1303 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000572684791374282780072690655159547322658653806736801426240468536499325845050189757197726749895082298459671276169485243687341244303884301407983941018764848519009760538365407417066728479609214020532734141276634152646838087367359096591050608075074128361915304588296242503874267088003497708111517861075965407874976993163864006868706299770345660854136532460837883188762660218897882959757576027004663098510665814998203696488735970017228952210391473425289317376802615099027744150694849719469800313786117309115771561305367258842368861186762192577459438495568790368178557087285771540049023985481099025406786101070908254025138134009344961961231192883869667689995739513
math.1305 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000143171197843570695018172663789886830664663451684200356560117134124831461262547439299431687473770574614917819042371310921835311075971075351995985254691212129752440134591351854266682119902303505133183535319158538161709521841839774144920334421601428381875374827056121125306867621416487634060432691983826482651208507137967732232687754315697862080451468776640736865733485872161075475697555211865274132222858620072072934670766402643402925262107305376661473423829212883283832571045518529500002672606135496890597797485474515420554106432992517647378542099935494202121485728298763106426321757812735708552692971130870077259854887086136411317835541147614104643463727246
math.1307 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000035792799460892673754543165947471707666165862921050089140029283531207865315636859824857921868442643653729454760592827730458827768992768837998996313672803032438110033647837963566670529975575876283295883829789634540427380460459943535914270539048456683401793560095370336808750333066967820407614087075382746294187044434158792004339847398159070727548126712096991557382573781088780506230851159090108380459196404833027808349338432087410869914738088797908756805067893514353008157517706175251695587060535971718499099222389588972688809938385294322726488941611398648037074935029710870791201908230216273510347702243037165318024859037029202760931733570216861009048718708
math.1309 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000008948199865223168438635791486867926916541465730262522285007320882801966328909214956214480467110660913432363690148206932614706942248192209499749078418200758109527508411959490891667632493893969070823970957447408635106845115114985883943477294056347458398553929282880368144635741901502611978848623333226367199256196402947126772881396162788057149379838291128337593895554813388696419591764162675170413361270292729456378174088693962997910379870439729499727862017919199628351718792873470703790704949616258678128846605016781286427137941891187974226765916113338684675825718653635122864623714342197415459960562669658846773576566130293598210094944394933170339703294669
math.1311 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000002237049966305792109658947871716981729135366432565630571251830220700491582227303739053620116777665228358090922537051733153676735562048052374937269604550189527381877102989872722916908123473492267705992739361852158776711278778746470981970396769001674327205764460613179140875397545904614869928278229348889647115097466782051556753286186613490894844160307571427698979434410915674248568391193213530749928916865114412539526072210415069405955595642403186182507654917683465910443382800635935635004610341943462704101548021303939411088121942017672055340507392510532325990872078383727962119834639572014292750585225634411373974867558861166575529015386173558412918538765
math.1313 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000559262491576448027414736967929245432283841608141407642812957555175122895556825934763405029194416307089522730634262933288419183890512013093734317401137547381845469275747468180729227030868373066926498184840463039694177819694686617745059385109463175218197805797363637796854011838757149481394972045786366617034446407367209540691981229532981235655395714091672847023252570236529689216592259697242481554927210075686549454274975084092719656360819588576120105337409985227105827253346754675584559493828296310681533551031425508476747865738344597735803396901781608413147257040501594287193765148806417701299111436765905879095417412751117520753016100961661521844685846
math.1315 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000139815622894112006853684241982311358070960402035351910703239388793780723889206483690851257298604076772380682658565733322104795972628003273433579350284386845461367318936867045182306757717093266731624546210115759923544454923671654436216711379278322319704603080697614228284076565498286899672398843496496565953686273027546457562290827703201810240999554878342203120079138948866991979091893968072819730598820248053838192293556445216334607325758315364016911184641220094671476927965734669119805707888548954975701541951504845680263958363271685176952596984823625157412739363243152557632634377356583811494796774314443304716282617707556615810947111472733687502157019
math.1317 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000034953905723528001713421060495577839517740100508837977675809847198445180972301620922712814324651019193095170664641433330526198993157000818358394837571096711365341829734216761295576689429273316682906136552528939980886113730917913609048829522809861526054500951436259643634416208686682783731839247768558020565652087277524844656049986961351174929933291647965994264938228780520589069766732274658449303996770683063609590749523794460357951577459901533504905871393204539895280943505875016682144743080082110185782647229647823853419800331647473705007199121940164795796905367385022763719066390988460147870069119625809727282188164229723922687288739950041363732545877
math.1319 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000008738476430882000428355265123894459879435025127209494418952461799611295243075405230678203581162754798273792666160358332631549748289250204589598709392774177841335457433554190323894172357318329170726534138132234995221528432729478402261613122701385486638997480221493364971203726317460813578930871597076602816660857266118792304621083410954540662448145459589325620114384311052796275774322933402417256150648384634802052119176465314490201786135493779852129711115896719125141573885024224551308179299653492190481171455680302090249174165833115425266599846186259980638274777624201354568667222081694776070800333379926019664096388928382897686983491452252233228192063
math.1321 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000002184619107720500107088816280973614969858756281802373604738115449902823810768851307669550895290688699568448166540089583157887437072312551147399677348193544460333864358388547580973543089329582292681633534533058748805382108182369600565337252008559716673679619206754280583089784262230772022062835638706606001414973810611651536222891593918273713385905536852645522126354646199048958758318496099249306276824090781425105516729902678127713971174447314542177587546036610944866099990002204819195840117502812246641337860204360527694250423306514094496352879462371256507018179374840960339001078679029552075137914104388230146989653145190186361637255301460075347285507
math.1323 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000546154776930125026772204070243403742464689070450593401184528862475705952692212826917387723822672174892112041635022395789471859268078137786849919337048386115083466089597136895243385772332395573170408383633264687201345527045592400141326976483608078614412154707397563405804540808098311741885721991836368755603716729773129935174347425277306044765795181097085171320228502487078894113439375441328436818008759859934159419054691933686292202684193969906396659045599188812176221698612344584336792590383362890351241515459692763877761897142200773796371717217795129237360087254453834397870112069448563598229453277862971762174680678915568854230003544097255136770863
math.1325 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000136538694232531256693051017560850935616172267612648350296132215618926488173053206729346930955668043723028010408755598947367964817019534446712479834262096528770866522399284223810846443083098893292602095908316171800336381761398100035330928952176258480935510888594834547010256840084646683956987507087949661706481768789973267251211803741297357460261994928040602917683774614804907353233149573278343676591817982287168212471100901854586448050381684575155841110081661583151081195549257575300010777683355003964557818197775835370294817344490344969236169202713917318887865230613524878797068509519585582008634736024388875446125774489861086029374466814925577609131
math.1327 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000034134673558132814173262754390212733904043066903162087574033053904731622043263301682336732738917010930757002602188899736841991204254883611678119958565524132192716630599821055952711610770774723323150523977079042950084095440349525008832641663741202267715263523453757936259133280916724865265419877786304912405015174013792292752539056204432211172711409804651185183601682430705136152183099139202500860491273684932992232998424403912750578850045057679851909211950669377917742157021290035150401883248479009364249030472448913551373421594009974922463397726253918031988484072126898407156283458391874739916107798590738812722528817606737052529490521003637149524461
math.1329 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000008533668389533203543315688597553183476010766725790521893508263476182905510815825420584183184729252732689250650547224934210497801063720902919529989641381033048179157649955263988177902692693680830787630994269760737521023860087381252208150352123871416648969858786222739565513216995354904569263080670389283321075430371925737181438775747675594105138509237011800124142724916232273961809642756565393541938744474821625670328139445025372268139989790262345040129460406824848479085661247644925928020052421781354610812887155778549781817817859151110950244105093051154296055888154189878872706524692421542843251469936413315169357612109593868200777633788253000735366
math.1331 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000002133417097383300885828922149388295869002691681447630473377065869045726377703956355146045796182313183172312662636806233552624450265930225729882497410345258262044789412488815997044475673173420207696907748567440184380255965021845313052036469829697948575592906687976046613681626111746913725972226970243215854693483911701174739060139680981958672058033618791728234173715041119845148648396019337433755130900230860602529540942391969749397721452402492832708794360853324455842804762632416524070821278243712470358288678754804355081995032423076734123554074207633287435153658237853026658119560771492267699519109647814125698223410092101207638796624278429478745565
math.1333 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000533354274345825221457230537347073967250672920361907618344266467261431594425989088786511449045578295793078165659201558388156112566482556432470624352586314565511197353122203999261118918293355051924226937141860046095063991255461328263008993212838942078714942448818496289231886734926527051899329720632570077498329457783042622953973336252496350878220216868907414447654739397936471406097374856145702076748854592175112849778340518742721956292929424171921339030637296223155369852304545076687100162534224293138815788821360413624492174977985496620961650665971591306437357044356652947888597467164413508356950557520701928736277084510079420876100715981030009423
math.1335 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000133338568586456305364307634336768491812668230090476904586066616815357898606497272196627862261394573948269541414800389597039028141620639108117656088146578641377799338280550999815279729573338762981056734285465011523765997813865332065752234498255786067991704031851789031842580595619387165242196094388338754244022195541066093315042046952791496926634144458446337601272126973703582767524162605346121440745413715893888626713064521659485922835668224771085576070262431760553729151922250979929733754586293137569603287631386099265243146826767639246157351797750036967854891297489221340302520220709201788512253906336937394519978032864899433478293136142521406399
math.1337 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000033334642146614076341076908584192122953167057522619226146516654203839474651624318049156965565348643487067385353700097399259757035405159777029414022036644660344449834570137749953819932393334690745264183571366252880941499453466333016438057090680174355699366943479298920131157250225708502673589430733773159102054419006967127503932590948160919699111768363635971510246747535005836238103242750370941018137264573551446322596108090644314281529271694506930330770167369936735151027977135153477430473409386690167214987821169376008144183652418042077316410903373050082546090068246272119584814153106977455794493224966207177041988012873588403011554406974065710760
math.1339 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000008333660536653519085269227146048030738291764380654806536629163550959868662906079512289241391337160871766846338425024349814939258851289944257353505509161165086112458642534437488454983098333672686316045892841563220235374863366583254109514102238513348780557395371641581385068434925411760264290736254186453168963479209708515673224489871480568310050523451911702556442655305038119120217166476374336438751084049961467439910676811645538741123612577023440000591864349027309850825126701812686142112485107770320174960895618908473818787722555079622364323636156495081412414670173782182230759853800718821081070760770292399798332556428432757538415554612740651191
math.1341 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000002083415134163379771317306786512007684572941095163701634157290887739967165726519878072310347834290217941711584606256087453734814712822486064338376377290291271528114660633609372113745774583418171579011473210390805058843715841645813527378506622791643845774422120890045496520344550129010576727503904740298113735300297756766006888493816141290786987362125311560047875215873069158675686664484513762019045189668877604167725053944330704556584458781037828934250260954628921593664360244051778650912277917317848685866491924458094862579904878617764490010956668389308227767071872888435008563566948893762357199251687145223880230854092493362277445677143927919015
math.1343 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000520853783540844942829326696628001921143235273790925408539322721934991791431629969518077586958572554485427896151564021863433703678205621516084594094322572817882028665158402343028436443645854542894752868302597701264710928960411453381844624551604945033736391449998028057491556784062927145365744847428817286377650685031373400453498048287672553355144004920516057387087529023915101769707550619571383578788379046535256059200769044471532283945224885516371997690580169447254047227781825033975923276307442545072035669926716676065744507792887963513417526407424858008998411723112342406447327685068458381492709536028224262887799264211334641572799516220540960
math.1345 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000130213445885211235707331674157000480285808818447731352134830680483747947857907492379519396739643138621356974037891005465858425919551405379021148523580643204470507166289600585757109110911463635723688217075649425316177732240102863345461155904113128933133296298030119979190830378963584508695199419773175739143726627990308005527971689211068122406375276073754130504358944562270490203320379820574054652196090520599911552654687626573195273362747914917353602032635809259919482781698593089228109263618960996017120722381820299796606997191909422788549434356484499771464680981931046534931977861400750785646012627382658725775223632396568230858196802773344005
math.1347 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000032553361471302808926832918539250120071452204611932838033707670120936986964476873094879849184910784655339243509472751366464606479887851344755287130895160801117626791572400146439277277727865908930922054268912356329044433060025715836365288950051825863805457234010931435333034392846213096324217989156179647846966541078961963094725941984894806609103738445507989976932743063488924190929371862441425747215577714504271112597179553689044734462773872565431293772911922177728437662307339999244805204145881887273913695009051784096055723079358968718885465881877247265726788644905416679415978919258306973577363443772974307796614517182285767150620148281701989
math.1349 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000008138340367825702231708229634812530017863051152983209508426917530234246741119218273719962296227696163834810877368187841616151619971962836188821782723790200279406697893100036609819319431966477232730513567228089082261108265006428959091322234626683536009379104003110796670517131334366270653323178868254435635189955723227708741762932127571232319777036769940270533215742090641264563298929288643457779489067215778090230045011525996485737092608264338330474339122657486589110826669294418857800736880126309297587632470594727953822461841303998385445104430924414964701452241880038591275804225369162002399645776246733268047897022436915546816905062831475935
math.1351 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000002034585091956425557927057408703132504465762788245802377106729382558561685279804568429990574056924040958702719342046960404037904992990709047205445680947550069851674473275009152454829857991619308182628391807022270565277066251607239772830558335973891786568642167486358927324675402793011726916203781420222650291746758972173626338671546486978154111048321214320193190886225412430975887686358053431260726174891405954974684582105751273294834268614772695280939868261272280447625489745783528528017607880565509869801892264639204416096731195616208312482824316324988438036897998538405797435063377347094074094583163181565289014953578084488333713687750798900
math.1353 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000508646272989106389481764352175783126116440697061450594276682345639640421319951142107497643514231010239675679835511740101009476248247677261801361420236887517462918618318752288113707464497904827045657097951755567641319266562901809943207639548360473811555923449283663038463990247276191161016318619172457189405632003983626344462216610465541213435183094606830332729604967770009392312249815723643016943089065902765049070017151220662573434615757311269958484837171190109502507479853772627308021060668536288284902803948570554362381826550821823557576032280202387124611737118017115021593963368263822604231270371574551876825942752872759892053254496185544
math.1355 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000127161568247276597370441088043945781529110174265362648569170586409910105329987785526874410878557752559918919958877935025252369062061919315450340355059221879365729654579688072028426866124476206761414274487938891910329816640725452485801909883130896326768287852033368349241866605883263149063776062995047800332818591467082468101948455265696045015175886352068725897054954322158086782543367954275776653721749036944562391104714161547271015529623645625064578790300088502039481792623241697211189869886654103911249412774950358142668094296929953632689715842232873852472349670549667494161400853094193521114848499240235675793356145515682611454251168793650
math.1357 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000031790392061819149342610272010986445382277543566340662142292646602477526332496946381718602719639438139979729989719483756313092265515479828862585088764805469841432413644922018007106716531119051690353568621984722977582454160181363121450477470342810512123106072976392375046674323033506382689243616660087894858916935696901270579530925221902982548947317443612863998114151067167937107244832435609502209869268654930975303964644055155543043436874691455524725875735274919448799420093849568500218290105619122402695273081326355060274372864015090297775995539263033828215914818282779934505739638084498119518339535099801656979931775743655527907820227206547
math.1359 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000007947598015454787335652568002746611345569385891585165535573161650619381583124236595429650679909859534994932497429870939078273066378869957215646272191201367460358103411230504501776679132779762922588392155496180744395613540045340780362619367536823342523113641573881459065691655376453328497121970932947078689808377016462056928665377017195631336698312233747180724400805820861808211434429269684659779849409541032171378290544427072472598234121694970991525718051867541485876031244234475906661072256469849203326938307844862505090198039513081945949502394986872429889912319615805336547677733035606614617954205379467481125961693398402249975736146480075
math.1361 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001986899503863696833913142000686652836392346472896291383893290412654845395781059148857412669977464883748733124357467734769568266594717489303911568047800341865089525852807626125444169783194940730647098038874045186098903385011335195090654841878774803907704757430112960911314366579455191327037277929672892447460887931030707485919971555601117356336965044308346817197120127889876934483409668619196525782584871624645998053859161055069160980878387441556909381247626381876003559433150722798489862998962400624730658750921237001105415977225146405918167148235198150230050578606303305549955313829212063118900125985348282847179282190076758015403682108091
math.1363 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000496724875965924208478285500171663209098086618224072845973322603163711348945264787214353167494366220937183281089366933692392066648679372325977892011950085466272381463201906531361042445798735182661774509718511296524725846252833798772663710469090253007695783472710750910594308615457337743176740059800014531310643502414920566341507033489413730435617592840592441643382106714071998245830456176802640425672049724672966768542519040782487802051514015688639529646965196864762609402256642586872523900025727861007803467671193004656909944724082355745265979455130168003033310804492079562913228570540668663184382115390986172071872690454331401382965063527
math.1365 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000124181218991481052119571375042915802274521654556018211493330650790927837236316196803588291873591555234295820272341733423098016662169843081494473002987521366568095365800476632840260611449683795665443627429627824131181461563208449693165927617205513477565011880975744470178101261708061092618342856881313790543818822232312774347767218882257253870168435072759859004634646094251640075344062824423272215309771522113960635855908684768045058141003262142134025860642726566117794274016465808936373050161176786757017153893923754530067988216423491278068669860595143847303522409878606133553532832101477354378881977634665272892853979656861381214474894728
math.1367 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000031045304747870263029892843760728950568630413639004552873332662697731959309079049200897072968397888808573955068085433355774504165542460770373618250746880341642023841450119158210065152862420948916360906857406956032795365390802112423291481904293928394462482527221497977825583549631873790579492141101585131826638921850142930560540744777220293607682557308480159039357452569755536742601176681686108288148749446189125619644041367978784737687134161370255321756045939157865676544492579418679968218988790674694820388435024368005888223446239739515892724271321241334179990025272314070436831660833152755347944611854479135674775560833659870548875273472
math.1369 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000007761326186967565757473210940182237642157603409751138218333165674432989827269762300224268242099472202143488767021358338943626041385615192593404562686720085410505960362529789552516288215605237229090226714351739008198841347700528105822870476072654323623535027025103590043180135652952727358751527151091470088957976717209592303868401756155737861936244720485616902972562147571398266068645389930448209183999202176240901947686216960646974152123532617897658486395026529455853563041612000495885331386487023733664029136967621383197334734948433247498436241858732200061267249887629748727102352944151408541860979212380349359467220898088316322690387780
math.1371 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001940331546741891439368302735045559410539400852437784554583291418608247456817440575056067060524868050535872191755339584735906510346403798148351140671680021352626490090632447388129072053901309307272556678587934752049710336925132026455717619018071605906763134002912463687104394829347546252341047551738999425828188207599493594159679945911230516596906223828690574980162648574240019896978149650269956423423338391722391912177336721842273191549053022867636051416140562804238617822716997896203672843383821200731335067184577603922672193755015204352080050330251452398608800353465036104015484254914506386568112014704296417992214616585928360598581116
math.1373 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000485082886685472859842075683761389852634850213109446138645822854652061864204360143764016765131217012633968047938834896183976627586600949537087785167920005338156622522658111847032268013475327326818139169646983688012427584231283006613929404754507682032344047639243289941366027698015704831157835861708764512411346388377328456116873265019173857050653783035760015882487563441492277572001959875640589564458449914337505364118769507377668656273473355956469482979389699874791920078174963352383662816955415554508696701138889380642877658696109175695044454057944380732788911456489285290547261787209395916255246806658092528523424585794503531048189698
math.1375 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000121270721671368214960518920940347463158712553277361534661455713663015466051090035941004191282804253158492011984708724045994156896650237384271946291980001334539155630664527961758067003368831831704534792411745922003106896057820751653482351188625785014269707925201397376407054590134906015353078295846526089875536523369604898204435347203834156251710915434338600874782657671254433014973536909251602997626014180407366050936672242755854520360986968416865914656767425308302364835516510624110403726155343062869057825115458124559552065690804915261942641618741203185206617139560732012203417419899221788489449680876043209800304231871906264078756596
math.1377 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000030317680417842053740129730235086865789678138319340383665363928415753866512772508985251047820701063289623002996177181011498539224162559346067986572995000333634788907666131990439516750842207957926133698102936480500776724014455187913370587797156320087587837649677079887553491165937168704678671721786002073776961900428542645015021840239740838172821892155851160985824638507911537545073722776239729150129992623082173702745279597639441640846699906239314764273029671947328211728162624397500027708912466106701439652885987097148975562708549042418593394856982153733599342277192278588043017487518231385655350623851279476784704513662466952260674737
math.1379 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000007579420104460513435032432558771716447419534579835095916340982103938466628193127246312761955175265822405750749044295252874634806040639836516996643248750083408697226916532997609879187710551989481533424525734120125194181003613796978342646949289066003454782820016684476716342515751341309596379280204763913034026893950040263527523571553133242777638157849770180331692712303655432085305134977274024332057330275546135891244450514394933416549304910406701667431514538751878657988749785604588869298147729508275099470619742110195774140719702661429228292000378567885153888156430434646078861799933594422963893002750492265058365642051602046230274518
math.1381 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001894855026115128358758108139692929111854883644958773979085245525984616657048281811578190488793816455601437687261073813218658701510159959129249160812187520852174306729133249402469796927637997370383356131433530031298545250903449244585661737322264943259009416959439397493304487189729675557618303357664688768482992247832799467855127498638647720457615552532255092393906151100252210108139775786738532405980582194933135650988696915930209329578277476930459381993844434538501343704423768431065466867603864561895101949025880546889151185330437628219509442462895335048469658320142638109530188183254078865909025542433665925414121981448140182078023
math.1383 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000473713756528782089689527034923232277963720911239693494771311381496154164262070452894547622198454113900359421815268453304664675377539989782312290203046880213043576682283312350617449231909499342595839032858382507824636312725862311146415434330566062747564988901556324741572661603198457573684962873468806693229222368660725820960919053588032710786412342587475996373001879462440184613907836332043794145011591471888746450516417929988443814815897931972219614523621684323335864441490002363893736073478564791364513681381563810611941616419789309473147970150955005173515533416180791091036526325127535256506654087718972042575146576808799320584344
math.1385 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000118428439132195522422381758730808069490930227809923373692827845374038541065517613223636905549613528475089855453817113326166168844384997445578072550761720053260894170570828087654362307977374835648959758214595626956159078181465577786603858582641496457203762187799800670753892045884729802785728166595272173430469404021017672351022783277938264437937358364025912790419952275318616385351724903606410874421391859433904672381569928385655619455927012112742936280306842231173732543481001557079934654368033411585213285338703375217539081165882919656789275843381287982023140301684440089988931743463478500400517254421454021588363507213634720275113
math.1387 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000029607109783048880605595439682702017372732556952480843423206961343509635266379403305909226387403382118772463863454278331541542211096249361394518137690430013315223542642707021913590576994343708912239939553648906739039769545366394446650964645660371977668997764995585666061887083147306385070263980340825876704635552322569553322288253584032353525188147670690579719512708336575050788768460761523320756179625075020889285845686874083967551817992063203550984397923064398555819471372531388551477736809940343817910150714590544430941632141722187586379863912969156858493986539348847450374130741130258794507923594170754780123791297651187248230025
math.1389 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000007401777445762220151398859920675504343183139238120210855801740335877408816594850826477306596850845529693115965863569582885385552774062340348629534422607503328805885660676755478397644248585927228059984888412226684759942386341598611662741161415092757013700243253967027445851112084173700086880654939874006214716466004788514467742347592068953649708571148748656210090146002782140107462174027672132193219825947662157112322566818200160613705180690976335268499111025994560620784193469819470722567497276110671811467327984824254258796015953816684900947509474604033128250022952382167521171125121050685432794929884997277052843767902468128358788
math.1391 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001850444361440555037849714980168876085795784809530052713950435083969352204148712706619326649212711382423278991465892395721346388193515585087157383605651875832201471415169188869599411062146481807014996222103056671189985596585399652915685290353773162875252927702944046964838260387415325446088459274376005669074402937213364854398951808690667886695091035084498639212755269433132516895550044394844382102169784571865365954102351077760045765274732252492308858547965828725427845862646227847123935340651275077756626636534504695762808987758108942304868775484512366329115155519156190606053578539917632488630712973043054499168590965666962289072
math.1393 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000462611090360138759462428745042219021448946202382513178487608770992338051037178176654831662303177845605819747866473098930336597048378896271789345901412968958050367853792297217399852765536620451753749055525764167797496399146349913228921322588443287787905217135675155086029063137561820297563036545194835207868077004971811906651222942247492468814655897426384058324324236106905072560554904151690132614121701438113684585576775710508265488011782455725610346196887105495316338750429837185067297747409451828659712669301128102124239480368125148692083971104907391103371572140845953499181458219983506716163035387518914894259740885781354204606
math.1395 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000115652772590034689865607186260554755362236550595628294621902192748084512759294544163707915575794461401454936966618274732584149262094724067947336475353242239512591963448074304349963191384155112938437263881441041949374099786587478307230330647110821621319858196134249143153876677802453845061972661476579223144738836872783053668526290014631505774873211984958169972318327776573150733101769710475759496705898170100348157177659566508916780533139539672061173738299428302743749842502794244896786619767873922933748587114512925339325987119429155623139308975731161178029690598215626837433236631030290498228074027487267653132877616446328187152
math.1397 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000028913193147508672466401796565138688840559137648907073655475548187021128189823636040926978893948615350363734241654568683146037315523681016986834118838310559878147990862018576087490797846038778234609315970360260487343524946646869576807582661777705369145914983724168993749203713163057769117850223722241519250375774288176883084433856331742141840519329399390893092105945138570719082493558391235965023418193743699745596048133315453465349067741473466028706963512674088942237818873025599366299020640865293823714608476984276939158689087193044448403515631112155124583550653075683885500220614557548807441798922754062360116643207869243235306
math.1399 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000007228298286877168116600449141284672210139784412226768413868887046755282047455909010231744723487153837590933560413642170786509328880920254246708529709577639969536997715504644021872699461509694558652328992590065121835881236661717394201895665444426338266028794229998549321826988703258254263057784636460014641948506357597678511919828952722676059774390839086762228473859972912394370536513593766438494659183902722120683095779821618741708376874401616227154178616833615308426425560533073486870567379361527355151680748896557014650184012464900140679690668055676332184858590996447813366417478656738616380737435668328910419708962657298749327
math.1401 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001807074571719292029150112285321168052534946103056692103467221761688820511863977252557936180871788459397733390103410542696627332220230063561677132427394409992384249428876161005468174865377423639663082248147516280458970309165429348550473916361106584119790537257383670762070753888313876008386138237548296419304300232238692710292331112601462414904104208576028218834839847480289103735586620214659316865311027546883980116583454675922566842927067367216413700310658475449088369673533197559150231704421862980387213618077654176524946011514351564141114372706707791003811603529496236993521016101512110328809231004852147040546209491468758569
math.1403 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000451768642929823007287528071330292013133736525764173025866805440422205127965994313139484045217947114849433347525852635674156833055057515890419283106848602498096062357219040251367043716344355909915770562036879070114742577291357337137618479090276645980312449725444143627363689217911725940165611456990773300250205462819592408941124319752675981499415663122266794899418279009204554945169790806225906238607207094093640511661252481658093951063521292007371837950390915372526794579791087973402272747427631193990965259670020386434705172804188753505424293746413615444708356608002100694185169668777255165682286029653772169385719816570538238
math.1405 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000112942160732455751821882017832573003283434131441043256466701360105551281991498578284871011304486778712358336881463158918539208263764378972604820776712150624524015589304760062841760929086088977478942640509219767528685644322839334284404619772569161489563091921483061010934922387348293367049078075092548791220788077344889127942841251227314592905230539222595558746044382767760280848656129451841040673238407352120370737083689655454101031235223338917968550919276252045453822191835235780870952080422690125447427099278002708655372937227032570548456426273760542641637385983032824209996156343006809517680334673166843841880377032903928851
math.1407 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000028235540183113937955470504458143250820858532860260814116675340026387820497874644571217752826121694678089584220365789729634802065941094743151205194178037656131003897326190015710440232271522244369735660127304941882171411080709833571101154943142290371777992923717656930966397272711557995318677875533676694045001098407332395953216998505622603507460592965874318577754408249213308224648885890769656180930335791207532751956297584442080718547707369088519022263980429563778722120950328432053813593146105814173301099499096742850398424797897265497061072682045634284143733282581211655385599147756473293462690288466738283751973674950818866
math.1409 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000007058885045778484488867626114535812705214633215065203529168835006596955124468661142804438206530423669522396055091447432408700516485273685787801298544509414032750974331547503927610058067880561092433915031826235470542852770177458392775288735785572592876411557967957752545228948830610015891492619634590228649006283387512000540249436926271645908104365814826960632354525679778131279771649642449013602190443275932709862176338303953744547518893476598932161968233688228500649563417446853731380519345172632316494874406922824810635600076227737827922030670532105285014401113212220802247254344448685899523799325145953100670303720117437500
math.1411 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001764721261444621122216906528633953176303658303766300882292208751649238781117165285701109551632605917380599013772861858102175129121318421446950324636127353508187743582886875981902514516970140273108478757956558867635713192544364598193822183946393148211537703607383162558932751724621450313075727214333229955335571823064544751945157820441910924941560072968782490079289599663955511455071096140764462431817410997713762676002787971089287826322426953976327127626499518142412107913424902016956952429527332985497299599120427812133515688693715106157397225875470204765595469962455721415252201542846868239207860518852034611905540585896589
math.1413 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000441180315361155280554226632158488294075914575941575220573052187912309695279291321425277387908151479345149753443215464525543782280329605361737581159031838377046935895721718995475628629242535068277119689489139716908928298136091149548455545986598287052043849692445093353358245099707467727180328726437271132509893064231307812084378187207588781003775420382422548296562197662591399142896516871692344706199529639932473683658276101960546996740397091127969000566092627368070206792916746121495268966911056815028282715075901405386360851785693323593276226302481442676269784030768405831351419122577208614978824420935045277797450386950624
math.1415 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000110295078840288820138556658039622073518978643985393805143263046978077423819822830356319346977037869836287438360803866131385945570082401340434395289757959594261733973930429748868907157310633767069279922372284929227232074534022787387113886496649571762917565066511195862075678738099323059451904061926424854647028833665068244587548850368242867447431122000075295493778304720825907705627322866423222743021568731150233200320966704289112270417013863140352623967346880694756647380902449216813323831276350414243010709220399932592075855798297171364786302670050245416357569071296457982270057376373569074349214462556213186672481747704123
math.1417 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000027573769710072205034639164509905518379744660996348451285815761744519355954955707589079836744259467459071859590200966532846486392520600335108598822439489898565433493482607437217226789327658441767319980593071232306808018633505696846778471624162392940719013782561123690378488291543992556824845113294618110497263382594849426876493246321654680439245254600515452586737660103004038917507185566439154193141135107361682164458730307049959755039240093606790392984795923982619788319199716794090356193091208656987798114430029289250686735766828330789861535615617653209626768379091733082863315448177616456794048613264672022806413485711010
math.1419 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000006893442427518051258659791127476379594936165249087112821453940436129838988738926897269959186064866864767964897550241633211621598130150083777149705609872474641358373370651859304306697331914610441829995148267808076702004658376424211694617906040598235178600391855094780912351918110349449424196733636211405050483198335221508466857315328146332729521032994628488559272535461617405506165724708257938382439255212904212081601181313537789012819829128298810067350352844685728048233735202459361034355857902442894103666785783767252402299584620118171424805797016895327692416259474248643739828664264173710380717249038168073386051277596587
math.1421 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001723360606879512814664947781869094898734041312271778205363485109032459747184731724317489796516216716191991224387560408302905399532537520944287426402468118660339593342662964826076674332978652610457498787066952019175501164594106052923654476510149558794521980876530790596724628996959730158047567332670282087750505437861949533129218137340212362348004842490413852327925024945062018406867656692056799404699518344252080454350743581702775177634302870578277189052706924507684991589409830333828779619721346228746805705695815544979725029874278493552872194946633267871754953800655202328039942537854782310285694783503009349193071220133
math.1423 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000430840151719878203666236945467273724683510328067944551340871277258114936796182931079372449129054179047997806096890102075726349883134380236071856600617029665084898335665741206519168583244663152614374696766738004793875291148526513230913619127537389698616259987216819356807451634725751184178378935791729502507593676582884318439514457146567443916750832159635875583069162851900020364543189687188889161717736821418471230704954250676311678137092488476385545058027634854829040778984104295268371702125080369571202030958470541503598880385709819870560734494976052200095322190436411350725670662218883398408451021556757177014104302445
math.1425 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000107710037929969550916559236366818431170877582016986137835217819314528734199045732769843112282263544761999451524222525518931587470783595059017964150154257416271224583916435301629792145811165788153593674191684501198468822787131628307728404781884347424652483304369107251160340062624306534340871078683950040134672565492098516849568605710143455793604332655134792506999280336934395731449828034483298880489751675949667931800379491030257955093550194861593926843720636770110189978670900742578962573271706618812186800129291542664702084257602843588208908611699109889296495162710853111157035100269426764782823861770479082945724292730
math.1427 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000026927509482492387729139809091704607792719395504246534458804454828632183549761433192460778070565886190499862881055631379732896867695898764754491037538564354067806145979108825407448036452791447038398418547921125299617205696782907076932101195471086856162945082488377080785471366094173160062581807974989472756754157633733233350135483807924930038891819232142122972442263375784642337341793743363722119018028749053533663408332753686584509643202896269083358562912744593098140909365573935694987618292344497398186677151818240020074073016569075612551362145567553067807874010380965628694827756283929139097712036844598269770094644270
math.1429 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000006731877370623096932284952272926151948179848876061633614701113707158045887440358298115194517641471547624965720263907844933224216923974691188622759384641088516951536494777206351862009113197861759599604636980281324904301424195726769233025298867771714040716743554994299973632991572220681846463678471969808491753652326289819908394241216468906519777481037853133503743059543007387629277596961923474685187350612826285269236331841858203908564870908901296008951286178557704131793893625040052179576285725079495096066062938656890842555994718892023046935326864904190895170522577737561324072872361972313801773603909687895543077331014
math.1431 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001682969342655774233071238068231537987044962219015408403675278426789511471860089574528798629410367886906241430065976961233306054230993672797155689846160272129237884123694301587965502278299465439899901159245070331226075356048931692308256324716942928510177016214626356079771042342908213998373500337794945489890092294667622929416379222393634853283762062776350349339375296758649912312971298934484688567153589380227078796221699735279619557758972178775004709432428145225819898119989177743326628917553186790048981392506241082375238940084217542443874350946660926217516938143456244572637265611231249517695948160604845870862330490
math.1433 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000420742335663943558267809517057884496761240554753852100918819606697377867965022393632199657352591971726560357516494240308326513557748418199288922461540068032309471030923575396991375569574866359974975289811267582806518839012232923077064081179235732127544012978754120251760848857932947225899772942204568968800487430677479949278296907629120738136428493839983917713022758745973923077528609006245174060712390253240743197626395963900865162074888454431597652911677142108990232687027442957558120419946692306965889272739791691467358073871997026563360380724775342932156357226788019630712738586173013642549524573579736648421831326
math.1435 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000105185583915985889566952379264471124190310138688463025229704901674344466991255598408049914338147992931640089379123560077081628389437104549822230615385017008077367757730893849247843892393716589993743822452816895701629709753058230769266020294808933031885976458588255755364444244728336109397876330857345864014340119559433789200041127132914853958050232142873349470275571303861419102636128281852849283947430108663960632581151327650878543291898435066199131403116293438800297784806657929062306805804992335908598243452720205243048605480978919745893250080307154524363420971794762551844294428838231534806341309713248215663515897
math.1437 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000026296395978996472391738094816117781047577534672115756307426225418586116747813899602012478584536998232910022344780890019270407097359276137455557653846254252019341939432723462311960973098429147498435955613204223925407427438264557692316505073702233257971491138413700126888247953431539505452017204415025757316275947877643314175617715141632565647728459000482489594459990783450681257131696073828940739739005587760854028498015869321126552813906988118769550064850983720715930225154544907405111106519995208072458617856798632133898809956866597552264542238755419592238988360563412737468764263025479074089614782542350976175858756
math.1439 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000006574098994749118097934523704029445261894383668028939076856556354646529186953474900503119646134249558227505586195222504817601774339819034363889413461563563004835484858180865577990243274607286874608988903301055981351856859566139423079126268425558314492872453910829052616188309718935485041065203514944138363812422301386924863416365825230791651733881523983305979380675246694373256668775574386760564796101181450753937163695971486771295647922116212659015725772473368469563492821776597954163772643195738429334102377898909687656698167359475966467021587937830281652656786496896898478486078920553015873257079024534620077500188
math.1441 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001643524748687279524483630926007361315473595917007234769214139088661632296738368725125779911533562389556876396548805626204400443584954758590972353365390890751208871214545216394497560818651821718652247225825263995337964214891534855769781567106389578623218076734085487697838890914295050002273067813312445594813487278899630806910973349621325717355888911425013559374688539543782529987844066477748516739175271419415198739723104444636119183648597457483822945505071644869117731777497127630434106322334881039175033517036274022826766440221457858590581237175747526167848983369268465958612475873125986139862530655221576022249455
math.1443 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000410881187171819881120907731501840328868398979251808692303534772165408074184592181281444977883390597389219099137201406551100110896238689647743088341347722687802217803636304098624390204662955429663061806456315998834491053722883713942445391776597394655804515100896730207103257560191671249680129946058823732465636453453007656289619103329067852052574286792829730346952104649299989810366591383999170911477148527823434623686232952597173714990318398572414744306747807956880756053875560257917159101592065568021662894191981098544419400203954013925039475797640169807755370649748104818438392654827142330178402918545756886616148
math.1445 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000102720296792954970280226932875460082217099744812952173075883693041352018546148045320361244470847649347304774784300351637775027724059672411935772085336930671950554450909076024656097551165738857415765451614078999708622763430720928485611347944149348663951128321599222360958429371338796562321350596818118414645549628221929686801502083157126565536877133802271470420435800580475481598525600597617797364167434984508040315783275664975753864200955693050863451244742813904069537757673605207644724843895743380018305341261615192830761814324135377543489232299419016416453726922442098891275604461198007320125728691950297522048530
math.1447 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000025680074198238742570056733218865020554274936203238043268970923260338004636537011330090311117711912336826193696075087909443756931014918102983943021334232667987638612727269006164024387791434714353941362903519749927155690857680232121402836986037337165987782029997032235704342340755907890569372994793797657164625242039779952003608554936488263886856345906574982919964258413802257526957394899584227633963875174188363596708231963669100736656184987852941801153344846886653720519249072136833592628970011049116342557036984252110667511335756638151694113055733372582218146881254245756414980591573517096312209159426859605499230
math.1449 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000006420018549559685642514183304716255138568734050809510817242730815084501159134252832522577779427978084206548424018771977360939232753729525745985755333558166996909653181817251541006096947858678588485340725879937481788922714420058030350709246509334291496945501898949908422167251624666833752236064875034753569293847730422491367928031417145024027562648971755647431641654411082051840331125919360476718815637285553907956706214996186737658675818993639262455103516230633823562444059226754554890173780031603353955541518453642398359721442237235719057665494294152089916363071050283336001209057911907690379739477276397619673809
math.1451 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001605004637389921410628545826179063784642183512702377704310682703771125289783563208130644444856994521051637106004692994340234808188432381436496438833389541749227413295454312885251524236964669647121335181469984370447230678605014507587677311627333572874236374852481015938439775843465581894713773571712614978783188290436456549429329263511029124207169186840234269204923581396233788815201168113943603073316931611456662235348971854402467392485113703638177540027261334798716803906079585678582883691133913496544311315437084421564541697036594421170885997032854724777291765108225878367249980946876592194807015365234295869278
math.1453 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000401251159347480352657136456544765946160545878175594426077670675942781322445890802032661111214248630262909276501173248585058702047108095359124109708347385437306853323863578221312881059241167411780333795367496092611807669651253626896919327906833393218559093643980647188265273176121825857751194209923034476524655556812540104851479139124954294086959734921316613000620892974138539285180257392244170031596745149861907009814489942235956039624656104170218616177128340619196718393428672153326390989558627508695214954806384064965249589562162918515135411453506102118581264769449901621508516886700103708006781042678818537103
math.1455 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100312789836870088164284114136191486540136469543898606519417668985695330611472700508165277803562157565727319125293312146264675511777023839781027427086846359326713330965894555328220264810291852945083448841874023152951917412813406724229831976708348304639773403312983264139132651281059840445881976591300922667703720781293467045552765142038241636758537976024491661198556312987978385892838277367516870484465426020781358117761038740693364517650669533487237482543345548168011143714435373763239493384467402909380142957527614625883527918999565317352451345480649285258212650447063991317773314844164770977707983715998035643
math.1457 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000025078197459217522041071028534047871635034117385974651629854417246423832652868175127041319450890539391431829781323328036566168877944255959945256856771711589831678332741473638832055066202572963236270862210468505788237979353203351681057457994177087076159943349974670423487318091403665335223479763493441042170985911481785415742797411325598412421969479410194493849860009419297366103650740005931487480130591816344673629047677876705362713864022309112626256278873464879505219947157934591024909689895388475788666375881403966156749799326336395350114509015934819772467775995665386016015693868049074430981142154262394588942
math.1459 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000006269549364804380510267757133511967908758529346493662907463604311605958163217043781760329862722634847857957445330832009141542219486063989986314214192927897457919583185368409708013766550643240809067715552617126447059494838300837920264364498544271769039985837398825895588777848249071931040537637467317572932086475791164359378078155058076142218023463732125109121860599059385493915599077272215050565867034116290554883875056982178583942103184427276353984828521695747086107747104593900215747239610909480758260046048785852401148573464474402759965025212365734891194844515362568114203337489718510711540990635178775422526
math.1461 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001567387341201095127566939283377991977189632336623415726865901077901489540804260945440082465680658711964489361332708002285385554871515997496578553548231974364479895796342102427003441637660810202266928888154281611764873709575209480066091124636067942259996459339168506087966498217618604675097486766157983498503840938981979338117183456371984344787098586317553464842438287575390411087146237024004718781690324873126107259112858100450792596593756876211281429782129559603345352377873687303269418318541866163287337635938473232570123737477427731936628197396892689818115921049683141306383678148340915316091401600779822187
math.1463 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000391846835300273781891734820844497994297408084155853931716475269475372385201065236360020616420164677991122340333177000571346388717878999374144638387057993591119973949085525606750860409415202550566732222038570402941218427393802370016522781159016985564999114833621241209855184127221386937103602513687117015235096011544482556040145274298879285116911608055641275585863852197071706348161772474916966063748336307224569735928060364646565601459289228982488481108652605481292293856468561088135378143929216801460478166034030755678040556946303961638309128510712368478190225323391661775827298843117564282570155551737917935
math.1465 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000097961708825068445472933705211124498574352021038963482929118817368843096300266309090005154105041169497780585083294250142836597179469749843536159596764498397779993487271381401687715102353800637641683055509642600735304606848450592504130695289754246391249778708275211934448635984340539597423592941993737158320900200308230385844575141930929065603687564400160642160383105305181715873304355698608773334639945753355369425220886851109848895066027864128392383255818010861153493453341294920010358290784590731908479040136933390698015418355081883981858046604982056936020655874703684877812624550532015013984593226224872962
math.1467 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000024490427206267111368233426302781124643588005259740870732279704342210774075066577272501288526260292374445146270823562535709149294867437460884039899191124599444998371817845350421928775588450159410420763877410650183826151712112648126032673822438561597812444677054347609388252324144600773038975159228651834526016849790625346109425876966755515770306298031845752013864347688063627777910968100194363535738082180177645355331763019438374167622196472366400793388977080990915488252006182944843525824819504717893406869122158556680942204278948945374998310489933777597811873993227472326377903475740466052713792270826843361
math.1469 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000006122606801566777842058356575695281160897001314935217683069926085552693518766644318125322131565073093611286567705890633927287323716859365221009974797781149861249592954461337605482193897112539852605190969352662545956537928028162031508168455609640399453111169261980749655517895264979734780085670221631574736592190193608308710498923851024795539174841944828725944995928184434595701098284155664387573054308960804278338724778677821917091222847952129619623183333920229672257147915068831509818210012387563788378232756718142804835922341514708329277801278663323699999459130736958416589357005135960859396451622362581397
math.1471 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001530651700391694460514589143923820290224250328733804420767481521388173379691661079531330532891268273402821641926472658481821830929214841305252493699445287465312398238615334401370548474278134963151297742338165636489134482007040507877042113902410099863277792315316726003707786508337104975059404268126628806935600631285629642418337030460189617749073534747991257530075519710725453787964608984518747610220397507721473558065549784626333840967414036683953874494720830146935899716039556263791237177155415759312445535127711964115723169436026563282448879150613696873861697866188960174750925359775995744697513828179682
math.1473 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000382662925097923615128647285980955072556062582183451105191870380347043344922915269882832633222817068350705410481618164620455457732303710326313123424861321866328099559653833600342637118569533740787824435584541409122283620501760126969260528475602524965819448078809352455352314703983406385991294035111516659821406055919579906692762709582157485876753166858198900080418154772356533281812660031509892941071005744336133820279818593839590241936900842983188309807300827927556233495109094721221978482094074328650477134980024539209959912703841814699409027641401271415017037293760042583204472421150807407569386780972976
math.1475 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000095665731274480903782161821495238768139015645545862776297967595086760836230728817470708158305704267087676352620404541155113864433075927581578280856215330466582024889913458400085659279642383435196956108896135352280570905125440031742315132118900631241454862019700134886552008462317977167856317171897863549187296613768580809571877172058551602740242156511349845653204458120275263302099999206253051683991741032462451836265891442646898314005897136725143938222167392655789647619716216687218810905392074032914989120092257783702621821402096077744344768277426105409586157972734251669832415695248699356320550735209863
math.1477 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000023916432818620225945540455373809692034753911386465694074491898771690209057682204367677039576426066771919088155101135288778466108268981895394570214053832616645506222478364600021414819910595858799239027224033838070142726281360007935578783029725157810363715504924788918606216536281952688781689699987797485544818053418665850492823347977194815270733190771926363705867772244200608045707981379160549415300600768824326112532688060015835773337215609290115648986617778868507776297862209515676638406444606465728656170005586631164004531463777876573992553016045046086419080141830390855383560164560911627477671877906761
math.1479 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005979108204655056486385113843452423008688477846616423518622974692922552264420551091919259894106516692979772038775283822194616527067245473848642553513458154161376555619591150005353704977648964699809756806008459517535681570340001983894695757431289452590928876231170029314689069704094660730712470220652882302648280018724312412078509767916138771646925653435913403418793918175906702558437742300946964303224137840382989629418148265526853871608494001288598010588861952822142134030760299682250405205222057312340100926506400721963598557647321951679850144984436561845961824116462001513286627451043330071553692141079
math.1481 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001494777051163764121596278460863105752172119461654105879655743673230638066105137772979814973526629173244943009693820955548654131766811368462160638378364538540344138904897787501338426244412241174952439201502114879383920392585000495973673939357822363147732219057789485069020593607535497242154789246685832899711377411798616968449924416825416354463245631187236403849348574780171641320880813076437808906703139530573687573604107428778147972047078131295500055892246739509838221675725093498377423591271993942699556972218415375183348015657090648104937788521392864572651942611232022973873451425411170997608941108511
math.1483 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000373694262790941030399069615215776438043029865413526469913935918307659516526284443244953743381657293311235752423455238887163532941702842115540159594591134635086034726224446875334606561103060293738109800375528719845980098146250123993418484839455590786933054764447035460627184644274077872702771944062859594266656287073825227160291879189285384343757431999948884628409376499064573183694800769242904207886574334918748578539868008571918604583431158487583889439668379647684341145567853539054631964867245357099800597844087433631592168597804962001530762518604591577453578540961122251950295340765591615845520404685
math.1485 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000093423565697735257599767403803944109510757466353381617478483979576914879131571110811238435845414323327808938105863809721790883235425710528885039898647783658771508681556111718833651640275765073434527450093882179961495024536562530998354621209863897696733263691111721553309244632445208752860590167392537272937643175560030860684274167017647045611266694022558308231110369991879661390754211025658887383217286856204723442983727130073799830209375748028974939953112484619916341918321682034303186320288093923795840789246752931680130200071972402578142639465978409434266890021502165216574355207050214800492212346197
math.1487 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000023355891424433814399941850950986027377689366588345404369620994894228719782892777702809608961353580831952234526465952430447720808856427632221259974661945914692877170389027929708412910068941268358631862523470544990373756134140632749588655302465974424183315922777926242566472099375378775402358339778892359831186249866849332270424230334447950238964155285925253399334039816538084024891942849008961993720504299881740449451349574510763310781623710163585855226911996487823923188411020411867657220070168048598941826755117352655935666569239605866540537682605193768728505781544944080749058258790731641397988158249
math.1489 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005838972856108453599985462737746506844422341647086351092405248723557179945723194425702402240338395207988058631616488107611930202214106908055314993665486478673219292597256982427103227517235317089657965630867636247593439033535158187397163825616493606045828980694481100001524796095408759093613006937029539024104946464139179411978911870282675208201870130401944054450892989530984192578917944762711625976368584507163955552328259404614533609770346780490033517649190049824909172719666762222171163843113759418684415690862650109298817724661578331026537174584892356863661768427716469920250363682722018927365579288
math.1491 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001459743214027113399996365684436626711105585411771587773101312180889294986430798606425600560084598801997014657904122026902982550553526727013828748416371619668304823149314245606775806879308829272414491407716909061898359758383789546849290956404123401511457245173620223818148618051803752578183631955624767985616057060193333335702822888311856318546115455813889425236876917982353068850944178691841365110341313853094193686914383270811822948483077721744016174790046803177604874302084687625609185618008642035738759100553535297442547559690015529893996731370037370166447385161565287387834643126220780934387224186
math.1493 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000364935803506778349999091421109156677776396352942896943275328045222323746607699651606400140021149700499253664476030506725745637638381681753457187104092904917076205787328561401693951719827207318103622851929227265474589939595947386712322739101030850377864311293405050267622423293834445122854839124613679021913994314399282054226605157715873803691600855421628290934125192895544602846759899395311836679390791543973904510487742308776087908903046211171727135180307126767772823800780118208460650623982600142669012139331880402885853397775030596459906531378354919688012979994033153777245574018732054931413264620
math.1495 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000091233950876694587499772855277289169444099088235724235818832011305580936651924912901600035005287425124813416119007626681436409409595420438364296776023226229269051446832140350423487929956801829525905712982306816368647484898986846678080684775257712594466077823351261935026191243556778722748035462898696091646274139638814815812306782277625086929019324018535509914076405268325743559914847595755903103381638228293515693039618520646592218534903417319123238598494395293421765321787429972124832522869127734710936395437133584700717304775622558160274002814535432336652525550844466418960010023598855512317603298
math.1497 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022808487719173646874943213819322292361024772058931058954708002826395234162981228225400008751321856281203354029751906670359102352398855109591074194005806557317262861708035087605871982489200457381476428245576704092161871224746711669520171193814428148616519455837815413547723968677879952024156163696371393596876930580703070870371750330368120177379176578314814943024113210908057317559253315264302879571402928440049986084091623878600303668074950388246526862141966282130388407284017661074148356080868758971885221435051385904041356578934084068860354180806232967634179166216412559156172642953319328001556301
math.1499 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005702121929793411718735803454830573090256193014732764738677000706598808540745307056350002187830464070300838507437976667589775588099713777397768548501451639329315715427008771901467995622300114345369107061394176023040467806186677917380042798453607037154129863959453845585950565257101684821277629587614778475364609941953475152847943667143346538247499208321030120701029624263305599120984597296667620306849995595198170168154794160422548031946414936891155851018419159892979862580286385970369281848107418446513629690638098276304066952329675212871331371308243447964981693708938007051235083706554099143372315
math.1501 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001425530482448352929683950863707643272564048253683191184669250176649702135186326764087500546957616017575209626859494166897443897024928444349442137125362909832328928856752192975366998905575028586342276765348544005760116951546669479345010699613401759288532465989863460529712038324012276407012583915072797960635083296241447392129208815069316244995508698051627128502479775125414318639265179155343782900490194841597950725053352783524800576311901216426069422300124389106818729132188881905806657929621777474784011490167255855732135938116275819624876017656885551351938998256162110979049242712416311095929363
math.1503 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000356382620612088232420987715926910818141012063420797796167312544162425533796581691021875136739404004393802406714873541724360974256232111087360534281340727458082232214188048243841749726393757146585569191337136001440029237886667369836252674903350439822133116497465865036119609248751608568607943369675877639246985358588481692911993636909937906852614274065281181939755762565752237310818409214522265483320070481821533034931633111816662762780786135462437406638607919422391913716510068841927541175891436333108140215290550285919903791426640282784828980418658415809935461151320773322149948675855608264323826
math.1505 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000089095655153022058105246928981727704535253015855199449041828136040606383449145422755468784184851001098450601678718385431090243564058027771840133570335181864520558053547012060960437431598439286646392297834284000360007309471666842459063168725837609955533279124366466248328968941937739860691407774742044759710436843483578183770186346243329904002457690688806339908731809395260132400038170573151268566185297817280054964696052157502550426106619959571822690666901292039685527195443169458563014320844767946104450536469933937889806683776142196950083677224672249854831602890976572012610059933950085926834087
math.1507 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000022273913788255514526311732245431926133813253963799862260457034010151595862286355688867196046212750274612650419679596357772560891014506942960033392583795466130139513386753015240109357899609821661598074458571000090001827367916710614765792181459402488883319781091616560893249638789972489455009936165852895471908155741612074891678579562593079032759325135811145468715493321461930108046605784345672941030244476189421708503251248214347021572368703860312710334209045110313753241391545544061256003671690108791899090530217323627027355604379173046328563938083021627504725226156498707836033602424348329128569
math.1509 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005568478447063878631577933061357981533453313490949965565114258502537898965571588922216799011553187568653162604919899089443140222753626735740008348145948866532534878346688253810027339474902455415399518614642750022500456841979177653691448045364850622220829945272904140091202121175886180617325594317056746706232477254371633050600977446399447872872598224353848644015822327326248861237991795092846657422441121477289645717950390813443357064838144183673403991051176140951505930465616783497476720082092972988372313796936619882135737377408046518292659621172604942935715160581919912618837516636882133148448
math.1511 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001392119611765969657894483265339495383363328372737491391278564625634474741392897230554199752888296892163290651229974772360785055688406683935002087036487216633133719586672063452506834868725613853849879653660687505625114210494794413422862011341212655555207486318226035008121609347126329404728410832107911436364279126811643187948170201127770647627345882799691302874727692604980696890202431996148155707263613972648435717502884232233795007514643625762265043040496462209642587202602159469046718601382708681080245620739872923519328630792898487968687969768021230440119914087546125285349721394172265399873
math.1513 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000348029902941492414473620816334873845840832093184372847819641156408618685348224307638549938222074223040822662807493693090196263922101670983750521759121804158283429896668015863126708717181403463462469913415171876406278552623698603355715502835303163888801871579556508750399411120465447267892881847231836165736198649838325788686812088007265848507858284778948285926545491014958338842628883912696649076999607226865000516932975116822110500912561748645445599124316100350473737040492336342155955659771484045681739447707611702055220759675369887292016145047699059912774730219864714950547009791897220877418
math.1515 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000087007475735373103618405204083718461460208023296093211954910289102154671337056076909637484555518555760205665701873423272549065980525417745937630439780451039570857474167003965781677179295350865865617478353792969101569638155924650838928875708825790972200467894889127187418631533859013474385529255052943297727952870030183112916121859526852371749300328314628789282510102516374380779554807190803007841492535554905460305628494230179267819565240530739681326265989422261089345033802576781911762259767771750665606972284961042363800472995146254976480291474893333123071652475156376262633968724702792240698
math.1517 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000021751868933843275904601301020929615365052005824023302988727572275538667834264019227409371138879638940051416425468355818137266495131354436484407609945112759892714368541750991445419294823837716466404369588448242275392409538981162709732218927206447743050116973722281796834522189436159108308861068568234075131310796126501518867299224606717082895362388425311832631835717824941905869210655821326179246177870971858499540451040274319676976484321254193622545620376299624568931252215543646411447909464142323817218581379773659549800767380248017310349671672324169748262388787586154860767664594195545428273
math.1519 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005437967233460818976150325255232403841263001456005825747181893068884666958566004806852342784719909735012854106367088954534316623782838609121101902486278189973178592135437747861354823705959429116601092397112060568848102384745290677433054731801611935762529243430570449206393248022529303711935128787058324416085763322620462009965779454457491830289186700400695414759839700218622097782881069067703398856105196645973158895417481554903690964748215938261437966636180491621010341320851144776229409784300052582952206784910615284125684520133063744269804826949461489443957764950263175974777912776439809715
math.1521 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001359491808365204744037581313808100960315750364001456436795473267221166739641501201713085696179977433753213526591772238633579155945709652280275475621569547493294648033859436965338705926489857279150273099278015142212025596186322669358263682950402983940632310857642612301349723190464495554063766823986781729939003529654569090618219675034175302733251074441589104445616618830560594499077724348721248304208238459420875699705194052613083501594598694549337442941501342194647329864304670766284286237286210399664247513523810841573342433820175879475993386724237871263520958824691146246905392726533486790
math.1523 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000339872952091301186009395328452025240078937591000364109198868316805291684910375300428271424044994358438303381647943059658394788986427413070068868905392386873323662008464859241334676481622464319787568274819503785553006399046580667339565920737600745985158077714410653075309809818153031624747051109021384390920035626746914893557529897805188530701196590759443415084254898460518489741809148540713134141627830647958284033354167809140733182110599085857776355322314918165023576112502083532767640395168882181301529475550652190371617135674500144650464788283860811011608902009120073683583369703043336325
math.1525 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000084968238022825296502348832113006310019734397750091027299717079201322921227593825107067856011248589609575845411985764914598697246606853267517217226348096718330915502116214810333669120405616079946892068704875946388251599761645166834891480184400186496289519428602663268824383456820136543545774933146978204222818322723759014600824138789813211010619572373088202545824918365449438115123366852237485987137598887889911575941638540728234662940088595044493199340238683333753455463032159851648071814798970838941427466887290339113148151117927080788505911377098265815337538279964440822237610644530456174
math.1527 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000021242059505706324125587208028251577504933599437522756824929269800330730306898456276766964002812147402393961352996441228649674311651713316879304306587024179582728875529053702583417280101404019986723017176218986597062899940411291708722870046100046624072379857150665817205754864458576206704111750608037007332683404685054230451477330735066200345468273613630644944763028896953450159855406126065949546976693191516960179274642589453508817669737573603350978780577443487577789506218040368260680968035308180284076726810857187611813531895892151730916591844625436129981288439013077378557230327436993125
math.1529 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005310514876426581031396802007062894376233399859380689206232317450082682576724614069191741000703036850598490338249110307162418577912928329219826076646756044895682218882263425645854320025351004996680754294054746649265724985102822927180717511525011656018094964287666454301400827253926503989102161798819524752835164949498499479677254465723538707790777350114171714891512702637372610083247577406107170098872572273071409850797642282427221299069440605529709022424113389679086818058630725157256447858704728891171622009840948148216705791410242750221253070202460968892803248280107934386557050184525052
math.1531 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001327628719106645257849200501765723594058349964845172301558079362520670644181153517297935250175759212649622584562277576790604644478232082304956519161689011223920554720565856411463580006337751249170188573513686662316431246275705731795179377881252914004523741071916613575345996940068565143172676466017133734838159434956285077342416036648327857105884220495932981911851006592566493645189232783706768453018062445360226355159076672723473867171254285237089958637111960548081151717039732830657807325171853229425482916273651469679569338960336652163039057313126900096743343973839466726385158669933625
math.1533 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000331907179776661314462300125441430898514587491211293075389519840630167661045288379324483812543939803162405646140569394197651161119558020576239129790422252805980138680141464102865895001584437812292547143378421665579107811568926432948794844470313228501130935267979153393836031471304578968670628673872311494446136325137033514604837611408464539849603264342582140276737510640721994647339234688391133883065617764350320354618620957304942749282135141737568345551620613820514015280339312759341578068532644497256801250167084461658583303214092456774794761793675402180026684320324265907265719770051339
math.1535 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000082976794944165328615575031360357724628646872802823268847379960157541915261322094831120953135984950790601411535142348549412790279889505144059782447605563201495034670035366025716473750396109453073136785844605416394776952892231608237198711117578307125282733816994788348458955894080304484709597119286747658137822577550698628125568691990603087803859950443267634491270461992689428799172800504593832556300971346977609395968972104784466163152680626593091625931498778309010682546297345115186675493317163615570298823747697333632297779419789998768303892857254477427107217443051882431760803945571140
math.1537 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000020744198736041332153893757840089431157161718200705817211844990039385478815330523707780238283996237697650352883785587137353197569972376286014945611901390800373758667508841506429118437599027363268284196461151354098694238223057902059299677779394576781320683454248697087114733198659427203682059274357094668370709921750612462528543205124149322266682669206108253003049402646228904992830754774203574704134639159621072272027167122358142149213964250110350633098829541783249620225492624775894619555047071328139116596624767971333092555076702109557569688927893459599114809990953290049939783763989241
math.1539 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005186049684010333038473439460022357789290429550176454302961247509846369703832630926945059570999059424412588220946396784338299392493094071503736402975347700093439666877210376607279609399756840817071049115287838524673559555764475514824919444848644195330170863562174271778682658013673587865477040204318973074483511255757316242930360406203836157305965256559434848565882566896842669656305876668128849929148270224898059455116680163093938239690406245596294565369035135368249229961661023849331875336493582832747543295012581235410644338117182681494767304408506421836685792125733415922759798197679
math.1541 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001296512421002583259618359865005589447322607387544113575740311877461592425958157731736264892749764856103147055236599196084574848123273517875934100743836925023359916719302594151819902349939210204267762278821959631168389888941118878706229861212161048832542715890543567944670593208842484404698395786084777266599325682617573573043096671013904104952635531365677778564085297873056936463922822846725009581785787591738958358037492215613306886166973085622255451415775416014973104370931452141457788158084252275566524454188361087522241147041703812297753708722256451355779619764037195258091086024508
math.1543 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000324128105250645814904589966251397361830651846886028393935077969365398106489539432934066223187441214025786763809149799021143712030818379468983525185959231255839979179825648537954975587484802551066940569705489907792097472235279719676557465303040262208135678972635891986167640380591075260988947361521753649758547850507531672406386008804914366863286018088732674243534064040358264010408078342758229850946304679658566644426964406663306980013340107430361841751001257578513593790124530220103637987606449620186926749811394480662518592273401982629988441021314839403925606322451556651308983691383
math.1545 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000081032026312661453726147491562849340457662961721507098483769492341349526622384858233516555796860303506446690952287449755285928007704594867245881296489807813959994794956412134488743896871200637766735142426372476948024368058819929919139366325760065552033919743158972996541909214967819277448831108713833893896161010388342726895553373429166185118613408438551305183384931518100013768649505433586999402236560367883955778319806807528046773722401341971456902537423359236269698069435823412243652235638930510706473022704045769060625325674683777580863002362263698172008549933414643361731788757265
math.1547 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000020258006578165363431536872890712335114415740430376774620942373085337381655596214558379138949215075876611672738071862438821482001926148716811470324122451953489998698739103033622185974217800159441683785606593119237006092014704982479784841581440016388008479935789743249135477205944182648495718251437724638080320702348358993812105773493729056657741341433678730365013056824859497638389874785940910066059138336189801624270292335866702807732718814949960496978763955902583134051041078104767193458356590725525217128905286612498440592770374805634997676207459146636479206979455060820542859402338
math.1549 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005064501644541340857884218222678083778603935107594193655235593271334345413899053639594784737303768969152918184517965609705370500481537179202867581030612988372499674684775758405546493554450039860420946401648279809251523003676245619946210395360004097002119983947435812283869290619626532027652948888238511143000225559453449796161713388591987539778445283313116376716244644585373764733857410656800873792562166738429592699833154409419159077859534788278598838514112986036418503872410952826793276029662503190715605111604167756117862471664973971743740220721700298119104446598023853079070840106
math.1551 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001266125411135335214471054555669520944650983776898548413808898317833586353474763409898696184325942242288229546129491402426342625120384294800716895257653247093124918671193939601386623388612509965105236600412069952312880750919061404986552598840001024250529995986858953070967321447526729662882502336371555743852284164570440376055458348832410593316067979149771737008281209854176702865285320905486147034560273094716196689653851984881840563318198258268369108942208692108064106830056998027313543914124045571197541548059289824823969754201507054290630219100769650095786514755443923120281512284
math.1553 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000316531352783833803617763638917380236162745944224637103452224579458396588368690852474674046081485560572057386532372850606585656280096073700179223814413311773281229667798484900346655847153127491276309150103017488078220187729765351246638149710000256062632498996714738267741830227728359821939432819016436486863318571665618752571090142950815282592512179045386561233094752319970093680968104475403306601575593985913360118490747816501243562368806738033616654937072222538011526918880326374053286750942092452025459580547278584770956946384128961287053790394301445511106054910487302643400163258
math.1555 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000079132838195958450904440909729345059040686486056159275863056144864599147092172713118668511520371390143014346633093212651646414070024018425044805953603327943320307416949621225086663961788281872819077287525754372019555046932441337811659537427500064015658124749178684566935457542026165222842503453078947738482523812974516761315797597486894113344071954123340376639498626952928736527425001035409912188497845797837707912520163045267620159652119148226906872367770283357946826343763120911985594565538082881805901107415661002639472629370744333248882966533001620052172175202862937374271782671
math.1557 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000019783209548989612726110227432336264760171621514039818965764036216149786773043178279667127880092847535753586658273303162911603517506004606261201488400831985830076854237405306271665990447070468204769321881438593004888761733110334452914884356875016003914531187294671141733864383850327446528142001972496780928041416583419420681507739566078005302233978459945509307788538835225096699321025249581265329136011149610467854007538104777161625364131727469893685717887262808758255996633210131430995316194610395178991465141683151927947117839450320294606795367566706637159239013628244558652763454
math.1559 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000004945802387247403181527556858084066190042905378509954741441009054037446693260794569916781970023211883938396664568325790727900879376501151565300372100207996457519213559351326567916497611767617051192330470359648251222190433277583613228721089218754000978632796823667785433466095778558099500648404793430844821722627850275991876216750468669998766249160162665312343382010497361042237881897978031848252507508309641621505266050897689874471391155369691158640054576781476553069489805994951381308856773997613373833758611221872532370394874059759459988725400388074450460012662070753109549987411
math.1561 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001236450596811850795381889214521016547510726344627488685360252263509361673315198642479195492505802970984599166142081447681975219844125287891325093025051999114379803389837831641979124402941904262798082617589912062805547608319395903307180272304688500244658199205916946358366523924192440193896868342836227826509798485282457603036389347961999407194586212630654198782711045290790344253990235134243387596155468770294769845864543477533513964469113292088017638655858232956434649225803463954038353209635067855608655762925323775394761391141087418303011976681002245636800925959909034554754463
math.1563 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000309112649202962698845472303630254136877681586156872171340063065877340418328799660619798873126450742746149791535520361920493804961031321972831273256262999778594950847459457910494781100735476065699520654397478015701386902079848975826795068076172125061164549801479236589591630978776211750555857879540003247858465346066554360090453084856555375757790572264810895577589808094978673261665974408703216284514244010339180631394115764390589170748419530721821923554149320885571693061380905809302771966839646118240146652031298350148485149184275392397341460184856068592358155812142723633790308
math.1565 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000077278162300740674711368075907563534219420396539218042835015766469335104582199915154949718281612685686537447883880090480123451240257830493207818314065749944648737711864864477623695275183869016424880163599369503925346725519962243956698767019043031265291137450369809147397907744441619793425813446977328177656951417043965252170541687643700568823796978522552428992387679442887011337435206449413845113959158426780960510062748929431781812646120572424879649098557859404333260016032353323236237801394885934742671049621569931392626199534603159850959538822472031360291971922562874434213443
math.1567 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000019319540575185168677842018976890883554855099134804510708753941617333776145549978788737429570403171421634361970970022620030862810064457623301954578516437486162184427966216119405923818795967254106220040899842375981336681379990560989174691754760757816322784362592452286849476936082356821221658803643479529491163974319583164392405245958654222748654726348010296703429167351737568725694214150935465838804300431605925166650600564395071510934754108633378153186863968093632241309648700358253298593249370657124750241252917942501544244359792138962524717194450263729808429785613040644310617
math.1569 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000004829885143796292169460504744222720888713774783701127677188485404333444036387494697184357392600792855408590492742505655007715702516114405825488644629109371540546106991554029851480954698991813526555010224960593995334170344997640247293672938690189454080696090648113071712369234017472746734881972232997380714671673586405996803631291939411231303019846222266150782005319336936149502683043819798533633069354088447112962677640511325115217486268967772473231731407603494802385472483898518835515160554226379078371085206107201927324862823732752888151989287810818592390881662755905003912137
math.1571 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001207471285949073042365126186055680222178443695925281919297121351083361009096873674296089348150198213852147623185626413751928925629028601456372161157277342885136526747888507462870238674747953381638752556240148498833542586249410061823418234672547363520174022662028267928092308504021913509216856538485733883321327286213744279300043034824771783072313181706935096184444000789788189144037652956818649752702853283515093004409057856428508788520624233577051647817635481633299162017866808211382426688184675995221282714543588314435954239742053532372965497238288402325039294882335966499596
math.1573 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000301867821487268260591281546513920055544610923981320479824280337770840252274218418574022337037549553463036905796406603437982231407257150364093040289319335721284131686972126865717559668686988345409688139060037124708385646562352515455854558668136840880043505665507066982023077125967003580137143410203254438014043920399241078535257430925300052136672920553444596344234796481419359894151268573336355936549527895516201288324367800234872132347198535111901102506157160178625100937456848117362276126899073969940940542750771936339402876681603067890834390927220303329483419300315575272153
math.1575 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000075466955371817065147820386628480013886152730995330119956070084442710063068554604643505584259387388365759226449101650859495557851814287591023260072329833930321032921743031716429389917171747086352422034765009281177096411640588128863963639667034210220010876416376766745505769281487475917571277994282127050301701213304899715046063987977892469297345410707995684896961343151907319152220245513793166039512250259949875659550214542961800803666471020079935074576733544463578531949141027814829548891597647263684971143950575509158848076009590883706075661899552446071803292396606184621231
math.1577 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000018866738842954266286955096657120003471538182748832529989017521110677515767138651160876396064846847091439806612275412714873889462953571897755815018082458482580258230435757929107347479292936771588105508691252320294274102910147032215990909916758552555002719104094191686376442320371393981896929736540677700441890884793457089362877067021869501353578261629180536314340629569260438585686442308499300071586381263439782841273011701618570508758803464609090412971982747717997105955593800346573413799579752540288310705032485462491930905142909271159411857055277250776545179652682453699978
math.1579 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000004716684710738566571738774164280000867884545687208132497254380277669378941784662790219099016211711772859951653068853178718472365738392974438953754520614620645064557608939482276836869823234192897026377172813080073568525727536758053997727479189638138750679776023547921594110580092795717974689127242963418206746674694723401296426052314066973563865888624204202421929634479124399512825097347130492635864186282354647257694414932724433772505499278328840008168306727107510662374266066538283365148208380074919139912146025234407576301262627308339081828675916403744312867665023012020922
math.1581 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001179171177684641642934693541070000216971136421802033124313595069417344735446165697554774754052927943214987913267213294679618091434598243609738438630153655161266139402234870569209217455808548224256594293203270018392131431884189513499431869797409534687669944005886980398527645023193065327056358822717964895717107951054086874740600362805587638241063624596502643631794962759909863362217311227697338740223344643628653020955067327751903717019087601828602589333464018878930691940696272752329244560120767145128644551455997035315050928726189678505378479548810220771411098497274236852
math.1583 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000294792794421160410733673385267500054242784105450508281078398767354336183861541424388693688513231985803746978316803323669904522858649560902434609657538413790316534850558717642302304363952137056064148573300817504598032857971047378374857967449352383671917486001471745099631911255797614757695653818121392373265992463027214668755604233400157381479664958209731442924547223243178575302325769411932576882186588833681256432722248403787249328215246124859217374806341809386539906137860696680423889191330204081674726603043432189738004505444284046669012455665991729270306120486718782787
math.1585 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000073698198605290102683418346316875013560696026362627070269599691838584045965385356097173422128307996450936744579200830917476130714662390225608652414384603447579133712639679410575576090988034264016037143325204376149508214492761844593714491862338095917979371500367936274907977813949331292305198355912781554353910946341658439418951518649901620027627245336944614288536637205594767099111602531317393353561175283172991127900948942263398265271642000592811757865249430642946891329208133018210496560155291013262226582111803428263043270239536658072334881860248071673431665290558059292
math.1587 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000018424549651322525670854586579218753390174006590656767567399922959646011491346339024293355532076999112734186144800207729369032678665597556402163103596150861894783428159919852643894022747008566004009285831301094037377053623190461148428622965584523979494842875091984068726994453487324778951997911354021328703745828872620695658076819695793435524430256421404126189623029456376483249614585097088709353169685829099100784166391329045470225564336107856870429928941688582549157809495695356707287532446937250021779269268188368106068538557793223775614111873499270069878229054303118061
math.1589 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000004606137412830631417713646644804688347543501647664191891849980739911502872836584756073338883019249778183546536200051932342258169666399389100540775899037715473695857039979963160973505686752141501002321457825273509344263405797615287107155741396130994873710718772996017181748613371830300946410402546930436633188467472289183448223531594317028938610169115036361838237854047980542087385500103634328562156798347086536640729503842647992074085131316709625106422527570025838671116506552962133502859138679607122194960804234539215261237980207061742745041977174686714915062007483499775
math.1591 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001151534353207657854428411661201172086885875411916047972962495184977875718209146189018334720754812444545886634050012983085564542416599847275135193974759428868423964259994990790243376421688035375250580364456318377336065851449403821776788935349032748718427679693249004295437153342957475926426036715446509653547340229642741365800808084175776129930609502057460491874140921315848996844358784726598943190797018972940987369921072927178520487288083593562665376775464493148710186252485920892836555119847109202163538558277028336303468262559125405918951180485056941121941237051634688
math.1593 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000287883588301914463607102915300293021721468852979011993240623796244468929552286547254583680188703111136471658512503245771391135604149961818783798493689857217105991064998747697560844105422008843812645091114079594334016462862350955444197233837258187179606919923312251073859288335739357947142446520940949690636859875362957064088527041665779465291326511436406237670166053586819301988643447161429380536765636098936005418874169594592463673600382500185820652098707455141515591799326778042860805671298477931954911135703093133544338356243428875486513858635047307241484535899098070
math.1595 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000071970897075478615901775728825073255430367213244752998310155949061117232388071636813645920047175777784117914628125811442847783901037490454695949623422464304276497766249686924390211026355502210953161272778519898583504115715587738861049308459314546794901729980828062768464822083934838260734049112688495453464773281946547235204167873818871025523795420739328349939944938203133386916889056343666194549643229175367418974317864772292319646375469136357027863902992567324749791864965616490797359973020732735514671284246103197998748641127411580885077845920242323592536445993691012
math.1597 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000017992724268869653975443932206268313857591803311188249577538987265279308097017909203411480011793944446029478657031452860711945975259372613673987405855616076069124441562421731097552756588875552738290318194629974645876028928896934715262327114828636698725432495207015692116205520983709428955560887333596977900144244165059916487934869943876218514389276615968397543031059529275409109192063480728643016905453977245567812423835345700213659146686563123765043851116553335561991734589617676049355944564670202501824494755098103776410285358659919709668478619110784700864205761177774
math.1599 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000004498181067217413493860983051567078464397950827797062394384746816319827024254477300852870002948486111507369664257863215177986493814843153418496851463904019017281110390605432774388189147218888184572579548657493661469007232224233678815581778707159174681358123801753923029051380245927342102451178406896257201030608116645324420527373206986661532312921535229467169984967657706859208405771358494615685281324236911804516310888742272512720070318227340331047393375628501043225019019428147162812876610202704882768438563906315474001280192815127498226328315991408663313878138558048
math.1601 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001124545266804353373465245762891769616099487706949265598596186704079956756063619325213217500737121527876842416064465803794496623453710788354624212865976004754320277597651358193597047286804722046143144887164373415367251808056058419703895444676789793670339530950438480757262845061481833843786234221001510158701490593092480582747805048526399483491075092833740990743708889469826683335637893880593358104215586183552524989381063995623658382429177563903849229521294921611109264240637451029674269919331175094370242961703817993297157522175633713319298741437384168604272126263367
math.1603 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000281136316701088343366311440722942404024871926737316399649046676019989189015904831303304375184280381969210604016116450948624155863427697088656053216494001188580069399412839548399261821701180511535786221791093353841812952014014604925973861169197448417584882737609620189315711265370458274076940735170093746169132488709914532088724789551570326474195963100254603046756886261135768748820035054252721390929955096510508570862919157516523302812807805289416460844477929997255428225246075450639417331919441812374790033086018307977221519406034458873287934663336233687854407207041
math.1605 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000070284079175272085841577860180735601006217981684329099912261669004997297253976207825826093796070095492302651004029112737156038965856924272164013304123500297145017349853209887099815455425295127883946555447773338460453238003503651231493465292299362104396220684402405047328927816342614547755944314894714126152700882226011342622378255990111521129818678540821356912892517553470508622195071161797000554940939724196780178662135695891420682059370108468293465596025504676478091741321153606351175135308927828759514167964382050025739171501378746140709932069724494433379274019859
math.1607 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000017571019793818021460394465045183900251554495421082274978065417251249324313494051956456523449017523873075662751007278184289009741464231068041003326030875074286254337463302471774953863856323781970986638861943334615113309500875912807873366323074840526099055171100601261832231954085653634631953759957255274828221638339673136722283126064441095783706857164733973245023495609277245648325441390253007939536173925501323159770690135807554043443305655688844405330662600855471104566998025595331281076925426654084761786433191852896246686294682375806123562606273281307987911767543
math.1609 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000004392754948454505365098616261295975062888623855270568744516354312812331078373512989114130862254380968268915687751819546072252435366057767010250831507718768571563584365825617943738465964080945492746659715485833653778327375218978201968341580768710131524763792775150315458057988521413408401651515681933456850393900449714984299091732856878409001621401794464452646455914593531491244612101858652558407195258925203345024954356557489077274519544539319074550102849675179017951878601477198137652640933619163845539505298294706534574612850292622426192446494048622455327961687347
math.1611 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001098188737113626341274654065323993765722155963817642186129088578203082769593378247278532715563595242067228921937954886518063108841514441752562707876929692142890896091456404485934616491020236373186664928871458413444581843804744550492085395192177532881190948193787578864514497130353352071930998441885546228524974097406157199053038918749395034371426837869553087747316502962003903656441188117506982055616447281726726795442919765290292369743704318309020722399532679771174162633921610568283451896310122983703232038516886650122900702130190485684172849020248638197486952211
math.1613 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000274547184278406585318663516330998441430538990954410546532272144550770692398344561819633178890898810516807230484488721629515777210378610438140676969232423035722724022864101121483654122755059093296666232217864603361145460951186137623021348798044383220297737048446894716128624282588338014818096223960517892234187856015696091349938141301770179033531863828881597062755554027071097303378710746528676653548746929419511760733372207213792396864544911637297758009562490500203117656652881645834230473177327969770320746841607128513143550270768756863681926110770655943860831899
math.1615 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000068636796069601646329665879082749610357634747738602636633068036137692673099586140454908294722724702629201807621122180407378944302594652609535169242308105758930681005716025280370913530688764773324166558054466150840286365237796534405755337199511095805074434262111723679032156070647084503352895901933366288069985223077719221902671025504822702585124649775164102057458491649720010035763390321871272623347701744464636835946969970235805799708204987027106948103466102686985176858404606967432265228117870871427263955574057522635794303393376171902933721950502520829692505307
math.1617 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000017159199017400411582416469770687402589408686934650659158267009034423168274896535113727073680681175657300451905280545101844736075648663152383792310577026439732670251429006320092728382672191193331041639513616537710071591309449133601438834299877773951268608565527930919758039017661771125799154180588145662574322778999851494260688477507247915404808016201340325824561245483869139810042926762161051873610315993017243530738256594606991194426169997769863682425986023456405671708405750248077367159435639070292736693646146380983290881549065420973877126992587699128941830073
math.1619 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000004289799754350102895604117442671850647352171733662664789566752258605792068724133778431768420170293914325112976320136275461184018912165788095948077644256609933167562857251580023182095668047798332760409878404134427517897827362283400359708574969443487817152141381982729939509754415442781445447456825347981261005858442231950096841088391372227713260543356729448157273269434460522430410962710728400048155177949021098029545843493323752214662000138443920025650954227840174682093079726284932597440555651051822582325147315374881941117794852122377264970443988882186362126243
math.1621 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001072449938587525723901029360667962661838042933415666197391688064651448017181033444607942105042573478581278244080034068865296004728041447023987019411064152483291890714312895005795523917011949583190102469601033606879474456840570850089927143742360871954288035345495682484877438603860695360879521059482724828298705020810107138840157543905306801877195762115069450555312699003268105147210791036337465344638815118250857037714133850049655449439772277808240306567192735162922097267519207112399988020943045968138866624619381849503457431274994485613107339407546006185309438
math.1623 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000268112484646881430975257340166990665459510733353916549347922016162862004295258361151985526260643369645319561020008517216324001182010361755996754852766038120822972678578223751448880979252987395797525617400258401719868614210142712522481785935590217988572008836373920621219359650965173840166286581886873375191036300786095630780026657761021130865083376410179297220716545905054526013966043687332972259031295764337864220678895742413702949464358365766308287067202158803980699205500650209127844549360871152193980418022794584524031386683077302990956900924221078530652208
math.1625 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000067028121161720357743814335041747666364877683338479137336980504040715501073814590287996381565160842411329890255002129304081000295502590438999188713191509530205743169644555937862220244813246848949381404350064600429967153552535678130620446483897554497143002209093480155304839912741293460035616791806850806921799080261364890591671916860776886093580225867146150369833399937845575917620771580527532611743556383837260495308653077814680080377691291032049095147400981369134083122333034600173944197903394583128275026095338853941327275414146083722705453865763873556366825
math.1627 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000016757030290430089435953583760436916591219420834619784334245126010178875268453647571999095391290210602832472563750532326020250073875647609749797178297877382551435792411138984465555061203311712237345351087516150107491788388133919532655111620974388624285750552273370038826209978185323365008242547544505197633120881739212442969769673928585510787540543329520018266308823702414943358752888523875693102600970478487403394953710951921587169317934122712509165273583627749854510594023022210920373056211642466732313439009064269548594448643259370012526888812242222007899133
math.1629 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000004189257572607522358988395940109229147804855208654946083561281502544718817113411892999773847822552650708118140937633081505062518468911902437449294574469345637858948102784746116388765300827928059336337771879037526872947097033479883163777905243597156071437638068342509706552494546330841251987120174214354508577010620788801889314829005856520948456856594905946863671703005376352437393521645273791047835251662124971767752488591587943142243207008450849168150255171649415959849999062615049747375912852760632219589894912586093893378244146054093904617376743352283547574
math.1631 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001047314393151880589747098985027307286951213802163736520890320375636179704278352973249943461955638162677029535234408270376265629617227975609362323643617336409464737025696186529097191325206982014834084442969759381718236774258369970790944476310899289017859409517085627426638123636582710312988611520007816971621673786973388377536752865209701709511072011229369193372869871318823286871191468463433069979369475809367488495240020520046491106771027420792500574437044547015360207110133105131287300851565688614848550745123517437399431521408440194916931108048814917557118
math.1633 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000261828598287970147436774746256826821737803450540934130222580093909044926069588243312485865488909540669257383808602067594066407404306993902340580910904334102366184256424046632274297831301745503708521110742439845429559193564592492697736119077724822254464852379271406856659530909145677578246245266274646281180687461385145750518415506718600035421863320863218129171544592271343063664776873465301079497126431205466821741267546532573923392911565222762592758817400207271770078956462993101582987087709966025036443947685308207554075990949102793140666970921173343175271
math.1635 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000065457149571992536859193686564206705434450862635233532555645023477261231517397060828121466372227385167314345952150516898516601851076748475585145227726083525591546064106011658068574457825436375927130277685609961357389798391148123174434029769431205563616213094817851714164882727286419394561460470598960685659090644750930732755629131170336076415920865555346291273811384116906570576969663516263360096757614718380588726145502344539292027807758902086700146949698837431045856092330161255258098091351874133525180454030461428910597926935559670082702007201552110085343
math.1637 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000016364287392998134214798421641051676358612715658808383138911255869315307879349265207030366593056846291828586488037629224629150462769187118896286306931520881397886516026502914517143614456359093981782569421402490339347449597787030793608507442357801390904053273704462928541220681821604848640353912541995628677430303343804271536243422180438026610697442537674546038555650034678954273217465340170072271131182225930023102739555109623246471349702791787903031986907907759217390284550808422688119113885128407064124491398753764014786670062779546343779303313391497962323
math.1639 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000004091071848249533553699605410262919089653178914702095784727813967328826969837316301757591648264211572957146622009407306157287615692296779724071576732880220349471629006625728629285903614089773495445642355350622584836862399446757698402126860589450347726013318426115732135305170455401212160087233123527291309652869408847911033764871032648840820087385762067300200761446287053328749301594052942988317442993172741936433596353168904525336103843816421001090802225110095521672711300843006657984733032078033813285740767530981230476881258916808452473018698860568842894
math.1641 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001022767962062383388424901352565729772413294728675523946181953491832206742459329075439397912066052893239286655502351826539321903923074194931017894183220055087367907251656432157321475903522443373861410588837655646209215599861689424600531715147362586931503329606528933033826292613850303040021669946218309954112694415867182552852775034555469556956627010255565460315087547139286651880646037446910440434103583880976403722584335725988413833340745046808643012278292318960120971176670851774046733764774636422061269011708614049857888059532385570341178426449960879938
math.1643 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000255691990515595847106225338141432443103323682168880986545488372958051685614832268859849478016513223309821663875587956634830475980768548732754473545805013771841976812914108039330368975880610843465352647209413911552303899965422356150132928786840646732875832401632233258456573153462575760005402116036409391494782166595151726481144567127007317231910149201529188425963661826594381254077900940745761338898706047521022633256755431481223436932940810764201898816463612526663886499885501844572855719722008183093381333328571417528267014027941285391161974132335861499
math.1645 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000063922997628898961776556334535358110775830920542220246636372093239512921403708067214962369504128305827455415968896989158707618995192137183188618386451253442960494203228527009832592243970152710866338161802353477888075974991355589037533232196710161683218958100408058314614143288365643940001348821173750337092207604163049719205614009391545154640505692482342055256178890461290008456176852077299568249210544298244358069715374580090763634632985708142388379787103740107958598703384463116816677516433652038625510390208598263301207081519609896784761052118232037379
math.1647 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000015980749407224740444139083633839527693957730135555061659093023309878230350927016803740592376032076456863853992224247289676904748798034295797154596612813360740123550807131752458148060992538177716584540450588369472018993747838897259383308049177540420804739525102014578653535822091410985000337015533954027519553241320124850644217709860085547030407329251914375830676719838060436907672810446226350719467732495268212007584530947491630661480440927641301306622663472468799941573447569963167887555386540792598919697145968783310820612054699484565068017176147288224
math.1649 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000003995187351806185111034770908459881923489432533888765414773255827469557587731754200935148094008019114215963498056061822419226187199508573949288649153203340185030887701782938114537015248134544429146135112647092368004748436959724314845827012294385105201184881275503644663383955522852746250084232799101445018388459249960370532478228299710193243188599660904023070628290762041546426210268992323416419551943837228955500802320214925012082350354065310959127952986705610734462270873165177899051686210871618849114559237665980745891477415461681445329318843200599139
math.1651 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000998796837951546277758692727114970480872358133472191353693313956867389396932938550233787023502004778553990874514015455604806546799877143487322162288300835046257721925445734528634253812033636107286533778161773092001187109239931078711456753073596276300296220318875911165845988880713186562521055857065687714430464692482221285499979389892971253640124064995497891319196113013324073140574623721612853741876038575228041745711995737042400252060053372254648799060102790854112998552877148597771787926521951479931929907927088280008558717545095689337052694011991092
math.1653 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000249699209487886569439673181778742620218089533368047838423328489216847349233234637558446755875501194638497718628503863901201636699969285871830540572075208761564430481361433632158563453008409026821633444540443273000296777309982769677864188268399069075074055079718977791461497220178296640630263703965347090811321715341902949417263993580512029281472588445484708792257186309212959017144475446043074419234574006916917830331548046014975581289628570231980734299850851954694630842062159829777265467608715290065952043034487642364680718901586928556872618163638437
math.1655 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000062424802371971642359918295444685655054522383342011959605832122304211837308308659389611688968875298659624429657125965975300409174992321467957635143018802190391107620340358408039640863252102256705408361135110818250074194327495692419466047067099767268768513769929744447865374305044574160157565897068995124058797711304514362692345903518157920194972766244327870082781869694623455391175098807692975380782595097630330279127725801698674508464031056687808354078832174571025477844275859144148129532010870758172189045847561467643446822949029717052832829077744160
math.1657 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000015606200592992910589979573861171413763630595835502989901458030576052959327077164847402922242218824664906107414281491493825102293748080366989408785754700547597776905085089602009910215813025564176352090283777704562518548581873923104866511766774941817192128442482436111966343576261143540039391471053655264498695792544910660155089798670987248145921482575854933396775197770024776696336994695943489042526087840618815994398024649335216473020632643519709107464582428263017682809264555806781900512459239015732696958067242959646586532411392926600831522677493145
math.1659 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000003901550148248227647494893465292853440907648958875747475364507644013239831769291211850730560554706166226526853570372873456275573437020091747352196438675136899444226271272400502477553953256391044088022570944426140629637145468480776216627941693735454298032110620609027991585894065285885009847867406347869845117988660536783870106152200129897380611291867827396224313769480991628935033495339988121727001570745289285490223516517768309434466783147474122501193353872023561233296560093509556016031387756567954601610211566818115402494378054859764978493243432960
math.1661 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000975387537062056911873723366323213360226912239718936868841126911003309957942322802962682640138676541556631713392593218364068893359255022936838049109668784224861056567818100125619388488314097761022005642736106535157409286367120194054156985423433863574508027655152256997896473516321471252461966811912973430217723890057431393230282775852817161167369769608367153313994596746288873863845686775058150235953662448385982736324724490355727084654118712330094668028275223424398612389351661595730774877266565768831198183194130656337927102888924701881026081298759
math.1663 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000243846884265514227968430841580803340056728059929734217210281727750827489485580700740670660034669135389157928348148304591017223339813755734209512277417196056215264141954525031404847122078524440255501410684026633789352321591780048513539246355858465893627006913788064249474118379080367813115491698570021798547567275283606228941320107943242380960125420474482688021337785464170178477680516335767617390717412959437007926352913905730972712047788771838020263639269607804331907347263280310791223389353021862229275379568008879247167375959547952561502747317421
math.1665 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000060961721066378556992107710395200835014182014982433554302570431937706872371395175185167665008667283847289482087037076147754305834953438933552378069354299014053816035488631257851211780519631110063875352671006658447338080397945012128384811588964616473406751728447016062368529594770091953278872924152703054191684741350818043972413295205814827536507241571108549748983239285775651287388917377497802106760352945119308897396198785670747726999087092265671354424506379945331005086807527290126531366231186623337569540822102770169985153000704416380964248665312
math.1667 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000015240430266594639248026927598800208753545503745608388575642607984426718092848793796291916252166820961822370521759269036938576458738359733388094517338574753513454008872157814462802945129907777515968838167751664611834520099486253032096202897241154118351687932111754015592132398692522988319718230983753275165120398952139676186112575825898621583735242220831346075429009034747591340510428043658439166587977092419833548327713064110798548303898428544880759552203148096804754410589849290579269010323677895587758993292213453263275087729572763323876255353177
math.1669 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000003810107566648659812006731899700052188386375936402097143910651996106679523212198449072979063041705240455592630439817259234644114684589933347023629334643688378363502218039453615700736282476944378992209541937916152958630024871563258024050724310288529587921983027938503898033099673130747079929557739891375637635567917416604067973616403635201473668080758324970811988718837942862114979073533057275196080093034898292423079557529104712038915322013300493847770948181814253633395857236485761221271332684056091758599060810956841244304418324434250936364309372
math.1671 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000952526891662164953001682974925013047096593984100524285977662999026669880803049612268244765760426310113898157609954314808661028671147483336755907333660922094590875554509863403925184070619236094748052385484479038239657506217890814506012681077572132396980495756984625974508274918282686769982389434300961336781721777063227130487345483926638821498605767705368735567342662736378226506042441280170510623700898923832443102959300395846054377646881787820535040836755985791457770432061806231016875472255967600141765462128100859025378275892805967390669678663
math.1673 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000238131722915541238250420743731253261774148496025131071494415749756667470200762403067061191440106577528474539402488578702165257167786870834188976833415230523647718888627465850981296017654809023687013096371119759559914376554472703626503170269393033099245123939246156493627068729570671692495597358500586715014633755122370795232274302428086200161494283940133965288520438267501523044429950099581706723000518086431370479414260445591296333169095831699252993331379055584314378326654638756722169716851208964169011099458250545953789164784737545295217173568
math.1675 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000059532930728885309562605185932813315443537124006282767873603937439166867550190600766765297860026644382118634850622144675541314291946717708547244208353807630911929722156866462745324004413702255921753274092779939889978594138618175906625792567348258274811280984811539123406767182392667923123899339616851832178014362209099811320339456878846716127800553431010355921761750965031710363098525278177546577091828783327093698039613483245577720931982334007493163124199214911239698550401347155732536967966937470390427272442550633927487657334911496959444329824
math.1677 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000014883232682221327390651296483203328860884281001570691968400984359791716887547650191691324465006661095529658712655536168885328572986679427136811052088451907727982430539216615686331001103425563980438318523194984972494648534654543976656448141837064568702820246202884780851691795598166980780974834903291308424987582044331298664781628805470030819442025296194462824843953452164186435440302181020177743866479336022801322086130967683367056637407625288837725757866964951716713967460079840772244746297749393080737323010106232126167501539676775020718382157
math.1679 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000003720808170555331847662824120800832215221070250392672992100246089947929221886912547922831116251665273882414678163884042221332143246669856784202763022112976931995607634804153921582750275856390995109579630798746243123662133663635994164112035459266142175705061550721195212922948899541745195243708725720421592967339010200196425606158822007324570137382650542157244478045664252853147156261196530132335921455627360258985807780252684394278204286577631872146436890870262807710639627213632619629020386216795546087720508837157640349856732210828539108709818
math.1681 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000930202042638832961915706030200208053805267562598168248025061522486982305471728136980707779062916318470603669540971010555333035811667464196050690755528244232998901908701038480395687568964097748777394907699686560780915533415908998541028008864816535543926265387680298803230737224885436298810927181418727007877439585785312635224956552239588572009554143357043926482517782864525124377530371496431739530901217212793485928194786589271071111619941220152782720047620790688431231880380482868970347742307470806066751231433570080753463811360637473786695213
math.1683 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000232550510659708240478926507550052013451316890649542062006265380621745576367932034245176944765729079617650917385242752638833258952916866049012672688882061058249725477175259620098921892241024437194348726924921640195228883353977249635257002216204133885981566346920074700807684306221359074702731795353417486373315989028024106453285454364092412944078367030539272216519042027388151937545378692318896610562783233501564757187554804892490173521462728614278581214672222670608204856048129018805152785105009025910556820700728750451157684509649810747429565
math.1685 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000058137627664927060119731626887513003362829222662385515501566345155436394091983008561294236191432269904412729346310688159708314738229216512253168172220515264562431369293814905024730473060256109298587181731230410048807220838494312408814250554051033471495391586730018675201921076555339768675682948838213897638213007543861131907437620958155911007318461889999072564784160096986690300293320875103164344622637911742412664312317385398091698448863173662023300992864391778596539756895699843763795512890490181410291317792085834042676877123449471565394727
math.1687 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000014534406916231765029932906721878250840707305665596378875391586288859098522995752140323559047858067476103182336577672039927078684557304128063292043055128816140607842323453726256182618265064027324646795432807602512201805209623578102203562638512758367873847896682504668800480269138834942168920737209537866192318141917838072453983433835887067504196156598318018642379862200928856165729660907889506663042541933865272218857571422368963941842048848027556231435904579734754078110655443581947894135624204537011756397521495451083477515588025111152895054
math.1689 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000003633601729057941257483226680469562710176826416399094718847896572214774630748938035080889761964516869025795584144418009981769671139326032015823010763782204035151960580863431564045654566266006831161698858201900628050451302405894525550890659628189591968461974170626167200120067284708735542230184302382732301720078816334272499842972747454887959645321496892643605170945792085789995949785303540567285414733534125170171689891975149956654041604773630450214102052642910366846546711807408932189673617338022215070606944401266714552156339249552528919055
math.1691 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000908400432264485314370806670117390677544206604099773679711974143053693657687234508770222440491129217256448896036104502495442417784831508003955752690945551008787990145215857891011413641566501707790424714550475157012612825601473631387722664907047397992115493542656541800030016821177183885557546075595490381390080074847429723443755885584068776977583968369065228467845363782955938378265223281607445759694278048942778141972895960568682241633700254674904219188327169444859083238834798171404767261144159771782263687678171581549574777513215390950846
math.1693 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000227100108066121328592701667529347669386051651024943419927993535763423414421808627192555610122782304314112224009026125623860604446207877000988938172736387752196997536303964472752853410391625426947606178637618789253153206400368407846930666226761849498028873385664135450007504205294295971389386518898851184898637837685619830692384826809389059473979724775144565691973442697017700082435072197786930818369224458641276226548768676039894863878703602231209465205433619233786709316473471313779786132709334856058300583207174621978404908789952505566405
math.1695 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000056775027016530332148175416882336917346512912756235854981998383940855853605452156798138902530695576078528056002256531405965151111551969250247234543184096938049249384075991118188213352597906356736901544659404697313288301600092101961732666556690462374507218346416033862501876051323573992847346629724710417285894772640711890987701301748277472116226457047439281264661371979952060074816408758045073746641823330927605911198919356331943083021929071509189411902286385572065781607647786914103679235113255371027101219278272393424210565166865829079075
math.1697 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000014193756754132583037043854220584229336628228189058963745499595985213963401363039199534725632673894019632014000564132851491287777887992312561808635796024234512312346018997779547053338149476589184225386164851174328322075400023025490433166639172615593626804586604008465625469012830893498211836657431177339994944283517878743115214780442172724389915672690043502520795122028954418913616062268244417441332624412317155572751032859896537922650177064649673691375674705366751901432859659960265778997882305137980389312983625992256394462366874748306978
math.1699 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000003548439188533145759260963555146057334157057047264740936374898996303490850340759799883681408168473504908003500141033212872821944471998078140452158949006058628078086504749444886763334537369147296056346541212793582080518850005756372608291659793153898406701146651002116406367253207723374552959164357794305629121692030325326930835856777776887359796591331197951430713200399901538494505344464698120916407841500810983792626791883953418053095288132470460238221707910672103026028320216460259762437148797539519943329153024335630619005792479656335375
math.1701 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000887109797133286439815240888786514333539264261816185234093724749075872712585189949970920352042118376227000875035258303218205486117999519535113039737251514657019521626187361221690833634342286824014086635303198395520129712501439093152072914948288474601675286662750529101591813301930843638239791089448573143989936468787514082934759935247966980206667072653607391068791199160155042082039327023087624221369863839600936983257267541608243544126907151841927930736892593627428803758420945086420352362557302104968721277935861999756612100507872003486
math.1703 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000221777449283321609953810222196628583384816065454046308523431187268968178146297487492730088010529594056750218758814575804551371529499879883778259934312878664254880406546840305422708408585571706003521658825799598880032428125359773288018228737072118650418821665687632275397953325482710909559947772362142923409652279553121004092111732790185649524724461480526240366141255255013251460032410738944949957499075808439677448765349835763586471621157236207911802163102584584820789459423772940658392876790205217906945762781719768939334456439037297625
math.1705 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000055444362320830402488452555549157145846204016363511577130857796817242044536574371873182522002632398514187554689703643951137842882374969970944564983578219666063720101636710076355677102146392926500880414706449899720008107031339943322004557184268029662604705416421908068849488331370677727389986943090535690564876199038973860285074794195123512878187525738700937046973475532083811858288389238422131256281058935280968606963674453425510571859670469968359041593984472388201151644835780642837187639880982381328377045506291599407768858070966091762
math.1707 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000013861090580207600622113138887289286461551004090877894282714449204310511134143592968295630500658099628546888672425910987784460720593742492736141245894554916515930025409177519088919275536598231625220103676612474930002026757834985830501139296067007415651176354105477017212372082842669431847496735772633918164826064109820532767051683104067222719214260364516276145680942407279897297158795815570632121504296954172580956715622723854668082293182190927243214959963765457272060608984482650450695734490626826093387661911113088465297767765783883268
math.1709 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000003465272645051900155528284721822321615387751022719473570678612301077627783535898242073907625164524907136722168106477746946115180148435623184035311473638729128982506352294379772229818884149557906305025919153118732500506689458746457625284824016751853912794088526369254303093020710667357961874183943158479043829517621908140713516585726604177290877718305555851467968854882293190361243776565666557953424300040804516217509428359907921513831991611446827854246820679959898212118665624828139496025236032398830157293314949404464664397408389389156
math.1711 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000866318161262975038882071180455580403846937755679868392669653075269406945883974560518476906291131226784180542026619436736528795037108905796008827868409682282245626588073594943057454721037389476576256479788279683125126672364686614406321206004187963478198522131592313575773255177666839490468545985789619705693268471527369347462886981716307835061002155769716470497615862848099372194730542724850590916988988230170274191859609859675322153408576607819969173575140945039019359268573336537854238710494287741629365310645254727937928056441396582
math.1713 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000216579540315743759720517795113895100961734438919967098167413268817351736470993640129619226572782806696045135506654859184132198759277226449002206967102420570561406647018398735764363680259347369144064119947069920781281668091171653601580301501046990869549630532898078393943313794416709872617136496447404920282860347442990577875026250991884015692091936651401740236115314853669485480214458048791659124904355727436037416242960229662713171175552345967548472490448675711362209772939681857016918833344259494750679325651080751053619251205195076
math.1715 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000054144885078935939930129448778473775240433609729991774541853317204337934117748410032404806643195701674011283876663714796033049689819306612250551741775605142640351661754599683941090920064836842286016029986767480195320417022792913400395075375261747717387407633224519598485828448604177468154284124111851229388442112367541893469790396699394010248227583908291837571441200840266776084668261441928916047410212117402728117202746475720554140885377885826615582466685884422463593549434514655649047392305030158059151831189410973283936772683431401
math.1717 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000013536221269733984982532362194618443810108402432497943635463329301084483529437102508101201660798925418502820969165928699008262422454826653062637935443901285660087915438649920985272730016209210571504007496691870048830104255698228350098768843815436929346851908306129899621457112151044367038571031027962807271302419814862612145340247391673281042635184837677559672017230446383294545013137241563451374761900049966650780760909554297346962787065560271623724988235217271685125176936361351845019368517253682222730402216979497271985316503902780
math.1719 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000003384055317433496245633090548654610952527100608124485908865832325271120882359275627025300415199731354625705242291482174752065605613706663265659483860975321415021978859662480246318182504052302642876001874172967512207526063924557087524692210953859232336712977076532474905364278037761091759642757756990701809402481811824224011656467205343295647389717193931012171243966526742112583347292297177665328458180237004548112019141048059582121537402066602902578955010331669706750937520505081064894566622757436412120649934203402535041441094336741
math.1721 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000846013829358374061408272637163652738131775152031121477216458081317780220589818906756325103799932838656426310572870543688016401403426665816414870965243830353755494714915620061579545626013075660719000468543241878051881515981139271881173052738464808084178244269133118726341069509440272939910689439247675451414717881634786111283161841049710065928642741206266626504287066701782473291712850604061052644290084197013185430220113068811683811087814043503050039636085956513962139189727908388850277710516471975967723525768464880115406633834055
math.1723 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000211503457339593515352068159290913184532943788007780369304114520329445055147454726689081275949983209664106577643217635922004100350856666454103717741310957588438873678728905015394886406503268915179750117135810469512970378995284817970293263184616202021044561067283279681585267377360068234977672359811918862749690295817444317639573242452859311380073290048623721480882370566140543595693743352086898775488634932128424960381122828749160222409430998962140876673855160138187690887387714666393306767054352757651659886132962247402678373999387
math.1725 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000052875864334898378838017039822728296133235947001945092326028630082361263786863681672270318987495802416026644410804408980501025087714166613525929435327739397109718419682226253848721601625817228794937529283952617378242594748821204492573315796154050505261140266820819920396316844340017058744418089952979715675868221221999722723091397523262805055897500817384493131866215296056794262564050360363017539918393608907120529298180102914649974450966359527910593253445309035624384509619788396507297507255280940930662638721112342670048909668402
math.1727 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000013218966083724594709504259955682074033308986750486273081507157520590315946715920418067579746873950604006661102701102245125256271928541653381482358831934849277429604920556563462180400406454307198734382320988154344560648687205301123143328949038512626315285066705204980099079211085004264686104522488244928917683238335237557715572636815265476509627617238260408034260511896738827272712191981462009145651402277324003942235978291920591373484809213191686023211692607147914702992713042624672265578535119429845748733812263839091891784282885
math.1729 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000003304741520931148677376064988920518508327246687621568270376789380147578986678980104516894936718487651001665275675275561281314067982135413345370589707983712319357401230139140865545100101613576799683595580247038586140162171801325280785832237259628156578821266676301245024769802771251066171526130622061232229278163253780236877204246696533010821368375646666689203153345537820776674519290149962308370931939888786248075549153824779251052245876483665666880791626627330201854288768049047895337639269479767974001969467731043486793151664305
math.1731 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000826185380232787169344016247230129627081811671905392067594197345036894746669745026129223734179621912750416318918818890320328516995533853336342647426995928079839350307534785216386275025403394199920898895061759646535040542950331320196458059314907039144705316669075311256192450692812766542881532655515308057303691221219597824668960284435101782448924060233515322409249447081424152667738332445777768790661563247145028886195039728046452936432918735055095196651487448464150076701988749943531214776892154272674357479673325728789437797839
math.1733 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000206546345058196792336004061807532406770452917976348016898549336259223686667436256532305933544905478187604079729704722580082129248883463334085661856748982019959837576883696304096568756350848549980224723765439911633760135737582830049114514828726759786176329167268827814048112673203191635720383163878827014324161739502070412319228805586758676401878809343583610782413813173270480837814115884244517315185012039628813888093935880148689886881984996945815465690075263884224908565494575038071337578614395488076796604667283082985265987310
math.1735 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000051636586264549198084001015451883101692613229494087004224637334064805921666859064133076483386226369546901019932426180645020532312220865833521415464187245504989959394220924076024142189087712137495056180941359977908440033934395707512278628707181689946544082291817206953512028168300797908930095790969706753580844760897425487096694838560910028077097235034251989382281392338085891617329032612483359897409544257445265323861836853163514322028691284034458496036652527278632603740262242376427671492919305196453444399472259843056083952137
math.1737 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000012909146566137299521000253862970775423153307373521751056159333516201480416714766033269120846556592386725254983106545161255133078055216458380353866046811376247489848555231019006035547271928034373764045235339994477110008483598926878069657176795422486636020572954301738378007042075199477232523947742426688395189448671235025553827891547363102461121812391713673644090119089495725282985091891056643370864973980754434314503053978082694341652527824875059582855177988631611081668275404884874677550814904779606055016346447079909550709179
math.1739 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000003227286641534324880250063465742693855788326843380437764039833379050370104178691508317280211639148096681313745776636290313783269513804114595088466511702844061872462138807754751508886817982008593441011308834998619277502120899731719517414294198855621659005143238575434594501760518799869308130986935606672098794946439684162363974104209855841775485731279389604666413615439593292696152143388090361220106531041454510576796607357275319781095949178870592113363351703470341984942981056142415087129657623803845146411473098672104668757665
math.1741 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000806821660383581220062515866435673463947081710845109441009958344762592526044672877079320052909787024170328436444159072578445817378451028648772116627925711015468115534701938687877221704495502148360252827208749654819375530224932929879353573549713905414751285809643858648625440129699967327032746733901668024698468195684974588273207310576745572783130395565310750535746711811585549083132559836612569181109154393172310662578935180457300349855875012295496968566504346745408960846620137958929309298172351955023564800106546040309531695
math.1743 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000201705415095895305015628966608918365986770427711277360252489586190648131511168219269830013227446756042582109111039768144611454344612757162193029156981427753867028883675484671969305426123875537090063206802187413704843882556233232469838393387428476353687821452410964662156360032424991831758186683475417006174587225117236313432710856323384740852637885082206530293085883721036651164682774716266727201330221268242485050469966668628475651449366563590259645222579251037453654111805712529194274756072688099171109192452400733870976511
math.1745 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000050426353773973826253907241652229591496692606927819340063122396547662032877792054817457503306861689010645527277759942036152863586153189290548257289245356938466757220918871167992326356530968884272515801700546853426210970639058308117459598346857119088421955363102741165539090008106247957939546670868854251543643492523308263509778717267423779397254503069538170646510271571163636557159541985412635678782881169277222083153628653103135642194052508732718844981306275465041348405745947914461007292521460925950023741715962875000365638
math.1747 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000012606588443493456563476810413057397874173151731954835015780599136915508219448013704364375826715422252661381819439985509038215896538297322637064322311339234616689305229717791998081589132742221068128950425136713356552742659764577029364899586714279772105488840775685291384772502026561989484886667717213562885910504935715864227622568559809010869768629300605269114209656852891406224399757530391598239523534275898927834181311272825341324918703223609307926098177842500224552087858100287744411667964063998282755540273753240031493799
math.1749 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000003151647110873364140869202603264349468543287932988708753945149784228877054862003426091093956678855563165345454859996377259553974134574330659266080577834808654172326307429447999520397283185555267032237606284178339138185664941144257341224896678569943026372210193921322846193125506640497371221666929303390721477585323361054762480963166947037830826046606620286884394868542122906787778814053046615039861751789372467771144539385934063932826363594394119005397083491028829939687122482106283787344194760306992383285606745256816918160
math.1751 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000787911777718341035217300650816087367135821983247177188486287446057219263715500856522773489169713890791336363714999094314888493533643582664816520144458702163543081576857361999880099320796388816758059401571044584784546416235286064335306224169642485756593052548480330711548281376660124342805416732325847680369391785221606880128609794736180025860277127373846121747878727630732833797911809978177702185534416276198699741602798453263605606222875097617754001775209468737907329020393530387356216849106110906061865905942641627456730
math.1753 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000196977944429585258804325162704021841783955495811794297121571861514304815928875214130693372292428472697834090928749773578722123383410895666204130036114675540885770394214340499970024830199097204189514850392761146196136604058821516083826556042410621439148263137120082677887070344165031085701354183081461920092347441236662074421971226795091736259932112478880908286876525474350556988723318796380419126394322839392092374897138721065637223737049496525327684055395335132301544170628716354217874301211642632956138088069696787222759
math.1755 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000049244486107396314701081290676005460445988873952948574280392965378576203982218803532673343073107118174458522732187443394680530845852723916551032509028668885221442598553585124992506207549774301047378712598190286549034151014705379020956639010602655359787065784280020669471767586041257771425338545770365480023086804190416669093250448711111459597745564856989046832819891764884011307096981510410215179377549462108291698112777914460824397287743565478097385859581385777278131811049438394929893029629034536732442478860094905734421
math.1757 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000012311121526849078675270322669001365111497218488237143570098241344644050995554700883168335768276779543614630683046860848670132711463180979137758127257167221305360649638396281248126551887443575261844678149547571637258537753676344755239159752650663839946766446070005167367941896510314442856334636442591370005771694812187628438619016845815478847521117518388241681660612985253933055653817801082010505708717226889324991682471504636807776138989357074720509225532296665897615815917055077218631530110161287349044837141987138536797
math.1759 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000003077780381712269668817580667250341277874304622059285892524560336161012748888675220792083942069194885903657670761715212167533177865795244784439531814291805326340162409599070312031637971860893815461169537386892909314634438419086188809789938162665959986691611517501291841985474127578610714083659110647842501442923010222847239133243619013604595000804524501613750799113251206031067122295830657108927634327069095914810937759767939379908125531057680368589835342735302205302049885341044692008801716751727744587233444048274867887
math.1761 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000769445095428067417204395166812585319468576155514821473131140084040253187222168805198020985517298721475914417690428803041883294466448811196109882953572951331585040602399767578007909492965223453865292384346723227328658609604771547202447484540666489996672902879375322960496368531894652678520914777661960625360730675575260713058698616704482802430259480559242696631329424456235300470445222151677932042709296426599098625233485515975861930358733132501976628720090618410314189794232736216041191450211421481405255489740012076271
math.1763 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000192361273857016854301098791703146329867144038878705368282785021010063296805542201299505246379324680368978604422607200760470823616612202799027470738393237832896260150599941894501977373241305863466323096086680806832164652401192886800611871135166622499168225719843830740124092132973663169630228694415490156340182660340431723073051066615129773238682464521348369594671368520139662194263668258741783025580382901385374199729876215786286026920346473393252953833845631586910622706657903503236852420444354208713363553404774503434
math.1765 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000048090318464254213575274697925786582466786009719676342070696255252515824201385550324876311594831170092244651105651800190117705904153050699756867684598309458224065037649985473625494343310326465866580774021670201708041163100298221700152967783791655624792056429960957685031023033243415792407557173603872539085045664134731991302526812480339006935350348839396836336094399064043897445971735144776812424717657813650299054757080702479051567211271417266953104753330627561653441816453333592389941389321255089774124186236723790788
math.1767 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000012022579616063553393818674481446645616696502429919085517674063813128956050346387581219077898707792523061162776412950047529426476038262674939216921149577364556016259412496368406373585827581616466645193505417550427010290775074555425038241945947913906198014107490239421257755758310853948101889293400968134771261415928085671218327708211924369914468668621966958410404328314234194572315802461759910513770810241001903153114227025456705120745171720863253816887762570186516225580756539811050899601131443387731951412990906521578
math.1769 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000003005644904015888348454668620361661404174125607479771379418515953282239012586596895304769474676948130765290694103237511882356619009565668734804230287394341139004064853124092101593396456895404116661298376354387606752572693768638856259560486486978476549503526872559855314438939577713487025472323350242033692815353970288381514881483174296605609798398423504822861087829695027795333170380468280611784841746536649290053770218628568280972290998915387648514299655077357307152520371713443090882039594097470853923449517918360826
math.1771 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000751411226003972087113667155090415351043531401869942844854628988320559753146649223826192368669237032691322673525809377970589154752391417183701057571848585284751016213281023025398349114223851029165324594088596901688143173442159714064890121621744619137375881718139963828609734894428371756368080837560508423203838491268424679864765918164763972580847524544326077326040492253531798858309545163556741365885964873301876274961531831415208862161504977116024139104262096068798810668770415253626858710883992593584817520612004699
math.1773 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000187852806500993021778416788772603837760882850467485711213657247080139938286662305956548092167309258172830668381452344492647288688097854295925264392962146321187754053320255756349587278555962757291331148522149225422035793360539928516222530405436154784343970429534990957152433723607092939092020209390127105800959622672253870093346493384592389826461649876983781781963797340781056999656767190156273692076972408434287161230035701114353969919462480968327764130564719210756444953397276533507420101316512023963310506945491674
math.1775 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000046963201625248255444604197193150959440220712616871427803414311770034984571665576489137023041827314543207667095363086123161822172024463573981316098240536580296938513330063939087396819638990689322832787130537306355508948340134982129055632601359038696085992607383747739288108430901773234773005052347531776450239905651968767537464958217637141532309831218235085717763579810461720614923011897457633795308741012120662689473025896751983131855319646540895466516474423713084304825705393880054711183506407325498283863046649641
math.1777 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011740800406312063861151049298287739860055178154217856950853577942508746142916394122284255760456828635801916773840771530790455543006115893495329024560134145074234628332515984771849204909747672330708196782634326588877237085033745532263908150339759674021498151845936934822027107725443308693251263086882944112559976411203891885936054540130290280376837665557564793026742783200591972065066318799804601303796131920397994497758359907261854005547025668425369460655633029426097716132578997422328480118521755764288325351693157
math.1779 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000002935200101578015965287762324571934965013794538554464237713394485627186535729098530571063940114207158950479193460192882697613885751528973373832256140033536268558657083128996192962301227436918082677049195658581647219309271258436383065977037584939918505374537961484233705506776931360827173312815771720736028139994102602272971658437522334906447571918289833701571988446565865165972831190284637217389490016908412347534416606466167845026950466435754128731568668022379707082374556059252400987751612065986095485121292371150
math.1781 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000733800025394503991321940581142983741253448634638616059428348621406796633932274632642765985028551789737619798365048220674403471437882243343458064035008384067139664270782249048240575306859229520669262298914645411804827317814609095766494259396234979626343634490371058426376694232840206793328203942930184007034998525628490465156212034728430376057169447285570990078418404806849046520566871707889485057400657706669998692170158340964541565292128864868003914778573830743499254252671980105292008078842668429917173651364772
math.1783 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000183450006348625997830485145285745935313362158659654014857087155351699158483068658160691496257137947434404949591262055168600867859470560835864516008752096016784916067695562262060143826714807380167315574728661352951206829453652273941623564849058744906585908622592764606594173558210051698332050985732546001758749631404669529871453303587074678921424570135520036084194241572885323109338306876815164340449767827065623571711266451797055927731423319143203314540373261665511331409129902471328009817024686208151059338204747
math.1785 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000045862501587156499457621286321436483828340539664913503714271788837924789620767164540172874064284486858601237397815513792150216964867640208966129002188024004196229016923890565515035956678701845041828893682165338237801707363413068485405891212264686226646477155648191151648543389552512924583012746433136500439687407850894817310352247552876123608926387902116374417114075990018337608356419935852990315790175667921752992779897375899921819311565952333156643729063293636337445946278243111721447765068840341001294381813804
math.1787 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011465625396789124864405321580359120957085134916228375928567947209481197405191791135043218516071121714650309349453878448037554241216910052241532250547006001049057254230972641378758989169675461260457223420541334559450426840853267121351472803066171556661619288912047787912135847388128231145753186608284125109921851962693419310086830961119859110961624238666467537174687397148696272202643119146491937911736551553254592622983317636164658981081501699662029276040265433524318497013534943918078086913062172912937989593742
math.1789 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000002866406349197281216101330395089780239271283729057093982141986802370299351297947783760804629017780428662577337363469612009388560304227513060383062636751500262264313557743160344689747292418865315114305855135333639862606710213316780337868200766542889165404822228011946978033961847032057786438296652071031277480462990669989825577126526157834578710409088904102876837690560358742053618831683695872357696177763951959908647746826482506076317847043604512492690540559916652185958747158643311487982355582441857413874525134
math.1791 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000716601587299320304025332598772445059817820932264273495535496700592574837824486945940201157254445107165644334340867403002347140076056878265095765659187875065566078389435790086172436823104716328778576463783833409965651677553329195084467050191635722291351205557002986744508490461758014446609574163017757819370115747667123567289328163303666400340935942141301940603202496875415289578949132469440242003849288328395117216603484073233731476414724032194454880582972596748724971297209094975868491214153043645373399423139
math.1793 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000179150396824830076006333149693111264954455233066068373883874175148143709456121736485050289313611276791411083585216850750586785019014219566273941414796968766391519597358947521543109205776179082194644115945958352491412919388332298771116762547908930572837801389250746686127122615439503611652393540754439454842528936916739348588448322133050795158937726637022843083442830528379353080764084400190299676496194008810461532447179624153678690987343578167095021028835662252256629669904433093744511206344642375901119943769
math.1795 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000044787599206207519001583287423277816238613808266517093470968543787035927364030434121262572328402819197852770896304212687646696254753554891568485353699242191597879899339736880385777301444044770548661028986489588122853229847083074692779190636977232643209450347312686671531780653859875902913098385188609863710632234229180221232236111789610942686812625114999861652265397222042119457527332353695379271961145382948357852922495862243446986289465068999382788688663639236961422622543014867855837624120202978926143329052
math.1797 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011196899801551879750395821855819454059653452066629273367742135946758981841007608530315643082100704799463192724076053171911674063688388722892121338424810547899469974834934220096444325361011192637165257246622397030713307461770768673194797659244308160802362586828171667882945163464968975728274596297152465927658058557294542428628364753663651660267399996054871066555759259949116662974756561051378634972185999153283070987368516250309225854880619967357811997883101328562274011754298894121704941867166565281631759275
math.1799 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000002799224950387969937598955463954863514913363016657318341935533986689745460251902132578910770525176199865798181019013292977918515922097180723030334606202636974867493708733555024111081340252798159291314311655599257678326865442692168298699414811077040200590646707042916970736290866242243932068649074288116481914514639323578620553684166889348024907321523158707283693318698813788810031791748332570638407702016834564501942035968028071470828443971960451910202328241056509670542507301965436842406115360065825974153931
math.1801 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000699806237596992484399738865988715878728340754164329585483883496672436365062975533144727692631294049966449545254753323244479628980524295180757583651550659243716873427183388756027770335063199539822828577913899814419581716360673042074674853702769260050147661676760729242684072716560560983017162268572029120478628659830888323293598039330496462875771661250231211707149550684170496317737115757556657342442783880445984840530529669850552636524750431069917239788445344612873417801128518237701287156458730290445340051
math.1803 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000174951559399248121099934716497178969682085188541082396370970874168109091265743883286181923157823512491612386313688330811119907245131073795189395912887664810929218356795847189006942583765799884955707144478474953604895429090168260518668713425692315012536915419190182310671018179140140245754290567143007280119657164957721377285085842900197388679936390919286068569434040557789656724966409903212941862334838155867591694023914379999603151288271767873805942081154122873824552469649132545924286858850095220828201854
math.1805 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000043737889849812030274983679124294742420521297135270599092742718542027272816435970821545480789455878122903096578422082702779976811282768448797348978221916202732304589198961797251735645941449971238926786119618738401223857272542065129667178356423078753134228854797545577667754544785035061438572641785751820029914291239430266150347719954779710832316706130569102213763693793530417808522950360672544079664169781828686310605009924170674675839521737535821111312959951465190160119564172357203178944683125210564480112
math.1807 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010934472462453007568745919781073685605130324283817649773185679635506818204108992705386370197363969530725774144605520675694994202820692112199337244555479050683076147299740449312933911485362492809731696529904684600305964318135516282416794589105769688283557213699386394416938636196258765359643160446437955007478572809857557851928736569776079226116133021614229450263721632169604855161998466264725865924982472441814731773367073172754656517375300558107458471870145727045764696796808558269917761723070347680834434
math.1809 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000002733618115613251892186479945268421401282581070954412443296419908876704551027248176346592549340992382681443536151380168923748550705173028049834311138869762670769036824935112328233477871340623202432924132476171150076491079533879070604198647276442422070889303424846598604234659049064691339910790111609488751869643202464388497909051540341925530755361754178218906657352428463179036349528602799135893815572287775414033401354500752087107191287699158877106911704220638511243914966509413897381998825466369702399098
math.1811 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000683404528903312973046619986317105350320645267738603110824104977219176137756812044086648137335248095670360884037845042230937137676293257012458577784717440667692259206233778082058369467835155800608231033119042787519122769883469767651049661819110605517722325856211649651058664762266172834977697527902372187967410800616097017246914818185248685380654716186183787118940553829214517149496482503445576491040479684404658401228928794566048249149021902980414760563464515933344616604661495066556895083555346068065384
math.1813 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000170851132225828243261654996579276337580161316934650777706026244304794034439203011021662034333812023917590221009461260557734284419073314253114644446179360166923064801558444520514592366958788950152057758279760696879780692470867441912762415454777651379430581464052912412764666190566543208744424381975593046991852700154024242397245586001841871644254154340060286830246521425461380183164601937379350015776498558940181272628377043813097779101377377218563471545022724128395447247058056165773823257243142477290303
math.1815 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000042712783056457060815413749144819084395040329233662694426506561076198508609800752755415508583453005979397555252365315139433571104768328563278661111544840041730766200389611130128648091739697237538014439569940174219945173117716860478190603863694412844857645366013228103191166547641635802186106095493898261747963175038506059275479938884408212388740258062072220602062895130605095145323426185624610380945944488383824948414999243750117302199135666690580843597828636048216561044641478752458411312794597392686349
math.1817 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010678195764114265203853437286204771098760082308415673606626640269049627152450188188853877145863251494849388813091328784858392776192082140819665277886210010432691550097402782532162022934924309384503609892485043554986293279429215119547650965923603211214411341503307025797791636910408950546526523873474565436990793759626514671777600541540691372482477790746627249904753202011246019612220513215016248236688327501376196021294809026067420819094063604416319311854154013844995731480032433782931216919072878545340
math.1819 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000002669548941028566300963359321551192774690020577103918401656660067262406788112547047213469286465812873712347203272832196214598194048020535204916319471552502608172887524350695633040505733731077346125902473121260888746573319857303779886912741480900802803602835375826756449447909227602237636631630968368641359247698439906628651600801893211688207042554256045387045741636013765030641934317791282516690170305660253724044440606479821909976901363532226856425207118760170326899540683303969075547069643148611900085
math.1821 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000667387235257141575240839830387798193672505144275979600414165016815601697028136761803367321616453218428086800818208049053649548512005133801229079867888125652043221881087673908260126433432769336531475618280315222186643329964325944971728185370225200700900708843956689112361977306900559409157907742092160339811924609976657161084245113061423758863075764940094565131569860470393120153719743707158353443813479327695455047405261907187841080517551537353255788352492450011241619372303310116643908012273863226549
math.1823 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000166846808814285393810209957596949548418126286068994900103541254203900424257034190450841830404113304607021700204552012263412387128001283450307269966972031413010805470271918477065031608358192334132868904570078805546660832491081486242932046342556300175225177210989172278090494326725139852289476935523040084952981152494164290069288460460745018282706408004884508360243671454168886668445524358626164016646376972397690865990609026986998809593462159964886112262878935550534486421017751734467325958789211390140
math.1825 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000041711702203571348452552489399237387104531571517248725025885313550975106064258547612710457601028326151755425051138003065853096782000320862576817491743007853252701367567979619266257902089548083533217226142519701386665208122770371560733011585639075043806294302747293069522623581681284963072369233880760021238245288123541072494902913136896152189225209420094556765322163012050066848224224248749493854794150592040959061402018206767865095672151570616396213085137047559602964002803540623095314706999607912369
math.1827 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010427925550892837113138122349809346776132892879312181256471328387743776516064636903177614400257081537938856262784500766463274195500080215644204372935751963313175341891994904816564475522387020883304306535629925346666302030692592890183252896409768760951573575686823267380655895420321240768092308470190005309561322030885268121234705842191804449367258734898464710804012436180055065513038635419923780435488353448188248117656323916534650948458562723562907162330630075675112378206341010160326812005713651963
math.1829 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000002606981387723209278284530587452336694033223219828045314117832096935944129016159225794403600064270384484714065696125191615818548875020053911051093233937990828293835472998726204141118880596755220826076633907481336666575507673148222545813224102442190237893393921705816845163973855080310192023077117547501327390330507721317030031896189211036268126365392599596790975833296063629138984591055880819869190755500077374671225764277892974593518272492910831155000698920650671486025385524791916359273585407487865
math.1831 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000651745346930802319571132646863084173508305804957011328529458024233986032254039806448600900016067596121178516424031297903954637218755013477762773308484497707073458868249681551035279720149188805206519158476870334166643876918287055636453306025610547559473348480426454211290993463770077548005769279386875331847582626930329257477220683820879639896541426913785932552272789240197881702406808084187069973453698543268957717146646908114862910807884586590058551298759399529283498661263369020898437350127324730
math.1833 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000162936336732700579892783161715771043377076451239252832132364506058496508063509951612150225004016899030294629106007824475988659304688753369440693327121124426768364717062420387758819930037297201301629789619217583541660969229571763909113326506402636889868337120106613552822748365942519387001442319846718832961895656732582314365888130568344418070240921035545009227880915668303981198519373589267001124003960582920049419365059219792184008950833519856655726838470876200255540478080527926536678110173548156
math.1835 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000040734084183175144973195790428942760844269112809813208033091126514624127015877487903037556251004224757573657276501956118997164826172188342360173331780281106692091179265605096939704982509324300325407447404804395885415242307392940977278331626600659222467084280026653388205687091485629846750360579961679708240473914183145578591092361487988827639349737404119421872504975401326496496620695793785665128849938584296991242627753415255098033487581976987401830488926721974278847987605097056224399391170244481
math.1837 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010183521045793786243298947607235690211067278202453302008272781628656031753969371975759389062751056189393414319125489029749291206543047085590043332945070276673022794816401274234926245627331075081351861851201098971353810576848235244319582906650164805616771070006663347051421772871407461687590144990419927060118478545786394647730904688208620590036268478277985419852326793026124257154157548054073487529034472581689909299881532736780289621881449471654668597710458596260263426688492605677236499306656391
math.1839 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000002545880261448446560824736901808922552766819550613325502068195407164007938492342993939847265687764047348353579781372257437322801635761771397510833236267569168255698704100318558731561406832768770337965462800274742838452644212058811079895726662541201404192767501665836762855443217851865421897536247604981765029619636446598661928038873853423334197826467041510794043757580778142190177315342525480283584097487757360488285297403064529048099913246281780801702258589993808460459981814078266102086106008017
math.1841 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000636470065362111640206184225452230638191704887653331375517048851791001984623085748484961816421941011837088394945343064359330700408940442849377708309066892292063924676025079639682890351708192192584491365700068685709613161053014702769973931665635300351048191875416459190713860804462966355474384061901245441257404909111649665481488907552385632070429877590601525075458937696936783754192830688254727751784246340666567733582908530613814879916409783097104264768089203423603404252085844771724739446429106
math.1843 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000159117516340527910051546056363057659547926221913332843879262212947750496155771437121240454105485252959272098736335766089832675102235110712344427077266723073015981169006269909920722587927048048146122841425017171427403290263253675692493482916408825087762047968854114797678465201115741588868596015475311360314351227277912416370314359009099718964382276156564139776033572480056555517421984900606421588586047629758469229202233550929181814972224469402265381659071379186066216535980608437953320186043621
math.1845 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000039779379085131977512886514090764414886981555478333210969815553236937624038942859280310113526371313239818024684083941522458168775558777678086106769316680768253995292251567477480180646981762012036530710356254292856850822565813418923123370729102206271940511992213528699419616300278935397217149003868827840078587806819478104092572159987941964290737214234575897000360486237327734388119249250545243136106510356838709229056836878651820797631180786642565158244439964610979372519879501803379678415892721
math.1847 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000009944844771282994378221628522691103721745388869583302742453888309234406009735714820077528381592828309954506171020985380614542193889694419521526692329170192063498823062891869370045161745440503009132677589063573214212705641453354730780842682275551567985127998053382174854904075069733849304287250967206960019646951704869526023142325578726272689311153024803403367462576350144555320225784871013381643911071861365131965237129051987346904284253493248641157653295782243240711839512580972388402756126715
math.1849 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000002486211192820748594555407130672775930436347217395825685613472077308601502433928705019382095398207077488626542755246345153635548472423604880381673082292548015874705765722967342511290436360125752283169397265893303553176410363338682695210670568887891996281999513345543713726018767433462326071812741801740004911737926217381505785502014874988351952993752440787410462583508737541243744887613128575506520483995580777953306273355477324693279558739599715830312455700126420830038716223634379709928159849
math.1851 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000621552798205187148638851782668193982609086804348956421403368019327150375608482176254845523849551769372156635688811586288408887118105901220095418270573137003968676441430741835627822609090031438070792349316473325888294102590834670673802667642221972999070499878336385928431504691858365581517953185450435001227934481554345376446366683740238219057715715470189804681972479540096690234937613879391665023756113366249484104011793589385391898611392265212906566906342205561946629549953507626328508609759
math.1853 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000155388199551296787159712945667048495652271701087239105350842004831787593902120544063711380962387942343039158922202896572102221779526475305023854567643284250992169110357685458906955652272507859517698087329118331472073525647708667668450666910555493249767624969584096482107876172964591395379488296362608750306983620388586344111590690937447458216591959685324445844529409035658770258591704647319892744120707727235148334607776699574594483399704440223665418259076348496791004039810332354515574549084
math.1855 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000038847049887824196789928236416762123913067925271809776337710501207946898475530136015927845240596985585759789730550724143025555444881618826255963641910821062748042277589421364726738913068126964879424521832279582868018381411927166917112666727638873312441906242396024120526969043241147848844872074090652187576745905097146586027897563845738298271054993345528555313803051053429647864632070737104637240272585752439095673496925097363453788488465707158187329735045842358231567304655022582843721125787
math.1857 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000009711762471956049197482059104190530978266981317952444084427625301986724618882534003981961310149246396439947432637681035756388861220404706563990910477705265687010569397355341181684728267031741219856130458069895717004595352981791729278166681909718328110476560599006030131742260810286962211218018522663046894186476274286646506974378862698622758531193161292965923191951518303518110600700414862233093872858529290919317245895821281952910193065270912021385230458877837783871414464026700623688891282
math.1859 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000002427940617989012299370514776047632744566745329488111021106906325496681154720633500995490327537311599109986858159420258939097215305101176640997727619426316421752642349338835295421182066757935304964032614517473929251148838245447932319541670477429582027619140149751507532935565202571740552804504630665761723546619068571661626743593371370661044162514381980000046880342185681002432588250962669566471668738198009523762519436682758387056778371744852724741062803321375915521141204925681257339846135
math.1861 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000606985154497253074842628694011908186141686332372027755276726581374170288680158375248872581884327899777496714539855064734774303826275294160249431904856579105438160587334708823855295516689483826241008153629368482312787209561361983079885417619357395506904785037437876883233891300642935138201126157666440430886654767142915406685898193475554744877263716790195407951458247098597597584626724995614751050576056800913599875188362627141078553493539227038895794055119445808830650588889087658936919680
math.1863 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000151746288624313268710657173502977046535421583093006938819181645343542572170039593812218145471081974944374178634963766183693575956568823540062357976214144776359540146833677205963823879172370956560252038407342120578196802390340495769971354404839348876726196259359469220808472825160733784550281539416610107721663691785728851671474531772543073312275387119237229346905972961132398222552679507595146999687515011176473218278111983179082344917896252743914007219811983877757703234739790508578891936
math.1865 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000037936572156078317177664293375744261633855395773251734704795411335885643042509898453054536367770493736093544658740941545923393989142205885015589494053536194089885036708419301490955969793092739140063009601835530144549200597585123942492838601209837219181549064839867305202118206290183446137570384854152526930415922946432212917868631099097366893953230993330238154397761149892321647459947461197837776260045509566126443400752587616305331401086446073110730550067676238944985873964671915349685430
math.1867 = 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000