/*
 * Decompiled with CFR 0.152.
 */
package jexifviewer;

import java.io.IOException;
import java.io.RandomAccessFile;
import jexifviewer.Main;
import shared.cvshelper.Cvs;
import shared.dataformathelper.JDataFormatHelper;

@Cvs(header="$Header: /home/reiner/cvs/Java/JExifViewer/src/jexifviewer/JTiffHeader.java,v 1.4 2010/04/02 12:12:13 reiner Exp $")
public final class JTiffHeader {
    private int m_ifdOffset = 0;
    private long m_offset = 0L;
    private boolean m_bIntel = true;

    public long getOffset() {
        return this.m_offset;
    }

    public int getIFDOffset() {
        return this.m_ifdOffset;
    }

    public boolean isIntel() {
        return this.m_bIntel;
    }

    public boolean read(RandomAccessFile randomAccessFile) {
        boolean bl = false;
        try {
            this.m_offset = randomAccessFile.getFilePointer();
            byte[] byArray = new byte[4];
            randomAccessFile.read(byArray, 0, 2);
            if (byArray[0] == byArray[1] && (byArray[0] == 73 || byArray[0] == 77)) {
                this.m_bIntel = byArray[0] == 73;
                randomAccessFile.read(byArray, 0, 2);
                if (JDataFormatHelper.buf2ToInt(byArray, 0, this.isIntel()) == 42) {
                    randomAccessFile.read(byArray, 0, 4);
                    this.m_ifdOffset = JDataFormatHelper.buf4ToInt(byArray, 0, this.isIntel());
                    bl = true;
                } else if (Main.m_settings.isDebug()) {
                    System.err.println("TIFF header byte order check failed!");
                }
            } else if (Main.m_settings.isDebug()) {
                System.err.println("Invalid byte order in TIFF header!");
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return bl;
    }
}

