/*
 * Decompiled with CFR 0.152.
 */
package jexifviewer;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.RenderingHints;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import shared.cvshelper.Cvs;
import shared.settings.JSettingsHelper;
import shared.table.JTableColSortData;

@Cvs(header="$Header: /home/reiner/cvs/Java/JExifViewer/src/jexifviewer/JSettings.java,v 1.10 2010/04/03 07:59:53 reiner Exp $")
public final class JSettings
extends JSettingsHelper {
    public static final String SETTINGS_FILE = "jexifviewer.properties";
    private static final String COMMENT = "JExifViewer settings";
    private static final String COLS = "Cols";
    private static final String COLWIDTH = "ColWIDTH";
    private static final String SORTCOL = "SortCol";
    private static final String SORTUP = "SortUp";
    private static final String SORTDEEP = "SortDeep";
    private static final String IMGDISPLAYTIMER = "ImgDisplayTimer";
    private static final String FILLLISTTIMER = "FillListTimer";
    private static final String JPGEXTENSTIONS = "JpgFileExtensions";
    private static final String HOMEDIR = "HomeDir";
    private static final String SIZE_W = "SizeW";
    private static final String SIZE_H = "SizeH";
    private static final String EXTENDEDSTATE = "ExtendedState";
    private static final String LOCATION_X = "Location_x";
    private static final String LOCATION_Y = "Location_y";
    private static final String DISPLAYALLIMAGES = "DisplayAllImages";
    private static final String SAVEIMAGE = "SaveImage";
    private static final String IMGCACHESIZE = "ImgCacheSize";
    private static final String IMGUSEPRELOAD = "ImgUsePreload";
    private static final String VERTRESIZEWEIGHT = "VertResizeWeight";
    private static final String HORRESIZEWEIGHT = "HorResizeWeight";
    private static final String VERTDIVIDERLOCATION = "VertDividerLocationDouble";
    private static final String HORDIVIDERLOCATION = "HorDividerLocationDouble";
    private static final String INTERPOLATION = "Interpolation";
    private static final String ZOOMDELTA = "ZoomDelta";
    private static final String IMGSCROLLDELTA = "ImgScrollDelta";
    private static final String DELCONFIRM = "DelConfirm";
    private static final String OVERWRITECONFIRM = "OverwriteConfirm";
    private static final String COPYDIRECTORY = "CopyDirectory";
    private static final String MOVEDIRECTORY = "MoveDirectory";
    private static final String IMGVIEWBACKCOLOR = "ImgViewBackColor";
    private static final String CALLGCAFTERCACHEOP = "CallGcAfterCacheOp";
    private static final String CALLGCINSETJPG = "CallGcInSetJpg";
    private static final String SLIDESHOWTIMER = "SlideshowTimer";
    private static final String SLIDESHOWLOOP = "SlideshowLoop";
    private static final String SLIDESHOWDIRECTION = "SlideshowDirection";
    private static final String TOOLTIPTAGS = "ToolTipTags";
    private static final String TOOLTIPBOLD = "ToolTipBold";
    private static final String TOOLTIPTABLE = "ToolTipTable";
    private static final String TOOLTIPDISMISSDELAY = "ToolTipDismissDelay";
    private static final String EXPORTJPEGOPTIMIZEDHUFTABLE = "ExportJpegOptimizedHufTable";
    private static final String EXPORTQUALITY = "ExpertQuality";
    private static final String EXPORTSCALEFACTOR = "ExportScaleFactor";
    private static final String EXPORTDIRECTORY = "ExportDirectory";
    private static final String EXPORTMIMETYPE = "ExportMIMEType";
    private static final String USEFULLSCREENMODE = "UseFullScreenMode";
    private static final String FULLSCREENPAGESIZE = "FullScreenPageSize";
    private static final String BATCHCONVERTRECURSIVE = "BatchRecursive";
    private static final String BATCHCONVERTSRCFORMATS = "BatchSourceFormats";
    private static final String BATCHCONVERTTARGETFORMAT = "BatchTargetFormat";
    private static final String BATCHCONVERTJPGQUALITY = "BatchJpgQuality";
    private static final String BATCHCONVERTJPGOPTHUF = "BatchJpgOptimizedHuffman";
    private static final String BATCHCONVERTSCALE = "BatchScale";
    private static final String DEF_COLS = "0,16,12,27,11,4";
    private static final String DEF_COLWIDTH = "53,17,79,22,46,45";
    private static final String DEF_IMGDISPLAYTIMER = "250";
    private static final String DEF_FILLLISTTIMER = "500";
    private static final String DEF_JPGEXTENSIONS = "jpg|jpeg|png|bmp";
    private static final String DEF_SIZE_W = "750";
    private static final String DEF_SIZE_H = "600";
    private static final String DEF_EXTENDEDSTATE = "0";
    private static final String DEF_LOCATION_X = "10";
    private static final String DEF_LOCATION_Y = "10";
    private static final String DEF_DISPLAYALLIMAGES = "true";
    private static final String DEF_SAVEIMAGE = "2";
    private static final String DEF_IMGCACHESIZE = "6";
    private static final String DEF_IMGUSEPRELOAD = "true";
    private static final String DEF_VERTRESIZEWEIGHT = "0.3";
    private static final String DEF_HORRESIZEWEIGHT = "0.5";
    private static final String DEF_VERTDIVIDERLOCATION = "220";
    private static final String DEF_HORDIVIDERLOCATION = "350";
    private static final String DEF_INTERPOLATION = "1";
    private static final String DEF_ZOOMDELTA = "0.01";
    private static final String DEF_IMGSCROLLDELTA = "3";
    private static final String DEF_DELCONFIRM = "true";
    private static final String DEF_OVERWRITECONFIRM = "true";
    private static final String DEF_COPYDIRECTORY = "";
    private static final String DEF_MOVEDIRECTORY = "";
    private static final String DEF_IMGVIEWBACKCOLOR = "-13421773";
    private static final String DEF_CALLGCAFTERCACHEOP = "false";
    private static final String DEF_CALLGCINSETJPG = "false";
    private static final String DEF_SLIDESHOWTIMER = "20000";
    private static final String DEF_SLIDESHOWLOOP = "false";
    private static final String DEF_SLIDESHOWDIRECTION = "1";
    private static final String DEF_TOOLTIPTAGS = "0,1,4,-1,33434,33437,34855,41989,37385,41987,-1,41986,34850,37380,37383,-1,41994,41992,41993,41991,41985,-1,271,272";
    private static final String DEF_TOOLTIPBOLD = "true";
    private static final String DEF_TOOLTIPTABLE = "true";
    private static final String DEF_TOOLTIPDISMISSDELAY = "20000";
    private static final String DEF_EXPORTJPEGOPTIMIZEDHUFTABLE = "true";
    private static final String DEF_EXPORTQUALITY = "0.85";
    private static final String DEF_EXPORTSCALEFACTOR = "1.0";
    private static final String DEF_EXPORTDIRECTORY = "";
    private static final String DEF_EXPORTMIMETYPE = "image/jpeg";
    private static final String DEF_USEFULLSCREENMODE = "true";
    private static final String DEF_FULLSCREENPAGESIZE = "10";
    private static final String DEF_BATCHCONVERTRECURSIVE = "true";
    private static final String DEF_BATCHCONVERTSRCFORMATS = Integer.toString(6);
    private static final String DEF_BATCHCONVERTTARGETFORMAT = Integer.toString(1);
    private static final String DEF_BATCHCONVERTJPGQUALITY = "0.85";
    private static final String DEF_BATCHCONVERTJPGOPTHUF = "true";
    private static final String DEF_BATCHCONVERTSCALE = "1.0";
    public short[] m_cols;
    public int[] m_colWidth;
    public JTableColSortData[] m_sortData;
    public String[] m_jpgExtensions;
    public String[] m_homeDir;
    public int[] m_toolTipTags;
    private int m_imgDisplayTimer;
    private int m_fillListTimer;
    private Dimension m_size;
    private int m_extendedState;
    private Point m_location;
    private boolean m_bDisplayAllImages;
    private int m_saveImage;
    private int m_imgCacheSize;
    private boolean m_bImgUsePreload;
    private float m_vertResizeWeight;
    private float m_horResizeWeight;
    private double m_vertDividerLocation;
    private double m_horDividerLocation;
    private Object m_interpolation;
    private float m_zoomDelta;
    private int m_imgScrollDelta;
    private boolean m_bDelConfirm;
    private boolean m_bOverwriteConfirm;
    private String m_copyDirectory;
    private String m_moveDirectory;
    private Color m_imgViewBackColor;
    private boolean m_bCallGcAfterCacheOp;
    private boolean m_bCallGcInSetJpg;
    private int m_slideShowTimer;
    private boolean m_bSlideShowLoop;
    private int m_slideShowDirection;
    private boolean m_bToolTipBold;
    private boolean m_bToolTipTable;
    private int m_toolTipDismissDelay;
    private boolean m_bExportJpegOptimizedHufTable;
    private float m_exportQuality;
    private float m_exportScaleFactor;
    private String m_exportDirectory;
    private String m_exportMimeType;
    private boolean m_bUseFullScreenMode;
    private int m_fullScreenPageSize;
    private boolean m_bBatchRecursive;
    private int m_batchSrcFormats;
    private int m_batchTargetFormat;
    private boolean m_bBatchJpgOptHuf;
    private float m_batchJpgQuality;
    private float m_batchScale;

    public JSettings(boolean bl) {
        super(bl);
    }

    protected String getComment() {
        return COMMENT;
    }

    public boolean isDisplayAllInages() {
        return this.m_bDisplayAllImages;
    }

    public void setDisplayAllInages(boolean bl) {
        this.m_bDisplayAllImages = bl;
    }

    public Point getLocation() {
        return this.m_location;
    }

    public void setLocation(Point point) {
        this.m_location = point;
    }

    public int getSaveImage() {
        return this.m_saveImage;
    }

    public void setSaveImage(int n) {
        this.m_saveImage = n;
    }

    public int getExtendedState() {
        return this.m_extendedState;
    }

    public void setExtendedState(int n) {
        this.m_extendedState = n;
    }

    public Dimension getSize() {
        if (this.m_size.getWidth() < 50.0) {
            this.m_size = new Dimension(50, (int)this.m_size.getHeight());
        }
        if (this.m_size.getHeight() < 50.0) {
            this.m_size = new Dimension((int)this.m_size.getWidth(), 50);
        }
        return this.m_size;
    }

    public void setSize(Dimension dimension) {
        this.m_size = dimension;
    }

    public int getImgDisplayTimer() {
        return this.m_imgDisplayTimer;
    }

    public void setImgDisplayTimer(int n) {
        this.m_imgDisplayTimer = n;
    }

    public int getFillListTimer() {
        return this.m_fillListTimer;
    }

    public void setFillListTimer(int n) {
        this.m_fillListTimer = n;
    }

    public int getSortDeep() {
        return this.m_sortData.length;
    }

    public void setSortDeep(int n) {
        JTableColSortData[] jTableColSortDataArray = new JTableColSortData[n];
        if (n > this.m_sortData.length) {
            System.arraycopy(this.m_sortData, 0, jTableColSortDataArray, 0, this.m_sortData.length);
            int n2 = n - this.m_sortData.length;
            for (int i = 0; i < n2; ++i) {
                jTableColSortDataArray[i + this.m_sortData.length] = new JTableColSortData(0, true);
            }
            this.m_sortData = jTableColSortDataArray;
        } else if (n < this.m_sortData.length) {
            System.arraycopy(this.m_sortData, 0, jTableColSortDataArray, 0, n);
            this.m_sortData = jTableColSortDataArray;
        }
    }

    public int getImgCacheSize() {
        return this.m_imgCacheSize;
    }

    public void setImgCacheSize(int n) {
        this.m_imgCacheSize = n;
    }

    public boolean isImgUsePreload() {
        return this.m_bImgUsePreload;
    }

    public void setImgUsePreload(boolean bl) {
        this.m_bImgUsePreload = bl;
    }

    public float getVertResizeWeight() {
        return this.m_vertResizeWeight;
    }

    public float getHorResizeWeight() {
        return this.m_horResizeWeight;
    }

    public double getVertDividerLocation() {
        return this.m_vertDividerLocation;
    }

    public void setVertDividerLocation(double d) {
        this.m_vertDividerLocation = d;
    }

    public double getHorDividerLocation() {
        return this.m_horDividerLocation;
    }

    public void setHorDividerLocation(double d) {
        this.m_horDividerLocation = d;
    }

    public Object getInterpolation() {
        return this.m_interpolation;
    }

    public void setInterpolation(Object object) {
        this.m_interpolation = object;
    }

    public float getZoomDelta() {
        return this.m_zoomDelta;
    }

    public void setZoomDelta(float f) {
        this.m_zoomDelta = f;
    }

    public int getImgScrollDelta() {
        return this.m_imgScrollDelta;
    }

    public void setImgScrollDelta(int n) {
        this.m_imgScrollDelta = n;
    }

    public boolean isDelConfirm() {
        return this.m_bDelConfirm;
    }

    public void setDelConfirm(boolean bl) {
        this.m_bDelConfirm = bl;
    }

    public boolean isOverwriteConfirm() {
        return this.m_bOverwriteConfirm;
    }

    public void setOverwriteConfirm(boolean bl) {
        this.m_bOverwriteConfirm = bl;
    }

    public String getCopyDirectory() {
        return this.m_copyDirectory;
    }

    public void setCopyDirectory(String string) {
        this.m_copyDirectory = string;
    }

    public String getMoveDirectory() {
        return this.m_moveDirectory;
    }

    public void setMoveDirectory(String string) {
        this.m_moveDirectory = string;
    }

    public Color getImgViewBackColor() {
        return this.m_imgViewBackColor;
    }

    public void setImgViewBackColor(Color color) {
        this.m_imgViewBackColor = color;
    }

    public boolean getCallGcAfterCacheOp() {
        return this.m_bCallGcAfterCacheOp;
    }

    public boolean getCallGcInSetJpg() {
        return this.m_bCallGcInSetJpg;
    }

    public int getSlideShowTimer() {
        return this.m_slideShowTimer;
    }

    public void setSlideShowTimer(int n) {
        this.m_slideShowTimer = n;
    }

    public boolean getSlideShowLoop() {
        return this.m_bSlideShowLoop;
    }

    public void setSlideShowLoop(boolean bl) {
        this.m_bSlideShowLoop = bl;
    }

    public int getSlideShowDirection() {
        return this.m_slideShowDirection;
    }

    public void setSlideShowDirection(int n) {
        this.m_slideShowDirection = n;
    }

    public boolean isToolTipBold() {
        return this.m_bToolTipBold;
    }

    public void setToolTipBold(boolean bl) {
        this.m_bToolTipBold = bl;
    }

    public boolean isToolTipTable() {
        return this.m_bToolTipTable;
    }

    public void setToolTipTable(boolean bl) {
        this.m_bToolTipTable = bl;
    }

    public int getToolTipDismissDelay() {
        return this.m_toolTipDismissDelay;
    }

    public void setToolTipDismissDelay(int n) {
        this.m_toolTipDismissDelay = n;
    }

    public boolean isExportJpegOptimizedHufTable() {
        return this.m_bExportJpegOptimizedHufTable;
    }

    public void setExportJpegOptimizedHufTable(boolean bl) {
        this.m_bExportJpegOptimizedHufTable = bl;
    }

    public float getExportQuality() {
        return this.m_exportQuality;
    }

    public void setExportQuality(float f) {
        this.m_exportQuality = f;
    }

    public float getExportScaleFactor() {
        return this.m_exportScaleFactor;
    }

    public void setExportScalefactor(float f) {
        this.m_exportScaleFactor = f;
    }

    public String getExportDirectory() {
        return this.m_exportDirectory;
    }

    public void setExportDirectory(String string) {
        this.m_exportDirectory = string;
    }

    public String getExportMimeType() {
        return this.m_exportMimeType;
    }

    public void setExportMimeType(String string) {
        this.m_exportMimeType = string;
    }

    public boolean getUseFullScreenMode() {
        return this.m_bUseFullScreenMode;
    }

    public void setUseFullScreenMode(boolean bl) {
        this.m_bUseFullScreenMode = bl;
    }

    public int getFullScreenPageSize() {
        return this.m_fullScreenPageSize;
    }

    public void setFullScreenPageSize(int n) {
        this.m_fullScreenPageSize = n;
    }

    public boolean getBatchRecursive() {
        return this.m_bBatchRecursive;
    }

    public void setBatchRecursive(boolean bl) {
        this.m_bBatchRecursive = bl;
    }

    public int getBatchSrcFormats() {
        return this.m_batchSrcFormats;
    }

    public void setBatchSrcFormats(int n) {
        this.m_batchSrcFormats = n;
    }

    public int getBatchTargetFormat() {
        return this.m_batchTargetFormat;
    }

    public void setBatchTargetFormat(int n) {
        this.m_batchTargetFormat = n;
    }

    public boolean getBatchJpgOptHuf() {
        return this.m_bBatchJpgOptHuf;
    }

    public void setBatchJpgOptHuf(boolean bl) {
        this.m_bBatchJpgOptHuf = bl;
    }

    public float getBatchJpgQuality() {
        return this.m_batchJpgQuality;
    }

    public void setBatchJpgQuality(float f) {
        this.m_batchJpgQuality = f;
    }

    public float getBatchScale() {
        return this.m_batchScale;
    }

    public void setBatchScale(float f) {
        this.m_batchScale = f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createDummy(String string) {
        Properties properties = new Properties();
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(string);
            properties.store(fileOutputStream, COMMENT);
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - void declaration
     */
    public void doSave(Properties properties) {
        void var4_12;
        StringBuilder stringBuilder = new StringBuilder();
        for (int n : this.m_cols) {
            if (stringBuilder.length() != 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append(Short.toString((short)n));
        }
        properties.setProperty(COLS, stringBuilder.toString());
        stringBuilder = new StringBuilder();
        for (int n : this.m_colWidth) {
            if (stringBuilder.length() != 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append(Integer.toString(n));
        }
        properties.setProperty(COLWIDTH, stringBuilder.toString());
        stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        for (JTableColSortData jTableColSortData : this.m_sortData) {
            if (stringBuilder.length() != 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append(Integer.toString(jTableColSortData.getSortCol()));
            if (stringBuilder2.length() != 0) {
                stringBuilder2.append(",");
            }
            stringBuilder2.append(Boolean.toString(jTableColSortData.getSortUp()));
        }
        properties.setProperty(SORTCOL, stringBuilder.toString());
        properties.setProperty(SORTUP, stringBuilder2.toString());
        properties.setProperty(SORTDEEP, Integer.toString(this.m_sortData.length));
        properties.setProperty(IMGDISPLAYTIMER, Integer.toString(this.m_imgDisplayTimer));
        properties.setProperty(FILLLISTTIMER, Integer.toString(this.m_fillListTimer));
        stringBuilder = new StringBuilder();
        for (String string : this.m_jpgExtensions) {
            if (stringBuilder.length() != 0) {
                stringBuilder.append("|");
            }
            stringBuilder.append(string);
        }
        properties.setProperty(JPGEXTENSTIONS, stringBuilder.toString());
        stringBuilder = new StringBuilder();
        for (String string : this.m_homeDir) {
            if (stringBuilder.length() != 0) {
                stringBuilder.append("|");
            }
            stringBuilder.append(string);
        }
        properties.setProperty(HOMEDIR, stringBuilder.toString());
        stringBuilder = new StringBuilder();
        for (int n : this.m_toolTipTags) {
            if (stringBuilder.length() != 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append(Integer.toString(n));
        }
        properties.setProperty(TOOLTIPTAGS, stringBuilder.toString());
        properties.setProperty(SIZE_W, new Integer((int)this.m_size.getWidth()).toString());
        properties.setProperty(SIZE_H, new Integer((int)this.m_size.getHeight()).toString());
        properties.setProperty(EXTENDEDSTATE, new Integer(this.m_extendedState).toString());
        properties.setProperty(LOCATION_X, new Integer((int)this.m_location.getX()).toString());
        properties.setProperty(LOCATION_Y, new Integer((int)this.m_location.getY()).toString());
        properties.setProperty(DISPLAYALLIMAGES, Boolean.toString(this.m_bDisplayAllImages));
        properties.setProperty(SAVEIMAGE, Integer.toString(this.m_saveImage));
        properties.setProperty(IMGCACHESIZE, Integer.toString(this.m_imgCacheSize));
        properties.setProperty(IMGUSEPRELOAD, Boolean.toString(this.m_bImgUsePreload));
        properties.setProperty(VERTRESIZEWEIGHT, Float.toString(this.m_vertResizeWeight));
        properties.setProperty(HORRESIZEWEIGHT, Float.toString(this.m_horResizeWeight));
        properties.setProperty(VERTDIVIDERLOCATION, Double.toString(this.m_vertDividerLocation));
        properties.setProperty(HORDIVIDERLOCATION, Double.toString(this.m_horDividerLocation));
        if (this.m_interpolation.equals(RenderingHints.VALUE_INTERPOLATION_BILINEAR)) {
            boolean bl = true;
        } else if (this.m_interpolation.equals(RenderingHints.VALUE_INTERPOLATION_BICUBIC)) {
            int n = 2;
        } else {
            boolean bl = false;
        }
        properties.setProperty(INTERPOLATION, Integer.toString((int)var4_12));
        properties.setProperty(ZOOMDELTA, Float.toString(this.m_zoomDelta));
        properties.setProperty(IMGSCROLLDELTA, Integer.toString(this.m_imgScrollDelta));
        properties.setProperty(DELCONFIRM, Boolean.toString(this.m_bDelConfirm));
        properties.setProperty(OVERWRITECONFIRM, Boolean.toString(this.m_bOverwriteConfirm));
        properties.setProperty(COPYDIRECTORY, this.m_copyDirectory);
        properties.setProperty(MOVEDIRECTORY, this.m_moveDirectory);
        properties.setProperty(IMGVIEWBACKCOLOR, Integer.toString(this.m_imgViewBackColor.getRGB()));
        properties.setProperty(CALLGCAFTERCACHEOP, Boolean.toString(this.m_bCallGcAfterCacheOp));
        properties.setProperty(CALLGCINSETJPG, Boolean.toString(this.m_bCallGcInSetJpg));
        properties.setProperty(SLIDESHOWTIMER, Integer.toString(this.m_slideShowTimer));
        properties.setProperty(SLIDESHOWLOOP, Boolean.toString(this.m_bSlideShowLoop));
        properties.setProperty(SLIDESHOWDIRECTION, Integer.toString(this.m_slideShowDirection));
        properties.setProperty(TOOLTIPBOLD, Boolean.toString(this.m_bToolTipBold));
        properties.setProperty(TOOLTIPTABLE, Boolean.toString(this.m_bToolTipTable));
        properties.setProperty(TOOLTIPDISMISSDELAY, Integer.toString(this.m_toolTipDismissDelay));
        properties.setProperty(EXPORTJPEGOPTIMIZEDHUFTABLE, Boolean.toString(this.m_bExportJpegOptimizedHufTable));
        properties.setProperty(EXPORTQUALITY, Float.toString(this.m_exportQuality));
        properties.setProperty(EXPORTSCALEFACTOR, Float.toString(this.m_exportScaleFactor));
        properties.setProperty(EXPORTDIRECTORY, this.m_exportDirectory);
        properties.setProperty(EXPORTMIMETYPE, this.m_exportMimeType);
        properties.setProperty(USEFULLSCREENMODE, Boolean.toString(this.m_bUseFullScreenMode));
        properties.setProperty(FULLSCREENPAGESIZE, Integer.toString(this.m_fullScreenPageSize));
        properties.setProperty(BATCHCONVERTRECURSIVE, Boolean.toString(this.m_bBatchRecursive));
        properties.setProperty(BATCHCONVERTSRCFORMATS, Integer.toString(this.m_batchSrcFormats));
        properties.setProperty(BATCHCONVERTTARGETFORMAT, Integer.toString(this.m_batchTargetFormat));
        properties.setProperty(BATCHCONVERTJPGQUALITY, Float.toString(this.m_batchJpgQuality));
        properties.setProperty(BATCHCONVERTJPGOPTHUF, Boolean.toString(this.m_bBatchJpgOptHuf));
        properties.setProperty(BATCHCONVERTSCALE, Float.toString(this.m_batchScale));
    }

    public void doLoad(Properties properties) {
        block10: {
            int n;
            String string = properties.getProperty(COLS, DEF_COLS);
            String[] stringArray = string.split(",");
            this.m_cols = new short[stringArray.length];
            int n2 = 0;
            for (String string2 : stringArray) {
                this.m_cols[n2++] = new Short(string2);
            }
            string = properties.getProperty(COLWIDTH, DEF_COLWIDTH);
            stringArray = string.split(",");
            this.m_colWidth = new int[stringArray.length];
            n2 = 0;
            for (String string2 : stringArray) {
                this.m_colWidth[n2++] = new Integer(string2);
            }
            this.m_sortData = new JTableColSortData[new Integer(properties.getProperty(SORTDEEP, "5")).intValue()];
            string = properties.getProperty(SORTCOL, DEF_EXTENDEDSTATE);
            stringArray = string.split(",");
            string = properties.getProperty(SORTUP, "true");
            String[] stringArray2 = string.split(",");
            for (n = 0; n < this.m_sortData.length; ++n) {
                this.m_sortData[n] = n < stringArray.length ? new JTableColSortData(new Integer(stringArray[n]), new Boolean(stringArray2[n])) : new JTableColSortData(0, true);
            }
            this.m_imgDisplayTimer = new Integer(properties.getProperty(IMGDISPLAYTIMER, DEF_IMGDISPLAYTIMER));
            this.m_fillListTimer = new Integer(properties.getProperty(FILLLISTTIMER, DEF_FILLLISTTIMER));
            string = properties.getProperty(JPGEXTENSTIONS, DEF_JPGEXTENSIONS);
            stringArray = string.split("\\|");
            this.m_jpgExtensions = new String[stringArray.length];
            n = 0;
            for (String string2 : stringArray) {
                this.m_jpgExtensions[n++] = string2.toLowerCase().trim();
            }
            string = properties.getProperty(HOMEDIR, System.getProperty("user.home"));
            if (string.length() != 0) {
                stringArray = string.split("\\|");
                this.m_homeDir = new String[stringArray.length];
                n = 0;
                for (String string2 : stringArray) {
                    this.m_homeDir[n++] = string2;
                }
            } else {
                this.m_homeDir = null;
            }
            string = properties.getProperty(TOOLTIPTAGS, DEF_TOOLTIPTAGS);
            stringArray = string.split(",");
            this.m_toolTipTags = new int[stringArray.length];
            n = 0;
            try {
                for (String string2 : stringArray) {
                    this.m_toolTipTags[n++] = new Integer(string2.trim());
                }
            }
            catch (NumberFormatException numberFormatException) {
                if ($assertionsDisabled) break block10;
                throw new AssertionError();
            }
        }
        this.m_size = new Dimension(new Integer(properties.getProperty(SIZE_W, DEF_SIZE_W)), new Integer(properties.getProperty(SIZE_H, DEF_SIZE_H)));
        this.m_extendedState = new Integer(properties.getProperty(EXTENDEDSTATE, DEF_EXTENDEDSTATE));
        this.m_location = new Point(new Integer(properties.getProperty(LOCATION_X, "10")), new Integer(properties.getProperty(LOCATION_Y, "10")));
        this.m_bDisplayAllImages = new Boolean(properties.getProperty(DISPLAYALLIMAGES, "true"));
        this.m_saveImage = new Integer(properties.getProperty(SAVEIMAGE, DEF_SAVEIMAGE));
        this.m_imgCacheSize = new Integer(properties.getProperty(IMGCACHESIZE, DEF_IMGCACHESIZE));
        this.m_bImgUsePreload = new Boolean(properties.getProperty(IMGUSEPRELOAD, "true"));
        this.m_vertResizeWeight = new Float(properties.getProperty(VERTRESIZEWEIGHT, DEF_VERTRESIZEWEIGHT)).floatValue();
        this.m_horResizeWeight = new Float(properties.getProperty(HORRESIZEWEIGHT, DEF_HORRESIZEWEIGHT)).floatValue();
        this.m_vertDividerLocation = new Double(properties.getProperty(VERTDIVIDERLOCATION, DEF_VERTDIVIDERLOCATION));
        this.m_horDividerLocation = new Double(properties.getProperty(HORDIVIDERLOCATION, DEF_HORDIVIDERLOCATION));
        int n = new Integer(properties.getProperty(INTERPOLATION, "1"));
        this.m_interpolation = n == 1 ? RenderingHints.VALUE_INTERPOLATION_BILINEAR : (n == 2 ? RenderingHints.VALUE_INTERPOLATION_BICUBIC : RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
        this.m_zoomDelta = new Float(properties.getProperty(ZOOMDELTA, DEF_ZOOMDELTA)).floatValue();
        this.m_imgScrollDelta = new Integer(properties.getProperty(IMGSCROLLDELTA, DEF_IMGSCROLLDELTA));
        this.m_bDelConfirm = new Boolean(properties.getProperty(DELCONFIRM, "true"));
        this.m_bOverwriteConfirm = new Boolean(properties.getProperty(OVERWRITECONFIRM, "true"));
        this.m_copyDirectory = properties.getProperty(COPYDIRECTORY, "");
        this.m_moveDirectory = properties.getProperty(MOVEDIRECTORY, "");
        this.m_imgViewBackColor = new Color(Integer.parseInt(properties.getProperty(IMGVIEWBACKCOLOR, DEF_IMGVIEWBACKCOLOR)));
        this.m_bCallGcAfterCacheOp = new Boolean(properties.getProperty(CALLGCAFTERCACHEOP, "false"));
        this.m_bCallGcInSetJpg = new Boolean(properties.getProperty(CALLGCINSETJPG, "false"));
        this.m_slideShowTimer = new Integer(properties.getProperty(SLIDESHOWTIMER, "20000"));
        this.m_bSlideShowLoop = new Boolean(properties.getProperty(SLIDESHOWLOOP, "false"));
        this.m_slideShowDirection = new Integer(properties.getProperty(SLIDESHOWDIRECTION, "1"));
        this.m_bToolTipBold = new Boolean(properties.getProperty(TOOLTIPBOLD, "true"));
        this.m_bToolTipTable = new Boolean(properties.getProperty(TOOLTIPTABLE, "true"));
        this.m_toolTipDismissDelay = new Integer(properties.getProperty(TOOLTIPDISMISSDELAY, "20000"));
        this.m_bExportJpegOptimizedHufTable = new Boolean(properties.getProperty(EXPORTJPEGOPTIMIZEDHUFTABLE, "true"));
        this.m_exportQuality = new Float(properties.getProperty(EXPORTQUALITY, "0.85")).floatValue();
        this.m_exportScaleFactor = new Float(properties.getProperty(EXPORTSCALEFACTOR, "1.0")).floatValue();
        this.m_exportDirectory = properties.getProperty(EXPORTDIRECTORY, "");
        this.m_exportMimeType = properties.getProperty(EXPORTMIMETYPE, DEF_EXPORTMIMETYPE);
        this.m_bUseFullScreenMode = new Boolean(properties.getProperty(USEFULLSCREENMODE, "true"));
        this.m_fullScreenPageSize = new Integer(properties.getProperty(FULLSCREENPAGESIZE, "10"));
        this.m_batchSrcFormats = new Integer(properties.getProperty(BATCHCONVERTSRCFORMATS, DEF_BATCHCONVERTSRCFORMATS));
        this.m_bBatchRecursive = new Boolean(properties.getProperty(BATCHCONVERTRECURSIVE, "true"));
        this.m_batchTargetFormat = new Integer(properties.getProperty(BATCHCONVERTTARGETFORMAT, DEF_BATCHCONVERTTARGETFORMAT));
        this.m_batchJpgQuality = new Float(properties.getProperty(BATCHCONVERTJPGQUALITY, "0.85")).floatValue();
        this.m_bBatchJpgOptHuf = new Boolean(properties.getProperty(BATCHCONVERTJPGOPTHUF, "true"));
        this.m_batchScale = new Float(properties.getProperty(BATCHCONVERTSCALE, "1.0")).floatValue();
    }
}

