/*
 * Decompiled with CFR 0.152.
 */
package jexifviewer;

import java.io.File;
import java.io.FilenameFilter;
import jexifviewer.Main;
import shared.cvshelper.Cvs;
import shared.files.JPathHelper;

@Cvs(header="$Header: /home/reiner/cvs/Java/JExifViewer/src/jexifviewer/JBatchData.java,v 1.4 2010/04/03 07:59:53 reiner Exp $")
public final class JBatchData
implements FilenameFilter {
    public static final int JPG_FORMAT = 1;
    public static final int PNG_FORMAT = 2;
    public static final int BMP_FORMAT = 4;
    public String m_srcFolder;
    public String m_targetFolder;
    public boolean m_bRecursive = Main.m_settings.getBatchRecursive();
    public int m_srcTypes = Main.m_settings.getBatchSrcFormats();
    public int m_targetFormat = Main.m_settings.getBatchTargetFormat();
    public double m_scaleFactor = 1.0;
    public double m_quality = Main.m_settings.getBatchJpgQuality();
    public boolean m_bOptimizedHuffmanTable = Main.m_settings.getBatchJpgOptHuf();
    public String m_targetTemplate = "%1";

    public JBatchData() {
        this.m_scaleFactor = Main.m_settings.getBatchScale();
    }

    public boolean accept(File file, String string) {
        if (!new File(JPathHelper.addSeparator(file.getPath()) + string).isDirectory()) {
            String string2 = JPathHelper.getFileExtension(string);
            return (this.m_srcTypes & 1) != 0 ? string2.equalsIgnoreCase("jpg") || string2.equalsIgnoreCase("jpeg") : ((this.m_srcTypes & 2) != 0 ? string2.equalsIgnoreCase("png") : (this.m_srcTypes & 4) != 0 && string2.equalsIgnoreCase("bmp"));
        }
        return true;
    }

    public String getTargetExtension() {
        return this.getExtension(this.m_targetFormat);
    }

    public String getExtension(int n) {
        switch (n) {
            case 1: {
                return "jpg";
            }
            case 2: {
                return "png";
            }
            case 4: {
                return "bmp";
            }
        }
        assert (false);
        return null;
    }
}

