/*
 * Decompiled with CFR 0.152.
 */
package shared.table;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import shared.table.JTableColSortData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JTableDataModel<T>
extends AbstractTableModel
implements Comparator<T> {
    protected ArrayList<T> m_data;
    protected JTableColSortData m_sortData;

    public JTableDataModel() {
        this.doInit(0, true);
    }

    public JTableDataModel(int n, boolean bl) {
        this.doInit(n, bl);
    }

    protected void doInit(int n, boolean bl) {
        this.m_data = new ArrayList();
        this.m_sortData = new JTableColSortData(n, bl);
    }

    @Override
    public abstract Object getValueAt(int var1, int var2);

    @Override
    public abstract int getColumnCount();

    public int getSortCol() {
        return this.m_sortData.getSortCol();
    }

    public boolean getSortUp() {
        return this.m_sortData.getSortUp();
    }

    public void setSortCol(int n) {
        this.m_sortData.setSortCol(n);
    }

    public void setSortUp(boolean bl) {
        this.m_sortData.setSortUp(bl);
    }

    public Icon getColIcon(int n) {
        return null;
    }

    public T getItem(int n) {
        assert (n >= 0 && n < this.m_data.size());
        return n >= 0 && n < this.m_data.size() ? (T)this.m_data.get(n) : null;
    }

    public int findRow(T t) {
        int n = 0;
        for (T t2 : this.m_data) {
            if (t == t2) {
                return n;
            }
            ++n;
        }
        return 0;
    }

    public void setData(ArrayList<T> arrayList) {
        if (arrayList != null) {
            this.m_data = arrayList;
            this.fireTableDataChanged();
            this.sort();
        }
    }

    public ArrayList<T> getData() {
        return this.m_data;
    }

    public void addData(T t) {
        if (this.m_data == null) {
            this.m_data = new ArrayList();
        }
        this.m_data.add(t);
        this.fireTableDataChanged();
        this.sort();
    }

    public T getRowData(int n) {
        assert (n >= 0 && n < this.m_data.size());
        return n >= 0 && n < this.m_data.size() ? (T)this.m_data.get(n) : null;
    }

    @Override
    public int getRowCount() {
        return this.m_data.size();
    }

    public void removeRow(int n) {
        if (n >= 0 && n < this.m_data.size()) {
            this.m_data.remove(n);
            this.fireTableRowsDeleted(n, n);
            this.sort();
        }
    }

    public void insertRow(T t, int n) {
        if (n >= 0 && n <= this.m_data.size()) {
            if (n < this.m_data.size()) {
                this.m_data.add(n, t);
            } else {
                this.m_data.add(t);
            }
            this.fireTableRowsInserted(n, n);
            this.sort();
        }
    }

    public void removeAll() {
        int n = this.m_data.size();
        this.m_data.clear();
        this.fireTableRowsDeleted(0, n);
    }

    public void sort() {
        Collections.sort(this.m_data, this);
        this.fireTableDataChanged();
    }

    @Override
    public int compare(T t, T t2) {
        int n = 0;
        switch (this.m_sortData.getSortCol()) {
            case 0: {
                n = t.toString().compareTo(t2.toString());
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        if (!this.m_sortData.getSortUp()) {
            n = -n;
        }
        return n;
    }

    @Override
    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof JTableDataModel) {
            JTableDataModel jTableDataModel = (JTableDataModel)object;
            if (jTableDataModel.m_sortData.equals(jTableDataModel.m_sortData)) {
                bl = true;
            }
        }
        return bl;
    }

    public void updateColHeader(JTable jTable) {
        int n = this.getColumnCount();
        TableColumnModel tableColumnModel = jTable.getColumnModel();
        for (int i = 0; i < n; ++i) {
            TableColumn tableColumn = tableColumnModel.getColumn(i);
            JLabel jLabel = (JLabel)((Object)tableColumn.getHeaderRenderer());
            assert (jLabel != null);
            if (jLabel == null) continue;
            jLabel.setIcon(this.getColIcon(i));
        }
        jTable.getTableHeader().repaint();
    }
}

