/*
 * Decompiled with CFR 0.152.
 */
package shared.number;

import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;

public final class JDoubleHelper {
    private JDoubleHelper() {
    }

    public static double parseDouble(String string, Locale locale) throws NumberFormatException {
        double d;
        try {
            d = Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            try {
                NumberFormat numberFormat = NumberFormat.getInstance(locale);
                d = numberFormat.parse(string).doubleValue();
            }
            catch (ParseException parseException) {
                throw new NumberFormatException(parseException.getMessage());
            }
        }
        return d;
    }

    public static double parseDouble(String string) throws NumberFormatException {
        return JDoubleHelper.parseDouble(string, Locale.getDefault());
    }
}

