/*
 * Decompiled with CFR 0.152.
 */
package shared.ftp;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.net.BindException;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.NoRouteToHostException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import shared.files.JPathHelper;
import shared.ftp.FtpNotify;
import shared.ftp.JFtpFile;
import shared.misc.JSleepHelper;
import shared.proglistener.ProgListener;
import shared.proglistener.ProgNotify;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JFtp
implements ProgListener {
    public static final int REPLY_125 = 125;
    public static final int REPLY_150 = 150;
    public static final int REPLY_200 = 200;
    public static final int REPLY_214 = 214;
    public static final int REPLY_215 = 215;
    public static final int REPLY_220 = 220;
    public static final int REPLY_221 = 221;
    public static final int REPLY_226 = 226;
    public static final int REPLY_227 = 227;
    public static final int REPLY_230 = 230;
    public static final int REPLY_250 = 250;
    public static final int REPLY_257 = 257;
    public static final int REPLY_331 = 331;
    public static final int REPLY_332 = 332;
    public static final int REPLY_350 = 350;
    public static final char TYPE_ASCII = 'A';
    public static final char TYPE_IMAGE = 'I';
    public static final char MODE_STREAM = 'S';
    public static final char MODE_BLOCK = 'B';
    public static final char MODE_COMPRESSED = 'C';
    protected static boolean m_isDebug = false;
    protected boolean m_bOpen = false;
    protected int m_dataPort = 0;
    protected boolean m_bPassive = true;
    protected Socket m_comSocket;
    protected int m_waitTimeout = 1000;
    protected int m_comConTimeOut = 30000;
    protected int m_comTimeOut = 10000;
    protected int m_dataConTimeout = 5000;
    protected int m_dataTimeout = 25000;
    protected int m_activeTimeOut = 5000;
    protected int m_bufSize = 1396;
    protected int m_socketUsedReties = 10;
    protected int m_socketUsedWait = 1000;
    protected boolean m_bWaitForReady = true;
    protected BufferedReader m_comBufReader;
    protected BufferedWriter m_comBuffWriter;
    protected String[] m_tempFileNames = null;
    protected ArrayList<String> m_messages = new ArrayList();
    protected ArrayList<String> m_lastListOutput = null;
    protected boolean m_bHasLastListOutputHardlinks;
    protected int m_lastReplyCode;
    protected Thread m_dataThread = null;
    protected final Object m_lock = new Object();

    public void setDebug(boolean bl) {
        m_isDebug = bl;
    }

    public ArrayList<String> getLastListOutput() {
        return this.m_lastListOutput;
    }

    public boolean getHasLastListOutputHardlinks() {
        return this.m_bHasLastListOutputHardlinks;
    }

    public ArrayList<String> getMessages() {
        return this.m_messages;
    }

    public boolean getWaitForReady() {
        return this.m_bWaitForReady;
    }

    public void setWaitForReady(boolean bl) {
        this.m_bWaitForReady = bl;
    }

    public boolean isOpen() {
        return this.m_bOpen && this.m_comSocket.isConnected();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForReady() {
        boolean bl = true;
        while (bl) {
            Object object = this.m_lock;
            synchronized (object) {
                if (this.m_dataThread == null) {
                    bl = false;
                } else if (m_isDebug) {
                    System.err.println("Waiting ....");
                }
            }
            if (!bl) break;
            JSleepHelper.sleep(300);
        }
    }

    public boolean isReady() {
        Thread.yield();
        boolean bl = false;
        if (this.isOpen()) {
            Thread.yield();
            if (this.m_dataThread == null) {
                bl = true;
            }
        }
        return bl;
    }

    public void setActive(int n) {
        this.m_dataPort = n;
        this.m_bPassive = false;
    }

    public void setPassive() {
        this.m_bPassive = true;
    }

    public boolean open(String string, String string2, String string3) {
        return this.open(string, 21, string2, string3, null, 'I', true, 0);
    }

    public boolean open(String string, String string2, String string3, String string4) {
        return this.open(string, 21, string2, string3, string4, 'I', true, 0);
    }

    public boolean open(String string, int n, String string2, String string3) {
        return this.open(string, n, string2, string3, null, 'I', true, 0);
    }

    public boolean open(String string, int n, String string2, String string3, String string4) {
        return this.open(string, n, string2, string3, string4, 'I', true, 0);
    }

    public boolean open(String string, String string2, String string3, boolean bl) {
        return this.open(string, 21, string2, string3, null, 'I', bl, 0);
    }

    public boolean open(String string, String string2, String string3, String string4, boolean bl) {
        return this.open(string, 21, string2, string3, string4, 'I', bl, 0);
    }

    public boolean open(String string, String string2, String string3, boolean bl, int n) {
        return this.open(string, 21, string2, string3, null, 'I', bl, n);
    }

    public boolean open(String string, String string2, String string3, String string4, boolean bl, int n) {
        return this.open(string, 21, string2, string3, string4, 'I', bl, n);
    }

    public boolean open(String string, int n, String string2, String string3, boolean bl) {
        return this.open(string, n, string2, string3, null, 'I', bl, 0);
    }

    public boolean open(String string, int n, String string2, String string3, String string4, boolean bl) {
        return this.open(string, n, string2, string3, string4, 'I', bl, 0);
    }

    public boolean open(String string, int n, String string2, String string3, boolean bl, int n2) {
        return this.open(string, n, string2, string3, null, 'I', bl, n2);
    }

    public boolean open(String string, int n, String string2, String string3, String string4, boolean bl, int n2) {
        return this.open(string, n, string2, string3, string4, 'I', bl, n2);
    }

    public boolean open(String string, int n, String string2, String string3, String string4, char c, boolean bl, int n2) {
        boolean bl2;
        block14: {
            bl2 = false;
            if (!this.isOpen()) {
                try {
                    this.m_comSocket = new Socket();
                    this.m_comSocket.connect(new InetSocketAddress(string, n), this.m_comConTimeOut);
                    this.m_comBufReader = new BufferedReader(new InputStreamReader(this.m_comSocket.getInputStream()));
                    this.m_comBuffWriter = new BufferedWriter(new OutputStreamWriter(this.m_comSocket.getOutputStream()));
                    this.getMessage(this.m_comTimeOut);
                    if (this.m_lastReplyCode == 220 && this.doLogin(string2, string3, string4)) {
                        this.m_bOpen = true;
                        bl2 = this.setDataType(c);
                        if (bl) {
                            this.setPassive();
                        } else {
                            this.setActive(n2);
                        }
                    }
                }
                catch (UnknownHostException unknownHostException) {
                    if (m_isDebug) {
                        System.err.println("Unable to connect to '" + string + "'");
                    }
                }
                catch (NoRouteToHostException noRouteToHostException) {
                    if (m_isDebug) {
                        System.err.println("Unable to connect to '" + string + "'; route error");
                    }
                }
                catch (ConnectException connectException) {
                    if (m_isDebug) {
                        System.err.println("Unable to find '" + string + "'");
                    }
                }
                catch (SocketTimeoutException socketTimeoutException) {
                    if (m_isDebug) {
                        System.err.println("Timeout during connecting to '" + string + "'");
                    }
                }
                catch (IOException iOException) {
                    if (!m_isDebug) break block14;
                    System.err.println("Error during connect to '" + string + "'");
                }
            }
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean close() {
        boolean bl = false;
        Object object = this.m_lock;
        synchronized (object) {
            if (this.isReady()) {
                try {
                    this.m_comBuffWriter.write("QUIT\r\n");
                    this.m_comBuffWriter.flush();
                    this.getMessage(this.m_comTimeOut);
                    if (this.m_lastReplyCode == 221) {
                        this.m_comSocket.close();
                        this.m_bOpen = false;
                        bl = true;
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return bl;
    }

    public boolean ping() {
        return this.noop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean noop() {
        boolean bl = false;
        Object object = this.m_lock;
        synchronized (object) {
            if (this.isReady()) {
                try {
                    this.m_comBuffWriter.write("NOOP\r\n");
                    this.m_comBuffWriter.flush();
                    this.getMessage(this.m_comTimeOut);
                    if (this.m_lastReplyCode == 200) {
                        bl = true;
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCurrentDirectory() {
        String string = null;
        Object object = this.m_lock;
        synchronized (object) {
            if (this.isReady()) {
                try {
                    Pattern pattern;
                    Matcher matcher;
                    this.m_comBuffWriter.write("PWD\r\n");
                    this.m_comBuffWriter.flush();
                    String string2 = this.getMessage(this.m_comTimeOut);
                    if (this.m_lastReplyCode == 257 && string2 != null && (matcher = (pattern = Pattern.compile("^\\d{3}[ \t]+\"(.+)\".*")).matcher(string2)).find()) {
                        string = matcher.group(1);
                        if (m_isDebug) {
                            System.err.println(string);
                        }
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setCurrentDirectory(String string) {
        boolean bl = false;
        Object object = this.m_lock;
        synchronized (object) {
            if (this.isReady()) {
                try {
                    this.m_comBuffWriter.write("CWD " + string + "\r\n");
                    this.m_comBuffWriter.flush();
                    String string2 = this.getMessage(this.m_comTimeOut);
                    if (this.m_lastReplyCode == 250) {
                        bl = true;
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean changeToParentDirectory() {
        boolean bl = false;
        Object object = this.m_lock;
        synchronized (object) {
            if (this.isReady()) {
                try {
                    this.m_comBuffWriter.write("CDUP\r\n");
                    this.m_comBuffWriter.flush();
                    String string = this.getMessage(this.m_comTimeOut, 1);
                    if (this.m_lastReplyCode == 250) {
                        bl = true;
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getStatus(String string) {
        boolean bl = false;
        Object object = this.m_lock;
        synchronized (object) {
            if (this.isReady()) {
                try {
                    this.m_comBuffWriter.write("STAT " + string + "\r\n");
                    this.m_comBuffWriter.flush();
                    this.getMessage(this.m_comTimeOut);
                    if (this.m_lastReplyCode == 250) {
                        bl = true;
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean system() {
        boolean bl = false;
        Object object = this.m_lock;
        synchronized (object) {
            if (this.isReady()) {
                try {
                    this.m_comBuffWriter.write("SYST\r\n");
                    this.m_comBuffWriter.flush();
                    this.getMessage(this.m_comTimeOut);
                    if (this.m_lastReplyCode == 215) {
                        bl = true;
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean site(String string) {
        boolean bl = false;
        Object object = this.m_lock;
        synchronized (object) {
            if (this.isReady()) {
                try {
                    this.m_comBuffWriter.write("SITE " + string + "\r\n");
                    this.m_comBuffWriter.flush();
                    this.getMessage(this.m_comTimeOut);
                    if (this.m_lastReplyCode == 200) {
                        bl = true;
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean help(String string) {
        boolean bl = false;
        Object object = this.m_lock;
        synchronized (object) {
            if (this.isReady()) {
                try {
                    this.m_comBuffWriter.write("HELP " + string + "\r\n");
                    this.m_comBuffWriter.flush();
                    this.getMessage(this.m_comTimeOut);
                    if (this.m_lastReplyCode == 214) {
                        bl = true;
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return bl;
    }

    protected boolean abortInternal() {
        boolean bl = false;
        try {
            this.m_comBuffWriter.write("ABOR\r\n");
            this.m_comBuffWriter.flush();
            this.getMessage(this.m_comTimeOut);
            if (this.m_lastReplyCode == 226) {
                bl = true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean abort() {
        boolean bl = false;
        Object object = this.m_lock;
        synchronized (object) {
            if (this.isReady()) {
                bl = this.abortInternal();
            }
        }
        return bl;
    }

    protected boolean renameInternal(String string, String string2) {
        boolean bl = false;
        try {
            this.m_comBuffWriter.write("RNFR " + string + "\r\n");
            this.m_comBuffWriter.flush();
            this.getMessage(this.m_comTimeOut);
            if (this.m_lastReplyCode == 350) {
                this.m_comBuffWriter.write("RNTO " + string2 + "\r\n");
                this.m_comBuffWriter.flush();
                this.getMessage(this.m_comTimeOut);
                if (this.m_lastReplyCode == 250) {
                    bl = true;
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean rename(String string, String string2) {
        boolean bl = false;
        Object object = this.m_lock;
        synchronized (object) {
            if (this.isReady()) {
                bl = this.renameInternal(string, string2);
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteFile(String string) {
        boolean bl = false;
        Object object = this.m_lock;
        synchronized (object) {
            if (this.isReady()) {
                try {
                    this.m_comBuffWriter.write("DELE " + string + "\r\n");
                    this.m_comBuffWriter.flush();
                    this.getMessage(this.m_comTimeOut);
                    if (this.m_lastReplyCode == 250) {
                        bl = true;
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean makeDirectory(String string) {
        boolean bl = false;
        Object object = this.m_lock;
        synchronized (object) {
            if (this.isReady()) {
                try {
                    this.m_comBuffWriter.write("MKD " + string + "\r\n");
                    this.m_comBuffWriter.flush();
                    this.getMessage(this.m_comTimeOut);
                    if (this.m_lastReplyCode == 257) {
                        bl = true;
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteDirectory(String string) {
        boolean bl = false;
        Object object = this.m_lock;
        synchronized (object) {
            if (this.isReady()) {
                try {
                    this.m_comBuffWriter.write("RMD " + string + "\r\n");
                    this.m_comBuffWriter.flush();
                    this.getMessage(this.m_comTimeOut);
                    if (this.m_lastReplyCode == 250) {
                        bl = true;
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean listDirectory(String string) {
        Object object = this.m_lock;
        synchronized (object) {
        }
        boolean bl = false;
        if (this.isReady()) {
            Socket socket = null;
            ServerSocket serverSocket = null;
            if (this.m_bPassive) {
                socket = this.doPassive();
            } else {
                serverSocket = this.doActive();
            }
            if (this.m_bPassive && socket != null || !this.m_bPassive && serverSocket != null) {
                final Socket socket2 = socket;
                final ServerSocket serverSocket2 = serverSocket;
                final JFtp jFtp = this;
                int n = this.m_waitTimeout;
                final boolean[] blArray = new boolean[]{false};
                this.m_dataThread = new Thread(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        Object object = jFtp.m_lock;
                        synchronized (object) {
                            ArrayList<String> arrayList = new ArrayList<String>();
                            boolean bl = false;
                            Socket socket = socket2;
                            boolean bl2 = false;
                            try {
                                String string;
                                if (serverSocket2 != null) {
                                    blArray[0] = true;
                                    socket = JFtp.this.activeWaitForConnection(serverSocket2);
                                }
                                jFtp.notify(new FtpNotify(1, 0));
                                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                                while (!this.isInterrupted() && !bl && (string = bufferedReader.readLine()) != null) {
                                    arrayList.add(string);
                                    if (jFtp.notify(new FtpNotify<String>(1, 1, string))) continue;
                                    jFtp.abort();
                                    bl = true;
                                }
                                bl2 = true;
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                            JFtp.this.closeSocket(socket);
                            if (bl2) {
                                jFtp.notify(new FtpNotify(1, bl ? -2 : 2, arrayList));
                            } else {
                                jFtp.notify(new FtpNotify(1, -1));
                            }
                        }
                    }
                };
                if (!this.m_bPassive) {
                    this.m_dataThread.start();
                    int n2 = 100;
                    while (!blArray[0] && n2-- > 0) {
                        JSleepHelper.sleep(50);
                    }
                    Thread.yield();
                }
                try {
                    bl = false;
                    this.m_comBuffWriter.write("LIST -al " + (string != null ? string : ".") + "\r\n");
                    this.m_comBuffWriter.flush();
                    this.getMessage(this.m_comTimeOut);
                    if (this.m_lastReplyCode == 250 || this.m_lastReplyCode == 125 || this.m_lastReplyCode == 150) {
                        if (this.m_bPassive) {
                            this.m_dataThread.start();
                        }
                        bl = true;
                    }
                    if (!bl) {
                        if (!this.m_bPassive) {
                            this.m_dataThread.interrupt();
                        }
                        this.closeSocket(socket);
                        this.closeSocket(serverSocket);
                    }
                }
                catch (IOException iOException) {
                    if (!this.m_bPassive) {
                        this.m_dataThread.interrupt();
                    }
                    this.closeSocket(socket);
                    this.closeSocket(serverSocket);
                }
            }
        }
        if (!bl) {
            this.m_dataThread = null;
        } else if (this.m_bWaitForReady) {
            this.waitForReady();
        }
        return bl;
    }

    public boolean getFile(String string, String string2) {
        return this.getFile(string, string2, false, 0L);
    }

    public boolean getFile(String string, String string2, boolean bl) {
        return this.getFile(string, string2, bl, 0L);
    }

    public boolean getFile(String string, String string2, long l) {
        return this.getFile(string, string2, false, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getFile(String string, final String string2, final boolean bl, final long l) {
        Object object = this.m_lock;
        synchronized (object) {
        }
        boolean bl2 = false;
        if (this.isReady()) {
            Socket socket = null;
            ServerSocket serverSocket = null;
            if (this.m_bPassive) {
                socket = this.doPassive();
            } else {
                serverSocket = this.doActive();
            }
            if (this.m_bPassive && socket != null || !this.m_bPassive && serverSocket != null) {
                final Socket socket2 = socket;
                final ServerSocket serverSocket2 = serverSocket;
                final JFtp jFtp = this;
                int n = this.m_waitTimeout;
                final boolean[] blArray = new boolean[]{false};
                this.m_dataThread = new Thread(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        Object object = jFtp.m_lock;
                        synchronized (object) {
                            FileOutputStream fileOutputStream = null;
                            long l2 = 0L;
                            boolean bl3 = false;
                            File file = null;
                            Socket socket = socket2;
                            boolean bl2 = false;
                            try {
                                int n;
                                Object object2;
                                if (serverSocket2 != null) {
                                    blArray[0] = true;
                                    socket = JFtp.this.activeWaitForConnection(serverSocket2);
                                }
                                if (bl) {
                                    file = File.createTempFile("ftp", "", new File(JPathHelper.getFolder(string2)));
                                    fileOutputStream = new FileOutputStream(file);
                                } else {
                                    object2 = new File(string2);
                                    if (((File)object2).exists() && l > 0L) {
                                        RandomAccessFile randomAccessFile = new RandomAccessFile((File)object2, "rw");
                                        if (randomAccessFile.getFilePointer() > l) {
                                            randomAccessFile.setLength(l);
                                        }
                                        randomAccessFile.close();
                                        fileOutputStream = new FileOutputStream(string2, true);
                                    }
                                    if (fileOutputStream == null) {
                                        fileOutputStream = new FileOutputStream(string2);
                                    }
                                }
                                jFtp.notify(new FtpNotify<String>(2, 0, bl ? file.getPath() : string2));
                                object2 = socket.getInputStream();
                                byte[] byArray = new byte[JFtp.this.m_bufSize];
                                while (!this.isInterrupted() && !bl3 && (n = ((InputStream)object2).read(byArray)) > 0) {
                                    fileOutputStream.write(byArray, 0, n);
                                    l2 += (long)n;
                                    if (jFtp.notify(new FtpNotify<Long>(2, 1, new Long(n)))) continue;
                                    jFtp.abortInternal();
                                    bl3 = true;
                                }
                                bl2 = true;
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                            JFtp.this.closeSocket(socket);
                            if (fileOutputStream != null) {
                                try {
                                    fileOutputStream.close();
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                            }
                            if (bl2 && !bl3 && file != null) {
                                file.renameTo(new File(string2));
                            }
                            if (bl2) {
                                jFtp.notify(new FtpNotify<Long>(2, bl3 ? -2 : 2, new Long(l2)));
                            } else {
                                jFtp.notify(new FtpNotify<String>(2, -1, bl ? file.getPath() : null));
                            }
                        }
                    }
                };
                try {
                    bl2 = false;
                    if (l > 0L) {
                        this.m_comBuffWriter.write("REST " + Long.toString(l) + "\r\n");
                        this.m_comBuffWriter.flush();
                        this.getMessage(this.m_comTimeOut);
                        if (this.m_lastReplyCode == 350) {
                            bl2 = true;
                        }
                    } else {
                        bl2 = true;
                    }
                    if (bl2) {
                        if (!this.m_bPassive) {
                            this.m_dataThread.start();
                            int n2 = 100;
                            while (!blArray[0] && n2-- > 0) {
                                JSleepHelper.sleep(50);
                            }
                            Thread.yield();
                        }
                        bl2 = false;
                        this.m_comBuffWriter.write("RETR " + string + "\r\n");
                        this.m_comBuffWriter.flush();
                        this.getMessage(this.m_comTimeOut);
                        if (this.m_lastReplyCode == 150 || this.m_lastReplyCode == 125) {
                            if (this.m_bPassive) {
                                this.m_dataThread.start();
                            }
                            bl2 = true;
                        }
                    }
                    if (!bl2) {
                        if (!this.m_bPassive) {
                            this.m_dataThread.interrupt();
                        }
                        this.closeSocket(socket);
                        this.closeSocket(serverSocket);
                    }
                }
                catch (IOException iOException) {
                    if (!this.m_bPassive) {
                        this.m_dataThread.interrupt();
                    }
                    this.closeSocket(socket);
                    this.closeSocket(serverSocket);
                }
            }
        }
        if (!bl2) {
            this.m_dataThread = null;
        } else if (this.m_bWaitForReady) {
            this.waitForReady();
        }
        return bl2;
    }

    public boolean sendFile(String string, String string2) {
        return this.sendFile(string, string2, false, 0L);
    }

    public boolean sendFile(String string, String string2, boolean bl) {
        return this.sendFile(string, string2, bl, 0L);
    }

    public boolean sendFile(String string, String string2, long l) {
        return this.sendFile(string, string2, false, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sendFile(final String string, String string2, final boolean bl, final long l) {
        Object object = this.m_lock;
        synchronized (object) {
        }
        this.m_tempFileNames = null;
        boolean bl2 = false;
        if (this.isReady()) {
            Socket socket = null;
            ServerSocket serverSocket = null;
            if (this.m_bPassive) {
                socket = this.doPassive();
            } else {
                serverSocket = this.doActive();
            }
            String[] stringArray = new String[1];
            if (this.m_bPassive && socket != null || !this.m_bPassive && serverSocket != null) {
                final Socket socket2 = socket;
                final ServerSocket serverSocket2 = serverSocket;
                final JFtp jFtp = this;
                int n = this.m_waitTimeout;
                final String string3 = string2;
                final boolean[] blArray = new boolean[]{false};
                this.m_dataThread = new Thread(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        Object object = jFtp.m_lock;
                        synchronized (object) {
                            boolean bl3 = false;
                            long l2 = 0L;
                            boolean bl2 = false;
                            FileInputStream fileInputStream = null;
                            Socket socket = socket2;
                            try {
                                int n;
                                if (serverSocket2 != null) {
                                    blArray[0] = true;
                                    socket = JFtp.this.activeWaitForConnection(serverSocket2);
                                }
                                fileInputStream = new FileInputStream(string);
                                if (l > 0L) {
                                    fileInputStream.skip(l);
                                }
                                jFtp.notify(new FtpNotify<String>(3, 0, bl ? JFtp.this.m_tempFileNames[0] : string3));
                                OutputStream outputStream = socket.getOutputStream();
                                byte[] byArray = new byte[JFtp.this.m_bufSize];
                                while (!bl2 && (n = fileInputStream.read(byArray)) > 0) {
                                    outputStream.write(byArray, 0, n);
                                    l2 += (long)n;
                                    if (jFtp.notify(new FtpNotify<Long>(3, 1, new Long(n)))) continue;
                                    jFtp.abort();
                                    bl2 = true;
                                }
                                bl3 = true;
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                            try {
                                fileInputStream.close();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                            JFtp.this.closeSocket(socket);
                            if (bl3) {
                                jFtp.notify(new FtpNotify<Long>(3, bl2 ? -2 : 2, new Long(l2)));
                            } else {
                                jFtp.notify(new FtpNotify<Object>(3, -1, (bl ? JFtp.this.m_tempFileNames[0] : null)));
                            }
                        }
                    }
                };
                try {
                    if (l > 0L) {
                        this.m_comBuffWriter.write("REST " + Long.toString(l) + "\r\n");
                        this.m_comBuffWriter.flush();
                        this.getMessage(this.m_comTimeOut);
                        if (this.m_lastReplyCode == 350) {
                            bl2 = true;
                        }
                    } else {
                        bl2 = true;
                    }
                    if (bl2) {
                        bl2 = false;
                        if (!this.m_bPassive) {
                            this.m_dataThread.start();
                            int n2 = 100;
                            while (!blArray[0] && n2-- > 0) {
                                JSleepHelper.sleep(50);
                            }
                            Thread.yield();
                        }
                        if (bl) {
                            this.m_comBuffWriter.write("STOU \r\n");
                        } else {
                            this.m_comBuffWriter.write("STOR " + string2 + "\r\n");
                        }
                        this.m_comBuffWriter.flush();
                        String string4 = this.getMessage(this.m_comTimeOut);
                        if (this.m_lastReplyCode == 150) {
                            if (bl) {
                                Pattern pattern = Pattern.compile("150[- ]FILE: (.+)");
                                Matcher matcher = pattern.matcher(string4);
                                if (matcher.find()) {
                                    this.m_tempFileNames = new String[2];
                                    this.m_tempFileNames[0] = matcher.group(1);
                                    this.m_tempFileNames[1] = string2;
                                    bl2 = true;
                                }
                            } else {
                                bl2 = true;
                            }
                            if (this.m_bPassive && bl2) {
                                this.m_dataThread.start();
                            }
                        }
                    }
                    if (!bl2) {
                        if (this.m_bPassive) {
                            this.m_dataThread.interrupt();
                        }
                        this.closeSocket(socket);
                        this.closeSocket(serverSocket);
                    }
                }
                catch (IOException iOException) {
                    if (this.m_bPassive) {
                        this.m_dataThread.interrupt();
                    }
                    this.closeSocket(socket);
                    this.closeSocket(serverSocket);
                }
            }
        }
        if (!bl2) {
            this.m_dataThread = null;
        } else if (this.m_bWaitForReady) {
            this.waitForReady();
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean transferFile(String string, String string2, JFtp jFtp, boolean bl) {
        boolean bl2 = false;
        if (!this.m_bPassive && jFtp.m_bPassive || this.m_bPassive && !jFtp.m_bPassive) {
            Object object = this.m_lock;
            synchronized (object) {
            }
            object = jFtp.m_lock;
            synchronized (object) {
            }
            try {
                if (this.isReady() && jFtp.isReady()) {
                    if (jFtp.m_bPassive) {
                        object = jFtp.doPassiveSimple();
                        bl2 = this.doActiveSimple((InetSocketAddress)object);
                    } else {
                        object = this.doPassiveSimple();
                        bl2 = jFtp.doActiveSimple((InetSocketAddress)object);
                    }
                    if (bl2) {
                        bl2 = false;
                        if (bl) {
                            jFtp.m_comBuffWriter.write("STOU \r\n");
                        } else {
                            jFtp.m_comBuffWriter.write("STOR " + string2 + "\r\n");
                        }
                        jFtp.m_comBuffWriter.flush();
                        object = jFtp.getMessage(this.m_comTimeOut);
                        if (jFtp.m_lastReplyCode == 150) {
                            if (bl) {
                                Pattern pattern = Pattern.compile("150[- ]FILE: (.+)");
                                Matcher matcher = pattern.matcher((CharSequence)object);
                                if (matcher.find()) {
                                    bl2 = true;
                                }
                            } else {
                                bl2 = true;
                            }
                            if (bl2) {
                                bl2 = false;
                                this.m_comBuffWriter.write("RETR " + string + "\r\n");
                                this.m_comBuffWriter.flush();
                                this.getMessage(this.m_comTimeOut);
                                if (this.m_lastReplyCode == 150 || this.m_lastReplyCode == 125) {
                                    bl2 = true;
                                }
                            }
                            if (bl2) {
                                bl2 = false;
                                this.notify(new FtpNotify(4, 0));
                                object = this.getMessage(0, 1);
                                String string3 = jFtp.getMessage(0, 1);
                                if (!(this.m_lastReplyCode != 150 && this.m_lastReplyCode != 125 || jFtp.m_lastReplyCode != 150 || bl)) {
                                    bl2 = true;
                                }
                                this.notify(new FtpNotify(4, bl2 ? 2 : -1));
                            }
                        }
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return bl2;
    }

    protected Socket doPassive() {
        Socket socket = null;
        if (this.isReady()) {
            try {
                InetSocketAddress inetSocketAddress = this.doPassiveSimple();
                if (inetSocketAddress != null) {
                    socket = new Socket();
                    socket.connect(inetSocketAddress, this.m_dataConTimeout);
                    socket.setSoTimeout(this.m_dataTimeout);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return socket;
    }

    protected InetSocketAddress doPassiveSimple() {
        InetSocketAddress inetSocketAddress = null;
        if (this.isReady()) {
            try {
                Pattern pattern;
                Matcher matcher;
                this.m_comBuffWriter.write("PASV\r\n");
                this.m_comBuffWriter.flush();
                String string = this.getMessage(this.m_comTimeOut);
                if (this.m_lastReplyCode == 227 && (matcher = (pattern = Pattern.compile("\\d{3}.*\\((\\d{1,3}),(\\d{1,3}),(\\d{1,3}),(\\d{1,3}),(\\d{1,3}),(\\d{1,3})\\)")).matcher(string)).find()) {
                    inetSocketAddress = new InetSocketAddress(matcher.group(1) + "." + matcher.group(2) + "." + matcher.group(3) + "." + matcher.group(4), Integer.parseInt(matcher.group(5)) * 256 + Integer.parseInt(matcher.group(6)));
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return inetSocketAddress;
    }

    protected Socket activeWaitForConnection(ServerSocket serverSocket) throws IOException {
        Socket socket = null;
        if (serverSocket != null) {
            socket = serverSocket.accept();
            socket.setSoTimeout(this.m_dataTimeout);
            this.closeSocket(serverSocket);
        }
        return socket;
    }

    protected ServerSocket doActive() {
        ServerSocket serverSocket = null;
        int n = 0;
        try {
            InetSocketAddress inetSocketAddress = new InetSocketAddress("0.0.0.0", this.m_dataPort);
            while (serverSocket == null && n++ < this.m_socketUsedReties) {
                try {
                    serverSocket = this.doInternalActive(inetSocketAddress);
                }
                catch (BindException bindException) {
                    JSleepHelper.sleep(this.m_socketUsedWait);
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return serverSocket;
    }

    protected ServerSocket doInternalActive(InetSocketAddress inetSocketAddress) throws IOException {
        ServerSocket serverSocket = null;
        if (this.isReady()) {
            String string = inetSocketAddress.getAddress().getHostAddress();
            int n = inetSocketAddress.getPort();
            if (string.equals("0.0.0.0")) {
                string = this.m_comSocket.getLocalAddress().getHostAddress();
            }
            serverSocket = new ServerSocket();
            serverSocket.setReuseAddress(true);
            if (n > 0) {
                serverSocket.bind(new InetSocketAddress("0.0.0.0", n));
            } else {
                serverSocket.bind(null);
            }
            serverSocket.setSoTimeout(this.m_activeTimeOut);
            n = serverSocket.getLocalPort();
            string = string.replace('.', ',');
            string = string + ',';
            string = string + Integer.toString(n / 256);
            string = string + ',';
            string = string + Integer.toString(n % 256);
            this.m_comBuffWriter.write("PORT " + string + "\r\n");
            this.m_comBuffWriter.flush();
            this.getMessage(this.m_comTimeOut);
            if (this.m_lastReplyCode != 200) {
                serverSocket.close();
                serverSocket = null;
            }
        }
        return serverSocket;
    }

    protected boolean doActiveSimple(InetSocketAddress inetSocketAddress) {
        boolean bl = false;
        if (inetSocketAddress != null && this.isReady()) {
            try {
                String string = inetSocketAddress.getAddress().getHostAddress();
                int n = inetSocketAddress.getPort();
                string = string.replace('.', ',');
                string = string + ',';
                string = string + Integer.toString(n / 256);
                string = string + ',';
                string = string + Integer.toString(n % 256);
                this.m_comBuffWriter.write("PORT " + string + "\r\n");
                this.m_comBuffWriter.flush();
                this.getMessage(this.m_comTimeOut);
                bl = true;
                if (this.m_lastReplyCode != 200) {
                    bl = false;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return bl;
    }

    protected boolean doLogin(String string, String string2, String string3) {
        boolean bl = false;
        try {
            this.m_comBuffWriter.write("USER " + string + "\r\n");
            this.m_comBuffWriter.flush();
            this.getMessage(this.m_comTimeOut);
            if (this.m_lastReplyCode == 331) {
                this.m_comBuffWriter.write("PASS " + string2 + "\r\n");
                this.m_comBuffWriter.flush();
                this.getMessage(this.m_comTimeOut);
                if (this.m_lastReplyCode == 230) {
                    bl = true;
                } else if (this.m_lastReplyCode == 332) {
                    this.m_comBuffWriter.write("ACCT " + string3 + "\r\n");
                    this.m_comBuffWriter.flush();
                    this.getMessage(this.m_comTimeOut);
                    if (this.m_lastReplyCode == 230) {
                        bl = true;
                    }
                }
            } else if (this.m_lastReplyCode == 230) {
                bl = true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return bl;
    }

    public boolean setDataType(char c) {
        boolean bl = false;
        try {
            this.m_comBuffWriter.write("TYPE " + c + "\r\n");
            this.m_comBuffWriter.flush();
            this.getMessage(this.m_comTimeOut);
            if (this.m_lastReplyCode == 200) {
                bl = true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return bl;
    }

    public boolean setTransferMode(char c) {
        boolean bl = false;
        try {
            this.m_comBuffWriter.write("MODE " + c + "\r\n");
            this.m_comBuffWriter.flush();
            this.getMessage(this.m_comTimeOut);
            if (this.m_lastReplyCode == 200) {
                bl = true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return bl;
    }

    protected String getMessage(int n) {
        return this.getMessage(n, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String getMessage(int n, int n2) {
        String string = null;
        String string2 = null;
        try {
            this.m_comSocket.setSoTimeout(n);
            int n3 = n2 > 0 ? n2 : -1;
            Boolean bl = false;
            while (true) {
                int n4;
                if (!bl.booleanValue() && n3 >= 0) {
                    if (n3-- <= 0) return string;
                }
                if ((string2 = this.m_comBufReader.readLine()) == null) {
                    return string;
                }
                if (string == null) {
                    string = string2;
                }
                if ((n4 = this.getReplyCode(string2, bl)) > 0) {
                    if (bl.booleanValue() && n4 == this.m_lastReplyCode) {
                        bl = false;
                        n3 = 0;
                    } else {
                        this.m_lastReplyCode = n4;
                    }
                } else if (n4 < 0) {
                    this.m_lastReplyCode = -n4;
                    bl = true;
                }
                ArrayList<String> arrayList = this.m_messages;
                synchronized (arrayList) {
                    this.m_messages.add(string2);
                    if (m_isDebug) {
                        System.err.println(string2);
                    }
                }
            }
        }
        catch (SocketException socketException) {
            return string;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return string;
    }

    protected int getReplyCode(String string, Boolean bl) {
        Pattern pattern;
        Matcher matcher;
        int n = 0;
        if (string != null && (matcher = (pattern = Pattern.compile("^(\\d{3})(-|\\s+).*")).matcher(string)).find()) {
            n = Integer.parseInt(matcher.group(1));
            if (matcher.group(2).equals("-")) {
                n = -n;
            }
        }
        return n;
    }

    @Override
    public boolean notify(ProgNotify progNotify) {
        boolean bl = true;
        boolean bl2 = false;
        FtpNotify ftpNotify = (FtpNotify)progNotify;
        if (ftpNotify.getReason() == 2) {
            this.getMessage(this.m_comTimeOut);
            if (this.m_lastReplyCode == 226) {
                bl2 = true;
            }
            this.m_dataThread = null;
        } else if (ftpNotify.getReason() == -2 || ftpNotify.getReason() == -1) {
            this.m_dataThread = null;
        }
        if (ftpNotify.getType() == 1) {
            if (ftpNotify.getReason() == 0) {
                if (m_isDebug) {
                    System.err.println("List start");
                }
            } else if (ftpNotify.getReason() == 1) {
                FtpNotify ftpNotify2 = ftpNotify;
                String string = (String)ftpNotify2.getData();
                if (m_isDebug) {
                    System.err.println("List :" + string);
                }
            } else if (ftpNotify.getReason() == 2) {
                FtpNotify ftpNotify3 = ftpNotify;
                ArrayList arrayList = (ArrayList)ftpNotify3.getData();
                if (m_isDebug) {
                    System.err.println("List results:");
                    for (String string : arrayList) {
                        System.err.println(string);
                        this.parseListLine(string);
                    }
                }
                this.m_lastListOutput = arrayList;
            } else if (ftpNotify.getReason() == -1) {
                if (m_isDebug) {
                    System.err.println("List error");
                }
            } else if (ftpNotify.getReason() == -2) {
                FtpNotify ftpNotify4 = ftpNotify;
                ArrayList arrayList = (ArrayList)ftpNotify4.getData();
                if (m_isDebug) {
                    System.err.println("List abort");
                    for (String string : arrayList) {
                        System.err.println(string);
                    }
                }
            }
        } else if (ftpNotify.getType() == 2) {
            if (ftpNotify.getReason() == 0) {
                FtpNotify ftpNotify5 = ftpNotify;
                String string = (String)ftpNotify5.getData();
                if (m_isDebug) {
                    System.err.println("Retr start of '" + string + "'");
                }
            } else if (ftpNotify.getReason() == 1) {
                if (m_isDebug) {
                    System.err.println("Retr :" + ftpNotify.getData().toString());
                }
            } else if (ftpNotify.getReason() == 2) {
                FtpNotify ftpNotify6 = ftpNotify;
                Long l = (Long)ftpNotify6.getData();
                if (m_isDebug) {
                    System.err.println("Retr end fileSize = " + l);
                }
            } else if (ftpNotify.getReason() == -1) {
                FtpNotify ftpNotify7 = ftpNotify;
                String string = (String)ftpNotify7.getData();
                if (m_isDebug) {
                    if (string != null) {
                        System.err.println("Retr error tempfile = '" + string + "'");
                    } else {
                        System.err.println("Retr error");
                    }
                }
            } else if (ftpNotify.getReason() == -2) {
                FtpNotify ftpNotify8 = ftpNotify;
                Long l = (Long)ftpNotify8.getData();
                if (m_isDebug) {
                    System.err.println("Retr abort fileSize = " + l);
                }
            }
        } else if (ftpNotify.getType() == 3) {
            if (ftpNotify.getReason() == 0) {
                FtpNotify ftpNotify9 = ftpNotify;
                String string = (String)ftpNotify9.getData();
                if (m_isDebug) {
                    System.err.println("Stor start of '" + string + "'");
                }
            } else if (ftpNotify.getReason() == 1) {
                if (m_isDebug) {
                    System.err.println("Stor :" + ftpNotify.getData().toString());
                }
            } else if (ftpNotify.getReason() == 2) {
                if (this.m_tempFileNames != null) {
                    this.renameInternal(this.m_tempFileNames[0], this.m_tempFileNames[1]);
                }
                FtpNotify ftpNotify10 = ftpNotify;
                Long l = (Long)ftpNotify10.getData();
                if (m_isDebug) {
                    System.err.println("Stor end fileSize = " + l);
                }
            } else if (ftpNotify.getReason() == -1) {
                FtpNotify ftpNotify11 = ftpNotify;
                String string = (String)ftpNotify11.getData();
                if (m_isDebug) {
                    if (string != null) {
                        System.err.println("Stor error tempfile = '" + string + "'");
                    } else {
                        System.err.println("Stor error");
                    }
                }
            } else if (ftpNotify.getReason() == -2) {
                FtpNotify ftpNotify12 = ftpNotify;
                Long l = (Long)ftpNotify12.getData();
                if (m_isDebug) {
                    System.err.println("Stor abort fileSize = " + l);
                }
            }
        }
        return bl;
    }

    public JFtpFile parseListLine(String string) {
        Matcher matcher;
        String string2;
        JFtpFile jFtpFile = null;
        Calendar calendar = Calendar.getInstance();
        Calendar calendar2 = Calendar.getInstance();
        calendar.set(14, 0);
        calendar.set(13, 0);
        Pattern pattern = Pattern.compile("([dl-])((?:[r-][w-][xst-]){3})\\s+(\\d+)\\s+([^\\s]+)\\s+([^\\s]+)\\s+(\\d+)\\s+([a-zA-Z]{3})\\s+(\\d{1,2})\\s+(\\d{4}|\\d{2}:\\d{2})\\s+(.+)");
        Matcher matcher2 = pattern.matcher(string);
        if (matcher2.matches()) {
            jFtpFile = new JFtpFile();
            if (matcher2.group(1).equals("-")) {
                jFtpFile.setType(1);
            } else if (matcher2.group(1).equals("d")) {
                jFtpFile.setType(2);
            } else if (matcher2.group(1).equals("l")) {
                jFtpFile.setType(3);
            }
            jFtpFile.setRights(matcher2.group(2));
            jFtpFile.setNumberOfHardLinks(Integer.parseInt(matcher2.group(3)));
            jFtpFile.setUser(matcher2.group(4));
            jFtpFile.setGroup(matcher2.group(5));
            jFtpFile.setSize(Long.parseLong(matcher2.group(6)));
            string2 = matcher2.group(7);
            if (string2.equalsIgnoreCase("jan")) {
                calendar.set(2, 0);
            } else if (string2.equalsIgnoreCase("feb")) {
                calendar.set(2, 1);
            } else if (string2.equalsIgnoreCase("mar")) {
                calendar.set(2, 2);
            } else if (string2.equalsIgnoreCase("apr")) {
                calendar.set(2, 3);
            } else if (string2.equalsIgnoreCase("may")) {
                calendar.set(2, 4);
            } else if (string2.equalsIgnoreCase("jun")) {
                calendar.set(2, 5);
            } else if (string2.equalsIgnoreCase("jul")) {
                calendar.set(2, 6);
            } else if (string2.equalsIgnoreCase("aug")) {
                calendar.set(2, 7);
            } else if (string2.equalsIgnoreCase("sep")) {
                calendar.set(2, 8);
            } else if (string2.equalsIgnoreCase("oct")) {
                calendar.set(2, 9);
            } else if (string2.equalsIgnoreCase("nov")) {
                calendar.set(2, 10);
            } else if (string2.equalsIgnoreCase("dec")) {
                calendar.set(2, 11);
            }
            calendar.set(5, Integer.parseInt(matcher2.group(8)));
            jFtpFile.setTimeStamp(calendar);
            pattern = Pattern.compile("(\\d{2}):(\\d{2})");
            matcher = pattern.matcher(matcher2.group(9));
            if (matcher.matches()) {
                calendar.set(11, Integer.parseInt(matcher.group(1)));
                calendar.set(12, Integer.parseInt(matcher.group(2)));
                if (calendar.get(2) > calendar2.get(2)) {
                    calendar.set(1, calendar.get(1) - 1);
                }
            } else {
                calendar.set(11, 0);
                calendar.set(12, 0);
                calendar.set(1, Integer.parseInt(matcher2.group(9)));
            }
            jFtpFile.setName(matcher2.group(10));
            this.m_bHasLastListOutputHardlinks = true;
        }
        if (jFtpFile == null && (matcher2 = (pattern = Pattern.compile("([dl-])((?:[r-][w-][xst-]){3})\\s+([^\\s]+)\\s+(\\d+)\\s+(\\d+)\\s+([a-zA-Z]{3})\\s+(\\d{1,2})\\s+(\\d{4}|\\d{2}:\\d{2})\\s+(.+)")).matcher(string)).matches()) {
            jFtpFile = new JFtpFile();
            if (matcher2.group(1).equals("-")) {
                jFtpFile.setType(1);
            } else if (matcher2.group(1).equals("d")) {
                jFtpFile.setType(2);
            } else if (matcher2.group(1).equals("l")) {
                jFtpFile.setType(3);
            }
            jFtpFile.setRights(matcher2.group(2));
            jFtpFile.setNumberOfHardLinks(Integer.parseInt(matcher2.group(3)));
            jFtpFile.setUser(matcher2.group(4));
            jFtpFile.setSize(Long.parseLong(matcher2.group(5)));
            string2 = matcher2.group(6);
            if (string2.equalsIgnoreCase("jan")) {
                calendar.set(2, 0);
            } else if (string2.equalsIgnoreCase("feb")) {
                calendar.set(2, 1);
            } else if (string2.equalsIgnoreCase("mar")) {
                calendar.set(2, 2);
            } else if (string2.equalsIgnoreCase("apr")) {
                calendar.set(2, 3);
            } else if (string2.equalsIgnoreCase("may")) {
                calendar.set(2, 4);
            } else if (string2.equalsIgnoreCase("jun")) {
                calendar.set(2, 5);
            } else if (string2.equalsIgnoreCase("jul")) {
                calendar.set(2, 6);
            } else if (string2.equalsIgnoreCase("aug")) {
                calendar.set(2, 7);
            } else if (string2.equalsIgnoreCase("sep")) {
                calendar.set(2, 8);
            } else if (string2.equalsIgnoreCase("oct")) {
                calendar.set(2, 9);
            } else if (string2.equalsIgnoreCase("nov")) {
                calendar.set(2, 10);
            } else if (string2.equalsIgnoreCase("dec")) {
                calendar.set(2, 11);
            }
            calendar.set(5, Integer.parseInt(matcher2.group(7)));
            jFtpFile.setTimeStamp(calendar);
            pattern = Pattern.compile("(\\d{2}):(\\d{2})");
            matcher = pattern.matcher(matcher2.group(8));
            if (matcher.matches()) {
                calendar.set(11, Integer.parseInt(matcher.group(1)));
                calendar.set(12, Integer.parseInt(matcher.group(2)));
                if (calendar.get(2) > calendar2.get(2)) {
                    calendar.set(1, calendar.get(1) - 1);
                }
            } else {
                calendar.set(11, 0);
                calendar.set(12, 0);
                calendar.set(1, Integer.parseInt(matcher2.group(8)));
            }
            jFtpFile.setName(matcher2.group(9));
            this.m_bHasLastListOutputHardlinks = true;
        }
        if (jFtpFile == null && (matcher2 = (pattern = Pattern.compile("([dl-])((?:[r-][w-][xst-]){3})\\s+(\\d+)\\s+([^\\s]+)\\s+(\\d+)\\s+([a-zA-Z]{3})\\s+(\\d{1,2})\\s+(\\d{4}|\\d{2}:\\d{2})\\s+(.+)")).matcher(string)).matches()) {
            jFtpFile = new JFtpFile();
            if (matcher2.group(1).equals("-")) {
                jFtpFile.setType(1);
            } else if (matcher2.group(1).equals("d")) {
                jFtpFile.setType(2);
            } else if (matcher2.group(1).equals("l")) {
                jFtpFile.setType(3);
            }
            jFtpFile.setRights(matcher2.group(2));
            jFtpFile.setNumberOfHardLinks(Integer.parseInt(matcher2.group(3)));
            jFtpFile.setUser(matcher2.group(4));
            jFtpFile.setSize(Long.parseLong(matcher2.group(5)));
            string2 = matcher2.group(6);
            if (string2.equalsIgnoreCase("jan")) {
                calendar.set(2, 0);
            } else if (string2.equalsIgnoreCase("feb")) {
                calendar.set(2, 1);
            } else if (string2.equalsIgnoreCase("mar")) {
                calendar.set(2, 2);
            } else if (string2.equalsIgnoreCase("apr")) {
                calendar.set(2, 3);
            } else if (string2.equalsIgnoreCase("may")) {
                calendar.set(2, 4);
            } else if (string2.equalsIgnoreCase("jun")) {
                calendar.set(2, 5);
            } else if (string2.equalsIgnoreCase("jul")) {
                calendar.set(2, 6);
            } else if (string2.equalsIgnoreCase("aug")) {
                calendar.set(2, 7);
            } else if (string2.equalsIgnoreCase("sep")) {
                calendar.set(2, 8);
            } else if (string2.equalsIgnoreCase("oct")) {
                calendar.set(2, 9);
            } else if (string2.equalsIgnoreCase("nov")) {
                calendar.set(2, 10);
            } else if (string2.equalsIgnoreCase("dec")) {
                calendar.set(2, 11);
            }
            calendar.set(5, Integer.parseInt(matcher2.group(7)));
            jFtpFile.setTimeStamp(calendar);
            pattern = Pattern.compile("(\\d{2}):(\\d{2})");
            matcher = pattern.matcher(matcher2.group(8));
            if (matcher.matches()) {
                calendar.set(11, Integer.parseInt(matcher.group(1)));
                calendar.set(12, Integer.parseInt(matcher.group(2)));
                if (calendar.get(2) > calendar2.get(2)) {
                    calendar.set(1, calendar.get(1) - 1);
                }
            } else {
                calendar.set(11, 0);
                calendar.set(12, 0);
                calendar.set(1, Integer.parseInt(matcher2.group(8)));
            }
            jFtpFile.setName(matcher2.group(9));
            this.m_bHasLastListOutputHardlinks = true;
        }
        if (jFtpFile == null && (matcher2 = (pattern = Pattern.compile("([dl-])((?:[r-][w-][xst-]){3})\\s+(\\d+)\\s+([^\\s]+)\\s+@\\s+([^\\s]+)\\s+@\\s+(\\d+)\\s+([a-zA-Z]{3})\\s+(\\d{1,2})\\s+(\\d{4}|\\d{2}:\\d{2})\\s+(.+)")).matcher(string)).matches()) {
            jFtpFile = new JFtpFile();
            if (matcher2.group(1).equals("-")) {
                jFtpFile.setType(1);
            } else if (matcher2.group(1).equals("d")) {
                jFtpFile.setType(2);
            } else if (matcher2.group(1).equals("l")) {
                jFtpFile.setType(3);
            }
            jFtpFile.setRights(matcher2.group(2));
            jFtpFile.setNumberOfHardLinks(Integer.parseInt(matcher2.group(3)));
            jFtpFile.setUser(matcher2.group(4));
            jFtpFile.setGroup(matcher2.group(5));
            jFtpFile.setSize(Long.parseLong(matcher2.group(6)));
            string2 = matcher2.group(7);
            if (string2.equalsIgnoreCase("jan")) {
                calendar.set(2, 0);
            } else if (string2.equalsIgnoreCase("feb")) {
                calendar.set(2, 1);
            } else if (string2.equalsIgnoreCase("mar")) {
                calendar.set(2, 2);
            } else if (string2.equalsIgnoreCase("apr")) {
                calendar.set(2, 3);
            } else if (string2.equalsIgnoreCase("may")) {
                calendar.set(2, 4);
            } else if (string2.equalsIgnoreCase("jun")) {
                calendar.set(2, 5);
            } else if (string2.equalsIgnoreCase("jul")) {
                calendar.set(2, 6);
            } else if (string2.equalsIgnoreCase("aug")) {
                calendar.set(2, 7);
            } else if (string2.equalsIgnoreCase("sep")) {
                calendar.set(2, 8);
            } else if (string2.equalsIgnoreCase("oct")) {
                calendar.set(2, 9);
            } else if (string2.equalsIgnoreCase("nov")) {
                calendar.set(2, 10);
            } else if (string2.equalsIgnoreCase("dec")) {
                calendar.set(2, 11);
            }
            calendar.set(5, Integer.parseInt(matcher2.group(8)));
            jFtpFile.setTimeStamp(calendar);
            pattern = Pattern.compile("(\\d{2}):(\\d{2})");
            matcher = pattern.matcher(matcher2.group(9));
            if (matcher.matches()) {
                calendar.set(11, Integer.parseInt(matcher.group(1)));
                calendar.set(12, Integer.parseInt(matcher.group(2)));
                if (calendar.get(2) > calendar2.get(2)) {
                    calendar.set(1, calendar.get(1) - 1);
                }
            } else {
                calendar.set(11, 0);
                calendar.set(12, 0);
                calendar.set(1, Integer.parseInt(matcher2.group(9)));
            }
            jFtpFile.setName(matcher2.group(10));
            this.m_bHasLastListOutputHardlinks = true;
        }
        if (jFtpFile == null && (matcher2 = (pattern = Pattern.compile("(\\d{2})-(\\d{2})-(\\d{2})\\s+(\\d{2}):(\\d{2})([A|P]M)\\s+(<DIR>|\\d+)\\s+(.+)")).matcher(string)).matches()) {
            jFtpFile = new JFtpFile();
            calendar.set(2, Integer.parseInt(matcher2.group(1)) - 1);
            calendar.set(5, Integer.parseInt(matcher2.group(2)));
            calendar.set(1, Integer.parseInt(matcher2.group(3)));
            calendar.set(10, Integer.parseInt(matcher2.group(4)));
            calendar.set(12, Integer.parseInt(matcher2.group(5)));
            calendar.set(9, matcher2.group(6).equalsIgnoreCase("pm") ? 1 : 0);
            jFtpFile.setTimeStamp(calendar);
            try {
                jFtpFile.setSize(Long.parseLong(matcher2.group(7)));
                jFtpFile.setType(1);
            }
            catch (NumberFormatException numberFormatException) {
                jFtpFile.setType(2);
            }
            jFtpFile.setName(matcher2.group(8));
            this.m_bHasLastListOutputHardlinks = false;
        }
        if (m_isDebug && jFtpFile == null) {
            System.err.println("NO MATCH FOUND FOR '" + string + "'");
        }
        return jFtpFile;
    }

    private void closeSocket(Socket socket) {
        if (socket != null) {
            try {
                socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void closeSocket(ServerSocket serverSocket) {
        if (serverSocket != null) {
            try {
                serverSocket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

