<?xml version="1.0" encoding="utf-8"?>
<!DOCTYPE xsl:stylesheet SYSTEM "ui.dtd">
<xsl:stylesheet version="1.1" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output doctype-system="about:legacy-compat" method="html" indent="no" encoding="utf-8"/>

<xsl:template match="part[@name='profile']">
  <style>
    &css_form;
  </style>

  <div class="form-cnt">
    <xsl:apply-templates select="limit"/>
    <xsl:apply-templates select="used"/>
    <xsl:apply-templates select="depth-max"/>
    <xsl:apply-templates select="copy-to"/>

    <form enctype="multipart/form-data" method="post">

      <div class="form-cnt__form-ctl">
        <div class="form-ctl__caption">
          <xsl:value-of select="$strings/profile-password"/>
        </div>
        <div class="form-ctl__value">
          <input class="form-ctl__value__input" type="password" maxlength="255"
            name="password" autocomplete="new-password"/>
        </div>
      </div>
      <div class="form-cnt__form-ctl">
        <div class="form-ctl__caption">
          <xsl:value-of select="$strings/profile-password2"/>
        </div>
        <div class="form-ctl__value">
          <input class="form-ctl__value__input" type="password" maxlength="255"
            name="password2" autocomplete="new-password"/>
        </div>
      </div>

      <xsl:apply-templates select="vcard"/>

      <div class="form-apply-cnt">
        <input class="form-apply" type="submit" value="{$strings/submit}"/>
      </div>
    </form>
  </div>
</xsl:template>

<xsl:template match="limit|used|depth-max|copy-to">
  <xsl:if test="not(.='0' or .='' or .='0 B')">
    <xsl:variable name="prop" select="local-name()"/>
    <div class="form-cnt__form-ctl">
      <div class="form-ctl__caption">
        <xsl:value-of select="$strings/profile[@prop=$prop]"/>
      </div>
      <div class="form-ctl__value">
        <xsl:value-of select="."/>
      </div>
    </div>
  </xsl:if>
</xsl:template>


<xsl:template match="login-time">
  <div class="form-cnt__form-ctl">
    <div class="form-ctl__caption">
      <xsl:value-of select="$strings/profile[@prop='login-time']"/>
    </div>
    <div class="form-ctl__value">
      <xsl:call-template name="date-time">
        <xsl:with-param name="value" select="."/>
      </xsl:call-template>
    </div>  <!-- form-ctl__value -->
  </div>  <!-- form-cnt__form-ctl -->
</xsl:template>  <!-- login-time -->

</xsl:stylesheet>
