<?xml version="1.0" encoding="utf-8"?>
<!DOCTYPE xsl:stylesheet SYSTEM "ui.dtd">
<xsl:stylesheet version="1.1" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output doctype-system="about:legacy-compat" method="html" indent="no" encoding="utf-8"/>

<xsl:template match="part[@name='abdomain']">
  <xsl:apply-templates select="list"/>
</xsl:template>


<!--
     AB domain items (users)
-->

<xsl:template match="part[@name='abdomain']/list">
  <style>
    &css_part_ab_control;
  </style>
  <div class="list">
    <xsl:apply-templates select="item"/>
  </div>
</xsl:template>

<xsl:template match="part[@name='abdomain']/list/item">
  <div class="list__row">
    <div class="row__caption">
      <xsl:value-of select="."/>
    </div>
    <form class="row__control" enctype="multipart/form-data" method="post">
      <input type="hidden" name="o" value="{.}"/>

      <xsl:if test="not(@hidden)">
        <input type="hidden" name="hide" value="on"/>
      </xsl:if>

      <label>
        <xsl:choose>
          <xsl:when test="@hidden">
            <xsl:attribute name="class">row__control__switch row__control__switch--off</xsl:attribute>
          </xsl:when>
          <xsl:otherwise>
            <xsl:attribute name="class">row__control__switch row__control__switch--on</xsl:attribute>
          </xsl:otherwise>
        </xsl:choose>
        <input type="submit"/>
      </label>
    </form>
  </div>
</xsl:template>

</xsl:stylesheet>
