<?xml version="1.0" encoding="utf-8"?>
<!DOCTYPE xsl:stylesheet SYSTEM "ui.dtd">
<xsl:stylesheet version="1.1" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:mm="http://os2.snc.ru/manjary/xslt">
<xsl:output doctype-system="about:legacy-compat" method="html" indent="no" encoding="utf-8"/>

<xsl:template match="part[@name='ab']">
  <xsl:apply-templates select="property"/>
</xsl:template>


<!--
     AB properties: search
-->

<xsl:template match="part[@name='ab']/property[@name='search']">
  <style>
    &css_part_ab_search;
  </style>
  <div class="ab-list">
    <xsl:apply-templates select="item"/>
  </div>
</xsl:template>

<xsl:template match="property[@name='search']/item">
  <div class="ab-list__entry">
    <xsl:apply-templates select="persone"/>
    <xsl:if test="o or ou or title">
      <div class="entry__job-info">
        <xsl:apply-templates select="o"/>
        <xsl:apply-templates select="ou"/>
        <xsl:apply-templates select="title"/>
      </div>
    </xsl:if>
    <xsl:if test="addr or other-mailbox">
      <a class="ab-list__entry__vcard" href="vcard{$uri-ext}?o={mm:encode-uri(addr)}">vCard</a>
      <div class="entry__addr-list">
        <xsl:apply-templates select="addr"/>
        <xsl:apply-templates select="other-mailbox"/>
      </div>
    </xsl:if>
  </div>
</xsl:template>

<xsl:template match="persone">
  <div class="entry__persone">
    <xsl:value-of select="."/>
  </div>
</xsl:template>

<xsl:template match="o|ou|title">
  <div class="job-info__item">
    <xsl:value-of select="."/>
  </div>
</xsl:template>

<xsl:template match="addr|other-mailbox">
  <a class="addr-list__email" href="mailto:{mm:encode-uri(.)}">
    <xsl:value-of select="."/>
  </a>
</xsl:template>


<!--
     AB properties: control (domain list)
-->

<xsl:template match="part[@name='ab']/property[@name='control']">
  <style>
    &css_part_ab_control;
  </style>
  <div class="list">
    <xsl:apply-templates select="item"/>
  </div>
</xsl:template>

<xsl:template match="property[@name='control']/item">
  <div class="list__row">
    <a class="row__caption" href="abdomain{$uri-ext}?o={mm:encode-uri(.)}">
      <xsl:value-of select="."/>
    </a>
    <form class="row__control" enctype="multipart/form-data" method="post">
      <input type="hidden" name="o" value="{.}"/>

      <xsl:if test="not(@hidden)">
        <input type="hidden" name="hide" value="on"/>
      </xsl:if>

      <label>
        <xsl:choose>
          <xsl:when test="@hidden">
            <xsl:attribute name="class">row__control__switch row__control__switch--off</xsl:attribute>
          </xsl:when>
          <xsl:otherwise>
            <xsl:attribute name="class">row__control__switch row__control__switch--on</xsl:attribute>
          </xsl:otherwise>
        </xsl:choose>
        <input type="submit"/>
      </label>
    </form>
  </div>
</xsl:template>

</xsl:stylesheet>
