<?xml version="1.0" encoding="utf-8"?>
<!DOCTYPE xsl:stylesheet SYSTEM "ui.dtd">
<xsl:stylesheet xmlns:xsl = "http://www.w3.org/1999/XSL/Transform" version = "1.0" xmlns="http://www.w3.org/1999/xhtml">
<xsl:output doctype-system="about:legacy-compat" method="html" indent="no" encoding="utf-8"/>

<xsl:template match="/logon">
  <head>
    <title>Manjary management - logon</title>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <meta name="viewport" content="width=device-width, user-scalable=no"/>
    <style>
      body {
        position: absolute;
        top: 0;
        right: 0;
        bottom: 0;
        left: 0;
        text-align: center;
        background-color: &clr_bg;;
        color: &clr_txt;;
      }
      body:before {
        content: '';
        display: inline-block;
        height: 85%;
        vertical-align: middle;
      }

      svg { fill: &clr9;; }

      .logon-form {
        position: relative;
        display: inline-flex;
        flex-direction: column;
        vertical-align: middle;
        max-width: 320px;
        min-width: 200pt;
      }

      .logon-form__cover {
        display: none;
        position: absolute;
        z-index: 1;
        top: 0;
        width: 100%;
        height: 100%;
        background-color: &clr_bg;;
        opacity: 0.5;
        align-items: center;
        justify-content: center;
      }

      @keyframes progress_point {
        from, 5% { opacity: 1; }
        95%, to { opacity: 0.1; }
      }

      .cover__point {
        animation: progress_point 1s infinite alternate;
        display: inline-block;
        width: 13pt;
        height: 13pt;
        margin: 0 4pt;
        border-radius: 3pt;
        background-color: &clr8;;
      }
      .point--1 { animation-delay: -1s }
      .point--2 { animation-delay: -0.5s; }

      .logon-form__input-cnt {
        display: flex;
        align-items: center;
        margin: 4pt 0;
        padding: 1px;
        background-color: &clr2;;
        border: solid 1px &clr5;;
        border-radius: 3pt;
      }

      .input-cnt__icon {
        margin: 0;
        padding: 0 5pt;
        background-color: &clr2;;
        border-right: solid 1px &clr5;;
      }

      .input-cnt__input {
        min-width: 150pt;
        flex-grow: 1;
        margin: 0 auto;
        padding: 4pt 5pt;
        outline: none;
        border: 0;
        appearance: none;
        -webkit-appearance: none;
        -moz-appearance: none;
        font-family: sans-serif;
        font-size: 15pt;
        color: &clr9;;
        background-color: &clr1;;
      }
      input:is(:-webkit-autofill, :autofill) {
        -webkit-text-fill-color: &clr9;;
        -webkit-box-shadow: 0 0 0px 1000px &clr1; inset;
        transition: background-color 5000s ease-in-out 0s;
      }

      .logon-form__submit {
        margin-top: 5pt;
        height: 30pt;
        border-radius: 3pt;
        font-size: 15pt;
        outline: 0;
        border: 0;
        color: &clr_btn_txt;;
        background-color: &clr_btn_bg;;
      }
      .logon-form__submit:hover, .logon-form__submit:focus {
        background-color: &clr_btn_hover;;
      }

      <xsl:if test="notification">
        &css_main_notifications;
      </xsl:if>
    </style>
  </head>
  <body>
    <form class="logon-form" method="post"
      onsubmit="document.getElementById('logon-form__cover').style.setProperty('display','flex');">
      <div class="logon-form__cover" id="logon-form__cover">
        <div class="cover__point point--1"></div>
        <div class="cover__point point--2"></div>
        <div class="cover__point"></div>
      </div>

      <xsl:apply-templates select="servers"/>

      <div class="logon-form__input-cnt">
        <div class="input-cnt__icon">
          <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" fill="currentColor" viewBox="0 0 16 16">
            <path d="M3 14s-1 0-1-1 1-4 6-4 6 3 6 4-1 1-1 1zm5-6a3 3 0 1 0 0-6 3 3 0 0 0 0 6"/>
          </svg>
        </div>
        <input class="input-cnt__input" autofocus="1" type="text" name="username" autocomplete="on" placeholder="{$strings/logon-user}" value="{username}"/>
      </div>

      <div class="logon-form__input-cnt">
        <div class="input-cnt__icon">
          <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" fill="currentColor" viewBox="0 0 16 16">
            <path d="M8 1a2 2 0 0 1 2 2v4H6V3a2 2 0 0 1 2-2m3 6V3a3 3 0 0 0-6 0v4a2 2 0 0 0-2 2v5a2 2 0 0 0 2 2h6a2 2 0 0 0 2-2V9a2 2 0 0 0-2-2"/>
          </svg>
        </div>
        <input class="input-cnt__input" type="password" name="password" autocomplete="current-password" placeholder="{$strings/logon-password}"/>
      </div>

      <div class="logon-form__input-cnt">
        <div class="input-cnt__icon">
          <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" fill="currentColor" class="bi bi-globe" viewBox="0 0 16 16">
            <path d="M0 8a8 8 0 1 1 16 0A8 8 0 0 1 0 8m7.5-6.923c-.67.204-1.335.82-1.887 1.855A8 8 0 0 0 5.145 4H7.5zM4.09 4a9.3 9.3 0 0 1 .64-1.539 7 7 0 0 1 .597-.933A7.03 7.03 0 0 0 2.255 4zm-.582 3.5c.03-.877.138-1.718.312-2.5H1.674a7 7 0 0 0-.656 2.5zM4.847 5a12.5 12.5 0 0 0-.338 2.5H7.5V5zM8.5 5v2.5h2.99a12.5 12.5 0 0 0-.337-2.5zM4.51 8.5a12.5 12.5 0 0 0 .337 2.5H7.5V8.5zm3.99 0V11h2.653c.187-.765.306-1.608.338-2.5zM5.145 12q.208.58.468 1.068c.552 1.035 1.218 1.65 1.887 1.855V12zm.182 2.472a7 7 0 0 1-.597-.933A9.3 9.3 0 0 1 4.09 12H2.255a7 7 0 0 0 3.072 2.472M3.82 11a13.7 13.7 0 0 1-.312-2.5h-2.49c.062.89.291 1.733.656 2.5zm6.853 3.472A7 7 0 0 0 13.745 12H11.91a9.3 9.3 0 0 1-.64 1.539 7 7 0 0 1-.597.933M8.5 12v2.923c.67-.204 1.335-.82 1.887-1.855q.26-.487.468-1.068zm3.68-1h2.146c.365-.767.594-1.61.656-2.5h-2.49a13.7 13.7 0 0 1-.312 2.5m2.802-3.5a7 7 0 0 0-.656-2.5H12.18c.174.782.282 1.623.312 2.5zM11.27 2.461c.247.464.462.98.64 1.539h1.835a7 7 0 0 0-3.072-2.472c.218.284.418.598.597.933M10.855 4a8 8 0 0 0-.468-1.068C9.835 1.897 9.17 1.282 8.5 1.077V4z"/>
          </svg>
        </div>
        <select class="input-cnt__input" name="lang">
          <xsl:apply-templates select="$lang-list/item" mode="lang-list"/>
        </select>
      </div>

      <input class="logon-form__submit" type="submit" value="{$strings/logon-submit}"/>

    </form>
<!-- Check colors
    <style>span{display:inline-block;width:20pt;height:20pt;}</style>
    <div>
      <span style="background:&clr1;;"> 1 </span>
      <span style="background:&clr2;;"> 2 </span>
      <span style="background:&clr3;;"> 3 </span>
      <span style="background:&clr4;;"> 4 </span>
      <span style="background:&clr5;;"> 5 </span>
      <span style="background:&clr6;;"> 6 </span>
      <span style="background:&clr7;;"> 7 </span>
      <span style="background:&clr8;;"> 8 </span>
      <span style="background:&clr9;;"> 9 </span>
      <span style="background:&clrA;;"> A </span>
    </div>
-->

    <xsl:if test="notification">
      <xsl:if test="notification[@type='warning']">
        <svg style="display: none;" xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 16 16">
          <symbol id="warning-svg">
            <path d="M8.982 1.566a1.13 1.13 0 0 0-1.96 0L.165 13.233c-.457.778.091 1.767.98 1.767h13.713c.889 0 1.438-.99.98-1.767zM8 5c.535 0 .954.462.9.995l-.35 3.507a.552.552 0 0 1-1.1 0L7.1 5.995A.905.905 0 0 1 8 5m.002 6a1 1 0 1 1 0 2 1 1 0 0 1 0-2"/>
          </symbol>
        </svg>
      </xsl:if>
      <xsl:if test="notification[@type='information']">
        <svg style="display: none;" xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 16 16">
          <symbol id="information-svg">
            <path d="M8 16A8 8 0 1 0 8 0a8 8 0 0 0 0 16m.93-9.412-1 4.705c-.07.34.029.533.304.533.194 0 .487-.07.686-.246l-.088.416c-.287.346-.92.598-1.465.598-.703 0-1.002-.422-.808-1.319l.738-3.468c.064-.293.006-.399-.287-.47l-.451-.081.082-.381 2.29-.287zM8 5.5a1 1 0 1 1 0-2 1 1 0 0 1 0 2"/>
          </symbol>
        </svg>
      </xsl:if>
      <input type="checkbox" class="hide-notification" id="hide-notification" checked="checked"/>
      <label class="notification-back" for="hide-notification">
        <xsl:apply-templates select="notification[@msg-id]"/>
        <xsl:apply-templates select="notification[not(@msg-id)]"/>
      </label>
    </xsl:if>
  </body>
</xsl:template>

<xsl:template match="item" mode="lang-list">
  <option value="{@name}">
    <xsl:if test="@name=$lang">
      <xsl:attribute name="selected">1</xsl:attribute>
    </xsl:if>
    <xsl:value-of select="."/>
  </option>
</xsl:template>

<xsl:template match="logon/notification">
  <!-- @msg-id - code to select language-depended text, text() - raw details. -->
  <div class="notification-box notification-box--{@type}">
    <svg class="notification-svg"
      xmlns:xlink="http://www.w3.org/1999/xlink" width="16" height="16" viewBox="0 0 16 16">
      <use xlink:href="#{@type}-svg" x="0" y="0"/>
    </svg>
    <xsl:if test="@msg-id">
      <xsl:variable name="msg-id" select="@msg-id"/>
      <div class="notification-box__msg">
        <xsl:value-of select="$strings/notification[@msg-id=$msg-id]"/>
      </div>
    </xsl:if>
    <xsl:if test="text()">
      <div class="notification-box__details">
        <xsl:value-of select="."/>
      </div>
    </xsl:if>
  </div>
</xsl:template>

<xsl:template match="servers">
  <div class="logon-form__input-cnt">
    <div class="input-cnt__icon">
      <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" fill="currentColor" viewBox="0 0 16 16">
        <path d="M1.333 2.667C1.333 1.194 4.318 0 8 0s6.667 1.194 6.667 2.667V4c0 1.473-2.985 2.667-6.667 2.667S1.333 5.473 1.333 4z"/>
        <path d="M1.333 6.334v3C1.333 10.805 4.318 12 8 12s6.667-1.194 6.667-2.667V6.334a6.5 6.5 0 0 1-1.458.79C11.81 7.684 9.967 8 8 8s-3.809-.317-5.208-.876a6.5 6.5 0 0 1-1.458-.79z"/>
        <path d="M14.667 11.668a6.5 6.5 0 0 1-1.458.789c-1.4.56-3.242.876-5.21.876-1.966 0-3.809-.316-5.208-.876a6.5 6.5 0 0 1-1.458-.79v1.666C1.333 14.806 4.318 16 8 16s6.667-1.194 6.667-2.667z"/>
      </svg>
    </div>
    <select class="input-cnt__input" name="server">
      <xsl:if test="@local">
        <option value="">
          <xsl:value-of select="$strings/logon-local"/>
        </option>
      </xsl:if>
      <xsl:apply-templates select="item"/>
    </select>
  </div>
</xsl:template>

<xsl:template match="item">
  <option>
    <xsl:if test="@selected">
      <xsl:attribute name="selected">1</xsl:attribute>
    </xsl:if>
    <xsl:value-of select="."/>
  </option>
</xsl:template>

</xsl:stylesheet>
