/*
   Example of using the RXMMP library.

   The example demonstrates changing user vCard (personal data) using the
   mmpSetVCStem() function.
*/


/* Your data for connecting to the MMP server. */
MMPServer = "localhost:2010"
MMPUser = "postmaster"
MMPPassword = "ChangeMe"

/* The user for whom the vCard will be rewritten. */
User = "u1"


/* Load functions from rxmmp.dll */
if RxFuncQuery("mmpLoadFuncs") then
do
  call RxFuncAdd "mmpLoadFuncs", "RXMMP", "mmpLoadFuncs"
  call mmpLoadFuncs
end

/* Connect to the MMP server and log in. */

MMPHandle = mmpCreate( MMPServer, MMPUser, MMPPassword )
parse var MMPHandle resStatus ":" resError
if resStatus = "ERROR" then
  call die "mmpCreate", resStatus, resError

/* vCard data */

vc.!N_FAMILY = "MyFamily"
vc.!N_GIVEN = "MyName"
vc.!N_MID = ""
vc.!N_PREF = "mr."
vc.!N_SUFF = ""
vc.!ORG = "My organization"
vc.!ORG_DEP = "My department"
vc.!TEL_HOME = "111"
vc.!TEL_WORK = "222"
vc.!TEL_CELL = "333"
vc.!FN = "Test User"
vc.!NICKNAME = "My nick"
vc.!TITLE = "My job title"
vc.!EMAIL = "other@domain.invalid"
vc.!NOTE = "This is just a test."

/* Set vCard data */

parse value mmpSetVCStem( MMPHandle, "vc.!", User ) with resStatus ":" resError
if resStatus \= "SUCCESS" then
  call die "mmpSetVCStem", resStatus, resError

say "Done"

call mmpDestroy( MMPHandle )
call mmpDropFuncs

exit


/* DIE func.name, result status, error text */
die:
  say arg(1) || "(): " || arg(2) || " (" || arg(3) || ")"
  call mmpDropFuncs
  exit
