const gl_iEntriesMax = 500;
const gl_iDelayMax = 6500;
const gl_iDelayMin = 1000;
const gl_iDelayStep = 500;
const gl_reDTBegin = /^\d{8}\s\d{6}/;
var gl_iLastId = 0;
var gl_timerId = NaN;
var gl_fPause = false;
var gl_iDelay = 3000;
var gl_fDate = false;

function _logReceived(xmlRoot) {
  const elCont = document.getElementById( "log-entries__cont" );
  var iEntries = elCont.childNodes.length;

  gl_iDelay += gl_iDelayStep;
  if ( gl_iDelay > gl_iDelayMax ) gl_iDelay = gl_iDelayMax;

  gl_iLastId = parseInt( xmlRoot.getAttribute( "last-id" ) );

  if ( xmlRoot.getAttribute( "missing-entries" ) == "1" ) {
    elE = document.createElement( "div" );
    elE.appendChild( document.createTextNode( "...missing entries..." ) );
    elCont.insertBefore( elE, elCont.firstChild );
  }

  for(xmlE of xmlRoot.childNodes) {
    if ( xmlE.nodeType != 1 || xmlE.nodeName != "e" )
      continue;

    // Delete unnecessary old entries
    while( iEntries >= gl_iEntriesMax ) {
      elCont.removeChild( elCont.lastChild );
      iEntries--;
    }

    var strE = xmlE.firstChild.textContent;
    var elE = document.createElement( "div" );

    elE.classList.add( "log-entries__cont__entry" );

    if ( gl_reDTBegin.test( strE ) ) {
      /* Date and time */
      var elDT = document.createElement( "span" );
      elDT.appendChild( document.createTextNode( strE.slice(0,4) + "-" + strE.slice(4,6) + "-" + strE.slice(6,8)
                        + " " ) );
      if ( !gl_fDate ) elDT.classList.add( "invisible" );
      elE.appendChild( elDT );

      elDT = document.createElement( "span" );
      elDT.appendChild( document.createTextNode( strE.slice(9,11) + ":" + strE.slice(11,13) + ":" + strE.slice(13,15)
                        + " " ) );
      elE.appendChild( elDT );
      strE = strE.slice(16);
    }

    elE.appendChild( document.createTextNode( strE ) );

    // Insert new element at the beginning
    elCont.insertBefore( elE, elCont.firstChild );

    iEntries++;
    gl_iDelay = gl_iDelayMin;
  }

  if ( !gl_fPause )
    gl_timerId = setTimeout( logUpdate, gl_iDelay );
}

function logUpdate() {
  const oReq = new XMLHttpRequest();

  oReq.open( "GET", "dynamic-log.mm?stop-id="+gl_iLastId, true );
  oReq.onload = function() {
    if ( oReq.status == 200 ) {
      if ( oReq.responseXML )
        _logReceived( oReq.responseXML.documentElement );
    }
    else
      alert( "HTTP error: " + oReq.status + " " + oReq.statusText );
  }

  oReq.send();
}

window.addEventListener( "load", function() {
  const elPauseBtn = document.getElementById( "ctrl-pad__btn" );

  elPauseBtn.className = "ctrl-pad__btn-pause";
  elPauseBtn.addEventListener( "click", function(e) {
    if ( gl_fPause ) {
      logUpdate();
      elPauseBtn.className = "ctrl-pad__btn-pause";
      const elCnt = document.getElementById( "log-entries__cont" );
      elCnt.scrollIntoView();
    } else {
      if ( !isNaN( gl_timerId ) ) { clearTimeout( gl_timerId ); gl_timerId = NaN; }
      elPauseBtn.className = "ctrl-pad__btn-play";
    }
    gl_fPause = !gl_fPause;
  }, true );


  const elDateCB = document.getElementById( "ctrl-pad__show-date-cb" );

  elDateCB.checked = gl_fDate;
  elDateCB.addEventListener( "change", function(e) {
    const elCont = document.getElementById( "log-entries__cont" );
    const aelDate = elCont.querySelectorAll( ".log-entries__cont__entry span:first-child" );

    gl_fDate = elDateCB.checked;
    for(elDate of aelDate)
      if ( gl_fDate ) elDate.classList.remove( "invisible" );
      else elDate.classList.add( "invisible" );
  } );


  logUpdate();
} );
