/*
   Example of using the RXMMP library.

   The example demonstrates querying user properties and vCards.

   To query user properties, low-level functions are used to form an MMP
   protocol command: mmpStmtCreate(), mmpStmtBind().

   The formed command is sent to the server by the mmpSendStmt() function and
   the result is received by the mmpRead() function.
*/


parse arg MMPServer MMPUser MMPPassword User

if User = "" then
do
  parse source srcOS " " srcMode " " srcFile
  srcFile = filespec( "name", srcFile )
  say "Usage: " || srcFile || " server:port username password user[@domain]"
  exit
end

/* Load functions from rxmmp.dll */
if RxFuncQuery("mmpLoadFuncs") then
do
  call RxFuncAdd "mmpLoadFuncs", "RXMMP", "mmpLoadFuncs"
  call mmpLoadFuncs
end

/* Connect to the MMP server and log in. */

MMPHandle = mmpCreate( MMPServer, MMPUser, MMPPassword )
parse var MMPHandle resStatus ":" resError
if resStatus = "ERROR" then
  call die "mmpCreate", resStatus, resError


/*
    User information.
*/

/* Prepare a command using the MMP statement. */

StmtHandle = mmpStmtCreate( "SET USER ?" )
parse var StmtHandle resStatus ":" resError
if resStatus = "ERROR" then
  call die "mmpStmtCreate", resStatus, resError

res = mmpStmtBind( StmtHandle, 0, User )
parse var res resStatus ":" resError
if resStatus \= "SUCCESS" then
  call die "mmpStmtBind", resStatus, resError

/* Send command */

res = mmpSendStmt( MMPHandle, StmtHandle )
parse var res resStatus ":" resError
if resStatus \= "SUCCESS" then
  call die "mmpSendStmt", resStatus, resError

/* We don't need the statement anymore. */
call mmpStmtDestroy StmtHandle

/* Receive information and output to console. */

do forever
  parse value mmpRead( MMPHandle, "reply" ) with resStatus ":" resError
  if resStatus \= "SUCCESS" then
    call die "mmpRead", resStatus, resError

  /* First item - reply type: * / OK / NO / BYE */
  if reply.1 \= "*" then
  do
    if reply.1 \= "OK" then
      say "Reply type: " || reply.1 || ", " || reply.2
    leave
  end

  if reply.0 == 2 then
    val = ""
  else
    val = reply.3

  /* First argument in *-reply is property name,
     second argument is property value.          */
  say reply.2 || ": " || val
end


/*
    VCard
*/

res = mmpQueryVCStem( MMPHandle, "vc.!", User )
parse var res resStatus ":" resError
if resStatus \= "SUCCESS" then
  call die "mmpQueryVCStem", resStatus, resError

say
say "vCard"
say "  Family name: " || vc.!N_FAMILY
say "  Given name: " || vc.!N_GIVEN
say "  Additional/Middle names: " || vc.!N_MID
say "  Honorific prefixes: " || vc.!N_PREF
say "  Honorific suffixes: " || vc.!N_SUFF
say "  Full name/Title: " || vc.!FN
say "  Nick: " || vc.!NICKNAME
say "  Organization: " || vc.!ORG
say "  Department: " || vc.!ORG_DEP
say "  Job title: " || vc.!TITLE
say "  Telephone number, home: " || vc.!TEL_HOME
say "  Telephone number, work: " || vc.!TEL_WORK
say "  Telephone number, cell: " || vc.!TEL_CELL
say "  Alternative e-mail: " || vc.!EMAIL
say "  Note: " || vc.!NOTE


/* Log out, close the connection and destroy the MMP Client object. */
call mmpDestroy( MMPHandle )

call mmpDropFuncs

exit


/* DIE func.name, result status, error text */
die:
  say arg(1) || "(): " || arg(2) || " (" || arg(3) || ")"
  call mmpDropFuncs
  exit
