/*
 * Decompiled with CFR 0.152.
 */
package jexifviewer;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Date;
import java.util.GregorianCalendar;
import jexifviewer.JExif;
import jexifviewer.JIfd;
import jexifviewer.JJPEGHelper;
import jexifviewer.JTiffHeader;
import shared.cvshelper.Cvs;
import shared.files.JPathHelper;

@Cvs(header="$Header: /home/reiner/cvs/Java/JExifViewer/src/jexifviewer/JIfdData.java,v 1.5 2010/04/02 12:12:13 reiner Exp $")
public final class JIfdData
extends JIfd {
    private String m_fileName;
    private long m_fileSize = -1L;

    public JIfdData() {
    }

    public JIfdData(File file) {
        this.readFromFile(file);
    }

    public JIfdData(String string) {
        this.readFromFile(string);
    }

    public long getFileSize() {
        if (this.m_fileSize == -1L) {
            File file = new File(this.m_fileName);
            this.m_fileSize = file.length();
        }
        return this.m_fileSize;
    }

    public Date getFileDate() {
        File file = new File(this.m_fileName);
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(new Date(file.lastModified()));
        return gregorianCalendar.getTime();
    }

    public String getFileName() {
        return JPathHelper.getBaseFileName(this.m_fileName);
    }

    public String getFullFileName() {
        return JPathHelper.getBaseFileName(this.m_fileName) + "." + JPathHelper.getFileExtension(this.m_fileName);
    }

    public String getFilePath() {
        return this.m_fileName;
    }

    public void setFilePath(String string) {
        this.m_fileName = string;
    }

    public boolean readFromFile(String string) {
        return this.readFromFile(new File(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean readFromFile(File file) {
        boolean bl = false;
        RandomAccessFile randomAccessFile = null;
        try {
            JTiffHeader jTiffHeader;
            JExif jExif;
            if (this.m_tagArray != null) {
                this.m_tagArray.clear();
            }
            this.m_fileName = file.getPath();
            JJPEGHelper jJPEGHelper = new JJPEGHelper();
            randomAccessFile = new RandomAccessFile(file, "r");
            if (jJPEGHelper.isJpegFile(randomAccessFile) && jJPEGHelper.findMarker(randomAccessFile, 65496) && jJPEGHelper.findMarker(randomAccessFile, 65505) && (jExif = new JExif()).read(randomAccessFile) && (jTiffHeader = new JTiffHeader()).read(randomAccessFile)) {
                randomAccessFile.seek(jTiffHeader.getOffset() + (long)jTiffHeader.getIFDOffset());
                bl = this.read(randomAccessFile, jTiffHeader.isIntel(), jTiffHeader.getOffset());
            }
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                if (randomAccessFile != null) {
                    randomAccessFile.close();
                }
            }
            catch (IOException iOException) {}
        }
        return bl;
    }
}

