/*
 * Decompiled with CFR 0.152.
 */
package jexifviewer;

import java.io.IOException;
import java.io.RandomAccessFile;
import shared.cvshelper.Cvs;
import shared.dataformathelper.JDataFormatHelper;

@Cvs(header="$Header: /home/reiner/cvs/Java/JExifViewer/src/jexifviewer/JExifTag.java,v 1.7 2010/04/02 12:12:13 reiner Exp $")
public final class JExifTag {
    public static final int EXIFTAG_TAG_EXIFIFD = 34665;
    public static final int EXIFTAG_TAG_GPSIFD = 34853;
    public static final int TAGMASK_GPS = 65536;
    public static final int TAGMASK_EXIF = 0;
    public static final int EXIFTAG_TAG_NAME = 0;
    public static final int EXIFTAG_TAG_SIZE = 1;
    public static final int EXIFTAG_TAG_RESOLUTION = 2;
    public static final int EXIFTAG_TAG_FOCALPLANERESOLUTION = 3;
    public static final int EXIFTAG_TAG_FILESIZE = 4;
    public static final int EXIFTAG_TAG_FILEDATETIME = 5;
    public static final int EXIFTAG_TAG_MAKE = 271;
    public static final int EXIFTAG_TAG_MODEL = 272;
    public static final int EXIFTAG_TAG_ORIENTATION = 274;
    public static final int EXIFTAG_TAG_XRESOLUTION = 282;
    public static final int EXIFTAG_TAG_YRESOLUTION = 283;
    public static final int EXIFTAG_TAG_RESOLUTIONUNIT = 296;
    public static final int EXIFTAG_TAG_SOFTWARE = 305;
    public static final int EXIFTAG_TAG_CHANGEDATETIME = 306;
    public static final int EXIFTAG_TAG_ARTIST = 315;
    public static final int EXIFTAG_TAG_YCBCRPOSITION = 531;
    public static final int EXIFTAG_TAG_COPYRIGHT = 33432;
    public static final int EXIFTAG_TAG_DESCRIPTION = 270;
    public static final int EXIFTAG_TAG_EXPOSURETIME = 33434;
    public static final int EXIFTAG_TAG_FNUMBER = 33437;
    public static final int EXIFTAG_TAG_EXPOSUREPROGRAM = 34850;
    public static final int EXIFTAG_TAG_ISOSPEEDRATINGS = 34855;
    public static final int EXIFTAG_TAG_EXIFVERSION = 36864;
    public static final int EXIFTAG_TAG_ORIGINALDATETIME = 36867;
    public static final int EXIFTAG_TAG_DIGITIZEDDATETIME = 36868;
    public static final int EXIFTAG_TAG_COMPONENTSCCONFIG = 37121;
    public static final int EXIFTAG_TAG_COMPRESSEDPITSPERPIXEL = 37122;
    public static final int EXIFTAG_TAG_SHUTERSPEEDVALUE = 37377;
    public static final int EXIFTAG_TAG_APERTUREVALUE = 37378;
    public static final int EXIFTAG_TAG_BRIGHTNESSVALUE = 37379;
    public static final int EXIFTAG_TAG_EXPOSUREBIASVALUE = 37380;
    public static final int EXIFTAG_TAG_MAXAPERTUREVALUE = 37381;
    public static final int EXIFTAG_TAG_METERINGMODE = 37383;
    public static final int EXIFTAG_TAG_LIGHTSOURCE = 37384;
    public static final int EXIFTAG_TAG_FLASH = 37385;
    public static final int EXIFTAG_TAG_FOCALLENGTH = 37386;
    public static final int EXIFTAG_TAG_MAKERNOTE = 37500;
    public static final int EXIFTAG_TAG_USERCOMMENT = 37510;
    public static final int EXIFTAG_TAG_COLORSPACE = 40961;
    public static final int EXIFTAG_TAG_PIXELXDIMENSION = 40962;
    public static final int EXIFTAG_TAG_PIXELYDIMENSION = 40963;
    public static final int EXIFTAG_TAG_FOCALPLANEXRESOLUTION = 41486;
    public static final int EXIFTAG_TAG_FOCALPLANEYRESOLUTION = 41487;
    public static final int EXIFTAG_TAG_FOCALPLANERESOLUTIONUNIT = 41488;
    public static final int EXIFTAG_TAG_SENSINGMODE = 41495;
    public static final int EXIFTAG_TAG_FILESOURCE = 41728;
    public static final int EXIFTAG_TAG_SCENETYPE = 41729;
    public static final int EXIFTAG_TAG_CUSTOMRENDERED = 41985;
    public static final int EXIFTAG_TAG_EXPOSUREMODE = 41986;
    public static final int EXIFTAG_TAG_WHITEBALANCE = 41987;
    public static final int EXIFTAG_TAG_DIGITALZOOMRATIO = 41988;
    public static final int EXIFTAG_TAG_FOCALLENGTH35MM = 41989;
    public static final int EXIFTAG_TAG_SCENECAPTURETYPE = 41990;
    public static final int EXIFTAG_TAG_GAINCONTROL = 41991;
    public static final int EXIFTAG_TAG_CONTRAST = 41992;
    public static final int EXIFTAG_TAG_SATURATION = 41993;
    public static final int EXIFTAG_TAG_SHARPNESS = 41994;
    public static final int EXIFTAG_TAG_SUBJECTDISTANCERANGE = 41996;
    public static final int GPSTAG_TAG_VERSIONID = 65536;
    public static final int GPSTAG_TAG_LATITUDEREF = 65537;
    public static final int GPSTAG_TAG_LATITUDE = 65538;
    public static final int GPSTAG_TAG_LONGITUDEREF = 65539;
    public static final int GPSTAG_TAG_LONGITUDE = 65540;
    public static final int GPSTAG_TAG_ALTITUDEREF = 65541;
    public static final int GPSTAG_TAG_ALTITUDE = 65542;
    public static final int GPSTAG_TAG_TIMESTAMP = 65543;
    public static final int GPSTAG_TAG_SATELLITES = 65544;
    public static final int GPSTAG_TAG_STATUS = 65545;
    public static final int GPSTAG_TAG_MEASUREMODE = 65546;
    public static final int GPSTAG_TAG_DOP = 65547;
    public static final int GPSTAG_TAG_MAPLINK = 69632;
    private int m_tag;
    private int m_tagMask;
    private short m_type;
    private long m_count;
    private long m_valueOffset;
    private int m_fileOffset = 0;
    private String m_string;
    private int m_integer1;
    private int m_integer2;
    private long m_long1;
    private long m_long2;
    private byte[] m_byteArray;
    private long[] m_longArray1;
    private long[] m_longArray2;

    public JExifTag(int n) {
        this.m_tagMask = n;
    }

    public static boolean isGenericTag(int n) {
        return n == 0 || n == 1 || n == 2 || n == 3 || n == 4 || n == 5 || n == 69632;
    }

    public static boolean isTagUsedByGeneric(int n) {
        if (n == 41486 || n == 41487 || n == 41488) {
            return true;
        }
        if (n == 282 || n == 283 || n == 296) {
            return true;
        }
        return n == 69632;
    }

    public static boolean isGPSTag(int n) {
        return (n & 0x10000) != 0;
    }

    public long getFileOffset() {
        return this.m_fileOffset;
    }

    public String getString() {
        assert (this.m_type == 2 || this.m_type == 7 && this.m_tag == 36864 || this.m_type == 7 && this.m_tag == 37121);
        return this.m_string;
    }

    public int getInteger1() {
        assert (this.m_type == 1 || this.m_type == 3 || this.m_type == 5 || this.m_type == 9 || this.m_type == 10 || this.m_type == 7 && this.m_tag == 65541);
        return this.m_type == 5 ? (int)this.m_long1 : this.m_integer1;
    }

    public int getInteger() {
        assert (this.m_type == 3 || this.m_type == 4 || this.m_type == 5);
        return this.m_type == 3 ? this.m_integer1 : (int)this.m_long1;
    }

    public int getInteger2() {
        assert (this.m_type == 10 || this.m_type == 5);
        return this.m_type == 10 ? this.m_integer2 : (int)this.m_long2;
    }

    public long getLong1() {
        assert (this.m_type == 5 || this.m_type == 4 || this.m_type == 10);
        if (this.m_type == 5 || this.m_type == 4) {
            return this.m_long1;
        }
        if (this.m_type == 10) {
            return this.m_integer1;
        }
        return 0L;
    }

    public long getLong2() {
        assert (this.m_type == 5 || this.m_type == 10);
        if (this.m_type == 5) {
            return this.m_long2;
        }
        if (this.m_type == 10) {
            return this.m_integer2;
        }
        return 0L;
    }

    public int getTag() {
        return this.m_tag;
    }

    public byte[] getByteArray() {
        return this.m_byteArray;
    }

    public long[] getLongArray1() {
        return this.m_longArray1;
    }

    public long[] getLongArray2() {
        return this.m_longArray2;
    }

    public int getType() {
        return this.m_type;
    }

    public long getValueOffset() {
        return this.m_valueOffset;
    }

    public String toString() {
        String string = null;
        switch (this.m_type) {
            case 1: {
                string = String.format("%1$d", this.m_integer1);
                break;
            }
            case 2: {
                string = this.m_string;
                break;
            }
            case 3: {
                string = String.format("%1$d", this.m_integer1);
                break;
            }
            case 4: {
                string = String.format("%1$d", this.m_long1);
                break;
            }
            case 5: {
                string = String.format("%1$d/%2$d", this.m_long1, this.m_long2);
                break;
            }
            case 7: {
                string = String.format("---", new Object[0]);
                break;
            }
            case 9: {
                string = String.format("%1d", this.m_integer1);
                break;
            }
            case 10: {
                string = String.format("%1d/%2d", this.m_integer1, this.m_integer2);
            }
        }
        return string;
    }

    public boolean read(RandomAccessFile randomAccessFile, boolean bl, long l) {
        boolean bl2 = false;
        try {
            this.m_fileOffset = (int)randomAccessFile.getFilePointer() + 8;
            byte[] byArray = new byte[4];
            randomAccessFile.read(byArray, 0, 2);
            this.m_tag = JDataFormatHelper.buf2ToInt(byArray, 0, bl);
            this.m_tag |= this.m_tagMask;
            randomAccessFile.read(byArray, 0, 2);
            this.m_type = (short)JDataFormatHelper.buf2ToInt(byArray, 0, bl);
            randomAccessFile.read(byArray, 0, 4);
            this.m_count = JDataFormatHelper.buf4ToLong(byArray, 0, bl);
            randomAccessFile.read(byArray, 0, 4);
            this.m_valueOffset = JDataFormatHelper.buf4ToLong(byArray, 0, bl);
            if (this.m_tag == 41729 || this.m_tag == 41728) {
                this.m_type = 1;
            }
            switch (this.m_type) {
                case 1: {
                    if (this.m_count == 1L) {
                        if (bl) {
                            this.m_integer1 = (int)(this.m_valueOffset & 0xFFL);
                            break;
                        }
                        this.m_integer1 = (int)((this.m_valueOffset & 0xFFFFFFFFFF000000L) >> 24);
                        break;
                    }
                    if (this.m_count > 4L) break;
                    this.m_byteArray = new byte[(int)this.m_count];
                    int n = 0;
                    while ((long)n < this.m_count) {
                        this.m_byteArray[n] = bl ? (byte)((this.m_valueOffset & (long)(255 << n * 8)) >> n * 8) : (byte)((this.m_valueOffset & (long)(-16777216 >> n * 8)) >> (3 - n) * 8);
                        ++n;
                    }
                    break;
                }
                case 2: {
                    long l2 = randomAccessFile.getFilePointer();
                    if (this.m_count <= 4L) {
                        char c;
                        StringBuilder stringBuilder = new StringBuilder();
                        int n = 0;
                        while ((long)n++ < this.m_count && (c = bl ? (char)((this.m_valueOffset & (long)(255 << (n - 1) * 8)) >> (n - 1) * 8) : (char)((this.m_valueOffset & (long)(255 << (4 - n) * 8)) >> (4 - n) * 8)) != '\u0000') {
                            stringBuilder.append(c);
                        }
                        this.m_string = stringBuilder.toString();
                    } else {
                        randomAccessFile.seek(l + this.m_valueOffset);
                        byArray = new byte[(int)this.m_count];
                        randomAccessFile.read(byArray);
                        this.m_string = new String(byArray);
                        if ((long)this.m_string.length() < this.m_count) {
                            String string = new String(byArray, this.m_string.length() + 1, (int)(this.m_count - (long)this.m_string.length() - 1L));
                            this.m_string = this.m_string + "\t";
                            this.m_string = this.m_string + string;
                        }
                    }
                    this.m_string = this.m_string.trim();
                    randomAccessFile.seek(l2);
                    break;
                }
                case 3: {
                    if (bl) {
                        this.m_integer1 = (short)(this.m_valueOffset & 0xFFFFL);
                        break;
                    }
                    this.m_integer1 = (short)((this.m_valueOffset & 0xFFFFFFFFFFFF0000L) >> 16);
                    break;
                }
                case 4: {
                    this.m_long1 = this.m_valueOffset;
                    break;
                }
                case 5: {
                    long l3 = randomAccessFile.getFilePointer();
                    randomAccessFile.seek(l + this.m_valueOffset);
                    byArray = new byte[(int)(this.m_count * 8L)];
                    randomAccessFile.read(byArray);
                    if (this.m_count == 1L) {
                        this.m_long1 = JDataFormatHelper.buf4ToLong(byArray, 0, bl);
                        this.m_long2 = JDataFormatHelper.buf4ToLong(byArray, 4, bl);
                    } else {
                        this.m_longArray1 = new long[(int)this.m_count];
                        this.m_longArray2 = new long[(int)this.m_count];
                        int n = 0;
                        while ((long)n < this.m_count) {
                            this.m_longArray1[n] = JDataFormatHelper.buf4ToLong(byArray, n * 8, bl);
                            this.m_longArray2[n] = JDataFormatHelper.buf4ToLong(byArray, n * 8 + 4, bl);
                            ++n;
                        }
                    }
                    randomAccessFile.seek(l3);
                    break;
                }
                case 7: {
                    if (this.m_tag == 36864) {
                        long l4 = randomAccessFile.getFilePointer();
                        randomAccessFile.seek(l4 - 4L);
                        byArray = new byte[4];
                        randomAccessFile.read(byArray);
                        this.m_string = new String(byArray);
                        break;
                    }
                    if (this.m_tag == 37121) {
                        assert (this.m_count == 4L);
                        long l5 = randomAccessFile.getFilePointer();
                        randomAccessFile.seek(l5 - 4L);
                        byArray = new byte[4];
                        randomAccessFile.read(byArray);
                        this.m_string = "";
                        for (int i = 0; i < 4; ++i) {
                            this.m_string = byArray[i] == 0 ? this.m_string + "" : (byArray[i] == 1 ? this.m_string + "Y" : (byArray[i] == 2 ? this.m_string + "Cb" : (byArray[i] == 3 ? this.m_string + "Cr" : (byArray[i] == 4 ? this.m_string + "R" : (byArray[i] == 5 ? this.m_string + "G" : (byArray[i] == 6 ? this.m_string + "B" : this.m_string + "?"))))));
                        }
                        break;
                    }
                    if (this.m_tag == 37510) {
                        long l6 = randomAccessFile.getFilePointer();
                        randomAccessFile.seek(l + this.m_valueOffset);
                        byArray = new byte[(int)this.m_count];
                        randomAccessFile.read(byArray);
                        int n = Math.min(8, byArray.length);
                        String string = new String(byArray, 0, n);
                        randomAccessFile.seek(l6);
                        if (this.m_count > (long)n) {
                            this.m_string = new String(byArray, n, (int)(this.m_count - (long)n));
                            if (this.m_string.charAt(0) == '\u0000') {
                                this.m_string = null;
                            }
                        } else {
                            this.m_string = null;
                        }
                        if (this.m_string == null) break;
                        this.m_string = this.m_string.trim();
                        break;
                    }
                    if (this.m_tag != 65541 || this.m_count != 1L) break;
                    long l7 = randomAccessFile.getFilePointer();
                    randomAccessFile.seek(l7 - 1L);
                    byArray = new byte[1];
                    randomAccessFile.read(byArray);
                    this.m_integer1 = byArray[0];
                    break;
                }
                case 9: {
                    this.m_integer1 = (int)(this.m_valueOffset & Integer.MAX_VALUE);
                    if ((this.m_valueOffset & Integer.MIN_VALUE) == 0L) break;
                    this.m_integer1 = (int)((long)this.m_integer1 - 0x100000000L);
                    break;
                }
                case 10: {
                    long l8 = randomAccessFile.getFilePointer();
                    randomAccessFile.seek(l + this.m_valueOffset);
                    byArray = new byte[(int)(this.m_count * 8L)];
                    randomAccessFile.read(byArray);
                    this.m_integer1 = JDataFormatHelper.buf4ToIntSigned(byArray, 0, bl);
                    this.m_integer2 = JDataFormatHelper.buf4ToIntSigned(byArray, 4, bl);
                    randomAccessFile.seek(l8);
                }
            }
            bl2 = true;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return bl2;
    }
}

