/*
 * Decompiled with CFR 0.152.
 */
package shared.table;

import java.awt.Component;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public final class JTableHelper {
    public static void selectRow(JTable jTable, int n, boolean bl) {
        assert (n >= 0 && n < jTable.getRowCount());
        if (n >= 0 && n < jTable.getRowCount()) {
            jTable.setRowSelectionInterval(n, n);
            if (bl) {
                Rectangle rectangle = jTable.getCellRect(n, 0, true);
                jTable.scrollRectToVisible(rectangle);
            }
        }
    }

    public static void setTableHeaderCellRenderer(TableColumn tableColumn) {
        tableColumn.setHeaderRenderer(new DefaultTableCellRenderer(){

            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                if (jTable != null) {
                    JComponent jComponent = (JComponent)((Object)jTable.getTableHeader().getDefaultRenderer());
                    this.setForeground(jComponent.getForeground());
                    this.setBackground(jComponent.getBackground());
                    this.setFont(jComponent.getFont());
                    this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
                }
                this.setText(object != null ? object.toString() : "");
                this.setHorizontalAlignment(0);
                return this;
            }
        });
    }

    public static void setTableHeaderCellRenderer(JTable jTable) {
        TableColumnModel tableColumnModel = jTable.getColumnModel();
        int n = tableColumnModel.getColumnCount();
        for (int i = 0; i < n; ++i) {
            JTableHelper.setTableHeaderCellRenderer(tableColumnModel.getColumn(i));
        }
    }

    public static void autoAdjustColWidths(JTable jTable) {
        for (int i = 0; i < jTable.getColumnCount(); ++i) {
            DefaultTableColumnModel defaultTableColumnModel = (DefaultTableColumnModel)jTable.getColumnModel();
            TableColumn tableColumn = defaultTableColumnModel.getColumn(i);
            int n = 4;
            TableCellRenderer tableCellRenderer = tableColumn.getHeaderRenderer();
            if (tableCellRenderer == null) {
                tableCellRenderer = jTable.getTableHeader().getDefaultRenderer();
            }
            Component component = tableCellRenderer.getTableCellRendererComponent(jTable, tableColumn.getHeaderValue(), false, false, 0, i);
            n = component.getPreferredSize().width + 4;
            for (int j = 0; j < jTable.getRowCount(); ++j) {
                int n2;
                tableCellRenderer = jTable.getCellRenderer(j, i);
                if (tableCellRenderer == null) {
                    jTable.getDefaultRenderer(String.class);
                }
                if ((n2 = tableCellRenderer.getTableCellRendererComponent((JTable)jTable, (Object)jTable.getValueAt((int)j, (int)i), (boolean)false, (boolean)false, (int)j, (int)i).getPreferredSize().width + 4) <= n) continue;
                n = n2;
            }
            tableColumn.setPreferredWidth(n);
        }
    }
}

