/*
 * Decompiled with CFR 0.152.
 */
package shared.dataformathelper;

public class JDataFormatHelper {
    public static int byteToInt(byte by) {
        return (by & 0x7F) + (by & 0x80);
    }

    public static long byteToLong(byte by) {
        return (long)(by & 0x7F) + (long)(by & 0x80);
    }

    public static int buf4ToInt(byte[] byArray, int n, boolean bl) {
        assert (byArray.length >= n + 4);
        return bl ? JDataFormatHelper.byteToInt(byArray[n]) + (JDataFormatHelper.byteToInt(byArray[n + 1]) << 8) + (JDataFormatHelper.byteToInt(byArray[n + 2]) << 16) + (JDataFormatHelper.byteToInt(byArray[n + 3]) << 24) : JDataFormatHelper.byteToInt(byArray[n + 3]) + (JDataFormatHelper.byteToInt(byArray[n + 2]) << 8) + (JDataFormatHelper.byteToInt(byArray[n + 1]) << 16) + (JDataFormatHelper.byteToInt(byArray[n]) << 24);
    }

    public static int buf4ToIntSigned(byte[] byArray, int n, boolean bl) {
        assert (byArray.length >= n + 4);
        long l = bl ? (long)(JDataFormatHelper.byteToInt(byArray[n]) + (JDataFormatHelper.byteToInt(byArray[n + 1]) << 8) + (JDataFormatHelper.byteToInt(byArray[n + 2]) << 16) + (JDataFormatHelper.byteToInt((byte)(0x7F & byArray[n + 3])) << 24)) : (long)(JDataFormatHelper.byteToInt(byArray[n + 3]) + (JDataFormatHelper.byteToInt(byArray[n + 2]) << 8) + (JDataFormatHelper.byteToInt(byArray[n + 1]) << 16) + (JDataFormatHelper.byteToInt((byte)(0x7F & byArray[n])) << 24));
        if (((bl ? byArray[n + 3] : byArray[n]) & 0x80) != 0) {
            l -= 0x80000000L;
        }
        return (int)l;
    }

    public static int buf2ToInt(byte[] byArray, int n, boolean bl) {
        assert (byArray.length >= n + 2);
        return bl ? JDataFormatHelper.byteToInt(byArray[n]) + (JDataFormatHelper.byteToInt(byArray[n + 1]) << 8) : JDataFormatHelper.byteToInt(byArray[n + 1]) + (JDataFormatHelper.byteToInt(byArray[n]) << 8);
    }

    public static int buf2ToIntBE(byte[] byArray, int n) {
        assert (byArray.length >= n + 2);
        return (JDataFormatHelper.byteToInt(byArray[n]) << 8) + JDataFormatHelper.byteToInt(byArray[n + 1]);
    }

    public static short buf2ToShortBE(byte[] byArray, int n) {
        assert (byArray.length >= n + 2);
        return (short)((JDataFormatHelper.byteToInt(byArray[n]) << 8) + JDataFormatHelper.byteToInt(byArray[n + 1]));
    }

    public static int buf4ToIntBE(byte[] byArray, int n) {
        assert (byArray.length >= n + 4);
        return (JDataFormatHelper.byteToInt(byArray[n]) << 24) + (JDataFormatHelper.byteToInt(byArray[n + 1]) << 16) + (JDataFormatHelper.byteToInt(byArray[n + 1]) << 16) + (JDataFormatHelper.byteToInt(byArray[n + 2]) << 8) + JDataFormatHelper.byteToInt(byArray[n + 3]);
    }

    public static long buf4ToLong(byte[] byArray, int n, boolean bl) {
        assert (byArray.length >= n + 4);
        return bl ? JDataFormatHelper.byteToLong(byArray[n]) + (JDataFormatHelper.byteToLong(byArray[n + 1]) << 8) + (JDataFormatHelper.byteToLong(byArray[n + 2]) << 16) + (JDataFormatHelper.byteToLong(byArray[n + 3]) << 24) : JDataFormatHelper.byteToLong(byArray[n + 3]) + (JDataFormatHelper.byteToLong(byArray[n + 2]) << 8) + (JDataFormatHelper.byteToLong(byArray[n + 1]) << 16) + (JDataFormatHelper.byteToLong(byArray[n]) << 24);
    }

    public static long buf4ToLongSigned(byte[] byArray, int n) {
        assert (byArray.length >= n + 4);
        long l = JDataFormatHelper.byteToLong(byArray[n]) + (JDataFormatHelper.byteToLong(byArray[n + 1]) << 8) + (JDataFormatHelper.byteToLong(byArray[n + 2]) << 16) + (JDataFormatHelper.byteToLong((byte)(0x7F & byArray[n + 3])) << 24);
        if ((byArray[n + 3] & 0x80) != 0) {
            l -= 0x100000000L;
        }
        return l;
    }

    public static short buf1ToShort(byte[] byArray, int n) {
        assert (byArray.length >= n + 1);
        return (short)JDataFormatHelper.byteToInt(byArray[n]);
    }

    public static void IntToBuf2(int n, byte[] byArray, int n2, boolean bl) {
        assert (byArray.length >= n2 + 2);
        byArray[n2 + (bl ? 0 : 1)] = (byte)(n & 0xFF);
        byArray[n2 + (bl ? 1 : 0)] = (byte)(n >> 8 & 0xFF);
    }

    public static void IntToBuf2BE(int n, byte[] byArray, int n2) {
        assert (byArray.length >= n2 + 2);
        byArray[n2] = (byte)(n >> 8 & 0xFF);
        byArray[n2 + 1] = (byte)(n & 0xFF);
    }

    public static void IntToBuf4(int n, byte[] byArray, int n2, boolean bl) {
        assert (byArray.length >= n2 + 4);
        byArray[n2 + (bl ? 0 : 3)] = (byte)(n & 0xFF);
        byArray[n2 + (bl ? 1 : 2)] = (byte)(n >> 8 & 0xFF);
        byArray[n2 + (bl ? 2 : 1)] = (byte)(n >> 16 & 0xFF);
        byArray[n2 + (bl ? 3 : 0)] = (byte)(n >> 24 & 0xFF);
    }

    public static void LongToBuf4(long l, byte[] byArray, int n) {
        assert (byArray.length >= n + 4);
        byArray[n] = (byte)(l & 0xFFL);
        byArray[n + 1] = (byte)(l >> 8 & 0xFFL);
        byArray[n + 2] = (byte)(l >> 16 & 0xFFL);
        byArray[n + 3] = (byte)(l >> 24 & 0xFFL);
    }

    public static void ShortToBuf1(short s, byte[] byArray, int n) {
        assert (byArray.length >= n + 1);
        byArray[n] = (byte)(s & 0xFF);
    }

    public static void IntSignedToBuf4(int n, byte[] byArray, int n2) {
        assert (byArray.length >= n2 + 4);
        byArray[n2] = (byte)(n & 0xFF);
        byArray[n2 + 1] = (byte)(n >> 8 & 0xFF);
        byArray[n2 + 2] = (byte)(n >> 16 & 0xFF);
        byArray[n2 + 3] = (byte)(n >> 24 & 0xFF);
    }
}

