/*
 * Decompiled with CFR 0.152.
 */
package shared.base64;

import java.io.UnsupportedEncodingException;

public class JBase64 {
    private static final char[] m_b64Tbl = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/', '='};

    public static String encode(String string) {
        return JBase64.encode(string, "ISO-8859-1");
    }

    public static String encode(String string, String string2) {
        String string3 = null;
        try {
            string3 = JBase64.encode(string.getBytes(string2));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return string3;
    }

    public static String encode(byte[] byArray) {
        return JBase64.encode(byArray, 0, byArray.length);
    }

    public static String encode(byte[] byArray, int n, int n2) {
        int n3;
        StringBuffer stringBuffer = new StringBuffer();
        int n4 = n;
        while (n2 >= 3) {
            n3 = (byArray[n4] & 0xFC) >>> 2;
            stringBuffer.append(m_b64Tbl[n3]);
            n3 = (byArray[n4++] & 3) << 4;
            stringBuffer.append(m_b64Tbl[n3 |= (byArray[n4] & 0xF0) >>> 4]);
            n3 = (byArray[n4++] & 0xF) << 2;
            stringBuffer.append(m_b64Tbl[n3 |= (byArray[n4] & 0xC0) >>> 6]);
            n3 = byArray[n4++] & 0x3F;
            stringBuffer.append(m_b64Tbl[n3]);
            n2 -= 3;
        }
        if (n2 != 0) {
            if (n2 == 1) {
                n3 = (byArray[n4] & 0xFC) >>> 2;
                stringBuffer.append(m_b64Tbl[n3]);
                n3 = (byArray[n4] & 3) << 4;
                stringBuffer.append(m_b64Tbl[n3]);
                stringBuffer.append(m_b64Tbl[64]);
                stringBuffer.append(m_b64Tbl[64]);
            } else if (n2 == 2) {
                n3 = (byArray[n4] & 0xFC) >>> 2;
                stringBuffer.append(m_b64Tbl[n3]);
                n3 = (byArray[n4++] & 3) << 4;
                stringBuffer.append(m_b64Tbl[n3 |= (byArray[n4] & 0xF0) >>> 4]);
                n3 = (byArray[n4] & 0xF) << 2;
                stringBuffer.append(m_b64Tbl[n3]);
                stringBuffer.append(m_b64Tbl[64]);
            }
        }
        return stringBuffer.toString();
    }

    public static byte[] decode(String string) {
        byte[] byArray = null;
        int n = JBase64.getDataSize(string);
        if (n > 0) {
            int n2;
            byArray = new byte[n];
            int n3 = 0;
            int n4 = 0;
            for (n = string.length() - (string.length() / 4 * 3 - n); n >= 4 && (n2 = JBase64.getVal(string.charAt(n3++))) != -1; n -= 4) {
                int n5 = n4;
                byArray[n5] = (byte)(byArray[n5] | n2 << 2);
                if ((n2 = JBase64.getVal(string.charAt(n3++))) == -1) break;
                int n6 = n4++;
                byArray[n6] = (byte)(byArray[n6] | (n2 & 0x30) >>> 4);
                int n7 = n4;
                byArray[n7] = (byte)(byArray[n7] | (n2 & 0xF) << 4);
                if ((n2 = JBase64.getVal(string.charAt(n3++))) == -1) break;
                int n8 = n4++;
                byArray[n8] = (byte)(byArray[n8] | (n2 & 0x3C) >>> 2);
                int n9 = n4;
                byArray[n9] = (byte)(byArray[n9] | (n2 & 3) << 6);
                if ((n2 = JBase64.getVal(string.charAt(n3++))) == -1) break;
                int n10 = n4++;
                byArray[n10] = (byte)(byArray[n10] | n2 & 0x3F);
            }
            if (n == 3) {
                if ((n2 = JBase64.getVal(string.charAt(n3++))) != -1) {
                    int n11 = n4;
                    byArray[n11] = (byte)(byArray[n11] | n2 << 2);
                    if ((n2 = JBase64.getVal(string.charAt(n3++))) != -1) {
                        int n12 = n4++;
                        byArray[n12] = (byte)(byArray[n12] | (n2 & 0x30) >>> 4);
                        int n13 = n4;
                        byArray[n13] = (byte)(byArray[n13] | (n2 & 0xF) << 4);
                        if ((n2 = JBase64.getVal(string.charAt(n3++))) != -1) {
                            int n14 = n4;
                            byArray[n14] = (byte)(byArray[n14] | (n2 & 0x3C) >>> 2);
                            n -= 3;
                        }
                    }
                }
            } else if (n == 2 && (n2 = JBase64.getVal(string.charAt(n3++))) != -1) {
                int n15 = n4;
                byArray[n15] = (byte)(byArray[n15] | n2 << 2);
                if ((n2 = JBase64.getVal(string.charAt(n3++))) != -1) {
                    int n16 = n4;
                    byArray[n16] = (byte)(byArray[n16] | (n2 & 0x30) >>> 4);
                    n -= 2;
                }
            }
        }
        return (byte[])(n == 0 ? byArray : null);
    }

    private static int getVal(char c) {
        for (int i = 0; i < 64; ++i) {
            if (m_b64Tbl[i] != c) continue;
            return i;
        }
        return -1;
    }

    public static int getDataSize(String string) {
        int n = 0;
        assert (string.length() % 4 == 0);
        if (string.length() >= 4) {
            n = string.length() / 4 * 3;
            if (string.charAt(string.length() - 1) == m_b64Tbl[64]) {
                --n;
            }
            if (string.charAt(string.length() - 2) == m_b64Tbl[64]) {
                --n;
            }
        }
        return n;
    }
}

