/** $(c2)
 *
 * Copyright (C) 2013-2024 David Azarewicz <david@88watts.net>
 * All rights reserved.
 *
 * LICENSE
 *
 * You may copy this source code, use it in derivative works, or use it in any
 * other way, provided the copyright notice above is not removed.
 *
 * This source code is provided to you with absolutely no warranty whatsoever.
 * There is no guarantee that you will be able to use this code, or build the
 * program, or use it in any way. It is provided solely as a reference so that
 * you may understand how the program works.
 *
 * The author is not responsible in any way for any problem caused by this
 * software, whether it is used correctly or not.
 */
#define INCL_NOPMAPI
#define INCL_DOSDEVIOCTL
#define INCL_BASE
#include <os2.h>
#include <stdio.h>
#include "ioctl.h"

#define OPEN_FLAG ( OPEN_ACTION_OPEN_IF_EXISTS )
#define OPEN_MODE ( OPEN_FLAGS_FAIL_ON_ERROR | OPEN_SHARE_DENYNONE | OPEN_ACCESS_READWRITE )

HFILE hfile;                    // set via DosOpen

ULONG Ac5IoRW(ULONG Function, ULONG Data)
{
    AC5INFO aiInfo;
    ULONG DataBufLen;
    APIRET rc;

    DataBufLen = sizeof(aiInfo);
    aiInfo.Command = Function;
    aiInfo.Data = Data;

    rc = DosDevIOCtl(hfile, IOCTL_CATEGORY, IOCTL_FUNCTION_IORW, NULL, 0, NULL, (PVOID)&aiInfo, DataBufLen, &DataBufLen);
    if (rc) {
            printf("ERROR: DosDevIOCtl failed with RC = %lu %x\n", rc, rc);
    }
    return aiInfo.Data;
}

void Ac5Info(void)
{
    AC5INFO aiInfo;
    ULONG DataBufLen;
    APIRET rc;

    DataBufLen = sizeof(aiInfo);

    rc = DosDevIOCtl(hfile, IOCTL_CATEGORY, IOCTL_FUNCTION_INFO, NULL, 0, NULL, (PVOID)&aiInfo, DataBufLen, &DataBufLen);
    if (rc) {
            printf("ERROR: DosDevIOCtl failed with RC = %lu %x\n", rc, rc);
    }
    printf("Output=%x\n", aiInfo.Data);
}

int main(int argc, char **argv)
{
    APIRET rc;
    ULONG ulAction;
    int i;
    ULONG InBits, OutBits;

    rc = DosOpen((PSZ) "PCIAC5$ ", &hfile, &ulAction, 0, 0, OPEN_FLAG, OPEN_MODE, NULL);
    if (rc) {
        printf("DosOpen failed with RC = %lu\n", rc);
        return 1;
    }

    /* sanity check */
    Ac5Info();

    /* Tests */

    /* Blink the LEDs */
    Ac5IoRW(IOCTL_FCN_WRITE_CONFIG_0, 0xc0000000); /* configure LEDs on port 0 as outputs */
    Ac5IoRW(IOCTL_FCN_WRITE_CONFIG_1, 0xc0000000); /* configure LEDs on port 1 as outputs */
    Ac5IoRW(IOCTL_FCN_WRITE_DATA_0, 0xc0000000); /* turn LEDs off */
    Ac5IoRW(IOCTL_FCN_WRITE_DATA_1, 0xc0000000); /* turn LEDs off */
    DosSleep(1000); /* 1 second */

    for (i=0; i<10; i++)
    {
        Ac5IoRW(IOCTL_FCN_WRITE_DATA_0, 0x40000000);
        DosSleep(1000); /* 1 second */
        Ac5IoRW(IOCTL_FCN_WRITE_DATA_0, 0x80000000);
        DosSleep(1000); /* 1 second */
        Ac5IoRW(IOCTL_FCN_WRITE_DATA_0, 0xc0000000);
        Ac5IoRW(IOCTL_FCN_WRITE_DATA_1, 0x40000000);
        DosSleep(1000); /* 1 second */
        Ac5IoRW(IOCTL_FCN_WRITE_DATA_1, 0x80000000);
        DosSleep(1000); /* 1 second */
        Ac5IoRW(IOCTL_FCN_WRITE_DATA_1, 0xc0000000);
    }

    /* Reading and writing inputs and outputs */

    /* configure bit 1 and LEDs as outputs, all others as inputs */
    Ac5IoRW(IOCTL_FCN_WRITE_CONFIG_0, 0xc0000002);

    /* Turn all outputs off */
    OutBits = 0xffffffff;
    Ac5IoRW(IOCTL_FCN_WRITE_DATA_0, OutBits);

    /* read the status bits on port 0 */
    InBits = Ac5IoRW(IOCTL_FCN_READ_DATA_0, 0);

    if (!(InBits & 1)) /* is the input bit on? */
    {
        OutBits &= ~2; /* turn the output bit on */
        Ac5IoRW(IOCTL_FCN_WRITE_DATA_0, OutBits); /* write it to the port */
    }

    rc = DosClose(hfile);
    if (rc) {
        printf("ERROR: DosClose failed with RC = %lu\n", rc);
        return 1;
    }

   return 0;
}

