/** $(c1)
 *
 * Copyright (C) 2013-2024 David Azarewicz <david@88watts.net>
 * All rights reserved.
 *
 * LICENSE
 *
 * You may use this source code to develop and test this software. You may
 * produce binaries for testing and for your own use. You may not publish,
 * release, share, distribute, or otherwise give this source code to any
 * other person or organization, whether modified or not. You may not fork,
 * clone, or otherwise create any copy of this source code whether modified
 * or not. You may not publish, release, share, distribute, or otherwise give
 * any binaries produced from this code to any other person or organization,
 * whether modified or not.
 *
 * The author and copyright holder retains sole right of distribution of this
 * software. Any desired changes to this software must be submitted to David
 * Azarewicz at david@88watts.net.
 *
 * This software is provided as-is, without warranty of any kind, express or
 * implied, including but not limited to the warranties of merchantability,
 * fitness for any particular purpose, and noninfringement. In no event shall
 * the author(s) or copyright holder(s) be liable for any claim, damages, or
 * other liability, whether in an action of contract, tort, or otherwise
 * arising from, out of, or in connection with this software, or the use or
 * other dealings in this software.
 *
 * This copyright and license statement may not be removed.
 *
 * Coding Guidelines: <https://88watts.net/files/CodingGuidelines.c>
 */
#ifndef __RM_CALLS__
#define __RM_CALLS__

#include <Dev32rmbase.h>

#ifdef __cplusplus
  extern "C" {
#endif

ULONG __syscall RMCreateDriver(void *pDriverStruct, ULONG *phDriver);
ULONG __syscall RMDestroyDriver(HDRIVER hDriver);
ULONG __syscall RMCreateAdapter(HDRIVER hDriver, void *phAdapter, void *pAdapterStruct, HDEVICE hDevice, void *pahResource);
ULONG __syscall RMDestroyAdapter(HDRIVER hDriver, HADAPTER hAdapter);
ULONG __syscall RMCreateDevice(HDRIVER hDriver, void *phDevice, void *pDeviceStruct, HADAPTER hAdapter, void *pahResource);
ULONG __syscall RMDestroyDevice(HDRIVER hDriver, HDEVICE hDevice);
ULONG __syscall RMAllocResource(HDRIVER hDriver, void *phResource, void *pResourceStruct);
ULONG __syscall RMDeallocResource(HDRIVER hDriver, HRESOURCE hResource);
ULONG __syscall RMModifyResources(HDRIVER hDriver, HADAPTER hAdapter, USHORT ModifyAction, HRESOURCE hResource);
ULONG __syscall RMGetNodeInfo(RMHANDLE RMHandle, void *pNodeInfo, USHORT BufferSize);
ULONG __syscall RMDevIDToHandleList(RMHANDLE RMHandle, DEVID DeviceID, DEVID FunctionID, DEVID CompatibleID,
  VENDID VendorID, SERNUM SerialNumber, SEARCHIDFLAGS SearchFlags, HDETECTED hStartNode, void *pHndList);
ULONG __syscall RMHandleToResourceHandleList(RMHANDLE hHandle, void *pHndList);
ULONG __syscall RMGetCommandLine(char *pchDriverName, char *pchBuffer, USHORT *pusBufLen, USHORT usIndex, USHORT usDDType);
ULONG __syscall RMKeyToHandleList(RMHANDLE hHandle, char *pchSearchKey, void *pHndList);

#ifdef __cplusplus
	};
#endif

/****************************************************************************/
/*                                                                          */
/* Resource Manager Return Codes                                            */
/*                                                                          */
/****************************************************************************/
#define RMRC_SUCCESS               0x0000
#define RMRC_NOTINITIALIZED        0x0001
#define RMRC_BAD_DRIVERHANDLE      0x0002
#define RMRC_BAD_ADAPTERHANDLE     0x0003
#define RMRC_BAD_DEVICEHANDLE      0x0004
#define RMRC_BAD_RESOURCEHANDLE    0x0005
#define RMRC_BAD_LDEVHANDLE        0x0006
#define RMRC_BAD_SYSNAMEHANDLE     0x0007
#define RMRC_BAD_DEVHELP           0x0008
#define RMRC_NULL_POINTER          0x0009
#define RMRC_NULL_STRINGS          0x000a
#define RMRC_BAD_VERSION           0x000b
#define RMRC_RES_ALREADY_CLAIMED   0x000c
#define RMRC_DEV_ALREADY_CLAIMED   0x000d
#define RMRC_INVALID_PARM_VALUE    0x000e
#define RMRC_OUT_OF_MEMORY         0x000f
#define RMRC_SEARCH_FAILED         0x0010
#define RMRC_BUFFER_TOO_SMALL      0x0011
#define RMRC_GENERAL_FAILURE       0x0012
#define RMRC_IRQ_ENTRY_ILLEGAL     0x0013
#define RMRC_NOT_IMPLEMENTED       0x0014
#define RMRC_NOT_INSTALLED         0x0015
#define RMRC_BAD_DETECTHANDLE      0x0016
#define RMRC_BAD_RMHANDLE          0x0017
#define RMRC_BAD_FLAGS             0x0018
#define RMRC_NO_DETECTED_DATA      0x0019


/*********************/
/*  RM Types         */
/*********************/

typedef struct {
   UCHAR      MajorVersion;
   UCHAR      MinorVersion;
   USHORT     NumRSMEntries;
} RSMVERSTRUCT;

#endif /* __RM_CALLS__ */
