/*
 * Decompiled with CFR 0.152.
 */
package blackjack;

import blackjack.Player;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;

public class Card {
    public static Image[][] card_images;
    public static Image card_back;
    public static Image busted_image;
    public static Image blackjack_image;
    public static Image twenty_one_image;
    public static final int CARD_WIDTH = 69;
    public static final int CARD_HEIGHT = 100;
    public Suit suit;
    public Rank rank;
    public boolean given_away = false;

    public static void LoadImages() throws IOException {
        BufferedImage bufferedImage = ImageIO.read(new File("data/cards.png"));
        card_images = new Image[4][];
        for (int i = 0; i < 4; ++i) {
            Card.card_images[i] = new Image[13];
            int n = bufferedImage.getHeight() - (i + 2) * 100;
            for (int j = 0; j < 13; ++j) {
                int n2 = j == 12 ? 0 : j + 1;
                int n3 = n2 * 69;
                Card.card_images[i][j] = bufferedImage.getSubimage(n3, n, 69, 100);
            }
        }
        busted_image = ImageIO.read(new File("data/busted.png"));
        blackjack_image = ImageIO.read(new File("data/blackjack.png"));
        twenty_one_image = ImageIO.read(new File("data/21.png"));
        card_back = ImageIO.read(new File("data/card_back.png"));
    }

    Card(Suit suit, Rank rank) {
        this.suit = suit;
        this.rank = rank;
    }

    Card() {
        this.suit = Suit.SPADES;
        this.rank = Rank.TWO;
    }

    int Value() {
        return Card.Value(this.rank);
    }

    Image CardImage() {
        int n = Card.IDBySuit(this.suit);
        int n2 = Card.IDByRank(this.rank);
        return card_images[n][n2];
    }

    String RankString() {
        return Card.StringByRank(this.rank);
    }

    String SuitString() {
        return Card.StringBySuit(this.suit);
    }

    String CardString() {
        return Card.StringByCard(this);
    }

    void GiveToPlayer(Player player) {
        player.AddCard(this);
        this.given_away = true;
    }

    static int IDByRank(Rank rank) {
        switch (rank) {
            case TWO: {
                return 0;
            }
            case THREE: {
                return 1;
            }
            case FOUR: {
                return 2;
            }
            case FIVE: {
                return 3;
            }
            case SIX: {
                return 4;
            }
            case SEVEN: {
                return 5;
            }
            case EIGHT: {
                return 6;
            }
            case NINE: {
                return 7;
            }
            case TEN: {
                return 8;
            }
            case JACK: {
                return 9;
            }
            case QUEEN: {
                return 10;
            }
            case KING: {
                return 11;
            }
            case ACE: {
                return 12;
            }
        }
        return 0;
    }

    static Rank RankByID(int n) {
        switch (n) {
            case 0: {
                return Rank.TWO;
            }
            case 1: {
                return Rank.THREE;
            }
            case 2: {
                return Rank.FOUR;
            }
            case 3: {
                return Rank.FIVE;
            }
            case 4: {
                return Rank.SIX;
            }
            case 5: {
                return Rank.SEVEN;
            }
            case 6: {
                return Rank.EIGHT;
            }
            case 7: {
                return Rank.NINE;
            }
            case 8: {
                return Rank.TEN;
            }
            case 9: {
                return Rank.JACK;
            }
            case 10: {
                return Rank.QUEEN;
            }
            case 11: {
                return Rank.KING;
            }
            case 12: {
                return Rank.ACE;
            }
        }
        return Rank.TWO;
    }

    static Suit SuitByID(int n) {
        switch (n) {
            case 0: {
                return Suit.SPADES;
            }
            case 1: {
                return Suit.HEARTS;
            }
            case 2: {
                return Suit.DIAMONDS;
            }
            case 3: {
                return Suit.CLUBS;
            }
        }
        return Suit.SPADES;
    }

    static int IDBySuit(Suit suit) {
        switch (suit) {
            case SPADES: {
                return 0;
            }
            case HEARTS: {
                return 1;
            }
            case DIAMONDS: {
                return 2;
            }
            case CLUBS: {
                return 3;
            }
        }
        return 0;
    }

    static String StringByRank(Rank rank) {
        switch (rank) {
            case TWO: {
                return "2";
            }
            case THREE: {
                return "3";
            }
            case FOUR: {
                return "4";
            }
            case FIVE: {
                return "5";
            }
            case SIX: {
                return "6";
            }
            case SEVEN: {
                return "7";
            }
            case EIGHT: {
                return "8";
            }
            case NINE: {
                return "9";
            }
            case TEN: {
                return "10";
            }
            case JACK: {
                return "Jack";
            }
            case QUEEN: {
                return "Queen";
            }
            case KING: {
                return "King";
            }
            case ACE: {
                return "Ace";
            }
        }
        return "";
    }

    static String StringBySuit(Suit suit) {
        switch (suit) {
            case SPADES: {
                return "Spades";
            }
            case HEARTS: {
                return "Hearts";
            }
            case DIAMONDS: {
                return "Diamonds";
            }
            case CLUBS: {
                return "Clubs";
            }
        }
        return "";
    }

    static String StringByCard(Card card) {
        return card.RankString() + " of " + card.SuitString();
    }

    static int Value(Rank rank) {
        return Card.Value(rank, false);
    }

    static int Value(Rank rank, boolean bl) {
        switch (rank) {
            case TWO: {
                return 2;
            }
            case THREE: {
                return 3;
            }
            case FOUR: {
                return 4;
            }
            case FIVE: {
                return 5;
            }
            case SIX: {
                return 6;
            }
            case SEVEN: {
                return 7;
            }
            case EIGHT: {
                return 8;
            }
            case NINE: {
                return 9;
            }
            case TEN: {
                return 10;
            }
            case JACK: {
                return 10;
            }
            case QUEEN: {
                return 10;
            }
            case KING: {
                return 10;
            }
            case ACE: {
                return bl ? 1 : 11;
            }
        }
        return 0;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Rank {
        TWO,
        THREE,
        FOUR,
        FIVE,
        SIX,
        SEVEN,
        EIGHT,
        NINE,
        TEN,
        JACK,
        QUEEN,
        KING,
        ACE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Suit {
        SPADES,
        HEARTS,
        DIAMONDS,
        CLUBS;

    }
}

