/* examine a saved "TOCxxxxx.lst" output to see what has changed
      from the current contents of the CURRENT directory hierarchy. */
/* Options are '/New' '/Missing' '/Changed' */

parse arg fn . '/' opt
if opt \= '' then opt = '/'||translate(opt)
             else opt = '/NEW'

call RxFuncAdd "SysLoadFuncs", RexxUtil, "SysLoadFuncs"
call SysLoadFuncs

/* read the input file contents,
   assumed to be "TOC" command output internally generated by DriveDir */
n = 0
status = stream(fn,'c','open read')
Do While left(status,5) = 'READY'
   data = linein(fn)
   status = stream(fn,'s')
   if left(status,5) = 'READY' then do
      n = n + 1
      mLine.n = data
      parse var data fDate fTime fSize fAttr fName .
      key = fDate||"+"||fTime||"+"||fSize||"+"||fAttr
      mKey.n = key
      mFile.n = fName
   end
End
status = stream(fn,'c','close')
mLine.0 = n

/* get the current directory structure */
rc = SysFileTree('*',files,'FSL')
If substr(opt,2,1) = 'M' Then  /* asking for missing files */
   Do i = 1 to mLine.0
      fname = strip(mFile.i,'B','"')
      If stream(fname,'c','query exist') = '' Then Do
         say 'missing file' fname
      End
   End
Else Do i = 1 to files.0
   l = files.i
   parse var l dt tm size attr fname
   fname = '"'||strip(fname)||'"'

   /* enumerate all the files with those attributes */
   key = dt||"+"||tm||"+"||size||"+"||attr
   found = 0
   matched = 0
   matchList = ''
   Do x = 1 to mLine.0
      if mFile.x = fname then do
         found = 1
         if mKey.x = key then do
            matched = 1
         end
         leave
      end
   End

   /* if it wasn't in our previous list */
   If found = 0 Then Do
      If substr(opt,2,1) = 'N' Then Do   /* asking for 'new' files */
         say 'new file' fname
      End
   End
   Else Do
      If substr(opt,2,1) = 'C' Then Do   /* asking for 'changed' files */
         If matched = 0 Then Do
            say 'changed file' fname
         End
      End
   End
End
