/****************************************************************/
/*          Check the file RELAYRULES.TXT for some errors       */
/*                                                              */
/*      Author:       Peter Moylan (peter@ee.newcastle.edu.au)  */
/*      Started:      14 August 2017                            */
/*      Last revised: 15 August 2017                            */
/*                                                              */
/*  Usage:                                                      */
/*         checkrelayrules filename                             */
/*                                                              */
/*     If the optional filename is missing, then we check the   */
/*     file RELAYRULES.TXT                                      */
/*                                                              */
/*  Installation:                                               */
/*     Put this file in the directory containing the text       */
/*     file to be checked.                                      */
/*                                                              */
/****************************************************************/

CALL RxFuncAdd SysLoadFuncs, rexxutil, sysloadfuncs
CALL SysLoadFuncs

PARSE ARG filename
IF (filename = '') THEN filename = "RELAYRULES.TXT"

/* Does the file exist? */

IF STREAM(filename, 'C', "QUERY EXISTS") = "" THEN
    DO
        SAY "File "filename" does not exist"
        EXIT 1
    END

SAY "Using file "filename
errcount = CheckFile(filename)
SAY errcount" errors"

EXIT (errcount>0)

/****************************************************************/
/*            CHECKING THE FILE FOR GROSS ERRORS                */
/****************************************************************/

CheckFile: PROCEDURE

    /* Checks the file whose name is given as the argument */

    errcount = 0
    lineno = 0
    vialine = 0
    haveseenvia = 0
    tocount = 0
    PARSE ARG filename
    DO WHILE STREAM(filename,S) \= 'NOTREADY'
        line = LINEIN(filename)
        lineno = lineno + 1

        /* Strip comments and leading/trailing whitespace */

        k = POS('#', line)
        IF k > 0 THEN line = LEFT(line, k-1)
        line = STRIP(line)
        IF line = "" THEN
            DO
                /* Empty line, do nothing */
            END
        ELSE IF POS(':',line) = 0 THEN CALL ErrMes lineno, "missing colon"
        ELSE
            DO
                PARSE VAR line token':'domain
                token = STRIP(token)
                domain = STRIP(domain)
                IF TRANSLATE(token) = "TO" THEN
                    DO
                        tocount = tocount + 1
                        IF \haveseenvia THEN
                            CALL ErrMes lineno, "'to' line with no preceding 'via'"
                        ELSE IF domain = '' THEN
                            CALL ErrMes lineno, "'to' line with missing domain name"
                    END
                ELSE IF TRANSLATE(token) = "VIA" THEN
                    DO
                        haveseenvia = 1
                        IF domain = '' THEN
                            CALL ErrMes lineno, "'via' line with missing domain name"
                        ELSE IF Wild(domain) THEN
                            CALL ErrMes lineno, "a 'via' domain may not contain wildcard characters"
                        ELSE IF (tocount = 0) & (vialine > 0) THEN
                            CALL ErrMes vialine, "a 'via' line with no following 'to' lines"
                        vialine = lineno
                        tocount = 0
                    END
                ELSE CALL ErrMes lineno, "unknown token '"token"'"
            END
    END /* of DO WHILE */
    RETURN errcount

/****************************************************************/

ErrMes: PROCEDURE EXPOSE errcount

    /* Puts out an error message. */

    PARSE ARG lineno, text
    SAY "Line "lineno": "text
    errcount = errcount + 1
    RETURN

/****************************************************************/

Wild: PROCEDURE

    /* Returns 1 if its argument contains '*' or '?'    */
    /* characters, 0 otherwise.                         */

    PARSE ARG str
    found = POS('*', str)>0
    IF \found THEN found = POS('?', str)>0
    RETURN found

/****************************************************************/

