/****************************************************************/
/*                      Loadini for Weasel                      */
/*                                                              */
/*   This script invokes the generic LoadINI to translate       */
/*   from WEASEL.TNI to WEASEL.INI.  Then, if multidomain       */
/*   mode is in effect, it also translates each DOMAIN.TNI      */
/*   to the corresponding DOMAIN.INI.                           */
/*                                                              */
/*      Author:       Peter Moylan (peter@pmoylan.org)          */
/*      Started:      11 January 2009                           */
/*      Last revised: 13 January 2009                           */
/*                                                              */
/*  Usage:                                                      */
/*         mloadini                                             */
/*                                                              */
/*     (There are no arguments.)                                */
/*                                                              */
/*  Installation:                                               */
/*     Put this file in the directory containing WEASEL.INI     */
/*                                                              */
/****************************************************************/

Globals = "MultiDomain MailRoot Domains."
CALL RxFuncAdd SysLoadFuncs, rexxutil, sysloadfuncs
CALL SysLoadFuncs

'LOADINI WEASEL'
CALL ParseDomainInfo
IF MultiDomain & (Domains.0 > 0) & (Domains.1 \= '') THEN DO
    DO k = 1 TO Domains.0
        'LOADINI '||MailRoot||Domains.k||'\DOMAIN.INI'
    END
END

EXIT 0

/****************************************************************/
/*                                                              */
/*       BUILDING THE MAILROOT AND THE LIST OF DOMAINS          */
/*                                                              */
/*  This is an initialisation procedure that sets the global    */
/*  variables MultiDomain, MailRoot, and Domains.  For the      */
/*  purposes of this program those variables have values that   */
/*  never change.                                               */
/*                                                              */
/*  Note that, since this procedure reads information from      */
/*  WEASEL.INI, it must not be called until after the load of   */
/*  WEASEL.INI.                                                 */
/*                                                              */
/****************************************************************/

ParseDomainInfo: PROCEDURE expose (Globals)

    /* On exit, Domains.0 contains the number of domains we are */
    /* hosting, and the domain names are in Domains.j for j = 1 */
    /* to Domains.0.  In the single-domain case, Domains.0 = 1  */
    /* and Domains.1 is the empty string.                       */

    /* This procedure also sets the global variables 'MailRoot' */
    /* and 'MultiDomain'.                                       */

    /* Figure out the mail root. */

    INIFile = "WEASEL.INI"
    Nul = '00'X
    MailRoot = SysIni(INIFile, '$SYS', 'MailRoot')
    j = POS(Nul,MailRoot)
    IF j > 0 THEN MailRoot = LEFT(MailRoot, j-1)
    MailRoot = TRANSLATE(STRIP(MailRoot), '\', '/')

    MultiDomain = SysIni(INIFile, '$SYS', 'MultiDomainEnabled') == '01'X
    IF MultiDomain THEN DO
        Domains.0 = 0
        DomainString = SysIni(INIFile, '$SYS', 'Domains')

        DO WHILE DomainString \= ""
            PARSE VALUE DomainString WITH current '00'X DomainString
            current = TRANSLATE(STRIP(current))
            IF current \= "" THEN DO
                k = Domains.0 + 1
                Domains.k = current
                Domains.0 = k
            END /*IF*/
        END /*DO FOREVER*/

    END
    ELSE DO
        Domains.0 = 1
        Domains.1 = ''
    END /*IF*/;
    RETURN

/****************************************************************/

