/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;

public class TimeDialog
extends JDialog
implements ActionListener {
    private TextEditorPane textPane;
    private JLabel timeLabel;
    private JComboBox comboTime;
    private JButton okButton;
    private JButton cancelButton;

    public TimeDialog(TextEditorPane arg) {
        this.textPane = arg;
        this.setTitle("Insert Date & Time");
        this.setSize(350, 150);
        this.setDefaultCloseOperation(2);
        this.createComponent();
        this.setResizable(false);
        this.setModal(true);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int y = screenSize.height / 2 - this.getHeight() / 2;
        int x = screenSize.width / 2 - this.getWidth() / 2;
        this.setLocation(x, y);
        this.setVisible(true);
    }

    private void createComponent() {
        this.timeLabel = new JLabel("Select a format", 0);
        this.comboTime = new JComboBox<String>(new String[]{"dd/MM/yy HH:mm:ss", "dd/MM/yy HH:mm", "dd/MM HH:mm:ss", "dd/MM HH:mm", "dd/MM/yy", "HH:mm:ss", "HH:mm"});
        this.okButton = new JButton("OK");
        this.okButton.addActionListener(this);
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.addActionListener(this);
        this.setLayout(new GridLayout(4, 2));
        this.add(new JLabel());
        this.add(new JLabel());
        this.add(this.timeLabel);
        this.add(this.comboTime);
        this.add(new JLabel());
        this.add(new JLabel());
        this.add(this.okButton);
        this.add(this.cancelButton);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source.equals(this.okButton)) {
            Date time = Calendar.getInstance().getTime();
            SimpleDateFormat sdf = new SimpleDateFormat(this.comboTime.getSelectedItem().toString());
            String formatted = sdf.format(time);
            String text = this.textPane.getText();
            int position = this.textPane.getCaretPosition();
            this.textPane.setText(String.valueOf(text.substring(0, position)) + formatted + text.substring(position, text.length()));
            this.dispose();
        } else if (source.equals(this.cancelButton)) {
            this.dispose();
        }
    }
}

