/*
 * Decompiled with CFR 0.152.
 */
package shared.md5;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.MessageDigest;
import shared.proglistener.ProgListener;
import shared.proglistener.ProgNotify;

public class JMD5Helper {
    private static final int BUF_SIZE = 4096;
    private byte[] m_byteArray;

    public byte[] getMD5() {
        return this.m_byteArray;
    }

    public String getMD5AsString() {
        String string = null;
        if (this.m_byteArray != null && this.m_byteArray.length == 16) {
            string = String.format("%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x", this.m_byteArray[0], this.m_byteArray[1], this.m_byteArray[2], this.m_byteArray[3], this.m_byteArray[4], this.m_byteArray[5], this.m_byteArray[6], this.m_byteArray[7], this.m_byteArray[8], this.m_byteArray[9], this.m_byteArray[10], this.m_byteArray[11], this.m_byteArray[12], this.m_byteArray[13], this.m_byteArray[14], this.m_byteArray[15]);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doCalculateMD5(File file, ProgListener progListener) {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            long l = file.length();
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            byte[] byArray = new byte[4096];
            int n = -1;
            if (progListener != null) {
                progListener.notify(new ProgNotify(0, 0, new Long(l).toString()));
            }
            long l2 = l;
            boolean bl = false;
            while (l != 0L && (n = fileInputStream.read(byArray)) >= 0) {
                messageDigest.update(byArray, 0, n);
                assert (l <= (long)n);
                if (progListener == null || !(bl = progListener.notify(new ProgNotify(1, (int)(1000L - (l -= (long)n) * 1000L / l2), null)))) continue;
            }
            if (bl) {
                if (progListener != null) {
                    progListener.notify(new ProgNotify(-2, 0, null));
                }
            } else {
                this.m_byteArray = messageDigest.digest();
                String string = String.format("%02X%02X%02X%02X%02X%02X%02X%02X%02X%02X%02X%02X%02X%02X%02X%02X", this.m_byteArray[0], this.m_byteArray[1], this.m_byteArray[2], this.m_byteArray[3], this.m_byteArray[4], this.m_byteArray[5], this.m_byteArray[6], this.m_byteArray[7], this.m_byteArray[8], this.m_byteArray[9], this.m_byteArray[10], this.m_byteArray[11], this.m_byteArray[12], this.m_byteArray[13], this.m_byteArray[14], this.m_byteArray[15]);
                if (progListener != null) {
                    progListener.notify(new ProgNotify(2, 1000, string));
                }
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (progListener != null) {
                progListener.notify(new ProgNotify(-1, 0, fileNotFoundException.toString()));
            }
        }
        catch (Exception exception) {
            if (progListener != null) {
                progListener.notify(new ProgNotify(-1, 0, exception.toString()));
            }
        }
        finally {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public void calculateMD5(File file, ProgListener progListener) {
        final File file2 = file;
        final ProgListener progListener2 = progListener;
        Thread thread = new Thread(){

            public void run() {
                JMD5Helper.this.doCalculateMD5(file2, progListener2);
            }
        };
        thread.start();
    }

    public void calculateMD5(String string, ProgListener progListener) {
        this.calculateMD5(new File(string), progListener);
    }
}

