/*
 * Decompiled with CFR 0.152.
 */
package jexifviewer;

import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import jexifviewer.JImgView;
import jexifviewer.JMainFrame;
import jexifviewer.Main;
import shared.cvshelper.Cvs;
import shared.dialog.JModalDialog;
import shared.files.JMyFileFilter;
import shared.files.JPathHelper;
import shared.layout.JGridBagPanel;
import shared.number.JDoubleHelper;
import shared.valueholder.JValueHolder;

@Cvs(header="$Header: /home/reiner/cvs/Java/JExifViewer/src/jexifviewer/JExportDialog.java,v 1.6 2010/04/02 12:12:13 reiner Exp $")
public final class JExportDialog
extends JModalDialog {
    private JComboBox m_qualityBox;
    private JLabel m_qualityLabel;
    private JComboBox m_scaleFactorBox;
    private JImgView m_imgView;
    private JTextField m_sizeField;
    private JTextField m_fileField;
    private JButton m_fileBrowseButton;
    private JCheckBox m_optimizedHufButton;
    private JComboBox m_typeBox;
    public double m_quality = 0.85f;
    public double m_scaleFactor = 1.0;
    public File m_file;
    public boolean m_bOptimizedHuf;
    public String m_mimeType = "image/jpeg";

    public JExportDialog(JMainFrame jMainFrame, JImgView jImgView) {
        super(jMainFrame, Main.getString("export_caption"), Main.getString("ok"), Main.getString("cancel"));
        this.m_imgView = jImgView;
    }

    protected void doInit() {
        double[] dArray;
        JGridBagPanel jGridBagPanel = new JGridBagPanel();
        jGridBagPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        int n = 0;
        jGridBagPanel.addComponent(new JLabel(Main.getString("export_label_type")), 0, n, 17, new Insets(5, 0, 0, 0));
        this.m_typeBox = new JComboBox();
        jGridBagPanel.addComponent(this.m_typeBox, -1, ++n, 17, new Insets(2, 0, 10, 0));
        this.m_typeBox.addItem(new JValueHolder<String>(Main.getString("export_type_jpg"), "image/jpeg"));
        this.m_typeBox.addItem(new JValueHolder<String>(Main.getString("export_type_png"), "image/png"));
        this.m_typeBox.addItem(new JValueHolder<String>(Main.getString("export_type_bmp"), "image/bmp"));
        this.m_typeBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JExportDialog.this.updateTypeData();
                if (!JExportDialog.this.m_mimeType.equals("image/jpeg")) {
                    JExportDialog.this.m_optimizedHufButton.setVisible(false);
                    JExportDialog.this.m_qualityLabel.setVisible(false);
                    JExportDialog.this.m_qualityBox.setVisible(false);
                } else {
                    JExportDialog.this.m_optimizedHufButton.setVisible(true);
                    JExportDialog.this.m_qualityLabel.setVisible(true);
                    JExportDialog.this.m_qualityBox.setVisible(true);
                }
            }
        });
        this.m_qualityLabel = new JLabel(Main.getString("export_label_quality"));
        jGridBagPanel.addComponent(this.m_qualityLabel, 0, ++n, 17, new Insets(5, 0, 0, 0));
        this.m_qualityBox = new JComboBox();
        jGridBagPanel.addComponent(this.m_qualityBox, 0, ++n, 17, new Insets(2, 0, 0, 0));
        this.m_qualityBox.setEditable(true);
        for (double d = 0.0; d <= 1.01; d += 0.05) {
            this.m_qualityBox.addItem(String.format("%.2f", d));
        }
        this.m_qualityBox.setSelectedItem(String.format("%.2f", this.m_quality));
        this.m_optimizedHufButton = new JCheckBox(Main.getString("export_label_optimizedhuf"));
        jGridBagPanel.addComponent(this.m_optimizedHufButton, 1, n, 17, new Insets(2, 10, 0, 0), 1, 1, 1.0, 0.0, 2);
        this.m_optimizedHufButton.setSelected(this.m_bOptimizedHuf);
        jGridBagPanel.addComponent(new JLabel(Main.getString("export_label_file")), 0, ++n, 17, new Insets(5, 0, 0, 0));
        this.m_fileField = new JTextField(24);
        jGridBagPanel.addComponent(this.m_fileField, 0, ++n, 17, new Insets(2, 0, 0, 0), 2, 1, 1.0, 0.0, 2);
        this.m_fileBrowseButton = new JButton(Main.getString("export_label_file_browse"));
        jGridBagPanel.addComponent(this.m_fileBrowseButton, 2, n, 17, new Insets(2, 5, 0, 0));
        final JExportDialog jExportDialog = this;
        this.m_fileBrowseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Object object;
                JFileChooser jFileChooser = new JFileChooser(Main.m_settings.getExportDirectory());
                jFileChooser.setDialogTitle(Main.getString("caption_export"));
                FileFilter fileFilter = jFileChooser.getAcceptAllFileFilter();
                jFileChooser.setAcceptAllFileFilterUsed(false);
                JMyFileFilter jMyFileFilter = new JMyFileFilter();
                JExportDialog.this.updateTypeData();
                if (JExportDialog.this.m_mimeType.equals("image/jpeg")) {
                    jMyFileFilter.setDescription(Main.getString("filefilter_jpg"));
                    for (String string : Main.m_settings.m_jpgExtensions) {
                        jMyFileFilter.addExtension(string);
                    }
                } else if (JExportDialog.this.m_mimeType.equals("image/png")) {
                    jMyFileFilter.setDescription(Main.getString("filefilter_png"));
                    jMyFileFilter.addExtension("png");
                } else if (JExportDialog.this.m_mimeType.equals("image/bmp")) {
                    jMyFileFilter.setDescription(Main.getString("filefilter_bmp"));
                    jMyFileFilter.addExtension("bmp");
                }
                jFileChooser.addChoosableFileFilter(jMyFileFilter);
                jFileChooser.addChoosableFileFilter(fileFilter);
                jFileChooser.setFileFilter(jMyFileFilter);
                if (!JExportDialog.this.m_fileField.getText().isEmpty()) {
                    JExportDialog.this.m_file = new File(JExportDialog.this.m_fileField.getText());
                } else if (JExportDialog.this.m_file != null) {
                    object = new StringBuilder();
                    ((StringBuilder)object).append(Main.m_settings.getExportDirectory());
                    JPathHelper.addSeparator((StringBuilder)object);
                    ((StringBuilder)object).append(JPathHelper.getBaseFileName(JExportDialog.this.m_file));
                    JExportDialog.this.m_file = new File(((StringBuilder)object).toString());
                }
                jFileChooser.setSelectedFile(JExportDialog.this.m_file);
                if (jFileChooser.showSaveDialog(jExportDialog) == 0) {
                    object = jFileChooser.getSelectedFile().getAbsolutePath();
                    if (JPathHelper.getFileExtension((String)object).equals("")) {
                        if (JExportDialog.this.m_mimeType.equals("image/jpeg")) {
                            object = (String)object + ".jpg";
                        } else if (JExportDialog.this.m_mimeType.equals("image/png")) {
                            object = (String)object + ".png";
                        } else if (JExportDialog.this.m_mimeType.equals("image/bmp")) {
                            object = (String)object + ".bmp";
                        }
                    }
                    JExportDialog.this.m_fileField.setText((String)object);
                }
            }
        });
        jGridBagPanel.addComponent(new JLabel(Main.getString("export_label_scalefactor")), 0, ++n, 17, new Insets(5, 0, 0, 0));
        this.m_scaleFactorBox = new JComboBox();
        jGridBagPanel.addComponent(this.m_scaleFactorBox, -1, ++n, 17, new Insets(2, 0, 10, 0));
        this.m_scaleFactorBox.setEditable(true);
        for (double d : dArray = new double[]{0.125, 0.25, 0.3333333333333333, 0.5, 0.6666666666666666, 0.75, 0.875, 1.0, 1.25, 1.3333333333333333, 1.5, 1.6666666666666667, 1.75, 2.0}) {
            this.m_scaleFactorBox.addItem(String.format("%.3f", d));
        }
        this.m_scaleFactorBox.setSelectedItem(String.format("%.3f", this.m_scaleFactor));
        this.m_scaleFactorBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JExportDialog.this.updateSizeField();
            }
        });
        jGridBagPanel.addComponent(new JLabel(Main.getString("export_label_size")), 1, --n, 17, new Insets(5, 10, 0, 0));
        this.m_sizeField = new JTextField(13);
        jGridBagPanel.addComponent(this.m_sizeField, -1, ++n, 17, new Insets(2, 10, 10, 0));
        this.m_sizeField.setEditable(false);
        this.updateSizeField();
        if (this.m_mimeType.equals("image/jpeg")) {
            this.m_typeBox.setSelectedIndex(0);
        } else if (this.m_mimeType.equals("image/png")) {
            this.m_typeBox.setSelectedIndex(1);
        } else if (this.m_mimeType.equals("image/bmp")) {
            this.m_typeBox.setSelectedIndex(2);
        }
        this.setPreferredSize(new Dimension(550, 320));
        this.setResizable(false);
        this.addCtrlPanel(jGridBagPanel);
    }

    protected boolean doGetData() {
        boolean bl = false;
        try {
            this.m_quality = JDoubleHelper.parseDouble((String)this.m_qualityBox.getSelectedItem());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (this.m_quality < 0.0) {
            this.m_quality = 0.0;
        }
        if (this.m_quality > 1.0) {
            this.m_quality = 1.0;
        }
        this.updateScaleData();
        String string = this.m_fileField.getText();
        if (string.length() > 0) {
            this.m_file = new File(string);
            Main.m_settings.setExportDirectory(JPathHelper.getFolder(this.m_file));
            bl = true;
        } else {
            JOptionPane.showMessageDialog(this, Main.getString("msg_export_nofile"), Main.getMessageBoxCaption(), 0);
            this.m_fileField.requestFocusInWindow();
        }
        this.m_bOptimizedHuf = this.m_optimizedHufButton.isSelected();
        this.updateTypeData();
        return bl;
    }

    protected void updateScaleData() {
        try {
            this.m_scaleFactor = JDoubleHelper.parseDouble((String)this.m_scaleFactorBox.getSelectedItem());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    protected void updateTypeData() {
        JValueHolder jValueHolder = (JValueHolder)this.m_typeBox.getSelectedItem();
        this.m_mimeType = (String)jValueHolder.getValue();
    }

    protected void updateSizeField() {
        this.updateScaleData();
        Dimension dimension = this.m_imgView.getImageSize(this.m_imgView.m_img, null, this.m_scaleFactor);
        this.m_sizeField.setText(String.format("%d x %d", dimension.width, dimension.height));
    }
}

