<?xml version="1.0" encoding="utf-8"?>
<!DOCTYPE xsl:stylesheet SYSTEM "ui.dtd">
<xsl:stylesheet version="1.1" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:mm="http://os2.snc.ru/manjary/xslt">
<xsl:output doctype-system="about:legacy-compat" method="html" indent="no" encoding="utf-8"/>

<xsl:template match="part[@name='banip']">
  <style>
    &css_part_banip;
  </style>
  <xsl:apply-templates select="list"/>
  <xsl:apply-templates select="pool"/>
</xsl:template>


<xsl:template match="part[@name='banip']/list">
  <div id="check-item-list">
    <xsl:apply-templates select="item"/>
  </div>
</xsl:template>

<xsl:template match="part[@name='banip']/list/item">
  <div class="list__row">
    <a class="row__caption" href="?o={mm:encode-uri(.)}">
      <xsl:value-of select="."/>
    </a>
    <div class="row__caption__count-time">
      <xsl:value-of select="@count"/>
    </div>
  </div>
</xsl:template>


<xsl:template match="part[@name='banip']/pool">
  <div class="check-item-list">
    <input class="check-item-list__new-cb" type="checkbox" id="check-item-list__new-cb"/>
    <form class="check-item-list__row check-item-list__new" id="check-item-list__form-new" method="post">
      <input class="check-item-list__new__input-text" type="text" name="new" value="{new}"
        placeholder="{$strings/banip[@name='placeholder-ip']}"/>
      <input class="check-item-list__new__btn" type="submit" value="{$strings/submit[@name='create']}"/>
    </form>

    <form id="check-item-list" enctype="multipart/form-data" method="post" action="#">
      <xsl:apply-templates select="item"/>
    </form>
  </div>
</xsl:template>

<xsl:template match="pool/item">
  <div class="check-item-list__row">
    <input class="row__cb" type="checkbox" name="del" value="{.}"/>
    <div class="row__caption">
      <xsl:value-of select="."/>
    </div>

    <div class="row__caption__count-time">
      <xsl:if test="@type='R'">
        <div><xsl:value-of select="$strings/banip[@name='unblocked']"/></div>
      </xsl:if>
      <xsl:call-template name="timer">
        <xsl:with-param name="value" select="@exp-time"/>
      </xsl:call-template>
      <xsl:call-template name="date-time">
        <xsl:with-param name="value" select="@created"/>
      </xsl:call-template>
    </div>
  </div>
</xsl:template>

</xsl:stylesheet>
