<?xml version="1.0" encoding="utf-8"?>
<!DOCTYPE xsl:stylesheet SYSTEM "ui.dtd">
<xsl:stylesheet version="1.1" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output doctype-system="about:legacy-compat" method="html" indent="no" encoding="utf-8"/>

<xsl:template match="part[@name='subst']">
  <xsl:apply-templates select="list"/>
</xsl:template>

<xsl:template match="part[@name='subst']/list">
  <style>
    &css_form_checkitems;
  </style>
  <script>
    &js_form_checkitems;
  </script>
  <div class="check-item-list">
    <input class="check-item-list__new-cb" type="checkbox" id="check-item-list__new-cb"/>
    <form class="check-item-list__row check-item-list__new" id="check-item-list__form-new" method="post">
      <input class="check-item-list__new__input-text" type="text" name="new" value="{new}"/>
      <input class="check-item-list__new__btn" type="submit" value="{$strings/submit[@name='create']}"/>
    </form>
    <form id="check-item-list" enctype="multipart/form-data" method="post" action="#">
      <xsl:apply-templates select="item"/>
    </form>
  </div>
</xsl:template>

<xsl:template match="part[@name='subst']/list/item">
  <div class="check-item-list__row">
    <input class="row__cb" type="checkbox" name="del" value="{.}"/>
    <div class="row__caption">
      <xsl:value-of select="."/>
    </div>
  </div>
</xsl:template>

</xsl:stylesheet>
