<?xml version="1.0" encoding="utf-8"?>
<!DOCTYPE xsl:stylesheet SYSTEM "ui.dtd">
<xsl:stylesheet version="1.1" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output doctype-system="about:legacy-compat" method="html" indent="no" encoding="utf-8"/>

<xsl:template match="part[@name='log']">
  <xsl:apply-templates select="property"/>
</xsl:template>


<!--
     Log properties: filter
-->

<xsl:template match="part[@name='log']/property[@name='filter']">
  <style>
    &css_form;
    &css_part_log_filter;
  </style>
  <script>
    &js_part_log_filter;
  </script>

  <div class="module-groups">
    <xsl:apply-templates select="module[not(@group=preceding::module/@group)]" mode="group"/>
  </div>

  <form class="form-cnt" id="modules" enctype="multipart/form-data" method="post">
    <div class="form-cnt__form-ctl form-cnt__form-ctl--level">
      <div class="form-ctl__caption form-ctl__caption--level">
        <xsl:value-of select="$strings/log[@name='level']"/>
      </div>
      <div class="form-ctl__value form-ctl__value--level">
        <select name="log-level">
          <xsl:call-template name="log-level">
            <xsl:with-param name="cur" select="1"/>
            <xsl:with-param name="sel" select="level"/>
          </xsl:call-template>
        </select>
      </div>
    </div>

    <div class="form-apply-cnt">
      <input class="form-apply" type="submit" value="{$strings/submit}"/>
    </div>
  </form>
  
</xsl:template>

<xsl:template match="module" mode="group">
  <div class="module-groups__log-group">
    <xsl:if test="@group!=''">
      <label class="log-group__name">
        <input type="checkbox" name="group-{@group}"/>
        <xsl:value-of select="@group"/>
      </label>
    </xsl:if>

    <xsl:variable name="group" select="@group"/>
    <xsl:apply-templates select="../module[@group=$group]" mode="group-item"/>
  </div>
</xsl:template>

<xsl:template match="module" mode="group-item">
  <label class="log-group__item">
    <input type="checkbox" name="log-mod-{.}" form="modules" value="on">
      <xsl:if test="@checked">
        <xsl:attribute name="checked">checked</xsl:attribute>
      </xsl:if>
    </input>
    <xsl:value-of select="."/>
  </label>
</xsl:template>



<xsl:template name="log-level">
  <xsl:param name="cur"/>
  <xsl:param name="sel"/>

  <option value="{$cur}">
     <xsl:if test="$cur=$sel">
       <xsl:attribute name="selected">1</xsl:attribute>
     </xsl:if>
     <xsl:value-of select="$cur"/>
  </option>

  <xsl:if test="$cur &lt; 5">
    <xsl:call-template name="log-level">
      <xsl:with-param name="cur" select="$cur+1"/>
      <xsl:with-param name="sel" select="$sel"/>
    </xsl:call-template>
  </xsl:if>
</xsl:template>


<!--
     Log properties: entries
-->

<xsl:template match="part[@name='log']/property[@name='entries']">
  <script>
    &js_part_log_entries;
  </script>
  <style>
    &css_part_log_entries;
  </style>

  <div class="ctrl-pad">
    <input type="button" value="" id="ctrl-pad__btn"/>

    <label>
      <input type="checkbox" id="ctrl-pad__show-date-cb"/>
      <xsl:value-of select="$strings/log[@name='show-dates']"/>
    </label>
  </div>

  <div id="log-entries__cont">
  </div>
</xsl:template>

</xsl:stylesheet>
