/*
   Example of using the RXMMP library.

   The example demonstrates querying user properties and vCards using the
   mmpQueryUser() and mmpQueryVCStem() functions.
*/

parse arg MMPServer MMPUser MMPPassword User

if User = "" then
do
  parse source srcOS " " srcMode " " srcFile
  srcFile = filespec( "name", srcFile )
  say "Usage: " || srcFile || " server:port username password user[@domain]"
  exit
end


/* Load functions from rxmmp.dll */
if RxFuncQuery("mmpLoadFuncs") then
do
  call RxFuncAdd "mmpLoadFuncs", "RXMMP", "mmpLoadFuncs"
  call mmpLoadFuncs
end

/* Connect to the MMP server and log in. */

MMPHandle = mmpCreate( MMPServer, MMPUser, MMPPassword )
parse var MMPHandle resStatus ":" resError
if resStatus = "ERROR" then
  call die "mmpCreate", resStatus, resError


/* User information. */

res = mmpQueryUser( MMPHandle, "info.!", User )
parse var res resStatus ":" resError
if resStatus \= "SUCCESS" then
  call die "mmpQueryUser", resStatus, resError

say "User"
say "  Username: " || info.!USER
say "  Flags: " || info.!FLAGS
say "  Mailbox size limit: " || info.!LIMIT
say "  Mailbox space used: " || info.!USED
say "  Forward emails to: " || info.!COPYTO
say "  Limiting the depth of nested folders: " || info.!DEPTHMAX
say "  Login time: " || info.!LOGINTIME


/* VCard */

res = mmpQueryVCStem( MMPHandle, "vc.!", User )
parse var res resStatus ":" resError
if resStatus \= "SUCCESS" then
  call die "mmpQueryVCStem", resStatus, resError

say
say "vCard"
say "  Family name: " || vc.!N_FAMILY
say "  Given name: " || vc.!N_GIVEN
say "  Additional/Middle names: " || vc.!N_MID
say "  Honorific prefixes: " || vc.!N_PREF
say "  Honorific suffixes: " || vc.!N_SUFF
say "  Full name/Title: " || vc.!FN
say "  Nick: " || vc.!NICKNAME
say "  Organization: " || vc.!ORG
say "  Department: " || vc.!ORG_DEP
say "  Job title: " || vc.!TITLE
say "  Telephone number, home: " || vc.!TEL_HOME
say "  Telephone number, work: " || vc.!TEL_WORK
say "  Telephone number, cell: " || vc.!TEL_CELL
say "  Alternative e-mail: " || vc.!EMAIL
say "  Note: " || vc.!NOTE


/* Log out, close the connection and destroy the MMP Client object. */
call mmpDestroy( MMPHandle )

call mmpDropFuncs

exit


/* DIE func.name, result status, error text */
die:
  say arg(1) || "(): " || arg(2) || " (" || arg(3) || ")"
  call mmpDropFuncs
  exit
