<?xml version="1.0" encoding="utf-8"?>
<!DOCTYPE xsl:stylesheet SYSTEM "ui.dtd">
<xsl:stylesheet version="1.1" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output doctype-system="about:legacy-compat" method="html" indent="no" encoding="utf-8"/>

<xsl:template match="part[@name='spam']">
  <xsl:apply-templates select="property"/>
</xsl:template>

<xsl:template match="part/property[@name='whitelist']|part/property[@name='redlist']">
  <style>
    &css_part_spam;
  </style>
  <div class="check-item-list">
    <input class="check-item-list__new-cb" type="checkbox" id="check-item-list__new-cb"/>
    <form class="check-item-list__row check-item-list__new" id="check-item-list__form-new" method="post">
      <input class="check-item-list__new__input-text" type="text" name="new" value="{new}"
        placeholder="{$strings/spam[@name='placeholder-addr']}"/>
      <input class="check-item-list__new__input-text check-item-list__new__input-text--number"
        type="number" name="new-ttl" value="{new/@ttl}"
        placeholder="{$strings/spam[@name='placeholder-TTL']}"/>
      <xsl:value-of select="$strings/spam[@name='TTL-days']"/>.
      <input class="check-item-list__new__btn" type="submit" value="{$strings/submit[@name='create']}"/>
    </form>

    <form id="check-item-list" enctype="multipart/form-data" method="post" action="#">
      <xsl:apply-templates select="item"/>
    </form>
  </div>
</xsl:template>

<xsl:template match="property[@name='whitelist']/item|property[@name='redlist']/item">
  <div class="check-item-list__row">
    <input class="row__cb" type="checkbox" name="del" value="{.}"/>
    <div class="row__caption">
      <xsl:value-of select="."/>
    </div>

    <xsl:if test="@ttl">
      <div class="row__caption__TTL">
        <xsl:call-template name="timer">
          <xsl:with-param name="value" select="@ttl"/>
        </xsl:call-template>
      </div>
    </xsl:if>
  </div>
</xsl:template>

</xsl:stylesheet>
