/*
   Example of using the RXMMP library.

   The example demonstrates changing user properties using the mmpSetUser()
   function.
*/

parse arg MMPServer MMPUser MMPPassword User Password

if Password = "" then
do
  parse source srcOS " " srcMode " " srcFile
  srcFile = filespec( "name", srcFile )
  say "Usage: " || srcFile || " server:port username password user[@domain] newPassword"
  say "Where:"
  say "  server:port, username, password - Data for connecting to the MMP server."
  say "  user[@domain] - The user for whom a password needs to be set."
  say "  newPassword - New password for user user[@domain]." 
  exit
end

/* Load functions from rxmmp.dll */
if RxFuncQuery("mmpLoadFuncs") then
do
  call RxFuncAdd "mmpLoadFuncs", "RXMMP", "mmpLoadFuncs"
  call mmpLoadFuncs
end

/* Connect to the MMP server and log in. */

MMPHandle = mmpCreate( MMPServer, MMPUser, MMPPassword )
parse var MMPHandle resStatus ":" resError
if resStatus = "ERROR" then
  call die "mmpCreate", resStatus, resError

/* Fill user properties. */

prop.!PASSWORD = Password
/*
   Other available properties:

   prop.!FLAGS = "VCEDIT HASH"
   prop.!LIMIT = "100 mb"
   prop.!COPYTO = "trash@domain.invalid"
   prop.!DEPTHMAX = 20
*/

/* Set properties. */

parse value mmpSetUser( MMPHandle, "prop.!", User ) with resStatus ":" resError
if resStatus \= "SUCCESS" then
  call die "mmpSetVCStem", resStatus, resError

say "Done"

/* Log out, close the connection and destroy the MMP Client object. */
call mmpDestroy( MMPHandle )
call mmpDropFuncs

exit


/* DIE func.name, result status, error text */
die:
  say arg(1) || "(): " || arg(2) || " (" || arg(3) || ")"
  call mmpDropFuncs
  exit
