/*
   Example of using the RXMMP library.

   The example demonstrates creating a new user using the mmpCreate()
   function.
*/

parse arg MMPServer MMPUser MMPPassword User Password

if User = "" then
do
  parse source srcOS " " srcMode " " srcFile
  srcFile = filespec( "name", srcFile )
  say "Usage: " || srcFile || " server:port username password user[@domain] [newPassword]"
  say "Where:"
  say "  server:port, username, password - Data for connecting to the MMP server."
  say "  user[@domain] - New user name."
  say "  newPassword - New user password (optionsl)." 
  exit
end

/* Load functions from rxmmp.dll */
if RxFuncQuery("mmpLoadFuncs") then
do
  call RxFuncAdd "mmpLoadFuncs", "RXMMP", "mmpLoadFuncs"
  call mmpLoadFuncs
end

/* Connect to the MMP server and log in. */

MMPHandle = mmpCreate( MMPServer, MMPUser, MMPPassword )
parse var MMPHandle resStatus ":" resError
if resStatus = "ERROR" then
  call die "mmpCreate", resStatus, resError

/* Fill user properties. */

if Password \= "" then
  prop.!PASSWORD = Password

/*
   Other available properties:

   prop.!FLAGS = "VCEDIT HASH"
   prop.!LIMIT = "100 mb"
   prop.!COPYTO = "trash@domain.invalid"
   prop.!DEPTHMAX = 20
*/

/* Create a new user. */

parse value mmpCreateUser( MMPHandle, "prop.!", User ) ,
      with resStatus ":" resError
if resStatus \= "SUCCESS" then
  call die "mmpCreateUser", resStatus, resError

say "Done"


/* Log out, close the connection and destroy the MMP Client object. */
call mmpDestroy( MMPHandle )
call mmpDropFuncs

exit


/* DIE func.name, result status, error text */
die:
  say arg(1) || "(): " || arg(2) || " (" || arg(3) || ")"
  call mmpDropFuncs
  exit
