<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.1" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output doctype-system="about:legacy-compat" method="html" indent="no" encoding="utf-8"/>

<xsl:template match="vcard">

  <!--
    Outputs an HTML form for a 'vcard' node with input fields if there is no
    'read-only' attribute, or static data otherwise. The caller is responsible
    for creating the parent 'form' tag.
  -->

  <!-- Single line input fields. -->
  <xsl:call-template name="vc-enum-fields">
    <xsl:with-param name="list">N-family N-given N-mid N-pref N-suff FN NICKNAME ORG ORG-dep TITLE TEL-home TEL-work TEL-cell EMAIL</xsl:with-param>
  </xsl:call-template>

  <!-- Field 'NOTE': multiline input fileld. -->
  <div class="form-cnt__form-ctl">
    <div class="form-ctl__caption">
      <xsl:value-of select="$strings/vcard[@prop='NOTE']"/>
    </div>
    <div class="form-ctl__value-textarea">
      <textarea name="NOTE" maxlength="2048">
        <xsl:if test="@read-only">
          <xsl:attribute name="readonly">readonly</xsl:attribute>
        </xsl:if>
        <xsl:value-of select="./prop[@name='NOTE']"/>
      </textarea>
    </div>
  </div>
</xsl:template>

<xsl:template name="vc-field">
  <xsl:param name="name"/>

  <div class="form-cnt__form-ctl">
    <div class="form-ctl__caption">
      <xsl:value-of select="$strings/vcard[@prop=$name]"/>
    </div>
    <div class="form-ctl__value">
      <xsl:choose>
        <xsl:when test="@read-only">
          <xsl:value-of select="./prop[@name=$name]"/>
        </xsl:when>
        <xsl:otherwise>
          <input class="form-ctl__value__input" type="text" name="{$name}" maxlength="255"
            value="{./prop[@name=$name]}" autocomplete="off"/>
        </xsl:otherwise>
      </xsl:choose>
    </div>
  </div>
</xsl:template>

<xsl:template name="vc-enum-fields">
  <xsl:param name="list"/>

  <xsl:choose>
    <xsl:when test="contains($list,' ')">
      <xsl:call-template name="vc-field">
        <xsl:with-param name="name" select="substring-before($list,' ')"/>
      </xsl:call-template>
      <xsl:call-template name="vc-enum-fields">
        <xsl:with-param name="list" select="substring-after($list,' ')"/>
      </xsl:call-template>
    </xsl:when>
    <xsl:otherwise>
      <xsl:call-template name="vc-field">
        <xsl:with-param name="name" select="$list"/>
      </xsl:call-template>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>

</xsl:stylesheet>
