<?xml version="1.0" encoding="utf-8"?>
<!DOCTYPE xsl:stylesheet SYSTEM "ui.dtd">
<xsl:stylesheet version="1.1" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output doctype-system="about:legacy-compat" method="html" indent="no" encoding="utf-8"/>

<xsl:template match="part[@name='user']">
  <xsl:apply-templates select="property"/>
</xsl:template>


<!--
     User properties: aliases
     See part-domain.xsl, template "property[@name='aliases']"
-->

<!--
     User properties: profile
-->

<xsl:template match="part[@name='user']/property[@name='profile']">
  <style>
    &css_form;
  </style>

  <form class="form-cnt" enctype="multipart/form-data" method="post">

    <xsl:call-template name="flag-row">
      <xsl:with-param name="name">DISABLED</xsl:with-param>
    </xsl:call-template>
    <xsl:call-template name="flag-row">
      <xsl:with-param name="name">BLACKHOLE</xsl:with-param>
    </xsl:call-template>

    <!-- Only administrators can set privileges. -->
    <xsl:if test="/ui/common/user/@level='admin'">
      <div class="form-cnt__form-ctl">
        <div class="form-ctl__caption">
          <xsl:value-of select="$strings/profile-level"/>
        </div>
        <div class="form-ctl__value">
          <select class="form-ctl__value__input" name="level">
            <option value="user">
              <xsl:value-of select="$strings/profile-level-user"/>
            </option>
            <option value="OPER">
              <xsl:if test="flags/flag/text()='OPER'">
                <xsl:attribute name="selected">1</xsl:attribute>
              </xsl:if>
              <xsl:value-of select="$strings/profile-level-oper"/>
            </option>
            <option value="ADMIN">
              <xsl:if test="flags/flag/text()='ADMIN'">
                <xsl:attribute name="selected">1</xsl:attribute>
              </xsl:if>
              <xsl:value-of select="$strings/profile-level-admin"/>
            </option>
          </select>
        </div>
      </div>
    </xsl:if>

    <!-- Template "login-time" from part-profile.xsl -->
    <xsl:apply-templates select="login-time"/>

    <!-- Template "used" from part-profile.xsl -->
    <xsl:apply-templates select="used"/>
    <xsl:apply-templates select="limit" mode="edit"/>
    <xsl:apply-templates select="depth-max" mode="edit"/>
    <xsl:apply-templates select="copy-to" mode="edit"/>
    <xsl:call-template name="flag-sub">
      <xsl:with-param name="name">LOCALCOPY</xsl:with-param>
    </xsl:call-template>

    <div class="form-cnt__form-ctl">
      <div class="form-ctl__caption">
        <xsl:value-of select="$strings/profile-password"/>
      </div>
      <div class="form-ctl__value">
        <input class="form-ctl__value__input" type="password" maxlength="255"
          name="password" autocomplete="new-password"/>
      </div>
    </div>
    <div class="form-cnt__form-ctl">
      <div class="form-ctl__caption">
        <xsl:value-of select="$strings/profile-password2"/>
      </div>
      <div class="form-ctl__value">
        <input class="form-ctl__value__input" type="password" maxlength="255"
          name="password2" autocomplete="new-password"/>
      </div>
    </div>
    <xsl:call-template name="flag-sub">
      <xsl:with-param name="name">HASH</xsl:with-param>
    </xsl:call-template>

    <div class="form-cnt__form-ctl">
      <label>
        <input type="checkbox" name="flag" value="VCEDIT">
          <xsl:if test="flags/flag/text()='VCEDIT'">
            <xsl:attribute name="checked">checked</xsl:attribute>
          </xsl:if>
        </input>
        <xsl:value-of select="$strings/flag[@name='VCEDIT']"/>
      </label>
    </div>
    <xsl:apply-templates select="vcard"/>

    <div class="form-apply-cnt">
      <input class="form-apply" type="submit" value="{$strings/submit}"/>
    </div>
  </form>

</xsl:template>

<xsl:template match="limit|copy-to" mode="edit">
  <xsl:variable name="prop" select="local-name()"/>
  <div class="form-cnt__form-ctl">
    <div class="form-ctl__caption">
      <xsl:value-of select="$strings/profile[@prop=$prop]"/>
    </div>
    <div class="form-ctl__value">
      <input class="form-ctl__value__input" type="text" maxlength="512" name="{local-name()}"
        autocomplete="off" value="{.}"/>
    </div>
  </div>
</xsl:template>

<xsl:template match="depth-max" mode="edit">
  <xsl:variable name="prop" select="local-name()"/>
  <div class="form-cnt__form-ctl">
    <div class="form-ctl__caption">
      <xsl:value-of select="$strings/profile[@prop=$prop]"/>
    </div>
    <div class="form-ctl__value">
      <input class="form-ctl__value__input" type="number" min="0" max="20" name="{local-name()}"
        value="{.}" autocomplete="off"/>
    </div>
  </div>
</xsl:template>

<xsl:template name="flag-sub">
  <xsl:param name="name"/>
  <div class="form-cnt__form-ctl form-cnt__form-ctl--sub">
    <div class="form-ctl__caption">
    </div>
    <label class="form-ctl__value">
      <input type="checkbox" name="flag" value="{$name}">
        <xsl:if test="flags/flag/text()=$name">
          <xsl:attribute name="checked">checked</xsl:attribute>
        </xsl:if>
      </input>
      <xsl:value-of select="$strings/flag[@name=$name]"/>
    </label>
  </div>
</xsl:template>

<xsl:template name="flag-row">
  <xsl:param name="name"/>
  <div class="form-cnt__form-ctl">
    <label>
      <input type="checkbox" name="flag" value="{$name}">
        <xsl:if test="flags/flag/text()=$name">
          <xsl:attribute name="checked">checked</xsl:attribute>
        </xsl:if>
      </input>
      <xsl:value-of select="$strings/flag[@name=$name]"/>
    </label>
  </div>
</xsl:template>

</xsl:stylesheet>
