<?xml version="1.0" encoding="utf-8"?>
<!DOCTYPE xsl:stylesheet SYSTEM "ui.dtd">
<xsl:stylesheet version="1.1" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:mm="http://os2.snc.ru/manjary/xslt">
<xsl:output doctype-system="about:legacy-compat" method="html" indent="no" encoding="utf-8"/>

<xsl:template match="part[@name='domain']">
  <xsl:apply-templates select="list"/>
  <xsl:apply-templates select="property"/>
</xsl:template>

<xsl:template match="part[@name='domain']/list">
  <div class="check-item-list">
    <input class="check-item-list__new-cb" type="checkbox" id="check-item-list__new-cb"/>
    <form class="check-item-list__row check-item-list__new" id="check-item-list__form-new" method="post">
      <input class="check-item-list__new__input-text" type="text" name="new" value="{new}"
        placeholder="{$strings/placeholder-new-domain}"/>
      <input class="check-item-list__new__btn" type="submit" value="{$strings/submit[@name='create']}"/>
    </form>

    <form id="check-item-list" enctype="multipart/form-data" method="post" action="#">
      <xsl:apply-templates select="item"/>
    </form>
  </div>
</xsl:template>

<xsl:template match="part[@name='domain']/list/item">
  <div class="check-item-list__row">
    <input class="row__cb" type="checkbox" name="del" value="{.}"/>
    <a class="row__caption" href="?o={mm:encode-uri(.)}">
      <xsl:value-of select="."/>
    </a>
  </div>
</xsl:template>


<!--
     Domain properties: aliases
-->

<xsl:template match="property[@name='aliases']">
  <div class="check-item-list">
    <input class="check-item-list__new-cb" type="checkbox" id="check-item-list__new-cb"/>
    <form class="check-item-list__row check-item-list__new" id="check-item-list__form-new" method="post">
      <input class="check-item-list__new__input-text" type="text" name="new" value="{new}"
        placeholder="{$strings/placeholder-new-alias}"/>
      <input class="check-item-list__new__btn" type="submit" value="{$strings/submit[@name='create']}"/>
    </form>

    <form id="check-item-list" enctype="multipart/form-data" method="post" action="#">
      <xsl:apply-templates select="alias"/>
    </form>
  </div>
</xsl:template>

<xsl:template match="property[@name='aliases']/alias">
  <div class="check-item-list__row">
    <input class="row__cb" type="checkbox" name="del" value="{.}"/>
    <div class="row__caption">
      <xsl:value-of select="."/>
    </div>
  </div>
</xsl:template>


<!--
     Domain properties: dkim
-->

<xsl:template match="property[@name='dkim']">
  <style>
    &css_form;
    &css_part_domain_dkim;
  </style>
  <script>
    &js_part_domain_dkim;
  </script>

  <form class="form-cnt" enctype="multipart/form-data" method="post">
    <div class="form-cnt__form-ctl" style="font-size: 14pt;">
      <div class="form-ctl__mode-ptr">&#9655;</div>
      <div class="form-ctl__mode-ptr">&#9698;</div>
      <select class="form-ctl__select" name="mode">
        <option value="OFF">
          <xsl:if test="mode='OFF'">
            <xsl:attribute name="selected">1</xsl:attribute>
          </xsl:if>
          <xsl:value-of select="$strings/dkim[@mode='OFF']"/>
        </option>
        <option value="KEY">
          <xsl:if test="mode='KEY'">
            <xsl:attribute name="selected">1</xsl:attribute>
          </xsl:if>
          <xsl:value-of select="$strings/dkim[@mode='KEY']"/>
        </option>
        <option value="DELEGATE">
          <xsl:if test="mode='DELEGATE'">
            <xsl:attribute name="selected">1</xsl:attribute>
          </xsl:if>
          <xsl:value-of select="$strings/dkim[@mode='DELEGATE']"/>
        </option>
      </select>
    </div>
    <div class="form-cnt__KEY-DELEGATE-cnt">
      <div class="form-cnt__form-ctl">
        <div class="form-ctl__caption">
          <xsl:value-of select="$strings/dkim[@field='sdid']"/>
        </div>
        <div class="form-ctl__value">
          <input class="form-ctl__value__input" type="text" name="sdid" maxlength="512" value="{sdid}"/>
        </div>
      </div>

      <div class="form-cnt__KEY-cnt">
        <div class="form-cnt__form-ctl">
          <div class="form-ctl__caption">
            <xsl:value-of select="$strings/dkim[@field='selector']"/>
          </div>
          <div class="form-ctl__value">
            <input class="form-ctl__value__input" type="text" name="selector" maxlength="512" value="{selector}"/>
          </div>
        </div>

        <xsl:if test="privkey-installed">
          <div class="form-cnt__form-ctl">
            <div class="form-ctl__notification">
              <xsl:value-of select="$strings/dkim[@field='privkey-installed']"/>
            </div>
            <a class="form-ctl__pubkey" href="pubkey{$uri-ext}">
              <xsl:value-of select="$strings/dkim-get-pubkey"/>
            </a>
          </div>
        </xsl:if>

        <input class="form-cnt__install-privkey-cb" type="checkbox" name="install-privkey-cb"
          id="install-privkey-cb" value="on"/>
        <div class="form-cnt__form-ctl">
          <label class="form-cnt__form-ctl__install-privkey-btn" for="install-privkey-cb">
            <xsl:value-of select="$strings/dkim[@field='install-privkey']"/>
          </label>
        </div>
        <div class="form-cnt__privkey-cnt">
          <div class="form-cnt__form-ctl">
            <div class="form-ctl__caption">
              <xsl:value-of select="$strings/dkim[@field='password']"/>
            </div>
            <div class="form-ctl__value">
              <input class="form-ctl__value__input" type="text" maxlength="255"/>
            </div>
          </div>
          <div class="form-cnt__form-ctl">
            <label>
              <input class="form-ctl__radio-btn" type="radio" name="privkey-source"
                checked="checked" value="GENERATE:1024"/>
              <xsl:value-of select="$strings/dkim[@field='privkey-generate-1024']"/>
            </label>
          </div>
          <div class="form-cnt__form-ctl">
            <label>
              <input class="form-ctl__radio-btn" type="radio" name="privkey-source"
                value="GENERATE:2048"/>
              <xsl:value-of select="$strings/dkim[@field='privkey-generate-2048']"/>
            </label>
          </div>
          <div class="form-cnt__form-ctl">
            <div>
              <input class="form-ctl__radio-btn" type="radio" name="privkey-source"
                value="SET"/>
              <label class="form-ctl__file">
                <input class="file__input-file" type="file" name="file"/>
                <div class="file__cnt">
                  <div class="file__cnt__btn">
                    <xsl:value-of select="$strings/select-file"/>
                  </div>
                  <input class="file__cnt__name" readonly="readonly" tabindex="-1" type="text"/>
                </div>
              </label>
            </div>
          </div>
        </div>
      </div>  <!-- form-cnt__KEY-cnt -->
    </div>  <!-- form-cnt__KEY-DELEGATE-cnt -->

    <div class="form-apply-cnt">
      <input class="form-apply" type="submit" value="{$strings/submit}"/>
    </div>
  </form>

</xsl:template>


<!--
     Domain properties: users
-->

<xsl:template match="property[@name='users']">
  <xsl:apply-templates select="list"/>
</xsl:template>

<xsl:template match="property[@name='users']/list">
  <style>
    &css_part_domain_users-list;
  </style>
  <script>
    &js_part_domain_users;
  </script>
  <div class="check-item-list">
    <input class="check-item-list__new-cb" type="checkbox" id="check-item-list__new-cb"/>
    <form class="check-item-list__row check-item-list__new" id="check-item-list__form-new" method="post">
      <input class="check-item-list__new__input-text" type="text" name="new" value="{new}"
        placeholder="{$strings/placeholder-new-user}"/>
      <input class="check-item-list__new__btn" type="submit" value="{$strings/submit[@name='create']}"/>
      <input id="new__input-template" type="hidden" name="template"/>
    </form>
    <form id="check-item-list" enctype="multipart/form-data" method="post" action="#">
      <xsl:apply-templates select="item"/>
    </form>
  </div>
</xsl:template>

<xsl:template match="property[@name='users']/list/item">
  <div>
    <xsl:attribute name="class">
      <xsl:choose>
        <xsl:when test="@no-edit">check-item-list__row row--no-edit</xsl:when>
        <xsl:otherwise>check-item-list__row</xsl:otherwise>
      </xsl:choose>
    </xsl:attribute>

    <input class="row__cb" type="checkbox" name="del" value="{.}">
      <xsl:if test="@no-edit">
        <xsl:attribute name="disabled">1</xsl:attribute>
      </xsl:if>
    </input>

    <xsl:variable name="caption-class">
      <xsl:choose>
        <xsl:when test="@disabled">row__caption row__caption--disabled</xsl:when>
        <xsl:otherwise>row__caption</xsl:otherwise>
      </xsl:choose>
    </xsl:variable>

    <xsl:choose>
      <xsl:when test="@no-edit">
        <div class="{$caption-class}">
          <xsl:value-of select="."/>
        </div>
      </xsl:when>
      <xsl:otherwise>
        <a class="{$caption-class}" href="user{$uri-ext}?o={mm:encode-uri(.)}">
          <xsl:value-of select="."/>
        </a>
      </xsl:otherwise>
    </xsl:choose>

    <div class="row__info">
      <div>
        <xsl:if test="@used">
          <div><xsl:value-of select="@used"/></div>
        </xsl:if>
        <xsl:if test="@used-pr">
          <div><xsl:value-of select="@used-pr"/>%</div>
        </xsl:if>
      </div>

      <div class="row__info__btn" data-user="{.}">
        <svg class="checkitems-header__E__new__svg"
          xmlns:xlink="http://www.w3.org/1999/xlink" width="16" height="16" viewBox="0 0 16 16">
          <use xlink:href="#new-svg" x="0" y="0"/>
        </svg>
      </div>
    </div>
  </div>
</xsl:template>


<!--
     Domain properties: subst
-->

<xsl:template match="property[@name='subst']">
  <xsl:apply-templates select="list"/>
</xsl:template>

<!-- List of substitutions -->

<xsl:template match="property[@name='subst']/list">
  <style>
    &css_part_domain_subst-list;
  </style>
  <script>
    &js_part_domain_subst;
  </script>
  <div class="check-item-list">
    <input class="check-item-list__new-cb" type="checkbox" id="check-item-list__new-cb"/>
    <form class="check-item-list__row check-item-list__new" id="check-item-list__form-new" method="post">
      <label class="check-item-list__new__private-cnt">
        <input class="row__cb row__cb--private" type="checkbox" name="private" value="on"/>
        <xsl:value-of select="$strings/subst-private"/>
      </label>
      <input class="check-item-list__new__input-text check-item-list__new__input-text--mask" type="text" name="new" value="{new}"
        placeholder="{$strings/placeholder-new-subst}"/>
      <input type="hidden" name="list-id" value=""/>
      <input class="check-item-list__new__btn" type="submit" value="{$strings/submit}"/>
    </form>
    <form class="check-item-list" id="check-item-list" enctype="multipart/form-data" method="post" action="#">
      <xsl:apply-templates select="item"/>
    </form>
  </div>
</xsl:template>

<xsl:template match="property[@name='subst']/list/item">
  <div class="check-item-list__row" data-id="{@list-id}">
    <div class="row__drag-btn"/>
    <input class="row__cb row__cb--subst" type="checkbox" name="del" value="{@list-id}"/>

    <div class="row__private-icon">
      <xsl:choose>
        <xsl:when test="@private">
        </xsl:when>
        <xsl:otherwise>
          &#127760;
        </xsl:otherwise>
      </xsl:choose>
    </div>

    <a class="row__caption" href="subst{$uri-ext}?o={@list-id}" id="subst-{@list-id}">
      <xsl:value-of select="."/>
    </a>
    <div class="row__edit-btn" data-id="{@list-id}" data-private="{@private}"/>
  </div>
</xsl:template>

</xsl:stylesheet>
