<?xml version="1.0" encoding="utf-8"?>
<!DOCTYPE xsl:stylesheet SYSTEM "ui.dtd">
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:mm="http://os2.snc.ru/manjary/xslt">
<xsl:output doctype-system="about:legacy-compat" method="html" indent="no" encoding="utf-8"/>

<!--
      Select language resouse.
-->

<!-- Known languages are listed in the lang.xml file. -->
<xsl:variable name="lang-list" select="document('lang.xml')/list"/>

<!-- Read the root element's "lang" attribute into $lang-requested variable. -->
<xsl:variable name="lang-requested" select="/*/@lang"/>

<!-- Save the value of $lang-requested into the $lang variable if it is in the
     $lang-list, otherwise set it to 'en'. -->
<xsl:variable name="lang">
  <xsl:choose>
    <xsl:when test="$lang-list/item[@name=$lang-requested]">
      <!-- The value of the root element's "lang" attribute was found in the
           lang.xml file. -->
      <xsl:value-of select="$lang-requested"/>
    </xsl:when>
    <xsl:otherwise>
      <!-- Unkown language - use 'en'. -->
      <xsl:text>en</xsl:text>
    </xsl:otherwise>
  </xsl:choose>
</xsl:variable>

<!-- An XML tree for the selected language containing string nodes.
     We can get strings as follows: <xsl:value-of select="$locale/NODE/text()"/>
-->
<xsl:variable name="strings" select="document(concat('locale/',$lang,'.xml'))/locale/strings"/>

<xsl:variable name="uri-ext" select="/*/@uri-ext"/>


<xsl:include href="vcard.xsl"/>
<xsl:include href="logon.xsl"/>
<xsl:include href="part-profile.xsl"/>
<xsl:include href="part-domain.xsl"/>
<xsl:include href="part-user.xsl"/>
<xsl:include href="part-subst.xsl"/>
<xsl:include href="part-spam.xsl"/>
<xsl:include href="part-ab.xsl"/>
<xsl:include href="part-abdomain.xsl"/>
<xsl:include href="part-banip.xsl"/>
<xsl:include href="part-log.xsl"/>

<xsl:template match="/">
  <html lang="{$lang}" style="overscroll-behavior: none;">
    <xsl:apply-templates select="logon"/>
    <xsl:apply-templates select="ui"/>
  </html>
</xsl:template>


<xsl:template match="/ui">
  <head>
    <title>Manjary management</title>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <meta name="viewport" content="width=device-width, user-scalable=no"/>
    <style>
      &css_main;
      <xsl:if test="/ui/part/common/property">
        &css_main_properies-menu;
      </xsl:if>
      <xsl:if test="/ui/part/common/@form-checkitems">
        &css_form_checkitems;
      </xsl:if>
      <xsl:if test="/ui/part/common/@list">
        &css_list;
      </xsl:if>
      <xsl:if test="/ui/notification">
        &css_main_notifications;
      </xsl:if>
    </style>
    <script>
      <xsl:if test="/ui/part/common/@form-checkitems">
        &js_form_checkitems;
      </xsl:if>
      <xsl:if test="/ui/part/common/@search">
        &js_search;
      </xsl:if>
    </script>
  </head>
  <body style="overscroll-behavior: none; position:fixed; top:0; right: 0; left: 0;">

    <div id="menu" class="main-menu">
      <a class="main-menu__back" href="#"></a>
      <a class="main-menu__close-btn" href="#">&#10006;</a>
      <xsl:apply-templates select="common"/>
    </div>

    <div class="main-area">

      <!-- Part header and content -->
      <xsl:apply-templates select="part" mode="common"/>

      <!-- Notifications at the bottom right of the page -->
      <xsl:if test="notification">
        <xsl:if test="notification[@type='warning']">
          <svg style="display: none;" xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 16 16">
            <symbol id="warning-svg">
              <path d="M8.982 1.566a1.13 1.13 0 0 0-1.96 0L.165 13.233c-.457.778.091 1.767.98 1.767h13.713c.889 0 1.438-.99.98-1.767zM8 5c.535 0 .954.462.9.995l-.35 3.507a.552.552 0 0 1-1.1 0L7.1 5.995A.905.905 0 0 1 8 5m.002 6a1 1 0 1 1 0 2 1 1 0 0 1 0-2"/>
            </symbol>
          </svg>
        </xsl:if>
        <xsl:if test="notification[@type='information']">
          <svg style="display: none;" xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 16 16">
            <symbol id="information-svg">
              <path d="M8 16A8 8 0 1 0 8 0a8 8 0 0 0 0 16m.93-9.412-1 4.705c-.07.34.029.533.304.533.194 0 .487-.07.686-.246l-.088.416c-.287.346-.92.598-1.465.598-.703 0-1.002-.422-.808-1.319l.738-3.468c.064-.293.006-.399-.287-.47l-.451-.081.082-.381 2.29-.287zM8 5.5a1 1 0 1 1 0-2 1 1 0 0 1 0 2"/>
            </symbol>
          </svg>
        </xsl:if>
        <input type="checkbox" class="hide-notification" id="hide-notification" checked="checked"/>
        <label class="notification-back" for="hide-notification">
          <xsl:apply-templates select="notification[@msg-id]"/>
          <xsl:apply-templates select="notification[not(@msg-id)]"/>
        </label>
      </xsl:if>

    </div>
  </body>
</xsl:template>


<!--
     Main menu
-->

<xsl:template match="common">
  <xsl:variable name="level" select="user/@level"/>

  <div class="main-menu__header">
    <div class="main-menu__header__username">
      <xsl:value-of select="user"/>
    </div>
    <div class="main-menu__header__userlevel">
      <xsl:value-of select="$strings/user-level[@name=$level]"/>
    </div>
  </div>

  <xsl:apply-templates select="part"/>
  <a class="main-menu__item" href="logon{$uri-ext}?logout=1">
    <xsl:value-of select="$strings/part[@name='logout']"/>
  </a>

</xsl:template>

<xsl:template match="common/part">
  <xsl:variable name="part" select="."/>
  <xsl:variable name="caption" select="$strings/part[@name=$part]"/>

  <xsl:choose>
    <xsl:when test="@current">
      <div class="main-menu__item main-menu__item--current" href="{$part}{$uri-ext}">
        <xsl:value-of select="$caption"/>
      </div>
    </xsl:when>
    <xsl:otherwise>
      <a class="main-menu__item" href="{$part}{$uri-ext}">
        <xsl:value-of select="$caption"/>
      </a>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>


<!--
     Part header and content
-->

<xsl:template match="ui/part" mode="common">
  <!-- Part header and (optionaly) properties menu -->
  <xsl:apply-templates select="common"/>

  <!-- Part content (see part-*.xsl files) -->
  <div class="main-area__content">
    <div class="content__workspace">
      <xsl:apply-templates select="."/>
    </div>
  </div>
</xsl:template>

<xsl:template match="/ui/part/common">
  <xsl:variable name="prop" select="property[@current='1']/text()"/>

  <div class="main-area__header">
    <xsl:choose>
      <xsl:when test="@back-link">
        <a class="header__btn" href="{@back-link}">&#xFF1C;</a>
      </xsl:when>
      <xsl:otherwise>
        <a class="header__btn header__btn--hamburger" href="#menu">&#9776;</a>
      </xsl:otherwise>
    </xsl:choose>

    <xsl:if test="@search">
      <input type="checkbox" class="header__search-cb" id="header__search-cb">
        <xsl:if test="@ss">
          <xsl:attribute name="checked">checked</xsl:attribute>
        </xsl:if>
      </input>
    </xsl:if>

    <div class="header__title">
      <xsl:choose>
        <xsl:when test="title">
          <xsl:value-of select="title"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:variable name="part" select="../@name"/>
          <xsl:value-of select="$strings/part[@name=$part]"/>
        </xsl:otherwise>
      </xsl:choose>

    </div>  <!-- header__title -->
    <xsl:if test="@search">
      <div class="header__search">

        <!-- Magnifying glass icon. Used as a button to open the search form and as a
             small button to submit the form.  -->
        <svg style="display: none;">
          <symbol id="loupe">
            <path d="M416 208c0 45.9-14.9 88.3-40 122.7L502.6 457.4c12.5 12.5 12.5 32.8 0 45.3s-32.8 12.5-45.3 0L330.7 376c-34.4 25.2-76.8 40-122.7 40C93.1 416 0 322.9 0 208S93.1 0 208 0S416 93.1 416 208zM208 352a144 144 0 1 0 0-288 144 144 0 1 0 0 288z"/>
          </symbol>
        </svg>

        <form method="get">
          <select class="search__select" name="st">
            <option value="s">
               <xsl:if test="@st='s'">
                 <xsl:attribute name="selected">1</xsl:attribute>
               </xsl:if>
               ab&#x2026;
            </option>
            <option value="c">
               <xsl:if test="@st='c'">
                 <xsl:attribute name="selected">1</xsl:attribute>
               </xsl:if>
               &#x2026;ab&#x2026;
            </option>
            <option value="e">
               <xsl:if test="@st='e'">
                 <xsl:attribute name="selected">1</xsl:attribute>
               </xsl:if>
               &#x2026;ab
            </option>
          </select>
          <input class="search__text" type="text" name="ss" value="{@ss}">
            <xsl:if test="@ss">
              <xsl:attribute name="autofocus">1</xsl:attribute>
            </xsl:if>
          </input>

          <!-- Submit icon/button: transparent button over the icon. -->
          <svg class="search__submit-svg" xmlns:xlink="http://www.w3.org/1999/xlink"
            viewBox="0 0 512 512">
            <use xlink:href="#loupe" x="0" y="0"/>
          </svg>
          <input class="search__submit" type="submit" value=""/>

          <input type="hidden" name="prop" value="{$prop}"/>
        </form>
      </div>  <!-- header__search -->
    </xsl:if>
    <div class="header__ctrl-buttons">
      <xsl:if test="@search">
        <xsl:choose>
          <xsl:when test="@ss">
            <a class="ctrl-buttons__search-hide" href="?prop={$prop}">&#10006;</a>
          </xsl:when>
          <xsl:otherwise>
            <label for="header__search-cb" tabindex="0">
              <div class="ctrl-buttons__search-show">
                <svg class="header__ctrl-buttons__svg" xmlns:xlink="http://www.w3.org/1999/xlink"
                  viewBox="0 0 512 512">
                  <use xlink:href="#loupe" x="0" y="0"/>
                </svg>
              </div>
              <div class="ctrl-buttons__search-hide">&#10006;</div>
            </label>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:if>
    </div>  <!-- header__ctrl-buttons -->

  </div>  <!-- main-area__header -->

  <!-- Part properties horizontal menu -->
  <xsl:if test="property">
    <div class="main-area__properties">
      <xsl:apply-templates select="property"/>
    </div>
  </xsl:if>

  <!-- Check-item list header: Select All, First/Previous/Next Page buttons,
       New/Delete button.  -->
  <xsl:if test="@form-checkitems">

    <!-- Icon 'New' -->
    <svg style="display: none;" xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" viewBox="0 0 16 16">
      <symbol id="new-svg">
        <path d="M8 6.5a.5.5 0 0 1 .5.5v1.5H10a.5.5 0 0 1 0 1H8.5V11a.5.5 0 0 1-1 0V9.5H6a.5.5 0 0 1 0-1h1.5V7a.5.5 0 0 1 .5-.5"/>
        <path d="M14 4.5V14a2 2 0 0 1-2 2H4a2 2 0 0 1-2-2V2a2 2 0 0 1 2-2h5.5zm-3 0A1.5 1.5 0 0 1 9.5 3V1H4a1 1 0 0 0-1 1v12a1 1 0 0 0 1 1h8a1 1 0 0 0 1-1V4.5z"/>
      </symbol>
    </svg>

    <div id="del" class="del-conf-cnt">
      <a class="del-conf-back" href="#"></a>
      <div class="del-conf">
        <a class="del-conf__close-btn" href="#">&#10006;</a>
        <xsl:value-of select="$strings/del-sel-items-conf"/>
        <input class="del-conf__del-btn" form="check-item-list" type="submit"
          value="{$strings/del-btn}"/>
      </div>
    </div>

    <div>
      <div class="main-area__checkitems-header">
        <div class="checkitems-header__A">
          <input class="checkitems-header__A__select-all-cb" type="checkbox" id="select-all"/>
          <label class="checkitems-header__A__select-all" for="select-all">
            <xsl:value-of select="$strings/check-all"/>
          </label>
        </div>
        <div class="checkitems-header__B">
          <xsl:if test="@p &gt; 1">
            <a class="checkitems-header__page-btn page-btn--first"
               href="?prop={property[@current='1']}&amp;p=0&amp;st={@st}&amp;ss={mm:encode-uri(@ss)}">
            </a>
          </xsl:if>
          <xsl:if test="@p &gt; 0">
            <a class="checkitems-header__page-btn page-btn--prev"
               href="?prop={property[@current='1']}&amp;p={@p - 1}&amp;st={@st}&amp;ss={mm:encode-uri(@ss)}">
            </a>
          </xsl:if>
        </div>
        <div class="checkitems-header__C">
          <xsl:if test="@p and (@p &gt; 0 or @more)">
            <xsl:value-of select="@p + 1"/>
          </xsl:if>
        </div>
        <div class="checkitems-header__D">
          <xsl:if test="@more">
            <a class="checkitems-header__page-btn page-btn--next"
               href="?prop={property[@current='1']}&amp;p={@p+1}&amp;st={@st}&amp;ss={mm:encode-uri(@ss)}">
            </a>
          </xsl:if>
        </div>
        <div class="checkitems-header__E">
          <label class="checkitems-header__E__new" for="check-item-list__new-cb">
            <svg class="checkitems-header__E__new__svg"
              xmlns:xlink="http://www.w3.org/1999/xlink" width="16" height="16" viewBox="0 0 16 16">
              <use xlink:href="#new-svg" x="0" y="0"/>
            </svg>
          </label>

          <div class="checkitems-header__E__del checkitems-header__E__del--hidden">
            <a href="#del">
              <svg class="checkitems-header__E__del__svg" xmlns="http://www.w3.org/2000/svg" fill="currentColor" width="16" height="16" viewBox="0 0 16 16">
                <path d="M11 1.5v1h3.5a.5.5 0 0 1 0 1h-.538l-.853 10.66A2 2 0 0 1 11.115 16h-6.23a2 2 0 0 1-1.994-1.84L2.038 3.5H1.5a.5.5 0 0 1 0-1H5v-1A1.5 1.5 0 0 1 6.5 0h3A1.5 1.5 0 0 1 11 1.5m-5 0v1h4v-1a.5.5 0 0 0-.5-.5h-3a.5.5 0 0 0-.5.5M4.5 5.029l.5 8.5a.5.5 0 1 0 .998-.06l-.5-8.5a.5.5 0 1 0-.998.06m6.53-.528a.5.5 0 0 0-.528.47l-.5 8.5a.5.5 0 0 0 .998.058l.5-8.5a.5.5 0 0 0-.47-.528M8 4.5a.5.5 0 0 0-.5.5v8.5a.5.5 0 0 0 1 0V5a.5.5 0 0 0-.5-.5"/>
              </svg>
            </a>
          </div>
        </div>
      </div>
    </div>
  </xsl:if>

  <!-- Item list header, if more than one page: First/Previous/Next Page buttons -->
  <xsl:if test="@list and @p and (@p &gt; 0 or @more)">
    <div>
      <div class="main-area__list-header">
        <div class="list-header__A">
          <xsl:if test="@p &gt; 1">
            <a class="list-header__page-btn page-btn--first"
               href="?prop={property[@current='1']}&amp;p=0&amp;st={@st}&amp;ss={mm:encode-uri(@ss)}">
            </a>
          </xsl:if>
          <xsl:if test="@p &gt; 0">
            <a class="list-header__page-btn page-btn--prev"
               href="?prop={property[@current='1']}&amp;p={@p - 1}&amp;st={@st}&amp;ss={mm:encode-uri(@ss)}">
            </a>
          </xsl:if>
        </div>
        <div class="list-header__B">
          <xsl:if test="@p and (@p &gt; 0 or @more)">
            <xsl:value-of select="@p + 1"/>
          </xsl:if>
        </div>
        <div class="list-header__C">
          <xsl:if test="@more">
            <a class="list-header__page-btn page-btn--next"
               href="?prop={property[@current='1']}&amp;p={@p+1}&amp;st={@st}&amp;ss={mm:encode-uri(@ss)}">
            </a>
          </xsl:if>
        </div>
      </div>
    </div>
  </xsl:if>
</xsl:template>

<!-- Part property in the horizontal menu -->
<xsl:template match="part/common/property">
  <xsl:variable name="property" select="."/>
  <xsl:variable name="caption" select="$strings/property[@name=$property]"/>

  <xsl:choose>
    <xsl:when test="@current">
      <div class="main-area__properties__item main-area__properties__item--current">
        <xsl:value-of select="$caption"/>
      </div>
    </xsl:when>
    <xsl:otherwise>
      <a class="main-area__properties__item" href="?prop={$property}">
        <xsl:value-of select="$caption"/>
      </a>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>


<!--
     Notifications
-->

<xsl:template match="ui/notification">
  <!-- @msg-id - code to select language-depended text, text() - raw details. -->
  <div class="notification-box notification-box--{@type}">
    <svg class="notification-svg"
      xmlns:xlink="http://www.w3.org/1999/xlink" width="16" height="16" viewBox="0 0 16 16">
      <use xlink:href="#{@type}-svg" x="0" y="0"/>
    </svg>

    <xsl:variable name="msg-id" select="@msg-id"/>

    <xsl:choose>
      <xsl:when test="$msg-id and $strings/notification[@msg-id=$msg-id]">
        <div class="notification-box__msg">
          <xsl:value-of select="$strings/notification[@msg-id=$msg-id]"/>
        </div>
      </xsl:when>
      <xsl:otherwise>
        <div class="notification-box__details">
          <xsl:value-of select="."/>
        </div>
      </xsl:otherwise>
    </xsl:choose>

  </div>
</xsl:template>


<!--
      Utilites
-->

<xsl:template name="timer">
  <xsl:param name="value"/>

  <xsl:if test="$value">
    <xsl:variable name="d" select="floor($value div 86400)"/>
    <xsl:variable name="day-sec" select="$value - ($d * 86400)"/>
    <xsl:variable name="h" select="floor($day-sec div 3600)"/>
    <xsl:variable name="m" select="floor( ($day-sec - ($h * 3600)) div 60)"/>
    <xsl:variable name="s" select="$day-sec - ($h * 3600) - ($m * 60)"/>

    <xsl:choose>
      <xsl:when test="$d &gt; 1">
        <xsl:value-of select="$d"/>
        <xsl:text> </xsl:text>
        <xsl:value-of select="$strings/spam[@name='TTL-days']"/>
        <xsl:text> </xsl:text>
      </xsl:when>
      <xsl:when test="$d = 1">
        <xsl:value-of select="$strings/spam[@name='TTL-one-day']"/>
        <xsl:text> </xsl:text>
      </xsl:when>
    </xsl:choose>

    <xsl:value-of select="format-number($h,'00')"/><xsl:text>:</xsl:text>
    <xsl:value-of select="format-number($m,'00')"/><xsl:text>:</xsl:text>
    <xsl:value-of select="format-number($s,'00')"/>
  </xsl:if>
</xsl:template>

<xsl:template name="date-time">
  <xsl:param name="value"/>

  <xsl:if test="$value">
    <!-- Date -->
  
    <xsl:variable name="date-format" select="document(concat('locale/',$lang,'.xml'))/locale/date"/>
  
    <xsl:variable name="year" select="substring($value,1,4)"/>
    <xsl:variable name="month" select="substring($value,6,2)"/>
    <xsl:variable name="day" select="substring($value,9,2)"/>
  
    <xsl:variable name="date-fmt-1" select="substring($date-format,1,1)"/>
    <xsl:variable name="date-fmt-2" select="substring($date-format,3,1)"/>
    <xsl:variable name="date-fmt-3" select="substring($date-format,5,1)"/>
  
    <xsl:choose>
      <xsl:when test="$date-fmt-1='Y'"><xsl:value-of select="$year"/></xsl:when>
      <xsl:when test="$date-fmt-1='M'"><xsl:value-of select="$month"/></xsl:when>
      <xsl:when test="$date-fmt-1='D'"><xsl:value-of select="$day"/></xsl:when>
    </xsl:choose>
    <xsl:value-of select="substring($date-format,2,1)"/>
    <xsl:choose>
      <xsl:when test="$date-fmt-2='Y'"><xsl:value-of select="$year"/></xsl:when>
      <xsl:when test="$date-fmt-2='M'"><xsl:value-of select="$month"/></xsl:when>
      <xsl:when test="$date-fmt-2='D'"><xsl:value-of select="$day"/></xsl:when>
    </xsl:choose>
    <xsl:value-of select="substring($date-format,4,1)"/>
    <xsl:choose>
      <xsl:when test="$date-fmt-3='Y'"><xsl:value-of select="$year"/></xsl:when>
      <xsl:when test="$date-fmt-3='M'"><xsl:value-of select="$month"/></xsl:when>
      <xsl:when test="$date-fmt-3='D'"><xsl:value-of select="$day"/></xsl:when>
    </xsl:choose>
  
    <xsl:text> </xsl:text>
  
    <!-- Time -->
  
    <xsl:variable name="h" select="substring($value,12,2)"/>
    <xsl:variable name="m" select="substring($value,15,2)"/>
  
    <xsl:choose>
      <xsl:when test="document(concat('locale/',$lang,'.xml'))/locale/time='12'">
  
        <!-- 12-hour format -->
  
        <xsl:choose>
          <xsl:when test="$h = 0">
            <xsl:text>12</xsl:text>
          </xsl:when>
          <xsl:when test="$h &lt; 12">
            <xsl:value-of select="$h"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:value-of select="$h - 12"/>
          </xsl:otherwise>
        </xsl:choose>
        <xsl:text>:</xsl:text>
        <xsl:value-of select="$m"/>
        <xsl:choose>
          <xsl:when test="$h &lt; 12"> AM</xsl:when>
          <xsl:otherwise> PM</xsl:otherwise>
        </xsl:choose>
  
      </xsl:when>
      <xsl:otherwise>
  
        <!-- 24-hour format -->
  
        <xsl:value-of select="$h"/>
        <xsl:text>:</xsl:text>
        <xsl:value-of select="$m"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:if>
</xsl:template>

</xsl:stylesheet>
