IMPLEMENTATION MODULE PMMisc;

        (****************************************************************)
        (*                                                              *)
        (*                  Miscellaneous PM operations                 *)
        (*                                                              *)
        (*        Started:        9 December 2025                       *)
        (*        Last edited:    20 December 2025                      *)
        (*        Status:         OK                                    *)
        (*                                                              *)
        (****************************************************************)


IMPORT OS2;

(********************************************************************************)

PROCEDURE WinAdjustDlgItemSize (hwnd: OS2.HWND;  id: CARDINAL);

    (* Assumption: the dialogue item identified by (hwnd, id) is a single-line  *)
    (* item with a text label, for example a checkbox or radio button.          *)
    (* We adjust the item size so that the current text just fits.  This        *)
    (* procedure will have to be called again if, for example, the font changes.*)

    CONST bufsiz = 256;  extrachars = 2;

    VAR j, N, width, height: CARDINAL;
        hps: OS2.HPS;  w: OS2.HWND;
        str: ARRAY [0..bufsiz-1] OF CHAR;
        points: ARRAY [0..3] OF OS2.POINTL;

    BEGIN
        N := OS2.WinQueryDlgItemText (hwnd, id, bufsiz, str);

        (* Add some extra space characters to boost the size to allow for   *)
        (* a gap after the symbol (checkbox, etc.) in front of the text.    *)

        IF extrachars > 0 THEN
            FOR j := 0 TO extrachars-1 DO
                str[N] := ' ';  INC(N);
            END (*FOR*);
        END (*IF*);

        w := OS2.WinWindowFromID (hwnd, id);
        hps := OS2.WinGetPS (w);
        OS2.GpiQueryTextBox (hps, N, str, 4, points);
        OS2.WinReleasePS (hps);

        (* We add the height to the width below as an estimate for the  *)
        (* size of the symbol (checkbox, etc.) in front of the text.    *)

        height := points[0].y - points[1].y;
        width := points[2].x - points[0].x;
        OS2.WinSetWindowPos (w, 0, 0, 0, width + height, height, OS2.SWP_SIZE);

    END WinAdjustDlgItemSize;

(********************************************************************************)

END PMMisc.

