(**************************************************************************)
(*                                                                        *)
(*  Support modules for network applications                              *)
(*  Copyright (C) 2025   Peter Moylan                                     *)
(*                                                                        *)
(*  This program is free software: you can redistribute it and/or modify  *)
(*  it under the terms of the GNU General Public License as published by  *)
(*  the Free Software Foundation, either version 3 of the License, or     *)
(*  (at your option) any later version.                                   *)
(*                                                                        *)
(*  This program is distributed in the hope that it will be useful,       *)
(*  but WITHOUT ANY WARRANTY; without even the implied warranty of        *)
(*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *)
(*  GNU General Public License for more details.                          *)
(*                                                                        *)
(*  You should have received a copy of the GNU General Public License     *)
(*  along with this program.  If not, see <http://www.gnu.org/licenses/>. *)
(*                                                                        *)
(*  To contact author:   http://www.pmoylan.org   peter@pmoylan.org       *)
(*                                                                        *)
(**************************************************************************)

IMPLEMENTATION MODULE Domains;

        (********************************************************)
        (*                                                      *)
        (*      Domains: a cut-down version for Major Major     *)
        (*                                                      *)
        (*  Programmer:         P. Moylan                       *)
        (*  Started:            23 October 2025                 *)
        (*  Last edited:        25 October 2025                 *)
        (*  Status:             OK                              *)
        (*                                                      *)
        (*  The main operations of Major Major don't need to    *)
        (*  know about domains, so this module is just a        *)
        (*  dummy to satisfy the TLS subsystem.                 *)
        (*                                                      *)
        (********************************************************)


FROM Names IMPORT
    (* type *)  DomainName;

(************************************************************************)

CONST
    Nul = CHR(0);

TYPE
    Domain = POINTER TO DomainData;

    DomainData = RECORD
                     name: DomainName;
                 END (*RECORD*);

(************************************************************************)
(*                RETURNING INFORMATION ABOUT A DOMAIN                  *)
(************************************************************************)

PROCEDURE NameToDomain (VAR (*IN*) name: DomainName): Domain;

    (* Translates a domain name to a domain.  *)

    BEGIN
        RETURN NIL;
    END NameToDomain;

(************************************************************************)

PROCEDURE NameOfDomain (D: Domain;  VAR (*OUT*) name: DomainName);

    (* Returns the name of domain D in name. *)

    BEGIN
        IF D = NIL THEN
            name := "";
        ELSE
            name := D^.name;
        END (*IF*);
    END NameOfDomain;

(************************************************************************)

END Domains.

