/*
 * Decompiled with CFR 0.152.
 */
package jexifviewer;

import java.net.URL;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.table.AbstractTableModel;
import jexifviewer.JExifDataComparator;
import jexifviewer.JIfdData;
import jexifviewer.JMainFrame;
import jexifviewer.Main;
import shared.cvshelper.Cvs;
import shared.table.JTableColSortData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Cvs(header="$Header: /home/reiner/cvs/Java/JExifViewer/src/jexifviewer/JExifDataModel.java,v 1.9 2010/04/02 12:12:13 reiner Exp $")
public final class JExifDataModel
extends AbstractTableModel {
    private ResourceBundle m_resBundle;
    private ArrayList<JIfdData> m_data = new ArrayList();
    public JTableColSortData[] m_sortData;
    public static final int[] m_colTag = new int[]{0, 1, 271, 272, 274, 2, 305, 306, 315, 531, 33432, 33434, 33437, 34850, 34855, 36864, 36867, 36868, 37121, 37122, 37377, 37378, 37379, 37380, 37381, 37383, 37384, 37385, 37386, 40961, 3, 41495, 41985, 41986, 41987, 41988, 41989, 41990, 41991, 41992, 41993, 41994, 41996, 4, 5, 270, 41729, 41728, 65536, 65538, 65540, 65542, 69632};

    public JExifDataModel(ResourceBundle resourceBundle, JTableColSortData[] jTableColSortDataArray) {
        this.m_resBundle = resourceBundle;
        this.m_sortData = jTableColSortDataArray;
    }

    public int getSortCol() {
        return this.m_sortData[0].getSortCol();
    }

    public boolean getSortUp() {
        return this.m_sortData[0].getSortUp();
    }

    private void shiftSortArray() {
        for (int i = this.m_sortData.length - 1; i > 0; --i) {
            this.m_sortData[i].setData(this.m_sortData[i - 1]);
        }
    }

    public void setSortCol(int n) {
        this.shiftSortArray();
        this.m_sortData[0].setSortCol(n);
    }

    public void setSortUp(boolean bl) {
        this.m_sortData[0].setSortUp(bl);
    }

    public Icon getColIcon(int n) {
        ImageIcon imageIcon = null;
        String string = this.getColIconStr(n);
        if (string != null && string.length() > 0) {
            imageIcon = new ImageIcon(string);
        }
        return imageIcon;
    }

    public String getColIconStr(int n) {
        String string = null;
        if (n == this.m_sortData[0].getSortCol()) {
            URL uRL = JMainFrame.class.getResource(this.m_sortData[0].getSortUp() ? "down.gif" : "up.gif");
            string = uRL.toExternalForm();
        }
        return string;
    }

    public void addData(JIfdData jIfdData) {
        this.m_data.add(jIfdData);
        this.fireTableRowsInserted(this.m_data.size() - 1, this.m_data.size() - 1);
    }

    public void addData(ArrayList<JIfdData> arrayList) {
        this.m_data.addAll(arrayList);
        this.fireTableRowsInserted(this.m_data.size() - arrayList.size(), this.m_data.size() - 1);
    }

    public void removeAll() {
        int n = this.m_data.size();
        this.m_data.clear();
        this.fireTableRowsDeleted(0, n);
    }

    public void removeRow(int n) {
        if (n >= 0 && n < this.m_data.size()) {
            this.m_data.remove(n);
            this.fireTableRowsDeleted(n, n);
        }
    }

    @Override
    public int getRowCount() {
        return this.m_data.size();
    }

    @Override
    public int getColumnCount() {
        return m_colTag.length;
    }

    public JIfdData getRowData(int n) {
        return this.m_data.get(n);
    }

    public int findRow(JIfdData jIfdData) {
        int n = 0;
        int n2 = 0;
        for (JIfdData jIfdData2 : this.m_data) {
            if (jIfdData == jIfdData2) {
                return n2;
            }
            ++n2;
        }
        return n;
    }

    public int findRow(String string) {
        int n = -1;
        int n2 = 0;
        for (JIfdData jIfdData : this.m_data) {
            if (jIfdData.getFilePath().equals(string)) {
                return n2;
            }
            ++n2;
        }
        return n;
    }

    public static Object getTagValue(JIfdData jIfdData, int n) {
        Object object = null;
        String[] stringArray = new String[1];
        try {
            switch (n) {
                case 0: {
                    object = jIfdData.getFileName();
                    break;
                }
                case 271: {
                    object = jIfdData.getMake();
                    break;
                }
                case 272: {
                    object = jIfdData.getModel();
                    break;
                }
                case 274: {
                    object = Main.getString(String.format("data_orientation_0x%1$04X", jIfdData.getOrientation()));
                    break;
                }
                case 2: {
                    object = String.format("%1$.1f/%3$s x %2$.1f/%3$s", Float.valueOf(jIfdData.getXResolution()), Float.valueOf(jIfdData.getYResolution()), Main.getString(String.format("data_unit_0x%1$04X", jIfdData.getResolutionUnit())));
                    break;
                }
                case 305: {
                    object = jIfdData.getSoftware();
                    break;
                }
                case 306: {
                    Date date = JIfdData.getDateFromString(jIfdData.getChangeDateTime());
                    if (date != null) {
                        StringBuffer stringBuffer = new StringBuffer();
                        Main.m_shortDayOfWeekFormat.format(date, stringBuffer, new FieldPosition(0));
                        object = stringBuffer + ", " + DateFormat.getDateTimeInstance(3, 3).format(date);
                        break;
                    }
                    object = "";
                    break;
                }
                case 315: {
                    object = jIfdData.getArtist();
                    break;
                }
                case 270: {
                    object = jIfdData.getDescription();
                    break;
                }
                case 531: {
                    object = Main.getString(String.format("data_ycbcrposition_0x%1$04X", jIfdData.getYCbCrPosition()));
                    break;
                }
                case 33432: {
                    object = jIfdData.getCopyright();
                    break;
                }
                case 33434: {
                    jIfdData.getExposureTime(stringArray);
                    object = stringArray[0];
                    break;
                }
                case 33437: {
                    jIfdData.getFNumber(stringArray);
                    object = stringArray[0];
                    break;
                }
                case 34850: {
                    try {
                        object = Main.getString(String.format("data_exposureprogram_0x%1$04X", jIfdData.getExposureProgram()));
                    }
                    catch (MissingResourceException missingResourceException) {
                        object = Main.getString("data_exposureprogram_reserved");
                    }
                    break;
                }
                case 34855: {
                    object = jIfdData.getISOSpeedRatings();
                    break;
                }
                case 36864: {
                    object = jIfdData.getExifVersion();
                    break;
                }
                case 36867: {
                    Date date = JIfdData.getDateFromString(jIfdData.getOriginalDateTime());
                    if (date != null) {
                        StringBuffer stringBuffer = new StringBuffer();
                        Main.m_shortDayOfWeekFormat.format(date, stringBuffer, new FieldPosition(0));
                        object = stringBuffer + ", " + DateFormat.getDateTimeInstance(3, 3).format(date);
                        break;
                    }
                    object = "";
                    break;
                }
                case 36868: {
                    Date date = JIfdData.getDateFromString(jIfdData.getDigitizedDateTime());
                    if (date != null) {
                        StringBuffer stringBuffer = new StringBuffer();
                        Main.m_shortDayOfWeekFormat.format(date, stringBuffer, new FieldPosition(0));
                        object = stringBuffer + ", " + DateFormat.getDateTimeInstance(3, 3).format(date);
                        break;
                    }
                    object = "";
                    break;
                }
                case 37121: {
                    object = jIfdData.getComponentsConfig();
                    break;
                }
                case 37122: {
                    object = Float.valueOf(jIfdData.getCompressedBitsPerPixel());
                    break;
                }
                case 37377: {
                    object = Float.valueOf(jIfdData.getShuterSpeedValue());
                    break;
                }
                case 37378: {
                    object = Float.valueOf(jIfdData.getApertureValue());
                    break;
                }
                case 37379: {
                    object = Float.valueOf(jIfdData.getBrightnessValue());
                    break;
                }
                case 37380: {
                    object = Float.valueOf(jIfdData.getExposureBiasValue());
                    break;
                }
                case 37381: {
                    object = Float.valueOf(jIfdData.getMaxApertureValue());
                    break;
                }
                case 37383: {
                    try {
                        object = Main.getString(String.format("data_meteringmode_0x%1$04X", jIfdData.getMeteringMode()));
                    }
                    catch (MissingResourceException missingResourceException) {
                        object = Main.getString("data_meteringmode_reserved");
                    }
                    break;
                }
                case 37384: {
                    try {
                        object = Main.getString(String.format("data_lightsource_0x%1$04X", jIfdData.getLightSource()));
                    }
                    catch (MissingResourceException missingResourceException) {
                        object = Main.getString("data_lightsource_reserved");
                    }
                    break;
                }
                case 37385: {
                    int n2 = jIfdData.getFlash();
                    if ((n2 & 1) != 0) {
                        stringArray[0] = Main.getString(String.format("data_flash_yes", new Object[0]));
                        if ((n2 & 6) >> 1 == 2) {
                            stringArray[0] = stringArray[0] + ", " + Main.getString("data_flash_strobereturnnotdetected");
                        } else if ((n2 & 6) >> 1 == 3) {
                            stringArray[0] = stringArray[0] + ", " + Main.getString("data_flash_strobereturndetected");
                        }
                        if ((n2 & 0x18) >> 3 == 0) {
                            stringArray[0] = stringArray[0] + ", " + Main.getString("data_flash_modeunknown");
                        } else if ((n2 & 0x18) >> 3 == 1) {
                            stringArray[0] = stringArray[0] + ", " + Main.getString("data_flash_modecompulsory");
                        } else if ((n2 & 0x18) >> 3 == 3) {
                            stringArray[0] = stringArray[0] + ", " + Main.getString("data_flash_modeauto");
                        }
                        if ((n2 & 0x40) != 0) {
                            stringArray[0] = stringArray[0] + ", " + Main.getString("data_flash_moderedeyereduction");
                        }
                    } else if ((n2 & 0x20) != 0) {
                        stringArray[0] = Main.getString(String.format("data_flash_notavailable", new Object[0]));
                    } else {
                        stringArray[0] = Main.getString(String.format("data_flash_no", new Object[0]));
                        if ((n2 & 0x18) >> 3 == 1) {
                            stringArray[0] = stringArray[0] + ", " + Main.getString("data_flash_modecompulsorysuppression");
                        }
                    }
                    object = stringArray[0];
                    break;
                }
                case 37386: {
                    object = Float.valueOf(jIfdData.getFocalLength());
                    break;
                }
                case 40961: {
                    object = Main.getString(String.format("data_colorspace_0x%1$04X", jIfdData.getColorSpace()));
                    break;
                }
                case 1: {
                    object = String.format("%1$dx%2$d", jIfdData.getPixelXDimension(), jIfdData.getPixelYDimension());
                    break;
                }
                case 3: {
                    object = String.format("%1$.1f/%3$s x %2$.1f/%3$s", Float.valueOf(jIfdData.getFocalPlaneXResolution()), Float.valueOf(jIfdData.getFocalPlaneYResolution()), Main.getString(String.format("data_unit_0x%1$04X", jIfdData.getFocalPlaneResolutionUnit())));
                    break;
                }
                case 41495: {
                    object = Main.getString(String.format("data_sensingmode_0x%1$04X", jIfdData.getSensingMode()));
                    break;
                }
                case 41985: {
                    object = Main.getString(String.format("data_customrendered_0x%1$04X", jIfdData.getCustomRendered()));
                    break;
                }
                case 41986: {
                    object = Main.getString(String.format("data_exposuremode_0x%1$04X", jIfdData.getExposureMode()));
                    break;
                }
                case 41987: {
                    object = Main.getString(String.format("data_whitebalance_0x%1$04X", jIfdData.getWhiteBalance()));
                    break;
                }
                case 41988: {
                    object = Float.valueOf(jIfdData.getDigitalZoomRatio());
                    break;
                }
                case 41989: {
                    object = jIfdData.getFocalLength35mm();
                    break;
                }
                case 41990: {
                    object = Main.getString(String.format("data_scenecapturetype_0x%1$04X", jIfdData.getSceneCaptureType()));
                    break;
                }
                case 41729: {
                    object = Main.getString(String.format("data_scenetype_0x%1$04X", jIfdData.getSceneType()));
                    break;
                }
                case 41991: {
                    object = Main.getString(String.format("data_gaincontrol_0x%1$04X", jIfdData.getGainControl()));
                    break;
                }
                case 41992: {
                    object = Main.getString(String.format("data_contrast_0x%1$04X", jIfdData.getContrast()));
                    break;
                }
                case 41993: {
                    object = Main.getString(String.format("data_saturation_0x%1$04X", jIfdData.getSaturation()));
                    break;
                }
                case 41994: {
                    object = Main.getString(String.format("data_sharpness_0x%1$04X", jIfdData.getSharpness()));
                    break;
                }
                case 41996: {
                    object = Main.getString(String.format("data_subjectdistancerange_0x%1$04X", jIfdData.getSubjectDistanceRange()));
                    break;
                }
                case 4: {
                    StringBuilder stringBuilder = new StringBuilder();
                    if (jIfdData.getFileSize() < 1024L) {
                        stringBuilder.append(Long.toString(jIfdData.getFileSize()));
                    } else if (jIfdData.getFileSize() < 0x100000L) {
                        stringBuilder.append(String.format("%1$.1f ", Float.valueOf((float)jIfdData.getFileSize() / 1024.0f)));
                        stringBuilder.append(Main.getString("KByte"));
                    } else if (jIfdData.getFileSize() < 0x40000000L) {
                        stringBuilder.append(String.format("%1$.2f ", Float.valueOf((float)jIfdData.getFileSize() / 1048576.0f)));
                        stringBuilder.append(Main.getString("MByte"));
                    }
                    object = stringBuilder.toString();
                    break;
                }
                case 5: {
                    Date date = jIfdData.getFileDate();
                    if (date != null) {
                        StringBuffer stringBuffer = new StringBuffer();
                        Main.m_shortDayOfWeekFormat.format(date, stringBuffer, new FieldPosition(0));
                        object = stringBuffer + ", " + DateFormat.getDateTimeInstance(3, 3).format(date);
                        break;
                    }
                    object = "";
                    break;
                }
                case 41728: {
                    object = Main.getString(String.format("data_filesource_0x%1$04X", jIfdData.getFileSource()));
                    break;
                }
                case 65536: {
                    object = jIfdData.getGPSVersionID();
                    break;
                }
                case 65538: {
                    object = String.format("%.6f\u00b0 %s", Float.valueOf(jIfdData.getGPSLatitude()), Main.getString(String.format("data_gps_latituderef_%s", jIfdData.getGPSLatitudeRef())));
                    break;
                }
                case 65540: {
                    object = String.format("%.6f\u00b0 %s", Float.valueOf(jIfdData.getGPSLongitude()), Main.getString(String.format("data_gps_longituderef_%s", jIfdData.getGPSLongitudeRef())));
                    break;
                }
                case 65542: {
                    int n3 = jIfdData.getGPSAltitudeRef();
                    if (n3 < 0) {
                        throw new MissingResourceException(null, null, null);
                    }
                    n3 = n3 != 0 ? -1 : 1;
                    float f = jIfdData.getGPSAltitude();
                    if (Float.isNaN(f)) {
                        throw new MissingResourceException(null, null, null);
                    }
                    object = String.format("%.1f m", Float.valueOf((float)n3 * f), Main.getString("data_gps_altitude_unit"));
                    break;
                }
                case 65543: {
                    StringBuffer stringBuffer = new StringBuffer();
                    Date date = jIfdData.getGPSTimestamp();
                    if (date != null) {
                        Main.m_shortDayOfWeekFormat.format(date, stringBuffer, new FieldPosition(0));
                        object = stringBuffer + ", " + DateFormat.getDateTimeInstance(3, 3).format(date);
                    } else {
                        object = null;
                    }
                }
                case 65544: {
                    object = jIfdData.getGPSSatellites();
                    break;
                }
                case 65545: {
                    object = Main.getString(String.format("data_gps_status_%s", jIfdData.getGPSStatus()));
                    break;
                }
                case 65546: {
                    object = jIfdData.getGPSMeasureMode();
                    break;
                }
                case 69632: {
                    object = jIfdData.isTagPresent(69632) ? String.format(Main.getString("data_gps_maplink"), Main.m_url_map.toString()) : new String("");
                }
            }
        }
        catch (MissingResourceException missingResourceException) {
            object = Main.getString("data_unknown");
        }
        return object;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        assert (n2 >= 0 && n2 < m_colTag.length);
        JIfdData jIfdData = this.m_data.get(n);
        Object object = JExifDataModel.getTagValue(jIfdData, m_colTag[n2]);
        return object;
    }

    @Override
    public String getColumnName(int n) {
        String string = null;
        assert (n >= 0 && n < m_colTag.length);
        if (n >= 0 && n < m_colTag.length) {
            string = this.m_resBundle.getString(String.format("colheader_tag_0x%1$04X", m_colTag[n]));
        }
        return string;
    }

    public void sort() {
        Collections.sort(this.m_data, new JExifDataComparator(this.m_sortData));
        this.fireTableDataChanged();
    }
}

